<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## cache

Gets or, when options are provided, sets the limits of _libvips'_ operation cache.
Existing entries in the cache will be trimmed after any change in limits.
This method always returns cache statistics,
useful for determining how much working memory is required for a particular task.

### Parameters

-   `options` **([Object][1] \| [Boolean][2])** Object with the following attributes, or Boolean where true uses default cache settings and false removes all caching (optional, default `true`)
    -   `options.memory` **[Number][3]** is the maximum memory in MB to use for this cache (optional, default `50`)
    -   `options.files` **[Number][3]** is the maximum number of files to hold open (optional, default `20`)
    -   `options.items` **[Number][3]** is the maximum number of operations to cache (optional, default `100`)

### Examples

```javascript
const stats = sharp.cache();
```

```javascript
sharp.cache( { items: 200 } );
sharp.cache( { files: 0 } );
sharp.cache(false);
```

Returns **[Object][1]** 

## concurrency

Gets or, when a concurrency is provided, sets
the number of threads _libvips'_ should create to process each image.
The default value is the number of CPU cores.
A value of `0` will reset to this default.

The maximum number of images that can be processed in parallel
is limited by libuv's `UV_THREADPOOL_SIZE` environment variable.

This method always returns the current concurrency.

### Parameters

-   `concurrency` **[Number][3]?** 

### Examples

```javascript
const threads = sharp.concurrency(); // 4
sharp.concurrency(2); // 2
sharp.concurrency(0); // 4
```

Returns **[Number][3]** concurrency

## counters

Provides access to internal task counters.

-   queue is the number of tasks this module has queued waiting for _libuv_ to provide a worker thread from its pool.
-   process is the number of resize tasks currently being processed.

### Examples

```javascript
const counters = sharp.counters(); // { queue: 2, process: 4 }
```

Returns **[Object][1]** 

## simd

Get and set use of SIMD vector unit instructions.
Requires libvips to have been compiled with liborc support.

Improves the performance of `resize`, `blur` and `sharpen` operations
by taking advantage of the SIMD vector unit of the CPU, e.g. Intel SSE and ARM NEON.

### Parameters

-   `simd` **[Boolean][2]**  (optional, default `true`)

### Examples

```javascript
const simd = sharp.simd();
// simd is `true` if the runtime use of liborc is currently enabled
```

```javascript
const simd = sharp.simd(false);
// prevent libvips from using liborc at runtime
```

Returns **[Boolean][2]** 

[1]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number
