<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## resize

Resize image to `width`, `height` or `width x height`.

When both a `width` and `height` are provided, the possible methods by which the image should **fit** these are:

-   `cover`: Crop to cover both provided dimensions (the default).
-   `contain`: Embed within both provided dimensions.
-   `fill`: Ignore the aspect ratio of the input and stretch to both provided dimensions.
-   `inside`: Preserving aspect ratio, resize the image to be as large as possible while ensuring its dimensions are less than or equal to both those specified.
-   `outside`: Preserving aspect ratio, resize the image to be as small as possible while ensuring its dimensions are greater than or equal to both those specified.
    Some of these values are based on the [object-fit][1] CSS property.

When using a `fit` of `cover` or `contain`, the default **position** is `centre`. Other options are:

-   `sharp.position`: `top`, `right top`, `right`, `right bottom`, `bottom`, `left bottom`, `left`, `left top`.
-   `sharp.gravity`: `north`, `northeast`, `east`, `southeast`, `south`, `southwest`, `west`, `northwest`, `center` or `centre`.
-   `sharp.strategy`: `cover` only, dynamically crop using either the `entropy` or `attention` strategy.
    Some of these values are based on the [object-position][2] CSS property.

The experimental strategy-based approach resizes so one dimension is at its target length
then repeatedly ranks edge regions, discarding the edge with the lowest score based on the selected strategy.

-   `entropy`: focus on the region with the highest [Shannon entropy][3].
-   `attention`: focus on the region with the highest luminance frequency, colour saturation and presence of skin tones.

Possible interpolation kernels are:

-   `nearest`: Use [nearest neighbour interpolation][4].
-   `cubic`: Use a [Catmull-Rom spline][5].
-   `mitchell`: Use a [Mitchell-Netravali spline][6].
-   `lanczos2`: Use a [Lanczos kernel][7] with `a=2`.
-   `lanczos3`: Use a Lanczos kernel with `a=3` (the default).

### Parameters

-   `width` **[Number][8]?** pixels wide the resultant image should be. Use `null` or `undefined` to auto-scale the width to match the height.
-   `height` **[Number][8]?** pixels high the resultant image should be. Use `null` or `undefined` to auto-scale the height to match the width.
-   `options` **[Object][9]?** 
    -   `options.width` **[String][10]?** alternative means of specifying `width`. If both are present this take priority.
    -   `options.height` **[String][10]?** alternative means of specifying `height`. If both are present this take priority.
    -   `options.fit` **[String][10]** how the image should be resized to fit both provided dimensions, one of `cover`, `contain`, `fill`, `inside` or `outside`. (optional, default `'cover'`)
    -   `options.position` **[String][10]** position, gravity or strategy to use when `fit` is `cover` or `contain`. (optional, default `'centre'`)
    -   `options.background` **([String][10] \| [Object][9])** background colour when using a `fit` of `contain`, parsed by the [color][11] module, defaults to black without transparency. (optional, default `{r:0,g:0,b:0,alpha:1}`)
    -   `options.kernel` **[String][10]** the kernel to use for image reduction. (optional, default `'lanczos3'`)
    -   `options.withoutEnlargement` **[Boolean][12]** do not enlarge if the width _or_ height are already less than the specified dimensions, equivalent to GraphicsMagick's `>` geometry option. (optional, default `false`)
    -   `options.fastShrinkOnLoad` **[Boolean][12]** take greater advantage of the JPEG and WebP shrink-on-load feature, which can lead to a slight moiré pattern on some images. (optional, default `true`)

### Examples

```javascript
sharp(input)
  .resize({ width: 100 })
  .toBuffer()
  .then(data => {
    // 100 pixels wide, auto-scaled height
  });
```

```javascript
sharp(input)
  .resize({ height: 100 })
  .toBuffer()
  .then(data => {
    // 100 pixels high, auto-scaled width
  });
```

```javascript
sharp(input)
  .resize(200, 300, {
    kernel: sharp.kernel.nearest,
    fit: 'contain',
    position: 'right top',
    background: { r: 255, g: 255, b: 255, alpha: 0.5 }
  })
  .toFile('output.png')
  .then(() => {
    // output.png is a 200 pixels wide and 300 pixels high image
    // containing a nearest-neighbour scaled version
    // contained within the north-east corner of a semi-transparent white canvas
  });
```

```javascript
const transformer = sharp()
  .resize({
    width: 200,
    height: 200,
    fit: sharp.fit.cover,
    position: sharp.strategy.entropy
  });
// Read image data from readableStream
// Write 200px square auto-cropped image data to writableStream
readableStream
  .pipe(transformer)
  .pipe(writableStream);
```

```javascript
sharp(input)
  .resize(200, 200, {
    fit: sharp.fit.inside,
    withoutEnlargement: true
  })
  .toFormat('jpeg')
  .toBuffer()
  .then(function(outputBuffer) {
    // outputBuffer contains JPEG image data
    // no wider and no higher than 200 pixels
    // and no larger than the input image
  });
```

-   Throws **[Error][13]** Invalid parameters

Returns **Sharp** 

## extend

Extends/pads the edges of the image with the provided background colour.
This operation will always occur after resizing and extraction, if any.

### Parameters

-   `extend` **([Number][8] \| [Object][9])** single pixel count to add to all edges or an Object with per-edge counts
    -   `extend.top` **[Number][8]?** 
    -   `extend.left` **[Number][8]?** 
    -   `extend.bottom` **[Number][8]?** 
    -   `extend.right` **[Number][8]?** 
    -   `extend.background` **([String][10] \| [Object][9])** background colour, parsed by the [color][11] module, defaults to black without transparency. (optional, default `{r:0,g:0,b:0,alpha:1}`)

### Examples

```javascript
// Resize to 140 pixels wide, then add 10 transparent pixels
// to the top, left and right edges and 20 to the bottom edge
sharp(input)
  .resize(140)
  .extend({
    top: 10,
    bottom: 20,
    left: 10,
    right: 10,
    background: { r: 0, g: 0, b: 0, alpha: 0 }
  })
  ...
```

-   Throws **[Error][13]** Invalid parameters

Returns **Sharp** 

## extract

Extract a region of the image.

-   Use `extract` before `resize` for pre-resize extraction.
-   Use `extract` after `resize` for post-resize extraction.
-   Use `extract` before and after for both.

### Parameters

-   `options` **[Object][9]** describes the region to extract using integral pixel values
    -   `options.left` **[Number][8]** zero-indexed offset from left edge
    -   `options.top` **[Number][8]** zero-indexed offset from top edge
    -   `options.width` **[Number][8]** width of region to extract
    -   `options.height` **[Number][8]** height of region to extract

### Examples

```javascript
sharp(input)
  .extract({ left: left, top: top, width: width, height: height })
  .toFile(output, function(err) {
    // Extract a region of the input image, saving in the same format.
  });
```

```javascript
sharp(input)
  .extract({ left: leftOffsetPre, top: topOffsetPre, width: widthPre, height: heightPre })
  .resize(width, height)
  .extract({ left: leftOffsetPost, top: topOffsetPost, width: widthPost, height: heightPost })
  .toFile(output, function(err) {
    // Extract a region, resize, then extract from the resized image
  });
```

-   Throws **[Error][13]** Invalid parameters

Returns **Sharp** 

## trim

Trim "boring" pixels from all edges that contain values similar to the top-left pixel.
The `info` response Object will contain `trimOffsetLeft` and `trimOffsetTop` properties.

### Parameters

-   `threshold` **[Number][8]** the allowed difference from the top-left pixel, a number greater than zero. (optional, default `10`)


-   Throws **[Error][13]** Invalid parameters

Returns **Sharp** 

[1]: https://developer.mozilla.org/en-US/docs/Web/CSS/object-fit

[2]: https://developer.mozilla.org/en-US/docs/Web/CSS/object-position

[3]: https://en.wikipedia.org/wiki/Entropy_%28information_theory%29

[4]: http://en.wikipedia.org/wiki/Nearest-neighbor_interpolation

[5]: https://en.wikipedia.org/wiki/Centripetal_Catmull%E2%80%93Rom_spline

[6]: https://www.cs.utexas.edu/~fussell/courses/cs384g-fall2013/lectures/mitchell/Mitchell.pdf

[7]: https://en.wikipedia.org/wiki/Lanczos_resampling#Lanczos_kernel

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[10]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[11]: https://www.npmjs.org/package/color

[12]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[13]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error
