<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## clone

Take a "snapshot" of the Sharp instance, returning a new instance.
Cloned instances inherit the input of their parent instance.
This allows multiple output Streams and therefore multiple processing pipelines to share a single input Stream.

### Examples

```javascript
const pipeline = sharp().rotate();
pipeline.clone().resize(800, 600).pipe(firstWritableStream);
pipeline.clone().extract({ left: 20, top: 20, width: 100, height: 100 }).pipe(secondWritableStream);
readableStream.pipe(pipeline);
// firstWritableStream receives auto-rotated, resized readableStream
// secondWritableStream receives auto-rotated, extracted region of readableStream
```

Returns **Sharp** 

## metadata

Fast access to (uncached) image metadata without decoding any compressed image data.
A `Promise` is returned when `callback` is not provided.

-   `format`: Name of decoder used to decompress image data e.g. `jpeg`, `png`, `webp`, `gif`, `svg`
-   `size`: Total size of image in bytes, for Stream and Buffer input only
-   `width`: Number of pixels wide (EXIF orientation is not taken into consideration)
-   `height`: Number of pixels high (EXIF orientation is not taken into consideration)
-   `space`: Name of colour space interpretation e.g. `srgb`, `rgb`, `cmyk`, `lab`, `b-w` [...][1]
-   `channels`: Number of bands e.g. `3` for sRGB, `4` for CMYK
-   `depth`: Name of pixel depth format e.g. `uchar`, `char`, `ushort`, `float` [...][2]
-   `density`: Number of pixels per inch (DPI), if present
-   `chromaSubsampling`: String containing JPEG chroma subsampling, `4:2:0` or `4:4:4` for RGB, `4:2:0:4` or `4:4:4:4` for CMYK
-   `isProgressive`: Boolean indicating whether the image is interlaced using a progressive scan
-   `pages`: Number of pages/frames contained within the image, with support for TIFF, HEIF, PDF, animated GIF and animated WebP
-   `pageHeight`: Number of pixels high each page in this PDF image will be.
-   `pagePrimary`: Number of the primary page in a HEIF image
-   `hasProfile`: Boolean indicating the presence of an embedded ICC profile
-   `hasAlpha`: Boolean indicating the presence of an alpha transparency channel
-   `orientation`: Number value of the EXIF Orientation header, if present
-   `exif`: Buffer containing raw EXIF data, if present
-   `icc`: Buffer containing raw [ICC][3] profile data, if present
-   `iptc`: Buffer containing raw IPTC data, if present
-   `xmp`: Buffer containing raw XMP data, if present

### Parameters

-   `callback` **[Function][4]?** called with the arguments `(err, metadata)`

### Examples

```javascript
const image = sharp(inputJpg);
image
  .metadata()
  .then(function(metadata) {
    return image
      .resize(Math.round(metadata.width / 2))
      .webp()
      .toBuffer();
  })
  .then(function(data) {
    // data contains a WebP image half the width and height of the original JPEG
  });
```

Returns **([Promise][5]&lt;[Object][6]> | Sharp)** 

## stats

Access to pixel-derived image statistics for every channel in the image.
A `Promise` is returned when `callback` is not provided.

-   `channels`: Array of channel statistics for each channel in the image. Each channel statistic contains
    -   `min` (minimum value in the channel)
    -   `max` (maximum value in the channel)
    -   `sum` (sum of all values in a channel)
    -   `squaresSum` (sum of squared values in a channel)
    -   `mean` (mean of the values in a channel)
    -   `stdev` (standard deviation for the values in a channel)
    -   `minX` (x-coordinate of one of the pixel where the minimum lies)
    -   `minY` (y-coordinate of one of the pixel where the minimum lies)
    -   `maxX` (x-coordinate of one of the pixel where the maximum lies)
    -   `maxY` (y-coordinate of one of the pixel where the maximum lies)
-   `isOpaque`: Value to identify if the image is opaque or transparent, based on the presence and use of alpha channel
-   `entropy`: Histogram-based estimation of greyscale entropy, discarding alpha channel if any (experimental)

### Parameters

-   `callback` **[Function][4]?** called with the arguments `(err, stats)`

### Examples

```javascript
const image = sharp(inputJpg);
image
  .stats()
  .then(function(stats) {
     // stats contains the channel-wise statistics array and the isOpaque value
  });
```

Returns **[Promise][5]&lt;[Object][6]>** 

## limitInputPixels

Do not process input images where the number of pixels (width x height) exceeds this limit.
Assumes image dimensions contained in the input metadata can be trusted.
The default limit is 268402689 (0x3FFF x 0x3FFF) pixels.

### Parameters

-   `limit` **([Number][7] \| [Boolean][8])** an integral Number of pixels, zero or false to remove limit, true to use default limit.


-   Throws **[Error][9]** Invalid limit

Returns **Sharp** 

## sequentialRead

An advanced setting that switches the libvips access method to `VIPS_ACCESS_SEQUENTIAL`.
This will reduce memory usage and can improve performance on some systems.

The default behaviour _before_ function call is `false`, meaning the libvips access method is not sequential.

### Parameters

-   `sequentialRead` **[Boolean][8]**  (optional, default `true`)

Returns **Sharp** 

[1]: https://github.com/libvips/libvips/blob/master/libvips/iofuncs/enumtypes.c#L636

[2]: https://github.com/libvips/libvips/blob/master/libvips/iofuncs/enumtypes.c#L672

[3]: https://www.npmjs.com/package/icc

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error
