<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## Sharp

### Parameters

-   `input` **([Buffer][1] \| [String][2])?** if present, can be
     a Buffer containing JPEG, PNG, WebP, GIF, SVG, TIFF or raw pixel image data, or
     a String containing the path to an JPEG, PNG, WebP, GIF, SVG or TIFF image file.
     JPEG, PNG, WebP, GIF, SVG, TIFF or raw pixel image data can be streamed into the object when not present.
-   `options` **[Object][3]?** if present, is an Object with optional attributes.
    -   `options.failOnError` **[Boolean][4]** by default halt processing and raise an error when loading invalid images.
         Set this flag to `false` if you'd rather apply a "best effort" to decode images, even if the data is corrupt or invalid. (optional, default `true`)
    -   `options.density` **[Number][5]** number representing the DPI for vector images. (optional, default `72`)
    -   `options.pages` **[Number][5]** number of pages to extract for multi-page input (GIF, TIFF, PDF), use -1 for all pages. (optional, default `1`)
    -   `options.page` **[Number][5]** page number to start extracting from for multi-page input (GIF, TIFF, PDF), zero based. (optional, default `0`)
    -   `options.raw` **[Object][3]?** describes raw pixel input image data. See `raw()` for pixel ordering.
        -   `options.raw.width` **[Number][5]?** 
        -   `options.raw.height` **[Number][5]?** 
        -   `options.raw.channels` **[Number][5]?** 1-4
    -   `options.create` **[Object][3]?** describes a new image to be created.
        -   `options.create.width` **[Number][5]?** 
        -   `options.create.height` **[Number][5]?** 
        -   `options.create.channels` **[Number][5]?** 3-4
        -   `options.create.background` **([String][2] \| [Object][3])?** parsed by the [color][6] module to extract values for red, green, blue and alpha.

### Examples

```javascript
sharp('input.jpg')
  .resize(300, 200)
  .toFile('output.jpg', function(err) {
    // output.jpg is a 300 pixels wide and 200 pixels high image
    // containing a scaled and cropped version of input.jpg
  });
```

```javascript
// Read image data from readableStream,
// resize to 300 pixels wide,
// emit an 'info' event with calculated dimensions
// and finally write image data to writableStream
var transformer = sharp()
  .resize(300)
  .on('info', function(info) {
    console.log('Image height is ' + info.height);
  });
readableStream.pipe(transformer).pipe(writableStream);
```

```javascript
// Create a blank 300x200 PNG image of semi-transluent red pixels
sharp({
  create: {
    width: 300,
    height: 200,
    channels: 4,
    background: { r: 255, g: 0, b: 0, alpha: 0.5 }
  }
})
.png()
.toBuffer()
.then( ... );
```

-   Throws **[Error][7]** Invalid parameters

Returns **[Sharp][8]** 

### format

An Object containing nested boolean values representing the available input and output formats/methods.

#### Examples

```javascript
console.log(sharp.format);
```

Returns **[Object][3]** 

### versions

An Object containing the version numbers of libvips and its dependencies.

#### Examples

```javascript
console.log(sharp.versions);
```

## queue

An EventEmitter that emits a `change` event when a task is either:

-   queued, waiting for _libuv_ to provide a worker thread
-   complete

### Examples

```javascript
sharp.queue.on('change', function(queueLength) {
  console.log('Queue contains ' + queueLength + ' task(s)');
});
```

[1]: https://nodejs.org/api/buffer.html

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[6]: https://www.npmjs.org/package/color

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error

[8]: #sharp
