<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## composite

Composite image(s) over the processed (resized, extracted etc.) image.

The images to composite must be the same size or smaller than the processed image.
If both `top` and `left` options are provided, they take precedence over `gravity`.

The `blend` option can be one of `clear`, `source`, `over`, `in`, `out`, `atop`,
`dest`, `dest-over`, `dest-in`, `dest-out`, `dest-atop`,
`xor`, `add`, `saturate`, `multiply`, `screen`, `overlay`, `darken`, `lighten`,
`colour-dodge`, `color-dodge`, `colour-burn`,`color-burn`,
`hard-light`, `soft-light`, `difference`, `exclusion`.

More information about blend modes can be found at
[https://libvips.github.io/libvips/API/current/libvips-conversion.html#VipsBlendMode][1]
and [https://www.cairographics.org/operators/][2]

### Parameters

-   `images` **[Array][3]&lt;[Object][4]>** Ordered list of images to composite
    -   `images[].input` **([Buffer][5] \| [String][6])?** Buffer containing image data, String containing the path to an image file, or Create object (see bellow)
        -   `images[].input.create` **[Object][4]?** describes a blank overlay to be created.
            -   `images[].input.create.width` **[Number][7]?** 
            -   `images[].input.create.height` **[Number][7]?** 
            -   `images[].input.create.channels` **[Number][7]?** 3-4
            -   `images[].input.create.background` **([String][6] \| [Object][4])?** parsed by the [color][8] module to extract values for red, green, blue and alpha.
    -   `images[].blend` **[String][6]** how to blend this image with the image below. (optional, default `'over'`)
    -   `images[].gravity` **[String][6]** gravity at which to place the overlay. (optional, default `'centre'`)
    -   `images[].top` **[Number][7]?** the pixel offset from the top edge.
    -   `images[].left` **[Number][7]?** the pixel offset from the left edge.
    -   `images[].tile` **[Boolean][9]** set to true to repeat the overlay image across the entire image with the given `gravity`. (optional, default `false`)
    -   `images[].density` **[Number][7]** number representing the DPI for vector overlay image. (optional, default `72`)
    -   `images[].raw` **[Object][4]?** describes overlay when using raw pixel data.
        -   `images[].raw.width` **[Number][7]?** 
        -   `images[].raw.height` **[Number][7]?** 
        -   `images[].raw.channels` **[Number][7]?** 

### Examples

```javascript
sharp('input.png')
  .rotate(180)
  .resize(300)
  .flatten( { background: '#ff6600' } )
  .composite([{ input: 'overlay.png', gravity: 'southeast' }])
  .sharpen()
  .withMetadata()
  .webp( { quality: 90 } )
  .toBuffer()
  .then(function(outputBuffer) {
    // outputBuffer contains upside down, 300px wide, alpha channel flattened
    // onto orange background, composited with overlay.png with SE gravity,
    // sharpened, with metadata, 90% quality WebP image data. Phew!
  });
```

-   Throws **[Error][10]** Invalid parameters

Returns **Sharp** 

[1]: https://libvips.github.io/libvips/API/current/libvips-conversion.html#VipsBlendMode

[2]: https://www.cairographics.org/operators/

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[5]: https://nodejs.org/api/buffer.html

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[8]: https://www.npmjs.org/package/color

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[10]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error
