<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## removeAlpha

Remove alpha channel, if any. This is a no-op if the image does not have an alpha channel.

### Examples

```javascript
sharp('rgba.png')
  .removeAlpha()
  .toFile('rgb.png', function(err, info) {
    // rgb.png is a 3 channel image without an alpha channel
  });
```

Returns **Sharp** 

## ensureAlpha

Ensure alpha channel, if missing. The added alpha channel will be fully opaque. This is a no-op if the image already has an alpha channel.

### Examples

```javascript
sharp('rgb.jpg')
  .ensureAlpha()
  .toFile('rgba.png', function(err, info) {
    // rgba.png is a 4 channel image with a fully opaque alpha channel
  });
```

Returns **Sharp** 

## extractChannel

Extract a single channel from a multi-channel image.

### Parameters

-   `channel` **([Number][1] \| [String][2])** zero-indexed band number to extract, or `red`, `green` or `blue` as alternative to `0`, `1` or `2` respectively.

### Examples

```javascript
sharp(input)
  .extractChannel('green')
  .toFile('input_green.jpg', function(err, info) {
    // info.channels === 1
    // input_green.jpg contains the green channel of the input image
   });
```

-   Throws **[Error][3]** Invalid channel

Returns **Sharp** 

## joinChannel

Join one or more channels to the image.
The meaning of the added channels depends on the output colourspace, set with `toColourspace()`.
By default the output image will be web-friendly sRGB, with additional channels interpreted as alpha channels.
Channel ordering follows vips convention:

-   sRGB: 0: Red, 1: Green, 2: Blue, 3: Alpha.
-   CMYK: 0: Magenta, 1: Cyan, 2: Yellow, 3: Black, 4: Alpha.

Buffers may be any of the image formats supported by sharp: JPEG, PNG, WebP, GIF, SVG, TIFF or raw pixel image data.
For raw pixel input, the `options` object should contain a `raw` attribute, which follows the format of the attribute of the same name in the `sharp()` constructor.

### Parameters

-   `images` **([Array][4]&lt;([String][2] \| [Buffer][5])> | [String][2] \| [Buffer][5])** one or more images (file paths, Buffers).
-   `options` **[Object][6]** image options, see `sharp()` constructor.


-   Throws **[Error][3]** Invalid parameters

Returns **Sharp** 

## bandbool

Perform a bitwise boolean operation on all input image channels (bands) to produce a single channel output image.

### Parameters

-   `boolOp` **[String][2]** one of `and`, `or` or `eor` to perform that bitwise operation, like the C logic operators `&`, `|` and `^` respectively.

### Examples

```javascript
sharp('3-channel-rgb-input.png')
  .bandbool(sharp.bool.and)
  .toFile('1-channel-output.png', function (err, info) {
    // The output will be a single channel image where each pixel `P = R & G & B`.
    // If `I(1,1) = [247, 170, 14] = [0b11110111, 0b10101010, 0b00001111]`
    // then `O(1,1) = 0b11110111 & 0b10101010 & 0b00001111 = 0b00000010 = 2`.
  });
```

-   Throws **[Error][3]** Invalid parameters

Returns **Sharp** 

[1]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[5]: https://nodejs.org/api/buffer.html

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object
