
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/external/cannon/cannon.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

// Mon, 04 Nov 2019 05:14:37 GMT

/*
 * Copyright (c) 2015 cannon.js Authors
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
!function (e) {
  if ("object" == typeof exports && "undefined" != typeof module) module.exports = e();else if ("function" == typeof define && define.amd) define([], e);else {
    var f;
    "undefined" != typeof window ? f = window : "undefined" != typeof global ? f = global : "undefined" != typeof self && (f = self), f.CANNON = e();
  }
}(function () {
  var define, module, exports;
  return function e(t, n, r) {
    function s(o, u) {
      if (!n[o]) {
        if (!t[o]) {
          var a = typeof require == "function" && require;
          if (!u && a) return a(o, !0);
          if (i) return i(o, !0);
          throw new Error("Cannot find module '" + o + "'");
        }

        var f = n[o] = {
          exports: {}
        };
        t[o][0].call(f.exports, function (e) {
          var n = t[o][1][e];
          return s(n ? n : e);
        }, f, f.exports, e, t, n, r);
      }

      return n[o].exports;
    }

    var i = typeof require == "function" && require;

    for (var o = 0; o < r.length; o++) {
      s(r[o]);
    }

    return s;
  }({
    1: [function (_dereq_, module, exports) {
      module.exports = {
        "name": "@cocos/cannon",
        "version": "1.0.3",
        "description": "A lightweight 3D physics engine written in JavaScript.",
        "homepage": "https://github.com/cocos-creator/cannon.js",
        "author": "Stefan Hedman <schteppe@gmail.com> (http://steffe.se), JayceLai",
        "keywords": ["cannon", "cocos", "creator", "physics", "engine", "3d"],
        "scripts": {
          "build": "grunt && npm run preprocess && grunt addLicense && grunt addDate",
          "preprocess": "node node_modules/uglify-js/bin/uglifyjs build/cannon.js -o build/cannon.min.js -d doProfiling=false,DEBUG=false -c -m"
        },
        "main": "./build/cannon.min.js",
        "engines": {
          "node": "*"
        },
        "repository": {
          "type": "git",
          "url": "https://github.com/cocos-creator/cannon.js.git"
        },
        "bugs": {
          "url": "https://github.com/cocos-creator/cannon.js/issues"
        },
        "licenses": [{
          "type": "MIT"
        }],
        "devDependencies": {
          "jshint": "latest",
          "uglify-js": "latest",
          "nodeunit": "^0.9.0",
          "grunt": "~0.4.0",
          "grunt-contrib-jshint": "~0.1.1",
          "grunt-contrib-nodeunit": "^0.4.1",
          "grunt-contrib-concat": "~0.1.3",
          "grunt-contrib-uglify": "^0.5.1",
          "grunt-browserify": "^2.1.4",
          "grunt-contrib-yuidoc": "^0.5.2",
          "browserify": "*"
        },
        "dependencies": {}
      };
    }, {}],
    2: [function (_dereq_, module, exports) {
      // Export classes
      module.exports = {
        version: _dereq_('../package.json').version,
        AABB: _dereq_('./collision/AABB'),
        ArrayCollisionMatrix: _dereq_('./collision/ArrayCollisionMatrix'),
        Body: _dereq_('./objects/Body'),
        Box: _dereq_('./shapes/Box'),
        Broadphase: _dereq_('./collision/Broadphase'),
        Constraint: _dereq_('./constraints/Constraint'),
        ContactEquation: _dereq_('./equations/ContactEquation'),
        Narrowphase: _dereq_('./world/Narrowphase'),
        ConeTwistConstraint: _dereq_('./constraints/ConeTwistConstraint'),
        ContactMaterial: _dereq_('./material/ContactMaterial'),
        ConvexPolyhedron: _dereq_('./shapes/ConvexPolyhedron'),
        Cylinder: _dereq_('./shapes/Cylinder'),
        DistanceConstraint: _dereq_('./constraints/DistanceConstraint'),
        Equation: _dereq_('./equations/Equation'),
        EventTarget: _dereq_('./utils/EventTarget'),
        FrictionEquation: _dereq_('./equations/FrictionEquation'),
        GSSolver: _dereq_('./solver/GSSolver'),
        GridBroadphase: _dereq_('./collision/GridBroadphase'),
        Heightfield: _dereq_('./shapes/Heightfield'),
        HingeConstraint: _dereq_('./constraints/HingeConstraint'),
        LockConstraint: _dereq_('./constraints/LockConstraint'),
        Mat3: _dereq_('./math/Mat3'),
        Material: _dereq_('./material/Material'),
        NaiveBroadphase: _dereq_('./collision/NaiveBroadphase'),
        ObjectCollisionMatrix: _dereq_('./collision/ObjectCollisionMatrix'),
        Pool: _dereq_('./utils/Pool'),
        Particle: _dereq_('./shapes/Particle'),
        Plane: _dereq_('./shapes/Plane'),
        PointToPointConstraint: _dereq_('./constraints/PointToPointConstraint'),
        Quaternion: _dereq_('./math/Quaternion'),
        Ray: _dereq_('./collision/Ray'),
        RaycastVehicle: _dereq_('./objects/RaycastVehicle'),
        RaycastResult: _dereq_('./collision/RaycastResult'),
        RigidVehicle: _dereq_('./objects/RigidVehicle'),
        RotationalEquation: _dereq_('./equations/RotationalEquation'),
        RotationalMotorEquation: _dereq_('./equations/RotationalMotorEquation'),
        SAPBroadphase: _dereq_('./collision/SAPBroadphase'),
        SPHSystem: _dereq_('./objects/SPHSystem'),
        Shape: _dereq_('./shapes/Shape'),
        Solver: _dereq_('./solver/Solver'),
        Sphere: _dereq_('./shapes/Sphere'),
        SplitSolver: _dereq_('./solver/SplitSolver'),
        Spring: _dereq_('./objects/Spring'),
        Transform: _dereq_('./math/Transform'),
        Trimesh: _dereq_('./shapes/Trimesh'),
        Vec3: _dereq_('./math/Vec3'),
        Vec3Pool: _dereq_('./utils/Vec3Pool'),
        World: _dereq_('./world/World')
      };
    }, {
      "../package.json": 1,
      "./collision/AABB": 3,
      "./collision/ArrayCollisionMatrix": 4,
      "./collision/Broadphase": 5,
      "./collision/GridBroadphase": 6,
      "./collision/NaiveBroadphase": 7,
      "./collision/ObjectCollisionMatrix": 8,
      "./collision/Ray": 10,
      "./collision/RaycastResult": 11,
      "./collision/SAPBroadphase": 12,
      "./constraints/ConeTwistConstraint": 13,
      "./constraints/Constraint": 14,
      "./constraints/DistanceConstraint": 15,
      "./constraints/HingeConstraint": 16,
      "./constraints/LockConstraint": 17,
      "./constraints/PointToPointConstraint": 18,
      "./equations/ContactEquation": 20,
      "./equations/Equation": 21,
      "./equations/FrictionEquation": 22,
      "./equations/RotationalEquation": 23,
      "./equations/RotationalMotorEquation": 24,
      "./material/ContactMaterial": 25,
      "./material/Material": 26,
      "./math/Mat3": 28,
      "./math/Quaternion": 29,
      "./math/Transform": 30,
      "./math/Vec3": 31,
      "./objects/Body": 32,
      "./objects/RaycastVehicle": 33,
      "./objects/RigidVehicle": 34,
      "./objects/SPHSystem": 35,
      "./objects/Spring": 36,
      "./shapes/Box": 38,
      "./shapes/ConvexPolyhedron": 39,
      "./shapes/Cylinder": 40,
      "./shapes/Heightfield": 41,
      "./shapes/Particle": 42,
      "./shapes/Plane": 43,
      "./shapes/Shape": 44,
      "./shapes/Sphere": 45,
      "./shapes/Trimesh": 46,
      "./solver/GSSolver": 47,
      "./solver/Solver": 48,
      "./solver/SplitSolver": 49,
      "./utils/EventTarget": 50,
      "./utils/Pool": 52,
      "./utils/Vec3Pool": 55,
      "./world/Narrowphase": 56,
      "./world/World": 57
    }],
    3: [function (_dereq_, module, exports) {
      var Vec3 = _dereq_('../math/Vec3');

      var Utils = _dereq_('../utils/Utils');

      module.exports = AABB;
      /**
       * Axis aligned bounding box class.
       * @class AABB
       * @constructor
       * @param {Object} [options]
       * @param {Vec3}   [options.upperBound]
       * @param {Vec3}   [options.lowerBound]
       */

      function AABB(options) {
        options = options || {};
        /**
         * The lower bound of the bounding box.
         * @property lowerBound
         * @type {Vec3}
         */

        this.lowerBound = new Vec3();

        if (options.lowerBound) {
          this.lowerBound.copy(options.lowerBound);
        }
        /**
         * The upper bound of the bounding box.
         * @property upperBound
         * @type {Vec3}
         */


        this.upperBound = new Vec3();

        if (options.upperBound) {
          this.upperBound.copy(options.upperBound);
        }
      }

      var tmp = new Vec3();
      /**
       * Set the AABB bounds from a set of points.
       * @method setFromPoints
       * @param {Array} points An array of Vec3's.
       * @param {Vec3} position
       * @param {Quaternion} quaternion
       * @param {number} skinSize
       * @return {AABB} The self object
       */

      AABB.prototype.setFromPoints = function (points, position, quaternion, skinSize) {
        var l = this.lowerBound,
            u = this.upperBound,
            q = quaternion; // Set to the first point

        l.copy(points[0]);

        if (q) {
          q.vmult(l, l);
        }

        u.copy(l);

        for (var i = 1; i < points.length; i++) {
          var p = points[i];

          if (q) {
            q.vmult(p, tmp);
            p = tmp;
          }

          if (p.x > u.x) {
            u.x = p.x;
          }

          if (p.x < l.x) {
            l.x = p.x;
          }

          if (p.y > u.y) {
            u.y = p.y;
          }

          if (p.y < l.y) {
            l.y = p.y;
          }

          if (p.z > u.z) {
            u.z = p.z;
          }

          if (p.z < l.z) {
            l.z = p.z;
          }
        } // Add offset


        if (position) {
          position.vadd(l, l);
          position.vadd(u, u);
        }

        if (skinSize) {
          l.x -= skinSize;
          l.y -= skinSize;
          l.z -= skinSize;
          u.x += skinSize;
          u.y += skinSize;
          u.z += skinSize;
        }

        return this;
      };
      /**
       * Copy bounds from an AABB to this AABB
       * @method copy
       * @param  {AABB} aabb Source to copy from
       * @return {AABB} The this object, for chainability
       */


      AABB.prototype.copy = function (aabb) {
        this.lowerBound.copy(aabb.lowerBound);
        this.upperBound.copy(aabb.upperBound);
        return this;
      };
      /**
       * Clone an AABB
       * @method clone
       */


      AABB.prototype.clone = function () {
        return new AABB().copy(this);
      };
      /**
       * Extend this AABB so that it covers the given AABB too.
       * @method extend
       * @param  {AABB} aabb
       */


      AABB.prototype.extend = function (aabb) {
        this.lowerBound.x = Math.min(this.lowerBound.x, aabb.lowerBound.x);
        this.upperBound.x = Math.max(this.upperBound.x, aabb.upperBound.x);
        this.lowerBound.y = Math.min(this.lowerBound.y, aabb.lowerBound.y);
        this.upperBound.y = Math.max(this.upperBound.y, aabb.upperBound.y);
        this.lowerBound.z = Math.min(this.lowerBound.z, aabb.lowerBound.z);
        this.upperBound.z = Math.max(this.upperBound.z, aabb.upperBound.z);
      };
      /**
       * Returns true if the given AABB overlaps this AABB.
       * @method overlaps
       * @param  {AABB} aabb
       * @return {Boolean}
       */


      AABB.prototype.overlaps = function (aabb) {
        var l1 = this.lowerBound,
            u1 = this.upperBound,
            l2 = aabb.lowerBound,
            u2 = aabb.upperBound; //      l2        u2
        //      |---------|
        // |--------|
        // l1       u1
        // no consider contain case
        // let overlapsX = ((l2.x <= u1.x && u1.x <= u2.x) || (l1.x <= u2.x && u2.x <= u1.x));
        // let overlapsY = ((l2.y <= u1.y && u1.y <= u2.y) || (l1.y <= u2.y && u2.y <= u1.y));
        // let overlapsZ = ((l2.z <= u1.z && u1.z <= u2.z) || (l1.z <= u2.z && u2.z <= u1.z));
        // overlaps must consider contain case
        // or ray cast may miss

        var overlapsX = l2.x <= u1.x && l1.x <= u2.x;
        var overlapsY = l2.y <= u1.y && l1.y <= u2.y;
        var overlapsZ = l2.z <= u1.z && l1.z <= u2.z;
        return overlapsX && overlapsY && overlapsZ;
      }; // Mostly for debugging


      AABB.prototype.volume = function () {
        var l = this.lowerBound,
            u = this.upperBound;
        return (u.x - l.x) * (u.y - l.y) * (u.z - l.z);
      };
      /**
       * Returns true if the given AABB is fully contained in this AABB.
       * @method contains
       * @param {AABB} aabb
       * @return {Boolean}
       */


      AABB.prototype.contains = function (aabb) {
        var l1 = this.lowerBound,
            u1 = this.upperBound,
            l2 = aabb.lowerBound,
            u2 = aabb.upperBound; //      l2        u2
        //      |---------|
        // |---------------|
        // l1              u1

        return l1.x <= l2.x && u1.x >= u2.x && l1.y <= l2.y && u1.y >= u2.y && l1.z <= l2.z && u1.z >= u2.z;
      };
      /**
       * @method getCorners
       * @param {Vec3} a
       * @param {Vec3} b
       * @param {Vec3} c
       * @param {Vec3} d
       * @param {Vec3} e
       * @param {Vec3} f
       * @param {Vec3} g
       * @param {Vec3} h
       */


      AABB.prototype.getCorners = function (a, b, c, d, e, f, g, h) {
        var l = this.lowerBound,
            u = this.upperBound;
        a.copy(l);
        b.set(u.x, l.y, l.z);
        c.set(u.x, u.y, l.z);
        d.set(l.x, u.y, u.z);
        e.set(u.x, l.y, u.z);
        f.set(l.x, u.y, l.z);
        g.set(l.x, l.y, u.z);
        h.copy(u);
      };

      var transformIntoFrame_corners = [new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3()];
      /**
       * Get the representation of an AABB in another frame.
       * @method toLocalFrame
       * @param  {Transform} frame
       * @param  {AABB} target
       * @return {AABB} The "target" AABB object.
       */

      AABB.prototype.toLocalFrame = function (frame, target) {
        var corners = transformIntoFrame_corners;
        var a = corners[0];
        var b = corners[1];
        var c = corners[2];
        var d = corners[3];
        var e = corners[4];
        var f = corners[5];
        var g = corners[6];
        var h = corners[7]; // Get corners in current frame

        this.getCorners(a, b, c, d, e, f, g, h); // Transform them to new local frame

        for (var i = 0; i !== 8; i++) {
          var corner = corners[i];
          frame.pointToLocal(corner, corner);
        }

        return target.setFromPoints(corners);
      };
      /**
       * Get the representation of an AABB in the global frame.
       * @method toWorldFrame
       * @param  {Transform} frame
       * @param  {AABB} target
       * @return {AABB} The "target" AABB object.
       */


      AABB.prototype.toWorldFrame = function (frame, target) {
        var corners = transformIntoFrame_corners;
        var a = corners[0];
        var b = corners[1];
        var c = corners[2];
        var d = corners[3];
        var e = corners[4];
        var f = corners[5];
        var g = corners[6];
        var h = corners[7]; // Get corners in current frame

        this.getCorners(a, b, c, d, e, f, g, h); // Transform them to new local frame

        for (var i = 0; i !== 8; i++) {
          var corner = corners[i];
          frame.pointToWorld(corner, corner);
        }

        return target.setFromPoints(corners);
      };
      /**
       * Check if the AABB is hit by a ray.
       * @param  {Ray} ray
       * @return {number}
       */


      AABB.prototype.overlapsRay = function (ray) {
        var t = 0; // ray.direction is unit direction vector of ray

        var dirFracX = 1 / ray._direction.x;
        var dirFracY = 1 / ray._direction.y;
        var dirFracZ = 1 / ray._direction.z; // this.lowerBound is the corner of AABB with minimal coordinates - left bottom, rt is maximal corner

        var t1 = (this.lowerBound.x - ray.from.x) * dirFracX;
        var t2 = (this.upperBound.x - ray.from.x) * dirFracX;
        var t3 = (this.lowerBound.y - ray.from.y) * dirFracY;
        var t4 = (this.upperBound.y - ray.from.y) * dirFracY;
        var t5 = (this.lowerBound.z - ray.from.z) * dirFracZ;
        var t6 = (this.upperBound.z - ray.from.z) * dirFracZ; // var tmin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)));
        // var tmax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)));

        var tmin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)), Math.min(t5, t6));
        var tmax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)), Math.max(t5, t6)); // if tmax < 0, ray (line) is intersecting AABB, but whole AABB is behing us

        if (tmax < 0) {
          //t = tmax;
          return false;
        } // if tmin > tmax, ray doesn't intersect AABB


        if (tmin > tmax) {
          //t = tmax;
          return false;
        }

        return true;
      };
    }, {
      "../math/Vec3": 31,
      "../utils/Utils": 54
    }],
    4: [function (_dereq_, module, exports) {
      module.exports = ArrayCollisionMatrix;
      /**
       * Collision "matrix". It's actually a triangular-shaped array of whether two bodies are touching this step, for reference next step
       * @class ArrayCollisionMatrix
       * @constructor
       */

      function ArrayCollisionMatrix() {
        /**
         * The matrix storage
         * @property matrix
         * @type {Array}
         */
        this.matrix = [];
      }
      /**
       * Get an element
       * @method get
       * @param  {Number} i
       * @param  {Number} j
       * @return {Number}
       */


      ArrayCollisionMatrix.prototype.get = function (i, j) {
        i = i.index;
        j = j.index;

        if (j > i) {
          var temp = j;
          j = i;
          i = temp;
        }

        return this.matrix[(i * (i + 1) >> 1) + j - 1];
      };
      /**
       * Set an element
       * @method set
       * @param {Number} i
       * @param {Number} j
       * @param {Number} value
       */


      ArrayCollisionMatrix.prototype.set = function (i, j, value) {
        i = i.index;
        j = j.index;

        if (j > i) {
          var temp = j;
          j = i;
          i = temp;
        }

        this.matrix[(i * (i + 1) >> 1) + j - 1] = value ? 1 : 0;
      };
      /**
       * Sets all elements to zero
       * @method reset
       */


      ArrayCollisionMatrix.prototype.reset = function () {
        for (var i = 0, l = this.matrix.length; i !== l; i++) {
          this.matrix[i] = 0;
        }
      };
      /**
       * Sets the max number of objects
       * @method setNumObjects
       * @param {Number} n
       */


      ArrayCollisionMatrix.prototype.setNumObjects = function (n) {
        this.matrix.length = n * (n - 1) >> 1;
      };
    }, {}],
    5: [function (_dereq_, module, exports) {
      var Body = _dereq_('../objects/Body');

      var Vec3 = _dereq_('../math/Vec3');

      var Quaternion = _dereq_('../math/Quaternion');

      var Shape = _dereq_('../shapes/Shape');

      var Plane = _dereq_('../shapes/Plane');

      module.exports = Broadphase;
      /**
       * Base class for broadphase implementations
       * @class Broadphase
       * @constructor
       * @author schteppe
       */

      function Broadphase() {
        /**
        * The world to search for collisions in.
        * @property world
        * @type {World}
        */
        this.world = null;
        /**
         * If set to true, the broadphase uses bounding boxes for intersection test, else it uses bounding spheres.
         * @property useBoundingBoxes
         * @type {Boolean}
         */

        this.useBoundingBoxes = false;
        /**
         * Set to true if the objects in the world moved.
         * @property {Boolean} dirty
         */

        this.dirty = true;
      }
      /**
       * Get the collision pairs from the world
       * @method collisionPairs
       * @param {World} world The world to search in
       * @param {Array} p1 Empty array to be filled with body objects
       * @param {Array} p2 Empty array to be filled with body objects
       */


      Broadphase.prototype.collisionPairs = function (world, p1, p2) {
        throw new Error("collisionPairs not implemented for this BroadPhase class!");
      };
      /**
       * Check if a body pair needs to be intersection tested at all.
       * @method needBroadphaseCollision
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @return {bool}
       */


      Broadphase.prototype.needBroadphaseCollision = function (bodyA, bodyB) {
        // Check collision filter masks
        if ((bodyA.collisionFilterGroup & bodyB.collisionFilterMask) === 0 || (bodyB.collisionFilterGroup & bodyA.collisionFilterMask) === 0) {
          return false;
        } // Check has trigger


        if (bodyA.hasTrigger || bodyB.hasTrigger) {
          return true;
        } // Check types


        if (((bodyA.type & Body.STATIC) !== 0 || bodyA.sleepState === Body.SLEEPING) && ((bodyB.type & Body.STATIC) !== 0 || bodyB.sleepState === Body.SLEEPING)) {
          // Both bodies are static or sleeping. Skip.
          return false;
        }

        return true;
      };
      /**
       * Check if the bounding volumes of two bodies intersect.
       * @method intersectionTest
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {array} pairs1
       * @param {array} pairs2
        */


      Broadphase.prototype.intersectionTest = function (bodyA, bodyB, pairs1, pairs2) {
        if (this.useBoundingBoxes) {
          this.doBoundingBoxBroadphase(bodyA, bodyB, pairs1, pairs2);
        } else {
          this.doBoundingSphereBroadphase(bodyA, bodyB, pairs1, pairs2);
        }
      };
      /**
       * Check if the bounding spheres of two bodies are intersecting.
       * @method doBoundingSphereBroadphase
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {Array} pairs1 bodyA is appended to this array if intersection
       * @param {Array} pairs2 bodyB is appended to this array if intersection
       */


      var Broadphase_collisionPairs_r = new Vec3(),
          // Temp objects
      Broadphase_collisionPairs_normal = new Vec3(),
          Broadphase_collisionPairs_quat = new Quaternion(),
          Broadphase_collisionPairs_relpos = new Vec3();

      Broadphase.prototype.doBoundingSphereBroadphase = function (bodyA, bodyB, pairs1, pairs2) {
        var r = Broadphase_collisionPairs_r;
        bodyB.position.vsub(bodyA.position, r);
        var boundingRadiusSum2 = Math.pow(bodyA.boundingRadius + bodyB.boundingRadius, 2);
        var norm2 = r.norm2();

        if (norm2 < boundingRadiusSum2) {
          pairs1.push(bodyA);
          pairs2.push(bodyB);
        }
      };
      /**
       * Check if the bounding boxes of two bodies are intersecting.
       * @method doBoundingBoxBroadphase
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {Array} pairs1
       * @param {Array} pairs2
       */


      Broadphase.prototype.doBoundingBoxBroadphase = function (bodyA, bodyB, pairs1, pairs2) {
        if (bodyA.aabbNeedsUpdate) {
          bodyA.computeAABB();
        }

        if (bodyB.aabbNeedsUpdate) {
          bodyB.computeAABB();
        } // Check AABB / AABB


        if (bodyA.aabb.overlaps(bodyB.aabb)) {
          pairs1.push(bodyA);
          pairs2.push(bodyB);
        }
      };
      /**
       * Removes duplicate pairs from the pair arrays.
       * @method makePairsUnique
       * @param {Array} pairs1
       * @param {Array} pairs2
       */


      var Broadphase_makePairsUnique_temp = {
        keys: []
      },
          Broadphase_makePairsUnique_p1 = [],
          Broadphase_makePairsUnique_p2 = [];

      Broadphase.prototype.makePairsUnique = function (pairs1, pairs2) {
        var t = Broadphase_makePairsUnique_temp,
            p1 = Broadphase_makePairsUnique_p1,
            p2 = Broadphase_makePairsUnique_p2,
            N = pairs1.length;

        for (var i = 0; i !== N; i++) {
          p1[i] = pairs1[i];
          p2[i] = pairs2[i];
        }

        pairs1.length = 0;
        pairs2.length = 0;

        for (var i = 0; i !== N; i++) {
          var id1 = p1[i].id,
              id2 = p2[i].id;
          var key = id1 < id2 ? id1 + "," + id2 : id2 + "," + id1;
          t[key] = i;
          t.keys.push(key);
        }

        for (var i = 0; i !== t.keys.length; i++) {
          var key = t.keys.pop(),
              pairIndex = t[key];
          pairs1.push(p1[pairIndex]);
          pairs2.push(p2[pairIndex]);
          delete t[key];
        }
      };
      /**
       * To be implemented by subcasses
       * @method setWorld
       * @param {World} world
       */


      Broadphase.prototype.setWorld = function (world) {};
      /**
       * Check if the bounding spheres of two bodies overlap.
       * @method boundingSphereCheck
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @return {boolean}
       */


      var bsc_dist = new Vec3();

      Broadphase.boundingSphereCheck = function (bodyA, bodyB) {
        var dist = bsc_dist;
        bodyA.position.vsub(bodyB.position, dist);
        return Math.pow(bodyA.shape.boundingSphereRadius + bodyB.shape.boundingSphereRadius, 2) > dist.norm2();
      };
      /**
       * Returns all the bodies within the AABB.
       * @method aabbQuery
       * @param  {World} world
       * @param  {AABB} aabb
       * @param  {array} result An array to store resulting bodies in.
       * @return {array}
       */


      Broadphase.prototype.aabbQuery = function (world, aabb, result) {
        console.warn('.aabbQuery is not implemented in this Broadphase subclass.');
        return [];
      };
    }, {
      "../math/Quaternion": 29,
      "../math/Vec3": 31,
      "../objects/Body": 32,
      "../shapes/Plane": 43,
      "../shapes/Shape": 44
    }],
    6: [function (_dereq_, module, exports) {
      module.exports = GridBroadphase;

      var Broadphase = _dereq_('./Broadphase');

      var Vec3 = _dereq_('../math/Vec3');

      var Shape = _dereq_('../shapes/Shape');
      /**
       * Axis aligned uniform grid broadphase.
       * @class GridBroadphase
       * @constructor
       * @extends Broadphase
       * @todo Needs support for more than just planes and spheres.
       * @param {Vec3} aabbMin
       * @param {Vec3} aabbMax
       * @param {Number} nx Number of boxes along x
       * @param {Number} ny Number of boxes along y
       * @param {Number} nz Number of boxes along z
       */


      function GridBroadphase(aabbMin, aabbMax, nx, ny, nz) {
        Broadphase.apply(this);
        this.nx = nx || 10;
        this.ny = ny || 10;
        this.nz = nz || 10;
        this.aabbMin = aabbMin || new Vec3(100, 100, 100);
        this.aabbMax = aabbMax || new Vec3(-100, -100, -100);
        var nbins = this.nx * this.ny * this.nz;

        if (nbins <= 0) {
          throw "GridBroadphase: Each dimension's n must be >0";
        }

        this.bins = [];
        this.binLengths = []; //Rather than continually resizing arrays (thrashing the memory), just record length and allow them to grow

        this.bins.length = nbins;
        this.binLengths.length = nbins;

        for (var i = 0; i < nbins; i++) {
          this.bins[i] = [];
          this.binLengths[i] = 0;
        }
      }

      GridBroadphase.prototype = new Broadphase();
      GridBroadphase.prototype.constructor = GridBroadphase;
      /**
       * Get all the collision pairs in the physics world
       * @method collisionPairs
       * @param {World} world
       * @param {Array} pairs1
       * @param {Array} pairs2
       */

      var GridBroadphase_collisionPairs_d = new Vec3();
      var GridBroadphase_collisionPairs_binPos = new Vec3();

      GridBroadphase.prototype.collisionPairs = function (world, pairs1, pairs2) {
        var N = world.numObjects(),
            bodies = world.bodies;
        var max = this.aabbMax,
            min = this.aabbMin,
            nx = this.nx,
            ny = this.ny,
            nz = this.nz;
        var xstep = ny * nz;
        var ystep = nz;
        var zstep = 1;
        var xmax = max.x,
            ymax = max.y,
            zmax = max.z,
            xmin = min.x,
            ymin = min.y,
            zmin = min.z;
        var xmult = nx / (xmax - xmin),
            ymult = ny / (ymax - ymin),
            zmult = nz / (zmax - zmin);
        var binsizeX = (xmax - xmin) / nx,
            binsizeY = (ymax - ymin) / ny,
            binsizeZ = (zmax - zmin) / nz;
        var binRadius = Math.sqrt(binsizeX * binsizeX + binsizeY * binsizeY + binsizeZ * binsizeZ) * 0.5;
        var types = Shape.types;
        var SPHERE = types.SPHERE,
            PLANE = types.PLANE,
            BOX = types.BOX,
            COMPOUND = types.COMPOUND,
            CONVEXPOLYHEDRON = types.CONVEXPOLYHEDRON;
        var bins = this.bins,
            binLengths = this.binLengths,
            Nbins = this.bins.length; // Reset bins

        for (var i = 0; i !== Nbins; i++) {
          binLengths[i] = 0;
        }

        var ceil = Math.ceil;
        var min = Math.min;
        var max = Math.max;

        function addBoxToBins(x0, y0, z0, x1, y1, z1, bi) {
          var xoff0 = (x0 - xmin) * xmult | 0,
              yoff0 = (y0 - ymin) * ymult | 0,
              zoff0 = (z0 - zmin) * zmult | 0,
              xoff1 = ceil((x1 - xmin) * xmult),
              yoff1 = ceil((y1 - ymin) * ymult),
              zoff1 = ceil((z1 - zmin) * zmult);

          if (xoff0 < 0) {
            xoff0 = 0;
          } else if (xoff0 >= nx) {
            xoff0 = nx - 1;
          }

          if (yoff0 < 0) {
            yoff0 = 0;
          } else if (yoff0 >= ny) {
            yoff0 = ny - 1;
          }

          if (zoff0 < 0) {
            zoff0 = 0;
          } else if (zoff0 >= nz) {
            zoff0 = nz - 1;
          }

          if (xoff1 < 0) {
            xoff1 = 0;
          } else if (xoff1 >= nx) {
            xoff1 = nx - 1;
          }

          if (yoff1 < 0) {
            yoff1 = 0;
          } else if (yoff1 >= ny) {
            yoff1 = ny - 1;
          }

          if (zoff1 < 0) {
            zoff1 = 0;
          } else if (zoff1 >= nz) {
            zoff1 = nz - 1;
          }

          xoff0 *= xstep;
          yoff0 *= ystep;
          zoff0 *= zstep;
          xoff1 *= xstep;
          yoff1 *= ystep;
          zoff1 *= zstep;

          for (var xoff = xoff0; xoff <= xoff1; xoff += xstep) {
            for (var yoff = yoff0; yoff <= yoff1; yoff += ystep) {
              for (var zoff = zoff0; zoff <= zoff1; zoff += zstep) {
                var idx = xoff + yoff + zoff;
                bins[idx][binLengths[idx]++] = bi;
              }
            }
          }
        } // Put all bodies into the bins


        for (var i = 0; i !== N; i++) {
          var bi = bodies[i];
          var si = bi.shape;

          switch (si.type) {
            case SPHERE:
              // Put in bin
              // check if overlap with other bins
              var x = bi.position.x,
                  y = bi.position.y,
                  z = bi.position.z;
              var r = si.radius;
              addBoxToBins(x - r, y - r, z - r, x + r, y + r, z + r, bi);
              break;

            case PLANE:
              if (si.worldNormalNeedsUpdate) {
                si.computeWorldNormal(bi.quaternion);
              }

              var planeNormal = si.worldNormal; //Relative position from origin of plane object to the first bin
              //Incremented as we iterate through the bins

              var xreset = xmin + binsizeX * 0.5 - bi.position.x,
                  yreset = ymin + binsizeY * 0.5 - bi.position.y,
                  zreset = zmin + binsizeZ * 0.5 - bi.position.z;
              var d = GridBroadphase_collisionPairs_d;
              d.set(xreset, yreset, zreset);

              for (var xi = 0, xoff = 0; xi !== nx; xi++, xoff += xstep, d.y = yreset, d.x += binsizeX) {
                for (var yi = 0, yoff = 0; yi !== ny; yi++, yoff += ystep, d.z = zreset, d.y += binsizeY) {
                  for (var zi = 0, zoff = 0; zi !== nz; zi++, zoff += zstep, d.z += binsizeZ) {
                    if (d.dot(planeNormal) < binRadius) {
                      var idx = xoff + yoff + zoff;
                      bins[idx][binLengths[idx]++] = bi;
                    }
                  }
                }
              }

              break;

            default:
              if (bi.aabbNeedsUpdate) {
                bi.computeAABB();
              }

              addBoxToBins(bi.aabb.lowerBound.x, bi.aabb.lowerBound.y, bi.aabb.lowerBound.z, bi.aabb.upperBound.x, bi.aabb.upperBound.y, bi.aabb.upperBound.z, bi);
              break;
          }
        } // Check each bin


        for (var i = 0; i !== Nbins; i++) {
          var binLength = binLengths[i]; //Skip bins with no potential collisions

          if (binLength > 1) {
            var bin = bins[i]; // Do N^2 broadphase inside

            for (var xi = 0; xi !== binLength; xi++) {
              var bi = bin[xi];

              for (var yi = 0; yi !== xi; yi++) {
                var bj = bin[yi];

                if (this.needBroadphaseCollision(bi, bj)) {
                  this.intersectionTest(bi, bj, pairs1, pairs2);
                }
              }
            }
          }
        } //	for (var zi = 0, zoff=0; zi < nz; zi++, zoff+= zstep) {
        //		console.log("layer "+zi);
        //		for (var yi = 0, yoff=0; yi < ny; yi++, yoff += ystep) {
        //			var row = '';
        //			for (var xi = 0, xoff=0; xi < nx; xi++, xoff += xstep) {
        //				var idx = xoff + yoff + zoff;
        //				row += ' ' + binLengths[idx];
        //			}
        //			console.log(row);
        //		}
        //	}


        this.makePairsUnique(pairs1, pairs2);
      };
    }, {
      "../math/Vec3": 31,
      "../shapes/Shape": 44,
      "./Broadphase": 5
    }],
    7: [function (_dereq_, module, exports) {
      module.exports = NaiveBroadphase;

      var Broadphase = _dereq_('./Broadphase');

      var AABB = _dereq_('./AABB');
      /**
       * Naive broadphase implementation, used in lack of better ones.
       * @class NaiveBroadphase
       * @constructor
       * @description The naive broadphase looks at all possible pairs without restriction, therefore it has complexity N^2 (which is bad)
       * @extends Broadphase
       */


      function NaiveBroadphase() {
        Broadphase.apply(this);
      }

      NaiveBroadphase.prototype = new Broadphase();
      NaiveBroadphase.prototype.constructor = NaiveBroadphase;
      /**
       * Get all the collision pairs in the physics world
       * @method collisionPairs
       * @param {World} world
       * @param {Array} pairs1
       * @param {Array} pairs2
       */

      NaiveBroadphase.prototype.collisionPairs = function (world, pairs1, pairs2) {
        var bodies = world.bodies,
            n = bodies.length,
            i,
            j,
            bi,
            bj; // Naive N^2 ftw!

        for (i = 0; i !== n; i++) {
          for (j = 0; j !== i; j++) {
            bi = bodies[i];
            bj = bodies[j];

            if (!this.needBroadphaseCollision(bi, bj)) {
              continue;
            }

            this.intersectionTest(bi, bj, pairs1, pairs2);
          }
        }
      };

      var tmpAABB = new AABB();
      /**
       * Returns all the bodies within an AABB.
       * @method aabbQuery
       * @param  {World} world
       * @param  {AABB} aabb
       * @param {array} result An array to store resulting bodies in.
       * @return {array}
       */

      NaiveBroadphase.prototype.aabbQuery = function (world, aabb, result) {
        result = result || [];

        for (var i = 0; i < world.bodies.length; i++) {
          var b = world.bodies[i];

          if (b.aabbNeedsUpdate) {
            b.computeAABB();
          } // Ugly hack until Body gets aabb


          if (b.aabb.overlaps(aabb)) {
            result.push(b);
          }
        }

        return result;
      };
    }, {
      "./AABB": 3,
      "./Broadphase": 5
    }],
    8: [function (_dereq_, module, exports) {
      module.exports = ObjectCollisionMatrix;
      /**
       * Records what objects are colliding with each other
       * @class ObjectCollisionMatrix
       * @constructor
       */

      function ObjectCollisionMatrix() {
        /**
         * The matrix storage
         * @property matrix
         * @type {Object}
         */
        this.matrix = {};
      }
      /**
       * @method get
       * @param  {Number} i
       * @param  {Number} j
       * @return {Number}
       */


      ObjectCollisionMatrix.prototype.get = function (i, j) {
        i = i.id;
        j = j.id;

        if (j > i) {
          var temp = j;
          j = i;
          i = temp;
        }

        return i + '-' + j in this.matrix;
      };
      /**
       * @method set
       * @param  {Number} i
       * @param  {Number} j
       * @param {Number} value
       */


      ObjectCollisionMatrix.prototype.set = function (i, j, value) {
        i = i.id;
        j = j.id;

        if (j > i) {
          var temp = j;
          j = i;
          i = temp;
        }

        if (value) {
          this.matrix[i + '-' + j] = true;
        } else {
          delete this.matrix[i + '-' + j];
        }
      };
      /**
       * Empty the matrix
       * @method reset
       */


      ObjectCollisionMatrix.prototype.reset = function () {
        this.matrix = {};
      };
      /**
       * Set max number of objects
       * @method setNumObjects
       * @param {Number} n
       */


      ObjectCollisionMatrix.prototype.setNumObjects = function (n) {};
    }, {}],
    9: [function (_dereq_, module, exports) {
      module.exports = OverlapKeeper;
      /**
       * @class OverlapKeeper
       * @constructor
       */

      function OverlapKeeper() {
        this.current = [];
        this.previous = [];
      }

      OverlapKeeper.prototype.getKey = function (i, j) {
        if (j < i) {
          var temp = j;
          j = i;
          i = temp;
        }

        return i << 16 | j;
      };
      /**
       * @method set
       * @param {Number} i
       * @param {Number} j
       */


      OverlapKeeper.prototype.set = function (i, j) {
        // Insertion sort. This way the diff will have linear complexity.
        var key = this.getKey(i, j);
        var current = this.current;
        var index = 0;

        while (key > current[index]) {
          index++;
        }

        if (key === current[index]) {
          return; // Pair was already added
        }

        for (var j = current.length - 1; j >= index; j--) {
          current[j + 1] = current[j];
        }

        current[index] = key;
      };
      /**
       * @method tick
       */


      OverlapKeeper.prototype.tick = function () {
        var tmp = this.current;
        this.current = this.previous;
        this.previous = tmp;
        this.current.length = 0;
      };
      /**
       * @method reset
       */


      OverlapKeeper.prototype.reset = function () {
        this.previous.length = 0;
        this.current.length = 0;
      };

      function unpackAndPush(array, key) {
        array.push((key & 0xFFFF0000) >> 16, key & 0x0000FFFF);
      }
      /**
       * @method getDiff
       * @param  {array} additions
       * @param  {array} removals
       */


      OverlapKeeper.prototype.getDiff = function (additions, removals) {
        var a = this.current;
        var b = this.previous;
        var al = a.length;
        var bl = b.length;
        var j = 0;

        for (var i = 0; i < al; i++) {
          var found = false;
          var keyA = a[i];

          while (keyA > b[j]) {
            j++;
          }

          found = keyA === b[j];

          if (!found) {
            unpackAndPush(additions, keyA);
          }
        }

        j = 0;

        for (var i = 0; i < bl; i++) {
          var found = false;
          var keyB = b[i];

          while (keyB > a[j]) {
            j++;
          }

          found = a[j] === keyB;

          if (!found) {
            unpackAndPush(removals, keyB);
          }
        }
      };

      OverlapKeeper.prototype.copy = function (overlapKeeper) {
        this.current.length = 0;
        this.previous.length = 0;
        this.current = overlapKeeper.current.slice();
        this.previous = overlapKeeper.previous.slice();
      };
    }, {}],
    10: [function (_dereq_, module, exports) {
      module.exports = Ray;

      var Vec3 = _dereq_('../math/Vec3');

      var Quaternion = _dereq_('../math/Quaternion');

      var Transform = _dereq_('../math/Transform');

      var ConvexPolyhedron = _dereq_('../shapes/ConvexPolyhedron');

      var Box = _dereq_('../shapes/Box');

      var RaycastResult = _dereq_('../collision/RaycastResult');

      var Shape = _dereq_('../shapes/Shape');

      var AABB = _dereq_('../collision/AABB');
      /**
       * A line in 3D space that intersects bodies and return points.
       * @class Ray
       * @constructor
       * @param {Vec3} from
       * @param {Vec3} to
       */


      function Ray(from, to) {
        /**
         * @property {Vec3} from
         */
        this.from = from ? from.clone() : new Vec3();
        /**
         * @property {Vec3} to
         */

        this.to = to ? to.clone() : new Vec3();
        /**
         * @private
         * @property {Vec3} _direction
         */

        this._direction = new Vec3();
        /**
         * The precision of the ray. Used when checking parallelity etc.
         * @property {Number} precision
         */

        this.precision = 0.0001;
        /**
         * Set to true if you want the Ray to take .collisionResponse flags into account on bodies and shapes.
         * @property {Boolean} checkCollisionResponse
         */

        this.checkCollisionResponse = true;
        /**
         * If set to true, the ray skips any hits with normal.dot(rayDirection) < 0.
         * @property {Boolean} skipBackfaces
         */

        this.skipBackfaces = false;
        /**
         * @property {number} collisionFilterMask
         * @default -1
         */

        this.collisionFilterMask = -1;
        /**
         * @property {number} collisionFilterGroup
         * @default -1
         */

        this.collisionFilterGroup = -1;
        /**
         * The intersection mode. Should be Ray.ANY, Ray.ALL or Ray.CLOSEST.
         * @property {number} mode
         */

        this.mode = Ray.ANY;
        /**
         * Current result object.
         * @property {RaycastResult} result
         */

        this.result = new RaycastResult();
        /**
         * Will be set to true during intersectWorld() if the ray hit anything.
         * @property {Boolean} hasHit
         */

        this.hasHit = false;
        /**
         * Current, user-provided result callback. Will be used if mode is Ray.ALL.
         * @property {Function} callback
         */

        this.callback = function (result) {};
      }

      Ray.prototype.constructor = Ray;
      Ray.CLOSEST = 1;
      Ray.ANY = 2;
      Ray.ALL = 4;
      var tmpAABB = new AABB();
      var tmpArray = [];
      /**
       * Do itersection against all bodies in the given World.
       * @method intersectWorld
       * @param  {World} world
       * @param  {object} options
       * @return {Boolean} True if the ray hit anything, otherwise false.
       */

      Ray.prototype.intersectWorld = function (world, options) {
        this.mode = options.mode || Ray.ANY;
        this.result = options.result || new RaycastResult();
        this.skipBackfaces = !!options.skipBackfaces;
        this.collisionFilterMask = typeof options.collisionFilterMask !== 'undefined' ? options.collisionFilterMask : -1;
        this.collisionFilterGroup = typeof options.collisionFilterGroup !== 'undefined' ? options.collisionFilterGroup : -1;

        if (options.from) {
          this.from.copy(options.from);
        }

        if (options.to) {
          this.to.copy(options.to);
        }

        this.callback = options.callback || function () {};

        this.hasHit = false;
        this.result.reset();

        this._updateDirection();

        this.getAABB(tmpAABB);
        tmpArray.length = 0;
        world.broadphase.aabbQuery(world, tmpAABB, tmpArray);
        this.intersectBodies(tmpArray);
        return this.hasHit;
      };

      var v1 = new Vec3(),
          v2 = new Vec3();
      /*
       * As per "Barycentric Technique" as named here http://www.blackpawn.com/texts/pointinpoly/default.html But without the division
       */

      Ray.pointInTriangle = pointInTriangle;

      function pointInTriangle(p, a, b, c) {
        c.vsub(a, v0);
        b.vsub(a, v1);
        p.vsub(a, v2);
        var dot00 = v0.dot(v0);
        var dot01 = v0.dot(v1);
        var dot02 = v0.dot(v2);
        var dot11 = v1.dot(v1);
        var dot12 = v1.dot(v2);
        var u, v;
        return (u = dot11 * dot02 - dot01 * dot12) >= 0 && (v = dot00 * dot12 - dot01 * dot02) >= 0 && u + v < dot00 * dot11 - dot01 * dot01;
      }
      /**
       * Shoot a ray at a body, get back information about the hit.
       * @method intersectBody
       * @private
       * @param {Body} body
       * @param {RaycastResult} [result] Deprecated - set the result property of the Ray instead.
       */


      var intersectBody_xi = new Vec3();
      var intersectBody_qi = new Quaternion();

      Ray.prototype.intersectBody = function (body, result) {
        if (result) {
          this.result = result;

          this._updateDirection();
        }

        var checkCollisionResponse = this.checkCollisionResponse;

        if (checkCollisionResponse && !body.collisionResponse) {
          return;
        }

        if ((this.collisionFilterGroup & body.collisionFilterMask) === 0 || (body.collisionFilterGroup & this.collisionFilterMask) === 0) {
          return;
        }

        var xi = intersectBody_xi;
        var qi = intersectBody_qi;

        for (var i = 0, N = body.shapes.length; i < N; i++) {
          var shape = body.shapes[i];

          if (checkCollisionResponse && !shape.collisionResponse) {
            continue; // Skip
          }

          body.quaternion.mult(body.shapeOrientations[i], qi);
          body.quaternion.vmult(body.shapeOffsets[i], xi);
          xi.vadd(body.position, xi);
          this.intersectShape(shape, qi, xi, body);

          if (this.result._shouldStop) {
            break;
          }
        }
      };
      /**
       * @method intersectBodies
       * @param {Array} bodies An array of Body objects.
       * @param {RaycastResult} [result] Deprecated
       */


      Ray.prototype.intersectBodies = function (bodies, result) {
        if (result) {
          this.result = result;

          this._updateDirection();
        }

        for (var i = 0, l = bodies.length; !this.result._shouldStop && i < l; i++) {
          this.intersectBody(bodies[i]);
        }
      };
      /**
       * Updates the _direction vector.
       * @private
       * @method _updateDirection
       */


      Ray.prototype._updateDirection = function () {
        this.to.vsub(this.from, this._direction);

        this._direction.normalize();
      };
      /**
       * @method intersectShape
       * @private
       * @param {Shape} shape
       * @param {Quaternion} quat
       * @param {Vec3} position
       * @param {Body} body
       */


      Ray.prototype.intersectShape = function (shape, quat, position, body) {
        var from = this.from; // Checking boundingSphere

        var distance = distanceFromIntersection(from, this._direction, position);

        if (distance > shape.boundingSphereRadius) {
          return;
        }

        var intersectMethod = this[shape.type];

        if (intersectMethod) {
          intersectMethod.call(this, shape, quat, position, body, shape);
        }
      };

      var vector = new Vec3();
      var normal = new Vec3();
      var intersectPoint = new Vec3();
      var a = new Vec3();
      var b = new Vec3();
      var c = new Vec3();
      var d = new Vec3();
      var tmpRaycastResult = new RaycastResult();
      /**
       * @method intersectBox
       * @private
       * @param  {Shape} shape
       * @param  {Quaternion} quat
       * @param  {Vec3} position
       * @param  {Body} body
       */

      Ray.prototype.intersectBox = function (shape, quat, position, body, reportedShape) {
        return this.intersectConvex(shape.convexPolyhedronRepresentation, quat, position, body, reportedShape);
      };

      Ray.prototype[Shape.types.BOX] = Ray.prototype.intersectBox;
      /**
       * @method intersectPlane
       * @private
       * @param  {Shape} shape
       * @param  {Quaternion} quat
       * @param  {Vec3} position
       * @param  {Body} body
       */

      Ray.prototype.intersectPlane = function (shape, quat, position, body, reportedShape) {
        var from = this.from;
        var to = this.to;
        var direction = this._direction; // Get plane normal

        var worldNormal = new Vec3(0, 0, 1);
        quat.vmult(worldNormal, worldNormal);
        var len = new Vec3();
        from.vsub(position, len);
        var planeToFrom = len.dot(worldNormal);
        to.vsub(position, len);
        var planeToTo = len.dot(worldNormal);

        if (planeToFrom * planeToTo > 0) {
          // "from" and "to" are on the same side of the plane... bail out
          return;
        }

        if (from.distanceTo(to) < planeToFrom) {
          return;
        }

        var n_dot_dir = worldNormal.dot(direction);

        if (Math.abs(n_dot_dir) < this.precision) {
          // No intersection
          return;
        }

        var planePointToFrom = new Vec3();
        var dir_scaled_with_t = new Vec3();
        var hitPointWorld = new Vec3();
        from.vsub(position, planePointToFrom);
        var t = -worldNormal.dot(planePointToFrom) / n_dot_dir;
        direction.scale(t, dir_scaled_with_t);
        from.vadd(dir_scaled_with_t, hitPointWorld);
        this.reportIntersection(worldNormal, hitPointWorld, reportedShape, body, -1);
      };

      Ray.prototype[Shape.types.PLANE] = Ray.prototype.intersectPlane;
      /**
       * Get the world AABB of the ray.
       * @method getAABB
       * @param  {AABB} aabb
       */

      Ray.prototype.getAABB = function (result) {
        var to = this.to;
        var from = this.from;
        result.lowerBound.x = Math.min(to.x, from.x);
        result.lowerBound.y = Math.min(to.y, from.y);
        result.lowerBound.z = Math.min(to.z, from.z);
        result.upperBound.x = Math.max(to.x, from.x);
        result.upperBound.y = Math.max(to.y, from.y);
        result.upperBound.z = Math.max(to.z, from.z);
      };

      var intersectConvexOptions = {
        faceList: [0]
      };
      var worldPillarOffset = new Vec3();
      var intersectHeightfield_localRay = new Ray();
      var intersectHeightfield_index = [];
      var intersectHeightfield_minMax = [];
      /**
       * @method intersectHeightfield
       * @private
       * @param  {Shape} shape
       * @param  {Quaternion} quat
       * @param  {Vec3} position
       * @param  {Body} body
       */

      Ray.prototype.intersectHeightfield = function (shape, quat, position, body, reportedShape) {
        var data = shape.data,
            w = shape.elementSize; // Convert the ray to local heightfield coordinates

        var localRay = intersectHeightfield_localRay; //new Ray(this.from, this.to);

        localRay.from.copy(this.from);
        localRay.to.copy(this.to);
        Transform.pointToLocalFrame(position, quat, localRay.from, localRay.from);
        Transform.pointToLocalFrame(position, quat, localRay.to, localRay.to);

        localRay._updateDirection(); // Get the index of the data points to test against


        var index = intersectHeightfield_index;
        var iMinX, iMinY, iMaxX, iMaxY; // Set to max

        iMinX = iMinY = 0;
        iMaxX = iMaxY = shape.data.length - 1;
        var aabb = new AABB();
        localRay.getAABB(aabb);
        shape.getIndexOfPosition(aabb.lowerBound.x, aabb.lowerBound.y, index, true);
        iMinX = Math.max(iMinX, index[0]);
        iMinY = Math.max(iMinY, index[1]);
        shape.getIndexOfPosition(aabb.upperBound.x, aabb.upperBound.y, index, true);
        iMaxX = Math.min(iMaxX, index[0] + 1);
        iMaxY = Math.min(iMaxY, index[1] + 1);

        for (var i = iMinX; i < iMaxX; i++) {
          for (var j = iMinY; j < iMaxY; j++) {
            if (this.result._shouldStop) {
              return;
            }

            shape.getAabbAtIndex(i, j, aabb);

            if (!aabb.overlapsRay(localRay)) {
              continue;
            } // Lower triangle


            shape.getConvexTrianglePillar(i, j, false);
            Transform.pointToWorldFrame(position, quat, shape.pillarOffset, worldPillarOffset);
            this.intersectConvex(shape.pillarConvex, quat, worldPillarOffset, body, reportedShape, intersectConvexOptions);

            if (this.result._shouldStop) {
              return;
            } // Upper triangle


            shape.getConvexTrianglePillar(i, j, true);
            Transform.pointToWorldFrame(position, quat, shape.pillarOffset, worldPillarOffset);
            this.intersectConvex(shape.pillarConvex, quat, worldPillarOffset, body, reportedShape, intersectConvexOptions);
          }
        }
      };

      Ray.prototype[Shape.types.HEIGHTFIELD] = Ray.prototype.intersectHeightfield;
      var Ray_intersectSphere_intersectionPoint = new Vec3();
      var Ray_intersectSphere_normal = new Vec3();
      /**
       * @method intersectSphere
       * @private
       * @param  {Shape} shape
       * @param  {Quaternion} quat
       * @param  {Vec3} position
       * @param  {Body} body
       */

      Ray.prototype.intersectSphere = function (shape, quat, position, body, reportedShape) {
        var from = this.from,
            to = this.to,
            r = shape.radius;
        var a = Math.pow(to.x - from.x, 2) + Math.pow(to.y - from.y, 2) + Math.pow(to.z - from.z, 2);
        var b = 2 * ((to.x - from.x) * (from.x - position.x) + (to.y - from.y) * (from.y - position.y) + (to.z - from.z) * (from.z - position.z));
        var c = Math.pow(from.x - position.x, 2) + Math.pow(from.y - position.y, 2) + Math.pow(from.z - position.z, 2) - Math.pow(r, 2);
        var delta = Math.pow(b, 2) - 4 * a * c;
        var intersectionPoint = Ray_intersectSphere_intersectionPoint;
        var normal = Ray_intersectSphere_normal;

        if (delta < 0) {
          // No intersection
          return;
        } else if (delta === 0) {
          // single intersection point
          from.lerp(to, delta, intersectionPoint);
          intersectionPoint.vsub(position, normal);
          normal.normalize();
          this.reportIntersection(normal, intersectionPoint, reportedShape, body, -1);
        } else {
          var d1 = (-b - Math.sqrt(delta)) / (2 * a);
          var d2 = (-b + Math.sqrt(delta)) / (2 * a);

          if (d1 >= 0 && d1 <= 1) {
            from.lerp(to, d1, intersectionPoint);
            intersectionPoint.vsub(position, normal);
            normal.normalize();
            this.reportIntersection(normal, intersectionPoint, reportedShape, body, -1);
          }

          if (this.result._shouldStop) {
            return;
          }

          if (d2 >= 0 && d2 <= 1) {
            from.lerp(to, d2, intersectionPoint);
            intersectionPoint.vsub(position, normal);
            normal.normalize();
            this.reportIntersection(normal, intersectionPoint, reportedShape, body, -1);
          }
        }
      };

      Ray.prototype[Shape.types.SPHERE] = Ray.prototype.intersectSphere;
      var intersectConvex_normal = new Vec3();
      var intersectConvex_minDistNormal = new Vec3();
      var intersectConvex_minDistIntersect = new Vec3();
      var intersectConvex_vector = new Vec3();
      /**
       * @method intersectConvex
       * @private
       * @param  {Shape} shape
       * @param  {Quaternion} quat
       * @param  {Vec3} position
       * @param  {Body} body
       * @param {object} [options]
       * @param {array} [options.faceList]
       */

      Ray.prototype.intersectConvex = function intersectConvex(shape, quat, position, body, reportedShape, options) {
        var minDistNormal = intersectConvex_minDistNormal;
        var normal = intersectConvex_normal;
        var vector = intersectConvex_vector;
        var minDistIntersect = intersectConvex_minDistIntersect;
        var faceList = options && options.faceList || null; // Checking faces

        var faces = shape.faces,
            vertices = shape.vertices,
            normals = shape.faceNormals;
        var direction = this._direction;
        var from = this.from;
        var to = this.to;
        var fromToDistance = from.distanceTo(to);
        var minDist = -1;
        var Nfaces = faceList ? faceList.length : faces.length;
        var result = this.result;

        for (var j = 0; !result._shouldStop && j < Nfaces; j++) {
          var fi = faceList ? faceList[j] : j;
          var face = faces[fi];
          var faceNormal = normals[fi];
          var q = quat;
          var x = position; // determine if ray intersects the plane of the face
          // note: this works regardless of the direction of the face normal
          // Get plane point in world coordinates...

          vector.copy(vertices[face[0]]);
          q.vmult(vector, vector);
          vector.vadd(x, vector); // ...but make it relative to the ray from. We'll fix this later.

          vector.vsub(from, vector); // Get plane normal

          q.vmult(faceNormal, normal); // If this dot product is negative, we have something interesting

          var dot = direction.dot(normal); // Bail out if ray and plane are parallel

          if (Math.abs(dot) < this.precision) {
            continue;
          } // calc distance to plane


          var scalar = normal.dot(vector) / dot; // if negative distance, then plane is behind ray

          if (scalar < 0) {
            continue;
          } // if (dot < 0) {
          // Intersection point is from + direction * scalar


          direction.mult(scalar, intersectPoint);
          intersectPoint.vadd(from, intersectPoint); // a is the point we compare points b and c with.

          a.copy(vertices[face[0]]);
          q.vmult(a, a);
          x.vadd(a, a);

          for (var i = 1; !result._shouldStop && i < face.length - 1; i++) {
            // Transform 3 vertices to world coords
            b.copy(vertices[face[i]]);
            c.copy(vertices[face[i + 1]]);
            q.vmult(b, b);
            q.vmult(c, c);
            x.vadd(b, b);
            x.vadd(c, c);
            var distance = intersectPoint.distanceTo(from);

            if (!(pointInTriangle(intersectPoint, a, b, c) || pointInTriangle(intersectPoint, b, a, c)) || distance > fromToDistance) {
              continue;
            }

            this.reportIntersection(normal, intersectPoint, reportedShape, body, fi);
          } // }

        }
      };

      Ray.prototype[Shape.types.CONVEXPOLYHEDRON] = Ray.prototype.intersectConvex;
      var intersectTrimesh_normal = new Vec3();
      var intersectTrimesh_localDirection = new Vec3();
      var intersectTrimesh_localFrom = new Vec3();
      var intersectTrimesh_localTo = new Vec3();
      var intersectTrimesh_worldNormal = new Vec3();
      var intersectTrimesh_worldIntersectPoint = new Vec3();
      var intersectTrimesh_localAABB = new AABB();
      var intersectTrimesh_triangles = [];
      var intersectTrimesh_treeTransform = new Transform();
      /**
       * @method intersectTrimesh
       * @private
       * @param  {Shape} shape
       * @param  {Quaternion} quat
       * @param  {Vec3} position
       * @param  {Body} body
       * @param {object} [options]
       * @todo Optimize by transforming the world to local space first.
       * @todo Use Octree lookup
       */

      Ray.prototype.intersectTrimesh = function intersectTrimesh(mesh, quat, position, body, reportedShape, options) {
        var normal = intersectTrimesh_normal;
        var triangles = intersectTrimesh_triangles;
        var treeTransform = intersectTrimesh_treeTransform;
        var minDistNormal = intersectConvex_minDistNormal;
        var vector = intersectConvex_vector;
        var minDistIntersect = intersectConvex_minDistIntersect;
        var localAABB = intersectTrimesh_localAABB;
        var localDirection = intersectTrimesh_localDirection;
        var localFrom = intersectTrimesh_localFrom;
        var localTo = intersectTrimesh_localTo;
        var worldIntersectPoint = intersectTrimesh_worldIntersectPoint;
        var worldNormal = intersectTrimesh_worldNormal;
        var faceList = options && options.faceList || null; // Checking faces

        var indices = mesh.indices,
            vertices = mesh.vertices,
            normals = mesh.faceNormals;
        var from = this.from;
        var to = this.to;
        var direction = this._direction;
        var minDist = -1;
        treeTransform.position.copy(position);
        treeTransform.quaternion.copy(quat); // Transform ray to local space!

        Transform.vectorToLocalFrame(position, quat, direction, localDirection);
        Transform.pointToLocalFrame(position, quat, from, localFrom);
        Transform.pointToLocalFrame(position, quat, to, localTo);
        localTo.x *= mesh.scale.x;
        localTo.y *= mesh.scale.y;
        localTo.z *= mesh.scale.z;
        localFrom.x *= mesh.scale.x;
        localFrom.y *= mesh.scale.y;
        localFrom.z *= mesh.scale.z;
        localTo.vsub(localFrom, localDirection);
        localDirection.normalize();
        var fromToDistanceSquared = localFrom.distanceSquared(localTo);
        mesh.tree.rayQuery(this, treeTransform, triangles);

        for (var i = 0, N = triangles.length; !this.result._shouldStop && i !== N; i++) {
          var trianglesIndex = triangles[i];
          mesh.getNormal(trianglesIndex, normal); // determine if ray intersects the plane of the face
          // note: this works regardless of the direction of the face normal
          // Get plane point in world coordinates...

          mesh.getVertex(indices[trianglesIndex * 3], a); // ...but make it relative to the ray from. We'll fix this later.

          a.vsub(localFrom, vector); // If this dot product is negative, we have something interesting

          var dot = localDirection.dot(normal); // Bail out if ray and plane are parallel
          // if (Math.abs( dot ) < this.precision){
          //     continue;
          // }
          // calc distance to plane

          var scalar = normal.dot(vector) / dot; // if negative distance, then plane is behind ray

          if (scalar < 0) {
            continue;
          } // Intersection point is from + direction * scalar


          localDirection.scale(scalar, intersectPoint);
          intersectPoint.vadd(localFrom, intersectPoint); // Get triangle vertices

          mesh.getVertex(indices[trianglesIndex * 3 + 1], b);
          mesh.getVertex(indices[trianglesIndex * 3 + 2], c);
          var squaredDistance = intersectPoint.distanceSquared(localFrom);

          if (!(pointInTriangle(intersectPoint, b, a, c) || pointInTriangle(intersectPoint, a, b, c)) || squaredDistance > fromToDistanceSquared) {
            continue;
          } // transform intersectpoint and normal to world


          Transform.vectorToWorldFrame(quat, normal, worldNormal);
          Transform.pointToWorldFrame(position, quat, intersectPoint, worldIntersectPoint);
          this.reportIntersection(worldNormal, worldIntersectPoint, reportedShape, body, trianglesIndex);
        }

        triangles.length = 0;
      };

      Ray.prototype[Shape.types.TRIMESH] = Ray.prototype.intersectTrimesh;
      /**
       * @method reportIntersection
       * @private
       * @param  {Vec3} normal
       * @param  {Vec3} hitPointWorld
       * @param  {Shape} shape
       * @param  {Body} body
       * @return {boolean} True if the intersections should continue
       */

      Ray.prototype.reportIntersection = function (normal, hitPointWorld, shape, body, hitFaceIndex) {
        var from = this.from;
        var to = this.to;
        var distance = from.distanceTo(hitPointWorld);
        var result = this.result; // Skip back faces?

        if (this.skipBackfaces && normal.dot(this._direction) > 0) {
          return;
        }

        result.hitFaceIndex = typeof hitFaceIndex !== 'undefined' ? hitFaceIndex : -1;

        switch (this.mode) {
          case Ray.ALL:
            this.hasHit = true;
            result.set(from, to, normal, hitPointWorld, shape, body, distance);
            result.hasHit = true;
            this.callback(result);
            break;

          case Ray.CLOSEST:
            // Store if closer than current closest
            if (distance < result.distance || !result.hasHit) {
              this.hasHit = true;
              result.hasHit = true;
              result.set(from, to, normal, hitPointWorld, shape, body, distance);
            }

            break;

          case Ray.ANY:
            // Report and stop.
            this.hasHit = true;
            result.hasHit = true;
            result.set(from, to, normal, hitPointWorld, shape, body, distance);
            result._shouldStop = true;
            break;
        }
      };

      var v0 = new Vec3(),
          intersect = new Vec3();

      function distanceFromIntersection(from, direction, position) {
        // v0 is vector from from to position
        position.vsub(from, v0);
        var dot = v0.dot(direction); // intersect = direction*dot + from

        direction.mult(dot, intersect);
        intersect.vadd(from, intersect);
        var distance = position.distanceTo(intersect);
        return distance;
      }
    }, {
      "../collision/AABB": 3,
      "../collision/RaycastResult": 11,
      "../math/Quaternion": 29,
      "../math/Transform": 30,
      "../math/Vec3": 31,
      "../shapes/Box": 38,
      "../shapes/ConvexPolyhedron": 39,
      "../shapes/Shape": 44
    }],
    11: [function (_dereq_, module, exports) {
      var Vec3 = _dereq_('../math/Vec3');

      module.exports = RaycastResult;
      /**
       * Storage for Ray casting data.
       * @class RaycastResult
       * @constructor
       */

      function RaycastResult() {
        /**
         * @property {Vec3} rayFromWorld
         */
        this.rayFromWorld = new Vec3();
        /**
         * @property {Vec3} rayToWorld
         */

        this.rayToWorld = new Vec3();
        /**
         * @property {Vec3} hitNormalWorld
         */

        this.hitNormalWorld = new Vec3();
        /**
         * @property {Vec3} hitPointWorld
         */

        this.hitPointWorld = new Vec3();
        /**
         * @property {boolean} hasHit
         */

        this.hasHit = false;
        /**
         * The hit shape, or null.
         * @property {Shape} shape
         */

        this.shape = null;
        /**
         * The hit body, or null.
         * @property {Body} body
         */

        this.body = null;
        /**
         * The index of the hit triangle, if the hit shape was a trimesh.
         * @property {number} hitFaceIndex
         * @default -1
         */

        this.hitFaceIndex = -1;
        /**
         * Distance to the hit. Will be set to -1 if there was no hit.
         * @property {number} distance
         * @default -1
         */

        this.distance = -1;
        /**
         * If the ray should stop traversing the bodies.
         * @private
         * @property {Boolean} _shouldStop
         * @default false
         */

        this._shouldStop = false;
      }
      /**
       * Reset all result data.
       * @method reset
       */


      RaycastResult.prototype.reset = function () {
        this.rayFromWorld.setZero();
        this.rayToWorld.setZero();
        this.hitNormalWorld.setZero();
        this.hitPointWorld.setZero();
        this.hasHit = false;
        this.shape = null;
        this.body = null;
        this.hitFaceIndex = -1;
        this.distance = -1;
        this._shouldStop = false;
      };
      /**
       * @method abort
       */


      RaycastResult.prototype.abort = function () {
        this._shouldStop = true;
      };
      /**
       * @method set
       * @param {Vec3} rayFromWorld
       * @param {Vec3} rayToWorld
       * @param {Vec3} hitNormalWorld
       * @param {Vec3} hitPointWorld
       * @param {Shape} shape
       * @param {Body} body
       * @param {number} distance
       */


      RaycastResult.prototype.set = function (rayFromWorld, rayToWorld, hitNormalWorld, hitPointWorld, shape, body, distance) {
        this.rayFromWorld.copy(rayFromWorld);
        this.rayToWorld.copy(rayToWorld);
        this.hitNormalWorld.copy(hitNormalWorld);
        this.hitPointWorld.copy(hitPointWorld);
        this.shape = shape;
        this.body = body;
        this.distance = distance;
      };
    }, {
      "../math/Vec3": 31
    }],
    12: [function (_dereq_, module, exports) {
      var Shape = _dereq_('../shapes/Shape');

      var Broadphase = _dereq_('../collision/Broadphase');

      module.exports = SAPBroadphase;
      /**
       * Sweep and prune broadphase along one axis.
       *
       * @class SAPBroadphase
       * @constructor
       * @param {World} [world]
       * @extends Broadphase
       */

      function SAPBroadphase(world) {
        Broadphase.apply(this);
        /**
         * List of bodies currently in the broadphase.
         * @property axisList
         * @type {Array}
         */

        this.axisList = [];
        /**
         * The world to search in.
         * @property world
         * @type {World}
         */

        this.world = null;
        /**
         * Axis to sort the bodies along. Set to 0 for x axis, and 1 for y axis. For best performance, choose an axis that the bodies are spread out more on.
         * @property axisIndex
         * @type {Number}
         */

        this.axisIndex = 0;
        var axisList = this.axisList;

        this._addBodyHandler = function (e) {
          axisList.push(e.body);
        };

        this._removeBodyHandler = function (e) {
          var idx = axisList.indexOf(e.body);

          if (idx !== -1) {
            axisList.splice(idx, 1);
          }
        };

        if (world) {
          this.setWorld(world);
        }
      }

      SAPBroadphase.prototype = new Broadphase();
      /**
       * Change the world
       * @method setWorld
       * @param  {World} world
       */

      SAPBroadphase.prototype.setWorld = function (world) {
        // Clear the old axis array
        this.axisList.length = 0; // Add all bodies from the new world

        for (var i = 0; i < world.bodies.length; i++) {
          this.axisList.push(world.bodies[i]);
        } // Remove old handlers, if any


        world.removeEventListener("addBody", this._addBodyHandler);
        world.removeEventListener("removeBody", this._removeBodyHandler); // Add handlers to update the list of bodies.

        world.addEventListener("addBody", this._addBodyHandler);
        world.addEventListener("removeBody", this._removeBodyHandler);
        this.world = world;
        this.dirty = true;
      };
      /**
       * @static
       * @method insertionSortX
       * @param  {Array} a
       * @return {Array}
       */


      SAPBroadphase.insertionSortX = function (a) {
        for (var i = 1, l = a.length; i < l; i++) {
          var v = a[i];

          for (var j = i - 1; j >= 0; j--) {
            if (a[j].aabb.lowerBound.x <= v.aabb.lowerBound.x) {
              break;
            }

            a[j + 1] = a[j];
          }

          a[j + 1] = v;
        }

        return a;
      };
      /**
       * @static
       * @method insertionSortY
       * @param  {Array} a
       * @return {Array}
       */


      SAPBroadphase.insertionSortY = function (a) {
        for (var i = 1, l = a.length; i < l; i++) {
          var v = a[i];

          for (var j = i - 1; j >= 0; j--) {
            if (a[j].aabb.lowerBound.y <= v.aabb.lowerBound.y) {
              break;
            }

            a[j + 1] = a[j];
          }

          a[j + 1] = v;
        }

        return a;
      };
      /**
       * @static
       * @method insertionSortZ
       * @param  {Array} a
       * @return {Array}
       */


      SAPBroadphase.insertionSortZ = function (a) {
        for (var i = 1, l = a.length; i < l; i++) {
          var v = a[i];

          for (var j = i - 1; j >= 0; j--) {
            if (a[j].aabb.lowerBound.z <= v.aabb.lowerBound.z) {
              break;
            }

            a[j + 1] = a[j];
          }

          a[j + 1] = v;
        }

        return a;
      };
      /**
       * Collect all collision pairs
       * @method collisionPairs
       * @param  {World} world
       * @param  {Array} p1
       * @param  {Array} p2
       */


      SAPBroadphase.prototype.collisionPairs = function (world, p1, p2) {
        var bodies = this.axisList,
            N = bodies.length,
            axisIndex = this.axisIndex,
            i,
            j;

        if (this.dirty) {
          this.sortList();
          this.dirty = false;
        } // Look through the list


        for (i = 0; i !== N; i++) {
          var bi = bodies[i];

          for (j = i + 1; j < N; j++) {
            var bj = bodies[j];

            if (!this.needBroadphaseCollision(bi, bj)) {
              continue;
            }

            if (!SAPBroadphase.checkBounds(bi, bj, axisIndex)) {
              break;
            }

            this.intersectionTest(bi, bj, p1, p2);
          }
        }
      };

      SAPBroadphase.prototype.sortList = function () {
        var axisList = this.axisList;
        var axisIndex = this.axisIndex;
        var N = axisList.length; // Update AABBs

        for (var i = 0; i !== N; i++) {
          var bi = axisList[i];

          if (bi.aabbNeedsUpdate) {
            bi.computeAABB();
          }
        } // Sort the list


        if (axisIndex === 0) {
          SAPBroadphase.insertionSortX(axisList);
        } else if (axisIndex === 1) {
          SAPBroadphase.insertionSortY(axisList);
        } else if (axisIndex === 2) {
          SAPBroadphase.insertionSortZ(axisList);
        }
      };
      /**
       * Check if the bounds of two bodies overlap, along the given SAP axis.
       * @static
       * @method checkBounds
       * @param  {Body} bi
       * @param  {Body} bj
       * @param  {Number} axisIndex
       * @return {Boolean}
       */


      SAPBroadphase.checkBounds = function (bi, bj, axisIndex) {
        var biPos;
        var bjPos;

        if (axisIndex === 0) {
          biPos = bi.position.x;
          bjPos = bj.position.x;
        } else if (axisIndex === 1) {
          biPos = bi.position.y;
          bjPos = bj.position.y;
        } else if (axisIndex === 2) {
          biPos = bi.position.z;
          bjPos = bj.position.z;
        }

        var ri = bi.boundingRadius,
            rj = bj.boundingRadius,
            boundA1 = biPos - ri,
            boundA2 = biPos + ri,
            boundB1 = bjPos - rj,
            boundB2 = bjPos + rj;
        return boundB1 < boundA2;
      };
      /**
       * Computes the variance of the body positions and estimates the best
       * axis to use. Will automatically set property .axisIndex.
       * @method autoDetectAxis
       */


      SAPBroadphase.prototype.autoDetectAxis = function () {
        var sumX = 0,
            sumX2 = 0,
            sumY = 0,
            sumY2 = 0,
            sumZ = 0,
            sumZ2 = 0,
            bodies = this.axisList,
            N = bodies.length,
            invN = 1 / N;

        for (var i = 0; i !== N; i++) {
          var b = bodies[i];
          var centerX = b.position.x;
          sumX += centerX;
          sumX2 += centerX * centerX;
          var centerY = b.position.y;
          sumY += centerY;
          sumY2 += centerY * centerY;
          var centerZ = b.position.z;
          sumZ += centerZ;
          sumZ2 += centerZ * centerZ;
        }

        var varianceX = sumX2 - sumX * sumX * invN,
            varianceY = sumY2 - sumY * sumY * invN,
            varianceZ = sumZ2 - sumZ * sumZ * invN;

        if (varianceX > varianceY) {
          if (varianceX > varianceZ) {
            this.axisIndex = 0;
          } else {
            this.axisIndex = 2;
          }
        } else if (varianceY > varianceZ) {
          this.axisIndex = 1;
        } else {
          this.axisIndex = 2;
        }
      };
      /**
       * Returns all the bodies within an AABB.
       * @method aabbQuery
       * @param  {World} world
       * @param  {AABB} aabb
       * @param {array} result An array to store resulting bodies in.
       * @return {array}
       */


      SAPBroadphase.prototype.aabbQuery = function (world, aabb, result) {
        result = result || [];

        if (this.dirty) {
          this.sortList();
          this.dirty = false;
        }

        var axisIndex = this.axisIndex,
            axis = 'x';

        if (axisIndex === 1) {
          axis = 'y';
        }

        if (axisIndex === 2) {
          axis = 'z';
        }

        var axisList = this.axisList;
        var lower = aabb.lowerBound[axis];
        var upper = aabb.upperBound[axis];

        for (var i = 0; i < axisList.length; i++) {
          var b = axisList[i];

          if (b.aabbNeedsUpdate) {
            b.computeAABB();
          }

          if (b.aabb.overlaps(aabb)) {
            result.push(b);
          }
        }

        return result;
      };
    }, {
      "../collision/Broadphase": 5,
      "../shapes/Shape": 44
    }],
    13: [function (_dereq_, module, exports) {
      module.exports = ConeTwistConstraint;

      var Constraint = _dereq_('./Constraint');

      var PointToPointConstraint = _dereq_('./PointToPointConstraint');

      var ConeEquation = _dereq_('../equations/ConeEquation');

      var RotationalEquation = _dereq_('../equations/RotationalEquation');

      var ContactEquation = _dereq_('../equations/ContactEquation');

      var Vec3 = _dereq_('../math/Vec3');
      /**
       * @class ConeTwistConstraint
       * @constructor
       * @author schteppe
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {object} [options]
       * @param {Vec3} [options.pivotA]
       * @param {Vec3} [options.pivotB]
       * @param {Vec3} [options.axisA]
       * @param {Vec3} [options.axisB]
       * @param {Number} [options.maxForce=1e6]
       * @extends PointToPointConstraint
       */


      function ConeTwistConstraint(bodyA, bodyB, options) {
        options = options || {};
        var maxForce = typeof options.maxForce !== 'undefined' ? options.maxForce : 1e6; // Set pivot point in between

        var pivotA = options.pivotA ? options.pivotA.clone() : new Vec3();
        var pivotB = options.pivotB ? options.pivotB.clone() : new Vec3();
        this.axisA = options.axisA ? options.axisA.clone() : new Vec3();
        this.axisB = options.axisB ? options.axisB.clone() : new Vec3();
        PointToPointConstraint.call(this, bodyA, pivotA, bodyB, pivotB, maxForce);
        this.collideConnected = !!options.collideConnected;
        this.angle = typeof options.angle !== 'undefined' ? options.angle : 0;
        /**
         * @property {ConeEquation} coneEquation
         */

        var c = this.coneEquation = new ConeEquation(bodyA, bodyB, options);
        /**
         * @property {RotationalEquation} twistEquation
         */

        var t = this.twistEquation = new RotationalEquation(bodyA, bodyB, options);
        this.twistAngle = typeof options.twistAngle !== 'undefined' ? options.twistAngle : 0; // Make the cone equation push the bodies toward the cone axis, not outward

        c.maxForce = 0;
        c.minForce = -maxForce; // Make the twist equation add torque toward the initial position

        t.maxForce = 0;
        t.minForce = -maxForce;
        this.equations.push(c, t);
      }

      ConeTwistConstraint.prototype = new PointToPointConstraint();
      ConeTwistConstraint.constructor = ConeTwistConstraint;
      var ConeTwistConstraint_update_tmpVec1 = new Vec3();
      var ConeTwistConstraint_update_tmpVec2 = new Vec3();

      ConeTwistConstraint.prototype.update = function () {
        var bodyA = this.bodyA,
            bodyB = this.bodyB,
            cone = this.coneEquation,
            twist = this.twistEquation;
        PointToPointConstraint.prototype.update.call(this); // Update the axes to the cone constraint

        bodyA.vectorToWorldFrame(this.axisA, cone.axisA);
        bodyB.vectorToWorldFrame(this.axisB, cone.axisB); // Update the world axes in the twist constraint

        this.axisA.tangents(twist.axisA, twist.axisA);
        bodyA.vectorToWorldFrame(twist.axisA, twist.axisA);
        this.axisB.tangents(twist.axisB, twist.axisB);
        bodyB.vectorToWorldFrame(twist.axisB, twist.axisB);
        cone.angle = this.angle;
        twist.maxAngle = this.twistAngle;
      };
    }, {
      "../equations/ConeEquation": 19,
      "../equations/ContactEquation": 20,
      "../equations/RotationalEquation": 23,
      "../math/Vec3": 31,
      "./Constraint": 14,
      "./PointToPointConstraint": 18
    }],
    14: [function (_dereq_, module, exports) {
      module.exports = Constraint;

      var Utils = _dereq_('../utils/Utils');
      /**
       * Constraint base class
       * @class Constraint
       * @author schteppe
       * @constructor
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {object} [options]
       * @param {boolean} [options.collideConnected=true]
       * @param {boolean} [options.wakeUpBodies=true]
       */


      function Constraint(bodyA, bodyB, options) {
        options = Utils.defaults(options, {
          collideConnected: true,
          wakeUpBodies: true
        });
        /**
         * Equations to be solved in this constraint
         * @property equations
         * @type {Array}
         */

        this.equations = [];
        /**
         * @property {Body} bodyA
         */

        this.bodyA = bodyA;
        /**
         * @property {Body} bodyB
         */

        this.bodyB = bodyB;
        /**
         * @property {Number} id
         */

        this.id = Constraint.idCounter++;
        /**
         * Set to true if you want the bodies to collide when they are connected.
         * @property collideConnected
         * @type {boolean}
         */

        this.collideConnected = options.collideConnected;

        if (options.wakeUpBodies) {
          if (bodyA) {
            bodyA.wakeUp();
          }

          if (bodyB) {
            bodyB.wakeUp();
          }
        }
      }
      /**
       * Update all the equations with data.
       * @method update
       */


      Constraint.prototype.update = function () {
        throw new Error("method update() not implmemented in this Constraint subclass!");
      };
      /**
       * Enables all equations in the constraint.
       * @method enable
       */


      Constraint.prototype.enable = function () {
        var eqs = this.equations;

        for (var i = 0; i < eqs.length; i++) {
          eqs[i].enabled = true;
        }
      };
      /**
       * Disables all equations in the constraint.
       * @method disable
       */


      Constraint.prototype.disable = function () {
        var eqs = this.equations;

        for (var i = 0; i < eqs.length; i++) {
          eqs[i].enabled = false;
        }
      };

      Constraint.idCounter = 0;
    }, {
      "../utils/Utils": 54
    }],
    15: [function (_dereq_, module, exports) {
      module.exports = DistanceConstraint;

      var Constraint = _dereq_('./Constraint');

      var ContactEquation = _dereq_('../equations/ContactEquation');
      /**
       * Constrains two bodies to be at a constant distance from each others center of mass.
       * @class DistanceConstraint
       * @constructor
       * @author schteppe
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {Number} [distance] The distance to keep. If undefined, it will be set to the current distance between bodyA and bodyB
       * @param {Number} [maxForce=1e6]
       * @extends Constraint
       */


      function DistanceConstraint(bodyA, bodyB, distance, maxForce) {
        Constraint.call(this, bodyA, bodyB);

        if (typeof distance === "undefined") {
          distance = bodyA.position.distanceTo(bodyB.position);
        }

        if (typeof maxForce === "undefined") {
          maxForce = 1e6;
        }
        /**
         * @property {number} distance
         */


        this.distance = distance;
        /**
         * @property {ContactEquation} distanceEquation
         */

        var eq = this.distanceEquation = new ContactEquation(bodyA, bodyB);
        this.equations.push(eq); // Make it bidirectional

        eq.minForce = -maxForce;
        eq.maxForce = maxForce;
      }

      DistanceConstraint.prototype = new Constraint();

      DistanceConstraint.prototype.update = function () {
        var bodyA = this.bodyA;
        var bodyB = this.bodyB;
        var eq = this.distanceEquation;
        var halfDist = this.distance * 0.5;
        var normal = eq.ni;
        bodyB.position.vsub(bodyA.position, normal);
        normal.normalize();
        normal.mult(halfDist, eq.ri);
        normal.mult(-halfDist, eq.rj);
      };
    }, {
      "../equations/ContactEquation": 20,
      "./Constraint": 14
    }],
    16: [function (_dereq_, module, exports) {
      module.exports = HingeConstraint;

      var Constraint = _dereq_('./Constraint');

      var PointToPointConstraint = _dereq_('./PointToPointConstraint');

      var RotationalEquation = _dereq_('../equations/RotationalEquation');

      var RotationalMotorEquation = _dereq_('../equations/RotationalMotorEquation');

      var ContactEquation = _dereq_('../equations/ContactEquation');

      var Vec3 = _dereq_('../math/Vec3');
      /**
       * Hinge constraint. Think of it as a door hinge. It tries to keep the door in the correct place and with the correct orientation.
       * @class HingeConstraint
       * @constructor
       * @author schteppe
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {object} [options]
       * @param {Vec3} [options.pivotA] A point defined locally in bodyA. This defines the offset of axisA.
       * @param {Vec3} [options.axisA] An axis that bodyA can rotate around, defined locally in bodyA.
       * @param {Vec3} [options.pivotB]
       * @param {Vec3} [options.axisB]
       * @param {Number} [options.maxForce=1e6]
       * @extends PointToPointConstraint
       */


      function HingeConstraint(bodyA, bodyB, options) {
        options = options || {};
        var maxForce = typeof options.maxForce !== 'undefined' ? options.maxForce : 1e6;
        var pivotA = options.pivotA ? options.pivotA.clone() : new Vec3();
        var pivotB = options.pivotB ? options.pivotB.clone() : new Vec3();
        PointToPointConstraint.call(this, bodyA, pivotA, bodyB, pivotB, maxForce);
        /**
         * Rotation axis, defined locally in bodyA.
         * @property {Vec3} axisA
         */

        var axisA = this.axisA = options.axisA ? options.axisA.clone() : new Vec3(1, 0, 0);
        axisA.normalize();
        /**
         * Rotation axis, defined locally in bodyB.
         * @property {Vec3} axisB
         */

        var axisB = this.axisB = options.axisB ? options.axisB.clone() : new Vec3(1, 0, 0);
        axisB.normalize();
        /**
         * @property {RotationalEquation} rotationalEquation1
         */

        var r1 = this.rotationalEquation1 = new RotationalEquation(bodyA, bodyB, options);
        /**
         * @property {RotationalEquation} rotationalEquation2
         */

        var r2 = this.rotationalEquation2 = new RotationalEquation(bodyA, bodyB, options);
        /**
         * @property {RotationalMotorEquation} motorEquation
         */

        var motor = this.motorEquation = new RotationalMotorEquation(bodyA, bodyB, maxForce);
        motor.enabled = false; // Not enabled by default
        // Equations to be fed to the solver

        this.equations.push(r1, // rotational1
        r2, // rotational2
        motor);
      }

      HingeConstraint.prototype = new PointToPointConstraint();
      HingeConstraint.constructor = HingeConstraint;
      /**
       * @method enableMotor
       */

      HingeConstraint.prototype.enableMotor = function () {
        this.motorEquation.enabled = true;
      };
      /**
       * @method disableMotor
       */


      HingeConstraint.prototype.disableMotor = function () {
        this.motorEquation.enabled = false;
      };
      /**
       * @method setMotorSpeed
       * @param {number} speed
       */


      HingeConstraint.prototype.setMotorSpeed = function (speed) {
        this.motorEquation.targetVelocity = speed;
      };
      /**
       * @method setMotorMaxForce
       * @param {number} maxForce
       */


      HingeConstraint.prototype.setMotorMaxForce = function (maxForce) {
        this.motorEquation.maxForce = maxForce;
        this.motorEquation.minForce = -maxForce;
      };

      var HingeConstraint_update_tmpVec1 = new Vec3();
      var HingeConstraint_update_tmpVec2 = new Vec3();

      HingeConstraint.prototype.update = function () {
        var bodyA = this.bodyA,
            bodyB = this.bodyB,
            motor = this.motorEquation,
            r1 = this.rotationalEquation1,
            r2 = this.rotationalEquation2,
            worldAxisA = HingeConstraint_update_tmpVec1,
            worldAxisB = HingeConstraint_update_tmpVec2;
        var axisA = this.axisA;
        var axisB = this.axisB;
        PointToPointConstraint.prototype.update.call(this); // Get world axes

        bodyA.quaternion.vmult(axisA, worldAxisA);
        bodyB.quaternion.vmult(axisB, worldAxisB);
        worldAxisA.tangents(r1.axisA, r2.axisA);
        r1.axisB.copy(worldAxisB);
        r2.axisB.copy(worldAxisB);

        if (this.motorEquation.enabled) {
          bodyA.quaternion.vmult(this.axisA, motor.axisA);
          bodyB.quaternion.vmult(this.axisB, motor.axisB);
        }
      };
    }, {
      "../equations/ContactEquation": 20,
      "../equations/RotationalEquation": 23,
      "../equations/RotationalMotorEquation": 24,
      "../math/Vec3": 31,
      "./Constraint": 14,
      "./PointToPointConstraint": 18
    }],
    17: [function (_dereq_, module, exports) {
      module.exports = LockConstraint;

      var Constraint = _dereq_('./Constraint');

      var PointToPointConstraint = _dereq_('./PointToPointConstraint');

      var RotationalEquation = _dereq_('../equations/RotationalEquation');

      var RotationalMotorEquation = _dereq_('../equations/RotationalMotorEquation');

      var ContactEquation = _dereq_('../equations/ContactEquation');

      var Vec3 = _dereq_('../math/Vec3');
      /**
       * Lock constraint. Will remove all degrees of freedom between the bodies.
       * @class LockConstraint
       * @constructor
       * @author schteppe
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {object} [options]
       * @param {Number} [options.maxForce=1e6]
       * @extends PointToPointConstraint
       */


      function LockConstraint(bodyA, bodyB, options) {
        options = options || {};
        var maxForce = typeof options.maxForce !== 'undefined' ? options.maxForce : 1e6; // Set pivot point in between

        var pivotA = new Vec3();
        var pivotB = new Vec3();
        var halfWay = new Vec3();
        bodyA.position.vadd(bodyB.position, halfWay);
        halfWay.scale(0.5, halfWay);
        bodyB.pointToLocalFrame(halfWay, pivotB);
        bodyA.pointToLocalFrame(halfWay, pivotA); // The point-to-point constraint will keep a point shared between the bodies

        PointToPointConstraint.call(this, bodyA, pivotA, bodyB, pivotB, maxForce); // Store initial rotation of the bodies as unit vectors in the local body spaces

        this.xA = bodyA.vectorToLocalFrame(Vec3.UNIT_X);
        this.xB = bodyB.vectorToLocalFrame(Vec3.UNIT_X);
        this.yA = bodyA.vectorToLocalFrame(Vec3.UNIT_Y);
        this.yB = bodyB.vectorToLocalFrame(Vec3.UNIT_Y);
        this.zA = bodyA.vectorToLocalFrame(Vec3.UNIT_Z);
        this.zB = bodyB.vectorToLocalFrame(Vec3.UNIT_Z); // ...and the following rotational equations will keep all rotational DOF's in place

        /**
         * @property {RotationalEquation} rotationalEquation1
         */

        var r1 = this.rotationalEquation1 = new RotationalEquation(bodyA, bodyB, options);
        /**
         * @property {RotationalEquation} rotationalEquation2
         */

        var r2 = this.rotationalEquation2 = new RotationalEquation(bodyA, bodyB, options);
        /**
         * @property {RotationalEquation} rotationalEquation3
         */

        var r3 = this.rotationalEquation3 = new RotationalEquation(bodyA, bodyB, options);
        this.equations.push(r1, r2, r3);
      }

      LockConstraint.prototype = new PointToPointConstraint();
      LockConstraint.constructor = LockConstraint;
      var LockConstraint_update_tmpVec1 = new Vec3();
      var LockConstraint_update_tmpVec2 = new Vec3();

      LockConstraint.prototype.update = function () {
        var bodyA = this.bodyA,
            bodyB = this.bodyB,
            motor = this.motorEquation,
            r1 = this.rotationalEquation1,
            r2 = this.rotationalEquation2,
            r3 = this.rotationalEquation3,
            worldAxisA = LockConstraint_update_tmpVec1,
            worldAxisB = LockConstraint_update_tmpVec2;
        PointToPointConstraint.prototype.update.call(this); // These vector pairs must be orthogonal

        bodyA.vectorToWorldFrame(this.xA, r1.axisA);
        bodyB.vectorToWorldFrame(this.yB, r1.axisB);
        bodyA.vectorToWorldFrame(this.yA, r2.axisA);
        bodyB.vectorToWorldFrame(this.zB, r2.axisB);
        bodyA.vectorToWorldFrame(this.zA, r3.axisA);
        bodyB.vectorToWorldFrame(this.xB, r3.axisB);
      };
    }, {
      "../equations/ContactEquation": 20,
      "../equations/RotationalEquation": 23,
      "../equations/RotationalMotorEquation": 24,
      "../math/Vec3": 31,
      "./Constraint": 14,
      "./PointToPointConstraint": 18
    }],
    18: [function (_dereq_, module, exports) {
      module.exports = PointToPointConstraint;

      var Constraint = _dereq_('./Constraint');

      var ContactEquation = _dereq_('../equations/ContactEquation');

      var Vec3 = _dereq_('../math/Vec3');
      /**
       * Connects two bodies at given offset points.
       * @class PointToPointConstraint
       * @extends Constraint
       * @constructor
       * @param {Body} bodyA
       * @param {Vec3} pivotA The point relative to the center of mass of bodyA which bodyA is constrained to.
       * @param {Body} bodyB Body that will be constrained in a similar way to the same point as bodyA. We will therefore get a link between bodyA and bodyB. If not specified, bodyA will be constrained to a static point.
       * @param {Vec3} pivotB See pivotA.
       * @param {Number} maxForce The maximum force that should be applied to constrain the bodies.
       *
       * @example
       *     var bodyA = new Body({ mass: 1 });
       *     var bodyB = new Body({ mass: 1 });
       *     bodyA.position.set(-1, 0, 0);
       *     bodyB.position.set(1, 0, 0);
       *     bodyA.addShape(shapeA);
       *     bodyB.addShape(shapeB);
       *     world.addBody(bodyA);
       *     world.addBody(bodyB);
       *     var localPivotA = new Vec3(1, 0, 0);
       *     var localPivotB = new Vec3(-1, 0, 0);
       *     var constraint = new PointToPointConstraint(bodyA, localPivotA, bodyB, localPivotB);
       *     world.addConstraint(constraint);
       */


      function PointToPointConstraint(bodyA, pivotA, bodyB, pivotB, maxForce) {
        Constraint.call(this, bodyA, bodyB);
        maxForce = typeof maxForce !== 'undefined' ? maxForce : 1e6;
        /**
         * Pivot, defined locally in bodyA.
         * @property {Vec3} pivotA
         */

        this.pivotA = pivotA ? pivotA.clone() : new Vec3();
        /**
         * Pivot, defined locally in bodyB.
         * @property {Vec3} pivotB
         */

        this.pivotB = pivotB ? pivotB.clone() : new Vec3();
        /**
         * @property {ContactEquation} equationX
         */

        var x = this.equationX = new ContactEquation(bodyA, bodyB);
        /**
         * @property {ContactEquation} equationY
         */

        var y = this.equationY = new ContactEquation(bodyA, bodyB);
        /**
         * @property {ContactEquation} equationZ
         */

        var z = this.equationZ = new ContactEquation(bodyA, bodyB); // Equations to be fed to the solver

        this.equations.push(x, y, z); // Make the equations bidirectional

        x.minForce = y.minForce = z.minForce = -maxForce;
        x.maxForce = y.maxForce = z.maxForce = maxForce;
        x.ni.set(1, 0, 0);
        y.ni.set(0, 1, 0);
        z.ni.set(0, 0, 1);
      }

      PointToPointConstraint.prototype = new Constraint();

      PointToPointConstraint.prototype.update = function () {
        var bodyA = this.bodyA;
        var bodyB = this.bodyB;
        var x = this.equationX;
        var y = this.equationY;
        var z = this.equationZ; // Rotate the pivots to world space

        bodyA.quaternion.vmult(this.pivotA, x.ri);
        bodyB.quaternion.vmult(this.pivotB, x.rj);
        y.ri.copy(x.ri);
        y.rj.copy(x.rj);
        z.ri.copy(x.ri);
        z.rj.copy(x.rj);
      };
    }, {
      "../equations/ContactEquation": 20,
      "../math/Vec3": 31,
      "./Constraint": 14
    }],
    19: [function (_dereq_, module, exports) {
      module.exports = ConeEquation;

      var Vec3 = _dereq_('../math/Vec3');

      var Mat3 = _dereq_('../math/Mat3');

      var Equation = _dereq_('./Equation');
      /**
       * Cone equation. Works to keep the given body world vectors aligned, or tilted within a given angle from each other.
       * @class ConeEquation
       * @constructor
       * @author schteppe
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {Vec3} [options.axisA] Local axis in A
       * @param {Vec3} [options.axisB] Local axis in B
       * @param {Vec3} [options.angle] The "cone angle" to keep
       * @param {number} [options.maxForce=1e6]
       * @extends Equation
       */


      function ConeEquation(bodyA, bodyB, options) {
        options = options || {};
        var maxForce = typeof options.maxForce !== 'undefined' ? options.maxForce : 1e6;
        Equation.call(this, bodyA, bodyB, -maxForce, maxForce);
        this.axisA = options.axisA ? options.axisA.clone() : new Vec3(1, 0, 0);
        this.axisB = options.axisB ? options.axisB.clone() : new Vec3(0, 1, 0);
        /**
         * The cone angle to keep
         * @property {number} angle
         */

        this.angle = typeof options.angle !== 'undefined' ? options.angle : 0;
      }

      ConeEquation.prototype = new Equation();
      ConeEquation.prototype.constructor = ConeEquation;
      var tmpVec1 = new Vec3();
      var tmpVec2 = new Vec3();

      ConeEquation.prototype.computeB = function (h) {
        var a = this.a,
            b = this.b,
            ni = this.axisA,
            nj = this.axisB,
            nixnj = tmpVec1,
            njxni = tmpVec2,
            GA = this.jacobianElementA,
            GB = this.jacobianElementB; // Caluclate cross products

        ni.cross(nj, nixnj);
        nj.cross(ni, njxni); // The angle between two vector is:
        // cos(theta) = a * b / (length(a) * length(b) = { len(a) = len(b) = 1 } = a * b
        // g = a * b
        // gdot = (b x a) * wi + (a x b) * wj
        // G = [0 bxa 0 axb]
        // W = [vi wi vj wj]

        GA.rotational.copy(njxni);
        GB.rotational.copy(nixnj);
        var g = Math.cos(this.angle) - ni.dot(nj),
            GW = this.computeGW(),
            GiMf = this.computeGiMf();
        var B = -g * a - GW * b - h * GiMf;
        return B;
      };
    }, {
      "../math/Mat3": 28,
      "../math/Vec3": 31,
      "./Equation": 21
    }],
    20: [function (_dereq_, module, exports) {
      module.exports = ContactEquation;

      var Equation = _dereq_('./Equation');

      var Vec3 = _dereq_('../math/Vec3');

      var Mat3 = _dereq_('../math/Mat3');
      /**
       * Contact/non-penetration constraint equation
       * @class ContactEquation
       * @constructor
       * @author schteppe
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @extends Equation
       */


      function ContactEquation(bodyA, bodyB, maxForce) {
        maxForce = typeof maxForce !== 'undefined' ? maxForce : 1e6;
        Equation.call(this, bodyA, bodyB, 0, maxForce);
        /**
         * @property si
         * @type {Shape}
         */

        this.si = null;
        /**
         * @property sj
         * @type {Shape}
         */

        this.sj = null;
        /**
         * @property restitution
         * @type {Number}
         */

        this.restitution = 0.0; // "bounciness": u1 = -e*u0

        /**
         * World-oriented vector that goes from the center of bi to the contact point.
         * @property {Vec3} ri
         */

        this.ri = new Vec3();
        /**
         * World-oriented vector that starts in body j position and goes to the contact point.
         * @property {Vec3} rj
         */

        this.rj = new Vec3();
        /**
         * Contact normal, pointing out of body i.
         * @property {Vec3} ni
         */

        this.ni = new Vec3();
      }

      ContactEquation.prototype = new Equation();
      ContactEquation.prototype.constructor = ContactEquation;
      var ContactEquation_computeB_temp1 = new Vec3(); // Temp vectors

      var ContactEquation_computeB_temp2 = new Vec3();
      var ContactEquation_computeB_temp3 = new Vec3();

      ContactEquation.prototype.computeB = function (h) {
        var a = this.a,
            b = this.b,
            bi = this.bi,
            bj = this.bj,
            ri = this.ri,
            rj = this.rj,
            rixn = ContactEquation_computeB_temp1,
            rjxn = ContactEquation_computeB_temp2,
            vi = bi.velocity,
            wi = bi.angularVelocity,
            fi = bi.force,
            taui = bi.torque,
            vj = bj.velocity,
            wj = bj.angularVelocity,
            fj = bj.force,
            tauj = bj.torque,
            penetrationVec = ContactEquation_computeB_temp3,
            GA = this.jacobianElementA,
            GB = this.jacobianElementB,
            n = this.ni; // Caluclate cross products

        ri.cross(n, rixn);
        rj.cross(n, rjxn); // g = xj+rj -(xi+ri)
        // G = [ -ni  -rixn  ni  rjxn ]

        n.negate(GA.spatial);
        rixn.negate(GA.rotational);
        GB.spatial.copy(n);
        GB.rotational.copy(rjxn); // Calculate the penetration vector

        penetrationVec.copy(bj.position);
        penetrationVec.vadd(rj, penetrationVec);
        penetrationVec.vsub(bi.position, penetrationVec);
        penetrationVec.vsub(ri, penetrationVec);
        var g = n.dot(penetrationVec); // Compute iteration

        var ePlusOne = this.restitution + 1;
        var GW = ePlusOne * vj.dot(n) - ePlusOne * vi.dot(n) + wj.dot(rjxn) - wi.dot(rixn);
        var GiMf = this.computeGiMf();
        var B = -g * a - GW * b - h * GiMf;
        return B;
      };

      var ContactEquation_getImpactVelocityAlongNormal_vi = new Vec3();
      var ContactEquation_getImpactVelocityAlongNormal_vj = new Vec3();
      var ContactEquation_getImpactVelocityAlongNormal_xi = new Vec3();
      var ContactEquation_getImpactVelocityAlongNormal_xj = new Vec3();
      var ContactEquation_getImpactVelocityAlongNormal_relVel = new Vec3();
      /**
       * Get the current relative velocity in the contact point.
       * @method getImpactVelocityAlongNormal
       * @return {number}
       */

      ContactEquation.prototype.getImpactVelocityAlongNormal = function () {
        var vi = ContactEquation_getImpactVelocityAlongNormal_vi;
        var vj = ContactEquation_getImpactVelocityAlongNormal_vj;
        var xi = ContactEquation_getImpactVelocityAlongNormal_xi;
        var xj = ContactEquation_getImpactVelocityAlongNormal_xj;
        var relVel = ContactEquation_getImpactVelocityAlongNormal_relVel;
        this.bi.position.vadd(this.ri, xi);
        this.bj.position.vadd(this.rj, xj);
        this.bi.getVelocityAtWorldPoint(xi, vi);
        this.bj.getVelocityAtWorldPoint(xj, vj);
        vi.vsub(vj, relVel);
        return this.ni.dot(relVel);
      };
    }, {
      "../math/Mat3": 28,
      "../math/Vec3": 31,
      "./Equation": 21
    }],
    21: [function (_dereq_, module, exports) {
      module.exports = Equation;

      var JacobianElement = _dereq_('../math/JacobianElement'),
          Vec3 = _dereq_('../math/Vec3');
      /**
       * Equation base class
       * @class Equation
       * @constructor
       * @author schteppe
       * @param {Body} bi
       * @param {Body} bj
       * @param {Number} minForce Minimum (read: negative max) force to be applied by the constraint.
       * @param {Number} maxForce Maximum (read: positive max) force to be applied by the constraint.
       */


      function Equation(bi, bj, minForce, maxForce) {
        this.id = Equation.id++;
        /**
         * @property {number} minForce
         */

        this.minForce = typeof minForce === "undefined" ? -1e6 : minForce;
        /**
         * @property {number} maxForce
         */

        this.maxForce = typeof maxForce === "undefined" ? 1e6 : maxForce;
        /**
         * @property bi
         * @type {Body}
         */

        this.bi = bi;
        /**
         * @property bj
         * @type {Body}
         */

        this.bj = bj;
        /**
         * SPOOK parameter
         * @property {number} a
         */

        this.a = 0.0;
        /**
         * SPOOK parameter
         * @property {number} b
         */

        this.b = 0.0;
        /**
         * SPOOK parameter
         * @property {number} eps
         */

        this.eps = 0.0;
        /**
         * @property {JacobianElement} jacobianElementA
         */

        this.jacobianElementA = new JacobianElement();
        /**
         * @property {JacobianElement} jacobianElementB
         */

        this.jacobianElementB = new JacobianElement();
        /**
         * @property {boolean} enabled
         * @default true
         */

        this.enabled = true;
        /**
         * A number, proportional to the force added to the bodies.
         * @property {number} multiplier
         * @readonly
         */

        this.multiplier = 0; // Set typical spook params

        this.setSpookParams(1e7, 4, 1 / 60);
      }

      Equation.prototype.constructor = Equation;
      Equation.id = 0;
      /**
       * Recalculates a,b,eps.
       * @method setSpookParams
       */

      Equation.prototype.setSpookParams = function (stiffness, relaxation, timeStep) {
        var d = relaxation,
            k = stiffness,
            h = timeStep;
        this.a = 4.0 / (h * (1 + 4 * d));
        this.b = 4.0 * d / (1 + 4 * d);
        this.eps = 4.0 / (h * h * k * (1 + 4 * d));
      };
      /**
       * Computes the RHS of the SPOOK equation
       * @method computeB
       * @return {Number}
       */


      Equation.prototype.computeB = function (a, b, h) {
        var GW = this.computeGW(),
            Gq = this.computeGq(),
            GiMf = this.computeGiMf();
        return -Gq * a - GW * b - GiMf * h;
      };
      /**
       * Computes G*q, where q are the generalized body coordinates
       * @method computeGq
       * @return {Number}
       */


      Equation.prototype.computeGq = function () {
        var GA = this.jacobianElementA,
            GB = this.jacobianElementB,
            bi = this.bi,
            bj = this.bj,
            xi = bi.position,
            xj = bj.position;
        return GA.spatial.dot(xi) + GB.spatial.dot(xj);
      };

      var zero = new Vec3();
      /**
       * Computes G*W, where W are the body velocities
       * @method computeGW
       * @return {Number}
       */

      Equation.prototype.computeGW = function () {
        var GA = this.jacobianElementA,
            GB = this.jacobianElementB,
            bi = this.bi,
            bj = this.bj,
            vi = bi.velocity,
            vj = bj.velocity,
            wi = bi.angularVelocity,
            wj = bj.angularVelocity;
        return GA.multiplyVectors(vi, wi) + GB.multiplyVectors(vj, wj);
      };
      /**
       * Computes G*Wlambda, where W are the body velocities
       * @method computeGWlambda
       * @return {Number}
       */


      Equation.prototype.computeGWlambda = function () {
        var GA = this.jacobianElementA,
            GB = this.jacobianElementB,
            bi = this.bi,
            bj = this.bj,
            vi = bi.vlambda,
            vj = bj.vlambda,
            wi = bi.wlambda,
            wj = bj.wlambda;
        return GA.multiplyVectors(vi, wi) + GB.multiplyVectors(vj, wj);
      };
      /**
       * Computes G*inv(M)*f, where M is the mass matrix with diagonal blocks for each body, and f are the forces on the bodies.
       * @method computeGiMf
       * @return {Number}
       */


      var iMfi = new Vec3(),
          iMfj = new Vec3(),
          invIi_vmult_taui = new Vec3(),
          invIj_vmult_tauj = new Vec3();

      Equation.prototype.computeGiMf = function () {
        var GA = this.jacobianElementA,
            GB = this.jacobianElementB,
            bi = this.bi,
            bj = this.bj,
            fi = bi.force,
            ti = bi.torque,
            fj = bj.force,
            tj = bj.torque,
            invMassi = bi.invMassSolve,
            invMassj = bj.invMassSolve;
        fi.scale(invMassi, iMfi);
        fj.scale(invMassj, iMfj);
        bi.invInertiaWorldSolve.vmult(ti, invIi_vmult_taui);
        bj.invInertiaWorldSolve.vmult(tj, invIj_vmult_tauj);
        return GA.multiplyVectors(iMfi, invIi_vmult_taui) + GB.multiplyVectors(iMfj, invIj_vmult_tauj);
      };
      /**
       * Computes G*inv(M)*G'
       * @method computeGiMGt
       * @return {Number}
       */


      var tmp = new Vec3();

      Equation.prototype.computeGiMGt = function () {
        var GA = this.jacobianElementA,
            GB = this.jacobianElementB,
            bi = this.bi,
            bj = this.bj,
            invMassi = bi.invMassSolve,
            invMassj = bj.invMassSolve,
            invIi = bi.invInertiaWorldSolve,
            invIj = bj.invInertiaWorldSolve,
            result = invMassi + invMassj;
        invIi.vmult(GA.rotational, tmp);
        result += tmp.dot(GA.rotational);
        invIj.vmult(GB.rotational, tmp);
        result += tmp.dot(GB.rotational);
        return result;
      };

      var addToWlambda_temp = new Vec3(),
          addToWlambda_Gi = new Vec3(),
          addToWlambda_Gj = new Vec3(),
          addToWlambda_ri = new Vec3(),
          addToWlambda_rj = new Vec3(),
          addToWlambda_Mdiag = new Vec3();
      /**
       * Add constraint velocity to the bodies.
       * @method addToWlambda
       * @param {Number} deltalambda
       */

      Equation.prototype.addToWlambda = function (deltalambda) {
        var GA = this.jacobianElementA,
            GB = this.jacobianElementB,
            bi = this.bi,
            bj = this.bj,
            temp = addToWlambda_temp; // Add to linear velocity
        // v_lambda += inv(M) * delta_lamba * G

        bi.vlambda.addScaledVector(bi.invMassSolve * deltalambda, GA.spatial, bi.vlambda);
        bj.vlambda.addScaledVector(bj.invMassSolve * deltalambda, GB.spatial, bj.vlambda); // Add to angular velocity

        bi.invInertiaWorldSolve.vmult(GA.rotational, temp);
        bi.wlambda.addScaledVector(deltalambda, temp, bi.wlambda);
        bj.invInertiaWorldSolve.vmult(GB.rotational, temp);
        bj.wlambda.addScaledVector(deltalambda, temp, bj.wlambda);
      };
      /**
       * Compute the denominator part of the SPOOK equation: C = G*inv(M)*G' + eps
       * @method computeInvC
       * @param  {Number} eps
       * @return {Number}
       */


      Equation.prototype.computeC = function () {
        return this.computeGiMGt() + this.eps;
      };
    }, {
      "../math/JacobianElement": 27,
      "../math/Vec3": 31
    }],
    22: [function (_dereq_, module, exports) {
      module.exports = FrictionEquation;

      var Equation = _dereq_('./Equation');

      var Vec3 = _dereq_('../math/Vec3');

      var Mat3 = _dereq_('../math/Mat3');
      /**
       * Constrains the slipping in a contact along a tangent
       * @class FrictionEquation
       * @constructor
       * @author schteppe
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {Number} slipForce should be +-F_friction = +-mu * F_normal = +-mu * m * g
       * @extends Equation
       */


      function FrictionEquation(bodyA, bodyB, slipForce) {
        Equation.call(this, bodyA, bodyB, -slipForce, slipForce);
        this.ri = new Vec3();
        this.rj = new Vec3();
        this.t = new Vec3(); // tangent
      }

      FrictionEquation.prototype = new Equation();
      FrictionEquation.prototype.constructor = FrictionEquation;
      var FrictionEquation_computeB_temp1 = new Vec3();
      var FrictionEquation_computeB_temp2 = new Vec3();

      FrictionEquation.prototype.computeB = function (h) {
        var a = this.a,
            b = this.b,
            bi = this.bi,
            bj = this.bj,
            ri = this.ri,
            rj = this.rj,
            rixt = FrictionEquation_computeB_temp1,
            rjxt = FrictionEquation_computeB_temp2,
            t = this.t; // Caluclate cross products

        ri.cross(t, rixt);
        rj.cross(t, rjxt); // G = [-t -rixt t rjxt]
        // And remember, this is a pure velocity constraint, g is always zero!

        var GA = this.jacobianElementA,
            GB = this.jacobianElementB;
        t.negate(GA.spatial);
        rixt.negate(GA.rotational);
        GB.spatial.copy(t);
        GB.rotational.copy(rjxt);
        var GW = this.computeGW();
        var GiMf = this.computeGiMf();
        var B = -GW * b - h * GiMf;
        return B;
      };
    }, {
      "../math/Mat3": 28,
      "../math/Vec3": 31,
      "./Equation": 21
    }],
    23: [function (_dereq_, module, exports) {
      module.exports = RotationalEquation;

      var Vec3 = _dereq_('../math/Vec3');

      var Mat3 = _dereq_('../math/Mat3');

      var Equation = _dereq_('./Equation');
      /**
       * Rotational constraint. Works to keep the local vectors orthogonal to each other in world space.
       * @class RotationalEquation
       * @constructor
       * @author schteppe
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {Vec3} [options.axisA]
       * @param {Vec3} [options.axisB]
       * @param {number} [options.maxForce]
       * @extends Equation
       */


      function RotationalEquation(bodyA, bodyB, options) {
        options = options || {};
        var maxForce = typeof options.maxForce !== 'undefined' ? options.maxForce : 1e6;
        Equation.call(this, bodyA, bodyB, -maxForce, maxForce);
        this.axisA = options.axisA ? options.axisA.clone() : new Vec3(1, 0, 0);
        this.axisB = options.axisB ? options.axisB.clone() : new Vec3(0, 1, 0);
        this.maxAngle = Math.PI / 2;
      }

      RotationalEquation.prototype = new Equation();
      RotationalEquation.prototype.constructor = RotationalEquation;
      var tmpVec1 = new Vec3();
      var tmpVec2 = new Vec3();

      RotationalEquation.prototype.computeB = function (h) {
        var a = this.a,
            b = this.b,
            ni = this.axisA,
            nj = this.axisB,
            nixnj = tmpVec1,
            njxni = tmpVec2,
            GA = this.jacobianElementA,
            GB = this.jacobianElementB; // Caluclate cross products

        ni.cross(nj, nixnj);
        nj.cross(ni, njxni); // g = ni * nj
        // gdot = (nj x ni) * wi + (ni x nj) * wj
        // G = [0 njxni 0 nixnj]
        // W = [vi wi vj wj]

        GA.rotational.copy(njxni);
        GB.rotational.copy(nixnj);
        var g = Math.cos(this.maxAngle) - ni.dot(nj),
            GW = this.computeGW(),
            GiMf = this.computeGiMf();
        var B = -g * a - GW * b - h * GiMf;
        return B;
      };
    }, {
      "../math/Mat3": 28,
      "../math/Vec3": 31,
      "./Equation": 21
    }],
    24: [function (_dereq_, module, exports) {
      module.exports = RotationalMotorEquation;

      var Vec3 = _dereq_('../math/Vec3');

      var Mat3 = _dereq_('../math/Mat3');

      var Equation = _dereq_('./Equation');
      /**
       * Rotational motor constraint. Tries to keep the relative angular velocity of the bodies to a given value.
       * @class RotationalMotorEquation
       * @constructor
       * @author schteppe
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {Number} maxForce
       * @extends Equation
       */


      function RotationalMotorEquation(bodyA, bodyB, maxForce) {
        maxForce = typeof maxForce !== 'undefined' ? maxForce : 1e6;
        Equation.call(this, bodyA, bodyB, -maxForce, maxForce);
        /**
         * World oriented rotational axis
         * @property {Vec3} axisA
         */

        this.axisA = new Vec3();
        /**
         * World oriented rotational axis
         * @property {Vec3} axisB
         */

        this.axisB = new Vec3(); // World oriented rotational axis

        /**
         * Motor velocity
         * @property {Number} targetVelocity
         */

        this.targetVelocity = 0;
      }

      RotationalMotorEquation.prototype = new Equation();
      RotationalMotorEquation.prototype.constructor = RotationalMotorEquation;

      RotationalMotorEquation.prototype.computeB = function (h) {
        var a = this.a,
            b = this.b,
            bi = this.bi,
            bj = this.bj,
            axisA = this.axisA,
            axisB = this.axisB,
            GA = this.jacobianElementA,
            GB = this.jacobianElementB; // g = 0
        // gdot = axisA * wi - axisB * wj
        // gdot = G * W = G * [vi wi vj wj]
        // =>
        // G = [0 axisA 0 -axisB]

        GA.rotational.copy(axisA);
        axisB.negate(GB.rotational);
        var GW = this.computeGW() - this.targetVelocity,
            GiMf = this.computeGiMf();
        var B = -GW * b - h * GiMf;
        return B;
      };
    }, {
      "../math/Mat3": 28,
      "../math/Vec3": 31,
      "./Equation": 21
    }],
    25: [function (_dereq_, module, exports) {
      var Utils = _dereq_('../utils/Utils');

      module.exports = ContactMaterial;
      /**
       * Defines what happens when two materials meet.
       * @class ContactMaterial
       * @constructor
       * @param {Material} m1
       * @param {Material} m2
       * @param {object} [options]
       * @param {Number} [options.friction=0.3]
       * @param {Number} [options.restitution=0.3]
       * @param {number} [options.contactEquationStiffness=1e7]
       * @param {number} [options.contactEquationRelaxation=3]
       * @param {number} [options.frictionEquationStiffness=1e7]
       * @param {Number} [options.frictionEquationRelaxation=3]
       */

      function ContactMaterial(m1, m2, options) {
        options = Utils.defaults(options, {
          friction: 0.3,
          restitution: 0.3,
          contactEquationStiffness: 1e7,
          contactEquationRelaxation: 3,
          frictionEquationStiffness: 1e7,
          frictionEquationRelaxation: 3
        });
        /**
         * Identifier of this material
         * @property {Number} id
         */

        this.id = ContactMaterial.idCounter++;
        /**
         * Participating materials
         * @property {Array} materials
         * @todo  Should be .materialA and .materialB instead
         */

        this.materials = [m1, m2];
        /**
         * Friction coefficient
         * @property {Number} friction
         */

        this.friction = options.friction;
        /**
         * Restitution coefficient
         * @property {Number} restitution
         */

        this.restitution = options.restitution;
        /**
         * Stiffness of the produced contact equations
         * @property {Number} contactEquationStiffness
         */

        this.contactEquationStiffness = options.contactEquationStiffness;
        /**
         * Relaxation time of the produced contact equations
         * @property {Number} contactEquationRelaxation
         */

        this.contactEquationRelaxation = options.contactEquationRelaxation;
        /**
         * Stiffness of the produced friction equations
         * @property {Number} frictionEquationStiffness
         */

        this.frictionEquationStiffness = options.frictionEquationStiffness;
        /**
         * Relaxation time of the produced friction equations
         * @property {Number} frictionEquationRelaxation
         */

        this.frictionEquationRelaxation = options.frictionEquationRelaxation;
      }

      ContactMaterial.idCounter = 0;
    }, {
      "../utils/Utils": 54
    }],
    26: [function (_dereq_, module, exports) {
      module.exports = Material;
      /**
       * Defines a physics material.
       * @class Material
       * @constructor
       * @param {object} [options]
       * @author schteppe
       */

      function Material(options) {
        var name = '';
        options = options || {}; // Backwards compatibility fix

        if (typeof options === 'string') {
          name = options;
          options = {};
        } else if (typeof options === 'object') {
          name = '';
        }
        /**
         * @property name
         * @type {String}
         */


        this.name = name;
        /**
         * material id.
         * @property id
         * @type {number}
         */

        this.id = Material.idCounter++;
        /**
         * Friction for this material. If non-negative, it will be used instead of the friction given by ContactMaterials. If there's no matching ContactMaterial, the value from .defaultContactMaterial in the World will be used.
         * @property {number} friction
         */

        this.friction = typeof options.friction !== 'undefined' ? options.friction : -1;
        /**
         * Restitution for this material. If non-negative, it will be used instead of the restitution given by ContactMaterials. If there's no matching ContactMaterial, the value from .defaultContactMaterial in the World will be used.
         * @property {number} restitution
         */

        this.restitution = typeof options.restitution !== 'undefined' ? options.restitution : -1;
      }

      Material.idCounter = 0;
    }, {}],
    27: [function (_dereq_, module, exports) {
      module.exports = JacobianElement;

      var Vec3 = _dereq_('./Vec3');
      /**
       * An element containing 6 entries, 3 spatial and 3 rotational degrees of freedom.
       * @class JacobianElement
       * @constructor
       */


      function JacobianElement() {
        /**
         * @property {Vec3} spatial
         */
        this.spatial = new Vec3();
        /**
         * @property {Vec3} rotational
         */

        this.rotational = new Vec3();
      }
      /**
       * Multiply with other JacobianElement
       * @method multiplyElement
       * @param  {JacobianElement} element
       * @return {Number}
       */


      JacobianElement.prototype.multiplyElement = function (element) {
        return element.spatial.dot(this.spatial) + element.rotational.dot(this.rotational);
      };
      /**
       * Multiply with two vectors
       * @method multiplyVectors
       * @param  {Vec3} spatial
       * @param  {Vec3} rotational
       * @return {Number}
       */


      JacobianElement.prototype.multiplyVectors = function (spatial, rotational) {
        return spatial.dot(this.spatial) + rotational.dot(this.rotational);
      };
    }, {
      "./Vec3": 31
    }],
    28: [function (_dereq_, module, exports) {
      module.exports = Mat3;

      var Vec3 = _dereq_('./Vec3');
      /**
       * A 3x3 matrix.
       * @class Mat3
       * @constructor
       * @param array elements Array of nine elements. Optional.
       * @author schteppe / http://github.com/schteppe
       */


      function Mat3(elements) {
        /**
         * A vector of length 9, containing all matrix elements
         * @property {Array} elements
         */
        if (elements) {
          this.elements = elements;
        } else {
          this.elements = [0, 0, 0, 0, 0, 0, 0, 0, 0];
        }
      }
      /**
       * Sets the matrix to identity
       * @method identity
       * @todo Should perhaps be renamed to setIdentity() to be more clear.
       * @todo Create another function that immediately creates an identity matrix eg. eye()
       */


      Mat3.prototype.identity = function () {
        var e = this.elements;
        e[0] = 1;
        e[1] = 0;
        e[2] = 0;
        e[3] = 0;
        e[4] = 1;
        e[5] = 0;
        e[6] = 0;
        e[7] = 0;
        e[8] = 1;
      };
      /**
       * Set all elements to zero
       * @method setZero
       */


      Mat3.prototype.setZero = function () {
        var e = this.elements;
        e[0] = 0;
        e[1] = 0;
        e[2] = 0;
        e[3] = 0;
        e[4] = 0;
        e[5] = 0;
        e[6] = 0;
        e[7] = 0;
        e[8] = 0;
      };
      /**
       * Sets the matrix diagonal elements from a Vec3
       * @method setTrace
       * @param {Vec3} vec3
       */


      Mat3.prototype.setTrace = function (vec3) {
        var e = this.elements;
        e[0] = vec3.x;
        e[4] = vec3.y;
        e[8] = vec3.z;
      };
      /**
       * Gets the matrix diagonal elements
       * @method getTrace
       * @return {Vec3}
       */


      Mat3.prototype.getTrace = function (target) {
        var target = target || new Vec3();
        var e = this.elements;
        target.x = e[0];
        target.y = e[4];
        target.z = e[8];
      };
      /**
       * Matrix-Vector multiplication
       * @method vmult
       * @param {Vec3} v The vector to multiply with
       * @param {Vec3} target Optional, target to save the result in.
       */


      Mat3.prototype.vmult = function (v, target) {
        target = target || new Vec3();
        var e = this.elements,
            x = v.x,
            y = v.y,
            z = v.z;
        target.x = e[0] * x + e[1] * y + e[2] * z;
        target.y = e[3] * x + e[4] * y + e[5] * z;
        target.z = e[6] * x + e[7] * y + e[8] * z;
        return target;
      };
      /**
       * Matrix-scalar multiplication
       * @method smult
       * @param {Number} s
       */


      Mat3.prototype.smult = function (s) {
        for (var i = 0; i < this.elements.length; i++) {
          this.elements[i] *= s;
        }
      };
      /**
       * Matrix multiplication
       * @method mmult
       * @param {Mat3} m Matrix to multiply with from left side.
       * @return {Mat3} The result.
       */


      Mat3.prototype.mmult = function (m, target) {
        var r = target || new Mat3();

        for (var i = 0; i < 3; i++) {
          for (var j = 0; j < 3; j++) {
            var sum = 0.0;

            for (var k = 0; k < 3; k++) {
              sum += m.elements[i + k * 3] * this.elements[k + j * 3];
            }

            r.elements[i + j * 3] = sum;
          }
        }

        return r;
      };
      /**
       * Scale each column of the matrix
       * @method scale
       * @param {Vec3} v
       * @return {Mat3} The result.
       */


      Mat3.prototype.scale = function (v, target) {
        target = target || new Mat3();
        var e = this.elements,
            t = target.elements;

        for (var i = 0; i !== 3; i++) {
          t[3 * i + 0] = v.x * e[3 * i + 0];
          t[3 * i + 1] = v.y * e[3 * i + 1];
          t[3 * i + 2] = v.z * e[3 * i + 2];
        }

        return target;
      };
      /**
       * Solve Ax=b
       * @method solve
       * @param {Vec3} b The right hand side
       * @param {Vec3} target Optional. Target vector to save in.
       * @return {Vec3} The solution x
       * @todo should reuse arrays
       */


      Mat3.prototype.solve = function (b, target) {
        target = target || new Vec3(); // Construct equations

        var nr = 3; // num rows

        var nc = 4; // num cols

        var eqns = [];

        for (var i = 0; i < nr * nc; i++) {
          eqns.push(0);
        }

        var i, j;

        for (i = 0; i < 3; i++) {
          for (j = 0; j < 3; j++) {
            eqns[i + nc * j] = this.elements[i + 3 * j];
          }
        }

        eqns[3 + 4 * 0] = b.x;
        eqns[3 + 4 * 1] = b.y;
        eqns[3 + 4 * 2] = b.z; // Compute right upper triangular version of the matrix - Gauss elimination

        var n = 3,
            k = n,
            np;
        var kp = 4; // num rows

        var p, els;

        do {
          i = k - n;

          if (eqns[i + nc * i] === 0) {
            // the pivot is null, swap lines
            for (j = i + 1; j < k; j++) {
              if (eqns[i + nc * j] !== 0) {
                np = kp;

                do {
                  // do ligne( i ) = ligne( i ) + ligne( k )
                  p = kp - np;
                  eqns[p + nc * i] += eqns[p + nc * j];
                } while (--np);

                break;
              }
            }
          }

          if (eqns[i + nc * i] !== 0) {
            for (j = i + 1; j < k; j++) {
              var multiplier = eqns[i + nc * j] / eqns[i + nc * i];
              np = kp;

              do {
                // do ligne( k ) = ligne( k ) - multiplier * ligne( i )
                p = kp - np;
                eqns[p + nc * j] = p <= i ? 0 : eqns[p + nc * j] - eqns[p + nc * i] * multiplier;
              } while (--np);
            }
          }
        } while (--n); // Get the solution


        target.z = eqns[2 * nc + 3] / eqns[2 * nc + 2];
        target.y = (eqns[1 * nc + 3] - eqns[1 * nc + 2] * target.z) / eqns[1 * nc + 1];
        target.x = (eqns[0 * nc + 3] - eqns[0 * nc + 2] * target.z - eqns[0 * nc + 1] * target.y) / eqns[0 * nc + 0];

        if (isNaN(target.x) || isNaN(target.y) || isNaN(target.z) || target.x === Infinity || target.y === Infinity || target.z === Infinity) {
          throw "Could not solve equation! Got x=[" + target.toString() + "], b=[" + b.toString() + "], A=[" + this.toString() + "]";
        }

        return target;
      };
      /**
       * Get an element in the matrix by index. Index starts at 0, not 1!!!
       * @method e
       * @param {Number} row
       * @param {Number} column
       * @param {Number} value Optional. If provided, the matrix element will be set to this value.
       * @return {Number}
       */


      Mat3.prototype.e = function (row, column, value) {
        if (value === undefined) {
          return this.elements[column + 3 * row];
        } else {
          // Set value
          this.elements[column + 3 * row] = value;
        }
      };
      /**
       * Copy another matrix into this matrix object.
       * @method copy
       * @param {Mat3} source
       * @return {Mat3} this
       */


      Mat3.prototype.copy = function (source) {
        for (var i = 0; i < source.elements.length; i++) {
          this.elements[i] = source.elements[i];
        }

        return this;
      };
      /**
       * Returns a string representation of the matrix.
       * @method toString
       * @return string
       */


      Mat3.prototype.toString = function () {
        var r = "";
        var sep = ",";

        for (var i = 0; i < 9; i++) {
          r += this.elements[i] + sep;
        }

        return r;
      };
      /**
       * reverse the matrix
       * @method reverse
       * @param {Mat3} target Optional. Target matrix to save in.
       * @return {Mat3} The solution x
       */


      Mat3.prototype.reverse = function (target) {
        target = target || new Mat3(); // Construct equations

        var nr = 3; // num rows

        var nc = 6; // num cols

        var eqns = [];

        for (var i = 0; i < nr * nc; i++) {
          eqns.push(0);
        }

        var i, j;

        for (i = 0; i < 3; i++) {
          for (j = 0; j < 3; j++) {
            eqns[i + nc * j] = this.elements[i + 3 * j];
          }
        }

        eqns[3 + 6 * 0] = 1;
        eqns[3 + 6 * 1] = 0;
        eqns[3 + 6 * 2] = 0;
        eqns[4 + 6 * 0] = 0;
        eqns[4 + 6 * 1] = 1;
        eqns[4 + 6 * 2] = 0;
        eqns[5 + 6 * 0] = 0;
        eqns[5 + 6 * 1] = 0;
        eqns[5 + 6 * 2] = 1; // Compute right upper triangular version of the matrix - Gauss elimination

        var n = 3,
            k = n,
            np;
        var kp = nc; // num rows

        var p;

        do {
          i = k - n;

          if (eqns[i + nc * i] === 0) {
            // the pivot is null, swap lines
            for (j = i + 1; j < k; j++) {
              if (eqns[i + nc * j] !== 0) {
                np = kp;

                do {
                  // do line( i ) = line( i ) + line( k )
                  p = kp - np;
                  eqns[p + nc * i] += eqns[p + nc * j];
                } while (--np);

                break;
              }
            }
          }

          if (eqns[i + nc * i] !== 0) {
            for (j = i + 1; j < k; j++) {
              var multiplier = eqns[i + nc * j] / eqns[i + nc * i];
              np = kp;

              do {
                // do line( k ) = line( k ) - multiplier * line( i )
                p = kp - np;
                eqns[p + nc * j] = p <= i ? 0 : eqns[p + nc * j] - eqns[p + nc * i] * multiplier;
              } while (--np);
            }
          }
        } while (--n); // eliminate the upper left triangle of the matrix


        i = 2;

        do {
          j = i - 1;

          do {
            var multiplier = eqns[i + nc * j] / eqns[i + nc * i];
            np = nc;

            do {
              p = nc - np;
              eqns[p + nc * j] = eqns[p + nc * j] - eqns[p + nc * i] * multiplier;
            } while (--np);
          } while (j--);
        } while (--i); // operations on the diagonal


        i = 2;

        do {
          var multiplier = 1 / eqns[i + nc * i];
          np = nc;

          do {
            p = nc - np;
            eqns[p + nc * i] = eqns[p + nc * i] * multiplier;
          } while (--np);
        } while (i--);

        i = 2;

        do {
          j = 2;

          do {
            p = eqns[nr + j + nc * i];

            if (isNaN(p) || p === Infinity) {
              throw "Could not reverse! A=[" + this.toString() + "]";
            }

            target.e(i, j, p);
          } while (j--);
        } while (i--);

        return target;
      };
      /**
       * Set the matrix from a quaterion
       * @method setRotationFromQuaternion
       * @param {Quaternion} q
       */


      Mat3.prototype.setRotationFromQuaternion = function (q) {
        var x = q.x,
            y = q.y,
            z = q.z,
            w = q.w,
            x2 = x + x,
            y2 = y + y,
            z2 = z + z,
            xx = x * x2,
            xy = x * y2,
            xz = x * z2,
            yy = y * y2,
            yz = y * z2,
            zz = z * z2,
            wx = w * x2,
            wy = w * y2,
            wz = w * z2,
            e = this.elements;
        e[3 * 0 + 0] = 1 - (yy + zz);
        e[3 * 0 + 1] = xy - wz;
        e[3 * 0 + 2] = xz + wy;
        e[3 * 1 + 0] = xy + wz;
        e[3 * 1 + 1] = 1 - (xx + zz);
        e[3 * 1 + 2] = yz - wx;
        e[3 * 2 + 0] = xz - wy;
        e[3 * 2 + 1] = yz + wx;
        e[3 * 2 + 2] = 1 - (xx + yy);
        return this;
      };
      /**
       * Transpose the matrix
       * @method transpose
       * @param  {Mat3} target Where to store the result.
       * @return {Mat3} The target Mat3, or a new Mat3 if target was omitted.
       */


      Mat3.prototype.transpose = function (target) {
        target = target || new Mat3();
        var Mt = target.elements,
            M = this.elements;

        for (var i = 0; i !== 3; i++) {
          for (var j = 0; j !== 3; j++) {
            Mt[3 * i + j] = M[3 * j + i];
          }
        }

        return target;
      };
    }, {
      "./Vec3": 31
    }],
    29: [function (_dereq_, module, exports) {
      module.exports = Quaternion;

      var Vec3 = _dereq_('./Vec3');
      /**
       * A Quaternion describes a rotation in 3D space. The Quaternion is mathematically defined as Q = x*i + y*j + z*k + w, where (i,j,k) are imaginary basis vectors. (x,y,z) can be seen as a vector related to the axis of rotation, while the real multiplier, w, is related to the amount of rotation.
       * @class Quaternion
       * @constructor
       * @param {Number} x Multiplier of the imaginary basis vector i.
       * @param {Number} y Multiplier of the imaginary basis vector j.
       * @param {Number} z Multiplier of the imaginary basis vector k.
       * @param {Number} w Multiplier of the real part.
       * @see http://en.wikipedia.org/wiki/Quaternion
       */


      function Quaternion(x, y, z, w) {
        /**
         * @property {Number} x
         */
        this.x = x !== undefined ? x : 0;
        /**
         * @property {Number} y
         */

        this.y = y !== undefined ? y : 0;
        /**
         * @property {Number} z
         */

        this.z = z !== undefined ? z : 0;
        /**
         * The multiplier of the real quaternion basis vector.
         * @property {Number} w
         */

        this.w = w !== undefined ? w : 1;
      }
      /**
       * Set the value of the quaternion.
       * @method set
       * @param {Number} x
       * @param {Number} y
       * @param {Number} z
       * @param {Number} w
       */


      Quaternion.prototype.set = function (x, y, z, w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
      };
      /**
       * Convert to a readable format
       * @method toString
       * @return string
       */


      Quaternion.prototype.toString = function () {
        return this.x + "," + this.y + "," + this.z + "," + this.w;
      };
      /**
       * Convert to an Array
       * @method toArray
       * @return Array
       */


      Quaternion.prototype.toArray = function () {
        return [this.x, this.y, this.z, this.w];
      };
      /**
       * Set the quaternion components given an axis and an angle.
       * @method setFromAxisAngle
       * @param {Vec3} axis
       * @param {Number} angle in radians
       */


      Quaternion.prototype.setFromAxisAngle = function (axis, angle) {
        var s = Math.sin(angle * 0.5);
        this.x = axis.x * s;
        this.y = axis.y * s;
        this.z = axis.z * s;
        this.w = Math.cos(angle * 0.5);
        return this;
      };
      /**
       * Converts the quaternion to axis/angle representation.
       * @method toAxisAngle
       * @param {Vec3} [targetAxis] A vector object to reuse for storing the axis.
       * @return {Array} An array, first elemnt is the axis and the second is the angle in radians.
       */


      Quaternion.prototype.toAxisAngle = function (targetAxis) {
        targetAxis = targetAxis || new Vec3();
        this.normalize(); // if w>1 acos and sqrt will produce errors, this cant happen if quaternion is normalised

        var angle = 2 * Math.acos(this.w);
        var s = Math.sqrt(1 - this.w * this.w); // assuming quaternion normalised then w is less than 1, so term always positive.

        if (s < 0.001) {
          // test to avoid divide by zero, s is always positive due to sqrt
          // if s close to zero then direction of axis not important
          targetAxis.x = this.x; // if it is important that axis is normalised then replace with x=1; y=z=0;

          targetAxis.y = this.y;
          targetAxis.z = this.z;
        } else {
          targetAxis.x = this.x / s; // normalise axis

          targetAxis.y = this.y / s;
          targetAxis.z = this.z / s;
        }

        return [targetAxis, angle];
      };

      var sfv_t1 = new Vec3(),
          sfv_t2 = new Vec3();
      /**
       * Set the quaternion value given two vectors. The resulting rotation will be the needed rotation to rotate u to v.
       * @method setFromVectors
       * @param {Vec3} u
       * @param {Vec3} v
       */

      Quaternion.prototype.setFromVectors = function (u, v) {
        if (u.isAntiparallelTo(v)) {
          var t1 = sfv_t1;
          var t2 = sfv_t2;
          u.tangents(t1, t2);
          this.setFromAxisAngle(t1, Math.PI);
        } else {
          var a = u.cross(v);
          this.x = a.x;
          this.y = a.y;
          this.z = a.z;
          this.w = Math.sqrt(Math.pow(u.norm(), 2) * Math.pow(v.norm(), 2)) + u.dot(v);
          this.normalize();
        }

        return this;
      };
      /**
       * Quaternion multiplication
       * @method mult
       * @param {Quaternion} q
       * @param {Quaternion} target Optional.
       * @return {Quaternion}
       */


      var Quaternion_mult_va = new Vec3();
      var Quaternion_mult_vb = new Vec3();
      var Quaternion_mult_vaxvb = new Vec3();

      Quaternion.prototype.mult = function (q, target) {
        target = target || new Quaternion();
        var ax = this.x,
            ay = this.y,
            az = this.z,
            aw = this.w,
            bx = q.x,
            by = q.y,
            bz = q.z,
            bw = q.w;
        target.x = ax * bw + aw * bx + ay * bz - az * by;
        target.y = ay * bw + aw * by + az * bx - ax * bz;
        target.z = az * bw + aw * bz + ax * by - ay * bx;
        target.w = aw * bw - ax * bx - ay * by - az * bz;
        return target;
      };
      /**
       * Get the inverse quaternion rotation.
       * @method inverse
       * @param {Quaternion} target
       * @return {Quaternion}
       */


      Quaternion.prototype.inverse = function (target) {
        var x = this.x,
            y = this.y,
            z = this.z,
            w = this.w;
        target = target || new Quaternion();
        this.conjugate(target);
        var inorm2 = 1 / (x * x + y * y + z * z + w * w);
        target.x *= inorm2;
        target.y *= inorm2;
        target.z *= inorm2;
        target.w *= inorm2;
        return target;
      };
      /**
       * Get the quaternion conjugate
       * @method conjugate
       * @param {Quaternion} target
       * @return {Quaternion}
       */


      Quaternion.prototype.conjugate = function (target) {
        target = target || new Quaternion();
        target.x = -this.x;
        target.y = -this.y;
        target.z = -this.z;
        target.w = this.w;
        return target;
      };
      /**
       * Normalize the quaternion. Note that this changes the values of the quaternion.
       * @method normalize
       */


      Quaternion.prototype.normalize = function () {
        var l = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);

        if (l === 0) {
          this.x = 0;
          this.y = 0;
          this.z = 0;
          this.w = 0;
        } else {
          l = 1 / l;
          this.x *= l;
          this.y *= l;
          this.z *= l;
          this.w *= l;
        }

        return this;
      };
      /**
       * Approximation of quaternion normalization. Works best when quat is already almost-normalized.
       * @method normalizeFast
       * @see http://jsperf.com/fast-quaternion-normalization
       * @author unphased, https://github.com/unphased
       */


      Quaternion.prototype.normalizeFast = function () {
        var f = (3.0 - (this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w)) / 2.0;

        if (f === 0) {
          this.x = 0;
          this.y = 0;
          this.z = 0;
          this.w = 0;
        } else {
          this.x *= f;
          this.y *= f;
          this.z *= f;
          this.w *= f;
        }

        return this;
      };
      /**
       * Multiply the quaternion by a vector
       * @method vmult
       * @param {Vec3} v
       * @param {Vec3} target Optional
       * @return {Vec3}
       */


      Quaternion.prototype.vmult = function (v, target) {
        target = target || new Vec3();
        var x = v.x,
            y = v.y,
            z = v.z;
        var qx = this.x,
            qy = this.y,
            qz = this.z,
            qw = this.w; // q*v

        var ix = qw * x + qy * z - qz * y,
            iy = qw * y + qz * x - qx * z,
            iz = qw * z + qx * y - qy * x,
            iw = -qx * x - qy * y - qz * z;
        target.x = ix * qw + iw * -qx + iy * -qz - iz * -qy;
        target.y = iy * qw + iw * -qy + iz * -qx - ix * -qz;
        target.z = iz * qw + iw * -qz + ix * -qy - iy * -qx;
        return target;
      };
      /**
       * Copies value of source to this quaternion.
       * @method copy
       * @param {Quaternion} source
       * @return {Quaternion} this
       */


      Quaternion.prototype.copy = function (source) {
        this.x = source.x;
        this.y = source.y;
        this.z = source.z;
        this.w = source.w;
        return this;
      };
      /**
       * Convert the quaternion to euler angle representation. Order: YZX, as this page describes: http://www.euclideanspace.com/maths/standards/index.htm
       * @method toEuler
       * @param {Vec3} target
       * @param string order Three-character string e.g. "YZX", which also is default.
       */


      Quaternion.prototype.toEuler = function (target, order) {
        order = order || "YZX";
        var heading, attitude, bank;
        var x = this.x,
            y = this.y,
            z = this.z,
            w = this.w;

        switch (order) {
          case "YZX":
            var test = x * y + z * w;

            if (test > 0.499) {
              // singularity at north pole
              heading = 2 * Math.atan2(x, w);
              attitude = Math.PI / 2;
              bank = 0;
            }

            if (test < -0.499) {
              // singularity at south pole
              heading = -2 * Math.atan2(x, w);
              attitude = -Math.PI / 2;
              bank = 0;
            }

            if (isNaN(heading)) {
              var sqx = x * x;
              var sqy = y * y;
              var sqz = z * z;
              heading = Math.atan2(2 * y * w - 2 * x * z, 1 - 2 * sqy - 2 * sqz); // Heading

              attitude = Math.asin(2 * test); // attitude

              bank = Math.atan2(2 * x * w - 2 * y * z, 1 - 2 * sqx - 2 * sqz); // bank
            }

            break;

          default:
            throw new Error("Euler order " + order + " not supported yet.");
        }

        target.y = heading;
        target.z = attitude;
        target.x = bank;
      };
      /**
       * See http://www.mathworks.com/matlabcentral/fileexchange/20696-function-to-convert-between-dcm-euler-angles-quaternions-and-euler-vectors/content/SpinCalc.m
       * @method setFromEuler
       * @param {Number} x
       * @param {Number} y
       * @param {Number} z
       * @param {String} order The order to apply angles: 'XYZ' or 'YXZ' or any other combination
       */


      Quaternion.prototype.setFromEuler = function (x, y, z, order) {
        order = order || "XYZ";
        var c1 = Math.cos(x / 2);
        var c2 = Math.cos(y / 2);
        var c3 = Math.cos(z / 2);
        var s1 = Math.sin(x / 2);
        var s2 = Math.sin(y / 2);
        var s3 = Math.sin(z / 2);

        if (order === 'XYZ') {
          this.x = s1 * c2 * c3 + c1 * s2 * s3;
          this.y = c1 * s2 * c3 - s1 * c2 * s3;
          this.z = c1 * c2 * s3 + s1 * s2 * c3;
          this.w = c1 * c2 * c3 - s1 * s2 * s3;
        } else if (order === 'YXZ') {
          this.x = s1 * c2 * c3 + c1 * s2 * s3;
          this.y = c1 * s2 * c3 - s1 * c2 * s3;
          this.z = c1 * c2 * s3 - s1 * s2 * c3;
          this.w = c1 * c2 * c3 + s1 * s2 * s3;
        } else if (order === 'ZXY') {
          this.x = s1 * c2 * c3 - c1 * s2 * s3;
          this.y = c1 * s2 * c3 + s1 * c2 * s3;
          this.z = c1 * c2 * s3 + s1 * s2 * c3;
          this.w = c1 * c2 * c3 - s1 * s2 * s3;
        } else if (order === 'ZYX') {
          this.x = s1 * c2 * c3 - c1 * s2 * s3;
          this.y = c1 * s2 * c3 + s1 * c2 * s3;
          this.z = c1 * c2 * s3 - s1 * s2 * c3;
          this.w = c1 * c2 * c3 + s1 * s2 * s3;
        } else if (order === 'YZX') {
          this.x = s1 * c2 * c3 + c1 * s2 * s3;
          this.y = c1 * s2 * c3 + s1 * c2 * s3;
          this.z = c1 * c2 * s3 - s1 * s2 * c3;
          this.w = c1 * c2 * c3 - s1 * s2 * s3;
        } else if (order === 'XZY') {
          this.x = s1 * c2 * c3 - c1 * s2 * s3;
          this.y = c1 * s2 * c3 - s1 * c2 * s3;
          this.z = c1 * c2 * s3 + s1 * s2 * c3;
          this.w = c1 * c2 * c3 + s1 * s2 * s3;
        }

        return this;
      };
      /**
       * @method clone
       * @return {Quaternion}
       */


      Quaternion.prototype.clone = function () {
        return new Quaternion(this.x, this.y, this.z, this.w);
      };
      /**
       * Performs a spherical linear interpolation between two quat
       *
       * @method slerp
       * @param {Quaternion} toQuat second operand
       * @param {Number} t interpolation amount between the self quaternion and toQuat
       * @param {Quaternion} [target] A quaternion to store the result in. If not provided, a new one will be created.
       * @returns {Quaternion} The "target" object
       */


      Quaternion.prototype.slerp = function (toQuat, t, target) {
        target = target || new Quaternion();
        var ax = this.x,
            ay = this.y,
            az = this.z,
            aw = this.w,
            bx = toQuat.x,
            by = toQuat.y,
            bz = toQuat.z,
            bw = toQuat.w;
        var omega, cosom, sinom, scale0, scale1; // calc cosine

        cosom = ax * bx + ay * by + az * bz + aw * bw; // adjust signs (if necessary)

        if (cosom < 0.0) {
          cosom = -cosom;
          bx = -bx;
          by = -by;
          bz = -bz;
          bw = -bw;
        } // calculate coefficients


        if (1.0 - cosom > 0.000001) {
          // standard case (slerp)
          omega = Math.acos(cosom);
          sinom = Math.sin(omega);
          scale0 = Math.sin((1.0 - t) * omega) / sinom;
          scale1 = Math.sin(t * omega) / sinom;
        } else {
          // "from" and "to" quaternions are very close
          //  ... so we can do a linear interpolation
          scale0 = 1.0 - t;
          scale1 = t;
        } // calculate final values


        target.x = scale0 * ax + scale1 * bx;
        target.y = scale0 * ay + scale1 * by;
        target.z = scale0 * az + scale1 * bz;
        target.w = scale0 * aw + scale1 * bw;
        return target;
      };
      /**
       * Rotate an absolute orientation quaternion given an angular velocity and a time step.
       * @param  {Vec3} angularVelocity
       * @param  {number} dt
       * @param  {Vec3} angularFactor
       * @param  {Quaternion} target
       * @return {Quaternion} The "target" object
       */


      Quaternion.prototype.integrate = function (angularVelocity, dt, angularFactor, target) {
        target = target || new Quaternion();
        var ax = angularVelocity.x * angularFactor.x,
            ay = angularVelocity.y * angularFactor.y,
            az = angularVelocity.z * angularFactor.z,
            bx = this.x,
            by = this.y,
            bz = this.z,
            bw = this.w;
        var half_dt = dt * 0.5;
        target.x += half_dt * (ax * bw + ay * bz - az * by);
        target.y += half_dt * (ay * bw + az * bx - ax * bz);
        target.z += half_dt * (az * bw + ax * by - ay * bx);
        target.w += half_dt * (-ax * bx - ay * by - az * bz);
        return target;
      };
    }, {
      "./Vec3": 31
    }],
    30: [function (_dereq_, module, exports) {
      var Vec3 = _dereq_('./Vec3');

      var Quaternion = _dereq_('./Quaternion');

      module.exports = Transform;
      /**
       * @class Transform
       * @constructor
       */

      function Transform(options) {
        options = options || {};
        /**
         * @property {Vec3} position
         */

        this.position = new Vec3();

        if (options.position) {
          this.position.copy(options.position);
        }
        /**
         * @property {Quaternion} quaternion
         */


        this.quaternion = new Quaternion();

        if (options.quaternion) {
          this.quaternion.copy(options.quaternion);
        }
      }

      var tmpQuat = new Quaternion();
      /**
       * @static
       * @method pointToLocaFrame
       * @param {Vec3} position
       * @param {Quaternion} quaternion
       * @param {Vec3} worldPoint
       * @param {Vec3} result
       */

      Transform.pointToLocalFrame = function (position, quaternion, worldPoint, result) {
        var result = result || new Vec3();
        worldPoint.vsub(position, result);
        quaternion.conjugate(tmpQuat);
        tmpQuat.vmult(result, result);
        return result;
      };
      /**
       * Get a global point in local transform coordinates.
       * @method pointToLocal
       * @param  {Vec3} point
       * @param  {Vec3} result
       * @return {Vec3} The "result" vector object
       */


      Transform.prototype.pointToLocal = function (worldPoint, result) {
        return Transform.pointToLocalFrame(this.position, this.quaternion, worldPoint, result);
      };
      /**
       * @static
       * @method pointToWorldFrame
       * @param {Vec3} position
       * @param {Vec3} quaternion
       * @param {Vec3} localPoint
       * @param {Vec3} result
       */


      Transform.pointToWorldFrame = function (position, quaternion, localPoint, result) {
        var result = result || new Vec3();
        quaternion.vmult(localPoint, result);
        result.vadd(position, result);
        return result;
      };
      /**
       * Get a local point in global transform coordinates.
       * @method pointToWorld
       * @param  {Vec3} point
       * @param  {Vec3} result
       * @return {Vec3} The "result" vector object
       */


      Transform.prototype.pointToWorld = function (localPoint, result) {
        return Transform.pointToWorldFrame(this.position, this.quaternion, localPoint, result);
      };

      Transform.prototype.vectorToWorldFrame = function (localVector, result) {
        var result = result || new Vec3();
        this.quaternion.vmult(localVector, result);
        return result;
      };

      Transform.vectorToWorldFrame = function (quaternion, localVector, result) {
        quaternion.vmult(localVector, result);
        return result;
      };

      Transform.vectorToLocalFrame = function (position, quaternion, worldVector, result) {
        var result = result || new Vec3();
        quaternion.w *= -1;
        quaternion.vmult(worldVector, result);
        quaternion.w *= -1;
        return result;
      };
    }, {
      "./Quaternion": 29,
      "./Vec3": 31
    }],
    31: [function (_dereq_, module, exports) {
      module.exports = Vec3;

      var Mat3 = _dereq_('./Mat3');
      /**
       * 3-dimensional vector
       * @class Vec3
       * @constructor
       * @param {Number} x
       * @param {Number} y
       * @param {Number} z
       * @author schteppe
       * @example
       *     var v = new Vec3(1, 2, 3);
       *     console.log('x=' + v.x); // x=1
       */


      function Vec3(x, y, z) {
        /**
         * @property x
         * @type {Number}
         */
        this.x = x || 0.0;
        /**
         * @property y
         * @type {Number}
         */

        this.y = y || 0.0;
        /**
         * @property z
         * @type {Number}
         */

        this.z = z || 0.0;
      }
      /**
       * @static
       * @property {Vec3} ZERO
       */


      Vec3.ZERO = new Vec3(0, 0, 0);
      /**
       * @static
       * @property {Vec3} UNIT_X
       */

      Vec3.UNIT_X = new Vec3(1, 0, 0);
      /**
       * @static
       * @property {Vec3} UNIT_Y
       */

      Vec3.UNIT_Y = new Vec3(0, 1, 0);
      /**
       * @static
       * @property {Vec3} UNIT_Z
       */

      Vec3.UNIT_Z = new Vec3(0, 0, 1);
      /**
       * Vector cross product
       * @method cross
       * @param {Vec3} v
       * @param {Vec3} target Optional. Target to save in.
       * @return {Vec3}
       */

      Vec3.prototype.cross = function (v, target) {
        var vx = v.x,
            vy = v.y,
            vz = v.z,
            x = this.x,
            y = this.y,
            z = this.z;
        target = target || new Vec3();
        target.x = y * vz - z * vy;
        target.y = z * vx - x * vz;
        target.z = x * vy - y * vx;
        return target;
      };
      /**
       * Set the vectors' 3 elements
       * @method set
       * @param {Number} x
       * @param {Number} y
       * @param {Number} z
       * @return Vec3
       */


      Vec3.prototype.set = function (x, y, z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
      };
      /**
       * Set all components of the vector to zero.
       * @method setZero
       */


      Vec3.prototype.setZero = function () {
        this.x = this.y = this.z = 0;
      };
      /**
       * Vector addition
       * @method vadd
       * @param {Vec3} v
       * @param {Vec3} target Optional.
       * @return {Vec3}
       */


      Vec3.prototype.vadd = function (v, target) {
        if (target) {
          target.x = v.x + this.x;
          target.y = v.y + this.y;
          target.z = v.z + this.z;
        } else {
          return new Vec3(this.x + v.x, this.y + v.y, this.z + v.z);
        }
      };
      /**
       * Vector subtraction
       * @method vsub
       * @param {Vec3} v
       * @param {Vec3} target Optional. Target to save in.
       * @return {Vec3}
       */


      Vec3.prototype.vsub = function (v, target) {
        if (target) {
          target.x = this.x - v.x;
          target.y = this.y - v.y;
          target.z = this.z - v.z;
        } else {
          return new Vec3(this.x - v.x, this.y - v.y, this.z - v.z);
        }
      };
      /**
       * Get the cross product matrix a_cross from a vector, such that a x b = a_cross * b = c
       * @method crossmat
       * @see http://www8.cs.umu.se/kurser/TDBD24/VT06/lectures/Lecture6.pdf
       * @return {Mat3}
       */


      Vec3.prototype.crossmat = function () {
        return new Mat3([0, -this.z, this.y, this.z, 0, -this.x, -this.y, this.x, 0]);
      };
      /**
       * Normalize the vector. Note that this changes the values in the vector.
       * @method normalize
       * @return {Number} Returns the norm of the vector
       */


      Vec3.prototype.normalize = function () {
        var x = this.x,
            y = this.y,
            z = this.z;
        var n = Math.sqrt(x * x + y * y + z * z);

        if (n > 0.0) {
          var invN = 1 / n;
          this.x *= invN;
          this.y *= invN;
          this.z *= invN;
        } else {
          // Make something up
          this.x = 0;
          this.y = 0;
          this.z = 0;
        }

        return n;
      };
      /**
       * Get the version of this vector that is of length 1.
       * @method unit
       * @param {Vec3} target Optional target to save in
       * @return {Vec3} Returns the unit vector
       */


      Vec3.prototype.unit = function (target) {
        target = target || new Vec3();
        var x = this.x,
            y = this.y,
            z = this.z;
        var ninv = Math.sqrt(x * x + y * y + z * z);

        if (ninv > 0.0) {
          ninv = 1.0 / ninv;
          target.x = x * ninv;
          target.y = y * ninv;
          target.z = z * ninv;
        } else {
          target.x = 1;
          target.y = 0;
          target.z = 0;
        }

        return target;
      };
      /**
       * Get the length of the vector
       * @method norm
       * @return {Number}
       * @deprecated Use .length() instead
       */


      Vec3.prototype.norm = function () {
        var x = this.x,
            y = this.y,
            z = this.z;
        return Math.sqrt(x * x + y * y + z * z);
      };
      /**
       * Get the length of the vector
       * @method length
       * @return {Number}
       */


      Vec3.prototype.length = Vec3.prototype.norm;
      /**
       * Get the squared length of the vector
       * @method norm2
       * @return {Number}
       * @deprecated Use .lengthSquared() instead.
       */

      Vec3.prototype.norm2 = function () {
        return this.dot(this);
      };
      /**
       * Get the squared length of the vector.
       * @method lengthSquared
       * @return {Number}
       */


      Vec3.prototype.lengthSquared = Vec3.prototype.norm2;
      /**
       * Get distance from this point to another point
       * @method distanceTo
       * @param  {Vec3} p
       * @return {Number}
       */

      Vec3.prototype.distanceTo = function (p) {
        var x = this.x,
            y = this.y,
            z = this.z;
        var px = p.x,
            py = p.y,
            pz = p.z;
        return Math.sqrt((px - x) * (px - x) + (py - y) * (py - y) + (pz - z) * (pz - z));
      };
      /**
       * Get squared distance from this point to another point
       * @method distanceSquared
       * @param  {Vec3} p
       * @return {Number}
       */


      Vec3.prototype.distanceSquared = function (p) {
        var x = this.x,
            y = this.y,
            z = this.z;
        var px = p.x,
            py = p.y,
            pz = p.z;
        return (px - x) * (px - x) + (py - y) * (py - y) + (pz - z) * (pz - z);
      };
      /**
       * Multiply all the components of the vector with a scalar.
       * @deprecated Use .scale instead
       * @method mult
       * @param {Number} scalar
       * @param {Vec3} target The vector to save the result in.
       * @return {Vec3}
       * @deprecated Use .scale() instead
       */


      Vec3.prototype.mult = function (scalar, target) {
        target = target || new Vec3();
        var x = this.x,
            y = this.y,
            z = this.z;
        target.x = scalar * x;
        target.y = scalar * y;
        target.z = scalar * z;
        return target;
      };
      /**
       * Multiply the vector with an other vector, component-wise.
       * @method mult
       * @param {Number} vector
       * @param {Vec3} target The vector to save the result in.
       * @return {Vec3}
       */


      Vec3.prototype.vmul = function (vector, target) {
        target = target || new Vec3();
        target.x = vector.x * this.x;
        target.y = vector.y * this.y;
        target.z = vector.z * this.z;
        return target;
      };
      /**
       * Multiply the vector with a scalar.
       * @method scale
       * @param {Number} scalar
       * @param {Vec3} target
       * @return {Vec3}
       */


      Vec3.prototype.scale = Vec3.prototype.mult;
      /**
       * Scale a vector and add it to this vector. Save the result in "target". (target = this + vector * scalar)
       * @method addScaledVector
       * @param {Number} scalar
       * @param {Vec3} vector
       * @param {Vec3} target The vector to save the result in.
       * @return {Vec3}
       */

      Vec3.prototype.addScaledVector = function (scalar, vector, target) {
        target = target || new Vec3();
        target.x = this.x + scalar * vector.x;
        target.y = this.y + scalar * vector.y;
        target.z = this.z + scalar * vector.z;
        return target;
      };
      /**
       * Calculate dot product
       * @method dot
       * @param {Vec3} v
       * @return {Number}
       */


      Vec3.prototype.dot = function (v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
      };
      /**
       * @method isZero
       * @return bool
       */


      Vec3.prototype.isZero = function () {
        return this.x === 0 && this.y === 0 && this.z === 0;
      };
      /**
       * Make the vector point in the opposite direction.
       * @method negate
       * @param {Vec3} target Optional target to save in
       * @return {Vec3}
       */


      Vec3.prototype.negate = function (target) {
        target = target || new Vec3();
        target.x = -this.x;
        target.y = -this.y;
        target.z = -this.z;
        return target;
      };
      /**
       * Compute two artificial tangents to the vector
       * @method tangents
       * @param {Vec3} t1 Vector object to save the first tangent in
       * @param {Vec3} t2 Vector object to save the second tangent in
       */


      var Vec3_tangents_n = new Vec3();
      var Vec3_tangents_randVec = new Vec3();

      Vec3.prototype.tangents = function (t1, t2) {
        var norm = this.norm();

        if (norm > 0.0) {
          var n = Vec3_tangents_n;
          var inorm = 1 / norm;
          n.set(this.x * inorm, this.y * inorm, this.z * inorm);
          var randVec = Vec3_tangents_randVec;

          if (Math.abs(n.x) < 0.9) {
            randVec.set(1, 0, 0);
            n.cross(randVec, t1);
          } else {
            randVec.set(0, 1, 0);
            n.cross(randVec, t1);
          }

          n.cross(t1, t2);
        } else {
          // The normal length is zero, make something up
          t1.set(1, 0, 0);
          t2.set(0, 1, 0);
        }
      };
      /**
       * Converts to a more readable format
       * @method toString
       * @return string
       */


      Vec3.prototype.toString = function () {
        return this.x + "," + this.y + "," + this.z;
      };
      /**
       * Converts to an array
       * @method toArray
       * @return Array
       */


      Vec3.prototype.toArray = function () {
        return [this.x, this.y, this.z];
      };
      /**
       * Copies value of source to this vector.
       * @method copy
       * @param {Vec3} source
       * @return {Vec3} this
       */


      Vec3.prototype.copy = function (source) {
        this.x = source.x;
        this.y = source.y;
        this.z = source.z;
        return this;
      };
      /**
       * Do a linear interpolation between two vectors
       * @method lerp
       * @param {Vec3} v
       * @param {Number} t A number between 0 and 1. 0 will make this function return u, and 1 will make it return v. Numbers in between will generate a vector in between them.
       * @param {Vec3} target
       */


      Vec3.prototype.lerp = function (v, t, target) {
        var x = this.x,
            y = this.y,
            z = this.z;
        target.x = x + (v.x - x) * t;
        target.y = y + (v.y - y) * t;
        target.z = z + (v.z - z) * t;
      };
      /**
       * Check if a vector equals is almost equal to another one.
       * @method almostEquals
       * @param {Vec3} v
       * @param {Number} precision
       * @return bool
       */


      Vec3.prototype.almostEquals = function (v, precision) {
        if (precision === undefined) {
          precision = 1e-6;
        }

        if (Math.abs(this.x - v.x) > precision || Math.abs(this.y - v.y) > precision || Math.abs(this.z - v.z) > precision) {
          return false;
        }

        return true;
      };
      /**
       * Check if a vector is almost zero
       * @method almostZero
       * @param {Number} precision
       */


      Vec3.prototype.almostZero = function (precision) {
        if (precision === undefined) {
          precision = 1e-6;
        }

        if (Math.abs(this.x) > precision || Math.abs(this.y) > precision || Math.abs(this.z) > precision) {
          return false;
        }

        return true;
      };

      var antip_neg = new Vec3();
      /**
       * Check if the vector is anti-parallel to another vector.
       * @method isAntiparallelTo
       * @param  {Vec3}  v
       * @param  {Number}  precision Set to zero for exact comparisons
       * @return {Boolean}
       */

      Vec3.prototype.isAntiparallelTo = function (v, precision) {
        this.negate(antip_neg);
        return antip_neg.almostEquals(v, precision);
      };
      /**
       * Clone the vector
       * @method clone
       * @return {Vec3}
       */


      Vec3.prototype.clone = function () {
        return new Vec3(this.x, this.y, this.z);
      };
    }, {
      "./Mat3": 28
    }],
    32: [function (_dereq_, module, exports) {
      module.exports = Body;

      var EventTarget = _dereq_('../utils/EventTarget');

      var Shape = _dereq_('../shapes/Shape');

      var Vec3 = _dereq_('../math/Vec3');

      var Mat3 = _dereq_('../math/Mat3');

      var Quaternion = _dereq_('../math/Quaternion');

      var Material = _dereq_('../material/Material');

      var AABB = _dereq_('../collision/AABB');

      var Box = _dereq_('../shapes/Box');

      var World = _dereq_('../world/World');
      /**
       * Base class for all body types.
       * @class Body
       * @constructor
       * @extends EventTarget
       * @param {object} [options]
       * @param {Vec3} [options.position]
       * @param {Vec3} [options.velocity]
       * @param {Vec3} [options.angularVelocity]
       * @param {Quaternion} [options.quaternion]
       * @param {number} [options.mass]
       * @param {Material} [options.material]
       * @param {number} [options.type]
       * @param {number} [options.linearDamping=0.01]
       * @param {number} [options.angularDamping=0.01]
       * @param {boolean} [options.allowSleep=true]
       * @param {number} [options.sleepSpeedLimit=0.1]
       * @param {number} [options.sleepTimeLimit=1]
       * @param {number} [options.collisionFilterGroup=1]
       * @param {number} [options.collisionFilterMask=-1]
       * @param {boolean} [options.fixedRotation=false]
       * @param {Vec3} [options.linearFactor]
       * @param {Vec3} [options.angularFactor]
       * @param {Shape} [options.shape]
       * @example
       *     var body = new Body({
       *         mass: 1
       *     });
       *     var shape = new Sphere(1);
       *     body.addShape(shape);
       *     world.addBody(body);
       */


      function Body(options) {
        options = options || {};
        EventTarget.apply(this);
        this.id = Body.idCounter++;
        /**
         * Reference to the world the body is living in
         * @property world
         * @type {World}
         */

        this.world = null;
        /**
         * Callback function that is used BEFORE stepping the system. Use it to apply forces, for example. Inside the function, "this" will refer to this Body object.
         * @property preStep
         * @type {Function}
         * @deprecated Use World events instead
         */

        this.preStep = null;
        /**
         * Callback function that is used AFTER stepping the system. Inside the function, "this" will refer to this Body object.
         * @property postStep
         * @type {Function}
         * @deprecated Use World events instead
         */

        this.postStep = null;
        this.vlambda = new Vec3();
        /**
         * @property {Number} collisionFilterGroup
         */

        this.collisionFilterGroup = typeof options.collisionFilterGroup === 'number' ? options.collisionFilterGroup : 1;
        /**
         * @property {Number} collisionFilterMask
         */

        this.collisionFilterMask = typeof options.collisionFilterMask === 'number' ? options.collisionFilterMask : -1;
        /**
         * Whether to produce contact forces when in contact with other bodies. Note that contacts will be generated, but they will be disabled.
         * @property {Number} collisionResponse
         */

        this.collisionResponse = true;
        /**
         * World space position of the body.
         * @property position
         * @type {Vec3}
         */

        this.position = new Vec3();
        /**
         * @property {Vec3} previousPosition
         */

        this.previousPosition = new Vec3();
        /**
         * Interpolated position of the body.
         * @property {Vec3} interpolatedPosition
         */

        this.interpolatedPosition = new Vec3();
        /**
         * Initial position of the body
         * @property initPosition
         * @type {Vec3}
         */

        this.initPosition = new Vec3();

        if (options.position) {
          this.position.copy(options.position);
          this.previousPosition.copy(options.position);
          this.interpolatedPosition.copy(options.position);
          this.initPosition.copy(options.position);
        }
        /**
         * World space velocity of the body.
         * @property velocity
         * @type {Vec3}
         */


        this.velocity = new Vec3();

        if (options.velocity) {
          this.velocity.copy(options.velocity);
        }
        /**
         * @property initVelocity
         * @type {Vec3}
         */


        this.initVelocity = new Vec3();
        /**
         * Linear force on the body in world space.
         * @property force
         * @type {Vec3}
         */

        this.force = new Vec3();
        var mass = typeof options.mass === 'number' ? options.mass : 0;
        /**
         * @property mass
         * @type {Number}
         * @default 0
         */

        this.mass = mass;
        /**
         * @property invMass
         * @type {Number}
         */

        this.invMass = mass > 0 ? 1.0 / mass : 0;
        /**
         * @property material
         * @type {Material}
         */

        this.material = options.material || null;
        /**
         * @property linearDamping
         * @type {Number}
         */

        this.linearDamping = typeof options.linearDamping === 'number' ? options.linearDamping : 0.01;
        /**
         * One of: Body.DYNAMIC, Body.STATIC and Body.KINEMATIC.
         * @property type
         * @type {Number}
         */

        this.type = mass <= 0.0 ? Body.STATIC : Body.DYNAMIC;

        if (typeof options.type === typeof Body.STATIC) {
          this.type = options.type;
        }
        /**
         * If true, the body will automatically fall to sleep.
         * @property allowSleep
         * @type {Boolean}
         * @default true
         */


        this.allowSleep = typeof options.allowSleep !== 'undefined' ? options.allowSleep : true;
        /**
         * Current sleep state.
         * @property sleepState
         * @type {Number}
         */

        this.sleepState = 0;
        /**
         * If the speed (the norm of the velocity) is smaller than this value, the body is considered sleepy.
         * @property sleepSpeedLimit
         * @type {Number}
         * @default 0.1
         */

        this.sleepSpeedLimit = typeof options.sleepSpeedLimit !== 'undefined' ? options.sleepSpeedLimit : 0.1;
        /**
         * If the body has been sleepy for this sleepTimeLimit seconds, it is considered sleeping.
         * @property sleepTimeLimit
         * @type {Number}
         * @default 1
         */

        this.sleepTimeLimit = typeof options.sleepTimeLimit !== 'undefined' ? options.sleepTimeLimit : 1;
        this.timeLastSleepy = 0;
        this._wakeUpAfterNarrowphase = false;
        /**
         * World space rotational force on the body, around center of mass.
         * @property {Vec3} torque
         */

        this.torque = new Vec3();
        /**
         * World space orientation of the body.
         * @property quaternion
         * @type {Quaternion}
         */

        this.quaternion = new Quaternion();
        /**
         * @property initQuaternion
         * @type {Quaternion}
         */

        this.initQuaternion = new Quaternion();
        /**
         * @property {Quaternion} previousQuaternion
         */

        this.previousQuaternion = new Quaternion();
        /**
         * Interpolated orientation of the body.
         * @property {Quaternion} interpolatedQuaternion
         */

        this.interpolatedQuaternion = new Quaternion();

        if (options.quaternion) {
          this.quaternion.copy(options.quaternion);
          this.initQuaternion.copy(options.quaternion);
          this.previousQuaternion.copy(options.quaternion);
          this.interpolatedQuaternion.copy(options.quaternion);
        }
        /**
         * Angular velocity of the body, in world space. Think of the angular velocity as a vector, which the body rotates around. The length of this vector determines how fast (in radians per second) the body rotates.
         * @property angularVelocity
         * @type {Vec3}
         */


        this.angularVelocity = new Vec3();

        if (options.angularVelocity) {
          this.angularVelocity.copy(options.angularVelocity);
        }
        /**
         * @property initAngularVelocity
         * @type {Vec3}
         */


        this.initAngularVelocity = new Vec3();
        /**
         * @property shapes
         * @type {array}
         */

        this.shapes = [];
        /**
         * Position of each Shape in the body, given in local Body space.
         * @property shapeOffsets
         * @type {array}
         */

        this.shapeOffsets = [];
        /**
         * Orientation of each Shape, given in local Body space.
         * @property shapeOrientations
         * @type {array}
         */

        this.shapeOrientations = [];
        /**
         * @property inertia
         * @type {Vec3}
         */

        this.inertia = new Vec3();
        /**
         * @property {Vec3} invInertia
         */

        this.invInertia = new Vec3();
        /**
         * @property {Mat3} invInertiaWorld
         */

        this.invInertiaWorld = new Mat3();
        this.invMassSolve = 0;
        /**
         * @property {Vec3} invInertiaSolve
         */

        this.invInertiaSolve = new Vec3();
        /**
         * @property {Mat3} invInertiaWorldSolve
         */

        this.invInertiaWorldSolve = new Mat3();
        /**
         * Set to true if you don't want the body to rotate. Make sure to run .updateMassProperties() after changing this.
         * @property {Boolean} fixedRotation
         * @default false
         */

        this.fixedRotation = typeof options.fixedRotation !== "undefined" ? options.fixedRotation : false;
        /**
         * use gravity ?
         * @property {Boolean} useGravity
         * @default true
         */

        this.useGravity = true;
        /**
         * @property {Number} angularDamping
         */

        this.angularDamping = typeof options.angularDamping !== 'undefined' ? options.angularDamping : 0.01;
        /**
         * Use this property to limit the motion along any world axis. (1,1,1) will allow motion along all axes while (0,0,0) allows none.
         * @property {Vec3} linearFactor
         */

        this.linearFactor = new Vec3(1, 1, 1);

        if (options.linearFactor) {
          this.linearFactor.copy(options.linearFactor);
        }
        /**
         * Use this property to limit the rotational motion along any world axis. (1,1,1) will allow rotation along all axes while (0,0,0) allows none.
         * @property {Vec3} angularFactor
         */


        this.angularFactor = new Vec3(1, 1, 1);

        if (options.angularFactor) {
          this.angularFactor.copy(options.angularFactor);
        }
        /**
         * World space bounding box of the body and its shapes.
         * @property aabb
         * @type {AABB}
         */


        this.aabb = new AABB();
        /**
         * Indicates if the AABB needs to be updated before use.
         * @property aabbNeedsUpdate
         * @type {Boolean}
         */

        this.aabbNeedsUpdate = true;
        /**
         * Total bounding radius of the Body including its shapes, relative to body.position.
         * @property boundingRadius
         * @type {Number}
         */

        this.boundingRadius = 0;
        this.wlambda = new Vec3();

        if (options.shape) {
          this.addShape(options.shape);
        }
        /**
         * has trigger?
         */


        this.hasTrigger = true;
        this.updateMassProperties();
      }

      Body.prototype = new EventTarget();
      Body.prototype.constructor = Body;
      /**
       * Dispatched after two bodies collide. This event is dispatched on each
       * of the two bodies involved in the collision.
       * @event collide
       * @param {Body} body The body that was involved in the collision.
       * @param {ContactEquation} contact The details of the collision.
       */

      Body.COLLIDE_EVENT_NAME = "collide";
      /**
       * A dynamic body is fully simulated. Can be moved manually by the user, but normally they move according to forces. A dynamic body can collide with all body types. A dynamic body always has finite, non-zero mass.
       * @static
       * @property DYNAMIC
       * @type {Number}
       */

      Body.DYNAMIC = 1;
      /**
       * A static body does not move during simulation and behaves as if it has infinite mass. Static bodies can be moved manually by setting the position of the body. The velocity of a static body is always zero. Static bodies do not collide with other static or kinematic bodies.
       * @static
       * @property STATIC
       * @type {Number}
       */

      Body.STATIC = 2;
      /**
       * A kinematic body moves under simulation according to its velocity. They do not respond to forces. They can be moved manually, but normally a kinematic body is moved by setting its velocity. A kinematic body behaves as if it has infinite mass. Kinematic bodies do not collide with other static or kinematic bodies.
       * @static
       * @property KINEMATIC
       * @type {Number}
       */

      Body.KINEMATIC = 4;
      /**
       * @static
       * @property AWAKE
       * @type {number}
       */

      Body.AWAKE = 0;
      /**
       * @static
       * @property SLEEPY
       * @type {number}
       */

      Body.SLEEPY = 1;
      /**
       * @static
       * @property SLEEPING
       * @type {number}
       */

      Body.SLEEPING = 2;
      Body.idCounter = 0;
      /**
       * Dispatched after a sleeping body has woken up.
       * @event wakeup
       */

      Body.wakeupEvent = {
        type: "wakeup"
      };
      /**
       * Wake the body up.
       * @method wakeUp
       */

      Body.prototype.wakeUp = function () {
        var s = this.sleepState;
        this.sleepState = 0;
        this._wakeUpAfterNarrowphase = false;

        if (s === Body.SLEEPING) {
          this.dispatchEvent(Body.wakeupEvent);
        }
      };
      /**
       * Force body sleep
       * @method sleep
       */


      Body.prototype.sleep = function () {
        this.sleepState = Body.SLEEPING;
        this.velocity.set(0, 0, 0);
        this.angularVelocity.set(0, 0, 0);
        this._wakeUpAfterNarrowphase = false;
      };
      /**
       * Dispatched after a body has gone in to the sleepy state.
       * @event sleepy
       */


      Body.sleepyEvent = {
        type: "sleepy"
      };
      /**
       * Dispatched after a body has fallen asleep.
       * @event sleep
       */

      Body.sleepEvent = {
        type: "sleep"
      };
      /**
       * Called every timestep to update internal sleep timer and change sleep state if needed.
       * @method sleepTick
       * @param {Number} time The world time in seconds
       */

      Body.prototype.sleepTick = function (time) {
        if (this.allowSleep) {
          var sleepState = this.sleepState;
          var speedSquared = this.velocity.norm2() + this.angularVelocity.norm2();
          var speedLimitSquared = Math.pow(this.sleepSpeedLimit, 2);

          if (sleepState === Body.AWAKE && speedSquared < speedLimitSquared) {
            this.sleepState = Body.SLEEPY; // Sleepy

            this.timeLastSleepy = time;
            this.dispatchEvent(Body.sleepyEvent);
          } else if (sleepState === Body.SLEEPY && speedSquared > speedLimitSquared) {
            this.wakeUp(); // Wake up
          } else if (sleepState === Body.SLEEPY && time - this.timeLastSleepy > this.sleepTimeLimit) {
            this.sleep(); // Sleeping

            this.dispatchEvent(Body.sleepEvent);
          }
        }
      };
      /**
       * If the body is sleeping, it should be immovable / have infinite mass during solve. We solve it by having a separate "solve mass".
       * @method updateSolveMassProperties
       */


      Body.prototype.updateSolveMassProperties = function () {
        if (this.sleepState === Body.SLEEPING || this.type === Body.KINEMATIC) {
          this.invMassSolve = 0;
          this.invInertiaSolve.setZero();
          this.invInertiaWorldSolve.setZero();
        } else {
          this.invMassSolve = this.invMass;
          this.invInertiaSolve.copy(this.invInertia);
          this.invInertiaWorldSolve.copy(this.invInertiaWorld);
        }
      };
      /**
       * Convert a world point to local body frame.
       * @method pointToLocalFrame
       * @param  {Vec3} worldPoint
       * @param  {Vec3} result
       * @return {Vec3}
       */


      Body.prototype.pointToLocalFrame = function (worldPoint, result) {
        var result = result || new Vec3();
        worldPoint.vsub(this.position, result);
        this.quaternion.conjugate().vmult(result, result);
        return result;
      };
      /**
       * Convert a world vector to local body frame.
       * @method vectorToLocalFrame
       * @param  {Vec3} worldPoint
       * @param  {Vec3} result
       * @return {Vec3}
       */


      Body.prototype.vectorToLocalFrame = function (worldVector, result) {
        var result = result || new Vec3();
        this.quaternion.conjugate().vmult(worldVector, result);
        return result;
      };
      /**
       * Convert a local body point to world frame.
       * @method pointToWorldFrame
       * @param  {Vec3} localPoint
       * @param  {Vec3} result
       * @return {Vec3}
       */


      Body.prototype.pointToWorldFrame = function (localPoint, result) {
        var result = result || new Vec3();
        this.quaternion.vmult(localPoint, result);
        result.vadd(this.position, result);
        return result;
      };
      /**
       * Convert a local body point to world frame.
       * @method vectorToWorldFrame
       * @param  {Vec3} localVector
       * @param  {Vec3} result
       * @return {Vec3}
       */


      Body.prototype.vectorToWorldFrame = function (localVector, result) {
        var result = result || new Vec3();
        this.quaternion.vmult(localVector, result);
        return result;
      };

      var tmpVec = new Vec3();
      var tmpQuat = new Quaternion();
      /**
       * Add a shape to the body with a local offset and orientation.
       * @method addShape
       * @param {Shape} shape
       * @param {Vec3} [_offset]
       * @param {Quaternion} [_orientation]
       * @return {Body} The body object, for chainability.
       */

      Body.prototype.addShape = function (shape, _offset, _orientation) {
        var offset;
        var orientation;

        if (DEBUG) {
          offset = new Vec3();
          orientation = new Quaternion();

          if (_offset) {
            offset.copy(_offset);
          }

          if (_orientation) {
            orientation.copy(_orientation);
          }
        } else {
          offset = _offset;
          orientation = _orientation;

          if (!offset) {
            offset = new Vec3();
          }

          if (!orientation) {
            orientation = new Quaternion();
          }
        }

        World.idToShapeMap[shape.id] = shape;
        this.shapes.push(shape);
        this.shapeOffsets.push(offset);
        this.shapeOrientations.push(orientation);
        this.updateMassProperties();
        this.updateBoundingRadius();
        this.aabbNeedsUpdate = true;
        this.updateHasTrigger();
        shape.body = this;
        return this;
      };
      /**
       * Remove a shape from the body
       */


      Body.prototype.removeShape = function (shape) {
        var idx = this.shapes.indexOf(shape);

        if (idx === -1) {
          return;
        } // shape.body = null;  needed ?
        // delete World.idToShapeMap[shape.id];  needed ?


        this.shapes.splice(idx, 1);
        this.shapeOffsets.splice(idx, 1);
        this.shapeOrientations.splice(idx, 1);
        this.updateMassProperties();
        this.updateBoundingRadius();
        this.aabbNeedsUpdate = true;
        this.updateHasTrigger();
      };
      /**
       * Update the bounding radius of the body. Should be done if any of the shapes are changed.
       * @method updateBoundingRadius
       */


      Body.prototype.updateBoundingRadius = function () {
        var shapes = this.shapes,
            shapeOffsets = this.shapeOffsets,
            N = shapes.length,
            radius = 0;

        for (var i = 0; i !== N; i++) {
          var shape = shapes[i];
          shape.updateBoundingSphereRadius();
          var offset = shapeOffsets[i].norm(),
              r = shape.boundingSphereRadius;

          if (offset + r > radius) {
            radius = offset + r;
          }
        }

        this.boundingRadius = radius;
      };

      var computeAABB_shapeAABB = new AABB();
      /**
       * Updates the .aabb
       * @method computeAABB
       * @todo rename to updateAABB()
       */

      Body.prototype.computeAABB = function () {
        var shapes = this.shapes,
            shapeOffsets = this.shapeOffsets,
            shapeOrientations = this.shapeOrientations,
            N = shapes.length,
            offset = tmpVec,
            orientation = tmpQuat,
            bodyQuat = this.quaternion,
            aabb = this.aabb,
            shapeAABB = computeAABB_shapeAABB;

        for (var i = 0; i !== N; i++) {
          var shape = shapes[i]; // Get shape world position

          bodyQuat.vmult(shapeOffsets[i], offset);
          offset.vadd(this.position, offset); // Get shape world quaternion

          shapeOrientations[i].mult(bodyQuat, orientation); // Get shape AABB

          shape.calculateWorldAABB(offset, orientation, shapeAABB.lowerBound, shapeAABB.upperBound);

          if (i === 0) {
            aabb.copy(shapeAABB);
          } else {
            aabb.extend(shapeAABB);
          }
        }

        this.aabbNeedsUpdate = false;
      };

      var uiw_m1 = new Mat3(),
          uiw_m2 = new Mat3(),
          uiw_m3 = new Mat3();
      /**
       * Update .inertiaWorld and .invInertiaWorld
       * @method updateInertiaWorld
       */

      Body.prototype.updateInertiaWorld = function (force) {
        var I = this.invInertia;

        if (I.x === I.y && I.y === I.z && !force) {// If inertia M = s*I, where I is identity and s a scalar, then
          //    R*M*R' = R*(s*I)*R' = s*R*I*R' = s*R*R' = s*I = M
          // where R is the rotation matrix.
          // In other words, we don't have to transform the inertia if all
          // inertia diagonal entries are equal.
        } else {
          var m1 = uiw_m1,
              m2 = uiw_m2,
              m3 = uiw_m3;
          m1.setRotationFromQuaternion(this.quaternion);
          m1.transpose(m2);
          m1.scale(I, m1);
          m1.mmult(m2, this.invInertiaWorld);
        }
      };
      /**
       * Apply force to a world point. This could for example be a point on the Body surface. Applying force this way will add to Body.force and Body.torque.
       * @method applyForce
       * @param  {Vec3} force The amount of force to add.
       * @param  {Vec3} relativePoint A point relative to the center of mass to apply the force on.
       */
      // var Body_applyForce_r = new Vec3();


      var Body_applyForce_rotForce = new Vec3();

      Body.prototype.applyForce = function (force, relativePoint) {
        if (this.type !== Body.DYNAMIC) {
          // Needed?
          return;
        } // Compute produced rotational force


        var rotForce = Body_applyForce_rotForce;
        relativePoint.cross(force, rotForce); // Add linear force

        this.force.vadd(force, this.force); // Add rotational force

        this.torque.vadd(rotForce, this.torque);
      };
      /**
       * Apply force to a local point in the body.
       * @method applyLocalForce
       * @param  {Vec3} force The force vector to apply, defined locally in the body frame.
       * @param  {Vec3} localPoint A local point in the body to apply the force on.
       */


      var Body_applyLocalForce_worldForce = new Vec3();
      var Body_applyLocalForce_relativePointWorld = new Vec3();

      Body.prototype.applyLocalForce = function (localForce, localPoint) {
        if (this.type !== Body.DYNAMIC) {
          return;
        }

        var worldForce = Body_applyLocalForce_worldForce;
        var relativePointWorld = Body_applyLocalForce_relativePointWorld; // Transform the force vector to world space

        this.vectorToWorldFrame(localForce, worldForce);
        this.vectorToWorldFrame(localPoint, relativePointWorld);
        this.applyForce(worldForce, relativePointWorld);
      };
      /**
       * Apply impulse to a world point. This could for example be a point on the Body surface. An impulse is a force added to a body during a short period of time (impulse = force * time). Impulses will be added to Body.velocity and Body.angularVelocity.
       * @method applyImpulse
       * @param  {Vec3} impulse The amount of impulse to add.
       * @param  {Vec3} relativePoint A point relative to the center of mass to apply the force on.
       */
      // var Body_applyImpulse_r = new Vec3();


      var Body_applyImpulse_velo = new Vec3();
      var Body_applyImpulse_rotVelo = new Vec3();

      Body.prototype.applyImpulse = function (impulse, relativePoint) {
        if (this.type !== Body.DYNAMIC) {
          return;
        } // Compute point position relative to the body center


        var r = relativePoint; // Compute produced central impulse velocity

        var velo = Body_applyImpulse_velo;
        velo.copy(impulse);
        velo.mult(this.invMass, velo); // Add linear impulse

        this.velocity.vadd(velo, this.velocity); // Compute produced rotational impulse velocity

        var rotVelo = Body_applyImpulse_rotVelo;
        r.cross(impulse, rotVelo);
        /*
        rotVelo.x *= this.invInertia.x;
        rotVelo.y *= this.invInertia.y;
        rotVelo.z *= this.invInertia.z;
        */

        this.invInertiaWorld.vmult(rotVelo, rotVelo); // Add rotational Impulse

        this.angularVelocity.vadd(rotVelo, this.angularVelocity);
      };
      /**
       * Apply locally-defined impulse to a local point in the body.
       * @method applyLocalImpulse
       * @param  {Vec3} force The force vector to apply, defined locally in the body frame.
       * @param  {Vec3} localPoint A local point in the body to apply the force on.
       */


      var Body_applyLocalImpulse_worldImpulse = new Vec3();
      var Body_applyLocalImpulse_relativePoint = new Vec3();

      Body.prototype.applyLocalImpulse = function (localImpulse, localPoint) {
        if (this.type !== Body.DYNAMIC) {
          return;
        }

        var worldImpulse = Body_applyLocalImpulse_worldImpulse;
        var relativePointWorld = Body_applyLocalImpulse_relativePoint; // Transform the force vector to world space

        this.vectorToWorldFrame(localImpulse, worldImpulse);
        this.vectorToWorldFrame(localPoint, relativePointWorld);
        this.applyImpulse(worldImpulse, relativePointWorld);
      };

      var Body_updateMassProperties_halfExtents = new Vec3();
      /**
       * Should be called whenever you change the body shape or mass.
       * @method updateMassProperties
       */

      Body.prototype.updateMassProperties = function () {
        var halfExtents = Body_updateMassProperties_halfExtents;
        this.invMass = this.mass > 0 ? 1.0 / this.mass : 0;
        var I = this.inertia;
        var fixed = this.fixedRotation; // Approximate with AABB box

        this.computeAABB();
        halfExtents.set((this.aabb.upperBound.x - this.aabb.lowerBound.x) / 2, (this.aabb.upperBound.y - this.aabb.lowerBound.y) / 2, (this.aabb.upperBound.z - this.aabb.lowerBound.z) / 2);
        Box.calculateInertia(halfExtents, this.mass, I);
        this.invInertia.set(I.x > 0 && !fixed ? 1.0 / I.x : 0, I.y > 0 && !fixed ? 1.0 / I.y : 0, I.z > 0 && !fixed ? 1.0 / I.z : 0);
        this.updateInertiaWorld(true);
      };
      /**
       * Get world velocity of a point in the body.
       * @method getVelocityAtWorldPoint
       * @param  {Vec3} worldPoint
       * @param  {Vec3} result
       * @return {Vec3} The result vector.
       */


      Body.prototype.getVelocityAtWorldPoint = function (worldPoint, result) {
        var r = new Vec3();
        worldPoint.vsub(this.position, r);
        this.angularVelocity.cross(r, result);
        this.velocity.vadd(result, result);
        return result;
      }; // var torque = new Vec3();
      // var invI_tau_dt = new Vec3();
      // var w = new Quaternion();
      // var wq = new Quaternion();

      /**
       * Move the body forward in time.
       * @param {number} dt Time step
       * @param {boolean} quatNormalize Set to true to normalize the body quaternion
       * @param {boolean} quatNormalizeFast If the quaternion should be normalized using "fast" quaternion normalization
       */


      Body.prototype.integrate = function (dt, quatNormalize, quatNormalizeFast) {
        // Save previous position
        this.previousPosition.copy(this.position);
        this.previousQuaternion.copy(this.quaternion);

        if (!(this.type === Body.DYNAMIC || this.type === Body.KINEMATIC) || this.sleepState === Body.SLEEPING) {
          // Only for dynamic
          return;
        }

        var velo = this.velocity,
            angularVelo = this.angularVelocity,
            pos = this.position,
            force = this.force,
            torque = this.torque,
            quat = this.quaternion,
            invMass = this.invMass,
            invInertia = this.invInertiaWorld,
            linearFactor = this.linearFactor;
        var iMdt = invMass * dt;
        velo.x += force.x * iMdt * linearFactor.x;
        velo.y += force.y * iMdt * linearFactor.y;
        velo.z += force.z * iMdt * linearFactor.z;
        var e = invInertia.elements;
        var angularFactor = this.angularFactor;
        var tx = torque.x * angularFactor.x;
        var ty = torque.y * angularFactor.y;
        var tz = torque.z * angularFactor.z;
        angularVelo.x += dt * (e[0] * tx + e[1] * ty + e[2] * tz);
        angularVelo.y += dt * (e[3] * tx + e[4] * ty + e[5] * tz);
        angularVelo.z += dt * (e[6] * tx + e[7] * ty + e[8] * tz); // Use new velocity  - leap frog

        pos.x += velo.x * dt;
        pos.y += velo.y * dt;
        pos.z += velo.z * dt;
        quat.integrate(this.angularVelocity, dt, this.angularFactor, quat);

        if (quatNormalize) {
          if (quatNormalizeFast) {
            quat.normalizeFast();
          } else {
            quat.normalize();
          }
        }

        this.aabbNeedsUpdate = true; // Update world inertia

        this.updateInertiaWorld();
      };
      /**
       * Is Sleeping
       */


      Body.prototype.isSleeping = function () {
        return this.sleepState === Body.SLEEPING;
      };
      /**
       * Is Sleepy
       */


      Body.prototype.isSleepy = function () {
        return this.sleepState === Body.SLEEPY;
      };
      /**
       * Is Awake
       */


      Body.prototype.isAwake = function () {
        return this.sleepState === Body.AWAKE;
      };
      /**
       * Update hasTrigger
       */


      Body.prototype.updateHasTrigger = function () {
        for (var i = this.shapes.length; i--;) {
          this.hasTrigger = !this.shapes[i].collisionResponse;
          if (this.hasTrigger) break;
        }
      };
    }, {
      "../collision/AABB": 3,
      "../material/Material": 26,
      "../math/Mat3": 28,
      "../math/Quaternion": 29,
      "../math/Vec3": 31,
      "../shapes/Box": 38,
      "../shapes/Shape": 44,
      "../utils/EventTarget": 50,
      "../world/World": 57
    }],
    33: [function (_dereq_, module, exports) {
      var Body = _dereq_('./Body');

      var Vec3 = _dereq_('../math/Vec3');

      var Quaternion = _dereq_('../math/Quaternion');

      var RaycastResult = _dereq_('../collision/RaycastResult');

      var Ray = _dereq_('../collision/Ray');

      var WheelInfo = _dereq_('../objects/WheelInfo');

      module.exports = RaycastVehicle;
      /**
       * Vehicle helper class that casts rays from the wheel positions towards the ground and applies forces.
       * @class RaycastVehicle
       * @constructor
       * @param {object} [options]
       * @param {Body} [options.chassisBody] The car chassis body.
       * @param {integer} [options.indexRightAxis] Axis to use for right. x=0, y=1, z=2
       * @param {integer} [options.indexLeftAxis]
       * @param {integer} [options.indexUpAxis]
       */

      function RaycastVehicle(options) {
        /**
         * @property {Body} chassisBody
         */
        this.chassisBody = options.chassisBody;
        /**
         * An array of WheelInfo objects.
         * @property {array} wheelInfos
         */

        this.wheelInfos = [];
        /**
         * Will be set to true if the car is sliding.
         * @property {boolean} sliding
         */

        this.sliding = false;
        /**
         * @property {World} world
         */

        this.world = null;
        /**
         * Index of the right axis, 0=x, 1=y, 2=z
         * @property {integer} indexRightAxis
         * @default 1
         */

        this.indexRightAxis = typeof options.indexRightAxis !== 'undefined' ? options.indexRightAxis : 1;
        /**
         * Index of the forward axis, 0=x, 1=y, 2=z
         * @property {integer} indexForwardAxis
         * @default 0
         */

        this.indexForwardAxis = typeof options.indexForwardAxis !== 'undefined' ? options.indexForwardAxis : 0;
        /**
         * Index of the up axis, 0=x, 1=y, 2=z
         * @property {integer} indexUpAxis
         * @default 2
         */

        this.indexUpAxis = typeof options.indexUpAxis !== 'undefined' ? options.indexUpAxis : 2;
      }

      var tmpVec1 = new Vec3();
      var tmpVec2 = new Vec3();
      var tmpVec3 = new Vec3();
      var tmpVec4 = new Vec3();
      var tmpVec5 = new Vec3();
      var tmpVec6 = new Vec3();
      var tmpRay = new Ray();
      /**
       * Add a wheel. For information about the options, see WheelInfo.
       * @method addWheel
       * @param {object} [options]
       */

      RaycastVehicle.prototype.addWheel = function (options) {
        options = options || {};
        var info = new WheelInfo(options);
        var index = this.wheelInfos.length;
        this.wheelInfos.push(info);
        return index;
      };
      /**
       * Set the steering value of a wheel.
       * @method setSteeringValue
       * @param {number} value
       * @param {integer} wheelIndex
       */


      RaycastVehicle.prototype.setSteeringValue = function (value, wheelIndex) {
        var wheel = this.wheelInfos[wheelIndex];
        wheel.steering = value;
      };

      var torque = new Vec3();
      /**
       * Set the wheel force to apply on one of the wheels each time step
       * @method applyEngineForce
       * @param  {number} value
       * @param  {integer} wheelIndex
       */

      RaycastVehicle.prototype.applyEngineForce = function (value, wheelIndex) {
        this.wheelInfos[wheelIndex].engineForce = value;
      };
      /**
       * Set the braking force of a wheel
       * @method setBrake
       * @param {number} brake
       * @param {integer} wheelIndex
       */


      RaycastVehicle.prototype.setBrake = function (brake, wheelIndex) {
        this.wheelInfos[wheelIndex].brake = brake;
      };
      /**
       * Add the vehicle including its constraints to the world.
       * @method addToWorld
       * @param {World} world
       */


      RaycastVehicle.prototype.addToWorld = function (world) {
        var constraints = this.constraints;
        world.addBody(this.chassisBody);
        var that = this;

        this.preStepCallback = function () {
          that.updateVehicle(world.dt);
        };

        world.addEventListener('preStep', this.preStepCallback);
        this.world = world;
      };
      /**
       * Get one of the wheel axles, world-oriented.
       * @private
       * @method getVehicleAxisWorld
       * @param  {integer} axisIndex
       * @param  {Vec3} result
       */


      RaycastVehicle.prototype.getVehicleAxisWorld = function (axisIndex, result) {
        result.set(axisIndex === 0 ? 1 : 0, axisIndex === 1 ? 1 : 0, axisIndex === 2 ? 1 : 0);
        this.chassisBody.vectorToWorldFrame(result, result);
      };

      RaycastVehicle.prototype.updateVehicle = function (timeStep) {
        var wheelInfos = this.wheelInfos;
        var numWheels = wheelInfos.length;
        var chassisBody = this.chassisBody;

        for (var i = 0; i < numWheels; i++) {
          this.updateWheelTransform(i);
        }

        this.currentVehicleSpeedKmHour = 3.6 * chassisBody.velocity.norm();
        var forwardWorld = new Vec3();
        this.getVehicleAxisWorld(this.indexForwardAxis, forwardWorld);

        if (forwardWorld.dot(chassisBody.velocity) < 0) {
          this.currentVehicleSpeedKmHour *= -1;
        } // simulate suspension


        for (var i = 0; i < numWheels; i++) {
          this.castRay(wheelInfos[i]);
        }

        this.updateSuspension(timeStep);
        var impulse = new Vec3();
        var relpos = new Vec3();

        for (var i = 0; i < numWheels; i++) {
          //apply suspension force
          var wheel = wheelInfos[i];
          var suspensionForce = wheel.suspensionForce;

          if (suspensionForce > wheel.maxSuspensionForce) {
            suspensionForce = wheel.maxSuspensionForce;
          }

          wheel.raycastResult.hitNormalWorld.scale(suspensionForce * timeStep, impulse);
          wheel.raycastResult.hitPointWorld.vsub(chassisBody.position, relpos);
          chassisBody.applyImpulse(impulse, relpos);
        }

        this.updateFriction(timeStep);
        var hitNormalWorldScaledWithProj = new Vec3();
        var fwd = new Vec3();
        var vel = new Vec3();

        for (i = 0; i < numWheels; i++) {
          var wheel = wheelInfos[i]; //var relpos = new Vec3();
          //wheel.chassisConnectionPointWorld.vsub(chassisBody.position, relpos);

          chassisBody.getVelocityAtWorldPoint(wheel.chassisConnectionPointWorld, vel); // Hack to get the rotation in the correct direction

          var m = 1;

          switch (this.indexUpAxis) {
            case 1:
              m = -1;
              break;
          }

          if (wheel.isInContact) {
            this.getVehicleAxisWorld(this.indexForwardAxis, fwd);
            var proj = fwd.dot(wheel.raycastResult.hitNormalWorld);
            wheel.raycastResult.hitNormalWorld.scale(proj, hitNormalWorldScaledWithProj);
            fwd.vsub(hitNormalWorldScaledWithProj, fwd);
            var proj2 = fwd.dot(vel);
            wheel.deltaRotation = m * proj2 * timeStep / wheel.radius;
          }

          if ((wheel.sliding || !wheel.isInContact) && wheel.engineForce !== 0 && wheel.useCustomSlidingRotationalSpeed) {
            // Apply custom rotation when accelerating and sliding
            wheel.deltaRotation = (wheel.engineForce > 0 ? 1 : -1) * wheel.customSlidingRotationalSpeed * timeStep;
          } // Lock wheels


          if (Math.abs(wheel.brake) > Math.abs(wheel.engineForce)) {
            wheel.deltaRotation = 0;
          }

          wheel.rotation += wheel.deltaRotation; // Use the old value

          wheel.deltaRotation *= 0.99; // damping of rotation when not in contact
        }
      };

      RaycastVehicle.prototype.updateSuspension = function (deltaTime) {
        var chassisBody = this.chassisBody;
        var chassisMass = chassisBody.mass;
        var wheelInfos = this.wheelInfos;
        var numWheels = wheelInfos.length;

        for (var w_it = 0; w_it < numWheels; w_it++) {
          var wheel = wheelInfos[w_it];

          if (wheel.isInContact) {
            var force; // Spring

            var susp_length = wheel.suspensionRestLength;
            var current_length = wheel.suspensionLength;
            var length_diff = susp_length - current_length;
            force = wheel.suspensionStiffness * length_diff * wheel.clippedInvContactDotSuspension; // Damper

            var projected_rel_vel = wheel.suspensionRelativeVelocity;
            var susp_damping;

            if (projected_rel_vel < 0) {
              susp_damping = wheel.dampingCompression;
            } else {
              susp_damping = wheel.dampingRelaxation;
            }

            force -= susp_damping * projected_rel_vel;
            wheel.suspensionForce = force * chassisMass;

            if (wheel.suspensionForce < 0) {
              wheel.suspensionForce = 0;
            }
          } else {
            wheel.suspensionForce = 0;
          }
        }
      };
      /**
       * Remove the vehicle including its constraints from the world.
       * @method removeFromWorld
       * @param {World} world
       */


      RaycastVehicle.prototype.removeFromWorld = function (world) {
        var constraints = this.constraints;
        world.remove(this.chassisBody);
        world.removeEventListener('preStep', this.preStepCallback);
        this.world = null;
      };

      var castRay_rayvector = new Vec3();
      var castRay_target = new Vec3();

      RaycastVehicle.prototype.castRay = function (wheel) {
        var rayvector = castRay_rayvector;
        var target = castRay_target;
        this.updateWheelTransformWorld(wheel);
        var chassisBody = this.chassisBody;
        var depth = -1;
        var raylen = wheel.suspensionRestLength + wheel.radius;
        wheel.directionWorld.scale(raylen, rayvector);
        var source = wheel.chassisConnectionPointWorld;
        source.vadd(rayvector, target);
        var raycastResult = wheel.raycastResult;
        var param = 0;
        raycastResult.reset(); // Turn off ray collision with the chassis temporarily

        var oldState = chassisBody.collisionResponse;
        chassisBody.collisionResponse = false; // Cast ray against world

        this.world.rayTest(source, target, raycastResult);
        chassisBody.collisionResponse = oldState;
        var object = raycastResult.body;
        wheel.raycastResult.groundObject = 0;

        if (object) {
          depth = raycastResult.distance;
          wheel.raycastResult.hitNormalWorld = raycastResult.hitNormalWorld;
          wheel.isInContact = true;
          var hitDistance = raycastResult.distance;
          wheel.suspensionLength = hitDistance - wheel.radius; // clamp on max suspension travel

          var minSuspensionLength = wheel.suspensionRestLength - wheel.maxSuspensionTravel;
          var maxSuspensionLength = wheel.suspensionRestLength + wheel.maxSuspensionTravel;

          if (wheel.suspensionLength < minSuspensionLength) {
            wheel.suspensionLength = minSuspensionLength;
          }

          if (wheel.suspensionLength > maxSuspensionLength) {
            wheel.suspensionLength = maxSuspensionLength;
            wheel.raycastResult.reset();
          }

          var denominator = wheel.raycastResult.hitNormalWorld.dot(wheel.directionWorld);
          var chassis_velocity_at_contactPoint = new Vec3();
          chassisBody.getVelocityAtWorldPoint(wheel.raycastResult.hitPointWorld, chassis_velocity_at_contactPoint);
          var projVel = wheel.raycastResult.hitNormalWorld.dot(chassis_velocity_at_contactPoint);

          if (denominator >= -0.1) {
            wheel.suspensionRelativeVelocity = 0;
            wheel.clippedInvContactDotSuspension = 1 / 0.1;
          } else {
            var inv = -1 / denominator;
            wheel.suspensionRelativeVelocity = projVel * inv;
            wheel.clippedInvContactDotSuspension = inv;
          }
        } else {
          //put wheel info as in rest position
          wheel.suspensionLength = wheel.suspensionRestLength + 0 * wheel.maxSuspensionTravel;
          wheel.suspensionRelativeVelocity = 0.0;
          wheel.directionWorld.scale(-1, wheel.raycastResult.hitNormalWorld);
          wheel.clippedInvContactDotSuspension = 1.0;
        }

        return depth;
      };

      RaycastVehicle.prototype.updateWheelTransformWorld = function (wheel) {
        wheel.isInContact = false;
        var chassisBody = this.chassisBody;
        chassisBody.pointToWorldFrame(wheel.chassisConnectionPointLocal, wheel.chassisConnectionPointWorld);
        chassisBody.vectorToWorldFrame(wheel.directionLocal, wheel.directionWorld);
        chassisBody.vectorToWorldFrame(wheel.axleLocal, wheel.axleWorld);
      };
      /**
       * Update one of the wheel transform.
       * Note when rendering wheels: during each step, wheel transforms are updated BEFORE the chassis; ie. their position becomes invalid after the step. Thus when you render wheels, you must update wheel transforms before rendering them. See raycastVehicle demo for an example.
       * @method updateWheelTransform
       * @param {integer} wheelIndex The wheel index to update.
       */


      RaycastVehicle.prototype.updateWheelTransform = function (wheelIndex) {
        var up = tmpVec4;
        var right = tmpVec5;
        var fwd = tmpVec6;
        var wheel = this.wheelInfos[wheelIndex];
        this.updateWheelTransformWorld(wheel);
        wheel.directionLocal.scale(-1, up);
        right.copy(wheel.axleLocal);
        up.cross(right, fwd);
        fwd.normalize();
        right.normalize(); // Rotate around steering over the wheelAxle

        var steering = wheel.steering;
        var steeringOrn = new Quaternion();
        steeringOrn.setFromAxisAngle(up, steering);
        var rotatingOrn = new Quaternion();
        rotatingOrn.setFromAxisAngle(right, wheel.rotation); // World rotation of the wheel

        var q = wheel.worldTransform.quaternion;
        this.chassisBody.quaternion.mult(steeringOrn, q);
        q.mult(rotatingOrn, q);
        q.normalize(); // world position of the wheel

        var p = wheel.worldTransform.position;
        p.copy(wheel.directionWorld);
        p.scale(wheel.suspensionLength, p);
        p.vadd(wheel.chassisConnectionPointWorld, p);
      };

      var directions = [new Vec3(1, 0, 0), new Vec3(0, 1, 0), new Vec3(0, 0, 1)];
      /**
       * Get the world transform of one of the wheels
       * @method getWheelTransformWorld
       * @param  {integer} wheelIndex
       * @return {Transform}
       */

      RaycastVehicle.prototype.getWheelTransformWorld = function (wheelIndex) {
        return this.wheelInfos[wheelIndex].worldTransform;
      };

      var updateFriction_surfNormalWS_scaled_proj = new Vec3();
      var updateFriction_axle = [];
      var updateFriction_forwardWS = [];
      var sideFrictionStiffness2 = 1;

      RaycastVehicle.prototype.updateFriction = function (timeStep) {
        var surfNormalWS_scaled_proj = updateFriction_surfNormalWS_scaled_proj; //calculate the impulse, so that the wheels don't move sidewards

        var wheelInfos = this.wheelInfos;
        var numWheels = wheelInfos.length;
        var chassisBody = this.chassisBody;
        var forwardWS = updateFriction_forwardWS;
        var axle = updateFriction_axle;
        var numWheelsOnGround = 0;

        for (var i = 0; i < numWheels; i++) {
          var wheel = wheelInfos[i];
          var groundObject = wheel.raycastResult.body;

          if (groundObject) {
            numWheelsOnGround++;
          }

          wheel.sideImpulse = 0;
          wheel.forwardImpulse = 0;

          if (!forwardWS[i]) {
            forwardWS[i] = new Vec3();
          }

          if (!axle[i]) {
            axle[i] = new Vec3();
          }
        }

        for (var i = 0; i < numWheels; i++) {
          var wheel = wheelInfos[i];
          var groundObject = wheel.raycastResult.body;

          if (groundObject) {
            var axlei = axle[i];
            var wheelTrans = this.getWheelTransformWorld(i); // Get world axle

            wheelTrans.vectorToWorldFrame(directions[this.indexRightAxis], axlei);
            var surfNormalWS = wheel.raycastResult.hitNormalWorld;
            var proj = axlei.dot(surfNormalWS);
            surfNormalWS.scale(proj, surfNormalWS_scaled_proj);
            axlei.vsub(surfNormalWS_scaled_proj, axlei);
            axlei.normalize();
            surfNormalWS.cross(axlei, forwardWS[i]);
            forwardWS[i].normalize();
            wheel.sideImpulse = resolveSingleBilateral(chassisBody, wheel.raycastResult.hitPointWorld, groundObject, wheel.raycastResult.hitPointWorld, axlei);
            wheel.sideImpulse *= sideFrictionStiffness2;
          }
        }

        var sideFactor = 1;
        var fwdFactor = 0.5;
        this.sliding = false;

        for (var i = 0; i < numWheels; i++) {
          var wheel = wheelInfos[i];
          var groundObject = wheel.raycastResult.body;
          var rollingFriction = 0;
          wheel.slipInfo = 1;

          if (groundObject) {
            var defaultRollingFrictionImpulse = 0;
            var maxImpulse = wheel.brake ? wheel.brake : defaultRollingFrictionImpulse; // btWheelContactPoint contactPt(chassisBody,groundObject,wheelInfraycastInfo.hitPointWorld,forwardWS[wheel],maxImpulse);
            // rollingFriction = calcRollingFriction(contactPt);

            rollingFriction = calcRollingFriction(chassisBody, groundObject, wheel.raycastResult.hitPointWorld, forwardWS[i], maxImpulse);
            rollingFriction += wheel.engineForce * timeStep; // rollingFriction = 0;

            var factor = maxImpulse / rollingFriction;
            wheel.slipInfo *= factor;
          } //switch between active rolling (throttle), braking and non-active rolling friction (nthrottle/break)


          wheel.forwardImpulse = 0;
          wheel.skidInfo = 1;

          if (groundObject) {
            wheel.skidInfo = 1;
            var maximp = wheel.suspensionForce * timeStep * wheel.frictionSlip;
            var maximpSide = maximp;
            var maximpSquared = maximp * maximpSide;
            wheel.forwardImpulse = rollingFriction; //wheelInfo.engineForce* timeStep;

            var x = wheel.forwardImpulse * fwdFactor;
            var y = wheel.sideImpulse * sideFactor;
            var impulseSquared = x * x + y * y;
            wheel.sliding = false;

            if (impulseSquared > maximpSquared) {
              this.sliding = true;
              wheel.sliding = true;
              var factor = maximp / Math.sqrt(impulseSquared);
              wheel.skidInfo *= factor;
            }
          }
        }

        if (this.sliding) {
          for (var i = 0; i < numWheels; i++) {
            var wheel = wheelInfos[i];

            if (wheel.sideImpulse !== 0) {
              if (wheel.skidInfo < 1) {
                wheel.forwardImpulse *= wheel.skidInfo;
                wheel.sideImpulse *= wheel.skidInfo;
              }
            }
          }
        } // apply the impulses


        for (var i = 0; i < numWheels; i++) {
          var wheel = wheelInfos[i];
          var rel_pos = new Vec3();
          wheel.raycastResult.hitPointWorld.vsub(chassisBody.position, rel_pos); // cannons applyimpulse is using world coord for the position
          //rel_pos.copy(wheel.raycastResult.hitPointWorld);

          if (wheel.forwardImpulse !== 0) {
            var impulse = new Vec3();
            forwardWS[i].scale(wheel.forwardImpulse, impulse);
            chassisBody.applyImpulse(impulse, rel_pos);
          }

          if (wheel.sideImpulse !== 0) {
            var groundObject = wheel.raycastResult.body;
            var rel_pos2 = new Vec3();
            wheel.raycastResult.hitPointWorld.vsub(groundObject.position, rel_pos2); //rel_pos2.copy(wheel.raycastResult.hitPointWorld);

            var sideImp = new Vec3();
            axle[i].scale(wheel.sideImpulse, sideImp); // Scale the relative position in the up direction with rollInfluence.
            // If rollInfluence is 1, the impulse will be applied on the hitPoint (easy to roll over), if it is zero it will be applied in the same plane as the center of mass (not easy to roll over).

            chassisBody.vectorToLocalFrame(rel_pos, rel_pos);
            rel_pos['xyz'[this.indexUpAxis]] *= wheel.rollInfluence;
            chassisBody.vectorToWorldFrame(rel_pos, rel_pos);
            chassisBody.applyImpulse(sideImp, rel_pos); //apply friction impulse on the ground

            sideImp.scale(-1, sideImp);
            groundObject.applyImpulse(sideImp, rel_pos2);
          }
        }
      };

      var calcRollingFriction_vel1 = new Vec3();
      var calcRollingFriction_vel2 = new Vec3();
      var calcRollingFriction_vel = new Vec3();

      function calcRollingFriction(body0, body1, frictionPosWorld, frictionDirectionWorld, maxImpulse) {
        var j1 = 0;
        var contactPosWorld = frictionPosWorld; // var rel_pos1 = new Vec3();
        // var rel_pos2 = new Vec3();

        var vel1 = calcRollingFriction_vel1;
        var vel2 = calcRollingFriction_vel2;
        var vel = calcRollingFriction_vel; // contactPosWorld.vsub(body0.position, rel_pos1);
        // contactPosWorld.vsub(body1.position, rel_pos2);

        body0.getVelocityAtWorldPoint(contactPosWorld, vel1);
        body1.getVelocityAtWorldPoint(contactPosWorld, vel2);
        vel1.vsub(vel2, vel);
        var vrel = frictionDirectionWorld.dot(vel);
        var denom0 = computeImpulseDenominator(body0, frictionPosWorld, frictionDirectionWorld);
        var denom1 = computeImpulseDenominator(body1, frictionPosWorld, frictionDirectionWorld);
        var relaxation = 1;
        var jacDiagABInv = relaxation / (denom0 + denom1); // calculate j that moves us to zero relative velocity

        j1 = -vrel * jacDiagABInv;

        if (maxImpulse < j1) {
          j1 = maxImpulse;
        }

        if (j1 < -maxImpulse) {
          j1 = -maxImpulse;
        }

        return j1;
      }

      var computeImpulseDenominator_r0 = new Vec3();
      var computeImpulseDenominator_c0 = new Vec3();
      var computeImpulseDenominator_vec = new Vec3();
      var computeImpulseDenominator_m = new Vec3();

      function computeImpulseDenominator(body, pos, normal) {
        var r0 = computeImpulseDenominator_r0;
        var c0 = computeImpulseDenominator_c0;
        var vec = computeImpulseDenominator_vec;
        var m = computeImpulseDenominator_m;
        pos.vsub(body.position, r0);
        r0.cross(normal, c0);
        body.invInertiaWorld.vmult(c0, m);
        m.cross(r0, vec);
        return body.invMass + normal.dot(vec);
      }

      var resolveSingleBilateral_vel1 = new Vec3();
      var resolveSingleBilateral_vel2 = new Vec3();
      var resolveSingleBilateral_vel = new Vec3(); //bilateral constraint between two dynamic objects

      function resolveSingleBilateral(body1, pos1, body2, pos2, normal, impulse) {
        var normalLenSqr = normal.norm2();

        if (normalLenSqr > 1.1) {
          return 0; // no impulse
        } // var rel_pos1 = new Vec3();
        // var rel_pos2 = new Vec3();
        // pos1.vsub(body1.position, rel_pos1);
        // pos2.vsub(body2.position, rel_pos2);


        var vel1 = resolveSingleBilateral_vel1;
        var vel2 = resolveSingleBilateral_vel2;
        var vel = resolveSingleBilateral_vel;
        body1.getVelocityAtWorldPoint(pos1, vel1);
        body2.getVelocityAtWorldPoint(pos2, vel2);
        vel1.vsub(vel2, vel);
        var rel_vel = normal.dot(vel);
        var contactDamping = 0.2;
        var massTerm = 1 / (body1.invMass + body2.invMass);
        var impulse = -contactDamping * rel_vel * massTerm;
        return impulse;
      }
    }, {
      "../collision/Ray": 10,
      "../collision/RaycastResult": 11,
      "../math/Quaternion": 29,
      "../math/Vec3": 31,
      "../objects/WheelInfo": 37,
      "./Body": 32
    }],
    34: [function (_dereq_, module, exports) {
      var Body = _dereq_('./Body');

      var Sphere = _dereq_('../shapes/Sphere');

      var Box = _dereq_('../shapes/Box');

      var Vec3 = _dereq_('../math/Vec3');

      var HingeConstraint = _dereq_('../constraints/HingeConstraint');

      module.exports = RigidVehicle;
      /**
       * Simple vehicle helper class with spherical rigid body wheels.
       * @class RigidVehicle
       * @constructor
       * @param {Body} [options.chassisBody]
       */

      function RigidVehicle(options) {
        this.wheelBodies = [];
        /**
         * @property coordinateSystem
         * @type {Vec3}
         */

        this.coordinateSystem = typeof options.coordinateSystem === 'undefined' ? new Vec3(1, 2, 3) : options.coordinateSystem.clone();
        /**
         * @property {Body} chassisBody
         */

        this.chassisBody = options.chassisBody;

        if (!this.chassisBody) {
          // No chassis body given. Create it!
          var chassisShape = new Box(new Vec3(5, 2, 0.5));
          this.chassisBody = new Body(1, chassisShape);
        }
        /**
         * @property constraints
         * @type {Array}
         */


        this.constraints = [];
        this.wheelAxes = [];
        this.wheelForces = [];
      }
      /**
       * Add a wheel
       * @method addWheel
       * @param {object} options
       * @param {boolean} [options.isFrontWheel]
       * @param {Vec3} [options.position] Position of the wheel, locally in the chassis body.
       * @param {Vec3} [options.direction] Slide direction of the wheel along the suspension.
       * @param {Vec3} [options.axis] Axis of rotation of the wheel, locally defined in the chassis.
       * @param {Body} [options.body] The wheel body.
       */


      RigidVehicle.prototype.addWheel = function (options) {
        options = options || {};
        var wheelBody = options.body;

        if (!wheelBody) {
          wheelBody = new Body(1, new Sphere(1.2));
        }

        this.wheelBodies.push(wheelBody);
        this.wheelForces.push(0); // Position constrain wheels

        var zero = new Vec3();
        var position = typeof options.position !== 'undefined' ? options.position.clone() : new Vec3(); // Set position locally to the chassis

        var worldPosition = new Vec3();
        this.chassisBody.pointToWorldFrame(position, worldPosition);
        wheelBody.position.set(worldPosition.x, worldPosition.y, worldPosition.z); // Constrain wheel

        var axis = typeof options.axis !== 'undefined' ? options.axis.clone() : new Vec3(0, 1, 0);
        this.wheelAxes.push(axis);
        var hingeConstraint = new HingeConstraint(this.chassisBody, wheelBody, {
          pivotA: position,
          axisA: axis,
          pivotB: Vec3.ZERO,
          axisB: axis,
          collideConnected: false
        });
        this.constraints.push(hingeConstraint);
        return this.wheelBodies.length - 1;
      };
      /**
       * Set the steering value of a wheel.
       * @method setSteeringValue
       * @param {number} value
       * @param {integer} wheelIndex
       * @todo check coordinateSystem
       */


      RigidVehicle.prototype.setSteeringValue = function (value, wheelIndex) {
        // Set angle of the hinge axis
        var axis = this.wheelAxes[wheelIndex];
        var c = Math.cos(value),
            s = Math.sin(value),
            x = axis.x,
            y = axis.y;
        this.constraints[wheelIndex].axisA.set(c * x - s * y, s * x + c * y, 0);
      };
      /**
       * Set the target rotational speed of the hinge constraint.
       * @method setMotorSpeed
       * @param {number} value
       * @param {integer} wheelIndex
       */


      RigidVehicle.prototype.setMotorSpeed = function (value, wheelIndex) {
        var hingeConstraint = this.constraints[wheelIndex];
        hingeConstraint.enableMotor();
        hingeConstraint.motorTargetVelocity = value;
      };
      /**
       * Set the target rotational speed of the hinge constraint.
       * @method disableMotor
       * @param {number} value
       * @param {integer} wheelIndex
       */


      RigidVehicle.prototype.disableMotor = function (wheelIndex) {
        var hingeConstraint = this.constraints[wheelIndex];
        hingeConstraint.disableMotor();
      };

      var torque = new Vec3();
      /**
       * Set the wheel force to apply on one of the wheels each time step
       * @method setWheelForce
       * @param  {number} value
       * @param  {integer} wheelIndex
       */

      RigidVehicle.prototype.setWheelForce = function (value, wheelIndex) {
        this.wheelForces[wheelIndex] = value;
      };
      /**
       * Apply a torque on one of the wheels.
       * @method applyWheelForce
       * @param  {number} value
       * @param  {integer} wheelIndex
       */


      RigidVehicle.prototype.applyWheelForce = function (value, wheelIndex) {
        var axis = this.wheelAxes[wheelIndex];
        var wheelBody = this.wheelBodies[wheelIndex];
        var bodyTorque = wheelBody.torque;
        axis.scale(value, torque);
        wheelBody.vectorToWorldFrame(torque, torque);
        bodyTorque.vadd(torque, bodyTorque);
      };
      /**
       * Add the vehicle including its constraints to the world.
       * @method addToWorld
       * @param {World} world
       */


      RigidVehicle.prototype.addToWorld = function (world) {
        var constraints = this.constraints;
        var bodies = this.wheelBodies.concat([this.chassisBody]);

        for (var i = 0; i < bodies.length; i++) {
          world.addBody(bodies[i]);
        }

        for (var i = 0; i < constraints.length; i++) {
          world.addConstraint(constraints[i]);
        }

        world.addEventListener('preStep', this._update.bind(this));
      };

      RigidVehicle.prototype._update = function () {
        var wheelForces = this.wheelForces;

        for (var i = 0; i < wheelForces.length; i++) {
          this.applyWheelForce(wheelForces[i], i);
        }
      };
      /**
       * Remove the vehicle including its constraints from the world.
       * @method removeFromWorld
       * @param {World} world
       */


      RigidVehicle.prototype.removeFromWorld = function (world) {
        var constraints = this.constraints;
        var bodies = this.wheelBodies.concat([this.chassisBody]);

        for (var i = 0; i < bodies.length; i++) {
          world.remove(bodies[i]);
        }

        for (var i = 0; i < constraints.length; i++) {
          world.removeConstraint(constraints[i]);
        }
      };

      var worldAxis = new Vec3();
      /**
       * Get current rotational velocity of a wheel
       * @method getWheelSpeed
       * @param {integer} wheelIndex
       */

      RigidVehicle.prototype.getWheelSpeed = function (wheelIndex) {
        var axis = this.wheelAxes[wheelIndex];
        var wheelBody = this.wheelBodies[wheelIndex];
        var w = wheelBody.angularVelocity;
        this.chassisBody.vectorToWorldFrame(axis, worldAxis);
        return w.dot(worldAxis);
      };
    }, {
      "../constraints/HingeConstraint": 16,
      "../math/Vec3": 31,
      "../shapes/Box": 38,
      "../shapes/Sphere": 45,
      "./Body": 32
    }],
    35: [function (_dereq_, module, exports) {
      module.exports = SPHSystem;

      var Shape = _dereq_('../shapes/Shape');

      var Vec3 = _dereq_('../math/Vec3');

      var Quaternion = _dereq_('../math/Quaternion');

      var Particle = _dereq_('../shapes/Particle');

      var Body = _dereq_('../objects/Body');

      var Material = _dereq_('../material/Material');
      /**
       * Smoothed-particle hydrodynamics system
       * @class SPHSystem
       * @constructor
       */


      function SPHSystem() {
        this.particles = [];
        /**
         * Density of the system (kg/m3).
         * @property {number} density
         */

        this.density = 1;
        /**
         * Distance below which two particles are considered to be neighbors.
         * It should be adjusted so there are about 15-20 neighbor particles within this radius.
         * @property {number} smoothingRadius
         */

        this.smoothingRadius = 1;
        this.speedOfSound = 1;
        /**
         * Viscosity of the system.
         * @property {number} viscosity
         */

        this.viscosity = 0.01;
        this.eps = 0.000001; // Stuff Computed per particle

        this.pressures = [];
        this.densities = [];
        this.neighbors = [];
      }
      /**
       * Add a particle to the system.
       * @method add
       * @param {Body} particle
       */


      SPHSystem.prototype.add = function (particle) {
        this.particles.push(particle);

        if (this.neighbors.length < this.particles.length) {
          this.neighbors.push([]);
        }
      };
      /**
       * Remove a particle from the system.
       * @method remove
       * @param {Body} particle
       */


      SPHSystem.prototype.remove = function (particle) {
        var idx = this.particles.indexOf(particle);

        if (idx !== -1) {
          this.particles.splice(idx, 1);

          if (this.neighbors.length > this.particles.length) {
            this.neighbors.pop();
          }
        }
      };
      /**
       * Get neighbors within smoothing volume, save in the array neighbors
       * @method getNeighbors
       * @param {Body} particle
       * @param {Array} neighbors
       */


      var SPHSystem_getNeighbors_dist = new Vec3();

      SPHSystem.prototype.getNeighbors = function (particle, neighbors) {
        var N = this.particles.length,
            id = particle.id,
            R2 = this.smoothingRadius * this.smoothingRadius,
            dist = SPHSystem_getNeighbors_dist;

        for (var i = 0; i !== N; i++) {
          var p = this.particles[i];
          p.position.vsub(particle.position, dist);

          if (id !== p.id && dist.norm2() < R2) {
            neighbors.push(p);
          }
        }
      }; // Temp vectors for calculation


      var SPHSystem_update_dist = new Vec3(),
          SPHSystem_update_a_pressure = new Vec3(),
          SPHSystem_update_a_visc = new Vec3(),
          SPHSystem_update_gradW = new Vec3(),
          SPHSystem_update_r_vec = new Vec3(),
          SPHSystem_update_u = new Vec3(); // Relative velocity

      SPHSystem.prototype.update = function () {
        var N = this.particles.length,
            dist = SPHSystem_update_dist,
            cs = this.speedOfSound,
            eps = this.eps;

        for (var i = 0; i !== N; i++) {
          var p = this.particles[i]; // Current particle

          var neighbors = this.neighbors[i]; // Get neighbors

          neighbors.length = 0;
          this.getNeighbors(p, neighbors);
          neighbors.push(this.particles[i]); // Add current too

          var numNeighbors = neighbors.length; // Accumulate density for the particle

          var sum = 0.0;

          for (var j = 0; j !== numNeighbors; j++) {
            //printf("Current particle has position %f %f %f\n",objects[id].pos.x(),objects[id].pos.y(),objects[id].pos.z());
            p.position.vsub(neighbors[j].position, dist);
            var len = dist.norm();
            var weight = this.w(len);
            sum += neighbors[j].mass * weight;
          } // Save


          this.densities[i] = sum;
          this.pressures[i] = cs * cs * (this.densities[i] - this.density);
        } // Add forces
        // Sum to these accelerations


        var a_pressure = SPHSystem_update_a_pressure;
        var a_visc = SPHSystem_update_a_visc;
        var gradW = SPHSystem_update_gradW;
        var r_vec = SPHSystem_update_r_vec;
        var u = SPHSystem_update_u;

        for (var i = 0; i !== N; i++) {
          var particle = this.particles[i];
          a_pressure.set(0, 0, 0);
          a_visc.set(0, 0, 0); // Init vars

          var Pij;
          var nabla;
          var Vij; // Sum up for all other neighbors

          var neighbors = this.neighbors[i];
          var numNeighbors = neighbors.length; //printf("Neighbors: ");

          for (var j = 0; j !== numNeighbors; j++) {
            var neighbor = neighbors[j]; //printf("%d ",nj);
            // Get r once for all..

            particle.position.vsub(neighbor.position, r_vec);
            var r = r_vec.norm(); // Pressure contribution

            Pij = -neighbor.mass * (this.pressures[i] / (this.densities[i] * this.densities[i] + eps) + this.pressures[j] / (this.densities[j] * this.densities[j] + eps));
            this.gradw(r_vec, gradW); // Add to pressure acceleration

            gradW.mult(Pij, gradW);
            a_pressure.vadd(gradW, a_pressure); // Viscosity contribution

            neighbor.velocity.vsub(particle.velocity, u);
            u.mult(1.0 / (0.0001 + this.densities[i] * this.densities[j]) * this.viscosity * neighbor.mass, u);
            nabla = this.nablaw(r);
            u.mult(nabla, u); // Add to viscosity acceleration

            a_visc.vadd(u, a_visc);
          } // Calculate force


          a_visc.mult(particle.mass, a_visc);
          a_pressure.mult(particle.mass, a_pressure); // Add force to particles

          particle.force.vadd(a_visc, particle.force);
          particle.force.vadd(a_pressure, particle.force);
        }
      }; // Calculate the weight using the W(r) weightfunction


      SPHSystem.prototype.w = function (r) {
        // 315
        var h = this.smoothingRadius;
        return 315.0 / (64.0 * Math.PI * Math.pow(h, 9)) * Math.pow(h * h - r * r, 3);
      }; // calculate gradient of the weight function


      SPHSystem.prototype.gradw = function (rVec, resultVec) {
        var r = rVec.norm(),
            h = this.smoothingRadius;
        rVec.mult(945.0 / (32.0 * Math.PI * Math.pow(h, 9)) * Math.pow(h * h - r * r, 2), resultVec);
      }; // Calculate nabla(W)


      SPHSystem.prototype.nablaw = function (r) {
        var h = this.smoothingRadius;
        var nabla = 945.0 / (32.0 * Math.PI * Math.pow(h, 9)) * (h * h - r * r) * (7 * r * r - 3 * h * h);
        return nabla;
      };
    }, {
      "../material/Material": 26,
      "../math/Quaternion": 29,
      "../math/Vec3": 31,
      "../objects/Body": 32,
      "../shapes/Particle": 42,
      "../shapes/Shape": 44
    }],
    36: [function (_dereq_, module, exports) {
      var Vec3 = _dereq_('../math/Vec3');

      module.exports = Spring;
      /**
       * A spring, connecting two bodies.
       *
       * @class Spring
       * @constructor
       * @param {Body} bodyA
       * @param {Body} bodyB
       * @param {Object} [options]
       * @param {number} [options.restLength]   A number > 0. Default: 1
       * @param {number} [options.stiffness]    A number >= 0. Default: 100
       * @param {number} [options.damping]      A number >= 0. Default: 1
       * @param {Vec3}  [options.worldAnchorA] Where to hook the spring to body A, in world coordinates.
       * @param {Vec3}  [options.worldAnchorB]
       * @param {Vec3}  [options.localAnchorA] Where to hook the spring to body A, in local body coordinates.
       * @param {Vec3}  [options.localAnchorB]
       */

      function Spring(bodyA, bodyB, options) {
        options = options || {};
        /**
         * Rest length of the spring.
         * @property restLength
         * @type {number}
         */

        this.restLength = typeof options.restLength === "number" ? options.restLength : 1;
        /**
         * Stiffness of the spring.
         * @property stiffness
         * @type {number}
         */

        this.stiffness = options.stiffness || 100;
        /**
         * Damping of the spring.
         * @property damping
         * @type {number}
         */

        this.damping = options.damping || 1;
        /**
         * First connected body.
         * @property bodyA
         * @type {Body}
         */

        this.bodyA = bodyA;
        /**
         * Second connected body.
         * @property bodyB
         * @type {Body}
         */

        this.bodyB = bodyB;
        /**
         * Anchor for bodyA in local bodyA coordinates.
         * @property localAnchorA
         * @type {Vec3}
         */

        this.localAnchorA = new Vec3();
        /**
         * Anchor for bodyB in local bodyB coordinates.
         * @property localAnchorB
         * @type {Vec3}
         */

        this.localAnchorB = new Vec3();

        if (options.localAnchorA) {
          this.localAnchorA.copy(options.localAnchorA);
        }

        if (options.localAnchorB) {
          this.localAnchorB.copy(options.localAnchorB);
        }

        if (options.worldAnchorA) {
          this.setWorldAnchorA(options.worldAnchorA);
        }

        if (options.worldAnchorB) {
          this.setWorldAnchorB(options.worldAnchorB);
        }
      }
      /**
       * Set the anchor point on body A, using world coordinates.
       * @method setWorldAnchorA
       * @param {Vec3} worldAnchorA
       */


      Spring.prototype.setWorldAnchorA = function (worldAnchorA) {
        this.bodyA.pointToLocalFrame(worldAnchorA, this.localAnchorA);
      };
      /**
       * Set the anchor point on body B, using world coordinates.
       * @method setWorldAnchorB
       * @param {Vec3} worldAnchorB
       */


      Spring.prototype.setWorldAnchorB = function (worldAnchorB) {
        this.bodyB.pointToLocalFrame(worldAnchorB, this.localAnchorB);
      };
      /**
       * Get the anchor point on body A, in world coordinates.
       * @method getWorldAnchorA
       * @param {Vec3} result The vector to store the result in.
       */


      Spring.prototype.getWorldAnchorA = function (result) {
        this.bodyA.pointToWorldFrame(this.localAnchorA, result);
      };
      /**
       * Get the anchor point on body B, in world coordinates.
       * @method getWorldAnchorB
       * @param {Vec3} result The vector to store the result in.
       */


      Spring.prototype.getWorldAnchorB = function (result) {
        this.bodyB.pointToWorldFrame(this.localAnchorB, result);
      };

      var applyForce_r = new Vec3(),
          applyForce_r_unit = new Vec3(),
          applyForce_u = new Vec3(),
          applyForce_f = new Vec3(),
          applyForce_worldAnchorA = new Vec3(),
          applyForce_worldAnchorB = new Vec3(),
          applyForce_ri = new Vec3(),
          applyForce_rj = new Vec3(),
          applyForce_ri_x_f = new Vec3(),
          applyForce_rj_x_f = new Vec3(),
          applyForce_tmp = new Vec3();
      /**
       * Apply the spring force to the connected bodies.
       * @method applyForce
       */

      Spring.prototype.applyForce = function () {
        var k = this.stiffness,
            d = this.damping,
            l = this.restLength,
            bodyA = this.bodyA,
            bodyB = this.bodyB,
            r = applyForce_r,
            r_unit = applyForce_r_unit,
            u = applyForce_u,
            f = applyForce_f,
            tmp = applyForce_tmp;
        var worldAnchorA = applyForce_worldAnchorA,
            worldAnchorB = applyForce_worldAnchorB,
            ri = applyForce_ri,
            rj = applyForce_rj,
            ri_x_f = applyForce_ri_x_f,
            rj_x_f = applyForce_rj_x_f; // Get world anchors

        this.getWorldAnchorA(worldAnchorA);
        this.getWorldAnchorB(worldAnchorB); // Get offset points

        worldAnchorA.vsub(bodyA.position, ri);
        worldAnchorB.vsub(bodyB.position, rj); // Compute distance vector between world anchor points

        worldAnchorB.vsub(worldAnchorA, r);
        var rlen = r.norm();
        r_unit.copy(r);
        r_unit.normalize(); // Compute relative velocity of the anchor points, u

        bodyB.velocity.vsub(bodyA.velocity, u); // Add rotational velocity

        bodyB.angularVelocity.cross(rj, tmp);
        u.vadd(tmp, u);
        bodyA.angularVelocity.cross(ri, tmp);
        u.vsub(tmp, u); // F = - k * ( x - L ) - D * ( u )

        r_unit.mult(-k * (rlen - l) - d * u.dot(r_unit), f); // Add forces to bodies

        bodyA.force.vsub(f, bodyA.force);
        bodyB.force.vadd(f, bodyB.force); // Angular force

        ri.cross(f, ri_x_f);
        rj.cross(f, rj_x_f);
        bodyA.torque.vsub(ri_x_f, bodyA.torque);
        bodyB.torque.vadd(rj_x_f, bodyB.torque);
      };
    }, {
      "../math/Vec3": 31
    }],
    37: [function (_dereq_, module, exports) {
      var Vec3 = _dereq_('../math/Vec3');

      var Transform = _dereq_('../math/Transform');

      var RaycastResult = _dereq_('../collision/RaycastResult');

      var Utils = _dereq_('../utils/Utils');

      module.exports = WheelInfo;
      /**
       * @class WheelInfo
       * @constructor
       * @param {Object} [options]
       *
       * @param {Vec3} [options.chassisConnectionPointLocal]
       * @param {Vec3} [options.chassisConnectionPointWorld]
       * @param {Vec3} [options.directionLocal]
       * @param {Vec3} [options.directionWorld]
       * @param {Vec3} [options.axleLocal]
       * @param {Vec3} [options.axleWorld]
       * @param {number} [options.suspensionRestLength=1]
       * @param {number} [options.suspensionMaxLength=2]
       * @param {number} [options.radius=1]
       * @param {number} [options.suspensionStiffness=100]
       * @param {number} [options.dampingCompression=10]
       * @param {number} [options.dampingRelaxation=10]
       * @param {number} [options.frictionSlip=10000]
       * @param {number} [options.steering=0]
       * @param {number} [options.rotation=0]
       * @param {number} [options.deltaRotation=0]
       * @param {number} [options.rollInfluence=0.01]
       * @param {number} [options.maxSuspensionForce]
       * @param {boolean} [options.isFrontWheel=true]
       * @param {number} [options.clippedInvContactDotSuspension=1]
       * @param {number} [options.suspensionRelativeVelocity=0]
       * @param {number} [options.suspensionForce=0]
       * @param {number} [options.skidInfo=0]
       * @param {number} [options.suspensionLength=0]
       * @param {number} [options.maxSuspensionTravel=1]
       * @param {boolean} [options.useCustomSlidingRotationalSpeed=false]
       * @param {number} [options.customSlidingRotationalSpeed=-0.1]
       */

      function WheelInfo(options) {
        options = Utils.defaults(options, {
          chassisConnectionPointLocal: new Vec3(),
          chassisConnectionPointWorld: new Vec3(),
          directionLocal: new Vec3(),
          directionWorld: new Vec3(),
          axleLocal: new Vec3(),
          axleWorld: new Vec3(),
          suspensionRestLength: 1,
          suspensionMaxLength: 2,
          radius: 1,
          suspensionStiffness: 100,
          dampingCompression: 10,
          dampingRelaxation: 10,
          frictionSlip: 10000,
          steering: 0,
          rotation: 0,
          deltaRotation: 0,
          rollInfluence: 0.01,
          maxSuspensionForce: Number.MAX_VALUE,
          isFrontWheel: true,
          clippedInvContactDotSuspension: 1,
          suspensionRelativeVelocity: 0,
          suspensionForce: 0,
          skidInfo: 0,
          suspensionLength: 0,
          maxSuspensionTravel: 1,
          useCustomSlidingRotationalSpeed: false,
          customSlidingRotationalSpeed: -0.1
        });
        /**
         * Max travel distance of the suspension, in meters.
         * @property {number} maxSuspensionTravel
         */

        this.maxSuspensionTravel = options.maxSuspensionTravel;
        /**
         * Speed to apply to the wheel rotation when the wheel is sliding.
         * @property {number} customSlidingRotationalSpeed
         */

        this.customSlidingRotationalSpeed = options.customSlidingRotationalSpeed;
        /**
         * If the customSlidingRotationalSpeed should be used.
         * @property {Boolean} useCustomSlidingRotationalSpeed
         */

        this.useCustomSlidingRotationalSpeed = options.useCustomSlidingRotationalSpeed;
        /**
         * @property {Boolean} sliding
         */

        this.sliding = false;
        /**
         * Connection point, defined locally in the chassis body frame.
         * @property {Vec3} chassisConnectionPointLocal
         */

        this.chassisConnectionPointLocal = options.chassisConnectionPointLocal.clone();
        /**
         * @property {Vec3} chassisConnectionPointWorld
         */

        this.chassisConnectionPointWorld = options.chassisConnectionPointWorld.clone();
        /**
         * @property {Vec3} directionLocal
         */

        this.directionLocal = options.directionLocal.clone();
        /**
         * @property {Vec3} directionWorld
         */

        this.directionWorld = options.directionWorld.clone();
        /**
         * @property {Vec3} axleLocal
         */

        this.axleLocal = options.axleLocal.clone();
        /**
         * @property {Vec3} axleWorld
         */

        this.axleWorld = options.axleWorld.clone();
        /**
         * @property {number} suspensionRestLength
         */

        this.suspensionRestLength = options.suspensionRestLength;
        /**
         * @property {number} suspensionMaxLength
         */

        this.suspensionMaxLength = options.suspensionMaxLength;
        /**
         * @property {number} radius
         */

        this.radius = options.radius;
        /**
         * @property {number} suspensionStiffness
         */

        this.suspensionStiffness = options.suspensionStiffness;
        /**
         * @property {number} dampingCompression
         */

        this.dampingCompression = options.dampingCompression;
        /**
         * @property {number} dampingRelaxation
         */

        this.dampingRelaxation = options.dampingRelaxation;
        /**
         * @property {number} frictionSlip
         */

        this.frictionSlip = options.frictionSlip;
        /**
         * @property {number} steering
         */

        this.steering = 0;
        /**
         * Rotation value, in radians.
         * @property {number} rotation
         */

        this.rotation = 0;
        /**
         * @property {number} deltaRotation
         */

        this.deltaRotation = 0;
        /**
         * @property {number} rollInfluence
         */

        this.rollInfluence = options.rollInfluence;
        /**
         * @property {number} maxSuspensionForce
         */

        this.maxSuspensionForce = options.maxSuspensionForce;
        /**
         * @property {number} engineForce
         */

        this.engineForce = 0;
        /**
         * @property {number} brake
         */

        this.brake = 0;
        /**
         * @property {number} isFrontWheel
         */

        this.isFrontWheel = options.isFrontWheel;
        /**
         * @property {number} clippedInvContactDotSuspension
         */

        this.clippedInvContactDotSuspension = 1;
        /**
         * @property {number} suspensionRelativeVelocity
         */

        this.suspensionRelativeVelocity = 0;
        /**
         * @property {number} suspensionForce
         */

        this.suspensionForce = 0;
        /**
         * @property {number} skidInfo
         */

        this.skidInfo = 0;
        /**
         * @property {number} suspensionLength
         */

        this.suspensionLength = 0;
        /**
         * @property {number} sideImpulse
         */

        this.sideImpulse = 0;
        /**
         * @property {number} forwardImpulse
         */

        this.forwardImpulse = 0;
        /**
         * The result from raycasting
         * @property {RaycastResult} raycastResult
         */

        this.raycastResult = new RaycastResult();
        /**
         * Wheel world transform
         * @property {Transform} worldTransform
         */

        this.worldTransform = new Transform();
        /**
         * @property {boolean} isInContact
         */

        this.isInContact = false;
      }

      var chassis_velocity_at_contactPoint = new Vec3();
      var relpos = new Vec3();
      var chassis_velocity_at_contactPoint = new Vec3();

      WheelInfo.prototype.updateWheel = function (chassis) {
        var raycastResult = this.raycastResult;

        if (this.isInContact) {
          var project = raycastResult.hitNormalWorld.dot(raycastResult.directionWorld);
          raycastResult.hitPointWorld.vsub(chassis.position, relpos);
          chassis.getVelocityAtWorldPoint(relpos, chassis_velocity_at_contactPoint);
          var projVel = raycastResult.hitNormalWorld.dot(chassis_velocity_at_contactPoint);

          if (project >= -0.1) {
            this.suspensionRelativeVelocity = 0.0;
            this.clippedInvContactDotSuspension = 1.0 / 0.1;
          } else {
            var inv = -1 / project;
            this.suspensionRelativeVelocity = projVel * inv;
            this.clippedInvContactDotSuspension = inv;
          }
        } else {
          // Not in contact : position wheel in a nice (rest length) position
          raycastResult.suspensionLength = this.suspensionRestLength;
          this.suspensionRelativeVelocity = 0.0;
          raycastResult.directionWorld.scale(-1, raycastResult.hitNormalWorld);
          this.clippedInvContactDotSuspension = 1.0;
        }
      };
    }, {
      "../collision/RaycastResult": 11,
      "../math/Transform": 30,
      "../math/Vec3": 31,
      "../utils/Utils": 54
    }],
    38: [function (_dereq_, module, exports) {
      module.exports = Box;

      var Shape = _dereq_('./Shape');

      var Vec3 = _dereq_('../math/Vec3');

      var ConvexPolyhedron = _dereq_('./ConvexPolyhedron');
      /**
       * A 3d box shape.
       * @class Box
       * @constructor
       * @param {Vec3} halfExtents
       * @author schteppe
       * @extends Shape
       */


      function Box(halfExtents) {
        Shape.call(this, {
          type: Shape.types.BOX
        });
        /**
         * @property halfExtents
         * @type {Vec3}
         */

        this.halfExtents = halfExtents;
        /**
         * Used by the contact generator to make contacts with other convex polyhedra for example
         * @property convexPolyhedronRepresentation
         * @type {ConvexPolyhedron}
         */

        this.convexPolyhedronRepresentation = null;
        this.updateConvexPolyhedronRepresentation();
        this.updateBoundingSphereRadius();
      }

      Box.prototype = new Shape();
      Box.prototype.constructor = Box;
      /**
       * Updates the local convex polyhedron representation used for some collisions.
       * @method updateConvexPolyhedronRepresentation
       */

      Box.prototype.updateConvexPolyhedronRepresentation = function () {
        var sx = this.halfExtents.x;
        var sy = this.halfExtents.y;
        var sz = this.halfExtents.z;
        var V = Vec3;
        var vertices = [new V(-sx, -sy, -sz), new V(sx, -sy, -sz), new V(sx, sy, -sz), new V(-sx, sy, -sz), new V(-sx, -sy, sz), new V(sx, -sy, sz), new V(sx, sy, sz), new V(-sx, sy, sz)];
        var indices = [[3, 2, 1, 0], // -z
        [4, 5, 6, 7], // +z
        [5, 4, 0, 1], // -y
        [2, 3, 7, 6], // +y
        [0, 4, 7, 3], // -x
        [1, 2, 6, 5] // +x
        ];
        var axes = [new V(0, 0, 1), new V(0, 1, 0), new V(1, 0, 0)];
        var h = new ConvexPolyhedron(vertices, indices);
        this.convexPolyhedronRepresentation = h;
        h.material = this.material;
      };
      /**
       * @method calculateLocalInertia
       * @param  {Number} mass
       * @param  {Vec3} target
       * @return {Vec3}
       */


      Box.prototype.calculateLocalInertia = function (mass, target) {
        target = target || new Vec3();
        Box.calculateInertia(this.halfExtents, mass, target);
        return target;
      };

      Box.calculateInertia = function (halfExtents, mass, target) {
        var e = halfExtents;

        if (e.isZero()) {
          target.x = 2.0 / 12.0 * mass;
          target.y = 2.0 / 12.0 * mass;
          target.z = 2.0 / 12.0 * mass;
        } else {
          target.x = 1.0 / 12.0 * mass * (2 * e.y * 2 * e.y + 2 * e.z * 2 * e.z);
          target.y = 1.0 / 12.0 * mass * (2 * e.x * 2 * e.x + 2 * e.z * 2 * e.z);
          target.z = 1.0 / 12.0 * mass * (2 * e.y * 2 * e.y + 2 * e.x * 2 * e.x);
        }
      };
      /**
       * Get the box 6 side normals
       * @method getSideNormals
       * @param {array}      sixTargetVectors An array of 6 vectors, to store the resulting side normals in.
       * @param {Quaternion} quat             Orientation to apply to the normal vectors. If not provided, the vectors will be in respect to the local frame.
       * @return {array}
       */


      Box.prototype.getSideNormals = function (sixTargetVectors, quat) {
        var sides = sixTargetVectors;
        var ex = this.halfExtents;
        sides[0].set(ex.x, 0, 0);
        sides[1].set(0, ex.y, 0);
        sides[2].set(0, 0, ex.z);
        sides[3].set(-ex.x, 0, 0);
        sides[4].set(0, -ex.y, 0);
        sides[5].set(0, 0, -ex.z);

        if (quat !== undefined) {
          for (var i = 0; i !== sides.length; i++) {
            quat.vmult(sides[i], sides[i]);
          }
        }

        return sides;
      };

      Box.prototype.volume = function () {
        return 8.0 * this.halfExtents.x * this.halfExtents.y * this.halfExtents.z;
      };

      Box.prototype.updateBoundingSphereRadius = function () {
        this.boundingSphereRadius = this.halfExtents.norm();
      };

      var worldCornerTempPos = new Vec3();
      var worldCornerTempNeg = new Vec3();

      Box.prototype.forEachWorldCorner = function (pos, quat, callback) {
        var e = this.halfExtents;
        var corners = [[e.x, e.y, e.z], [-e.x, e.y, e.z], [-e.x, -e.y, e.z], [-e.x, -e.y, -e.z], [e.x, -e.y, -e.z], [e.x, e.y, -e.z], [-e.x, e.y, -e.z], [e.x, -e.y, e.z]];

        for (var i = 0; i < corners.length; i++) {
          worldCornerTempPos.set(corners[i][0], corners[i][1], corners[i][2]);
          quat.vmult(worldCornerTempPos, worldCornerTempPos);
          pos.vadd(worldCornerTempPos, worldCornerTempPos);
          callback(worldCornerTempPos.x, worldCornerTempPos.y, worldCornerTempPos.z);
        }
      };

      var worldCornersTemp = [new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3()];

      Box.prototype.calculateWorldAABB = function (pos, quat, min, max) {
        var e = this.halfExtents;
        worldCornersTemp[0].set(e.x, e.y, e.z);
        worldCornersTemp[1].set(-e.x, e.y, e.z);
        worldCornersTemp[2].set(-e.x, -e.y, e.z);
        worldCornersTemp[3].set(-e.x, -e.y, -e.z);
        worldCornersTemp[4].set(e.x, -e.y, -e.z);
        worldCornersTemp[5].set(e.x, e.y, -e.z);
        worldCornersTemp[6].set(-e.x, e.y, -e.z);
        worldCornersTemp[7].set(e.x, -e.y, e.z);
        var wc = worldCornersTemp[0];
        quat.vmult(wc, wc);
        pos.vadd(wc, wc);
        max.copy(wc);
        min.copy(wc);

        for (var i = 1; i < 8; i++) {
          var wc = worldCornersTemp[i];
          quat.vmult(wc, wc);
          pos.vadd(wc, wc);
          var x = wc.x;
          var y = wc.y;
          var z = wc.z;

          if (x > max.x) {
            max.x = x;
          }

          if (y > max.y) {
            max.y = y;
          }

          if (z > max.z) {
            max.z = z;
          }

          if (x < min.x) {
            min.x = x;
          }

          if (y < min.y) {
            min.y = y;
          }

          if (z < min.z) {
            min.z = z;
          }
        } // Get each axis max
        // min.set(Infinity,Infinity,Infinity);
        // max.set(-Infinity,-Infinity,-Infinity);
        // this.forEachWorldCorner(pos,quat,function(x,y,z){
        //     if(x > max.x){
        //         max.x = x;
        //     }
        //     if(y > max.y){
        //         max.y = y;
        //     }
        //     if(z > max.z){
        //         max.z = z;
        //     }
        //     if(x < min.x){
        //         min.x = x;
        //     }
        //     if(y < min.y){
        //         min.y = y;
        //     }
        //     if(z < min.z){
        //         min.z = z;
        //     }
        // });

      };
    }, {
      "../math/Vec3": 31,
      "./ConvexPolyhedron": 39,
      "./Shape": 44
    }],
    39: [function (_dereq_, module, exports) {
      module.exports = ConvexPolyhedron;

      var Shape = _dereq_('./Shape');

      var Vec3 = _dereq_('../math/Vec3');

      var Quaternion = _dereq_('../math/Quaternion');

      var Transform = _dereq_('../math/Transform');
      /**
       * A set of polygons describing a convex shape.
       * @class ConvexPolyhedron
       * @constructor
       * @extends Shape
       * @description The shape MUST be convex for the code to work properly. No polygons may be coplanar (contained
       * in the same 3D plane), instead these should be merged into one polygon.
       *
       * @param {array} points An array of Vec3's
       * @param {array} faces Array of integer arrays, describing which vertices that is included in each face.
       *
       * @author qiao / https://github.com/qiao (original author, see https://github.com/qiao/three.js/commit/85026f0c769e4000148a67d45a9e9b9c5108836f)
       * @author schteppe / https://github.com/schteppe
       * @see http://www.altdevblogaday.com/2011/05/13/contact-generation-between-3d-convex-meshes/
       * @see http://bullet.googlecode.com/svn/trunk/src/BulletCollision/NarrowPhaseCollision/btPolyhedralContactClipping.cpp
       *
       * @todo Move the clipping functions to ContactGenerator?
       * @todo Automatically merge coplanar polygons in constructor.
       */


      function ConvexPolyhedron(points, faces, uniqueAxes) {
        Shape.call(this, {
          type: Shape.types.CONVEXPOLYHEDRON
        });
        /**
         * Array of Vec3
         * @property vertices
         * @type {Array}
         */

        this.vertices = points || [];
        this.worldVertices = []; // World transformed version of .vertices

        this.worldVerticesNeedsUpdate = true;
        /**
         * Array of integer arrays, indicating which vertices each face consists of
         * @property faces
         * @type {Array}
         */

        this.faces = faces || [];
        /**
         * Array of Vec3
         * @property faceNormals
         * @type {Array}
         */

        this.faceNormals = [];
        this.computeNormals();
        this.worldFaceNormalsNeedsUpdate = true;
        this.worldFaceNormals = []; // World transformed version of .faceNormals

        /**
         * Array of Vec3
         * @property uniqueEdges
         * @type {Array}
         */

        this.uniqueEdges = [];
        /**
         * If given, these locally defined, normalized axes are the only ones being checked when doing separating axis check.
         * @property {Array} uniqueAxes
         */

        this.uniqueAxes = uniqueAxes ? uniqueAxes.slice() : null;
        this.computeEdges();
        this.updateBoundingSphereRadius();
      }

      ConvexPolyhedron.prototype = new Shape();
      ConvexPolyhedron.prototype.constructor = ConvexPolyhedron;
      var computeEdges_tmpEdge = new Vec3();
      /**
       * Computes uniqueEdges
       * @method computeEdges
       */

      ConvexPolyhedron.prototype.computeEdges = function () {
        var faces = this.faces;
        var vertices = this.vertices;
        var nv = vertices.length;
        var edges = this.uniqueEdges;
        edges.length = 0;
        var edge = computeEdges_tmpEdge;

        for (var i = 0; i !== faces.length; i++) {
          var face = faces[i];
          var numVertices = face.length;

          for (var j = 0; j !== numVertices; j++) {
            var k = (j + 1) % numVertices;
            vertices[face[j]].vsub(vertices[face[k]], edge);
            edge.normalize();
            var found = false;

            for (var p = 0; p !== edges.length; p++) {
              if (edges[p].almostEquals(edge) || edges[p].almostEquals(edge)) {
                found = true;
                break;
              }
            }

            if (!found) {
              edges.push(edge.clone());
            }
          }
        }
      };
      /**
       * Compute the normals of the faces. Will reuse existing Vec3 objects in the .faceNormals array if they exist.
       * @method computeNormals
       */


      ConvexPolyhedron.prototype.computeNormals = function () {
        this.faceNormals.length = this.faces.length; // Generate normals

        for (var i = 0; i < this.faces.length; i++) {
          // Check so all vertices exists for this face
          for (var j = 0; j < this.faces[i].length; j++) {
            if (!this.vertices[this.faces[i][j]]) {
              throw new Error("Vertex " + this.faces[i][j] + " not found!");
            }
          }

          var n = this.faceNormals[i] || new Vec3();
          this.getFaceNormal(i, n);
          n.negate(n);
          this.faceNormals[i] = n;
          var vertex = this.vertices[this.faces[i][0]];

          if (n.dot(vertex) < 0) {
            console.error(".faceNormals[" + i + "] = Vec3(" + n.toString() + ") looks like it points into the shape? The vertices follow. Make sure they are ordered CCW around the normal, using the right hand rule.");

            for (var j = 0; j < this.faces[i].length; j++) {
              console.warn(".vertices[" + this.faces[i][j] + "] = Vec3(" + this.vertices[this.faces[i][j]].toString() + ")");
            }
          }
        }
      };
      /**
       * Get face normal given 3 vertices
       * @static
       * @method getFaceNormal
       * @param {Vec3} va
       * @param {Vec3} vb
       * @param {Vec3} vc
       * @param {Vec3} target
       */


      var cb = new Vec3();
      var ab = new Vec3();

      ConvexPolyhedron.computeNormal = function (va, vb, vc, target) {
        vb.vsub(va, ab);
        vc.vsub(vb, cb);
        cb.cross(ab, target);

        if (!target.isZero()) {
          target.normalize();
        }
      };
      /**
       * Compute the normal of a face from its vertices
       * @method getFaceNormal
       * @param  {Number} i
       * @param  {Vec3} target
       */


      ConvexPolyhedron.prototype.getFaceNormal = function (i, target) {
        var f = this.faces[i];
        var va = this.vertices[f[0]];
        var vb = this.vertices[f[1]];
        var vc = this.vertices[f[2]];
        return ConvexPolyhedron.computeNormal(va, vb, vc, target);
      };
      /**
       * @method clipAgainstHull
       * @param {Vec3} posA
       * @param {Quaternion} quatA
       * @param {ConvexPolyhedron} hullB
       * @param {Vec3} posB
       * @param {Quaternion} quatB
       * @param {Vec3} separatingNormal
       * @param {Number} minDist Clamp distance
       * @param {Number} maxDist
       * @param {array} result The an array of contact point objects, see clipFaceAgainstHull
       * @see http://bullet.googlecode.com/svn/trunk/src/BulletCollision/NarrowPhaseCollision/btPolyhedralContactClipping.cpp
       */


      var cah_WorldNormal = new Vec3();

      ConvexPolyhedron.prototype.clipAgainstHull = function (posA, quatA, hullB, posB, quatB, separatingNormal, minDist, maxDist, result) {
        var WorldNormal = cah_WorldNormal;
        var hullA = this;
        var curMaxDist = maxDist;
        var closestFaceB = -1;
        var dmax = -Number.MAX_VALUE;

        for (var face = 0; face < hullB.faces.length; face++) {
          WorldNormal.copy(hullB.faceNormals[face]);
          quatB.vmult(WorldNormal, WorldNormal); //posB.vadd(WorldNormal,WorldNormal);

          var d = WorldNormal.dot(separatingNormal);

          if (d > dmax) {
            dmax = d;
            closestFaceB = face;
          }
        }

        var worldVertsB1 = [];
        var polyB = hullB.faces[closestFaceB];
        var numVertices = polyB.length;

        for (var e0 = 0; e0 < numVertices; e0++) {
          var b = hullB.vertices[polyB[e0]];
          var worldb = new Vec3();
          worldb.copy(b);
          quatB.vmult(worldb, worldb);
          posB.vadd(worldb, worldb);
          worldVertsB1.push(worldb);
        }

        if (closestFaceB >= 0) {
          this.clipFaceAgainstHull(separatingNormal, posA, quatA, worldVertsB1, minDist, maxDist, result);
        }
      };
      /**
       * Find the separating axis between this hull and another
       * @method findSeparatingAxis
       * @param {ConvexPolyhedron} hullB
       * @param {Vec3} posA
       * @param {Quaternion} quatA
       * @param {Vec3} posB
       * @param {Quaternion} quatB
       * @param {Vec3} target The target vector to save the axis in
       * @return {bool} Returns false if a separation is found, else true
       */


      var fsa_faceANormalWS3 = new Vec3(),
          fsa_Worldnormal1 = new Vec3(),
          fsa_deltaC = new Vec3(),
          fsa_worldEdge0 = new Vec3(),
          fsa_worldEdge1 = new Vec3(),
          fsa_Cross = new Vec3();

      ConvexPolyhedron.prototype.findSeparatingAxis = function (hullB, posA, quatA, posB, quatB, target, faceListA, faceListB) {
        var faceANormalWS3 = fsa_faceANormalWS3,
            Worldnormal1 = fsa_Worldnormal1,
            deltaC = fsa_deltaC,
            worldEdge0 = fsa_worldEdge0,
            worldEdge1 = fsa_worldEdge1,
            Cross = fsa_Cross;
        var dmin = Number.MAX_VALUE;
        var hullA = this;
        var curPlaneTests = 0;

        if (!hullA.uniqueAxes) {
          var numFacesA = faceListA ? faceListA.length : hullA.faces.length; // Test face normals from hullA

          for (var i = 0; i < numFacesA; i++) {
            var fi = faceListA ? faceListA[i] : i; // Get world face normal

            faceANormalWS3.copy(hullA.faceNormals[fi]);
            quatA.vmult(faceANormalWS3, faceANormalWS3);
            var d = hullA.testSepAxis(faceANormalWS3, hullB, posA, quatA, posB, quatB);

            if (d === false) {
              return false;
            }

            if (d < dmin) {
              dmin = d;
              target.copy(faceANormalWS3);
            }
          }
        } else {
          // Test unique axes
          for (var i = 0; i !== hullA.uniqueAxes.length; i++) {
            // Get world axis
            quatA.vmult(hullA.uniqueAxes[i], faceANormalWS3);
            var d = hullA.testSepAxis(faceANormalWS3, hullB, posA, quatA, posB, quatB);

            if (d === false) {
              return false;
            }

            if (d < dmin) {
              dmin = d;
              target.copy(faceANormalWS3);
            }
          }
        }

        if (!hullB.uniqueAxes) {
          // Test face normals from hullB
          var numFacesB = faceListB ? faceListB.length : hullB.faces.length;

          for (var i = 0; i < numFacesB; i++) {
            var fi = faceListB ? faceListB[i] : i;
            Worldnormal1.copy(hullB.faceNormals[fi]);
            quatB.vmult(Worldnormal1, Worldnormal1);
            curPlaneTests++;
            var d = hullA.testSepAxis(Worldnormal1, hullB, posA, quatA, posB, quatB);

            if (d === false) {
              return false;
            }

            if (d < dmin) {
              dmin = d;
              target.copy(Worldnormal1);
            }
          }
        } else {
          // Test unique axes in B
          for (var i = 0; i !== hullB.uniqueAxes.length; i++) {
            quatB.vmult(hullB.uniqueAxes[i], Worldnormal1);
            curPlaneTests++;
            var d = hullA.testSepAxis(Worldnormal1, hullB, posA, quatA, posB, quatB);

            if (d === false) {
              return false;
            }

            if (d < dmin) {
              dmin = d;
              target.copy(Worldnormal1);
            }
          }
        } // Test edges


        for (var e0 = 0; e0 !== hullA.uniqueEdges.length; e0++) {
          // Get world edge
          quatA.vmult(hullA.uniqueEdges[e0], worldEdge0);

          for (var e1 = 0; e1 !== hullB.uniqueEdges.length; e1++) {
            // Get world edge 2
            quatB.vmult(hullB.uniqueEdges[e1], worldEdge1);
            worldEdge0.cross(worldEdge1, Cross);

            if (!Cross.almostZero()) {
              Cross.normalize();
              var dist = hullA.testSepAxis(Cross, hullB, posA, quatA, posB, quatB);

              if (dist === false) {
                return false;
              }

              if (dist < dmin) {
                dmin = dist;
                target.copy(Cross);
              }
            }
          }
        }

        posB.vsub(posA, deltaC);

        if (deltaC.dot(target) > 0.0) {
          target.negate(target);
        }

        return true;
      };

      var maxminA = [],
          maxminB = [];
      /**
       * Test separating axis against two hulls. Both hulls are projected onto the axis and the overlap size is returned if there is one.
       * @method testSepAxis
       * @param {Vec3} axis
       * @param {ConvexPolyhedron} hullB
       * @param {Vec3} posA
       * @param {Quaternion} quatA
       * @param {Vec3} posB
       * @param {Quaternion} quatB
       * @return {number} The overlap depth, or FALSE if no penetration.
       */

      ConvexPolyhedron.prototype.testSepAxis = function (axis, hullB, posA, quatA, posB, quatB) {
        var hullA = this;
        ConvexPolyhedron.project(hullA, axis, posA, quatA, maxminA);
        ConvexPolyhedron.project(hullB, axis, posB, quatB, maxminB);
        var maxA = maxminA[0];
        var minA = maxminA[1];
        var maxB = maxminB[0];
        var minB = maxminB[1];

        if (maxA < minB || maxB < minA) {
          return false; // Separated
        }

        var d0 = maxA - minB;
        var d1 = maxB - minA;
        var depth = d0 < d1 ? d0 : d1;
        return depth;
      };

      var cli_aabbmin = new Vec3(),
          cli_aabbmax = new Vec3();
      /**
       * @method calculateLocalInertia
       * @param  {Number} mass
       * @param  {Vec3} target
       */

      ConvexPolyhedron.prototype.calculateLocalInertia = function (mass, target) {
        // Approximate with box inertia
        // Exact inertia calculation is overkill, but see http://geometrictools.com/Documentation/PolyhedralMassProperties.pdf for the correct way to do it
        this.computeLocalAABB(cli_aabbmin, cli_aabbmax);
        var x = cli_aabbmax.x - cli_aabbmin.x,
            y = cli_aabbmax.y - cli_aabbmin.y,
            z = cli_aabbmax.z - cli_aabbmin.z;
        target.x = 1.0 / 12.0 * mass * (2 * y * 2 * y + 2 * z * 2 * z);
        target.y = 1.0 / 12.0 * mass * (2 * x * 2 * x + 2 * z * 2 * z);
        target.z = 1.0 / 12.0 * mass * (2 * y * 2 * y + 2 * x * 2 * x);
      };
      /**
       * @method getPlaneConstantOfFace
       * @param  {Number} face_i Index of the face
       * @return {Number}
       */


      ConvexPolyhedron.prototype.getPlaneConstantOfFace = function (face_i) {
        var f = this.faces[face_i];
        var n = this.faceNormals[face_i];
        var v = this.vertices[f[0]];
        var c = -n.dot(v);
        return c;
      };
      /**
       * Clip a face against a hull.
       * @method clipFaceAgainstHull
       * @param {Vec3} separatingNormal
       * @param {Vec3} posA
       * @param {Quaternion} quatA
       * @param {Array} worldVertsB1 An array of Vec3 with vertices in the world frame.
       * @param {Number} minDist Distance clamping
       * @param {Number} maxDist
       * @param Array result Array to store resulting contact points in. Will be objects with properties: point, depth, normal. These are represented in world coordinates.
       */


      var cfah_faceANormalWS = new Vec3(),
          cfah_edge0 = new Vec3(),
          cfah_WorldEdge0 = new Vec3(),
          cfah_worldPlaneAnormal1 = new Vec3(),
          cfah_planeNormalWS1 = new Vec3(),
          cfah_worldA1 = new Vec3(),
          cfah_localPlaneNormal = new Vec3(),
          cfah_planeNormalWS = new Vec3();

      ConvexPolyhedron.prototype.clipFaceAgainstHull = function (separatingNormal, posA, quatA, worldVertsB1, minDist, maxDist, result) {
        var faceANormalWS = cfah_faceANormalWS,
            edge0 = cfah_edge0,
            WorldEdge0 = cfah_WorldEdge0,
            worldPlaneAnormal1 = cfah_worldPlaneAnormal1,
            planeNormalWS1 = cfah_planeNormalWS1,
            worldA1 = cfah_worldA1,
            localPlaneNormal = cfah_localPlaneNormal,
            planeNormalWS = cfah_planeNormalWS;
        var hullA = this;
        var worldVertsB2 = [];
        var pVtxIn = worldVertsB1;
        var pVtxOut = worldVertsB2; // Find the face with normal closest to the separating axis

        var closestFaceA = -1;
        var dmin = Number.MAX_VALUE;

        for (var face = 0; face < hullA.faces.length; face++) {
          faceANormalWS.copy(hullA.faceNormals[face]);
          quatA.vmult(faceANormalWS, faceANormalWS); //posA.vadd(faceANormalWS,faceANormalWS);

          var d = faceANormalWS.dot(separatingNormal);

          if (d < dmin) {
            dmin = d;
            closestFaceA = face;
          }
        }

        if (closestFaceA < 0) {
          // console.log("--- did not find any closest face... ---");
          return;
        } //console.log("closest A: ",closestFaceA);
        // Get the face and construct connected faces


        var polyA = hullA.faces[closestFaceA];
        polyA.connectedFaces = [];

        for (var i = 0; i < hullA.faces.length; i++) {
          for (var j = 0; j < hullA.faces[i].length; j++) {
            if (polyA.indexOf(hullA.faces[i][j]) !== -1
            /* Sharing a vertex*/
            && i !== closestFaceA
            /* Not the one we are looking for connections from */
            && polyA.connectedFaces.indexOf(i) === -1
            /* Not already added */
            ) {
                polyA.connectedFaces.push(i);
              }
          }
        } // Clip the polygon to the back of the planes of all faces of hull A, that are adjacent to the witness face


        var numContacts = pVtxIn.length;
        var numVerticesA = polyA.length;
        var res = [];

        for (var e0 = 0; e0 < numVerticesA; e0++) {
          var a = hullA.vertices[polyA[e0]];
          var b = hullA.vertices[polyA[(e0 + 1) % numVerticesA]];
          a.vsub(b, edge0);
          WorldEdge0.copy(edge0);
          quatA.vmult(WorldEdge0, WorldEdge0);
          posA.vadd(WorldEdge0, WorldEdge0);
          worldPlaneAnormal1.copy(this.faceNormals[closestFaceA]); //transA.getBasis()* btVector3(polyA.m_plane[0],polyA.m_plane[1],polyA.m_plane[2]);

          quatA.vmult(worldPlaneAnormal1, worldPlaneAnormal1);
          posA.vadd(worldPlaneAnormal1, worldPlaneAnormal1);
          WorldEdge0.cross(worldPlaneAnormal1, planeNormalWS1);
          planeNormalWS1.negate(planeNormalWS1);
          worldA1.copy(a);
          quatA.vmult(worldA1, worldA1);
          posA.vadd(worldA1, worldA1);
          var planeEqWS1 = -worldA1.dot(planeNormalWS1);
          var planeEqWS;

          if (true) {
            var otherFace = polyA.connectedFaces[e0];
            localPlaneNormal.copy(this.faceNormals[otherFace]);
            var localPlaneEq = this.getPlaneConstantOfFace(otherFace);
            planeNormalWS.copy(localPlaneNormal);
            quatA.vmult(planeNormalWS, planeNormalWS); //posA.vadd(planeNormalWS,planeNormalWS);

            var planeEqWS = localPlaneEq - planeNormalWS.dot(posA);
          } else {
            planeNormalWS.copy(planeNormalWS1);
            planeEqWS = planeEqWS1;
          } // Clip face against our constructed plane


          this.clipFaceAgainstPlane(pVtxIn, pVtxOut, planeNormalWS, planeEqWS); // Throw away all clipped points, but save the reamining until next clip

          while (pVtxIn.length) {
            pVtxIn.shift();
          }

          while (pVtxOut.length) {
            pVtxIn.push(pVtxOut.shift());
          }
        } //console.log("Resulting points after clip:",pVtxIn);
        // only keep contact points that are behind the witness face


        localPlaneNormal.copy(this.faceNormals[closestFaceA]);
        var localPlaneEq = this.getPlaneConstantOfFace(closestFaceA);
        planeNormalWS.copy(localPlaneNormal);
        quatA.vmult(planeNormalWS, planeNormalWS);
        var planeEqWS = localPlaneEq - planeNormalWS.dot(posA);

        for (var i = 0; i < pVtxIn.length; i++) {
          var depth = planeNormalWS.dot(pVtxIn[i]) + planeEqWS; //???

          /*console.log("depth calc from normal=",planeNormalWS.toString()," and constant "+planeEqWS+" and vertex ",pVtxIn[i].toString()," gives "+depth);*/

          if (depth <= minDist) {
            // console.log("clamped: depth="+depth+" to minDist="+(minDist+""));
            depth = minDist;
          }

          if (depth <= maxDist) {
            var point = pVtxIn[i];

            if (depth <= 0) {
              /*console.log("Got contact point ",point.toString(),
                ", depth=",depth,
                "contact normal=",separatingNormal.toString(),
                "plane",planeNormalWS.toString(),
                "planeConstant",planeEqWS);*/
              var p = {
                point: point,
                normal: planeNormalWS,
                depth: depth
              };
              result.push(p);
            }
          }
        }
      };
      /**
       * Clip a face in a hull against the back of a plane.
       * @method clipFaceAgainstPlane
       * @param {Array} inVertices
       * @param {Array} outVertices
       * @param {Vec3} planeNormal
       * @param {Number} planeConstant The constant in the mathematical plane equation
       */


      ConvexPolyhedron.prototype.clipFaceAgainstPlane = function (inVertices, outVertices, planeNormal, planeConstant) {
        var n_dot_first, n_dot_last;
        var numVerts = inVertices.length;

        if (numVerts < 2) {
          return outVertices;
        }

        var firstVertex = inVertices[inVertices.length - 1],
            lastVertex = inVertices[0];
        n_dot_first = planeNormal.dot(firstVertex) + planeConstant;

        for (var vi = 0; vi < numVerts; vi++) {
          lastVertex = inVertices[vi];
          n_dot_last = planeNormal.dot(lastVertex) + planeConstant;

          if (n_dot_first < 0) {
            if (n_dot_last < 0) {
              // Start < 0, end < 0, so output lastVertex
              var newv = new Vec3();
              newv.copy(lastVertex);
              outVertices.push(newv);
            } else {
              // Start < 0, end >= 0, so output intersection
              var newv = new Vec3();
              firstVertex.lerp(lastVertex, n_dot_first / (n_dot_first - n_dot_last), newv);
              outVertices.push(newv);
            }
          } else {
            if (n_dot_last < 0) {
              // Start >= 0, end < 0 so output intersection and end
              var newv = new Vec3();
              firstVertex.lerp(lastVertex, n_dot_first / (n_dot_first - n_dot_last), newv);
              outVertices.push(newv);
              outVertices.push(lastVertex);
            }
          }

          firstVertex = lastVertex;
          n_dot_first = n_dot_last;
        }

        return outVertices;
      }; // Updates .worldVertices and sets .worldVerticesNeedsUpdate to false.


      ConvexPolyhedron.prototype.computeWorldVertices = function (position, quat) {
        var N = this.vertices.length;

        while (this.worldVertices.length < N) {
          this.worldVertices.push(new Vec3());
        }

        var verts = this.vertices,
            worldVerts = this.worldVertices;

        for (var i = 0; i !== N; i++) {
          quat.vmult(verts[i], worldVerts[i]);
          position.vadd(worldVerts[i], worldVerts[i]);
        }

        this.worldVerticesNeedsUpdate = false;
      };

      var computeLocalAABB_worldVert = new Vec3();

      ConvexPolyhedron.prototype.computeLocalAABB = function (aabbmin, aabbmax) {
        var n = this.vertices.length,
            vertices = this.vertices,
            worldVert = computeLocalAABB_worldVert;
        aabbmin.set(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
        aabbmax.set(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);

        for (var i = 0; i < n; i++) {
          var v = vertices[i];

          if (v.x < aabbmin.x) {
            aabbmin.x = v.x;
          } else if (v.x > aabbmax.x) {
            aabbmax.x = v.x;
          }

          if (v.y < aabbmin.y) {
            aabbmin.y = v.y;
          } else if (v.y > aabbmax.y) {
            aabbmax.y = v.y;
          }

          if (v.z < aabbmin.z) {
            aabbmin.z = v.z;
          } else if (v.z > aabbmax.z) {
            aabbmax.z = v.z;
          }
        }
      };
      /**
       * Updates .worldVertices and sets .worldVerticesNeedsUpdate to false.
       * @method computeWorldFaceNormals
       * @param  {Quaternion} quat
       */


      ConvexPolyhedron.prototype.computeWorldFaceNormals = function (quat) {
        var N = this.faceNormals.length;

        while (this.worldFaceNormals.length < N) {
          this.worldFaceNormals.push(new Vec3());
        }

        var normals = this.faceNormals,
            worldNormals = this.worldFaceNormals;

        for (var i = 0; i !== N; i++) {
          quat.vmult(normals[i], worldNormals[i]);
        }

        this.worldFaceNormalsNeedsUpdate = false;
      };
      /**
       * @method updateBoundingSphereRadius
       */


      ConvexPolyhedron.prototype.updateBoundingSphereRadius = function () {
        // Assume points are distributed with local (0,0,0) as center
        var max2 = 0;
        var verts = this.vertices;

        for (var i = 0, N = verts.length; i !== N; i++) {
          var norm2 = verts[i].norm2();

          if (norm2 > max2) {
            max2 = norm2;
          }
        }

        this.boundingSphereRadius = Math.sqrt(max2);
      };

      var tempWorldVertex = new Vec3();
      /**
       * @method calculateWorldAABB
       * @param {Vec3}        pos
       * @param {Quaternion}  quat
       * @param {Vec3}        min
       * @param {Vec3}        max
       */

      ConvexPolyhedron.prototype.calculateWorldAABB = function (pos, quat, min, max) {
        var n = this.vertices.length,
            verts = this.vertices;
        var minx, miny, minz, maxx, maxy, maxz;

        for (var i = 0; i < n; i++) {
          tempWorldVertex.copy(verts[i]);
          quat.vmult(tempWorldVertex, tempWorldVertex);
          pos.vadd(tempWorldVertex, tempWorldVertex);
          var v = tempWorldVertex;

          if (v.x < minx || minx === undefined) {
            minx = v.x;
          }

          if (v.x > maxx || maxx === undefined) {
            maxx = v.x;
          }

          if (v.y < miny || miny === undefined) {
            miny = v.y;
          }

          if (v.y > maxy || maxy === undefined) {
            maxy = v.y;
          }

          if (v.z < minz || minz === undefined) {
            minz = v.z;
          }

          if (v.z > maxz || maxz === undefined) {
            maxz = v.z;
          }
        }

        min.set(minx, miny, minz);
        max.set(maxx, maxy, maxz);
      };
      /**
       * Get approximate convex volume
       * @method volume
       * @return {Number}
       */


      ConvexPolyhedron.prototype.volume = function () {
        return 4.0 * Math.PI * this.boundingSphereRadius / 3.0;
      };
      /**
       * Get an average of all the vertices positions
       * @method getAveragePointLocal
       * @param  {Vec3} target
       * @return {Vec3}
       */


      ConvexPolyhedron.prototype.getAveragePointLocal = function (target) {
        target = target || new Vec3();
        var n = this.vertices.length,
            verts = this.vertices;

        for (var i = 0; i < n; i++) {
          target.vadd(verts[i], target);
        }

        target.mult(1 / n, target);
        return target;
      };
      /**
       * Transform all local points. Will change the .vertices
       * @method transformAllPoints
       * @param  {Vec3} offset
       * @param  {Quaternion} quat
       */


      ConvexPolyhedron.prototype.transformAllPoints = function (offset, quat) {
        var n = this.vertices.length,
            verts = this.vertices; // Apply rotation

        if (quat) {
          // Rotate vertices
          for (var i = 0; i < n; i++) {
            var v = verts[i];
            quat.vmult(v, v);
          } // Rotate face normals


          for (var i = 0; i < this.faceNormals.length; i++) {
            var v = this.faceNormals[i];
            quat.vmult(v, v);
          }
          /*
          // Rotate edges
          for(var i=0; i<this.uniqueEdges.length; i++){
              var v = this.uniqueEdges[i];
              quat.vmult(v,v);
          }*/

        } // Apply offset


        if (offset) {
          for (var i = 0; i < n; i++) {
            var v = verts[i];
            v.vadd(offset, v);
          }
        }
      };
      /**
       * Checks whether p is inside the polyhedra. Must be in local coords. The point lies outside of the convex hull of the other points if and only if the direction of all the vectors from it to those other points are on less than one half of a sphere around it.
       * @method pointIsInside
       * @param  {Vec3} p      A point given in local coordinates
       * @return {Boolean}
       */


      var ConvexPolyhedron_pointIsInside = new Vec3();
      var ConvexPolyhedron_vToP = new Vec3();
      var ConvexPolyhedron_vToPointInside = new Vec3();

      ConvexPolyhedron.prototype.pointIsInside = function (p) {
        var n = this.vertices.length,
            verts = this.vertices,
            faces = this.faces,
            normals = this.faceNormals;
        var positiveResult = null;
        var N = this.faces.length;
        var pointInside = ConvexPolyhedron_pointIsInside;
        this.getAveragePointLocal(pointInside);

        for (var i = 0; i < N; i++) {
          var numVertices = this.faces[i].length;
          var n = normals[i];
          var v = verts[faces[i][0]]; // We only need one point in the face
          // This dot product determines which side of the edge the point is

          var vToP = ConvexPolyhedron_vToP;
          p.vsub(v, vToP);
          var r1 = n.dot(vToP);
          var vToPointInside = ConvexPolyhedron_vToPointInside;
          pointInside.vsub(v, vToPointInside);
          var r2 = n.dot(vToPointInside);

          if (r1 < 0 && r2 > 0 || r1 > 0 && r2 < 0) {
            return false; // Encountered some other sign. Exit.
          } else {}
        } // If we got here, all dot products were of the same sign.


        return positiveResult ? 1 : -1;
      };
      /**
       * Get max and min dot product of a convex hull at position (pos,quat) projected onto an axis. Results are saved in the array maxmin.
       * @static
       * @method project
       * @param {ConvexPolyhedron} hull
       * @param {Vec3} axis
       * @param {Vec3} pos
       * @param {Quaternion} quat
       * @param {array} result result[0] and result[1] will be set to maximum and minimum, respectively.
       */


      var project_worldVertex = new Vec3();
      var project_localAxis = new Vec3();
      var project_localOrigin = new Vec3();

      ConvexPolyhedron.project = function (hull, axis, pos, quat, result) {
        var n = hull.vertices.length,
            worldVertex = project_worldVertex,
            localAxis = project_localAxis,
            max = 0,
            min = 0,
            localOrigin = project_localOrigin,
            vs = hull.vertices;
        localOrigin.setZero(); // Transform the axis to local

        Transform.vectorToLocalFrame(pos, quat, axis, localAxis);
        Transform.pointToLocalFrame(pos, quat, localOrigin, localOrigin);
        var add = localOrigin.dot(localAxis);
        min = max = vs[0].dot(localAxis);

        for (var i = 1; i < n; i++) {
          var val = vs[i].dot(localAxis);

          if (val > max) {
            max = val;
          }

          if (val < min) {
            min = val;
          }
        }

        min -= add;
        max -= add;

        if (min > max) {
          // Inconsistent - swap
          var temp = min;
          min = max;
          max = temp;
        } // Output


        result[0] = max;
        result[1] = min;
      };
    }, {
      "../math/Quaternion": 29,
      "../math/Transform": 30,
      "../math/Vec3": 31,
      "./Shape": 44
    }],
    40: [function (_dereq_, module, exports) {
      module.exports = Cylinder;

      var Shape = _dereq_('./Shape');

      var Vec3 = _dereq_('../math/Vec3');

      var Quaternion = _dereq_('../math/Quaternion');

      var ConvexPolyhedron = _dereq_('./ConvexPolyhedron');
      /**
       * @class Cylinder
       * @constructor
       * @extends ConvexPolyhedron
       * @author schteppe / https://github.com/schteppe
       * @param {Number} radiusTop
       * @param {Number} radiusBottom
       * @param {Number} height
       * @param {Number} numSegments The number of segments to build the cylinder out of
       */


      function Cylinder(radiusTop, radiusBottom, height, numSegments) {
        var N = numSegments,
            verts = [],
            axes = [],
            faces = [],
            bottomface = [],
            topface = [],
            cos = Math.cos,
            sin = Math.sin; // First bottom point

        verts.push(new Vec3(radiusBottom * cos(0), radiusBottom * sin(0), -height * 0.5));
        bottomface.push(0); // First top point

        verts.push(new Vec3(radiusTop * cos(0), radiusTop * sin(0), height * 0.5));
        topface.push(1);

        for (var i = 0; i < N; i++) {
          var theta = 2 * Math.PI / N * (i + 1);
          var thetaN = 2 * Math.PI / N * (i + 0.5);

          if (i < N - 1) {
            // Bottom
            verts.push(new Vec3(radiusBottom * cos(theta), radiusBottom * sin(theta), -height * 0.5));
            bottomface.push(2 * i + 2); // Top

            verts.push(new Vec3(radiusTop * cos(theta), radiusTop * sin(theta), height * 0.5));
            topface.push(2 * i + 3); // Face

            faces.push([2 * i + 2, 2 * i + 3, 2 * i + 1, 2 * i]);
          } else {
            faces.push([0, 1, 2 * i + 1, 2 * i]); // Connect
          } // Axis: we can cut off half of them if we have even number of segments


          if (N % 2 === 1 || i < N / 2) {
            axes.push(new Vec3(cos(thetaN), sin(thetaN), 0));
          }
        }

        faces.push(topface);
        axes.push(new Vec3(0, 0, 1)); // Reorder bottom face

        var temp = [];

        for (var i = 0; i < bottomface.length; i++) {
          temp.push(bottomface[bottomface.length - i - 1]);
        }

        faces.push(temp);
        ConvexPolyhedron.call(this, verts, faces, axes);
      }

      Cylinder.prototype = new ConvexPolyhedron();
    }, {
      "../math/Quaternion": 29,
      "../math/Vec3": 31,
      "./ConvexPolyhedron": 39,
      "./Shape": 44
    }],
    41: [function (_dereq_, module, exports) {
      var Shape = _dereq_('./Shape');

      var ConvexPolyhedron = _dereq_('./ConvexPolyhedron');

      var Vec3 = _dereq_('../math/Vec3');

      var Utils = _dereq_('../utils/Utils');

      module.exports = Heightfield;
      /**
       * Heightfield shape class. Height data is given as an array. These data points are spread out evenly with a given distance.
       * @class Heightfield
       * @extends Shape
       * @constructor
       * @param {Array} data An array of Y values that will be used to construct the terrain.
       * @param {object} options
       * @param {Number} [options.minValue] Minimum value of the data points in the data array. Will be computed automatically if not given.
       * @param {Number} [options.maxValue] Maximum value.
       * @param {Number} [options.elementSize=0.1] World spacing between the data points in X direction.
       * @todo Should be possible to use along all axes, not just y
       * @todo should be possible to scale along all axes
       *
       * @example
       *     // Generate some height data (y-values).
       *     var data = [];
       *     for(var i = 0; i < 1000; i++){
       *         var y = 0.5 * Math.cos(0.2 * i);
       *         data.push(y);
       *     }
       *
       *     // Create the heightfield shape
       *     var heightfieldShape = new Heightfield(data, {
       *         elementSize: 1 // Distance between the data points in X and Y directions
       *     });
       *     var heightfieldBody = new Body();
       *     heightfieldBody.addShape(heightfieldShape);
       *     world.addBody(heightfieldBody);
       */

      function Heightfield(data, options) {
        options = Utils.defaults(options, {
          maxValue: null,
          minValue: null,
          elementSize: 1
        });
        /**
         * An array of numbers, or height values, that are spread out along the x axis.
         * @property {array} data
         */

        this.data = data;
        /**
         * Max value of the data
         * @property {number} maxValue
         */

        this.maxValue = options.maxValue;
        /**
         * Max value of the data
         * @property {number} minValue
         */

        this.minValue = options.minValue;
        /**
         * The width of each element
         * @property {number} elementSize
         * @todo elementSizeX and Y
         */

        this.elementSize = options.elementSize;

        if (options.minValue === null) {
          this.updateMinValue();
        }

        if (options.maxValue === null) {
          this.updateMaxValue();
        }

        this.cacheEnabled = true;
        Shape.call(this, {
          type: Shape.types.HEIGHTFIELD
        });
        this.pillarConvex = new ConvexPolyhedron();
        this.pillarOffset = new Vec3();
        this.updateBoundingSphereRadius(); // "i_j_isUpper" => { convex: ..., offset: ... }
        // for example:
        // _cachedPillars["0_2_1"]

        this._cachedPillars = {};
      }

      Heightfield.prototype = new Shape();
      /**
       * Call whenever you change the data array.
       * @method update
       */

      Heightfield.prototype.update = function () {
        this._cachedPillars = {};
      };
      /**
       * Update the .minValue property
       * @method updateMinValue
       */


      Heightfield.prototype.updateMinValue = function () {
        var data = this.data;
        var minValue = data[0][0];

        for (var i = 0; i !== data.length; i++) {
          for (var j = 0; j !== data[i].length; j++) {
            var v = data[i][j];

            if (v < minValue) {
              minValue = v;
            }
          }
        }

        this.minValue = minValue;
      };
      /**
       * Update the .maxValue property
       * @method updateMaxValue
       */


      Heightfield.prototype.updateMaxValue = function () {
        var data = this.data;
        var maxValue = data[0][0];

        for (var i = 0; i !== data.length; i++) {
          for (var j = 0; j !== data[i].length; j++) {
            var v = data[i][j];

            if (v > maxValue) {
              maxValue = v;
            }
          }
        }

        this.maxValue = maxValue;
      };
      /**
       * Set the height value at an index. Don't forget to update maxValue and minValue after you're done.
       * @method setHeightValueAtIndex
       * @param {integer} xi
       * @param {integer} yi
       * @param {number} value
       */


      Heightfield.prototype.setHeightValueAtIndex = function (xi, yi, value) {
        var data = this.data;
        data[xi][yi] = value; // Invalidate cache

        this.clearCachedConvexTrianglePillar(xi, yi, false);

        if (xi > 0) {
          this.clearCachedConvexTrianglePillar(xi - 1, yi, true);
          this.clearCachedConvexTrianglePillar(xi - 1, yi, false);
        }

        if (yi > 0) {
          this.clearCachedConvexTrianglePillar(xi, yi - 1, true);
          this.clearCachedConvexTrianglePillar(xi, yi - 1, false);
        }

        if (yi > 0 && xi > 0) {
          this.clearCachedConvexTrianglePillar(xi - 1, yi - 1, true);
        }
      };
      /**
       * Get max/min in a rectangle in the matrix data
       * @method getRectMinMax
       * @param  {integer} iMinX
       * @param  {integer} iMinY
       * @param  {integer} iMaxX
       * @param  {integer} iMaxY
       * @param  {array} [result] An array to store the results in.
       * @return {array} The result array, if it was passed in. Minimum will be at position 0 and max at 1.
       */


      Heightfield.prototype.getRectMinMax = function (iMinX, iMinY, iMaxX, iMaxY, result) {
        result = result || []; // Get max and min of the data

        var data = this.data,
            max = this.minValue; // Set first value

        for (var i = iMinX; i <= iMaxX; i++) {
          for (var j = iMinY; j <= iMaxY; j++) {
            var height = data[i][j];

            if (height > max) {
              max = height;
            }
          }
        }

        result[0] = this.minValue;
        result[1] = max;
      };
      /**
       * Get the index of a local position on the heightfield. The indexes indicate the rectangles, so if your terrain is made of N x N height data points, you will have rectangle indexes ranging from 0 to N-1.
       * @method getIndexOfPosition
       * @param  {number} x
       * @param  {number} y
       * @param  {array} result Two-element array
       * @param  {boolean} clamp If the position should be clamped to the heightfield edge.
       * @return {boolean}
       */


      Heightfield.prototype.getIndexOfPosition = function (x, y, result, clamp) {
        // Get the index of the data points to test against
        var w = this.elementSize;
        var data = this.data;
        var xi = Math.floor(x / w);
        var yi = Math.floor(y / w);
        result[0] = xi;
        result[1] = yi;

        if (clamp) {
          // Clamp index to edges
          if (xi < 0) {
            xi = 0;
          }

          if (yi < 0) {
            yi = 0;
          }

          if (xi >= data.length - 1) {
            xi = data.length - 1;
          }

          if (yi >= data[0].length - 1) {
            yi = data[0].length - 1;
          }
        } // Bail out if we are out of the terrain


        if (xi < 0 || yi < 0 || xi >= data.length - 1 || yi >= data[0].length - 1) {
          return false;
        }

        return true;
      };

      var getHeightAt_idx = [];
      var getHeightAt_weights = new Vec3();
      var getHeightAt_a = new Vec3();
      var getHeightAt_b = new Vec3();
      var getHeightAt_c = new Vec3();

      Heightfield.prototype.getTriangleAt = function (x, y, edgeClamp, a, b, c) {
        var idx = getHeightAt_idx;
        this.getIndexOfPosition(x, y, idx, edgeClamp);
        var xi = idx[0];
        var yi = idx[1];
        var data = this.data;

        if (edgeClamp) {
          xi = Math.min(data.length - 2, Math.max(0, xi));
          yi = Math.min(data[0].length - 2, Math.max(0, yi));
        }

        var elementSize = this.elementSize;
        var lowerDist2 = Math.pow(x / elementSize - xi, 2) + Math.pow(y / elementSize - yi, 2);
        var upperDist2 = Math.pow(x / elementSize - (xi + 1), 2) + Math.pow(y / elementSize - (yi + 1), 2);
        var upper = lowerDist2 > upperDist2;
        this.getTriangle(xi, yi, upper, a, b, c);
        return upper;
      };

      var getNormalAt_a = new Vec3();
      var getNormalAt_b = new Vec3();
      var getNormalAt_c = new Vec3();
      var getNormalAt_e0 = new Vec3();
      var getNormalAt_e1 = new Vec3();

      Heightfield.prototype.getNormalAt = function (x, y, edgeClamp, result) {
        var a = getNormalAt_a;
        var b = getNormalAt_b;
        var c = getNormalAt_c;
        var e0 = getNormalAt_e0;
        var e1 = getNormalAt_e1;
        this.getTriangleAt(x, y, edgeClamp, a, b, c);
        b.vsub(a, e0);
        c.vsub(a, e1);
        e0.cross(e1, result);
        result.normalize();
      };
      /**
       * Get an AABB of a square in the heightfield
       * @param  {number} xi
       * @param  {number} yi
       * @param  {AABB} result
       */


      Heightfield.prototype.getAabbAtIndex = function (xi, yi, result) {
        var data = this.data;
        var elementSize = this.elementSize;
        result.lowerBound.set(xi * elementSize, yi * elementSize, data[xi][yi]);
        result.upperBound.set((xi + 1) * elementSize, (yi + 1) * elementSize, data[xi + 1][yi + 1]);
      };
      /**
       * Get the height in the heightfield at a given position
       * @param  {number} x
       * @param  {number} y
       * @param  {boolean} edgeClamp
       * @return {number}
       */


      Heightfield.prototype.getHeightAt = function (x, y, edgeClamp) {
        var data = this.data;
        var a = getHeightAt_a;
        var b = getHeightAt_b;
        var c = getHeightAt_c;
        var idx = getHeightAt_idx;
        this.getIndexOfPosition(x, y, idx, edgeClamp);
        var xi = idx[0];
        var yi = idx[1];

        if (edgeClamp) {
          xi = Math.min(data.length - 2, Math.max(0, xi));
          yi = Math.min(data[0].length - 2, Math.max(0, yi));
        }

        var upper = this.getTriangleAt(x, y, edgeClamp, a, b, c);
        barycentricWeights(x, y, a.x, a.y, b.x, b.y, c.x, c.y, getHeightAt_weights);
        var w = getHeightAt_weights;

        if (upper) {
          // Top triangle verts
          return data[xi + 1][yi + 1] * w.x + data[xi][yi + 1] * w.y + data[xi + 1][yi] * w.z;
        } else {
          // Top triangle verts
          return data[xi][yi] * w.x + data[xi + 1][yi] * w.y + data[xi][yi + 1] * w.z;
        }
      }; // from https://en.wikipedia.org/wiki/Barycentric_coordinate_system


      function barycentricWeights(x, y, ax, ay, bx, by, cx, cy, result) {
        result.x = ((by - cy) * (x - cx) + (cx - bx) * (y - cy)) / ((by - cy) * (ax - cx) + (cx - bx) * (ay - cy));
        result.y = ((cy - ay) * (x - cx) + (ax - cx) * (y - cy)) / ((by - cy) * (ax - cx) + (cx - bx) * (ay - cy));
        result.z = 1 - result.x - result.y;
      }

      Heightfield.prototype.getCacheConvexTrianglePillarKey = function (xi, yi, getUpperTriangle) {
        return xi + '_' + yi + '_' + (getUpperTriangle ? 1 : 0);
      };

      Heightfield.prototype.getCachedConvexTrianglePillar = function (xi, yi, getUpperTriangle) {
        return this._cachedPillars[this.getCacheConvexTrianglePillarKey(xi, yi, getUpperTriangle)];
      };

      Heightfield.prototype.setCachedConvexTrianglePillar = function (xi, yi, getUpperTriangle, convex, offset) {
        this._cachedPillars[this.getCacheConvexTrianglePillarKey(xi, yi, getUpperTriangle)] = {
          convex: convex,
          offset: offset
        };
      };

      Heightfield.prototype.clearCachedConvexTrianglePillar = function (xi, yi, getUpperTriangle) {
        delete this._cachedPillars[this.getCacheConvexTrianglePillarKey(xi, yi, getUpperTriangle)];
      };
      /**
       * Get a triangle from the heightfield
       * @param  {number} xi
       * @param  {number} yi
       * @param  {boolean} upper
       * @param  {Vec3} a
       * @param  {Vec3} b
       * @param  {Vec3} c
       */


      Heightfield.prototype.getTriangle = function (xi, yi, upper, a, b, c) {
        var data = this.data;
        var elementSize = this.elementSize;

        if (upper) {
          // Top triangle verts
          a.set((xi + 1) * elementSize, (yi + 1) * elementSize, data[xi + 1][yi + 1]);
          b.set(xi * elementSize, (yi + 1) * elementSize, data[xi][yi + 1]);
          c.set((xi + 1) * elementSize, yi * elementSize, data[xi + 1][yi]);
        } else {
          // Top triangle verts
          a.set(xi * elementSize, yi * elementSize, data[xi][yi]);
          b.set((xi + 1) * elementSize, yi * elementSize, data[xi + 1][yi]);
          c.set(xi * elementSize, (yi + 1) * elementSize, data[xi][yi + 1]);
        }
      };
      /**
       * Get a triangle in the terrain in the form of a triangular convex shape.
       * @method getConvexTrianglePillar
       * @param  {integer} i
       * @param  {integer} j
       * @param  {boolean} getUpperTriangle
       */


      Heightfield.prototype.getConvexTrianglePillar = function (xi, yi, getUpperTriangle) {
        var result = this.pillarConvex;
        var offsetResult = this.pillarOffset;

        if (this.cacheEnabled) {
          var data = this.getCachedConvexTrianglePillar(xi, yi, getUpperTriangle);

          if (data) {
            this.pillarConvex = data.convex;
            this.pillarOffset = data.offset;
            return;
          }

          result = new ConvexPolyhedron();
          offsetResult = new Vec3();
          this.pillarConvex = result;
          this.pillarOffset = offsetResult;
        }

        var data = this.data;
        var elementSize = this.elementSize;
        var faces = result.faces; // Reuse verts if possible

        result.vertices.length = 6;

        for (var i = 0; i < 6; i++) {
          if (!result.vertices[i]) {
            result.vertices[i] = new Vec3();
          }
        } // Reuse faces if possible


        faces.length = 5;

        for (var i = 0; i < 5; i++) {
          if (!faces[i]) {
            faces[i] = [];
          }
        }

        var verts = result.vertices;
        var h = (Math.min(data[xi][yi], data[xi + 1][yi], data[xi][yi + 1], data[xi + 1][yi + 1]) - this.minValue) / 2 + this.minValue;

        if (!getUpperTriangle) {
          // Center of the triangle pillar - all polygons are given relative to this one
          offsetResult.set((xi + 0.25) * elementSize, // sort of center of a triangle
          (yi + 0.25) * elementSize, h // vertical center
          ); // Top triangle verts

          verts[0].set(-0.25 * elementSize, -0.25 * elementSize, data[xi][yi] - h);
          verts[1].set(0.75 * elementSize, -0.25 * elementSize, data[xi + 1][yi] - h);
          verts[2].set(-0.25 * elementSize, 0.75 * elementSize, data[xi][yi + 1] - h); // bottom triangle verts

          verts[3].set(-0.25 * elementSize, -0.25 * elementSize, -h - 1);
          verts[4].set(0.75 * elementSize, -0.25 * elementSize, -h - 1);
          verts[5].set(-0.25 * elementSize, 0.75 * elementSize, -h - 1); // top triangle

          faces[0][0] = 0;
          faces[0][1] = 1;
          faces[0][2] = 2; // bottom triangle

          faces[1][0] = 5;
          faces[1][1] = 4;
          faces[1][2] = 3; // -x facing quad

          faces[2][0] = 0;
          faces[2][1] = 2;
          faces[2][2] = 5;
          faces[2][3] = 3; // -y facing quad

          faces[3][0] = 1;
          faces[3][1] = 0;
          faces[3][2] = 3;
          faces[3][3] = 4; // +xy facing quad

          faces[4][0] = 4;
          faces[4][1] = 5;
          faces[4][2] = 2;
          faces[4][3] = 1;
        } else {
          // Center of the triangle pillar - all polygons are given relative to this one
          offsetResult.set((xi + 0.75) * elementSize, // sort of center of a triangle
          (yi + 0.75) * elementSize, h // vertical center
          ); // Top triangle verts

          verts[0].set(0.25 * elementSize, 0.25 * elementSize, data[xi + 1][yi + 1] - h);
          verts[1].set(-0.75 * elementSize, 0.25 * elementSize, data[xi][yi + 1] - h);
          verts[2].set(0.25 * elementSize, -0.75 * elementSize, data[xi + 1][yi] - h); // bottom triangle verts

          verts[3].set(0.25 * elementSize, 0.25 * elementSize, -h - 1);
          verts[4].set(-0.75 * elementSize, 0.25 * elementSize, -h - 1);
          verts[5].set(0.25 * elementSize, -0.75 * elementSize, -h - 1); // Top triangle

          faces[0][0] = 0;
          faces[0][1] = 1;
          faces[0][2] = 2; // bottom triangle

          faces[1][0] = 5;
          faces[1][1] = 4;
          faces[1][2] = 3; // +x facing quad

          faces[2][0] = 2;
          faces[2][1] = 5;
          faces[2][2] = 3;
          faces[2][3] = 0; // +y facing quad

          faces[3][0] = 3;
          faces[3][1] = 4;
          faces[3][2] = 1;
          faces[3][3] = 0; // -xy facing quad

          faces[4][0] = 1;
          faces[4][1] = 4;
          faces[4][2] = 5;
          faces[4][3] = 2;
        }

        result.computeNormals();
        result.computeEdges();
        result.updateBoundingSphereRadius();
        this.setCachedConvexTrianglePillar(xi, yi, getUpperTriangle, result, offsetResult);
      };

      Heightfield.prototype.calculateLocalInertia = function (mass, target) {
        target = target || new Vec3();
        target.set(0, 0, 0);
        return target;
      };

      Heightfield.prototype.volume = function () {
        return Number.MAX_VALUE; // The terrain is infinite
      };

      Heightfield.prototype.calculateWorldAABB = function (pos, quat, min, max) {
        // TODO: do it properly
        min.set(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
        max.set(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
      };

      Heightfield.prototype.updateBoundingSphereRadius = function () {
        // Use the bounding box of the min/max values
        var data = this.data,
            s = this.elementSize;
        this.boundingSphereRadius = new Vec3(data.length * s, data[0].length * s, Math.max(Math.abs(this.maxValue), Math.abs(this.minValue))).norm();
      };
      /**
       * Sets the height values from an image. Currently only supported in browser.
       * @method setHeightsFromImage
       * @param {Image} image
       * @param {Vec3} scale
       */


      Heightfield.prototype.setHeightsFromImage = function (image, scale) {
        var canvas = document.createElement('canvas');
        canvas.width = image.width;
        canvas.height = image.height;
        var context = canvas.getContext('2d');
        context.drawImage(image, 0, 0);
        var imageData = context.getImageData(0, 0, image.width, image.height);
        var matrix = this.data;
        matrix.length = 0;
        this.elementSize = Math.abs(scale.x) / imageData.width;

        for (var i = 0; i < imageData.height; i++) {
          var row = [];

          for (var j = 0; j < imageData.width; j++) {
            var a = imageData.data[(i * imageData.height + j) * 4];
            var b = imageData.data[(i * imageData.height + j) * 4 + 1];
            var c = imageData.data[(i * imageData.height + j) * 4 + 2];
            var height = (a + b + c) / 4 / 255 * scale.z;

            if (scale.x < 0) {
              row.push(height);
            } else {
              row.unshift(height);
            }
          }

          if (scale.y < 0) {
            matrix.unshift(row);
          } else {
            matrix.push(row);
          }
        }

        this.updateMaxValue();
        this.updateMinValue();
        this.update();
      };
    }, {
      "../math/Vec3": 31,
      "../utils/Utils": 54,
      "./ConvexPolyhedron": 39,
      "./Shape": 44
    }],
    42: [function (_dereq_, module, exports) {
      module.exports = Particle;

      var Shape = _dereq_('./Shape');

      var Vec3 = _dereq_('../math/Vec3');
      /**
       * Particle shape.
       * @class Particle
       * @constructor
       * @author schteppe
       * @extends Shape
       */


      function Particle() {
        Shape.call(this, {
          type: Shape.types.PARTICLE
        });
      }

      Particle.prototype = new Shape();
      Particle.prototype.constructor = Particle;
      /**
       * @method calculateLocalInertia
       * @param  {Number} mass
       * @param  {Vec3} target
       * @return {Vec3}
       */

      Particle.prototype.calculateLocalInertia = function (mass, target) {
        target = target || new Vec3();
        target.set(0, 0, 0);
        return target;
      };

      Particle.prototype.volume = function () {
        return 0;
      };

      Particle.prototype.updateBoundingSphereRadius = function () {
        this.boundingSphereRadius = 0;
      };

      Particle.prototype.calculateWorldAABB = function (pos, quat, min, max) {
        // Get each axis max
        min.copy(pos);
        max.copy(pos);
      };
    }, {
      "../math/Vec3": 31,
      "./Shape": 44
    }],
    43: [function (_dereq_, module, exports) {
      module.exports = Plane;

      var Shape = _dereq_('./Shape');

      var Vec3 = _dereq_('../math/Vec3');
      /**
       * A plane, facing in the Z direction. The plane has its surface at z=0 and everything below z=0 is assumed to be solid plane. To make the plane face in some other direction than z, you must put it inside a Body and rotate that body. See the demos.
       * @class Plane
       * @constructor
       * @extends Shape
       * @author schteppe
       */


      function Plane() {
        Shape.call(this, {
          type: Shape.types.PLANE
        }); // World oriented normal

        this.worldNormal = new Vec3();
        this.worldNormalNeedsUpdate = true;
        this.boundingSphereRadius = Number.MAX_VALUE;
      }

      Plane.prototype = new Shape();
      Plane.prototype.constructor = Plane;

      Plane.prototype.computeWorldNormal = function (quat) {
        var n = this.worldNormal;
        n.set(0, 0, 1);
        quat.vmult(n, n);
        this.worldNormalNeedsUpdate = false;
      };

      Plane.prototype.calculateLocalInertia = function (mass, target) {
        target = target || new Vec3();
        return target;
      };

      Plane.prototype.volume = function () {
        return Number.MAX_VALUE; // The plane is infinite...
      };

      var tempNormal = new Vec3();

      Plane.prototype.calculateWorldAABB = function (pos, quat, min, max) {
        // The plane AABB is infinite, except if the normal is pointing along any axis
        tempNormal.set(0, 0, 1); // Default plane normal is z

        quat.vmult(tempNormal, tempNormal);
        var maxVal = Number.MAX_VALUE;
        min.set(-maxVal, -maxVal, -maxVal);
        max.set(maxVal, maxVal, maxVal);

        if (tempNormal.x === 1) {
          max.x = pos.x;
        }

        if (tempNormal.y === 1) {
          max.y = pos.y;
        }

        if (tempNormal.z === 1) {
          max.z = pos.z;
        }

        if (tempNormal.x === -1) {
          min.x = pos.x;
        }

        if (tempNormal.y === -1) {
          min.y = pos.y;
        }

        if (tempNormal.z === -1) {
          min.z = pos.z;
        }
      };

      Plane.prototype.updateBoundingSphereRadius = function () {
        this.boundingSphereRadius = Number.MAX_VALUE;
      };
    }, {
      "../math/Vec3": 31,
      "./Shape": 44
    }],
    44: [function (_dereq_, module, exports) {
      module.exports = Shape;

      var EventTarget = _dereq_('../utils/EventTarget');

      var Shape = _dereq_('./Shape');

      var Vec3 = _dereq_('../math/Vec3');

      var Quaternion = _dereq_('../math/Quaternion');

      var Material = _dereq_('../material/Material');
      /**
       * Base class for shapes
       * @class Shape
       * @constructor
       * @param {object} [options]
       * @param {number} [options.collisionFilterGroup=1]
       * @param {number} [options.collisionFilterMask=-1]
       * @param {number} [options.collisionResponse=true]
       * @param {number} [options.material=null]
       * @author schteppe
       */


      function Shape(options) {
        options = options || {};
        EventTarget.apply(this);
        /**
         * Identifyer of the Shape.
         * @property {number} id
         */

        this.id = Shape.idCounter++;
        /**
         * The type of this shape. Must be set to an int > 0 by subclasses.
         * @property type
         * @type {Number}
         * @see Shape.types
         */

        this.type = options.type || 0;
        /**
         * The local bounding sphere radius of this shape.
         * @property {Number} boundingSphereRadius
         */

        this.boundingSphereRadius = 0;
        /**
         * Whether to produce contact forces when in contact with other bodies. Note that contacts will be generated, but they will be disabled.
         * @property {boolean} collisionResponse
         */

        this.collisionResponse = options.collisionResponse ? options.collisionResponse : true;
        /**
         * @property {Number} collisionFilterGroup
         */

        this.collisionFilterGroup = options.collisionFilterGroup !== undefined ? options.collisionFilterGroup : 1;
        /**
         * @property {Number} collisionFilterMask
         */

        this.collisionFilterMask = options.collisionFilterMask !== undefined ? options.collisionFilterMask : -1;
        /**
         * @property {Material} material
         */

        this.material = options.material ? options.material : null;
        /**
         * @property {Body} body
         */

        this.body = null;
      }

      Shape.prototype = new EventTarget();
      Shape.prototype.constructor = Shape;
      /**
       * Computes the bounding sphere radius. The result is stored in the property .boundingSphereRadius
       * @method updateBoundingSphereRadius
       */

      Shape.prototype.updateBoundingSphereRadius = function () {
        throw "computeBoundingSphereRadius() not implemented for shape type " + this.type;
      };
      /**
       * Get the volume of this shape
       * @method volume
       * @return {Number}
       */


      Shape.prototype.volume = function () {
        throw "volume() not implemented for shape type " + this.type;
      };
      /**
       * Calculates the inertia in the local frame for this shape.
       * @method calculateLocalInertia
       * @param {Number} mass
       * @param {Vec3} target
       * @see http://en.wikipedia.org/wiki/List_of_moments_of_inertia
       */


      Shape.prototype.calculateLocalInertia = function (mass, target) {
        throw "calculateLocalInertia() not implemented for shape type " + this.type;
      };

      Shape.idCounter = 0;
      /**
       * The available shape types.
       * @static
       * @property types
       * @type {Object}
       */

      Shape.types = {
        SPHERE: 1,
        PLANE: 2,
        BOX: 4,
        COMPOUND: 8,
        CONVEXPOLYHEDRON: 16,
        HEIGHTFIELD: 32,
        PARTICLE: 64,
        CYLINDER: 128,
        TRIMESH: 256
      };
    }, {
      "../material/Material": 26,
      "../math/Quaternion": 29,
      "../math/Vec3": 31,
      "../utils/EventTarget": 50,
      "./Shape": 44
    }],
    45: [function (_dereq_, module, exports) {
      module.exports = Sphere;

      var Shape = _dereq_('./Shape');

      var Vec3 = _dereq_('../math/Vec3');
      /**
       * Spherical shape
       * @class Sphere
       * @constructor
       * @extends Shape
       * @param {Number} radius The radius of the sphere, a non-negative number.
       * @author schteppe / http://github.com/schteppe
       */


      function Sphere(radius) {
        Shape.call(this, {
          type: Shape.types.SPHERE
        });
        /**
         * @property {Number} radius
         */

        this.radius = radius !== undefined ? radius : 1.0;

        if (this.radius < 0) {
          throw new Error('The sphere radius cannot be negative.');
        }

        this.updateBoundingSphereRadius();
      }

      Sphere.prototype = new Shape();
      Sphere.prototype.constructor = Sphere;

      Sphere.prototype.calculateLocalInertia = function (mass, target) {
        target = target || new Vec3();
        var I = 2.0 * mass * this.radius * this.radius / 5.0;
        target.x = I;
        target.y = I;
        target.z = I;
        return target;
      };

      Sphere.prototype.volume = function () {
        return 4.0 * Math.PI * this.radius / 3.0;
      };

      Sphere.prototype.updateBoundingSphereRadius = function () {
        this.boundingSphereRadius = this.radius;
      };

      Sphere.prototype.calculateWorldAABB = function (pos, quat, min, max) {
        var r = this.radius;
        var axes = ['x', 'y', 'z'];

        for (var i = 0; i < axes.length; i++) {
          var ax = axes[i];
          min[ax] = pos[ax] - r;
          max[ax] = pos[ax] + r;
        }
      };
    }, {
      "../math/Vec3": 31,
      "./Shape": 44
    }],
    46: [function (_dereq_, module, exports) {
      module.exports = Trimesh;

      var Shape = _dereq_('./Shape');

      var Vec3 = _dereq_('../math/Vec3');

      var Quaternion = _dereq_('../math/Quaternion');

      var Transform = _dereq_('../math/Transform');

      var AABB = _dereq_('../collision/AABB');

      var Octree = _dereq_('../utils/Octree');
      /**
       * @class Trimesh
       * @constructor
       * @param {array} vertices
       * @param {array} indices
       * @extends Shape
       * @example
       *     // How to make a mesh with a single triangle
       *     var vertices = [
       *         0, 0, 0, // vertex 0
       *         1, 0, 0, // vertex 1
       *         0, 1, 0  // vertex 2
       *     ];
       *     var indices = [
       *         0, 1, 2  // triangle 0
       *     ];
       *     var trimeshShape = new Trimesh(vertices, indices);
       */


      function Trimesh(vertices, indices) {
        Shape.call(this, {
          type: Shape.types.TRIMESH
        });
        /**
         * @property vertices
         * @type {Array}
         */

        this.vertices = new Float32Array(vertices);
        /**
         * Array of integers, indicating which vertices each triangle consists of. The length of this array is thus 3 times the number of triangles.
         * @property indices
         * @type {Array}
         */

        this.indices = new Int16Array(indices);
        /**
         * The normals data.
         * @property normals
         * @type {Array}
         */

        this.normals = new Float32Array(indices.length);
        /**
         * The local AABB of the mesh.
         * @property aabb
         * @type {Array}
         */

        this.aabb = new AABB();
        /**
         * References to vertex pairs, making up all unique edges in the trimesh.
         * @property {array} edges
         */

        this.edges = null;
        /**
         * Local scaling of the mesh. Use .setScale() to set it.
         * @property {Vec3} scale
         */

        this.scale = new Vec3(1, 1, 1);
        /**
         * The indexed triangles. Use .updateTree() to update it.
         * @property {Octree} tree
         */

        this.tree = new Octree();
        this.updateEdges();
        this.updateNormals();
        this.updateAABB();
        this.updateBoundingSphereRadius();
        this.updateTree();
      }

      Trimesh.prototype = new Shape();
      Trimesh.prototype.constructor = Trimesh;
      var computeNormals_n = new Vec3();
      /**
       * @method updateTree
       */

      Trimesh.prototype.updateTree = function () {
        var tree = this.tree;
        tree.reset();
        tree.aabb.copy(this.aabb);
        var scale = this.scale; // The local mesh AABB is scaled, but the octree AABB should be unscaled

        tree.aabb.lowerBound.x *= 1 / scale.x;
        tree.aabb.lowerBound.y *= 1 / scale.y;
        tree.aabb.lowerBound.z *= 1 / scale.z;
        tree.aabb.upperBound.x *= 1 / scale.x;
        tree.aabb.upperBound.y *= 1 / scale.y;
        tree.aabb.upperBound.z *= 1 / scale.z; // Insert all triangles

        var triangleAABB = new AABB();
        var a = new Vec3();
        var b = new Vec3();
        var c = new Vec3();
        var points = [a, b, c];

        for (var i = 0; i < this.indices.length / 3; i++) {
          //this.getTriangleVertices(i, a, b, c);
          // Get unscaled triangle verts
          var i3 = i * 3;

          this._getUnscaledVertex(this.indices[i3], a);

          this._getUnscaledVertex(this.indices[i3 + 1], b);

          this._getUnscaledVertex(this.indices[i3 + 2], c);

          triangleAABB.setFromPoints(points);
          tree.insert(triangleAABB, i);
        }

        tree.removeEmptyNodes();
      };

      var unscaledAABB = new AABB();
      /**
       * Get triangles in a local AABB from the trimesh.
       * @method getTrianglesInAABB
       * @param  {AABB} aabb
       * @param  {array} result An array of integers, referencing the queried triangles.
       */

      Trimesh.prototype.getTrianglesInAABB = function (aabb, result) {
        unscaledAABB.copy(aabb); // Scale it to local

        var scale = this.scale;
        var isx = scale.x;
        var isy = scale.y;
        var isz = scale.z;
        var l = unscaledAABB.lowerBound;
        var u = unscaledAABB.upperBound;
        l.x /= isx;
        l.y /= isy;
        l.z /= isz;
        u.x /= isx;
        u.y /= isy;
        u.z /= isz;
        return this.tree.aabbQuery(unscaledAABB, result);
      };
      /**
       * @method setScale
       * @param {Vec3} scale
       */


      Trimesh.prototype.setScale = function (scale) {
        var wasUniform = this.scale.x === this.scale.y === this.scale.z;
        var isUniform = scale.x === scale.y === scale.z;

        if (!(wasUniform && isUniform)) {
          // Non-uniform scaling. Need to update normals.
          this.updateNormals();
        }

        this.scale.copy(scale);
        this.updateAABB();
        this.updateBoundingSphereRadius();
      };
      /**
       * Compute the normals of the faces. Will save in the .normals array.
       * @method updateNormals
       */


      Trimesh.prototype.updateNormals = function () {
        var n = computeNormals_n; // Generate normals

        var normals = this.normals;

        for (var i = 0; i < this.indices.length / 3; i++) {
          var i3 = i * 3;
          var a = this.indices[i3],
              b = this.indices[i3 + 1],
              c = this.indices[i3 + 2];
          this.getVertex(a, va);
          this.getVertex(b, vb);
          this.getVertex(c, vc);
          Trimesh.computeNormal(vb, va, vc, n);
          normals[i3] = n.x;
          normals[i3 + 1] = n.y;
          normals[i3 + 2] = n.z;
        }
      };
      /**
       * Update the .edges property
       * @method updateEdges
       */


      Trimesh.prototype.updateEdges = function () {
        var edges = {};

        var add = function add(indexA, indexB) {
          var key = a < b ? a + '_' + b : b + '_' + a;
          edges[key] = true;
        };

        for (var i = 0; i < this.indices.length / 3; i++) {
          var i3 = i * 3;
          var a = this.indices[i3],
              b = this.indices[i3 + 1],
              c = this.indices[i3 + 2];
          add(a, b);
          add(b, c);
          add(c, a);
        }

        var keys = Object.keys(edges);
        this.edges = new Int16Array(keys.length * 2);

        for (var i = 0; i < keys.length; i++) {
          var indices = keys[i].split('_');
          this.edges[2 * i] = parseInt(indices[0], 10);
          this.edges[2 * i + 1] = parseInt(indices[1], 10);
        }
      };
      /**
       * Get an edge vertex
       * @method getEdgeVertex
       * @param  {number} edgeIndex
       * @param  {number} firstOrSecond 0 or 1, depending on which one of the vertices you need.
       * @param  {Vec3} vertexStore Where to store the result
       */


      Trimesh.prototype.getEdgeVertex = function (edgeIndex, firstOrSecond, vertexStore) {
        var vertexIndex = this.edges[edgeIndex * 2 + (firstOrSecond ? 1 : 0)];
        this.getVertex(vertexIndex, vertexStore);
      };

      var getEdgeVector_va = new Vec3();
      var getEdgeVector_vb = new Vec3();
      /**
       * Get a vector along an edge.
       * @method getEdgeVector
       * @param  {number} edgeIndex
       * @param  {Vec3} vectorStore
       */

      Trimesh.prototype.getEdgeVector = function (edgeIndex, vectorStore) {
        var va = getEdgeVector_va;
        var vb = getEdgeVector_vb;
        this.getEdgeVertex(edgeIndex, 0, va);
        this.getEdgeVertex(edgeIndex, 1, vb);
        vb.vsub(va, vectorStore);
      };
      /**
       * Get face normal given 3 vertices
       * @static
       * @method computeNormal
       * @param {Vec3} va
       * @param {Vec3} vb
       * @param {Vec3} vc
       * @param {Vec3} target
       */


      var cb = new Vec3();
      var ab = new Vec3();

      Trimesh.computeNormal = function (va, vb, vc, target) {
        vb.vsub(va, ab);
        vc.vsub(vb, cb);
        cb.cross(ab, target);

        if (!target.isZero()) {
          target.normalize();
        }
      };

      var va = new Vec3();
      var vb = new Vec3();
      var vc = new Vec3();
      /**
       * Get vertex i.
       * @method getVertex
       * @param  {number} i
       * @param  {Vec3} out
       * @return {Vec3} The "out" vector object
       */

      Trimesh.prototype.getVertex = function (i, out) {
        var scale = this.scale;

        this._getUnscaledVertex(i, out);

        out.x *= scale.x;
        out.y *= scale.y;
        out.z *= scale.z;
        return out;
      };
      /**
       * Get raw vertex i
       * @private
       * @method _getUnscaledVertex
       * @param  {number} i
       * @param  {Vec3} out
       * @return {Vec3} The "out" vector object
       */


      Trimesh.prototype._getUnscaledVertex = function (i, out) {
        var i3 = i * 3;
        var vertices = this.vertices;
        return out.set(vertices[i3], vertices[i3 + 1], vertices[i3 + 2]);
      };
      /**
       * Get a vertex from the trimesh,transformed by the given position and quaternion.
       * @method getWorldVertex
       * @param  {number} i
       * @param  {Vec3} pos
       * @param  {Quaternion} quat
       * @param  {Vec3} out
       * @return {Vec3} The "out" vector object
       */


      Trimesh.prototype.getWorldVertex = function (i, pos, quat, out) {
        this.getVertex(i, out);
        Transform.pointToWorldFrame(pos, quat, out, out);
        return out;
      };
      /**
       * Get the three vertices for triangle i.
       * @method getTriangleVertices
       * @param  {number} i
       * @param  {Vec3} a
       * @param  {Vec3} b
       * @param  {Vec3} c
       */


      Trimesh.prototype.getTriangleVertices = function (i, a, b, c) {
        var i3 = i * 3;
        this.getVertex(this.indices[i3], a);
        this.getVertex(this.indices[i3 + 1], b);
        this.getVertex(this.indices[i3 + 2], c);
      };
      /**
       * Compute the normal of triangle i.
       * @method getNormal
       * @param  {Number} i
       * @param  {Vec3} target
       * @return {Vec3} The "target" vector object
       */


      Trimesh.prototype.getNormal = function (i, target) {
        var i3 = i * 3;
        return target.set(this.normals[i3], this.normals[i3 + 1], this.normals[i3 + 2]);
      };

      var cli_aabb = new AABB();
      /**
       * @method calculateLocalInertia
       * @param  {Number} mass
       * @param  {Vec3} target
       * @return {Vec3} The "target" vector object
       */

      Trimesh.prototype.calculateLocalInertia = function (mass, target) {
        // Approximate with box inertia
        // Exact inertia calculation is overkill, but see http://geometrictools.com/Documentation/PolyhedralMassProperties.pdf for the correct way to do it
        this.computeLocalAABB(cli_aabb);
        var x = cli_aabb.upperBound.x - cli_aabb.lowerBound.x,
            y = cli_aabb.upperBound.y - cli_aabb.lowerBound.y,
            z = cli_aabb.upperBound.z - cli_aabb.lowerBound.z;
        return target.set(1.0 / 12.0 * mass * (2 * y * 2 * y + 2 * z * 2 * z), 1.0 / 12.0 * mass * (2 * x * 2 * x + 2 * z * 2 * z), 1.0 / 12.0 * mass * (2 * y * 2 * y + 2 * x * 2 * x));
      };

      var computeLocalAABB_worldVert = new Vec3();
      /**
       * Compute the local AABB for the trimesh
       * @method computeLocalAABB
       * @param  {AABB} aabb
       */

      Trimesh.prototype.computeLocalAABB = function (aabb) {
        var l = aabb.lowerBound,
            u = aabb.upperBound,
            n = this.vertices.length,
            vertices = this.vertices,
            v = computeLocalAABB_worldVert;
        this.getVertex(0, v);
        l.copy(v);
        u.copy(v);

        for (var i = 0; i !== n; i++) {
          this.getVertex(i, v);

          if (v.x < l.x) {
            l.x = v.x;
          } else if (v.x > u.x) {
            u.x = v.x;
          }

          if (v.y < l.y) {
            l.y = v.y;
          } else if (v.y > u.y) {
            u.y = v.y;
          }

          if (v.z < l.z) {
            l.z = v.z;
          } else if (v.z > u.z) {
            u.z = v.z;
          }
        }
      };
      /**
       * Update the .aabb property
       * @method updateAABB
       */


      Trimesh.prototype.updateAABB = function () {
        this.computeLocalAABB(this.aabb);
      };
      /**
       * Will update the .boundingSphereRadius property
       * @method updateBoundingSphereRadius
       */


      Trimesh.prototype.updateBoundingSphereRadius = function () {
        // Assume points are distributed with local (0,0,0) as center
        var max2 = 0;
        var vertices = this.vertices;
        var v = new Vec3();

        for (var i = 0, N = vertices.length / 3; i !== N; i++) {
          this.getVertex(i, v);
          var norm2 = v.norm2();

          if (norm2 > max2) {
            max2 = norm2;
          }
        }

        this.boundingSphereRadius = Math.sqrt(max2);
      };

      var tempWorldVertex = new Vec3();
      var calculateWorldAABB_frame = new Transform();
      var calculateWorldAABB_aabb = new AABB();
      /**
       * @method calculateWorldAABB
       * @param {Vec3}        pos
       * @param {Quaternion}  quat
       * @param {Vec3}        min
       * @param {Vec3}        max
       */

      Trimesh.prototype.calculateWorldAABB = function (pos, quat, min, max) {
        /*
        var n = this.vertices.length / 3,
            verts = this.vertices;
        var minx,miny,minz,maxx,maxy,maxz;
          var v = tempWorldVertex;
        for(var i=0; i<n; i++){
            this.getVertex(i, v);
            quat.vmult(v, v);
            pos.vadd(v, v);
            if (v.x < minx || minx===undefined){
                minx = v.x;
            } else if(v.x > maxx || maxx===undefined){
                maxx = v.x;
            }
              if (v.y < miny || miny===undefined){
                miny = v.y;
            } else if(v.y > maxy || maxy===undefined){
                maxy = v.y;
            }
              if (v.z < minz || minz===undefined){
                minz = v.z;
            } else if(v.z > maxz || maxz===undefined){
                maxz = v.z;
            }
        }
        min.set(minx,miny,minz);
        max.set(maxx,maxy,maxz);
        */
        // Faster approximation using local AABB
        var frame = calculateWorldAABB_frame;
        var result = calculateWorldAABB_aabb;
        frame.position = pos;
        frame.quaternion = quat;
        this.aabb.toWorldFrame(frame, result);
        min.copy(result.lowerBound);
        max.copy(result.upperBound);
      };
      /**
       * Get approximate volume
       * @method volume
       * @return {Number}
       */


      Trimesh.prototype.volume = function () {
        return 4.0 * Math.PI * this.boundingSphereRadius / 3.0;
      };
      /**
       * Create a Trimesh instance, shaped as a torus.
       * @static
       * @method createTorus
       * @param  {number} [radius=1]
       * @param  {number} [tube=0.5]
       * @param  {number} [radialSegments=8]
       * @param  {number} [tubularSegments=6]
       * @param  {number} [arc=6.283185307179586]
       * @return {Trimesh} A torus
       */


      Trimesh.createTorus = function (radius, tube, radialSegments, tubularSegments, arc) {
        radius = radius || 1;
        tube = tube || 0.5;
        radialSegments = radialSegments || 8;
        tubularSegments = tubularSegments || 6;
        arc = arc || Math.PI * 2;
        var vertices = [];
        var indices = [];

        for (var j = 0; j <= radialSegments; j++) {
          for (var i = 0; i <= tubularSegments; i++) {
            var u = i / tubularSegments * arc;
            var v = j / radialSegments * Math.PI * 2;
            var x = (radius + tube * Math.cos(v)) * Math.cos(u);
            var y = (radius + tube * Math.cos(v)) * Math.sin(u);
            var z = tube * Math.sin(v);
            vertices.push(x, y, z);
          }
        }

        for (var j = 1; j <= radialSegments; j++) {
          for (var i = 1; i <= tubularSegments; i++) {
            var a = (tubularSegments + 1) * j + i - 1;
            var b = (tubularSegments + 1) * (j - 1) + i - 1;
            var c = (tubularSegments + 1) * (j - 1) + i;
            var d = (tubularSegments + 1) * j + i;
            indices.push(a, b, d);
            indices.push(b, c, d);
          }
        }

        return new Trimesh(vertices, indices);
      };
    }, {
      "../collision/AABB": 3,
      "../math/Quaternion": 29,
      "../math/Transform": 30,
      "../math/Vec3": 31,
      "../utils/Octree": 51,
      "./Shape": 44
    }],
    47: [function (_dereq_, module, exports) {
      module.exports = GSSolver;

      var Vec3 = _dereq_('../math/Vec3');

      var Quaternion = _dereq_('../math/Quaternion');

      var Solver = _dereq_('./Solver');
      /**
       * Constraint equation Gauss-Seidel solver.
       * @class GSSolver
       * @constructor
       * @todo The spook parameters should be specified for each constraint, not globally.
       * @author schteppe / https://github.com/schteppe
       * @see https://www8.cs.umu.se/kurser/5DV058/VT09/lectures/spooknotes.pdf
       * @extends Solver
       */


      function GSSolver() {
        Solver.call(this);
        /**
         * The number of solver iterations determines quality of the constraints in the world. The more iterations, the more correct simulation. More iterations need more computations though. If you have a large gravity force in your world, you will need more iterations.
         * @property iterations
         * @type {Number}
         * @todo write more about solver and iterations in the wiki
         */

        this.iterations = 10;
        /**
         * When tolerance is reached, the system is assumed to be converged.
         * @property tolerance
         * @type {Number}
         */

        this.tolerance = 1e-7;
      }

      GSSolver.prototype = new Solver();
      var GSSolver_solve_lambda = []; // Just temporary number holders that we want to reuse each solve.

      var GSSolver_solve_invCs = [];
      var GSSolver_solve_Bs = [];

      GSSolver.prototype.solve = function (dt, world) {
        var iter = 0,
            maxIter = this.iterations,
            tolSquared = this.tolerance * this.tolerance,
            equations = this.equations,
            Neq = equations.length,
            bodies = world.bodies,
            Nbodies = bodies.length,
            h = dt,
            q,
            B,
            invC,
            deltalambda,
            deltalambdaTot,
            GWlambda,
            lambdaj; // Update solve mass

        if (Neq !== 0) {
          for (var i = 0; i !== Nbodies; i++) {
            bodies[i].updateSolveMassProperties();
          }
        } // Things that does not change during iteration can be computed once


        var invCs = GSSolver_solve_invCs,
            Bs = GSSolver_solve_Bs,
            lambda = GSSolver_solve_lambda;
        invCs.length = Neq;
        Bs.length = Neq;
        lambda.length = Neq;

        for (var i = 0; i !== Neq; i++) {
          var c = equations[i];
          lambda[i] = 0.0;
          Bs[i] = c.computeB(h);
          invCs[i] = 1.0 / c.computeC();
        }

        if (Neq !== 0) {
          // Reset vlambda
          for (var i = 0; i !== Nbodies; i++) {
            var b = bodies[i],
                vlambda = b.vlambda,
                wlambda = b.wlambda;
            vlambda.set(0, 0, 0);
            wlambda.set(0, 0, 0);
          } // Iterate over equations


          for (iter = 0; iter !== maxIter; iter++) {
            // Accumulate the total error for each iteration.
            deltalambdaTot = 0.0;

            for (var j = 0; j !== Neq; j++) {
              var c = equations[j]; // Compute iteration

              B = Bs[j];
              invC = invCs[j];
              lambdaj = lambda[j];
              GWlambda = c.computeGWlambda();
              deltalambda = invC * (B - GWlambda - c.eps * lambdaj); // Clamp if we are not within the min/max interval

              if (lambdaj + deltalambda < c.minForce) {
                deltalambda = c.minForce - lambdaj;
              } else if (lambdaj + deltalambda > c.maxForce) {
                deltalambda = c.maxForce - lambdaj;
              }

              lambda[j] += deltalambda;
              deltalambdaTot += deltalambda > 0.0 ? deltalambda : -deltalambda; // abs(deltalambda)

              c.addToWlambda(deltalambda);
            } // If the total error is small enough - stop iterate


            if (deltalambdaTot * deltalambdaTot < tolSquared) {
              break;
            }
          } // Add result to velocity


          for (var i = 0; i !== Nbodies; i++) {
            var b = bodies[i],
                v = b.velocity,
                w = b.angularVelocity;
            b.vlambda.vmul(b.linearFactor, b.vlambda);
            v.vadd(b.vlambda, v);
            b.wlambda.vmul(b.angularFactor, b.wlambda);
            w.vadd(b.wlambda, w);
          } // Set the .multiplier property of each equation


          var l = equations.length;
          var invDt = 1 / h;

          while (l--) {
            equations[l].multiplier = lambda[l] * invDt;
          }
        }

        return iter;
      };
    }, {
      "../math/Quaternion": 29,
      "../math/Vec3": 31,
      "./Solver": 48
    }],
    48: [function (_dereq_, module, exports) {
      module.exports = Solver;
      /**
       * Constraint equation solver base class.
       * @class Solver
       * @constructor
       * @author schteppe / https://github.com/schteppe
       */

      function Solver() {
        /**
         * All equations to be solved
         * @property {Array} equations
         */
        this.equations = [];
      }
      /**
       * Should be implemented in subclasses!
       * @method solve
       * @param  {Number} dt
       * @param  {World} world
       */


      Solver.prototype.solve = function (dt, world) {
        // Should return the number of iterations done!
        return 0;
      };
      /**
       * Add an equation
       * @method addEquation
       * @param {Equation} eq
       */


      Solver.prototype.addEquation = function (eq) {
        if (eq.enabled) {
          this.equations.push(eq);
        }
      };
      /**
       * Remove an equation
       * @method removeEquation
       * @param {Equation} eq
       */


      Solver.prototype.removeEquation = function (eq) {
        var eqs = this.equations;
        var i = eqs.indexOf(eq);

        if (i !== -1) {
          eqs.splice(i, 1);
        }
      };
      /**
       * Add all equations
       * @method removeAllEquations
       */


      Solver.prototype.removeAllEquations = function () {
        this.equations.length = 0;
      };
    }, {}],
    49: [function (_dereq_, module, exports) {
      module.exports = SplitSolver;

      var Vec3 = _dereq_('../math/Vec3');

      var Quaternion = _dereq_('../math/Quaternion');

      var Solver = _dereq_('./Solver');

      var Body = _dereq_('../objects/Body');
      /**
       * Splits the equations into islands and solves them independently. Can improve performance.
       * @class SplitSolver
       * @constructor
       * @extends Solver
       * @param {Solver} subsolver
       */


      function SplitSolver(subsolver) {
        Solver.call(this);
        this.iterations = 10;
        this.tolerance = 1e-7;
        this.subsolver = subsolver;
        this.nodes = [];
        this.nodePool = []; // Create needed nodes, reuse if possible

        while (this.nodePool.length < 128) {
          this.nodePool.push(this.createNode());
        }
      }

      SplitSolver.prototype = new Solver(); // Returns the number of subsystems

      var SplitSolver_solve_nodes = []; // All allocated node objects

      var SplitSolver_solve_nodePool = []; // All allocated node objects

      var SplitSolver_solve_eqs = []; // Temp array

      var SplitSolver_solve_bds = []; // Temp array

      var SplitSolver_solve_dummyWorld = {
        bodies: []
      }; // Temp object

      var STATIC = Body.STATIC;

      function getUnvisitedNode(nodes) {
        var Nnodes = nodes.length;

        for (var i = 0; i !== Nnodes; i++) {
          var node = nodes[i];

          if (!node.visited && !(node.body.type & STATIC)) {
            return node;
          }
        }

        return false;
      }

      var queue = [];

      function bfs(root, visitFunc, bds, eqs) {
        queue.push(root);
        root.visited = true;
        visitFunc(root, bds, eqs);

        while (queue.length) {
          var node = queue.pop(); // Loop over unvisited child nodes

          var child;

          while (child = getUnvisitedNode(node.children)) {
            child.visited = true;
            visitFunc(child, bds, eqs);
            queue.push(child);
          }
        }
      }

      function visitFunc(node, bds, eqs) {
        bds.push(node.body);
        var Neqs = node.eqs.length;

        for (var i = 0; i !== Neqs; i++) {
          var eq = node.eqs[i];

          if (eqs.indexOf(eq) === -1) {
            eqs.push(eq);
          }
        }
      }

      SplitSolver.prototype.createNode = function () {
        return {
          body: null,
          children: [],
          eqs: [],
          visited: false
        };
      };
      /**
       * Solve the subsystems
       * @method solve
       * @param  {Number} dt
       * @param  {World} world
       */


      SplitSolver.prototype.solve = function (dt, world) {
        var nodes = SplitSolver_solve_nodes,
            nodePool = this.nodePool,
            bodies = world.bodies,
            equations = this.equations,
            Neq = equations.length,
            Nbodies = bodies.length,
            subsolver = this.subsolver; // Create needed nodes, reuse if possible

        while (nodePool.length < Nbodies) {
          nodePool.push(this.createNode());
        }

        nodes.length = Nbodies;

        for (var i = 0; i < Nbodies; i++) {
          nodes[i] = nodePool[i];
        } // Reset node values


        for (var i = 0; i !== Nbodies; i++) {
          var node = nodes[i];
          node.body = bodies[i];
          node.children.length = 0;
          node.eqs.length = 0;
          node.visited = false;
        }

        for (var k = 0; k !== Neq; k++) {
          var eq = equations[k],
              i = bodies.indexOf(eq.bi),
              j = bodies.indexOf(eq.bj),
              ni = nodes[i],
              nj = nodes[j];
          ni.children.push(nj);
          ni.eqs.push(eq);
          nj.children.push(ni);
          nj.eqs.push(eq);
        }

        var child,
            n = 0,
            eqs = SplitSolver_solve_eqs;
        subsolver.tolerance = this.tolerance;
        subsolver.iterations = this.iterations;
        var dummyWorld = SplitSolver_solve_dummyWorld;

        while (child = getUnvisitedNode(nodes)) {
          eqs.length = 0;
          dummyWorld.bodies.length = 0;
          bfs(child, visitFunc, dummyWorld.bodies, eqs);
          var Neqs = eqs.length;
          eqs = eqs.sort(sortById);

          for (var i = 0; i !== Neqs; i++) {
            subsolver.addEquation(eqs[i]);
          }

          var iter = subsolver.solve(dt, dummyWorld);
          subsolver.removeAllEquations();
          n++;
        }

        return n;
      };

      function sortById(a, b) {
        return b.id - a.id;
      }
    }, {
      "../math/Quaternion": 29,
      "../math/Vec3": 31,
      "../objects/Body": 32,
      "./Solver": 48
    }],
    50: [function (_dereq_, module, exports) {
      /**
       * Base class for objects that dispatches events.
       * @class EventTarget
       * @constructor
       */
      var EventTarget = function EventTarget() {};

      module.exports = EventTarget;
      EventTarget.prototype = {
        constructor: EventTarget,

        /**
         * Add an event listener
         * @method addEventListener
         * @param  {String} type
         * @param  {Function} listener
         * @return {EventTarget} The self object, for chainability.
         */
        addEventListener: function addEventListener(type, listener) {
          if (this._listeners === undefined) {
            this._listeners = {};
          }

          var listeners = this._listeners;

          if (listeners[type] === undefined) {
            listeners[type] = [];
          }

          if (listeners[type].indexOf(listener) === -1) {
            listeners[type].push(listener);
          }

          return this;
        },

        /**
         * Check if an event listener is added
         * @method hasEventListener
         * @param  {String} type
         * @param  {Function} listener
         * @return {Boolean}
         */
        hasEventListener: function hasEventListener(type, listener) {
          if (this._listeners === undefined) {
            return false;
          }

          var listeners = this._listeners;

          if (listeners[type] !== undefined && listeners[type].indexOf(listener) !== -1) {
            return true;
          }

          return false;
        },

        /**
         * Check if any event listener of the given type is added
         * @method hasAnyEventListener
         * @param  {String} type
         * @return {Boolean}
         */
        hasAnyEventListener: function hasAnyEventListener(type) {
          if (this._listeners === undefined) {
            return false;
          }

          var listeners = this._listeners;
          return listeners[type] !== undefined;
        },

        /**
         * Remove an event listener
         * @method removeEventListener
         * @param  {String} type
         * @param  {Function} listener
         * @return {EventTarget} The self object, for chainability.
         */
        removeEventListener: function removeEventListener(type, listener) {
          if (this._listeners === undefined) {
            return this;
          }

          var listeners = this._listeners;

          if (listeners[type] === undefined) {
            return this;
          }

          var index = listeners[type].indexOf(listener);

          if (index !== -1) {
            listeners[type].splice(index, 1);
          }

          return this;
        },

        /**
         * Emit an event.
         * @method dispatchEvent
         * @param  {Object} event
         * @param  {String} event.type
         * @return {EventTarget} The self object, for chainability.
         */
        dispatchEvent: function dispatchEvent(event) {
          if (this._listeners === undefined) {
            return this;
          }

          var listeners = this._listeners;
          var listenerArray = listeners[event.type];

          if (listenerArray !== undefined) {
            event.target = this;

            for (var i = 0, l = listenerArray.length; i < l; i++) {
              listenerArray[i].call(this, event);
            }
          }

          return this;
        }
      };
    }, {}],
    51: [function (_dereq_, module, exports) {
      var AABB = _dereq_('../collision/AABB');

      var Vec3 = _dereq_('../math/Vec3');

      module.exports = Octree;
      /**
       * @class OctreeNode
       * @param {object} [options]
       * @param {Octree} [options.root]
       * @param {AABB} [options.aabb]
       */

      function OctreeNode(options) {
        options = options || {};
        /**
         * The root node
         * @property {OctreeNode} root
         */

        this.root = options.root || null;
        /**
         * Boundary of this node
         * @property {AABB} aabb
         */

        this.aabb = options.aabb ? options.aabb.clone() : new AABB();
        /**
         * Contained data at the current node level.
         * @property {Array} data
         */

        this.data = [];
        /**
         * Children to this node
         * @property {Array} children
         */

        this.children = [];
      }
      /**
       * @class Octree
       * @param {AABB} aabb The total AABB of the tree
       * @param {object} [options]
       * @param {number} [options.maxDepth=8]
       * @extends OctreeNode
       */


      function Octree(aabb, options) {
        options = options || {};
        options.root = null;
        options.aabb = aabb;
        OctreeNode.call(this, options);
        /**
         * Maximum subdivision depth
         * @property {number} maxDepth
         */

        this.maxDepth = typeof options.maxDepth !== 'undefined' ? options.maxDepth : 8;
      }

      Octree.prototype = new OctreeNode();

      OctreeNode.prototype.reset = function (aabb, options) {
        this.children.length = this.data.length = 0;
      };
      /**
       * Insert data into this node
       * @method insert
       * @param  {AABB} aabb
       * @param  {object} elementData
       * @return {boolean} True if successful, otherwise false
       */


      OctreeNode.prototype.insert = function (aabb, elementData, level) {
        var nodeData = this.data;
        level = level || 0; // Ignore objects that do not belong in this node

        if (!this.aabb.contains(aabb)) {
          return false; // object cannot be added
        }

        var children = this.children;

        if (level < (this.maxDepth || this.root.maxDepth)) {
          // Subdivide if there are no children yet
          var subdivided = false;

          if (!children.length) {
            this.subdivide();
            subdivided = true;
          } // add to whichever node will accept it


          for (var i = 0; i !== 8; i++) {
            if (children[i].insert(aabb, elementData, level + 1)) {
              return true;
            }
          }

          if (subdivided) {
            // No children accepted! Might as well just remove em since they contain none
            children.length = 0;
          }
        } // Too deep, or children didnt want it. add it in current node


        nodeData.push(elementData);
        return true;
      };

      var halfDiagonal = new Vec3();
      /**
       * Create 8 equally sized children nodes and put them in the .children array.
       * @method subdivide
       */

      OctreeNode.prototype.subdivide = function () {
        var aabb = this.aabb;
        var l = aabb.lowerBound;
        var u = aabb.upperBound;
        var children = this.children;
        children.push(new OctreeNode({
          aabb: new AABB({
            lowerBound: new Vec3(0, 0, 0)
          })
        }), new OctreeNode({
          aabb: new AABB({
            lowerBound: new Vec3(1, 0, 0)
          })
        }), new OctreeNode({
          aabb: new AABB({
            lowerBound: new Vec3(1, 1, 0)
          })
        }), new OctreeNode({
          aabb: new AABB({
            lowerBound: new Vec3(1, 1, 1)
          })
        }), new OctreeNode({
          aabb: new AABB({
            lowerBound: new Vec3(0, 1, 1)
          })
        }), new OctreeNode({
          aabb: new AABB({
            lowerBound: new Vec3(0, 0, 1)
          })
        }), new OctreeNode({
          aabb: new AABB({
            lowerBound: new Vec3(1, 0, 1)
          })
        }), new OctreeNode({
          aabb: new AABB({
            lowerBound: new Vec3(0, 1, 0)
          })
        }));
        u.vsub(l, halfDiagonal);
        halfDiagonal.scale(0.5, halfDiagonal);
        var root = this.root || this;

        for (var i = 0; i !== 8; i++) {
          var child = children[i]; // Set current node as root

          child.root = root; // Compute bounds

          var lowerBound = child.aabb.lowerBound;
          lowerBound.x *= halfDiagonal.x;
          lowerBound.y *= halfDiagonal.y;
          lowerBound.z *= halfDiagonal.z;
          lowerBound.vadd(l, lowerBound); // Upper bound is always lower bound + halfDiagonal

          lowerBound.vadd(halfDiagonal, child.aabb.upperBound);
        }
      };
      /**
       * Get all data, potentially within an AABB
       * @method aabbQuery
       * @param  {AABB} aabb
       * @param  {array} result
       * @return {array} The "result" object
       */


      OctreeNode.prototype.aabbQuery = function (aabb, result) {
        var nodeData = this.data; // abort if the range does not intersect this node
        // if (!this.aabb.overlaps(aabb)){
        //     return result;
        // }
        // Add objects at this level
        // Array.prototype.push.apply(result, nodeData);
        // Add child data
        // @todo unwrap recursion into a queue / loop, that's faster in JS

        var children = this.children; // for (var i = 0, N = this.children.length; i !== N; i++) {
        //     children[i].aabbQuery(aabb, result);
        // }

        var queue = [this];

        while (queue.length) {
          var node = queue.pop();

          if (node.aabb.overlaps(aabb)) {
            Array.prototype.push.apply(result, node.data);
          }

          Array.prototype.push.apply(queue, node.children);
        }

        return result;
      };

      var tmpAABB = new AABB();
      /**
       * Get all data, potentially intersected by a ray.
       * @method rayQuery
       * @param  {Ray} ray
       * @param  {Transform} treeTransform
       * @param  {array} result
       * @return {array} The "result" object
       */

      OctreeNode.prototype.rayQuery = function (ray, treeTransform, result) {
        // Use aabb query for now.
        // @todo implement real ray query which needs less lookups
        ray.getAABB(tmpAABB);
        tmpAABB.toLocalFrame(treeTransform, tmpAABB);
        this.aabbQuery(tmpAABB, result);
        return result;
      };
      /**
       * @method removeEmptyNodes
       */


      OctreeNode.prototype.removeEmptyNodes = function () {
        for (var i = this.children.length - 1; i >= 0; i--) {
          this.children[i].removeEmptyNodes();

          if (!this.children[i].children.length && !this.children[i].data.length) {
            this.children.splice(i, 1);
          }
        }
      };
    }, {
      "../collision/AABB": 3,
      "../math/Vec3": 31
    }],
    52: [function (_dereq_, module, exports) {
      module.exports = Pool;
      /**
       * For pooling objects that can be reused.
       * @class Pool
       * @constructor
       */

      function Pool() {
        /**
         * The pooled objects
         * @property {Array} objects
         */
        this.objects = [];
        /**
         * Constructor of the objects
         * @property {mixed} type
         */

        this.type = Object;
      }
      /**
       * Release an object after use
       * @method release
       * @param {Object} obj
       */


      Pool.prototype.release = function () {
        var Nargs = arguments.length;

        for (var i = 0; i !== Nargs; i++) {
          this.objects.push(arguments[i]);
        }

        return this;
      };
      /**
       * Get an object
       * @method get
       * @return {mixed}
       */


      Pool.prototype.get = function () {
        if (this.objects.length === 0) {
          return this.constructObject();
        } else {
          return this.objects.pop();
        }
      };
      /**
       * Construct an object. Should be implmented in each subclass.
       * @method constructObject
       * @return {mixed}
       */


      Pool.prototype.constructObject = function () {
        throw new Error("constructObject() not implemented in this Pool subclass yet!");
      };
      /**
       * @method resize
       * @param {number} size
       * @return {Pool} Self, for chaining
       */


      Pool.prototype.resize = function (size) {
        var objects = this.objects;

        while (objects.length > size) {
          objects.pop();
        }

        while (objects.length < size) {
          objects.push(this.constructObject());
        }

        return this;
      };
    }, {}],
    53: [function (_dereq_, module, exports) {
      module.exports = TupleDictionary;
      /**
       * @class TupleDictionary
       * @constructor
       */

      function TupleDictionary() {
        /**
         * The data storage
         * @property data
         * @type {Object}
         */
        this.data = {
          keys: []
        };
      }
      /**
       * @method get
       * @param  {Number} i
       * @param  {Number} j
       * @return {Object}
       */


      TupleDictionary.prototype.get = function (i, j) {
        if (i > j) {
          // swap
          var temp = j;
          j = i;
          i = temp;
        }

        return this.data[i + '-' + j];
      };
      /**
       * @method set
       * @param  {Number} i
       * @param  {Number} j
       * @param {Object} value
       */


      TupleDictionary.prototype.set = function (i, j, value) {
        if (i > j) {
          var temp = j;
          j = i;
          i = temp;
        }

        var key = i + '-' + j; // Check if key already exists

        if (!this.get(i, j)) {
          this.data.keys.push(key);
        }

        this.data[key] = value;
        return this.data[key];
      };
      /**
       * @method reset
       */


      TupleDictionary.prototype.reset = function () {
        var data = this.data,
            keys = data.keys;

        while (keys.length > 0) {
          var key = keys.pop();
          delete data[key];
        }
      };
      /**
       * @method getLength
       */


      TupleDictionary.prototype.getLength = function () {
        return this.data.keys.length;
      };
      /**
       * @method getKeyByIndex
       * @param {Number} index
       */


      TupleDictionary.prototype.getKeyByIndex = function (index) {
        return this.data.keys[index];
      };
      /**
       * @method getDataByKey
       * @param {Number} Key
       */


      TupleDictionary.prototype.getDataByKey = function (Key) {
        return this.data[Key];
      };
    }, {}],
    54: [function (_dereq_, module, exports) {
      function Utils() {}

      module.exports = Utils;
      /**
       * Extend an options object with default values.
       * @static
       * @method defaults
       * @param  {object} options The options object. May be falsy: in this case, a new object is created and returned.
       * @param  {object} defaults An object containing default values.
       * @return {object} The modified options object.
       */

      Utils.defaults = function (options, defaults) {
        options = options || {};

        for (var key in defaults) {
          if (!(key in options)) {
            options[key] = defaults[key];
          }
        }

        return options;
      };
    }, {}],
    55: [function (_dereq_, module, exports) {
      module.exports = Vec3Pool;

      var Vec3 = _dereq_('../math/Vec3');

      var Pool = _dereq_('./Pool');
      /**
       * @class Vec3Pool
       * @constructor
       * @extends Pool
       */


      function Vec3Pool() {
        Pool.call(this);
        this.type = Vec3;
      }

      Vec3Pool.prototype = new Pool();
      /**
       * Construct a vector
       * @method constructObject
       * @return {Vec3}
       */

      Vec3Pool.prototype.constructObject = function () {
        return new Vec3();
      };
    }, {
      "../math/Vec3": 31,
      "./Pool": 52
    }],
    56: [function (_dereq_, module, exports) {
      module.exports = Narrowphase;

      var AABB = _dereq_('../collision/AABB');

      var Body = _dereq_('../objects/Body');

      var Shape = _dereq_('../shapes/Shape');

      var Ray = _dereq_('../collision/Ray');

      var Vec3 = _dereq_('../math/Vec3');

      var Transform = _dereq_('../math/Transform');

      var ConvexPolyhedron = _dereq_('../shapes/ConvexPolyhedron');

      var Quaternion = _dereq_('../math/Quaternion');

      var Solver = _dereq_('../solver/Solver');

      var Vec3Pool = _dereq_('../utils/Vec3Pool');

      var ContactEquation = _dereq_('../equations/ContactEquation');

      var FrictionEquation = _dereq_('../equations/FrictionEquation');
      /**
       * Helper class for the World. Generates ContactEquations.
       * @class Narrowphase
       * @constructor
       * @todo Sphere-ConvexPolyhedron contacts
       * @todo Contact reduction
       * @todo  should move methods to prototype
       */


      function Narrowphase(world) {
        /**
         * Internal storage of pooled contact points.
         * @property {Array} contactPointPool
         */
        this.contactPointPool = [];
        this.frictionEquationPool = [];
        this.result = [];
        this.frictionResult = [];
        /**
         * Pooled vectors.
         * @property {Vec3Pool} v3pool
         */

        this.v3pool = new Vec3Pool();
        this.world = world;
        this.currentContactMaterial = null;
        /**
         * @property {Boolean} enableFrictionReduction
         */

        this.enableFrictionReduction = false;
      }
      /**
       * Make a contact object, by using the internal pool or creating a new one.
       * @method createContactEquation
       * @param {Body} bi
       * @param {Body} bj
       * @param {Shape} si
       * @param {Shape} sj
       * @param {Shape} overrideShapeA
       * @param {Shape} overrideShapeB
       * @return {ContactEquation}
       */


      Narrowphase.prototype.createContactEquation = function (bi, bj, si, sj, overrideShapeA, overrideShapeB) {
        var c;

        if (this.contactPointPool.length) {
          c = this.contactPointPool.pop();
          c.bi = bi;
          c.bj = bj;
        } else {
          c = new ContactEquation(bi, bj);
        } // need ?, trigger is already filter
        // c.enabled = bi.collisionResponse && bj.collisionResponse && si.collisionResponse && sj.collisionResponse;


        var cm = this.currentContactMaterial;
        c.restitution = cm.restitution;
        c.setSpookParams(cm.contactEquationStiffness, cm.contactEquationRelaxation, this.world.dt);
        var matA = si.material || bi.material;
        var matB = sj.material || bj.material;

        if (matA && matB && matA.restitution >= 0 && matB.restitution >= 0) {
          c.restitution = matA.restitution * matB.restitution;
        }

        c.si = overrideShapeA || si;
        c.sj = overrideShapeB || sj;
        return c;
      };

      Narrowphase.prototype.createFrictionEquationsFromContact = function (contactEquation, outArray) {
        var bodyA = contactEquation.bi;
        var bodyB = contactEquation.bj;
        var shapeA = contactEquation.si;
        var shapeB = contactEquation.sj;
        var world = this.world;
        var cm = this.currentContactMaterial; // If friction or restitution were specified in the material, use them

        var friction = cm.friction;
        var matA = shapeA.material || bodyA.material;
        var matB = shapeB.material || bodyB.material;

        if (matA && matB && matA.friction >= 0 && matB.friction >= 0) {
          friction = matA.friction * matB.friction;
        }

        if (friction > 0) {
          // Create 2 tangent equations
          var mug = friction * world.gravity.length();
          var reducedMass = bodyA.invMass + bodyB.invMass;

          if (reducedMass > 0) {
            reducedMass = 1 / reducedMass;
          }

          var pool = this.frictionEquationPool;
          var c1 = pool.length ? pool.pop() : new FrictionEquation(bodyA, bodyB, mug * reducedMass);
          var c2 = pool.length ? pool.pop() : new FrictionEquation(bodyA, bodyB, mug * reducedMass);
          c1.bi = c2.bi = bodyA;
          c1.bj = c2.bj = bodyB;
          c1.minForce = c2.minForce = -mug * reducedMass;
          c1.maxForce = c2.maxForce = mug * reducedMass; // Copy over the relative vectors

          c1.ri.copy(contactEquation.ri);
          c1.rj.copy(contactEquation.rj);
          c2.ri.copy(contactEquation.ri);
          c2.rj.copy(contactEquation.rj); // Construct tangents

          contactEquation.ni.tangents(c1.t, c2.t); // Set spook params

          c1.setSpookParams(cm.frictionEquationStiffness, cm.frictionEquationRelaxation, world.dt);
          c2.setSpookParams(cm.frictionEquationStiffness, cm.frictionEquationRelaxation, world.dt);
          c1.enabled = c2.enabled = contactEquation.enabled;
          outArray.push(c1, c2);
          return true;
        }

        return false;
      };

      var averageNormal = new Vec3();
      var averageContactPointA = new Vec3();
      var averageContactPointB = new Vec3(); // Take the average N latest contact point on the plane.

      Narrowphase.prototype.createFrictionFromAverage = function (numContacts) {
        // The last contactEquation
        var c = this.result[this.result.length - 1]; // Create the result: two "average" friction equations

        if (!this.createFrictionEquationsFromContact(c, this.frictionResult) || numContacts === 1) {
          return;
        }

        var f1 = this.frictionResult[this.frictionResult.length - 2];
        var f2 = this.frictionResult[this.frictionResult.length - 1];
        averageNormal.setZero();
        averageContactPointA.setZero();
        averageContactPointB.setZero();
        var bodyA = c.bi;
        var bodyB = c.bj;

        for (var i = 0; i !== numContacts; i++) {
          c = this.result[this.result.length - 1 - i];

          if (c.bodyA !== bodyA) {
            averageNormal.vadd(c.ni, averageNormal);
            averageContactPointA.vadd(c.ri, averageContactPointA);
            averageContactPointB.vadd(c.rj, averageContactPointB);
          } else {
            averageNormal.vsub(c.ni, averageNormal);
            averageContactPointA.vadd(c.rj, averageContactPointA);
            averageContactPointB.vadd(c.ri, averageContactPointB);
          }
        }

        var invNumContacts = 1 / numContacts;
        averageContactPointA.scale(invNumContacts, f1.ri);
        averageContactPointB.scale(invNumContacts, f1.rj);
        f2.ri.copy(f1.ri); // Should be the same

        f2.rj.copy(f1.rj);
        averageNormal.normalize();
        averageNormal.tangents(f1.t, f2.t); // return eq;
      };

      var tmpVec1 = new Vec3();
      var tmpVec2 = new Vec3();
      var tmpQuat1 = new Quaternion();
      var tmpQuat2 = new Quaternion();
      /**
       * Generate all contacts between a list of body pairs
       * @method getContacts
       * @param {array} p1 Array of body indices
       * @param {array} p2 Array of body indices
       * @param {World} world
       * @param {array} result Array to store generated contacts
       * @param {array} oldcontacts Optional. Array of reusable contact objects
       */

      Narrowphase.prototype.getContacts = function (p1, p2, world, result, oldcontacts, frictionResult, frictionPool) {
        // Save old contact objects
        this.frictionEquationPool = frictionPool;
        this.result = result;
        this.frictionResult = frictionResult;
        var qi = tmpQuat1;
        var qj = tmpQuat2;
        var xi = tmpVec1;
        var xj = tmpVec2;

        for (var k = 0, N = p1.length; k !== N; k++) {
          // Get current collision bodies
          var bi = p1[k],
              bj = p2[k]; // Get contact material

          var bodyContactMaterial = null;

          if (bi.material && bj.material) {
            bodyContactMaterial = world.getContactMaterial(bi.material, bj.material) || null;
          }

          var justTest = bi.collisionResponse == false || bj.collisionResponse == false || bi.type & Body.KINEMATIC && bj.type & Body.STATIC || bi.type & Body.STATIC && bj.type & Body.KINEMATIC || bi.type & Body.KINEMATIC && bj.type & Body.KINEMATIC;

          for (var i = 0; i < bi.shapes.length; i++) {
            bi.quaternion.mult(bi.shapeOrientations[i], qi);
            bi.quaternion.vmult(bi.shapeOffsets[i], xi);
            xi.vadd(bi.position, xi);
            var si = bi.shapes[i];

            for (var j = 0; j < bj.shapes.length; j++) {
              // Compute world transform of shapes
              bj.quaternion.mult(bj.shapeOrientations[j], qj);
              bj.quaternion.vmult(bj.shapeOffsets[j], xj);
              xj.vadd(bj.position, xj);
              var sj = bj.shapes[j];

              if (!(si.collisionFilterMask & sj.collisionFilterGroup && sj.collisionFilterMask & si.collisionFilterGroup)) {
                continue;
              }

              if (xi.distanceTo(xj) > si.boundingSphereRadius + sj.boundingSphereRadius) {
                continue;
              } // is trigger ? ,trigger test just only


              justTest |= si.collisionResponse == false || sj.collisionResponse == false; // Get collision material

              var shapeContactMaterial = null;

              if (si.material && sj.material) {
                shapeContactMaterial = world.getContactMaterial(si.material, sj.material) || null;
              }

              this.currentContactMaterial = shapeContactMaterial || bodyContactMaterial || world.defaultContactMaterial; // Get contacts

              var resolver = this[si.type | sj.type];

              if (resolver) {
                var retval = false;

                if (si.type < sj.type) {
                  retval = resolver.call(this, si, sj, xi, xj, qi, qj, bi, bj, si, sj, justTest);
                } else {
                  retval = resolver.call(this, sj, si, xj, xi, qj, qi, bj, bi, si, sj, justTest);
                }

                if (retval && justTest) {
                  // Register overlap
                  world.shapeOverlapKeeper.set(si.id, sj.id);
                  world.shapeOverlapKeeperExit.set(si.id, sj.id);
                }
              }
            }
          }
        }
      };

      var numWarnings = 0;
      var maxWarnings = 10;

      function warn(msg) {
        if (numWarnings > maxWarnings) {
          return;
        }

        numWarnings++;
        console.warn(msg);
      }

      Narrowphase.prototype[Shape.types.BOX | Shape.types.BOX] = Narrowphase.prototype.boxBox = function (si, sj, xi, xj, qi, qj, bi, bj, rsi, rsj, justTest) {
        si.convexPolyhedronRepresentation.material = si.material;
        sj.convexPolyhedronRepresentation.material = sj.material;
        si.convexPolyhedronRepresentation.collisionResponse = si.collisionResponse;
        sj.convexPolyhedronRepresentation.collisionResponse = sj.collisionResponse;
        return this.convexConvex(si.convexPolyhedronRepresentation, sj.convexPolyhedronRepresentation, xi, xj, qi, qj, bi, bj, si, sj, justTest);
      };

      Narrowphase.prototype[Shape.types.BOX | Shape.types.CONVEXPOLYHEDRON] = Narrowphase.prototype.boxConvex = function (si, sj, xi, xj, qi, qj, bi, bj, rsi, rsj, justTest) {
        si.convexPolyhedronRepresentation.material = si.material;
        si.convexPolyhedronRepresentation.collisionResponse = si.collisionResponse;
        return this.convexConvex(si.convexPolyhedronRepresentation, sj, xi, xj, qi, qj, bi, bj, si, sj, justTest);
      };

      Narrowphase.prototype[Shape.types.BOX | Shape.types.PARTICLE] = Narrowphase.prototype.boxParticle = function (si, sj, xi, xj, qi, qj, bi, bj, rsi, rsj, justTest) {
        si.convexPolyhedronRepresentation.material = si.material;
        si.convexPolyhedronRepresentation.collisionResponse = si.collisionResponse;
        return this.convexParticle(si.convexPolyhedronRepresentation, sj, xi, xj, qi, qj, bi, bj, si, sj, justTest);
      };
      /**
       * @method sphereSphere
       * @param  {Shape}      si
       * @param  {Shape}      sj
       * @param  {Vec3}       xi
       * @param  {Vec3}       xj
       * @param  {Quaternion} qi
       * @param  {Quaternion} qj
       * @param  {Body}       bi
       * @param  {Body}       bj
       */


      Narrowphase.prototype[Shape.types.SPHERE] = Narrowphase.prototype.sphereSphere = function (si, sj, xi, xj, qi, qj, bi, bj, rsi, rsj, justTest) {
        if (justTest) {
          return xi.distanceSquared(xj) < Math.pow(si.radius + sj.radius, 2);
        } // We will have only one contact in this case


        var r = this.createContactEquation(bi, bj, si, sj, rsi, rsj); // Contact normal

        xj.vsub(xi, r.ni);
        r.ni.normalize(); // Contact point locations

        r.ri.copy(r.ni);
        r.rj.copy(r.ni);
        r.ri.mult(si.radius, r.ri);
        r.rj.mult(-sj.radius, r.rj);
        r.ri.vadd(xi, r.ri);
        r.ri.vsub(bi.position, r.ri);
        r.rj.vadd(xj, r.rj);
        r.rj.vsub(bj.position, r.rj);
        this.result.push(r);
        this.createFrictionEquationsFromContact(r, this.frictionResult);
      };
      /**
       * @method planeTrimesh
       * @param  {Shape}      si
       * @param  {Shape}      sj
       * @param  {Vec3}       xi
       * @param  {Vec3}       xj
       * @param  {Quaternion} qi
       * @param  {Quaternion} qj
       * @param  {Body}       bi
       * @param  {Body}       bj
       */


      var planeTrimesh_normal = new Vec3();
      var planeTrimesh_relpos = new Vec3();
      var planeTrimesh_projected = new Vec3();

      Narrowphase.prototype[Shape.types.PLANE | Shape.types.TRIMESH] = Narrowphase.prototype.planeTrimesh = function (planeShape, trimeshShape, planePos, trimeshPos, planeQuat, trimeshQuat, planeBody, trimeshBody, rsi, rsj, justTest) {
        // Make contacts!
        var v = new Vec3();
        var normal = planeTrimesh_normal;
        normal.set(0, 0, 1);
        planeQuat.vmult(normal, normal); // Turn normal according to plane

        for (var i = 0; i < trimeshShape.vertices.length / 3; i++) {
          // Get world vertex from trimesh
          trimeshShape.getVertex(i, v); // Safe up

          var v2 = new Vec3();
          v2.copy(v);
          Transform.pointToWorldFrame(trimeshPos, trimeshQuat, v2, v); // Check plane side

          var relpos = planeTrimesh_relpos;
          v.vsub(planePos, relpos);
          var dot = normal.dot(relpos);

          if (dot <= 0.0) {
            if (justTest) {
              return true;
            }

            var r = this.createContactEquation(planeBody, trimeshBody, planeShape, trimeshShape, rsi, rsj);
            r.ni.copy(normal); // Contact normal is the plane normal
            // Get vertex position projected on plane

            var projected = planeTrimesh_projected;
            normal.scale(relpos.dot(normal), projected);
            v.vsub(projected, projected); // ri is the projected world position minus plane position

            r.ri.copy(projected);
            r.ri.vsub(planeBody.position, r.ri);
            r.rj.copy(v);
            r.rj.vsub(trimeshBody.position, r.rj); // Store result

            this.result.push(r);
            this.createFrictionEquationsFromContact(r, this.frictionResult);
          }
        }
      };
      /**
       * @method sphereTrimesh
       * @param  {Shape}      sphereShape
       * @param  {Shape}      trimeshShape
       * @param  {Vec3}       spherePos
       * @param  {Vec3}       trimeshPos
       * @param  {Quaternion} sphereQuat
       * @param  {Quaternion} trimeshQuat
       * @param  {Body}       sphereBody
       * @param  {Body}       trimeshBody
       */


      var sphereTrimesh_normal = new Vec3();
      var sphereTrimesh_relpos = new Vec3();
      var sphereTrimesh_projected = new Vec3();
      var sphereTrimesh_v = new Vec3();
      var sphereTrimesh_v2 = new Vec3();
      var sphereTrimesh_edgeVertexA = new Vec3();
      var sphereTrimesh_edgeVertexB = new Vec3();
      var sphereTrimesh_edgeVector = new Vec3();
      var sphereTrimesh_edgeVectorUnit = new Vec3();
      var sphereTrimesh_localSpherePos = new Vec3();
      var sphereTrimesh_tmp = new Vec3();
      var sphereTrimesh_va = new Vec3();
      var sphereTrimesh_vb = new Vec3();
      var sphereTrimesh_vc = new Vec3();
      var sphereTrimesh_localSphereAABB = new AABB();
      var sphereTrimesh_triangles = [];

      Narrowphase.prototype[Shape.types.SPHERE | Shape.types.TRIMESH] = Narrowphase.prototype.sphereTrimesh = function (sphereShape, trimeshShape, spherePos, trimeshPos, sphereQuat, trimeshQuat, sphereBody, trimeshBody, rsi, rsj, justTest) {
        var edgeVertexA = sphereTrimesh_edgeVertexA;
        var edgeVertexB = sphereTrimesh_edgeVertexB;
        var edgeVector = sphereTrimesh_edgeVector;
        var edgeVectorUnit = sphereTrimesh_edgeVectorUnit;
        var localSpherePos = sphereTrimesh_localSpherePos;
        var tmp = sphereTrimesh_tmp;
        var localSphereAABB = sphereTrimesh_localSphereAABB;
        var v2 = sphereTrimesh_v2;
        var relpos = sphereTrimesh_relpos;
        var triangles = sphereTrimesh_triangles; // Convert sphere position to local in the trimesh

        Transform.pointToLocalFrame(trimeshPos, trimeshQuat, spherePos, localSpherePos); // Get the aabb of the sphere locally in the trimesh

        var sphereRadius = sphereShape.radius;
        localSphereAABB.lowerBound.set(localSpherePos.x - sphereRadius, localSpherePos.y - sphereRadius, localSpherePos.z - sphereRadius);
        localSphereAABB.upperBound.set(localSpherePos.x + sphereRadius, localSpherePos.y + sphereRadius, localSpherePos.z + sphereRadius);
        trimeshShape.getTrianglesInAABB(localSphereAABB, triangles); //for (var i = 0; i < trimeshShape.indices.length / 3; i++) triangles.push(i); // All
        // Vertices

        var v = sphereTrimesh_v;
        var radiusSquared = sphereShape.radius * sphereShape.radius;

        for (var i = 0; i < triangles.length; i++) {
          for (var j = 0; j < 3; j++) {
            trimeshShape.getVertex(trimeshShape.indices[triangles[i] * 3 + j], v); // Check vertex overlap in sphere

            v.vsub(localSpherePos, relpos);

            if (relpos.norm2() <= radiusSquared) {
              // Safe up
              v2.copy(v);
              Transform.pointToWorldFrame(trimeshPos, trimeshQuat, v2, v);
              v.vsub(spherePos, relpos);

              if (justTest) {
                return true;
              }

              var r = this.createContactEquation(sphereBody, trimeshBody, sphereShape, trimeshShape, rsi, rsj);
              r.ni.copy(relpos);
              r.ni.normalize(); // ri is the vector from sphere center to the sphere surface

              r.ri.copy(r.ni);
              r.ri.scale(sphereShape.radius, r.ri);
              r.ri.vadd(spherePos, r.ri);
              r.ri.vsub(sphereBody.position, r.ri);
              r.rj.copy(v);
              r.rj.vsub(trimeshBody.position, r.rj); // Store result

              this.result.push(r);
              this.createFrictionEquationsFromContact(r, this.frictionResult);
            }
          }
        } // Check all edges


        for (var i = 0; i < triangles.length; i++) {
          for (var j = 0; j < 3; j++) {
            trimeshShape.getVertex(trimeshShape.indices[triangles[i] * 3 + j], edgeVertexA);
            trimeshShape.getVertex(trimeshShape.indices[triangles[i] * 3 + (j + 1) % 3], edgeVertexB);
            edgeVertexB.vsub(edgeVertexA, edgeVector); // Project sphere position to the edge

            localSpherePos.vsub(edgeVertexB, tmp);
            var positionAlongEdgeB = tmp.dot(edgeVector);
            localSpherePos.vsub(edgeVertexA, tmp);
            var positionAlongEdgeA = tmp.dot(edgeVector);

            if (positionAlongEdgeA > 0 && positionAlongEdgeB < 0) {
              // Now check the orthogonal distance from edge to sphere center
              localSpherePos.vsub(edgeVertexA, tmp);
              edgeVectorUnit.copy(edgeVector);
              edgeVectorUnit.normalize();
              positionAlongEdgeA = tmp.dot(edgeVectorUnit);
              edgeVectorUnit.scale(positionAlongEdgeA, tmp);
              tmp.vadd(edgeVertexA, tmp); // tmp is now the sphere center position projected to the edge, defined locally in the trimesh frame

              var dist = tmp.distanceTo(localSpherePos);

              if (dist < sphereShape.radius) {
                if (justTest) {
                  return true;
                }

                var r = this.createContactEquation(sphereBody, trimeshBody, sphereShape, trimeshShape, rsi, rsj);
                tmp.vsub(localSpherePos, r.ni);
                r.ni.normalize();
                r.ni.scale(sphereShape.radius, r.ri);
                Transform.pointToWorldFrame(trimeshPos, trimeshQuat, tmp, tmp);
                tmp.vsub(trimeshBody.position, r.rj);
                Transform.vectorToWorldFrame(trimeshQuat, r.ni, r.ni);
                Transform.vectorToWorldFrame(trimeshQuat, r.ri, r.ri);
                this.result.push(r);
                this.createFrictionEquationsFromContact(r, this.frictionResult);
              }
            }
          }
        } // Triangle faces


        var va = sphereTrimesh_va;
        var vb = sphereTrimesh_vb;
        var vc = sphereTrimesh_vc;
        var normal = sphereTrimesh_normal;

        for (var i = 0, N = triangles.length; i !== N; i++) {
          trimeshShape.getTriangleVertices(triangles[i], va, vb, vc);
          trimeshShape.getNormal(triangles[i], normal);
          localSpherePos.vsub(va, tmp);
          var dist = tmp.dot(normal);
          normal.scale(dist, tmp);
          localSpherePos.vsub(tmp, tmp); // tmp is now the sphere position projected to the triangle plane

          dist = tmp.distanceTo(localSpherePos);

          if (Ray.pointInTriangle(tmp, va, vb, vc) && dist < sphereShape.radius) {
            if (justTest) {
              return true;
            }

            var r = this.createContactEquation(sphereBody, trimeshBody, sphereShape, trimeshShape, rsi, rsj);
            tmp.vsub(localSpherePos, r.ni);
            r.ni.normalize();
            r.ni.scale(sphereShape.radius, r.ri);
            Transform.pointToWorldFrame(trimeshPos, trimeshQuat, tmp, tmp);
            tmp.vsub(trimeshBody.position, r.rj);
            Transform.vectorToWorldFrame(trimeshQuat, r.ni, r.ni);
            Transform.vectorToWorldFrame(trimeshQuat, r.ri, r.ri);
            this.result.push(r);
            this.createFrictionEquationsFromContact(r, this.frictionResult);
          }
        }

        triangles.length = 0;
      };

      var point_on_plane_to_sphere = new Vec3();
      var plane_to_sphere_ortho = new Vec3();
      var p_s_ni = new Vec3();
      var p_s_ri = new Vec3();
      var p_s_rj = new Vec3();
      /**
       * @method spherePlane
       * @param  {Shape}      si
       * @param  {Shape}      sj
       * @param  {Vec3}       xi
       * @param  {Vec3}       xj
       * @param  {Quaternion} qi
       * @param  {Quaternion} qj
       * @param  {Body}       bi
       * @param  {Body}       bj
       */

      Narrowphase.prototype[Shape.types.SPHERE | Shape.types.PLANE] = Narrowphase.prototype.spherePlane = function (si, sj, xi, xj, qi, qj, bi, bj, rsi, rsj, justTest) {
        // Contact normal
        p_s_ni.set(0, 0, 1);
        qj.vmult(p_s_ni, p_s_ni);
        p_s_ni.negate(p_s_ni); // body i is the sphere, flip normal

        p_s_ni.normalize(); // Needed?
        // Vector from sphere center to contact point

        p_s_ni.mult(si.radius, p_s_ri); // Project down sphere on plane

        xi.vsub(xj, point_on_plane_to_sphere);
        p_s_ni.mult(p_s_ni.dot(point_on_plane_to_sphere), plane_to_sphere_ortho);
        point_on_plane_to_sphere.vsub(plane_to_sphere_ortho, p_s_rj); // The sphere position projected to plane

        if (-point_on_plane_to_sphere.dot(p_s_ni) <= si.radius) {
          if (justTest) {
            return true;
          } // We will have one contact in this case


          var r = this.createContactEquation(bi, bj, si, sj, rsi, rsj); // Make it relative to the body

          r.ni.copy(p_s_ni);
          r.ri.copy(p_s_ri);
          r.rj.copy(p_s_rj);
          var ri = r.ri;
          var rj = r.rj;
          ri.vadd(xi, ri);
          ri.vsub(bi.position, ri);
          rj.vadd(xj, rj);
          rj.vsub(bj.position, rj);
          this.result.push(r);
          this.createFrictionEquationsFromContact(r, this.frictionResult);
        }
      }; // See http://bulletphysics.com/Bullet/BulletFull/SphereTriangleDetector_8cpp_source.html


      var pointInPolygon_edge = new Vec3();
      var pointInPolygon_edge_x_normal = new Vec3();
      var pointInPolygon_vtp = new Vec3();

      function pointInPolygon(verts, normal, p) {
        var positiveResult = null;
        var N = verts.length;

        for (var i = 0; i !== N; i++) {
          var v = verts[i]; // Get edge to the next vertex

          var edge = pointInPolygon_edge;
          verts[(i + 1) % N].vsub(v, edge); // Get cross product between polygon normal and the edge

          var edge_x_normal = pointInPolygon_edge_x_normal; //var edge_x_normal = new Vec3();

          edge.cross(normal, edge_x_normal); // Get vector between point and current vertex

          var vertex_to_p = pointInPolygon_vtp;
          p.vsub(v, vertex_to_p); // This dot product determines which side of the edge the point is

          var r = edge_x_normal.dot(vertex_to_p); // If all such dot products have same sign, we are inside the polygon.

          if (positiveResult === null || r > 0 && positiveResult === true || r <= 0 && positiveResult === false) {
            if (positiveResult === null) {
              positiveResult = r > 0;
            }

            continue;
          } else {
            return false; // Encountered some other sign. Exit.
          }
        } // If we got here, all dot products were of the same sign.


        return true;
      }

      var box_to_sphere = new Vec3();
      var sphereBox_ns = new Vec3();
      var sphereBox_ns1 = new Vec3();
      var sphereBox_ns2 = new Vec3();
      var sphereBox_sides = [new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3(), new Vec3()];
      var sphereBox_sphere_to_corner = new Vec3();
      var sphereBox_side_ns = new Vec3();
      var sphereBox_side_ns1 = new Vec3();
      var sphereBox_side_ns2 = new Vec3();
      /**
       * @method sphereBox
       * @param  {Shape}      si
       * @param  {Shape}      sj
       * @param  {Vec3}       xi
       * @param  {Vec3}       xj
       * @param  {Quaternion} qi
       * @param  {Quaternion} qj
       * @param  {Body}       bi
       * @param  {Body}       bj
       */

      Narrowphase.prototype[Shape.types.SPHERE | Shape.types.BOX] = Narrowphase.prototype.sphereBox = function (si, sj, xi, xj, qi, qj, bi, bj, rsi, rsj, justTest) {
        var v3pool = this.v3pool; // we refer to the box as body j

        var sides = sphereBox_sides;
        xi.vsub(xj, box_to_sphere);
        sj.getSideNormals(sides, qj);
        var R = si.radius;
        var penetrating_sides = []; // Check side (plane) intersections

        var found = false; // Store the resulting side penetration info

        var side_ns = sphereBox_side_ns;
        var side_ns1 = sphereBox_side_ns1;
        var side_ns2 = sphereBox_side_ns2;
        var side_h = null;
        var side_penetrations = 0;
        var side_dot1 = 0;
        var side_dot2 = 0;
        var side_distance = null;

        for (var idx = 0, nsides = sides.length; idx !== nsides && found === false; idx++) {
          // Get the plane side normal (ns)
          var ns = sphereBox_ns;
          ns.copy(sides[idx]);
          var h = ns.norm();
          ns.normalize(); // The normal/distance dot product tells which side of the plane we are

          var dot = box_to_sphere.dot(ns);

          if (dot < h + R && dot > 0) {
            // Intersects plane. Now check the other two dimensions
            var ns1 = sphereBox_ns1;
            var ns2 = sphereBox_ns2;
            ns1.copy(sides[(idx + 1) % 3]);
            ns2.copy(sides[(idx + 2) % 3]);
            var h1 = ns1.norm();
            var h2 = ns2.norm();
            ns1.normalize();
            ns2.normalize();
            var dot1 = box_to_sphere.dot(ns1);
            var dot2 = box_to_sphere.dot(ns2);

            if (dot1 < h1 && dot1 > -h1 && dot2 < h2 && dot2 > -h2) {
              var dist = Math.abs(dot - h - R);

              if (side_distance === null || dist < side_distance) {
                side_distance = dist;
                side_dot1 = dot1;
                side_dot2 = dot2;
                side_h = h;
                side_ns.copy(ns);
                side_ns1.copy(ns1);
                side_ns2.copy(ns2);
                side_penetrations++;

                if (justTest) {
                  return true;
                }
              }
            }
          }
        }

        if (side_penetrations) {
          found = true;
          var r = this.createContactEquation(bi, bj, si, sj, rsi, rsj);
          side_ns.mult(-R, r.ri); // Sphere r

          r.ni.copy(side_ns);
          r.ni.negate(r.ni); // Normal should be out of sphere

          side_ns.mult(side_h, side_ns);
          side_ns1.mult(side_dot1, side_ns1);
          side_ns.vadd(side_ns1, side_ns);
          side_ns2.mult(side_dot2, side_ns2);
          side_ns.vadd(side_ns2, r.rj); // Make relative to bodies

          r.ri.vadd(xi, r.ri);
          r.ri.vsub(bi.position, r.ri);
          r.rj.vadd(xj, r.rj);
          r.rj.vsub(bj.position, r.rj);
          this.result.push(r);
          this.createFrictionEquationsFromContact(r, this.frictionResult);
        } // Check corners


        var rj = v3pool.get();
        var sphere_to_corner = sphereBox_sphere_to_corner;

        for (var j = 0; j !== 2 && !found; j++) {
          for (var k = 0; k !== 2 && !found; k++) {
            for (var l = 0; l !== 2 && !found; l++) {
              rj.set(0, 0, 0);

              if (j) {
                rj.vadd(sides[0], rj);
              } else {
                rj.vsub(sides[0], rj);
              }

              if (k) {
                rj.vadd(sides[1], rj);
              } else {
                rj.vsub(sides[1], rj);
              }

              if (l) {
                rj.vadd(sides[2], rj);
              } else {
                rj.vsub(sides[2], rj);
              } // World position of corner


              xj.vadd(rj, sphere_to_corner);
              sphere_to_corner.vsub(xi, sphere_to_corner);

              if (sphere_to_corner.norm2() < R * R) {
                if (justTest) {
                  return true;
                }

                found = true;
                var r = this.createContactEquation(bi, bj, si, sj, rsi, rsj);
                r.ri.copy(sphere_to_corner);
                r.ri.normalize();
                r.ni.copy(r.ri);
                r.ri.mult(R, r.ri);
                r.rj.copy(rj); // Make relative to bodies

                r.ri.vadd(xi, r.ri);
                r.ri.vsub(bi.position, r.ri);
                r.rj.vadd(xj, r.rj);
                r.rj.vsub(bj.position, r.rj);
                this.result.push(r);
                this.createFrictionEquationsFromContact(r, this.frictionResult);
              }
            }
          }
        }

        v3pool.release(rj);
        rj = null; // Check edges

        var edgeTangent = v3pool.get();
        var edgeCenter = v3pool.get();
        var r = v3pool.get(); // r = edge center to sphere center

        var orthogonal = v3pool.get();
        var dist = v3pool.get();
        var Nsides = sides.length;

        for (var j = 0; j !== Nsides && !found; j++) {
          for (var k = 0; k !== Nsides && !found; k++) {
            if (j % 3 !== k % 3) {
              // Get edge tangent
              sides[k].cross(sides[j], edgeTangent);
              edgeTangent.normalize();
              sides[j].vadd(sides[k], edgeCenter);
              r.copy(xi);
              r.vsub(edgeCenter, r);
              r.vsub(xj, r);
              var orthonorm = r.dot(edgeTangent); // distance from edge center to sphere center in the tangent direction

              edgeTangent.mult(orthonorm, orthogonal); // Vector from edge center to sphere center in the tangent direction
              // Find the third side orthogonal to this one

              var l = 0;

              while (l === j % 3 || l === k % 3) {
                l++;
              } // vec from edge center to sphere projected to the plane orthogonal to the edge tangent


              dist.copy(xi);
              dist.vsub(orthogonal, dist);
              dist.vsub(edgeCenter, dist);
              dist.vsub(xj, dist); // Distances in tangent direction and distance in the plane orthogonal to it

              var tdist = Math.abs(orthonorm);
              var ndist = dist.norm();

              if (tdist < sides[l].norm() && ndist < R) {
                if (justTest) {
                  return true;
                }

                found = true;
                var res = this.createContactEquation(bi, bj, si, sj, rsi, rsj);
                edgeCenter.vadd(orthogonal, res.rj); // box rj

                res.rj.copy(res.rj);
                dist.negate(res.ni);
                res.ni.normalize();
                res.ri.copy(res.rj);
                res.ri.vadd(xj, res.ri);
                res.ri.vsub(xi, res.ri);
                res.ri.normalize();
                res.ri.mult(R, res.ri); // Make relative to bodies

                res.ri.vadd(xi, res.ri);
                res.ri.vsub(bi.position, res.ri);
                res.rj.vadd(xj, res.rj);
                res.rj.vsub(bj.position, res.rj);
                this.result.push(res);
                this.createFrictionEquationsFromContact(res, this.frictionResult);
              }
            }
          }
        }

        v3pool.release(edgeTangent, edgeCenter, r, orthogonal, dist);
      };

      var convex_to_sphere = new Vec3();
      var sphereConvex_edge = new Vec3();
      var sphereConvex_edgeUnit = new Vec3();
      var sphereConvex_sphereToCorner = new Vec3();
      var sphereConvex_worldCorner = new Vec3();
      var sphereConvex_worldNormal = new Vec3();
      var sphereConvex_worldPoint = new Vec3();
      var sphereConvex_worldSpherePointClosestToPlane = new Vec3();
      var sphereConvex_penetrationVec = new Vec3();
      var sphereConvex_sphereToWorldPoint = new Vec3();
      /**
       * @method sphereConvex
       * @param  {Shape}      si
       * @param  {Shape}      sj
       * @param  {Vec3}       xi
       * @param  {Vec3}       xj
       * @param  {Quaternion} qi
       * @param  {Quaternion} qj
       * @param  {Body}       bi
       * @param  {Body}       bj
       */

      Narrowphase.prototype[Shape.types.SPHERE | Shape.types.CONVEXPOLYHEDRON] = Narrowphase.prototype.sphereConvex = function (si, sj, xi, xj, qi, qj, bi, bj, rsi, rsj, justTest) {
        var v3pool = this.v3pool;
        xi.vsub(xj, convex_to_sphere);
        var normals = sj.faceNormals;
        var faces = sj.faces;
        var verts = sj.vertices;
        var R = si.radius;
        var penetrating_sides = []; // if(convex_to_sphere.norm2() > si.boundingSphereRadius + sj.boundingSphereRadius){
        //     return;
        // }
        // Check corners

        for (var i = 0; i !== verts.length; i++) {
          var v = verts[i]; // World position of corner

          var worldCorner = sphereConvex_worldCorner;
          qj.vmult(v, worldCorner);
          xj.vadd(worldCorner, worldCorner);
          var sphere_to_corner = sphereConvex_sphereToCorner;
          worldCorner.vsub(xi, sphere_to_corner);

          if (sphere_to_corner.norm2() < R * R) {
            if (justTest) {
              return true;
            }

            found = true;
            var r = this.createContactEquation(bi, bj, si, sj, rsi, rsj);
            r.ri.copy(sphere_to_corner);
            r.ri.normalize();
            r.ni.copy(r.ri);
            r.ri.mult(R, r.ri);
            worldCorner.vsub(xj, r.rj); // Should be relative to the body.

            r.ri.vadd(xi, r.ri);
            r.ri.vsub(bi.position, r.ri); // Should be relative to the body.

            r.rj.vadd(xj, r.rj);
            r.rj.vsub(bj.position, r.rj);
            this.result.push(r);
            this.createFrictionEquationsFromContact(r, this.frictionResult);
            return;
          }
        } // Check side (plane) intersections


        var found = false;

        for (var i = 0, nfaces = faces.length; i !== nfaces && found === false; i++) {
          var normal = normals[i];
          var face = faces[i]; // Get world-transformed normal of the face

          var worldNormal = sphereConvex_worldNormal;
          qj.vmult(normal, worldNormal); // Get a world vertex from the face

          var worldPoint = sphereConvex_worldPoint;
          qj.vmult(verts[face[0]], worldPoint);
          worldPoint.vadd(xj, worldPoint); // Get a point on the sphere, closest to the face normal

          var worldSpherePointClosestToPlane = sphereConvex_worldSpherePointClosestToPlane;
          worldNormal.mult(-R, worldSpherePointClosestToPlane);
          xi.vadd(worldSpherePointClosestToPlane, worldSpherePointClosestToPlane); // Vector from a face point to the closest point on the sphere

          var penetrationVec = sphereConvex_penetrationVec;
          worldSpherePointClosestToPlane.vsub(worldPoint, penetrationVec); // The penetration. Negative value means overlap.

          var penetration = penetrationVec.dot(worldNormal);
          var worldPointToSphere = sphereConvex_sphereToWorldPoint;
          xi.vsub(worldPoint, worldPointToSphere);

          if (penetration < 0 && worldPointToSphere.dot(worldNormal) > 0) {
            // Intersects plane. Now check if the sphere is inside the face polygon
            var faceVerts = []; // Face vertices, in world coords

            for (var j = 0, Nverts = face.length; j !== Nverts; j++) {
              var worldVertex = v3pool.get();
              qj.vmult(verts[face[j]], worldVertex);
              xj.vadd(worldVertex, worldVertex);
              faceVerts.push(worldVertex);
            }

            if (pointInPolygon(faceVerts, worldNormal, xi)) {
              // Is the sphere center in the face polygon?
              if (justTest) {
                return true;
              }

              found = true;
              var r = this.createContactEquation(bi, bj, si, sj, rsi, rsj);
              worldNormal.mult(-R, r.ri); // Contact offset, from sphere center to contact

              worldNormal.negate(r.ni); // Normal pointing out of sphere

              var penetrationVec2 = v3pool.get();
              worldNormal.mult(-penetration, penetrationVec2);
              var penetrationSpherePoint = v3pool.get();
              worldNormal.mult(-R, penetrationSpherePoint); //xi.vsub(xj).vadd(penetrationSpherePoint).vadd(penetrationVec2 , r.rj);

              xi.vsub(xj, r.rj);
              r.rj.vadd(penetrationSpherePoint, r.rj);
              r.rj.vadd(penetrationVec2, r.rj); // Should be relative to the body.

              r.rj.vadd(xj, r.rj);
              r.rj.vsub(bj.position, r.rj); // Should be relative to the body.

              r.ri.vadd(xi, r.ri);
              r.ri.vsub(bi.position, r.ri);
              v3pool.release(penetrationVec2);
              v3pool.release(penetrationSpherePoint);
              this.result.push(r);
              this.createFrictionEquationsFromContact(r, this.frictionResult); // Release world vertices

              for (var j = 0, Nfaceverts = faceVerts.length; j !== Nfaceverts; j++) {
                v3pool.release(faceVerts[j]);
              }

              return; // We only expect *one* face contact
            } else {
              // Edge?
              for (var j = 0; j !== face.length; j++) {
                // Get two world transformed vertices
                var v1 = v3pool.get();
                var v2 = v3pool.get();
                qj.vmult(verts[face[(j + 1) % face.length]], v1);
                qj.vmult(verts[face[(j + 2) % face.length]], v2);
                xj.vadd(v1, v1);
                xj.vadd(v2, v2); // Construct edge vector

                var edge = sphereConvex_edge;
                v2.vsub(v1, edge); // Construct the same vector, but normalized

                var edgeUnit = sphereConvex_edgeUnit;
                edge.unit(edgeUnit); // p is xi projected onto the edge

                var p = v3pool.get();
                var v1_to_xi = v3pool.get();
                xi.vsub(v1, v1_to_xi);
                var dot = v1_to_xi.dot(edgeUnit);
                edgeUnit.mult(dot, p);
                p.vadd(v1, p); // Compute a vector from p to the center of the sphere

                var xi_to_p = v3pool.get();
                p.vsub(xi, xi_to_p); // Collision if the edge-sphere distance is less than the radius
                // AND if p is in between v1 and v2

                if (dot > 0 && dot * dot < edge.norm2() && xi_to_p.norm2() < R * R) {
                  // Collision if the edge-sphere distance is less than the radius
                  // Edge contact!
                  if (justTest) {
                    return true;
                  }

                  var r = this.createContactEquation(bi, bj, si, sj, rsi, rsj);
                  p.vsub(xj, r.rj);
                  p.vsub(xi, r.ni);
                  r.ni.normalize();
                  r.ni.mult(R, r.ri); // Should be relative to the body.

                  r.rj.vadd(xj, r.rj);
                  r.rj.vsub(bj.position, r.rj); // Should be relative to the body.

                  r.ri.vadd(xi, r.ri);
                  r.ri.vsub(bi.position, r.ri);
                  this.result.push(r);
                  this.createFrictionEquationsFromContact(r, this.frictionResult); // Release world vertices

                  for (var j = 0, Nfaceverts = faceVerts.length; j !== Nfaceverts; j++) {
                    v3pool.release(faceVerts[j]);
                  }

                  v3pool.release(v1);
                  v3pool.release(v2);
                  v3pool.release(p);
                  v3pool.release(xi_to_p);
                  v3pool.release(v1_to_xi);
                  return;
                }

                v3pool.release(v1);
                v3pool.release(v2);
                v3pool.release(p);
                v3pool.release(xi_to_p);
                v3pool.release(v1_to_xi);
              }
            } // Release world vertices


            for (var j = 0, Nfaceverts = faceVerts.length; j !== Nfaceverts; j++) {
              v3pool.release(faceVerts[j]);
            }
          }
        }
      };

      var planeBox_normal = new Vec3();
      var plane_to_corner = new Vec3();
      /**
       * @method planeBox
       * @param  {Array}      result
       * @param  {Shape}      si
       * @param  {Shape}      sj
       * @param  {Vec3}       xi
       * @param  {Vec3}       xj
       * @param  {Quaternion} qi
       * @param  {Quaternion} qj
       * @param  {Body}       bi
       * @param  {Body}       bj
       */

      Narrowphase.prototype[Shape.types.PLANE | Shape.types.BOX] = Narrowphase.prototype.planeBox = function (si, sj, xi, xj, qi, qj, bi, bj, rsi, rsj, justTest) {
        sj.convexPolyhedronRepresentation.material = sj.material;
        sj.convexPolyhedronRepresentation.collisionResponse = sj.collisionResponse;
        sj.convexPolyhedronRepresentation.id = sj.id;
        return this.planeConvex(si, sj.convexPolyhedronRepresentation, xi, xj, qi, qj, bi, bj, si, sj, justTest);
      };

      var planeConvex_v = new Vec3();
      var planeConvex_normal = new Vec3();
      var planeConvex_relpos = new Vec3();
      var planeConvex_projected = new Vec3();
      /**
       * @method planeConvex
       * @param  {Shape}      si
       * @param  {Shape}      sj
       * @param  {Vec3}       xi
       * @param  {Vec3}       xj
       * @param  {Quaternion} qi
       * @param  {Quaternion} qj
       * @param  {Body}       bi
       * @param  {Body}       bj
       */

      Narrowphase.prototype[Shape.types.PLANE | Shape.types.CONVEXPOLYHEDRON] = Narrowphase.prototype.planeConvex = function (planeShape, convexShape, planePosition, convexPosition, planeQuat, convexQuat, planeBody, convexBody, si, sj, justTest) {
        // Simply return the points behind the plane.
        var worldVertex = planeConvex_v,
            worldNormal = planeConvex_normal;
        worldNormal.set(0, 0, 1);
        planeQuat.vmult(worldNormal, worldNormal); // Turn normal according to plane orientation

        var numContacts = 0;
        var relpos = planeConvex_relpos;

        for (var i = 0; i !== convexShape.vertices.length; i++) {
          // Get world convex vertex
          worldVertex.copy(convexShape.vertices[i]);
          convexQuat.vmult(worldVertex, worldVertex);
          convexPosition.vadd(worldVertex, worldVertex);
          worldVertex.vsub(planePosition, relpos);
          var dot = worldNormal.dot(relpos);

          if (dot <= 0.0) {
            if (justTest) {
              return true;
            }

            var r = this.createContactEquation(planeBody, convexBody, planeShape, convexShape, si, sj); // Get vertex position projected on plane

            var projected = planeConvex_projected;
            worldNormal.mult(worldNormal.dot(relpos), projected);
            worldVertex.vsub(projected, projected);
            projected.vsub(planePosition, r.ri); // From plane to vertex projected on plane

            r.ni.copy(worldNormal); // Contact normal is the plane normal out from plane
            // rj is now just the vector from the convex center to the vertex

            worldVertex.vsub(convexPosition, r.rj); // Make it relative to the body

            r.ri.vadd(planePosition, r.ri);
            r.ri.vsub(planeBody.position, r.ri);
            r.rj.vadd(convexPosition, r.rj);
            r.rj.vsub(convexBody.position, r.rj);
            this.result.push(r);
            numContacts++;

            if (!this.enableFrictionReduction) {
              this.createFrictionEquationsFromContact(r, this.frictionResult);
            }
          }
        }

        if (this.enableFrictionReduction && numContacts) {
          this.createFrictionFromAverage(numContacts);
        }
      };

      var convexConvex_sepAxis = new Vec3();
      var convexConvex_q = new Vec3();
      /**
       * @method convexConvex
       * @param  {Shape}      si
       * @param  {Shape}      sj
       * @param  {Vec3}       xi
       * @param  {Vec3}       xj
       * @param  {Quaternion} qi
       * @param  {Quaternion} qj
       * @param  {Body}       bi
       * @param  {Body}       bj
       */

      Narrowphase.prototype[Shape.types.CONVEXPOLYHEDRON] = Narrowphase.prototype.convexConvex = function (si, sj, xi, xj, qi, qj, bi, bj, rsi, rsj, justTest, faceListA, faceListB) {
        var sepAxis = convexConvex_sepAxis;

        if (xi.distanceTo(xj) > si.boundingSphereRadius + sj.boundingSphereRadius) {
          return;
        }

        if (si.findSeparatingAxis(sj, xi, qi, xj, qj, sepAxis, faceListA, faceListB)) {
          var res = [];
          var q = convexConvex_q;
          si.clipAgainstHull(xi, qi, sj, xj, qj, sepAxis, -100, 100, res);
          var numContacts = 0;

          for (var j = 0; j !== res.length; j++) {
            if (justTest) {
              return true;
            }

            var r = this.createContactEquation(bi, bj, si, sj, rsi, rsj),
                ri = r.ri,
                rj = r.rj;
            sepAxis.negate(r.ni);
            res[j].normal.negate(q);
            q.mult(res[j].depth, q);
            res[j].point.vadd(q, ri);
            rj.copy(res[j].point); // Contact points are in world coordinates. Transform back to relative

            ri.vsub(xi, ri);
            rj.vsub(xj, rj); // Make relative to bodies

            ri.vadd(xi, ri);
            ri.vsub(bi.position, ri);
            rj.vadd(xj, rj);
            rj.vsub(bj.position, rj);
            this.result.push(r);
            numContacts++;

            if (!this.enableFrictionReduction) {
              this.createFrictionEquationsFromContact(r, this.frictionResult);
            }
          }

          if (this.enableFrictionReduction && numContacts) {
            this.createFrictionFromAverage(numContacts);
          }
        }
      };
      /**
       * @method convexTrimesh
       * @param  {Array}      result
       * @param  {Shape}      si
       * @param  {Shape}      sj
       * @param  {Vec3}       xi
       * @param  {Vec3}       xj
       * @param  {Quaternion} qi
       * @param  {Quaternion} qj
       * @param  {Body}       bi
       * @param  {Body}       bj
       */
      // Narrowphase.prototype[Shape.types.CONVEXPOLYHEDRON | Shape.types.TRIMESH] =
      // Narrowphase.prototype.convexTrimesh = function(si,sj,xi,xj,qi,qj,bi,bj,rsi,rsj,faceListA,faceListB){
      //     var sepAxis = convexConvex_sepAxis;
      //     if(xi.distanceTo(xj) > si.boundingSphereRadius + sj.boundingSphereRadius){
      //         return;
      //     }
      //     // Construct a temp hull for each triangle
      //     var hullB = new ConvexPolyhedron();
      //     hullB.faces = [[0,1,2]];
      //     var va = new Vec3();
      //     var vb = new Vec3();
      //     var vc = new Vec3();
      //     hullB.vertices = [
      //         va,
      //         vb,
      //         vc
      //     ];
      //     for (var i = 0; i < sj.indices.length / 3; i++) {
      //         var triangleNormal = new Vec3();
      //         sj.getNormal(i, triangleNormal);
      //         hullB.faceNormals = [triangleNormal];
      //         sj.getTriangleVertices(i, va, vb, vc);
      //         var d = si.testSepAxis(triangleNormal, hullB, xi, qi, xj, qj);
      //         if(!d){
      //             triangleNormal.scale(-1, triangleNormal);
      //             d = si.testSepAxis(triangleNormal, hullB, xi, qi, xj, qj);
      //             if(!d){
      //                 continue;
      //             }
      //         }
      //         var res = [];
      //         var q = convexConvex_q;
      //         si.clipAgainstHull(xi,qi,hullB,xj,qj,triangleNormal,-100,100,res);
      //         for(var j = 0; j !== res.length; j++){
      //             var r = this.createContactEquation(bi,bj,si,sj,rsi,rsj),
      //                 ri = r.ri,
      //                 rj = r.rj;
      //             r.ni.copy(triangleNormal);
      //             r.ni.negate(r.ni);
      //             res[j].normal.negate(q);
      //             q.mult(res[j].depth, q);
      //             res[j].point.vadd(q, ri);
      //             rj.copy(res[j].point);
      //             // Contact points are in world coordinates. Transform back to relative
      //             ri.vsub(xi,ri);
      //             rj.vsub(xj,rj);
      //             // Make relative to bodies
      //             ri.vadd(xi, ri);
      //             ri.vsub(bi.position, ri);
      //             rj.vadd(xj, rj);
      //             rj.vsub(bj.position, rj);
      //             result.push(r);
      //         }
      //     }
      // };


      var particlePlane_normal = new Vec3();
      var particlePlane_relpos = new Vec3();
      var particlePlane_projected = new Vec3();
      /**
       * @method particlePlane
       * @param  {Array}      result
       * @param  {Shape}      si
       * @param  {Shape}      sj
       * @param  {Vec3}       xi
       * @param  {Vec3}       xj
       * @param  {Quaternion} qi
       * @param  {Quaternion} qj
       * @param  {Body}       bi
       * @param  {Body}       bj
       */

      Narrowphase.prototype[Shape.types.PLANE | Shape.types.PARTICLE] = Narrowphase.prototype.planeParticle = function (sj, si, xj, xi, qj, qi, bj, bi, rsi, rsj, justTest) {
        var normal = particlePlane_normal;
        normal.set(0, 0, 1);
        bj.quaternion.vmult(normal, normal); // Turn normal according to plane orientation

        var relpos = particlePlane_relpos;
        xi.vsub(bj.position, relpos);
        var dot = normal.dot(relpos);

        if (dot <= 0.0) {
          if (justTest) {
            return true;
          }

          var r = this.createContactEquation(bi, bj, si, sj, rsi, rsj);
          r.ni.copy(normal); // Contact normal is the plane normal

          r.ni.negate(r.ni);
          r.ri.set(0, 0, 0); // Center of particle
          // Get particle position projected on plane

          var projected = particlePlane_projected;
          normal.mult(normal.dot(xi), projected);
          xi.vsub(projected, projected); //projected.vadd(bj.position,projected);
          // rj is now the projected world position minus plane position

          r.rj.copy(projected);
          this.result.push(r);
          this.createFrictionEquationsFromContact(r, this.frictionResult);
        }
      };

      var particleSphere_normal = new Vec3();
      /**
       * @method particleSphere
       * @param  {Array}      result
       * @param  {Shape}      si
       * @param  {Shape}      sj
       * @param  {Vec3}       xi
       * @param  {Vec3}       xj
       * @param  {Quaternion} qi
       * @param  {Quaternion} qj
       * @param  {Body}       bi
       * @param  {Body}       bj
       */

      Narrowphase.prototype[Shape.types.PARTICLE | Shape.types.SPHERE] = Narrowphase.prototype.sphereParticle = function (sj, si, xj, xi, qj, qi, bj, bi, rsi, rsj, justTest) {
        // The normal is the unit vector from sphere center to particle center
        var normal = particleSphere_normal;
        normal.set(0, 0, 1);
        xi.vsub(xj, normal);
        var lengthSquared = normal.norm2();

        if (lengthSquared <= sj.radius * sj.radius) {
          if (justTest) {
            return true;
          }

          var r = this.createContactEquation(bi, bj, si, sj, rsi, rsj);
          normal.normalize();
          r.rj.copy(normal);
          r.rj.mult(sj.radius, r.rj);
          r.ni.copy(normal); // Contact normal

          r.ni.negate(r.ni);
          r.ri.set(0, 0, 0); // Center of particle

          this.result.push(r);
          this.createFrictionEquationsFromContact(r, this.frictionResult);
        }
      }; // WIP


      var cqj = new Quaternion();
      var convexParticle_local = new Vec3();
      var convexParticle_normal = new Vec3();
      var convexParticle_penetratedFaceNormal = new Vec3();
      var convexParticle_vertexToParticle = new Vec3();
      var convexParticle_worldPenetrationVec = new Vec3();
      /**
       * @method convexParticle
       * @param  {Array}      result
       * @param  {Shape}      si
       * @param  {Shape}      sj
       * @param  {Vec3}       xi
       * @param  {Vec3}       xj
       * @param  {Quaternion} qi
       * @param  {Quaternion} qj
       * @param  {Body}       bi
       * @param  {Body}       bj
       */

      Narrowphase.prototype[Shape.types.PARTICLE | Shape.types.CONVEXPOLYHEDRON] = Narrowphase.prototype.convexParticle = function (sj, si, xj, xi, qj, qi, bj, bi, rsi, rsj, justTest) {
        var penetratedFaceIndex = -1;
        var penetratedFaceNormal = convexParticle_penetratedFaceNormal;
        var worldPenetrationVec = convexParticle_worldPenetrationVec;
        var minPenetration = null;
        var numDetectedFaces = 0; // Convert particle position xi to local coords in the convex

        var local = convexParticle_local;
        local.copy(xi);
        local.vsub(xj, local); // Convert position to relative the convex origin

        qj.conjugate(cqj);
        cqj.vmult(local, local);

        if (sj.pointIsInside(local)) {
          if (sj.worldVerticesNeedsUpdate) {
            sj.computeWorldVertices(xj, qj);
          }

          if (sj.worldFaceNormalsNeedsUpdate) {
            sj.computeWorldFaceNormals(qj);
          } // For each world polygon in the polyhedra


          for (var i = 0, nfaces = sj.faces.length; i !== nfaces; i++) {
            // Construct world face vertices
            var verts = [sj.worldVertices[sj.faces[i][0]]];
            var normal = sj.worldFaceNormals[i]; // Check how much the particle penetrates the polygon plane.

            xi.vsub(verts[0], convexParticle_vertexToParticle);
            var penetration = -normal.dot(convexParticle_vertexToParticle);

            if (minPenetration === null || Math.abs(penetration) < Math.abs(minPenetration)) {
              if (justTest) {
                return true;
              }

              minPenetration = penetration;
              penetratedFaceIndex = i;
              penetratedFaceNormal.copy(normal);
              numDetectedFaces++;
            }
          }

          if (penetratedFaceIndex !== -1) {
            // Setup contact
            var r = this.createContactEquation(bi, bj, si, sj, rsi, rsj);
            penetratedFaceNormal.mult(minPenetration, worldPenetrationVec); // rj is the particle position projected to the face

            worldPenetrationVec.vadd(xi, worldPenetrationVec);
            worldPenetrationVec.vsub(xj, worldPenetrationVec);
            r.rj.copy(worldPenetrationVec); //var projectedToFace = xi.vsub(xj).vadd(worldPenetrationVec);
            //projectedToFace.copy(r.rj);
            //qj.vmult(r.rj,r.rj);

            penetratedFaceNormal.negate(r.ni); // Contact normal

            r.ri.set(0, 0, 0); // Center of particle

            var ri = r.ri,
                rj = r.rj; // Make relative to bodies

            ri.vadd(xi, ri);
            ri.vsub(bi.position, ri);
            rj.vadd(xj, rj);
            rj.vsub(bj.position, rj);
            this.result.push(r);
            this.createFrictionEquationsFromContact(r, this.frictionResult);
          } else {
            console.warn("Point found inside convex, but did not find penetrating face!");
          }
        }
      };

      Narrowphase.prototype[Shape.types.BOX | Shape.types.HEIGHTFIELD] = Narrowphase.prototype.boxHeightfield = function (si, sj, xi, xj, qi, qj, bi, bj, rsi, rsj, justTest) {
        si.convexPolyhedronRepresentation.material = si.material;
        si.convexPolyhedronRepresentation.collisionResponse = si.collisionResponse;
        return this.convexHeightfield(si.convexPolyhedronRepresentation, sj, xi, xj, qi, qj, bi, bj, si, sj, justTest);
      };

      var convexHeightfield_tmp1 = new Vec3();
      var convexHeightfield_tmp2 = new Vec3();
      var convexHeightfield_faceList = [0];
      /**
       * @method convexHeightfield
       */

      Narrowphase.prototype[Shape.types.CONVEXPOLYHEDRON | Shape.types.HEIGHTFIELD] = Narrowphase.prototype.convexHeightfield = function (convexShape, hfShape, convexPos, hfPos, convexQuat, hfQuat, convexBody, hfBody, rsi, rsj, justTest) {
        var data = hfShape.data,
            w = hfShape.elementSize,
            radius = convexShape.boundingSphereRadius,
            worldPillarOffset = convexHeightfield_tmp2,
            faceList = convexHeightfield_faceList; // Get sphere position to heightfield local!

        var localConvexPos = convexHeightfield_tmp1;
        Transform.pointToLocalFrame(hfPos, hfQuat, convexPos, localConvexPos); // Get the index of the data points to test against

        var iMinX = Math.floor((localConvexPos.x - radius) / w) - 1,
            iMaxX = Math.ceil((localConvexPos.x + radius) / w) + 1,
            iMinY = Math.floor((localConvexPos.y - radius) / w) - 1,
            iMaxY = Math.ceil((localConvexPos.y + radius) / w) + 1; // Bail out if we are out of the terrain

        if (iMaxX < 0 || iMaxY < 0 || iMinX > data.length || iMinY > data[0].length) {
          return;
        } // Clamp index to edges


        if (iMinX < 0) {
          iMinX = 0;
        }

        if (iMaxX < 0) {
          iMaxX = 0;
        }

        if (iMinY < 0) {
          iMinY = 0;
        }

        if (iMaxY < 0) {
          iMaxY = 0;
        }

        if (iMinX >= data.length) {
          iMinX = data.length - 1;
        }

        if (iMaxX >= data.length) {
          iMaxX = data.length - 1;
        }

        if (iMaxY >= data[0].length) {
          iMaxY = data[0].length - 1;
        }

        if (iMinY >= data[0].length) {
          iMinY = data[0].length - 1;
        }

        var minMax = [];
        hfShape.getRectMinMax(iMinX, iMinY, iMaxX, iMaxY, minMax);
        var min = minMax[0];
        var max = minMax[1]; // Bail out if we're cant touch the bounding height box

        if (localConvexPos.z - radius > max || localConvexPos.z + radius < min) {
          return;
        }

        for (var i = iMinX; i < iMaxX; i++) {
          for (var j = iMinY; j < iMaxY; j++) {
            var intersecting = false; // Lower triangle

            hfShape.getConvexTrianglePillar(i, j, false);
            Transform.pointToWorldFrame(hfPos, hfQuat, hfShape.pillarOffset, worldPillarOffset);

            if (convexPos.distanceTo(worldPillarOffset) < hfShape.pillarConvex.boundingSphereRadius + convexShape.boundingSphereRadius) {
              intersecting = this.convexConvex(convexShape, hfShape.pillarConvex, convexPos, worldPillarOffset, convexQuat, hfQuat, convexBody, hfBody, null, null, justTest, faceList, null);
            }

            if (justTest && intersecting) {
              return true;
            } // Upper triangle


            hfShape.getConvexTrianglePillar(i, j, true);
            Transform.pointToWorldFrame(hfPos, hfQuat, hfShape.pillarOffset, worldPillarOffset);

            if (convexPos.distanceTo(worldPillarOffset) < hfShape.pillarConvex.boundingSphereRadius + convexShape.boundingSphereRadius) {
              intersecting = this.convexConvex(convexShape, hfShape.pillarConvex, convexPos, worldPillarOffset, convexQuat, hfQuat, convexBody, hfBody, null, null, justTest, faceList, null);
            }

            if (justTest && intersecting) {
              return true;
            }
          }
        }
      };

      var sphereHeightfield_tmp1 = new Vec3();
      var sphereHeightfield_tmp2 = new Vec3();
      /**
       * @method sphereHeightfield
       */

      Narrowphase.prototype[Shape.types.SPHERE | Shape.types.HEIGHTFIELD] = Narrowphase.prototype.sphereHeightfield = function (sphereShape, hfShape, spherePos, hfPos, sphereQuat, hfQuat, sphereBody, hfBody, rsi, rsj, justTest) {
        var data = hfShape.data,
            radius = sphereShape.radius,
            w = hfShape.elementSize,
            worldPillarOffset = sphereHeightfield_tmp2; // Get sphere position to heightfield local!

        var localSpherePos = sphereHeightfield_tmp1;
        Transform.pointToLocalFrame(hfPos, hfQuat, spherePos, localSpherePos); // Get the index of the data points to test against

        var iMinX = Math.floor((localSpherePos.x - radius) / w) - 1,
            iMaxX = Math.ceil((localSpherePos.x + radius) / w) + 1,
            iMinY = Math.floor((localSpherePos.y - radius) / w) - 1,
            iMaxY = Math.ceil((localSpherePos.y + radius) / w) + 1; // Bail out if we are out of the terrain

        if (iMaxX < 0 || iMaxY < 0 || iMinX > data.length || iMinY > data[0].length) {
          return;
        } // Clamp index to edges


        if (iMinX < 0) {
          iMinX = 0;
        }

        if (iMaxX < 0) {
          iMaxX = 0;
        }

        if (iMinY < 0) {
          iMinY = 0;
        }

        if (iMaxY < 0) {
          iMaxY = 0;
        }

        if (iMinX >= data.length) {
          iMinX = data.length - 1;
        }

        if (iMaxX >= data.length) {
          iMaxX = data.length - 1;
        }

        if (iMaxY >= data[0].length) {
          iMaxY = data[0].length - 1;
        }

        if (iMinY >= data[0].length) {
          iMinY = data[0].length - 1;
        }

        var minMax = [];
        hfShape.getRectMinMax(iMinX, iMinY, iMaxX, iMaxY, minMax);
        var min = minMax[0];
        var max = minMax[1]; // Bail out if we're cant touch the bounding height box

        if (localSpherePos.z - radius > max || localSpherePos.z + radius < min) {
          return;
        }

        var result = this.result;

        for (var i = iMinX; i < iMaxX; i++) {
          for (var j = iMinY; j < iMaxY; j++) {
            var numContactsBefore = result.length;
            var intersecting = false; // Lower triangle

            hfShape.getConvexTrianglePillar(i, j, false);
            Transform.pointToWorldFrame(hfPos, hfQuat, hfShape.pillarOffset, worldPillarOffset);

            if (spherePos.distanceTo(worldPillarOffset) < hfShape.pillarConvex.boundingSphereRadius + sphereShape.boundingSphereRadius) {
              intersecting = this.sphereConvex(sphereShape, hfShape.pillarConvex, spherePos, worldPillarOffset, sphereQuat, hfQuat, sphereBody, hfBody, sphereShape, hfShape, justTest);
            }

            if (justTest && intersecting) {
              return true;
            } // Upper triangle


            hfShape.getConvexTrianglePillar(i, j, true);
            Transform.pointToWorldFrame(hfPos, hfQuat, hfShape.pillarOffset, worldPillarOffset);

            if (spherePos.distanceTo(worldPillarOffset) < hfShape.pillarConvex.boundingSphereRadius + sphereShape.boundingSphereRadius) {
              intersecting = this.sphereConvex(sphereShape, hfShape.pillarConvex, spherePos, worldPillarOffset, sphereQuat, hfQuat, sphereBody, hfBody, sphereShape, hfShape, justTest);
            }

            if (justTest && intersecting) {
              return true;
            }

            var numContacts = result.length - numContactsBefore;

            if (numContacts > 2) {
              return;
            }
            /*
            // Skip all but 1
            for (var k = 0; k < numContacts - 1; k++) {
                result.pop();
            }
            */

          }
        }
      };
    }, {
      "../collision/AABB": 3,
      "../collision/Ray": 10,
      "../equations/ContactEquation": 20,
      "../equations/FrictionEquation": 22,
      "../math/Quaternion": 29,
      "../math/Transform": 30,
      "../math/Vec3": 31,
      "../objects/Body": 32,
      "../shapes/ConvexPolyhedron": 39,
      "../shapes/Shape": 44,
      "../solver/Solver": 48,
      "../utils/Vec3Pool": 55
    }],
    57: [function (_dereq_, module, exports) {
      (function (global) {
        /* global performance */
        module.exports = World;

        var Shape = _dereq_('../shapes/Shape');

        var Vec3 = _dereq_('../math/Vec3');

        var Quaternion = _dereq_('../math/Quaternion');

        var GSSolver = _dereq_('../solver/GSSolver');

        var ContactEquation = _dereq_('../equations/ContactEquation');

        var FrictionEquation = _dereq_('../equations/FrictionEquation');

        var Narrowphase = _dereq_('./Narrowphase');

        var EventTarget = _dereq_('../utils/EventTarget');

        var ArrayCollisionMatrix = _dereq_('../collision/ArrayCollisionMatrix');

        var ObjectCollisionMatrix = _dereq_('../collision/ObjectCollisionMatrix');

        var OverlapKeeper = _dereq_('../collision/OverlapKeeper');

        var Material = _dereq_('../material/Material');

        var ContactMaterial = _dereq_('../material/ContactMaterial');

        var Body = _dereq_('../objects/Body');

        var TupleDictionary = _dereq_('../utils/TupleDictionary');

        var RaycastResult = _dereq_('../collision/RaycastResult');

        var AABB = _dereq_('../collision/AABB');

        var Ray = _dereq_('../collision/Ray');

        var NaiveBroadphase = _dereq_('../collision/NaiveBroadphase');

        if (global) {
          global['doProfiling'] = false;
          global['DEBUG'] = true;
        } else if (window) {
          window['doProfiling'] = false;
          window['DEBUG'] = true;
        }
        /**
         * The physics world
         * @class World
         * @constructor
         * @extends EventTarget
         * @param {object} [options]
         * @param {Vec3} [options.gravity]
         * @param {boolean} [options.allowSleep]
         * @param {Broadphase} [options.broadphase]
         * @param {Solver} [options.solver]
         * @param {boolean} [options.quatNormalizeFast]
         * @param {number} [options.quatNormalizeSkip]
         */


        function World(options) {
          options = options || {};
          EventTarget.apply(this);
          /**
           * Currently / last used timestep. Is set to -1 if not available. This value is updated before each internal step, which means that it is "fresh" inside event callbacks.
           * @property {Number} dt
           */

          this.dt = -1;
          /**
           * Makes bodies go to sleep when they've been inactive
           * @property allowSleep
           * @type {Boolean}
           * @default false
           */

          this.allowSleep = !!options.allowSleep;
          /**
           * All the current contacts (instances of ContactEquation) in the world.
           * @property contacts
           * @type {Array}
           */

          this.contacts = [];
          this.frictionEquations = [];
          this.contactsDic = new TupleDictionary();
          this.oldContactsDic = new TupleDictionary();
          /**
           * How often to normalize quaternions. Set to 0 for every step, 1 for every second etc.. A larger value increases performance. If bodies tend to explode, set to a smaller value (zero to be sure nothing can go wrong).
           * @property quatNormalizeSkip
           * @type {Number}
           * @default 0
           */

          this.quatNormalizeSkip = options.quatNormalizeSkip !== undefined ? options.quatNormalizeSkip : 0;
          /**
           * Set to true to use fast quaternion normalization. It is often enough accurate to use. If bodies tend to explode, set to false.
           * @property quatNormalizeFast
           * @type {Boolean}
           * @see Quaternion.normalizeFast
           * @see Quaternion.normalize
           * @default false
           */

          this.quatNormalizeFast = options.quatNormalizeFast !== undefined ? options.quatNormalizeFast : false;
          /**
           * The wall-clock time since simulation start
           * @property time
           * @type {Number}
           */

          this.time = 0.0;
          /**
           * Number of timesteps taken since start
           * @property stepnumber
           * @type {Number}
           */

          this.stepnumber = 0;
          this.substeps = 0; /// Default and last timestep sizes

          this.default_dt = 1 / 60;
          this.nextId = 0;
          /**
           * @property gravity
           * @type {Vec3}
           */

          this.gravity = new Vec3();

          if (options.gravity) {
            this.gravity.copy(options.gravity);
          }
          /**
           * The broadphase algorithm to use. Default is NaiveBroadphase
           * @property broadphase
           * @type {Broadphase}
           */


          this.broadphase = options.broadphase !== undefined ? options.broadphase : new NaiveBroadphase();
          /**
           * @property bodies
           * @type {Array}
           */

          this.bodies = [];
          /**
           * The solver algorithm to use. Default is GSSolver
           * @property solver
           * @type {Solver}
           */

          this.solver = options.solver !== undefined ? options.solver : new GSSolver();
          /**
           * @property constraints
           * @type {Array}
           */

          this.constraints = [];
          /**
           * @property narrowphase
           * @type {Narrowphase}
           */

          this.narrowphase = new Narrowphase(this);
          /**
           * @property {ObjectCollisionMatrix} collisionMatrix
          * @type {ObjectCollisionMatrix}
          */

          this.collisionMatrix = new ObjectCollisionMatrix();
          this.triggerMatrix = new ObjectCollisionMatrix();
          this.shapeOverlapKeeper = new OverlapKeeper();
          this.shapeOverlapKeeperExit = new OverlapKeeper();
          /**
           * All added materials
           * @property materials
           * @type {Array}
           */

          this.materials = [];
          /**
           * @property contactmaterials
           * @type {Array}
           */

          this.contactmaterials = [];
          /**
           * Used to look up a ContactMaterial given two instances of Material.
           * @property {TupleDictionary} contactMaterialTable
           */

          this.contactMaterialTable = new TupleDictionary();
          this.defaultMaterial = new Material("default");
          /**
           * This contact material is used if no suitable contactmaterial is found for a contact.
           * @property defaultContactMaterial
           * @type {ContactMaterial}
           */

          this.defaultContactMaterial = new ContactMaterial(this.defaultMaterial, this.defaultMaterial, {
            friction: 0.3,
            restitution: 0.0
          });
          /**
           * @property profile
           * @type {Object}
           */

          this.profile = {
            solve: 0,
            makeContactConstraints: 0,
            broadphase: 0,
            integrate: 0,
            narrowphase: 0
          };
          /**
           * Time accumulator for interpolation. See http://gafferongames.com/game-physics/fix-your-timestep/
           * @property {Number} accumulator
           */

          this.accumulator = 0;
          /**
           * @property subsystems
           * @type {Array}
           */

          this.subsystems = [];
          /**
           * Dispatched after a body has been added to the world.
           * @event addBody
           * @param {Body} body The body that has been added to the world.
           */

          this.addBodyEvent = {
            type: "addBody",
            body: null
          };
          /**
           * Dispatched after a body has been removed from the world.
           * @event removeBody
           * @param {Body} body The body that has been removed from the world.
           */

          this.removeBodyEvent = {
            type: "removeBody",
            body: null
          };
          this.broadphase.setWorld(this);
        }

        World.idToBodyMap = {};
        World.idToShapeMap = {};
        World.prototype = new EventTarget(); // Temp stuff
        // var tmpAABB1 = new AABB();
        // var tmpArray1 = [];

        var tmpRay = new Ray();
        /**
         * Get the contact material between materials m1 and m2
         * @method getContactMaterial
         * @param {Material} m1
         * @param {Material} m2
         * @return {ContactMaterial} The contact material if it was found.
         */

        World.prototype.getContactMaterial = function (m1, m2) {
          return this.contactMaterialTable.get(m1.id, m2.id); //this.contactmaterials[this.mats2cmat[i+j*this.materials.length]];
        };
        /**
         * Get number of objects in the world.
         * @method numObjects
         * @return {Number}
         * @deprecated
         */


        World.prototype.numObjects = function () {
          return this.bodies.length;
        };
        /**
         * Store old collision state info
         * @method collisionMatrixTick
         */


        World.prototype.collisionMatrixTick = function () {// this.shapeOverlapKeeper.tick();
          // this.shapeOverlapKeeperExit.tick();
        };
        /**
         * Add a rigid body to the simulation.
         * @method add
         * @param {Body} body
         * @todo If the simulation has not yet started, why recrete and copy arrays for each body? Accumulate in dynamic arrays in this case.
         * @todo Adding an array of bodies should be possible. This would save some loops too
         * @deprecated Use .addBody instead
         */


        World.prototype.add = World.prototype.addBody = function (body) {
          if (this.bodies.indexOf(body) !== -1) {
            return;
          }

          body.index = this.bodies.length;
          this.bodies.push(body);
          body.world = this;
          body.initPosition.copy(body.position);
          body.initVelocity.copy(body.velocity);
          body.timeLastSleepy = this.time;

          if (body instanceof Body) {
            body.initAngularVelocity.copy(body.angularVelocity);
            body.initQuaternion.copy(body.quaternion);
          }

          this.collisionMatrix.setNumObjects(this.bodies.length);
          this.addBodyEvent.body = body;
          World.idToBodyMap[body.id] = body;
          this.dispatchEvent(this.addBodyEvent);
        };
        /**
         * Add a constraint to the simulation.
         * @method addConstraint
         * @param {Constraint} c
         */


        World.prototype.addConstraint = function (c) {
          this.constraints.push(c);
        };
        /**
         * Removes a constraint
         * @method removeConstraint
         * @param {Constraint} c
         */


        World.prototype.removeConstraint = function (c) {
          var idx = this.constraints.indexOf(c);

          if (idx !== -1) {
            this.constraints.splice(idx, 1);
          }
        };
        /**
         * Raycast test
         * @method rayTest
         * @param {Vec3} from
         * @param {Vec3} to
         * @param {RaycastResult} result
         * @deprecated Use .raycastAll, .raycastClosest or .raycastAny instead.
         */


        World.prototype.rayTest = function (from, to, result) {
          if (result instanceof RaycastResult) {
            // Do raycastclosest
            this.raycastClosest(from, to, {
              skipBackfaces: true
            }, result);
          } else {
            // Do raycastAll
            this.raycastAll(from, to, {
              skipBackfaces: true
            }, result);
          }
        };
        /**
         * Ray cast against all bodies. The provided callback will be executed for each hit with a RaycastResult as single argument.
         * @method raycastAll
         * @param  {Vec3} from
         * @param  {Vec3} to
         * @param  {Object} options
         * @param  {number} [options.collisionFilterMask=-1]
         * @param  {number} [options.collisionFilterGroup=-1]
         * @param  {boolean} [options.skipBackfaces=false]
         * @param  {boolean} [options.checkCollisionResponse=true]
         * @param  {Function} callback
         * @return {boolean} True if any body was hit.
         */


        World.prototype.raycastAll = function (from, to, options, callback) {
          options.mode = Ray.ALL;
          options.from = from;
          options.to = to;
          options.callback = callback;
          return tmpRay.intersectWorld(this, options);
        };
        /**
         * Ray cast, and stop at the first result. Note that the order is random - but the method is fast.
         * @method raycastAny
         * @param  {Vec3} from
         * @param  {Vec3} to
         * @param  {Object} options
         * @param  {number} [options.collisionFilterMask=-1]
         * @param  {number} [options.collisionFilterGroup=-1]
         * @param  {boolean} [options.skipBackfaces=false]
         * @param  {boolean} [options.checkCollisionResponse=true]
         * @param  {RaycastResult} result
         * @return {boolean} True if any body was hit.
         */


        World.prototype.raycastAny = function (from, to, options, result) {
          options.mode = Ray.ANY;
          options.from = from;
          options.to = to;
          options.result = result;
          return tmpRay.intersectWorld(this, options);
        };
        /**
         * Ray cast, and return information of the closest hit.
         * @method raycastClosest
         * @param  {Vec3} from
         * @param  {Vec3} to
         * @param  {Object} options
         * @param  {number} [options.collisionFilterMask=-1]
         * @param  {number} [options.collisionFilterGroup=-1]
         * @param  {boolean} [options.skipBackfaces=false]
         * @param  {boolean} [options.checkCollisionResponse=true]
         * @param  {RaycastResult} result
         * @return {boolean} True if any body was hit.
         */


        World.prototype.raycastClosest = function (from, to, options, result) {
          options.mode = Ray.CLOSEST;
          options.from = from;
          options.to = to;
          options.result = result;
          return tmpRay.intersectWorld(this, options);
        };
        /**
         * Remove a rigid body from the simulation.
         * @method remove
         * @param {Body} body
         * @deprecated Use .removeBody instead
         */


        World.prototype.remove = function (body) {
          body.world = null;
          var n = this.bodies.length - 1,
              bodies = this.bodies,
              idx = bodies.indexOf(body);

          if (idx !== -1) {
            bodies.splice(idx, 1); // Todo: should use a garbage free method
            // Recompute index

            for (var i = 0; i !== bodies.length; i++) {
              bodies[i].index = i;
            }

            this.collisionMatrix.setNumObjects(n);
            this.removeBodyEvent.body = body;
            delete World.idToBodyMap[body.id];
            this.dispatchEvent(this.removeBodyEvent);
          }
        };
        /**
         * Remove a rigid body from the simulation.
         * @method removeBody
         * @param {Body} body
         */


        World.prototype.removeBody = World.prototype.remove;

        World.prototype.getBodyById = function (id) {
          return World.idToBodyMap[id];
        };

        World.prototype.getShapeById = function (id) {
          return World.idToShapeMap[id];
        };
        /**
         * Adds a material to the World.
         * @method addMaterial
         * @param {Material} m
         * @todo Necessary?
         */


        World.prototype.addMaterial = function (m) {
          this.materials.push(m);
        };
        /**
         * Adds a contact material to the World
         * @method addContactMaterial
         * @param {ContactMaterial} cmat
         */


        World.prototype.addContactMaterial = function (cmat) {
          // Add contact material
          this.contactmaterials.push(cmat); // Add current contact material to the material table

          this.contactMaterialTable.set(cmat.materials[0].id, cmat.materials[1].id, cmat);
        }; // performance.now()


        if (DEBUG) {
          if (typeof performance === 'undefined') {
            performance = {};
          }

          if (!performance.now) {
            var nowOffset = Date.now();

            if (performance.timing && performance.timing.navigationStart) {
              nowOffset = performance.timing.navigationStart;
            }

            performance.now = function () {
              return Date.now() - nowOffset;
            };
          }
        } // var step_tmp1 = new Vec3();

        /**
         * Step the physics world forward in time.
         *
         * There are two modes. The simple mode is fixed timestepping without interpolation. In this case you only use the first argument. The second case uses interpolation. In that you also provide the time since the function was last used, as well as the maximum fixed timesteps to take.
         *
         * @method step
         * @param {Number} dt                       The fixed time step size to use.
         * @param {Number} [timeSinceLastCalled]    The time elapsed since the function was last called.
         * @param {Number} [maxSubSteps=10]         Maximum number of fixed steps to take per function call.
         *
         * @example
         *     // fixed timestepping without interpolation
         *     world.step(1/60);
         *
         * @see http://bulletphysics.org/mediawiki-1.5.8/index.php/Stepping_The_World
         */


        World.prototype.step = function (dt, timeSinceLastCalled, maxSubSteps) {
          maxSubSteps = maxSubSteps || 10;
          timeSinceLastCalled = timeSinceLastCalled || 0;

          if (this.substeps != 0) {
            World_step_oldContacts = this.contacts.slice();
          }

          if (timeSinceLastCalled === 0) {
            // Fixed, simple stepping
            this.internalStep(dt); // Increment time

            this.time += dt;
            this.substeps = 1;
          } else {
            this.accumulator += timeSinceLastCalled;
            this.substeps = 0;

            while (this.accumulator >= dt && this.substeps < maxSubSteps) {
              // Do fixed steps to catch up
              this.internalStep(dt);
              this.accumulator -= dt;
              this.substeps++;
            }

            var t = this.accumulator % dt / dt;

            for (var j = 0; j !== this.bodies.length; j++) {
              var b = this.bodies[j];
              b.previousPosition.lerp(b.position, t, b.interpolatedPosition);
              b.previousQuaternion.slerp(b.quaternion, t, b.interpolatedQuaternion);
              b.previousQuaternion.normalize();
            }

            this.time += timeSinceLastCalled;
          }
        };
        /**
         * Dispatched after the world has stepped forward in time.
         * @event postStep
         */
        // World_step_postStepEvent = {type:"postStep"}, // Reusable event objects to save memory

        /**
         * Dispatched before the world steps forward in time.
         * @event preStep
         */
        // World_step_preStepEvent = {type:"preStep"},


        var World_step_collideEvent = {
          type: "collide",
          event: '',
          body: null,
          selfShape: null,
          otherShape: null,
          contacts: null
        },
            World_step_oldContacts = [],
            // Pools for unused objects
        World_step_frictionEquationPool = [],
            World_step_p1 = [],
            // Reusable arrays for collision pairs
        World_step_p2 = []; // World_step_gvec = new Vec3(), // Temporary vectors and quats
        // World_step_vi = new Vec3(),
        // World_step_vj = new Vec3(),
        // World_step_wi = new Vec3(),
        // World_step_wj = new Vec3(),
        // World_step_t1 = new Vec3(),
        // World_step_t2 = new Vec3(),
        // World_step_rixn = new Vec3(),
        // World_step_rjxn = new Vec3(),
        // World_step_step_q = new Quaternion(),
        // World_step_step_w = new Quaternion(),
        // World_step_step_wq = new Quaternion(),
        // invI_tau_dt = new Vec3()

        World.prototype.internalStep = function (dt) {
          this.dt = dt;
          var world = this,
              that = this,
              contacts = this.contacts,
              p1 = World_step_p1,
              p2 = World_step_p2,
              N = this.numObjects(),
              bodies = this.bodies,
              solver = this.solver,
              gravity = this.gravity,
              profile = this.profile,
              DYNAMIC = Body.DYNAMIC,
              profilingStart,
              constraints = this.constraints,
              frictionEquationPool = World_step_frictionEquationPool,
              // gnorm = gravity.norm(),
          gx = gravity.x,
              gy = gravity.y,
              gz = gravity.z,
              i = 0;

          if (doProfiling) {
            profilingStart = performance.now();
          } // Add gravity to all objects


          for (i = 0; i !== N; i++) {
            var bi = bodies[i];

            if (bi.useGravity && bi.type === DYNAMIC) {
              // Only for dynamic bodies
              var f = bi.force,
                  m = bi.mass;
              f.x += m * gx;
              f.y += m * gy;
              f.z += m * gz;
            }
          } // Update subsystems


          for (var i = 0, Nsubsystems = this.subsystems.length; i !== Nsubsystems; i++) {
            this.subsystems[i].update();
          } // Collision detection


          if (doProfiling) {
            profilingStart = performance.now();
          }

          p1.length = 0; // Clean up pair arrays from last step

          p2.length = 0;
          this.broadphase.collisionPairs(this, p1, p2);

          if (doProfiling) {
            profile.broadphase = performance.now() - profilingStart;
          } // Remove constrained pairs with collideConnected == false


          var Nconstraints = constraints.length;

          for (i = 0; i !== Nconstraints; i++) {
            var c = constraints[i];

            if (!c.collideConnected) {
              for (var j = p1.length - 1; j >= 0; j -= 1) {
                if (c.bodyA === p1[j] && c.bodyB === p2[j] || c.bodyB === p1[j] && c.bodyA === p2[j]) {
                  p1.splice(j, 1);
                  p2.splice(j, 1);
                }
              }
            }
          } // Generate contacts


          if (doProfiling) {
            profilingStart = performance.now();
          }

          contacts.length = 0; // Transfer FrictionEquation from current list to the pool for reuse

          var NoldFrictionEquations = this.frictionEquations.length;

          for (i = 0; i !== NoldFrictionEquations; i++) {
            frictionEquationPool.push(this.frictionEquations[i]);
          }

          this.frictionEquations.length = 0;
          this.narrowphase.getContacts(p1, p2, this, contacts, null, this.frictionEquations, frictionEquationPool);

          if (doProfiling) {
            profile.narrowphase = performance.now() - profilingStart;
          } // Loop over all collisions


          if (doProfiling) {
            profilingStart = performance.now();
          } // Add all friction eqs


          for (i = 0; i < this.frictionEquations.length; i++) {
            solver.addEquation(this.frictionEquations[i]);
          }

          var ncontacts = contacts.length;

          for (i = 0; i !== ncontacts; i++) {
            solver.addEquation(contacts[i]);
          }

          if (doProfiling) {
            profile.makeContactConstraints = performance.now() - profilingStart;
            profilingStart = performance.now();
          } // Add user-added constraints


          var Nconstraints = constraints.length;

          for (i = 0; i !== Nconstraints; i++) {
            var c = constraints[i];
            c.update();

            for (var j = 0, Neq = c.equations.length; j !== Neq; j++) {
              var eq = c.equations[j];
              solver.addEquation(eq);
            }
          } // Solve the constrained system


          solver.solve(dt, this);

          if (doProfiling) {
            profile.solve = performance.now() - profilingStart;
          } // Remove all contacts from solver


          solver.removeAllEquations(); // Apply damping, see http://code.google.com/p/bullet/issues/detail?id=74 for details

          var pow = Math.pow;
          N = this.numObjects();

          for (i = 0; i !== N; i++) {
            var bi = bodies[i];

            if (bi.type & DYNAMIC) {
              // Only for dynamic bodies
              var ld = pow(1.0 - bi.linearDamping, dt);
              var v = bi.velocity;
              v.mult(ld, v);
              var av = bi.angularVelocity;

              if (av) {
                var ad = pow(1.0 - bi.angularDamping, dt);
                av.mult(ad, av);
              }
            }
          } // this.dispatchEvent(World_step_preStepEvent);
          // // Invoke pre-step callbacks
          // for(i=0; i!==N; i++){
          //     var bi = bodies[i];
          //     if(bi.preStep){
          //         bi.preStep.call(bi);
          //     }
          // }
          // Leap frog
          // vnew = v + h*f/m
          // xnew = x + h*vnew


          if (doProfiling) {
            profilingStart = performance.now();
          }

          var stepnumber = this.stepnumber;
          var quatNormalize = stepnumber % (this.quatNormalizeSkip + 1) === 0;
          var quatNormalizeFast = this.quatNormalizeFast;

          for (i = 0; i !== N; i++) {
            bodies[i].integrate(dt, quatNormalize, quatNormalizeFast);
          }

          this.clearForces();
          this.broadphase.dirty = true;

          if (doProfiling) {
            profile.integrate = performance.now() - profilingStart;
          } // Update world time


          this.time += dt;
          this.stepnumber += 1; // this.dispatchEvent(World_step_postStepEvent);
          // // Invoke post-step callbacks
          // for(i=0; i!==N; i++){
          //     var bi = bodies[i];
          //     var postStep = bi.postStep;
          //     if(postStep){
          //         postStep.call(bi);
          //     }
          // }
          // Sleeping update

          if (this.allowSleep) {
            for (i = 0; i !== N; i++) {
              bodies[i].sleepTick(this.time);
            }
          }
        };

        var additions = [];
        var removals = [];
        var triggeredEvent = {
          type: 'triggered',
          event: '',
          selfBody: null,
          // need ?
          otherBody: null,
          // need ?
          selfShape: null,
          otherShape: null
        };

        World.prototype.emitTriggeredEvents = function () {
          if (this.substeps == 0) return;
          var id1;
          var id2;
          additions.length = removals.length = 0;
          this.shapeOverlapKeeperExit.getDiff(additions, removals);

          for (var i = 0, l = removals.length; i < l; i += 2) {
            triggeredEvent.event = 'trigger-exit';
            var shapeA = this.getShapeById(removals[i]);
            var shapeB = this.getShapeById(removals[i + 1]); // if(!shapeA.body.isSleeping || !shapeB.body.isSleeping){

            this.triggerMatrix.set(shapeA, shapeB, false);
            triggeredEvent.selfShape = shapeA;
            triggeredEvent.otherShape = shapeB;
            triggeredEvent.selfBody = shapeA.body;
            triggeredEvent.otherBody = shapeB.body;
            shapeA.dispatchEvent(triggeredEvent);
            triggeredEvent.selfShape = shapeB;
            triggeredEvent.otherShape = shapeA;
            triggeredEvent.selfBody = shapeB.body;
            triggeredEvent.otherBody = shapeA.body;
            shapeB.dispatchEvent(triggeredEvent); // }
          }

          additions.length = removals.length = 0;
          this.shapeOverlapKeeper.getDiff(additions, removals);

          for (var i = 0, l = additions.length; i < l; i += 2) {
            var id1 = additions[i];
            var id2 = additions[i + 1];
            var shapeA = this.getShapeById(id1);
            var shapeB = this.getShapeById(id2);
            if (!shapeA || !shapeB) continue;

            if (this.triggerMatrix.get(shapeA, shapeB)) {
              triggeredEvent.event = 'trigger-stay';
            } else {
              this.triggerMatrix.set(shapeA, shapeB, true);
              triggeredEvent.event = 'trigger-enter';
            }

            triggeredEvent.selfShape = shapeA;
            triggeredEvent.otherShape = shapeB;
            triggeredEvent.selfBody = shapeA.body;
            triggeredEvent.otherBody = shapeB.body;
            shapeA.dispatchEvent(triggeredEvent);
            triggeredEvent.selfShape = shapeB;
            triggeredEvent.otherShape = shapeA;
            triggeredEvent.selfBody = shapeB.body;
            triggeredEvent.otherBody = shapeA.body;
            shapeB.dispatchEvent(triggeredEvent);
          }

          this.shapeOverlapKeeper.reset();
          this.shapeOverlapKeeperExit.tick();
        };

        World.prototype.emitCollisionEvents = function () {
          if (this.substeps == 0) return;
          var contacts = this.contacts;
          var i = this.contacts.length;

          while (i--) {
            // Current contact
            var c = contacts[i]; // Get current collision indeces

            var si = c.si;
            var sj = c.sj;
            var item = this.contactsDic.get(si.id, sj.id);

            if (item == null) {
              item = this.contactsDic.set(si.id, sj.id, []);
            }

            item.push(c);
          }

          var key;
          var data; // is collision enter or stay

          var i = this.contactsDic.getLength();

          while (i--) {
            key = this.contactsDic.getKeyByIndex(i);
            data = this.contactsDic.getDataByKey(key);
            if (data == null) continue;
            var bi = data[0].bi;
            var bj = data[0].bj;
            var si = data[0].si;
            var sj = data[0].sj;

            if (bi.allowSleep && bi.type === Body.DYNAMIC && bi.sleepState === Body.SLEEPING && bj.sleepState === Body.AWAKE && bj.type !== Body.STATIC) {
              var speedSquaredB = bj.velocity.norm2() + bj.angularVelocity.norm2();
              var speedLimitSquaredB = Math.pow(bj.sleepSpeedLimit, 2);

              if (speedSquaredB >= speedLimitSquaredB * 2) {
                // bi._wakeUpAfterNarrowphase = true;
                bi.wakeUp();
              }
            }

            if (bj.allowSleep && bj.type === Body.DYNAMIC && bj.sleepState === Body.SLEEPING && bi.sleepState === Body.AWAKE && bi.type !== Body.STATIC) {
              var speedSquaredA = bi.velocity.norm2() + bi.angularVelocity.norm2();
              var speedLimitSquaredA = Math.pow(bi.sleepSpeedLimit, 2);

              if (speedSquaredA >= speedLimitSquaredA * 2) {
                // bj._wakeUpAfterNarrowphase = true;
                bj.wakeUp();
              }
            } // Now we know that i and j are in contact. Set collision matrix state		


            if (this.collisionMatrix.get(bi, bj)) {
              // collision stay
              World_step_collideEvent.event = 'collision-stay';
            } else {
              this.collisionMatrix.set(bi, bj, true); // collision enter

              World_step_collideEvent.event = 'collision-enter';
            }

            if (DEBUG) {
              World_step_collideEvent.bi = bi;
              World_step_collideEvent.contact = data[0];
            }

            World_step_collideEvent.contacts = data;
            World_step_collideEvent.body = sj.body;
            World_step_collideEvent.selfShape = si;
            World_step_collideEvent.otherShape = sj;
            si.body.dispatchEvent(World_step_collideEvent);
            World_step_collideEvent.body = si.body;
            World_step_collideEvent.selfShape = sj;
            World_step_collideEvent.otherShape = si;
            sj.body.dispatchEvent(World_step_collideEvent);
          }

          var oldcontacts = World_step_oldContacts;

          for (i = oldcontacts.length; i--;) {
            // Current contact
            var c = oldcontacts[i]; // Get current collision indeces

            var si = c.si;
            var sj = c.sj;

            if (this.oldContactsDic.get(si.id, sj.id) == null) {
              this.oldContactsDic.set(si.id, sj.id, c);
            }
          } // is collision exit


          i = this.oldContactsDic.getLength();

          while (i--) {
            key = this.oldContactsDic.getKeyByIndex(i);

            if (this.contactsDic.getDataByKey(key) == null) {
              data = this.oldContactsDic.getDataByKey(key);
              var bi = data.bi;
              var bj = data.bj;
              var si = data.si;
              var sj = data.sj;

              if (this.collisionMatrix.get(bi, bj)) {
                if (!bi.isSleeping() || !bj.isSleeping()) {
                  this.collisionMatrix.set(bi, bj, false);

                  if (DEBUG) {
                    World_step_collideEvent.bi = bi;
                    World_step_collideEvent.contact = data;
                  } // collision exit


                  World_step_collideEvent.event = 'collision-exit';
                  World_step_collideEvent.body = sj.body;
                  World_step_collideEvent.selfShape = si;
                  World_step_collideEvent.otherShape = sj;
                  World_step_collideEvent.contacts.length = 0;
                  World_step_collideEvent.contacts.push(data);
                  si.body.dispatchEvent(World_step_collideEvent);
                  World_step_collideEvent.body = si.body;
                  World_step_collideEvent.selfShape = sj;
                  World_step_collideEvent.otherShape = si;
                  sj.body.dispatchEvent(World_step_collideEvent);
                } else {// not exit, due to sleeping
                }
              }
            }
          }

          this.contactsDic.reset();
          this.oldContactsDic.reset();
        };
        /**
         * Sets all body forces in the world to zero.
         * @method clearForces
         */


        World.prototype.clearForces = function () {
          var bodies = this.bodies;
          var N = bodies.length;

          for (var i = 0; i !== N; i++) {
            var b = bodies[i];
            b.force.set(0, 0, 0);
            b.torque.set(0, 0, 0);
          }
        };
      }).call(this, typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
    }, {
      "../collision/AABB": 3,
      "../collision/ArrayCollisionMatrix": 4,
      "../collision/NaiveBroadphase": 7,
      "../collision/ObjectCollisionMatrix": 8,
      "../collision/OverlapKeeper": 9,
      "../collision/Ray": 10,
      "../collision/RaycastResult": 11,
      "../equations/ContactEquation": 20,
      "../equations/FrictionEquation": 22,
      "../material/ContactMaterial": 25,
      "../material/Material": 26,
      "../math/Quaternion": 29,
      "../math/Vec3": 31,
      "../objects/Body": 32,
      "../shapes/Shape": 44,
      "../solver/GSSolver": 47,
      "../utils/EventTarget": 50,
      "../utils/TupleDictionary": 53,
      "./Narrowphase": 56
    }]
  }, {}, [2])(2);
});
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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