
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/extensions/spine/Skeleton.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var TrackEntryListeners = require('./track-entry-listeners');

var RenderComponent = require('../../cocos2d/core/components/CCRenderComponent');

var spine = require('./lib/spine');

var Graphics = require('../../cocos2d/core/graphics/graphics');

var RenderFlow = require('../../cocos2d/core/renderer/render-flow');

var FLAG_POST_RENDER = RenderFlow.FLAG_POST_RENDER;

var SkeletonCache = require('./skeleton-cache');

var AttachUtil = require('./AttachUtil');
/**
 * @module sp
 */


var DefaultSkinsEnum = cc.Enum({
  'default': -1
});
var DefaultAnimsEnum = cc.Enum({
  '<None>': 0
});
/**
 * !#en Enum for animation cache mode type.
 * !#zh Spine动画缓存类型
 * @enum Skeleton.AnimationCacheMode
 */

var AnimationCacheMode = cc.Enum({
  /**
   * !#en The realtime mode.
   * !#zh 实时计算模式。
   * @property {Number} REALTIME
   */
  REALTIME: 0,

  /**
   * !#en The shared cache mode.
   * !#zh 共享缓存模式。
   * @property {Number} SHARED_CACHE
   */
  SHARED_CACHE: 1,

  /**
   * !#en The private cache mode.
   * !#zh 私有缓存模式。
   * @property {Number} PRIVATE_CACHE
   */
  PRIVATE_CACHE: 2
});

function setEnumAttr(obj, propName, enumDef) {
  cc.Class.Attr.setClassAttr(obj, propName, 'type', 'Enum');
  cc.Class.Attr.setClassAttr(obj, propName, 'enumList', cc.Enum.getList(enumDef));
}
/**
 * !#en
 * The skeleton of Spine <br/>
 * <br/>
 * (Skeleton has a reference to a SkeletonData and stores the state for skeleton instance,
 * which consists of the current pose's bone SRT, slot colors, and which slot attachments are visible. <br/>
 * Multiple skeletons can use the same SkeletonData which includes all animations, skins, and attachments.) <br/>
 * !#zh
 * Spine 骨骼动画 <br/>
 * <br/>
 * (Skeleton 具有对骨骼数据的引用并且存储了骨骼实例的状态，
 * 它由当前的骨骼动作，slot 颜色，和可见的 slot attachments 组成。<br/>
 * 多个 Skeleton 可以使用相同的骨骼数据，其中包括所有的动画，皮肤和 attachments。
 *
 * @class Skeleton
 * @extends RenderComponent
 */


sp.Skeleton = cc.Class({
  name: 'sp.Skeleton',
  "extends": RenderComponent,
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.renderers/Spine Skeleton',
    help: 'app://docs/html/components/spine.html',
    inspector: 'packages://inspector/inspectors/comps/skeleton2d.js'
  },
  statics: {
    AnimationCacheMode: AnimationCacheMode
  },
  properties: {
    /**
     * !#en The skeletal animation is paused?
     * !#zh 该骨骼动画是否暂停。
     * @property paused
     * @type {Boolean}
     * @readOnly
     * @default false
     */
    paused: {
      "default": false,
      visible: false
    },

    /**
     * !#en
     * The skeleton data contains the skeleton information (bind pose bones, slots, draw order,
     * attachments, skins, etc) and animations but does not hold any state.<br/>
     * Multiple skeletons can share the same skeleton data.
     * !#zh
     * 骨骼数据包含了骨骼信息（绑定骨骼动作，slots，渲染顺序，
     * attachments，皮肤等等）和动画但不持有任何状态。<br/>
     * 多个 Skeleton 可以共用相同的骨骼数据。
     * @property {sp.SkeletonData} skeletonData
     */
    skeletonData: {
      "default": null,
      type: sp.SkeletonData,
      notify: function notify() {
        this.defaultSkin = '';
        this.defaultAnimation = '';

        if (CC_EDITOR) {
          this._refreshInspector();
        }

        this._updateSkeletonData();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.skeleton.skeleton_data'
    },
    // 由于 spine 的 skin 是无法二次替换的，所以只能设置默认的 skin

    /**
     * !#en The name of default skin.
     * !#zh 默认的皮肤名称。
     * @property {String} defaultSkin
     */
    defaultSkin: {
      "default": '',
      visible: false
    },

    /**
     * !#en The name of default animation.
     * !#zh 默认的动画名称。
     * @property {String} defaultAnimation
     */
    defaultAnimation: {
      "default": '',
      visible: false
    },

    /**
     * !#en The name of current playing animation.
     * !#zh 当前播放的动画名称。
     * @property {String} animation
     */
    animation: {
      get: function get() {
        if (this.isAnimationCached()) {
          return this._animationName;
        } else {
          var entry = this.getCurrent(0);
          return entry && entry.animation.name || "";
        }
      },
      set: function set(value) {
        this.defaultAnimation = value;

        if (value) {
          this.setAnimation(0, value, this.loop);
        } else if (!this.isAnimationCached()) {
          this.clearTrack(0);
          this.setToSetupPose();
        }
      },
      visible: false
    },

    /**
     * @property {Number} _defaultSkinIndex
     */
    _defaultSkinIndex: {
      get: function get() {
        if (this.skeletonData) {
          var skinsEnum = this.skeletonData.getSkinsEnum();

          if (skinsEnum) {
            if (this.defaultSkin === "") {
              if (skinsEnum.hasOwnProperty(0)) {
                this._defaultSkinIndex = 0;
                return 0;
              }
            } else {
              var skinIndex = skinsEnum[this.defaultSkin];

              if (skinIndex !== undefined) {
                return skinIndex;
              }
            }
          }
        }

        return 0;
      },
      set: function set(value) {
        var skinsEnum;

        if (this.skeletonData) {
          skinsEnum = this.skeletonData.getSkinsEnum();
        }

        if (!skinsEnum) {
          return cc.errorID('', this.name);
        }

        var skinName = skinsEnum[value];

        if (skinName !== undefined) {
          this.defaultSkin = skinName;
          this.setSkin(this.defaultSkin);

          if (CC_EDITOR && !cc.engine.isPlaying) {
            this._refreshInspector();
          }
        } else {
          cc.errorID(7501, this.name);
        }
      },
      type: DefaultSkinsEnum,
      visible: true,
      displayName: "Default Skin",
      tooltip: CC_DEV && 'i18n:COMPONENT.skeleton.default_skin'
    },
    // value of 0 represents no animation
    _animationIndex: {
      get: function get() {
        var animationName = !CC_EDITOR || cc.engine.isPlaying ? this.animation : this.defaultAnimation;

        if (this.skeletonData && animationName) {
          var animsEnum = this.skeletonData.getAnimsEnum();

          if (animsEnum) {
            var animIndex = animsEnum[animationName];

            if (animIndex !== undefined) {
              return animIndex;
            }
          }
        }

        return 0;
      },
      set: function set(value) {
        if (value === 0) {
          this.animation = '';
          return;
        }

        var animsEnum;

        if (this.skeletonData) {
          animsEnum = this.skeletonData.getAnimsEnum();
        }

        if (!animsEnum) {
          return cc.errorID(7502, this.name);
        }

        var animName = animsEnum[value];

        if (animName !== undefined) {
          this.animation = animName;
        } else {
          cc.errorID(7503, this.name);
        }
      },
      type: DefaultAnimsEnum,
      visible: true,
      displayName: 'Animation',
      tooltip: CC_DEV && 'i18n:COMPONENT.skeleton.animation'
    },
    // Record pre cache mode.
    _preCacheMode: -1,
    _cacheMode: AnimationCacheMode.REALTIME,
    _defaultCacheMode: {
      "default": 0,
      type: AnimationCacheMode,
      notify: function notify() {
        this.setAnimationCacheMode(this._defaultCacheMode);
      },
      editorOnly: true,
      visible: true,
      animatable: false,
      displayName: "Animation Cache Mode",
      tooltip: CC_DEV && 'i18n:COMPONENT.skeleton.animation_cache_mode'
    },

    /**
     * !#en TODO
     * !#zh 是否循环播放当前骨骼动画。
     * @property {Boolean} loop
     * @default true
     */
    loop: {
      "default": true,
      tooltip: CC_DEV && 'i18n:COMPONENT.skeleton.loop'
    },

    /**
     * !#en Indicates whether to enable premultiplied alpha.
     * You should disable this option when image's transparent area appears to have opaque pixels,
     * or enable this option when image's half transparent area appears to be darken.
     * !#zh 是否启用贴图预乘。
     * 当图片的透明区域出现色块时需要关闭该选项，当图片的半透明区域颜色变黑时需要启用该选项。
     * @property {Boolean} premultipliedAlpha
     * @default true
     */
    premultipliedAlpha: {
      "default": true,
      tooltip: CC_DEV && 'i18n:COMPONENT.skeleton.premultipliedAlpha'
    },

    /**
     * !#en The time scale of this skeleton.
     * !#zh 当前骨骼中所有动画的时间缩放率。
     * @property {Number} timeScale
     * @default 1
     */
    timeScale: {
      "default": 1,
      tooltip: CC_DEV && 'i18n:COMPONENT.skeleton.time_scale'
    },

    /**
     * !#en Indicates whether open debug slots.
     * !#zh 是否显示 slot 的 debug 信息。
     * @property {Boolean} debugSlots
     * @default false
     */
    debugSlots: {
      "default": false,
      editorOnly: true,
      tooltip: CC_DEV && 'i18n:COMPONENT.skeleton.debug_slots',
      notify: function notify() {
        this._updateDebugDraw();
      }
    },

    /**
     * !#en Indicates whether open debug bones.
     * !#zh 是否显示 bone 的 debug 信息。
     * @property {Boolean} debugBones
     * @default false
     */
    debugBones: {
      "default": false,
      editorOnly: true,
      tooltip: CC_DEV && 'i18n:COMPONENT.skeleton.debug_bones',
      notify: function notify() {
        this._updateDebugDraw();
      }
    },

    /**
     * !#en Indicates whether open debug mesh.
     * !#zh 是否显示 mesh 的 debug 信息。
     * @property {Boolean} debugMesh
     * @default false
     */
    debugMesh: {
      "default": false,
      editorOnly: true,
      tooltip: CC_DEV && 'i18n:COMPONENT.skeleton.debug_mesh',
      notify: function notify() {
        this._updateDebugDraw();
      }
    },

    /**
     * !#en Enabled two color tint.
     * !#zh 是否启用染色效果。
     * @property {Boolean} useTint
     * @default false
     */
    useTint: {
      "default": false,
      tooltip: CC_DEV && 'i18n:COMPONENT.skeleton.use_tint',
      notify: function notify() {
        this._updateUseTint();
      }
    },

    /**
     * !#en Enabled batch model, if skeleton is complex, do not enable batch, or will lower performance.
     * !#zh 开启合批，如果渲染大量相同纹理，且结构简单的骨骼动画，开启合批可以降低drawcall，否则请不要开启，cpu消耗会上升。
     * @property {Boolean} enableBatch
     * @default false
     */
    enableBatch: {
      "default": false,
      notify: function notify() {
        this._updateBatch();
      },
      tooltip: CC_DEV && 'i18n:COMPONENT.skeleton.enabled_batch'
    },
    // Below properties will effect when cache mode is SHARED_CACHE or PRIVATE_CACHE.
    // accumulate time
    _accTime: 0,
    // Play times counter
    _playCount: 0,
    // Frame cache
    _frameCache: null,
    // Cur frame
    _curFrame: null,
    // Skeleton cache
    _skeletonCache: null,
    // Aimation name
    _animationName: "",
    // Animation queue
    _animationQueue: [],
    // Head animation info of 
    _headAniInfo: null,
    // Play times
    _playTimes: 0,
    // Is animation complete.
    _isAniComplete: true
  },
  // CONSTRUCTOR
  ctor: function ctor() {
    this._effectDelegate = null;
    this._skeleton = null;
    this._rootBone = null;
    this._listener = null;
    this._materialCache = {};
    this._debugRenderer = null;
    this._startSlotIndex = -1;
    this._endSlotIndex = -1;
    this._startEntry = {
      animation: {
        name: ""
      },
      trackIndex: 0
    };
    this._endEntry = {
      animation: {
        name: ""
      },
      trackIndex: 0
    };
    this.attachUtil = new AttachUtil();
  },
  // override base class _getDefaultMaterial to modify default material
  _getDefaultMaterial: function _getDefaultMaterial() {
    return cc.Material.getBuiltinMaterial('2d-spine');
  },
  // override base class _updateMaterial to set define value and clear material cache
  _updateMaterial: function _updateMaterial() {
    var useTint = this.useTint || this.isAnimationCached() && !CC_NATIVERENDERER;
    var baseMaterial = this.getMaterial(0);

    if (baseMaterial) {
      baseMaterial.define('USE_TINT', useTint);
      baseMaterial.define('CC_USE_MODEL', !this.enableBatch);
    }

    this._materialCache = {};
  },
  // override base class disableRender to clear post render flag
  disableRender: function disableRender() {
    this._super();

    this.node._renderFlag &= ~FLAG_POST_RENDER;
  },
  // override base class disableRender to add post render flag
  markForRender: function markForRender(enable) {
    this._super(enable);

    if (enable) {
      this.node._renderFlag |= FLAG_POST_RENDER;
    } else {
      this.node._renderFlag &= ~FLAG_POST_RENDER;
    }
  },
  // if change use tint mode, just clear material cache
  _updateUseTint: function _updateUseTint() {
    var baseMaterial = this.getMaterial(0);

    if (baseMaterial) {
      var useTint = this.useTint || this.isAnimationCached() && !CC_NATIVERENDERER;
      baseMaterial.define('USE_TINT', useTint);
    }

    this._materialCache = {};
  },
  // if change use batch mode, just clear material cache
  _updateBatch: function _updateBatch() {
    var baseMaterial = this.getMaterial(0);

    if (baseMaterial) {
      baseMaterial.define('CC_USE_MODEL', !this.enableBatch);
    }

    this._materialCache = {};
  },
  _validateRender: function _validateRender() {
    var skeletonData = this.skeletonData;

    if (!skeletonData || !skeletonData.isTexturesLoaded()) {
      this.disableRender();
      return;
    }

    this._super();
  },

  /**
   * !#en
   * Sets runtime skeleton data to sp.Skeleton.<br>
   * This method is different from the `skeletonData` property. This method is passed in the raw data provided by the Spine runtime, and the skeletonData type is the asset type provided by Creator.
   * !#zh
   * 设置底层运行时用到的 SkeletonData。<br>
   * 这个接口有别于 `skeletonData` 属性，这个接口传入的是 Spine runtime 提供的原始数据，而 skeletonData 的类型是 Creator 提供的资源类型。
   * @method setSkeletonData
   * @param {sp.spine.SkeletonData} skeletonData
   */
  setSkeletonData: function setSkeletonData(skeletonData) {
    if (skeletonData.width != null && skeletonData.height != null) {
      this.node.setContentSize(skeletonData.width, skeletonData.height);
    }

    if (!CC_EDITOR) {
      if (this._cacheMode === AnimationCacheMode.SHARED_CACHE) {
        this._skeletonCache = SkeletonCache.sharedCache;
      } else if (this._cacheMode === AnimationCacheMode.PRIVATE_CACHE) {
        this._skeletonCache = new SkeletonCache();

        this._skeletonCache.enablePrivateMode();
      }
    }

    if (this.isAnimationCached()) {
      if (this.debugBones || this.debugSlots) {
        cc.warn("Debug bones or slots is invalid in cached mode");
      }

      var skeletonInfo = this._skeletonCache.getSkeletonCache(this.skeletonData._uuid, skeletonData);

      this._skeleton = skeletonInfo.skeleton;
      this._clipper = skeletonInfo.clipper;
      this._rootBone = this._skeleton.getRootBone();
    } else {
      this._skeleton = new spine.Skeleton(skeletonData);
      this._clipper = new spine.SkeletonClipping();
      this._rootBone = this._skeleton.getRootBone();
    }

    this.markForRender(true);
  },

  /**
   * !#en Sets slots visible range.
   * !#zh 设置骨骼插槽可视范围。
   * @method setSlotsRange
   * @param {Number} startSlotIndex
   * @param {Number} endSlotIndex
   */
  setSlotsRange: function setSlotsRange(startSlotIndex, endSlotIndex) {
    if (this.isAnimationCached()) {
      cc.warn("Slots visible range can not be modified in cached mode.");
    } else {
      this._startSlotIndex = startSlotIndex;
      this._endSlotIndex = endSlotIndex;
    }
  },

  /**
   * !#en Sets animation state data.<br>
   * The parameter type is {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.AnimationStateData.
   * !#zh 设置动画状态数据。<br>
   * 参数是 {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.AnimationStateData。
   * @method setAnimationStateData
   * @param {sp.spine.AnimationStateData} stateData
   */
  setAnimationStateData: function setAnimationStateData(stateData) {
    if (this.isAnimationCached()) {
      cc.warn("'setAnimationStateData' interface can not be invoked in cached mode.");
    } else {
      var state = new spine.AnimationState(stateData);

      if (this._listener) {
        if (this._state) {
          this._state.removeListener(this._listener);
        }

        state.addListener(this._listener);
      }

      this._state = state;
    }
  },
  // IMPLEMENT
  __preload: function __preload() {
    this._super();

    if (CC_EDITOR) {
      var Flags = cc.Object.Flags;
      this._objFlags |= Flags.IsAnchorLocked | Flags.IsSizeLocked;

      this._refreshInspector();
    }

    var children = this.node.children;

    for (var i = 0, n = children.length; i < n; i++) {
      var child = children[i];

      if (child && child._name === "DEBUG_DRAW_NODE") {
        child.destroy();
      }
    }

    this._updateSkeletonData();

    this._updateDebugDraw();

    this._updateUseTint();

    this._updateBatch();
  },

  /**
   * !#en
   * It's best to set cache mode before set property 'dragonAsset', or will waste some cpu time.
   * If set the mode in editor, then no need to worry about order problem.
   * !#zh 
   * 若想切换渲染模式，最好在设置'dragonAsset'之前，先设置好渲染模式，否则有运行时开销。
   * 若在编辑中设置渲染模式，则无需担心设置次序的问题。
   * 
   * @method setAnimationCacheMode
   * @param {AnimationCacheMode} cacheMode
   * @example
   * skeleton.setAnimationCacheMode(sp.Skeleton.AnimationCacheMode.SHARED_CACHE);
   */
  setAnimationCacheMode: function setAnimationCacheMode(cacheMode) {
    if (this._preCacheMode !== cacheMode) {
      this._cacheMode = cacheMode;

      this._updateSkeletonData();

      this._updateUseTint();
    }
  },

  /**
   * !#en Whether in cached mode.
   * !#zh 当前是否处于缓存模式。
   * @method isAnimationCached
   * @return {Boolean}
   */
  isAnimationCached: function isAnimationCached() {
    if (CC_EDITOR) return false;
    return this._cacheMode !== AnimationCacheMode.REALTIME;
  },
  update: function update(dt) {
    if (CC_EDITOR) return;
    if (this.paused) return;
    dt *= this.timeScale * sp.timeScale;

    if (this.isAnimationCached()) {
      // Cache mode and has animation queue.
      if (this._isAniComplete) {
        if (this._animationQueue.length === 0 && !this._headAniInfo) {
          var frameCache = this._frameCache;

          if (frameCache && frameCache.isInvalid()) {
            frameCache.updateToFrame();
            var frames = frameCache.frames;
            this._curFrame = frames[frames.length - 1];
          }

          return;
        }

        if (!this._headAniInfo) {
          this._headAniInfo = this._animationQueue.shift();
        }

        this._accTime += dt;

        if (this._accTime > this._headAniInfo.delay) {
          var aniInfo = this._headAniInfo;
          this._headAniInfo = null;
          this.setAnimation(0, aniInfo.animationName, aniInfo.loop);
        }

        return;
      }

      this._updateCache(dt);
    } else {
      this._updateRealtime(dt);
    }
  },
  _emitCacheCompleteEvent: function _emitCacheCompleteEvent() {
    if (!this._listener) return;
    this._endEntry.animation.name = this._animationName;
    this._listener.complete && this._listener.complete(this._endEntry);
    this._listener.end && this._listener.end(this._endEntry);
  },
  _updateCache: function _updateCache(dt) {
    var frameCache = this._frameCache;

    if (!frameCache.isInited()) {
      return;
    }

    var frames = frameCache.frames;
    var frameTime = SkeletonCache.FrameTime; // Animation Start, the event diffrent from dragonbones inner event,
    // It has no event object.

    if (this._accTime == 0 && this._playCount == 0) {
      this._startEntry.animation.name = this._animationName;
      this._listener && this._listener.start && this._listener.start(this._startEntry);
    }

    this._accTime += dt;
    var frameIdx = Math.floor(this._accTime / frameTime);

    if (!frameCache.isCompleted) {
      frameCache.updateToFrame(frameIdx);
    }

    if (frameCache.isCompleted && frameIdx >= frames.length) {
      this._playCount++;

      if (this._playTimes > 0 && this._playCount >= this._playTimes) {
        // set frame to end frame.
        this._curFrame = frames[frames.length - 1];
        this._accTime = 0;
        this._playCount = 0;
        this._isAniComplete = true;

        this._emitCacheCompleteEvent();

        return;
      }

      this._accTime = 0;
      frameIdx = 0;

      this._emitCacheCompleteEvent();
    }

    this._curFrame = frames[frameIdx];
  },
  _updateRealtime: function _updateRealtime(dt) {
    var skeleton = this._skeleton;
    var state = this._state;

    if (skeleton) {
      skeleton.update(dt);

      if (state) {
        state.update(dt);
        state.apply(skeleton);
      }
    }
  },

  /**
   * !#en Sets vertex effect delegate.
   * !#zh 设置顶点动画代理
   * @method setVertexEffectDelegate
   * @param {sp.VertexEffectDelegate} effectDelegate
   */
  setVertexEffectDelegate: function setVertexEffectDelegate(effectDelegate) {
    this._effectDelegate = effectDelegate;
  },
  // RENDERER

  /**
   * !#en Computes the world SRT from the local SRT for each bone.
   * !#zh 重新更新所有骨骼的世界 Transform，
   * 当获取 bone 的数值未更新时，即可使用该函数进行更新数值。
   * @method updateWorldTransform
   * @example
   * var bone = spine.findBone('head');
   * cc.log(bone.worldX); // return 0;
   * spine.updateWorldTransform();
   * bone = spine.findBone('head');
   * cc.log(bone.worldX); // return -23.12;
   */
  updateWorldTransform: function updateWorldTransform() {
    if (!this.isAnimationCached()) return;

    if (this._skeleton) {
      this._skeleton.updateWorldTransform();
    }
  },

  /**
   * !#en Sets the bones and slots to the setup pose.
   * !#zh 还原到起始动作
   * @method setToSetupPose
   */
  setToSetupPose: function setToSetupPose() {
    if (this._skeleton) {
      this._skeleton.setToSetupPose();
    }
  },

  /**
   * !#en
   * Sets the bones to the setup pose,
   * using the values from the `BoneData` list in the `SkeletonData`.
   * !#zh
   * 设置 bone 到起始动作
   * 使用 SkeletonData 中的 BoneData 列表中的值。
   * @method setBonesToSetupPose
   */
  setBonesToSetupPose: function setBonesToSetupPose() {
    if (this._skeleton) {
      this._skeleton.setBonesToSetupPose();
    }
  },

  /**
   * !#en
   * Sets the slots to the setup pose,
   * using the values from the `SlotData` list in the `SkeletonData`.
   * !#zh
   * 设置 slot 到起始动作。
   * 使用 SkeletonData 中的 SlotData 列表中的值。
   * @method setSlotsToSetupPose
   */
  setSlotsToSetupPose: function setSlotsToSetupPose() {
    if (this._skeleton) {
      this._skeleton.setSlotsToSetupPose();
    }
  },

  /**
   * !#en
   * Updating an animation cache to calculate all frame data in the animation is a cost in 
   * performance due to calculating all data in a single frame.
   * To update the cache, use the invalidAnimationCache method with high performance.
   * !#zh
   * 更新某个动画缓存, 预计算动画中所有帧数据，由于在单帧计算所有数据，所以较消耗性能。
   * 若想更新缓存，可使用 invalidAnimationCache 方法，具有较高性能。
   * @method updateAnimationCache
   * @param {String} animName
   */
  updateAnimationCache: function updateAnimationCache(animName) {
    if (!this.isAnimationCached()) return;
    var uuid = this.skeletonData._uuid;

    if (this._skeletonCache) {
      this._skeletonCache.updateAnimationCache(uuid, animName);
    }
  },

  /**
   * !#en
   * Invalidates the animation cache, which is then recomputed on each frame..
   * !#zh
   * 使动画缓存失效，之后会在每帧重新计算。
   * @method invalidAnimationCache
   */
  invalidAnimationCache: function invalidAnimationCache() {
    if (!this.isAnimationCached()) return;

    if (this._skeletonCache) {
      this._skeletonCache.invalidAnimationCache(this.skeletonData._uuid);
    }
  },

  /**
   * !#en
   * Finds a bone by name.
   * This does a string comparison for every bone.<br>
   * Returns a {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.Bone object.
   * !#zh
   * 通过名称查找 bone。
   * 这里对每个 bone 的名称进行了对比。<br>
   * 返回一个 {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.Bone 对象。
   *
   * @method findBone
   * @param {String} boneName
   * @return {sp.spine.Bone}
   */
  findBone: function findBone(boneName) {
    if (this._skeleton) {
      return this._skeleton.findBone(boneName);
    }

    return null;
  },

  /**
   * !#en
   * Finds a slot by name. This does a string comparison for every slot.<br>
   * Returns a {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.Slot object.
   * !#zh
   * 通过名称查找 slot。这里对每个 slot 的名称进行了比较。<br>
   * 返回一个 {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.Slot 对象。
   *
   * @method findSlot
   * @param {String} slotName
   * @return {sp.spine.Slot}
   */
  findSlot: function findSlot(slotName) {
    if (this._skeleton) {
      return this._skeleton.findSlot(slotName);
    }

    return null;
  },

  /**
   * !#en
   * Finds a skin by name and makes it the active skin.
   * This does a string comparison for every skin.<br>
   * Note that setting the skin does not change which attachments are visible.<br>
   * Returns a {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.Skin object.
   * !#zh
   * 按名称查找皮肤，激活该皮肤。这里对每个皮肤的名称进行了比较。<br>
   * 注意：设置皮肤不会改变 attachment 的可见性。<br>
   * 返回一个 {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.Skin 对象。
   *
   * @method setSkin
   * @param {String} skinName
   */
  setSkin: function setSkin(skinName) {
    if (this._skeleton) {
      this._skeleton.setSkinByName(skinName);

      this._skeleton.setSlotsToSetupPose();
    }

    this.invalidAnimationCache();
  },

  /**
   * !#en
   * Returns the attachment for the slot and attachment name.
   * The skeleton looks first in its skin, then in the skeleton data’s default skin.<br>
   * Returns a {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.Attachment object.
   * !#zh
   * 通过 slot 和 attachment 的名称获取 attachment。Skeleton 优先查找它的皮肤，然后才是 Skeleton Data 中默认的皮肤。<br>
   * 返回一个 {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.Attachment 对象。
   *
   * @method getAttachment
   * @param {String} slotName
   * @param {String} attachmentName
   * @return {sp.spine.Attachment}
   */
  getAttachment: function getAttachment(slotName, attachmentName) {
    if (this._skeleton) {
      return this._skeleton.getAttachmentByName(slotName, attachmentName);
    }

    return null;
  },

  /**
   * !#en
   * Sets the attachment for the slot and attachment name.
   * The skeleton looks first in its skin, then in the skeleton data’s default skin.
   * !#zh
   * 通过 slot 和 attachment 的名字来设置 attachment。
   * Skeleton 优先查找它的皮肤，然后才是 Skeleton Data 中默认的皮肤。
   * @method setAttachment
   * @param {String} slotName
   * @param {String} attachmentName
   */
  setAttachment: function setAttachment(slotName, attachmentName) {
    if (this._skeleton) {
      this._skeleton.setAttachment(slotName, attachmentName);
    }

    this.invalidAnimationCache();
  },

  /**
  * Return the renderer of attachment.
  * @method getTextureAtlas
  * @param {sp.spine.RegionAttachment|spine.BoundingBoxAttachment} regionAttachment
  * @return {sp.spine.TextureAtlasRegion}
  */
  getTextureAtlas: function getTextureAtlas(regionAttachment) {
    return regionAttachment.region;
  },
  // ANIMATION

  /**
   * !#en
   * Mix applies all keyframe values,
   * interpolated for the specified time and mixed with the current values.
   * !#zh 为所有关键帧设定混合及混合时间（从当前值开始差值）。
   * @method setMix
   * @param {String} fromAnimation
   * @param {String} toAnimation
   * @param {Number} duration
   */
  setMix: function setMix(fromAnimation, toAnimation, duration) {
    if (this._state) {
      this._state.data.setMix(fromAnimation, toAnimation, duration);
    }
  },

  /**
   * !#en Set the current animation. Any queued animations are cleared.<br>
   * Returns a {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.TrackEntry object.
   * !#zh 设置当前动画。队列中的任何的动画将被清除。<br>
   * 返回一个 {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.TrackEntry 对象。
   * @method setAnimation
   * @param {Number} trackIndex
   * @param {String} name
   * @param {Boolean} loop
   * @return {sp.spine.TrackEntry}
   */
  setAnimation: function setAnimation(trackIndex, name, loop) {
    this._playTimes = loop ? 0 : 1;
    this._animationName = name;

    if (this.isAnimationCached()) {
      if (trackIndex !== 0) {
        cc.warn("Track index can not greater than 0 in cached mode.");
      }

      if (!this._skeletonCache) return null;

      var cache = this._skeletonCache.getAnimationCache(this.skeletonData._uuid, name);

      if (!cache) {
        cache = this._skeletonCache.initAnimationCache(this.skeletonData._uuid, name);
      }

      if (cache) {
        this._isAniComplete = false;
        this._accTime = 0;
        this._playCount = 0;
        this._frameCache = cache;

        if (this.attachUtil._hasAttachedNode()) {
          this._frameCache.enableCacheAttachedInfo();
        }

        this._frameCache.updateToFrame(0);

        this._curFrame = this._frameCache.frames[0];
      }
    } else {
      if (this._skeleton) {
        var animation = this._skeleton.data.findAnimation(name);

        if (!animation) {
          cc.logID(7509, name);
          return null;
        }

        var res = this._state.setAnimationWith(trackIndex, animation, loop);

        this._state.apply(this._skeleton);

        return res;
      }
    }

    return null;
  },

  /**
   * !#en Adds an animation to be played delay seconds after the current or last queued animation.<br>
   * Returns a {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.TrackEntry object.
   * !#zh 添加一个动画到动画队列尾部，还可以延迟指定的秒数。<br>
   * 返回一个 {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.TrackEntry 对象。
   * @method addAnimation
   * @param {Number} trackIndex
   * @param {String} name
   * @param {Boolean} loop
   * @param {Number} [delay=0]
   * @return {sp.spine.TrackEntry}
   */
  addAnimation: function addAnimation(trackIndex, name, loop, delay) {
    delay = delay || 0;

    if (this.isAnimationCached()) {
      if (trackIndex !== 0) {
        cc.warn("Track index can not greater than 0 in cached mode.");
      }

      this._animationQueue.push({
        animationName: name,
        loop: loop,
        delay: delay
      });
    } else {
      if (this._skeleton) {
        var animation = this._skeleton.data.findAnimation(name);

        if (!animation) {
          cc.logID(7510, name);
          return null;
        }

        return this._state.addAnimationWith(trackIndex, animation, loop, delay);
      }
    }

    return null;
  },

  /**
   * !#en Find animation with specified name.
   * !#zh 查找指定名称的动画
   * @method findAnimation
   * @param {String} name
   * @returns {sp.spine.Animation}
   */
  findAnimation: function findAnimation(name) {
    if (this._skeleton) {
      return this._skeleton.data.findAnimation(name);
    }

    return null;
  },

  /**
   * !#en Returns track entry by trackIndex.<br>
   * Returns a {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.TrackEntry object.
   * !#zh 通过 track 索引获取 TrackEntry。<br>
   * 返回一个 {{#crossLinkModule "sp.spine"}}sp.spine{{/crossLinkModule}}.TrackEntry 对象。
   * @method getCurrent
   * @param trackIndex
   * @return {sp.spine.TrackEntry}
   */
  getCurrent: function getCurrent(trackIndex) {
    if (this.isAnimationCached()) {
      cc.warn("'getCurrent' interface can not be invoked in cached mode.");
    } else {
      if (this._state) {
        return this._state.getCurrent(trackIndex);
      }
    }

    return null;
  },

  /**
   * !#en Clears all tracks of animation state.
   * !#zh 清除所有 track 的动画状态。
   * @method clearTracks
   */
  clearTracks: function clearTracks() {
    if (this.isAnimationCached()) {
      cc.warn("'clearTracks' interface can not be invoked in cached mode.");
    } else {
      if (this._state) {
        this._state.clearTracks();
      }
    }
  },

  /**
   * !#en Clears track of animation state by trackIndex.
   * !#zh 清除出指定 track 的动画状态。
   * @method clearTrack
   * @param {number} trackIndex
   */
  clearTrack: function clearTrack(trackIndex) {
    if (this.isAnimationCached()) {
      cc.warn("'clearTrack' interface can not be invoked in cached mode.");
    } else {
      if (this._state) {
        this._state.clearTrack(trackIndex);

        if (CC_EDITOR && !cc.engine.isPlaying) {
          this._state.update(0);
        }
      }
    }
  },

  /**
   * !#en Set the start event listener.
   * !#zh 用来设置开始播放动画的事件监听。
   * @method setStartListener
   * @param {function} listener
   */
  setStartListener: function setStartListener(listener) {
    this._ensureListener();

    this._listener.start = listener;
  },

  /**
   * !#en Set the interrupt event listener.
   * !#zh 用来设置动画被打断的事件监听。
   * @method setInterruptListener
   * @param {function} listener
   */
  setInterruptListener: function setInterruptListener(listener) {
    this._ensureListener();

    this._listener.interrupt = listener;
  },

  /**
   * !#en Set the end event listener.
   * !#zh 用来设置动画播放完后的事件监听。
   * @method setEndListener
   * @param {function} listener
   */
  setEndListener: function setEndListener(listener) {
    this._ensureListener();

    this._listener.end = listener;
  },

  /**
   * !#en Set the dispose event listener.
   * !#zh 用来设置动画将被销毁的事件监听。
   * @method setDisposeListener
   * @param {function} listener
   */
  setDisposeListener: function setDisposeListener(listener) {
    this._ensureListener();

    this._listener.dispose = listener;
  },

  /**
   * !#en Set the complete event listener.
   * !#zh 用来设置动画播放一次循环结束后的事件监听。
   * @method setCompleteListener
   * @param {function} listener
   */
  setCompleteListener: function setCompleteListener(listener) {
    this._ensureListener();

    this._listener.complete = listener;
  },

  /**
   * !#en Set the animation event listener.
   * !#zh 用来设置动画播放过程中帧事件的监听。
   * @method setEventListener
   * @param {function} listener
   */
  setEventListener: function setEventListener(listener) {
    this._ensureListener();

    this._listener.event = listener;
  },

  /**
   * !#en Set the start event listener for specified TrackEntry.
   * !#zh 用来为指定的 TrackEntry 设置动画开始播放的事件监听。
   * @method setTrackStartListener
   * @param {sp.spine.TrackEntry} entry
   * @param {function} listener
   */
  setTrackStartListener: function setTrackStartListener(entry, listener) {
    TrackEntryListeners.getListeners(entry).start = listener;
  },

  /**
   * !#en Set the interrupt event listener for specified TrackEntry.
   * !#zh 用来为指定的 TrackEntry 设置动画被打断的事件监听。
   * @method setTrackInterruptListener
   * @param {sp.spine.TrackEntry} entry
   * @param {function} listener
   */
  setTrackInterruptListener: function setTrackInterruptListener(entry, listener) {
    TrackEntryListeners.getListeners(entry).interrupt = listener;
  },

  /**
   * !#en Set the end event listener for specified TrackEntry.
   * !#zh 用来为指定的 TrackEntry 设置动画播放结束的事件监听。
   * @method setTrackEndListener
   * @param {sp.spine.TrackEntry} entry
   * @param {function} listener
   */
  setTrackEndListener: function setTrackEndListener(entry, listener) {
    TrackEntryListeners.getListeners(entry).end = listener;
  },

  /**
   * !#en Set the dispose event listener for specified TrackEntry.
   * !#zh 用来为指定的 TrackEntry 设置动画即将被销毁的事件监听。
   * @method setTrackDisposeListener
   * @param {sp.spine.TrackEntry} entry
   * @param {function} listener
   */
  setTrackDisposeListener: function setTrackDisposeListener(entry, listener) {
    TrackEntryListeners.getListeners(entry).dispose = listener;
  },

  /**
   * !#en Set the complete event listener for specified TrackEntry.
   * !#zh 用来为指定的 TrackEntry 设置动画一次循环播放结束的事件监听。
   * @method setTrackCompleteListener
   * @param {sp.spine.TrackEntry} entry
   * @param {function} listener
   * @param {sp.spine.TrackEntry} listener.entry
   * @param {Number} listener.loopCount
   */
  setTrackCompleteListener: function setTrackCompleteListener(entry, listener) {
    TrackEntryListeners.getListeners(entry).complete = function (trackEntry) {
      var loopCount = Math.floor(trackEntry.trackTime / trackEntry.animationEnd);
      listener(trackEntry, loopCount);
    };
  },

  /**
   * !#en Set the event listener for specified TrackEntry.
   * !#zh 用来为指定的 TrackEntry 设置动画帧事件的监听。
   * @method setTrackEventListener
   * @param {sp.spine.TrackEntry} entry
   * @param {function} listener
   */
  setTrackEventListener: function setTrackEventListener(entry, listener) {
    TrackEntryListeners.getListeners(entry).event = listener;
  },

  /**
   * !#en Get the animation state object
   * !#zh 获取动画状态
   * @method getState
   * @return {sp.spine.AnimationState} state
   */
  getState: function getState() {
    return this._state;
  },
  // update animation list for editor
  _updateAnimEnum: CC_EDITOR && function () {
    var animEnum;

    if (this.skeletonData) {
      animEnum = this.skeletonData.getAnimsEnum();
    } // change enum


    setEnumAttr(this, '_animationIndex', animEnum || DefaultAnimsEnum);
  },
  // update skin list for editor
  _updateSkinEnum: CC_EDITOR && function () {
    var skinEnum;

    if (this.skeletonData) {
      skinEnum = this.skeletonData.getSkinsEnum();
    } // change enum


    setEnumAttr(this, '_defaultSkinIndex', skinEnum || DefaultSkinsEnum);
  },
  _ensureListener: function _ensureListener() {
    if (!this._listener) {
      this._listener = new TrackEntryListeners();

      if (this._state) {
        this._state.addListener(this._listener);
      }
    }
  },
  _updateSkeletonData: function _updateSkeletonData() {
    if (!this.skeletonData) {
      this.disableRender();
      return;
    }

    var data = this.skeletonData.getRuntimeData();

    if (!data) {
      this.disableRender();
      return;
    }

    try {
      this.setSkeletonData(data);

      if (!this.isAnimationCached()) {
        this.setAnimationStateData(new spine.AnimationStateData(this._skeleton.data));
      }

      this.defaultSkin && this.setSkin(this.defaultSkin);
    } catch (e) {
      cc.warn(e);
    }

    this.attachUtil.init(this);

    this.attachUtil._associateAttachedNode();

    this._preCacheMode = this._cacheMode;
    this.animation = this.defaultAnimation;
  },
  _refreshInspector: function _refreshInspector() {
    // update inspector
    this._updateAnimEnum();

    this._updateSkinEnum();

    Editor.Utils.refreshSelectedInspector('node', this.node.uuid);
  },
  _updateDebugDraw: function _updateDebugDraw() {
    if (this.debugBones || this.debugSlots) {
      if (!this._debugRenderer) {
        var debugDrawNode = new cc.PrivateNode();
        debugDrawNode.name = 'DEBUG_DRAW_NODE';
        var debugDraw = debugDrawNode.addComponent(Graphics);
        debugDraw.lineWidth = 1;
        debugDraw.strokeColor = cc.color(255, 0, 0, 255);
        this._debugRenderer = debugDraw;
      }

      this._debugRenderer.node.parent = this.node;

      if (this.isAnimationCached()) {
        cc.warn("Debug bones or slots is invalid in cached mode");
      }
    } else if (this._debugRenderer) {
      this._debugRenderer.node.parent = null;
    }
  }
});
module.exports = sp.Skeleton;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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