
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/extensions/dragonbones/webgl-assembler.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _assembler = _interopRequireDefault(require("../../cocos2d/core/renderer/assembler"));

var _mat = _interopRequireDefault(require("../../cocos2d/core/value-types/mat4"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var Armature = require('./ArmatureDisplay');

var RenderFlow = require('../../cocos2d/core/renderer/render-flow');

var gfx = cc.gfx;
var NEED_COLOR = 0x01;
var NEED_BATCH = 0x10;

var _boneColor = cc.color(255, 0, 0, 255);

var _slotColor = cc.color(0, 0, 255, 255);

var _originColor = cc.color(0, 255, 0, 255);

var _nodeR, _nodeG, _nodeB, _nodeA, _premultipliedAlpha, _multiply, _mustFlush, _buffer, _node, _renderer, _comp, _vfOffset, _indexOffset, _vertexOffset, _vertexCount, _indexCount, _x, _y, _c, _r, _g, _b, _a, _handleVal, _m00, _m04, _m12, _m01, _m05, _m13;

function _getSlotMaterial(tex, blendMode) {
  if (!tex) return null;
  var src, dst;

  switch (blendMode) {
    case 1:
      //additive
      src = _premultipliedAlpha ? cc.macro.ONE : cc.macro.SRC_ALPHA;
      dst = cc.macro.ONE;
      break;

    case 10:
      //multiply
      src = cc.macro.DST_COLOR;
      dst = cc.macro.ONE_MINUS_SRC_ALPHA;
      break;

    case 12:
      //screen
      src = cc.macro.ONE;
      dst = cc.macro.ONE_MINUS_SRC_COLOR;
      break;

    case 0: //normal

    default:
      src = _premultipliedAlpha ? cc.macro.ONE : cc.macro.SRC_ALPHA;
      dst = cc.macro.ONE_MINUS_SRC_ALPHA;
      break;
  }

  var useModel = !_comp.enableBatch;
  var baseMaterial = _comp._materials[0];

  if (!baseMaterial) {
    return null;
  }

  var materialCache = _comp._materialCache; // The key use to find corresponding material

  var key = tex.getId() + src + dst + useModel;
  var material = materialCache[key];

  if (!material) {
    if (!materialCache.baseMaterial) {
      material = baseMaterial;
      materialCache.baseMaterial = baseMaterial;
    } else {
      material = cc.MaterialVariant.create(baseMaterial);
    }

    material.define('CC_USE_MODEL', useModel);
    material.setProperty('texture', tex); // update blend function

    material.setBlend(true, gfx.BLEND_FUNC_ADD, src, dst, gfx.BLEND_FUNC_ADD, src, dst);
    materialCache[key] = material;
  }

  return material;
}

function _handleColor(color, parentOpacity) {
  _a = color.a * parentOpacity * _nodeA;
  _multiply = _premultipliedAlpha ? _a / 255.0 : 1.0;
  _r = color.r * _nodeR * _multiply;
  _g = color.g * _nodeG * _multiply;
  _b = color.b * _nodeB * _multiply;
  _c = (_a << 24 >>> 0) + (_b << 16) + (_g << 8) + _r;
}

var ArmatureAssembler =
/*#__PURE__*/
function (_Assembler) {
  _inheritsLoose(ArmatureAssembler, _Assembler);

  function ArmatureAssembler() {
    return _Assembler.apply(this, arguments) || this;
  }

  var _proto = ArmatureAssembler.prototype;

  _proto.updateRenderData = function updateRenderData(comp, batchData) {};

  _proto.realTimeTraverse = function realTimeTraverse(armature, parentMat, parentOpacity) {
    var slots = armature._slots;
    var vbuf, ibuf, uintbuf;
    var material;
    var vertices, indices;
    var slotColor;
    var slot;
    var slotMat;
    var slotMatm;
    var offsetInfo;

    for (var i = 0, l = slots.length; i < l; i++) {
      slot = slots[i];
      slotColor = slot._color;
      if (!slot._visible || !slot._displayData) continue;

      if (parentMat) {
        slot._mulMat(slot._worldMatrix, parentMat, slot._matrix);
      } else {
        _mat["default"].copy(slot._worldMatrix, slot._matrix);
      }

      if (slot.childArmature) {
        this.realTimeTraverse(slot.childArmature, slot._worldMatrix, parentOpacity * slotColor.a / 255);
        continue;
      }

      material = _getSlotMaterial(slot.getTexture(), slot._blendMode);

      if (!material) {
        continue;
      }

      if (_mustFlush || material.getHash() !== _renderer.material.getHash()) {
        _mustFlush = false;

        _renderer._flush();

        _renderer.node = _node;
        _renderer.material = material;
      }

      _handleColor(slotColor, parentOpacity);

      slotMat = slot._worldMatrix;
      slotMatm = slotMat.m;
      vertices = slot._localVertices;
      _vertexCount = vertices.length >> 2;
      indices = slot._indices;
      _indexCount = indices.length;
      offsetInfo = _buffer.request(_vertexCount, _indexCount);
      _indexOffset = offsetInfo.indiceOffset;
      _vfOffset = offsetInfo.byteOffset >> 2;
      _vertexOffset = offsetInfo.vertexOffset;
      vbuf = _buffer._vData;
      ibuf = _buffer._iData;
      uintbuf = _buffer._uintVData;
      _m00 = slotMatm[0];
      _m04 = slotMatm[4];
      _m12 = slotMatm[12];
      _m01 = slotMatm[1];
      _m05 = slotMatm[5];
      _m13 = slotMatm[13];

      for (var vi = 0, vl = vertices.length; vi < vl;) {
        _x = vertices[vi++];
        _y = vertices[vi++];
        vbuf[_vfOffset++] = _x * _m00 + _y * _m04 + _m12; // x

        vbuf[_vfOffset++] = _x * _m01 + _y * _m05 + _m13; // y

        vbuf[_vfOffset++] = vertices[vi++]; // u

        vbuf[_vfOffset++] = vertices[vi++]; // v

        uintbuf[_vfOffset++] = _c; // color
      }

      for (var ii = 0, il = indices.length; ii < il; ii++) {
        ibuf[_indexOffset++] = _vertexOffset + indices[ii];
      }
    }
  };

  _proto.cacheTraverse = function cacheTraverse(frame, parentMat) {
    if (!frame) return;
    var segments = frame.segments;
    if (segments.length == 0) return;
    var vbuf, ibuf, uintbuf;
    var material;
    var offsetInfo;
    var vertices = frame.vertices;
    var indices = frame.indices;
    var frameVFOffset = 0,
        frameIndexOffset = 0,
        segVFCount = 0;

    if (parentMat) {
      var parentMatm = parentMat.m;
      _m00 = parentMatm[0];
      _m01 = parentMatm[1];
      _m04 = parentMatm[4];
      _m05 = parentMatm[5];
      _m12 = parentMatm[12];
      _m13 = parentMatm[13];
    }

    var justTranslate = _m00 === 1 && _m01 === 0 && _m04 === 0 && _m05 === 1;
    var needBatch = _handleVal & NEED_BATCH;
    var calcTranslate = needBatch && justTranslate;
    var colorOffset = 0;
    var colors = frame.colors;
    var nowColor = colors[colorOffset++];
    var maxVFOffset = nowColor.vfOffset;

    _handleColor(nowColor, 1.0);

    for (var i = 0, n = segments.length; i < n; i++) {
      var segInfo = segments[i];
      material = _getSlotMaterial(segInfo.tex, segInfo.blendMode);

      if (_mustFlush || material.getHash() !== _renderer.material.getHash()) {
        _mustFlush = false;

        _renderer._flush();

        _renderer.node = _node;
        _renderer.material = material;
      }

      _vertexCount = segInfo.vertexCount;
      _indexCount = segInfo.indexCount;
      offsetInfo = _buffer.request(_vertexCount, _indexCount);
      _indexOffset = offsetInfo.indiceOffset;
      _vertexOffset = offsetInfo.vertexOffset;
      _vfOffset = offsetInfo.byteOffset >> 2;
      vbuf = _buffer._vData;
      ibuf = _buffer._iData;
      uintbuf = _buffer._uintVData;

      for (var ii = _indexOffset, il = _indexOffset + _indexCount; ii < il; ii++) {
        ibuf[ii] = _vertexOffset + indices[frameIndexOffset++];
      }

      segVFCount = segInfo.vfCount;
      vbuf.set(vertices.subarray(frameVFOffset, frameVFOffset + segVFCount), _vfOffset);
      frameVFOffset += segVFCount;

      if (calcTranslate) {
        for (var _ii = _vfOffset, _il = _vfOffset + segVFCount; _ii < _il; _ii += 5) {
          vbuf[_ii] += _m12;
          vbuf[_ii + 1] += _m13;
        }
      } else if (needBatch) {
        for (var _ii2 = _vfOffset, _il2 = _vfOffset + segVFCount; _ii2 < _il2; _ii2 += 5) {
          _x = vbuf[_ii2];
          _y = vbuf[_ii2 + 1];
          vbuf[_ii2] = _x * _m00 + _y * _m04 + _m12;
          vbuf[_ii2 + 1] = _x * _m01 + _y * _m05 + _m13;
        }
      }

      if (!(_handleVal & NEED_COLOR)) continue; // handle color

      var frameColorOffset = frameVFOffset - segVFCount;

      for (var _ii3 = _vfOffset + 4, _il3 = _vfOffset + 4 + segVFCount; _ii3 < _il3; _ii3 += 5, frameColorOffset += 5) {
        if (frameColorOffset >= maxVFOffset) {
          nowColor = colors[colorOffset++];

          _handleColor(nowColor, 1.0);

          maxVFOffset = nowColor.vfOffset;
        }

        uintbuf[_ii3] = _c;
      }
    }
  };

  _proto.fillBuffers = function fillBuffers(comp, renderer) {
    comp.node._renderFlag |= RenderFlow.FLAG_UPDATE_RENDER_DATA;
    var armature = comp._armature;
    if (!armature) return; // Init temp var.

    _mustFlush = true;
    _premultipliedAlpha = comp.premultipliedAlpha;
    _node = comp.node;
    _buffer = renderer._meshBuffer;
    _renderer = renderer;
    _comp = comp;
    _handleVal = 0;
    var nodeColor = _node._color;
    _nodeR = nodeColor.r / 255;
    _nodeG = nodeColor.g / 255;
    _nodeB = nodeColor.b / 255;
    _nodeA = nodeColor.a / 255;

    if (nodeColor._val !== 0xffffffff) {
      _handleVal |= NEED_COLOR;
    }

    var worldMat = undefined;

    if (_comp.enableBatch) {
      worldMat = _node._worldMatrix;
      _mustFlush = false;
      _handleVal |= NEED_BATCH;
    }

    if (comp.isAnimationCached()) {
      // Traverse input assembler.
      this.cacheTraverse(comp._curFrame, worldMat);
    } else {
      // Traverse all armature.
      this.realTimeTraverse(armature, worldMat, 1.0);
      var graphics = comp._debugDraw;

      if (comp.debugBones && graphics) {
        graphics.clear();
        graphics.lineWidth = 5;
        graphics.strokeColor = _boneColor;
        graphics.fillColor = _slotColor; // Root bone color is same as slot color.

        var bones = armature.getBones();

        for (var i = 0, l = bones.length; i < l; i++) {
          var bone = bones[i];
          var boneLength = Math.max(bone.boneData.length, 5);
          var startX = bone.globalTransformMatrix.tx;
          var startY = bone.globalTransformMatrix.ty;
          var endX = startX + bone.globalTransformMatrix.a * boneLength;
          var endY = startY + bone.globalTransformMatrix.b * boneLength;
          graphics.moveTo(startX, startY);
          graphics.lineTo(endX, endY);
          graphics.stroke(); // Bone origins.

          graphics.circle(startX, startY, Math.PI * 2);
          graphics.fill();

          if (i === 0) {
            graphics.fillColor = _originColor;
          }
        }
      }
    } // sync attached node matrix


    renderer.worldMatDirty++;

    comp.attachUtil._syncAttachedNode(); // Clear temp var.


    _node = undefined;
    _buffer = undefined;
    _renderer = undefined;
    _comp = undefined;
  };

  _proto.postFillBuffers = function postFillBuffers(comp, renderer) {
    renderer.worldMatDirty--;
  };

  return ArmatureAssembler;
}(_assembler["default"]);

exports["default"] = ArmatureAssembler;

_assembler["default"].register(Armature, ArmatureAssembler);

module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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