
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/extensions/dragonbones/index.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * !#en
 * The global main namespace of DragonBones, all classes, functions,
 * properties and constants of DragonBones are defined in this namespace
 * !#zh
 * DragonBones 的全局的命名空间，
 * 与 DragonBones 相关的所有的类，函数，属性，常量都在这个命名空间中定义。
 * @module dragonBones
 * @main dragonBones
 */

/*
 * Reference:
 * http://dragonbones.com/cn/index.html
 */
var _global = typeof window === 'undefined' ? global : window;

if (!CC_NATIVERENDERER) {
  _global.dragonBones = require('./lib/dragonBones');
}

if (_global.dragonBones !== undefined) {
  /**
   * !#en
   * The global time scale of DragonBones.
   * !#zh
   * DragonBones 全局时间缩放率。
   * @example
   * dragonBones.timeScale = 0.8;
   */
  dragonBones._timeScale = 1.0;
  Object.defineProperty(dragonBones, 'timeScale', {
    get: function get() {
      return this._timeScale;
    },
    set: function set(value) {
      this._timeScale = value;
      var factory = this.CCFactory.getInstance();
      factory._dragonBones.clock.timeScale = value;
    },
    configurable: true
  });
  dragonBones.DisplayType = {
    Image: 0,
    Armature: 1,
    Mesh: 2
  };
  dragonBones.ArmatureType = {
    Armature: 0,
    MovieClip: 1,
    Stage: 2
  };
  dragonBones.ExtensionType = {
    FFD: 0,
    AdjustColor: 10,
    BevelFilter: 11,
    BlurFilter: 12,
    DropShadowFilter: 13,
    GlowFilter: 14,
    GradientBevelFilter: 15,
    GradientGlowFilter: 16
  };
  dragonBones.EventType = {
    Frame: 0,
    Sound: 1
  };
  dragonBones.ActionType = {
    Play: 0,
    Stop: 1,
    GotoAndPlay: 2,
    GotoAndStop: 3,
    FadeIn: 4,
    FadeOut: 5
  };
  dragonBones.AnimationFadeOutMode = {
    None: 0,
    SameLayer: 1,
    SameGroup: 2,
    SameLayerAndGroup: 3,
    All: 4
  };
  dragonBones.BinaryOffset = {
    WeigthBoneCount: 0,
    WeigthFloatOffset: 1,
    WeigthBoneIndices: 2,
    MeshVertexCount: 0,
    MeshTriangleCount: 1,
    MeshFloatOffset: 2,
    MeshWeightOffset: 3,
    MeshVertexIndices: 4,
    TimelineScale: 0,
    TimelineOffset: 1,
    TimelineKeyFrameCount: 2,
    TimelineFrameValueCount: 3,
    TimelineFrameValueOffset: 4,
    TimelineFrameOffset: 5,
    FramePosition: 0,
    FrameTweenType: 1,
    FrameTweenEasingOrCurveSampleCount: 2,
    FrameCurveSamples: 3,
    DeformMeshOffset: 0,
    DeformCount: 1,
    DeformValueCount: 2,
    DeformValueOffset: 3,
    DeformFloatOffset: 4
  };
  dragonBones.BoneType = {
    Bone: 0,
    Surface: 1
  };

  if (!CC_EDITOR || !Editor.isMainProcess) {
    if (!CC_NATIVERENDERER) {
      require('./CCFactory');

      require('./CCSlot');

      require('./CCTextureData');

      require('./CCArmatureDisplay');

      require('./ArmatureCache');
    } // require the component for dragonbones


    require('./DragonBonesAsset');

    require('./DragonBonesAtlasAsset');

    require('./ArmatureDisplay');

    require('./webgl-assembler');
  } else {
    require('./DragonBonesAsset');

    require('./DragonBonesAtlasAsset');
  }
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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