
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/extensions/dragonbones/CCSlot.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var _mat = _interopRequireDefault(require("../../cocos2d/core/value-types/mat4"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/****************************************************************************
 Copyright (c) 2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var BinaryOffset = dragonBones.BinaryOffset;
var BoneType = dragonBones.BoneType;
dragonBones.CCSlot = cc.Class({
  name: 'dragonBones.CCSlot',
  "extends": dragonBones.Slot,
  ctor: function ctor() {
    this._localVertices = [];
    this._indices = [];
    this._matrix = cc.mat4();
    this._worldMatrix = cc.mat4();
    this._worldMatrixDirty = true;
    this._visible = false;
    this._color = cc.color();
  },
  _onClear: function _onClear() {
    this._super();

    this._localVertices.length = 0;
    this._indices.length = 0;

    _mat["default"].identity(this._matrix);

    _mat["default"].identity(this._worldMatrix);

    this._worldMatrixDirty = true;
    this._color = cc.color();
    this._visible = false;
  },
  statics: {
    toString: function toString() {
      return "[class dragonBones.CCSlot]";
    }
  },
  // just for adapt to dragonbones api,no need to do any thing
  _onUpdateDisplay: function _onUpdateDisplay() {},
  // just for adapt to dragonbones api,no need to do any thing
  _initDisplay: function _initDisplay(value) {},
  _addDisplay: function _addDisplay() {
    this._visible = true;
  },
  // just for adapt to dragonbones api,no need to do any thing
  _replaceDisplay: function _replaceDisplay(value) {},
  _removeDisplay: function _removeDisplay() {
    this._visible = false;
  },
  // just for adapt to dragonbones api,no need to do any thing
  _disposeDisplay: function _disposeDisplay(object) {},
  _updateVisible: function _updateVisible() {
    this._visible = this.parent._visible;
  },
  // just for adapt to dragonbones api,no need to do any thing
  _updateZOrder: function _updateZOrder() {},
  _updateBlendMode: function _updateBlendMode() {
    if (this._childArmature) {
      var childSlots = this._childArmature.getSlots();

      for (var i = 0, l = childSlots.length; i < l; i++) {
        var slot = childSlots[i];
        slot._blendMode = this._blendMode;

        slot._updateBlendMode();
      }
    }
  },
  _updateColor: function _updateColor() {
    var c = this._color;
    c.r = this._colorTransform.redMultiplier * 255;
    c.g = this._colorTransform.greenMultiplier * 255;
    c.b = this._colorTransform.blueMultiplier * 255;
    c.a = this._colorTransform.alphaMultiplier * 255;
  },
  //return dragonBones.CCTexture2D
  getTexture: function getTexture() {
    return this._textureData && this._textureData.spriteFrame && this._textureData.spriteFrame.getTexture();
  },
  _updateFrame: function _updateFrame() {
    this._indices.length = 0;
    var indices = this._indices,
        localVertices = this._localVertices;
    var indexOffset = 0,
        vfOffset = 0;
    var currentTextureData = this._textureData;
    if (!this._display || this._displayIndex < 0 || !currentTextureData || !currentTextureData.spriteFrame) return;
    var texture = currentTextureData.spriteFrame.getTexture();
    var textureAtlasWidth = texture.width;
    var textureAtlasHeight = texture.height;
    var region = currentTextureData.region;
    var currentVerticesData = this._deformVertices !== null && this._display === this._meshDisplay ? this._deformVertices.verticesData : null;

    if (currentVerticesData) {
      var data = currentVerticesData.data;
      var intArray = data.intArray;
      var floatArray = data.floatArray;
      var vertexCount = intArray[currentVerticesData.offset + BinaryOffset.MeshVertexCount];
      var triangleCount = intArray[currentVerticesData.offset + BinaryOffset.MeshTriangleCount];
      var vertexOffset = intArray[currentVerticesData.offset + BinaryOffset.MeshFloatOffset];

      if (vertexOffset < 0) {
        vertexOffset += 65536; // Fixed out of bouds bug. 
      }

      var uvOffset = vertexOffset + vertexCount * 2;
      var scale = this._armature._armatureData.scale;

      for (var i = 0, l = vertexCount * 2; i < l; i += 2) {
        localVertices[vfOffset++] = floatArray[vertexOffset + i] * scale;
        localVertices[vfOffset++] = -floatArray[vertexOffset + i + 1] * scale;

        if (currentVerticesData.rotated) {
          localVertices[vfOffset++] = (region.x + (1.0 - floatArray[uvOffset + i]) * region.width) / textureAtlasWidth;
          localVertices[vfOffset++] = (region.y + floatArray[uvOffset + i + 1] * region.height) / textureAtlasHeight;
        } else {
          localVertices[vfOffset++] = (region.x + floatArray[uvOffset + i] * region.width) / textureAtlasWidth;
          localVertices[vfOffset++] = (region.y + floatArray[uvOffset + i + 1] * region.height) / textureAtlasHeight;
        }
      }

      for (var _i = 0; _i < triangleCount * 3; ++_i) {
        indices[indexOffset++] = intArray[currentVerticesData.offset + BinaryOffset.MeshVertexIndices + _i];
      }

      localVertices.length = vfOffset;
      indices.length = indexOffset;
      var isSkinned = !!currentVerticesData.weight;

      if (isSkinned) {
        this._identityTransform();
      }
    } else {
      var _l = region.x / textureAtlasWidth;

      var b = (region.y + region.height) / textureAtlasHeight;
      var r = (region.x + region.width) / textureAtlasWidth;
      var t = region.y / textureAtlasHeight;
      localVertices[vfOffset++] = 0; // 0x

      localVertices[vfOffset++] = 0; // 0y

      localVertices[vfOffset++] = _l; // 0u

      localVertices[vfOffset++] = b; // 0v

      localVertices[vfOffset++] = region.width; // 1x

      localVertices[vfOffset++] = 0; // 1y

      localVertices[vfOffset++] = r; // 1u

      localVertices[vfOffset++] = b; // 1v

      localVertices[vfOffset++] = 0; // 2x

      localVertices[vfOffset++] = region.height;
      ; // 2y

      localVertices[vfOffset++] = _l; // 2u

      localVertices[vfOffset++] = t; // 2v

      localVertices[vfOffset++] = region.width; // 3x

      localVertices[vfOffset++] = region.height;
      ; // 3y

      localVertices[vfOffset++] = r; // 3u

      localVertices[vfOffset++] = t; // 3v

      indices[0] = 0;
      indices[1] = 1;
      indices[2] = 2;
      indices[3] = 1;
      indices[4] = 3;
      indices[5] = 2;
      localVertices.length = vfOffset;
      indices.length = 6;
    }

    this._visibleDirty = true;
    this._blendModeDirty = true;
    this._colorDirty = true;
  },
  _updateMesh: function _updateMesh() {
    var scale = this._armature._armatureData.scale;
    var deformVertices = this._deformVertices.vertices;
    var bones = this._deformVertices.bones;
    var verticesData = this._deformVertices.verticesData;
    var weightData = verticesData.weight;
    var hasDeform = deformVertices.length > 0 && verticesData.inheritDeform;
    var localVertices = this._localVertices;

    if (weightData) {
      var data = verticesData.data;
      var intArray = data.intArray;
      var floatArray = data.floatArray;
      var vertexCount = intArray[verticesData.offset + BinaryOffset.MeshVertexCount];
      var weightFloatOffset = intArray[weightData.offset + BinaryOffset.WeigthFloatOffset];

      if (weightFloatOffset < 0) {
        weightFloatOffset += 65536; // Fixed out of bouds bug. 
      }

      for (var i = 0, iB = weightData.offset + BinaryOffset.WeigthBoneIndices + bones.length, iV = weightFloatOffset, iF = 0, lvi = 0; i < vertexCount; i++, lvi += 4) {
        var boneCount = intArray[iB++];
        var xG = 0.0,
            yG = 0.0;

        for (var j = 0; j < boneCount; ++j) {
          var boneIndex = intArray[iB++];
          var bone = bones[boneIndex];

          if (bone !== null) {
            var matrix = bone.globalTransformMatrix;
            var weight = floatArray[iV++];
            var xL = floatArray[iV++] * scale;
            var yL = floatArray[iV++] * scale;

            if (hasDeform) {
              xL += deformVertices[iF++];
              yL += deformVertices[iF++];
            }

            xG += (matrix.a * xL + matrix.c * yL + matrix.tx) * weight;
            yG += (matrix.b * xL + matrix.d * yL + matrix.ty) * weight;
          }
        }

        localVertices[lvi] = xG;
        localVertices[lvi + 1] = -yG;
      }
    } else if (hasDeform) {
      var isSurface = this._parent._boneData.type !== BoneType.Bone;
      var _data = verticesData.data;
      var _intArray = _data.intArray;
      var _floatArray = _data.floatArray;
      var _vertexCount = _intArray[verticesData.offset + BinaryOffset.MeshVertexCount];
      var vertexOffset = _intArray[verticesData.offset + BinaryOffset.MeshFloatOffset];

      if (vertexOffset < 0) {
        vertexOffset += 65536; // Fixed out of bouds bug. 
      }

      for (var _i2 = 0, l = _vertexCount, _lvi = 0; _i2 < l; _i2++, _lvi += 4) {
        var x = _floatArray[vertexOffset + _i2 * 2] * scale + deformVertices[_i2 * 2];
        var y = _floatArray[vertexOffset + _i2 * 2 + 1] * scale + deformVertices[_i2 * 2 + 1];

        if (isSurface) {
          var _matrix = this._parent._getGlobalTransformMatrix(x, y);

          localVertices[_lvi] = _matrix.a * x + _matrix.c * y + _matrix.tx;
          localVertices[_lvi + 1] = -_matrix.b * x + _matrix.d * y + _matrix.ty;
        } else {
          localVertices[_lvi] = x;
          localVertices[_lvi + 1] = -y;
        }
      }
    }

    if (weightData) {
      this._identityTransform();
    }
  },
  _identityTransform: function _identityTransform() {
    var m = this._matrix.m;
    m[0] = 1.0;
    m[1] = 0.0;
    m[4] = -0.0;
    m[5] = -1.0;
    m[12] = 0.0;
    m[13] = 0.0;
    this._worldMatrixDirty = true;
  },
  _updateTransform: function _updateTransform() {
    var t = this._matrix;
    var tm = t.m;
    tm[0] = this.globalTransformMatrix.a;
    tm[1] = this.globalTransformMatrix.b;
    tm[4] = -this.globalTransformMatrix.c;
    tm[5] = -this.globalTransformMatrix.d;

    if (this._childArmature) {
      tm[12] = this.globalTransformMatrix.tx;
      tm[13] = this.globalTransformMatrix.ty;
    } else {
      tm[12] = this.globalTransformMatrix.tx - (this.globalTransformMatrix.a * this._pivotX - this.globalTransformMatrix.c * this._pivotY);
      tm[13] = this.globalTransformMatrix.ty - (this.globalTransformMatrix.b * this._pivotX - this.globalTransformMatrix.d * this._pivotY);
    }

    this._worldMatrixDirty = true;
  },
  updateWorldMatrix: function updateWorldMatrix() {
    if (!this._armature) return;
    var parentSlot = this._armature._parent;

    if (parentSlot) {
      parentSlot.updateWorldMatrix();
    }

    if (this._worldMatrixDirty) {
      this.calculWorldMatrix();
      var childArmature = this.childArmature;
      if (!childArmature) return;
      var slots = childArmature.getSlots();

      for (var i = 0, n = slots.length; i < n; i++) {
        var slot = slots[i];

        if (slot) {
          slot._worldMatrixDirty = true;
        }
      }
    }
  },
  _mulMat: function _mulMat(out, a, b) {
    var am = a.m,
        bm = b.m,
        outm = out.m;
    var aa = am[0],
        ab = am[1],
        ac = am[4],
        ad = am[5],
        atx = am[12],
        aty = am[13];
    var ba = bm[0],
        bb = bm[1],
        bc = bm[4],
        bd = bm[5],
        btx = bm[12],
        bty = bm[13];

    if (ab !== 0 || ac !== 0) {
      outm[0] = ba * aa + bb * ac;
      outm[1] = ba * ab + bb * ad;
      outm[4] = bc * aa + bd * ac;
      outm[5] = bc * ab + bd * ad;
      outm[12] = aa * btx + ac * bty + atx;
      outm[13] = ab * btx + ad * bty + aty;
    } else {
      outm[0] = ba * aa;
      outm[1] = bb * ad;
      outm[4] = bc * aa;
      outm[5] = bd * ad;
      outm[12] = aa * btx + atx;
      outm[13] = ad * bty + aty;
    }
  },
  calculWorldMatrix: function calculWorldMatrix() {
    var parent = this._armature._parent;

    if (parent) {
      this._mulMat(this._worldMatrix, parent._worldMatrix, this._matrix);
    } else {
      _mat["default"].copy(this._worldMatrix, this._matrix);
    }

    this._worldMatrixDirty = false;
  }
});
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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