
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/webview/webview-impl.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var utils = require('../core/platform/utils');

var sys = require('../core/platform/CCSys');

var _mat4_temp = cc.mat4();

var WebViewImpl = cc.Class({
  name: "WebViewImpl",
  ctor: function ctor() {
    // this.setContentSize(cc.size(300, 200));
    this._EventList = {};
    this._visible = false;
    this._parent = null;
    this._div = null;
    this._iframe = null;
    this._listener = null;
    this._forceUpdate = false; // update matrix cache

    this._m00 = 0;
    this._m01 = 0;
    this._m04 = 0;
    this._m05 = 0;
    this._m12 = 0;
    this._m13 = 0;
    this._w = 0;
    this._h = 0; //

    this.__eventListeners = {};
  },
  _updateVisibility: function _updateVisibility() {
    if (!this._div) return;
    var div = this._div;

    if (this._visible) {
      div.style.visibility = 'visible';
    } else {
      div.style.visibility = 'hidden';
    }
  },
  _updateSize: function _updateSize(w, h) {
    var div = this._div;

    if (div) {
      div.style.width = w + "px";
      div.style.height = h + "px";
    }
  },
  _initEvent: function _initEvent() {
    var iframe = this._iframe;

    if (iframe) {
      var cbs = this.__eventListeners,
          self = this;

      cbs.load = function () {
        self._forceUpdate = true;

        self._dispatchEvent(WebViewImpl.EventType.LOADED);
      };

      cbs.error = function () {
        self._dispatchEvent(WebViewImpl.EventType.ERROR);
      };

      iframe.addEventListener("load", cbs.load);
      iframe.addEventListener("error", cbs.error);
    }
  },
  _initStyle: function _initStyle() {
    if (!this._div) return;
    var div = this._div;
    div.style.position = "absolute";
    div.style.bottom = "0px";
    div.style.left = "0px";
  },
  _setOpacity: function _setOpacity(opacity) {
    var iframe = this._iframe;

    if (iframe && iframe.style) {
      iframe.style.opacity = opacity / 255;
    }
  },
  _createDom: function _createDom(w, h) {
    if (WebViewImpl._polyfill.enableDiv) {
      this._div = document.createElement("div");
      this._div.style["-webkit-overflow"] = "auto";
      this._div.style["-webkit-overflow-scrolling"] = "touch";
      this._iframe = document.createElement("iframe");

      this._div.appendChild(this._iframe);

      this._iframe.style.width = "100%";
      this._iframe.style.height = "100%";
    } else {
      this._div = this._iframe = document.createElement("iframe");
    }

    if (WebViewImpl._polyfill.enableBG) this._div.style["background"] = "#FFF";
    this._div.style["background"] = "#FFF";
    this._div.style.height = h + "px";
    this._div.style.width = w + "px";
    this._div.style.overflow = "scroll";
    this._iframe.style.border = "none";
    cc.game.container.appendChild(this._div);

    this._updateVisibility();
  },
  _createNativeControl: function _createNativeControl(w, h) {
    this._createDom(w, h);

    this._initStyle();

    this._initEvent();
  },
  createDomElementIfNeeded: CC_EDITOR ? function (w, h) {
    this._div = document.createElement('div');
    this._div.style.background = 'rgba(255, 255, 255, 0.8)';
    this._div.style.color = 'rgb(51, 51, 51)';
    this._div.style.height = w + 'px';
    this._div.style.width = h + 'px';
    this._div.style.position = 'absolute';
    this._div.style.bottom = '0px';
    this._div.style.left = '0px';
    this._div.style['word-wrap'] = 'break-word';
    cc.game.container.appendChild(this._div);
  } : function (w, h) {
    if (!this._div) {
      this._createNativeControl(w, h);
    } else {
      this._updateSize(w, h);
    }
  },
  removeDom: function removeDom() {
    var div = this._div;

    if (div) {
      var hasChild = utils.contains(cc.game.container, div);
      if (hasChild) cc.game.container.removeChild(div);
      this._div = null;
    }

    var iframe = this._iframe;

    if (iframe) {
      var cbs = this.__eventListeners;
      iframe.removeEventListener("load", cbs.load);
      iframe.removeEventListener("error", cbs.error);
      cbs.load = null;
      cbs.error = null;
      this._iframe = null;
    }
  },
  setOnJSCallback: function setOnJSCallback(callback) {},
  setJavascriptInterfaceScheme: function setJavascriptInterfaceScheme(scheme) {},
  // private method
  loadData: function loadData(data, MIMEType, encoding, baseURL) {},
  loadHTMLString: function loadHTMLString(string, baseURL) {},

  /**
   * Load an URL
   * @param {String} url
   */
  loadURL: CC_EDITOR ? function (url) {
    this._div.innerText = url;
  } : function (url) {
    var iframe = this._iframe;

    if (iframe) {
      iframe.src = url;
      var self = this;

      var cb = function cb() {
        self._loaded = true;

        self._updateVisibility();

        iframe.removeEventListener("load", cb);
      };

      iframe.addEventListener("load", cb);

      this._dispatchEvent(WebViewImpl.EventType.LOADING);
    }
  },

  /**
   * Stop loading
   */
  stopLoading: function stopLoading() {
    cc.logID(7800);
  },

  /**
   * Reload the WebView
   */
  reload: function reload() {
    var iframe = this._iframe;

    if (iframe) {
      var win = iframe.contentWindow;
      if (win && win.location) win.location.reload();
    }
  },

  /**
   * Determine whether to go back
   */
  canGoBack: function canGoBack() {
    cc.logID(7801);
    return true;
  },

  /**
   * Determine whether to go forward
   */
  canGoForward: function canGoForward() {
    cc.logID(7802);
    return true;
  },

  /**
   * go back
   */
  goBack: function goBack() {
    try {
      if (WebViewImpl._polyfill.closeHistory) return cc.logID(7803);
      var iframe = this._iframe;

      if (iframe) {
        var win = iframe.contentWindow;
        if (win && win.location) win.history.back.call(win);
      }
    } catch (err) {
      cc.log(err);
    }
  },

  /**
   * go forward
   */
  goForward: function goForward() {
    try {
      if (WebViewImpl._polyfill.closeHistory) return cc.logID(7804);
      var iframe = this._iframe;

      if (iframe) {
        var win = iframe.contentWindow;
        if (win && win.location) win.history.forward.call(win);
      }
    } catch (err) {
      cc.log(err);
    }
  },

  /**
   * In the webview execution within a period of js string
   * @param {String} str
   */
  evaluateJS: function evaluateJS(str) {
    var iframe = this._iframe;

    if (iframe) {
      var win = iframe.contentWindow;

      try {
        win.eval(str);

        this._dispatchEvent(WebViewImpl.EventType.JS_EVALUATED);
      } catch (err) {
        console.error(err);
      }
    }
  },

  /**
   * Limited scale
   */
  setScalesPageToFit: function setScalesPageToFit() {
    cc.logID(7805);
  },

  /**
   * The binding event
   * @param {WebViewImpl.EventType} event
   * @param {Function} callback
   */
  setEventListener: function setEventListener(event, callback) {
    this._EventList[event] = callback;
  },

  /**
   * Delete events
   * @param {WebViewImpl.EventType} event
   */
  removeEventListener: function removeEventListener(event) {
    this._EventList[event] = null;
  },
  _dispatchEvent: function _dispatchEvent(event) {
    var callback = this._EventList[event];
    if (callback) callback.call(this, this, this._iframe.src);
  },
  _createRenderCmd: function _createRenderCmd() {
    return new WebViewImpl.RenderCmd(this);
  },
  destroy: function destroy() {
    this.removeDom();
  },
  setVisible: function setVisible(visible) {
    if (this._visible !== visible) {
      this._visible = !!visible;

      this._updateVisibility();
    }
  },
  updateMatrix: function updateMatrix(node) {
    if (!this._div || !this._visible) return;
    node.getWorldMatrix(_mat4_temp);

    var renderCamera = cc.Camera._findRendererCamera(node);

    if (renderCamera) {
      renderCamera.worldMatrixToScreen(_mat4_temp, _mat4_temp, cc.game.canvas.width, cc.game.canvas.height);
    }

    var _mat4_tempm = _mat4_temp.m;

    if (!this._forceUpdate && this._m00 === _mat4_tempm[0] && this._m01 === _mat4_tempm[1] && this._m04 === _mat4_tempm[4] && this._m05 === _mat4_tempm[5] && this._m12 === _mat4_tempm[12] && this._m13 === _mat4_tempm[13] && this._w === node._contentSize.width && this._h === node._contentSize.height) {
      return;
    } // update matrix cache


    this._m00 = _mat4_tempm[0];
    this._m01 = _mat4_tempm[1];
    this._m04 = _mat4_tempm[4];
    this._m05 = _mat4_tempm[5];
    this._m12 = _mat4_tempm[12];
    this._m13 = _mat4_tempm[13];
    this._w = node._contentSize.width;
    this._h = node._contentSize.height;
    var dpr = cc.view._devicePixelRatio;
    var scaleX = 1 / dpr;
    var scaleY = 1 / dpr;
    var container = cc.game.container;
    var a = _mat4_tempm[0] * scaleX,
        b = _mat4_tempm[1],
        c = _mat4_tempm[4],
        d = _mat4_tempm[5] * scaleY;
    var offsetX = container && container.style.paddingLeft ? parseInt(container.style.paddingLeft) : 0;
    var offsetY = container && container.style.paddingBottom ? parseInt(container.style.paddingBottom) : 0;

    this._updateSize(this._w, this._h);

    var w = this._w * scaleX;
    var h = this._h * scaleY;
    var appx = w * _mat4_tempm[0] * node._anchorPoint.x;
    var appy = h * _mat4_tempm[5] * node._anchorPoint.y;
    var tx = _mat4_tempm[12] * scaleX - appx + offsetX,
        ty = _mat4_tempm[13] * scaleY - appy + offsetY;
    var matrix = "matrix(" + a + "," + -b + "," + -c + "," + d + "," + tx + "," + -ty + ")";
    this._div.style['transform'] = matrix;
    this._div.style['-webkit-transform'] = matrix;
    this._div.style['transform-origin'] = '0px 100% 0px';
    this._div.style['-webkit-transform-origin'] = '0px 100% 0px'; // chagned iframe opacity

    this._setOpacity(node.opacity);

    this._forceUpdate = false;
  }
});
WebViewImpl.EventType = {
  LOADING: 0,
  LOADED: 1,
  ERROR: 2,
  JS_EVALUATED: 3
};
var polyfill = WebViewImpl._polyfill = {
  devicePixelRatio: false,
  enableDiv: false
};
if (sys.os === sys.OS_IOS) polyfill.enableDiv = true;

if (sys.isMobile) {
  if (sys.browserType === sys.BROWSER_TYPE_FIREFOX) {
    polyfill.enableBG = true;
  }
} else {
  if (sys.browserType === sys.BROWSER_TYPE_IE) {
    polyfill.closeHistory = true;
  }
}

module.exports = WebViewImpl;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC93ZWJ2aWV3L3dlYnZpZXctaW1wbC5qcyJdLCJuYW1lcyI6WyJ1dGlscyIsInJlcXVpcmUiLCJzeXMiLCJfbWF0NF90ZW1wIiwiY2MiLCJtYXQ0IiwiV2ViVmlld0ltcGwiLCJDbGFzcyIsIm5hbWUiLCJjdG9yIiwiX0V2ZW50TGlzdCIsIl92aXNpYmxlIiwiX3BhcmVudCIsIl9kaXYiLCJfaWZyYW1lIiwiX2xpc3RlbmVyIiwiX2ZvcmNlVXBkYXRlIiwiX20wMCIsIl9tMDEiLCJfbTA0IiwiX20wNSIsIl9tMTIiLCJfbTEzIiwiX3ciLCJfaCIsIl9fZXZlbnRMaXN0ZW5lcnMiLCJfdXBkYXRlVmlzaWJpbGl0eSIsImRpdiIsInN0eWxlIiwidmlzaWJpbGl0eSIsIl91cGRhdGVTaXplIiwidyIsImgiLCJ3aWR0aCIsImhlaWdodCIsIl9pbml0RXZlbnQiLCJpZnJhbWUiLCJjYnMiLCJzZWxmIiwibG9hZCIsIl9kaXNwYXRjaEV2ZW50IiwiRXZlbnRUeXBlIiwiTE9BREVEIiwiZXJyb3IiLCJFUlJPUiIsImFkZEV2ZW50TGlzdGVuZXIiLCJfaW5pdFN0eWxlIiwicG9zaXRpb24iLCJib3R0b20iLCJsZWZ0IiwiX3NldE9wYWNpdHkiLCJvcGFjaXR5IiwiX2NyZWF0ZURvbSIsIl9wb2x5ZmlsbCIsImVuYWJsZURpdiIsImRvY3VtZW50IiwiY3JlYXRlRWxlbWVudCIsImFwcGVuZENoaWxkIiwiZW5hYmxlQkciLCJvdmVyZmxvdyIsImJvcmRlciIsImdhbWUiLCJjb250YWluZXIiLCJfY3JlYXRlTmF0aXZlQ29udHJvbCIsImNyZWF0ZURvbUVsZW1lbnRJZk5lZWRlZCIsIkNDX0VESVRPUiIsImJhY2tncm91bmQiLCJjb2xvciIsInJlbW92ZURvbSIsImhhc0NoaWxkIiwiY29udGFpbnMiLCJyZW1vdmVDaGlsZCIsInJlbW92ZUV2ZW50TGlzdGVuZXIiLCJzZXRPbkpTQ2FsbGJhY2siLCJjYWxsYmFjayIsInNldEphdmFzY3JpcHRJbnRlcmZhY2VTY2hlbWUiLCJzY2hlbWUiLCJsb2FkRGF0YSIsImRhdGEiLCJNSU1FVHlwZSIsImVuY29kaW5nIiwiYmFzZVVSTCIsImxvYWRIVE1MU3RyaW5nIiwic3RyaW5nIiwibG9hZFVSTCIsInVybCIsImlubmVyVGV4dCIsInNyYyIsImNiIiwiX2xvYWRlZCIsIkxPQURJTkciLCJzdG9wTG9hZGluZyIsImxvZ0lEIiwicmVsb2FkIiwid2luIiwiY29udGVudFdpbmRvdyIsImxvY2F0aW9uIiwiY2FuR29CYWNrIiwiY2FuR29Gb3J3YXJkIiwiZ29CYWNrIiwiY2xvc2VIaXN0b3J5IiwiaGlzdG9yeSIsImJhY2siLCJjYWxsIiwiZXJyIiwibG9nIiwiZ29Gb3J3YXJkIiwiZm9yd2FyZCIsImV2YWx1YXRlSlMiLCJzdHIiLCJldmFsIiwiSlNfRVZBTFVBVEVEIiwiY29uc29sZSIsInNldFNjYWxlc1BhZ2VUb0ZpdCIsInNldEV2ZW50TGlzdGVuZXIiLCJldmVudCIsIl9jcmVhdGVSZW5kZXJDbWQiLCJSZW5kZXJDbWQiLCJkZXN0cm95Iiwic2V0VmlzaWJsZSIsInZpc2libGUiLCJ1cGRhdGVNYXRyaXgiLCJub2RlIiwiZ2V0V29ybGRNYXRyaXgiLCJyZW5kZXJDYW1lcmEiLCJDYW1lcmEiLCJfZmluZFJlbmRlcmVyQ2FtZXJhIiwid29ybGRNYXRyaXhUb1NjcmVlbiIsImNhbnZhcyIsIl9tYXQ0X3RlbXBtIiwibSIsIl9jb250ZW50U2l6ZSIsImRwciIsInZpZXciLCJfZGV2aWNlUGl4ZWxSYXRpbyIsInNjYWxlWCIsInNjYWxlWSIsImEiLCJiIiwiYyIsImQiLCJvZmZzZXRYIiwicGFkZGluZ0xlZnQiLCJwYXJzZUludCIsIm9mZnNldFkiLCJwYWRkaW5nQm90dG9tIiwiYXBweCIsIl9hbmNob3JQb2ludCIsIngiLCJhcHB5IiwieSIsInR4IiwidHkiLCJtYXRyaXgiLCJwb2x5ZmlsbCIsImRldmljZVBpeGVsUmF0aW8iLCJvcyIsIk9TX0lPUyIsImlzTW9iaWxlIiwiYnJvd3NlclR5cGUiLCJCUk9XU0VSX1RZUEVfRklSRUZPWCIsIkJST1dTRVJfVFlQRV9JRSIsIm1vZHVsZSIsImV4cG9ydHMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7QUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBeUJBLElBQU1BLEtBQUssR0FBR0MsT0FBTyxDQUFDLHdCQUFELENBQXJCOztBQUNBLElBQU1DLEdBQUcsR0FBR0QsT0FBTyxDQUFDLHdCQUFELENBQW5COztBQUVBLElBQUlFLFVBQVUsR0FBR0MsRUFBRSxDQUFDQyxJQUFILEVBQWpCOztBQUVBLElBQUlDLFdBQVcsR0FBR0YsRUFBRSxDQUFDRyxLQUFILENBQVM7QUFDdkJDLEVBQUFBLElBQUksRUFBRSxhQURpQjtBQUd2QkMsRUFBQUEsSUFIdUIsa0JBR2Y7QUFDSjtBQUNBLFNBQUtDLFVBQUwsR0FBa0IsRUFBbEI7QUFFQSxTQUFLQyxRQUFMLEdBQWdCLEtBQWhCO0FBQ0EsU0FBS0MsT0FBTCxHQUFlLElBQWY7QUFDQSxTQUFLQyxJQUFMLEdBQVksSUFBWjtBQUNBLFNBQUtDLE9BQUwsR0FBZSxJQUFmO0FBQ0EsU0FBS0MsU0FBTCxHQUFpQixJQUFqQjtBQUNBLFNBQUtDLFlBQUwsR0FBb0IsS0FBcEIsQ0FUSSxDQVdKOztBQUNBLFNBQUtDLElBQUwsR0FBWSxDQUFaO0FBQ0EsU0FBS0MsSUFBTCxHQUFZLENBQVo7QUFDQSxTQUFLQyxJQUFMLEdBQVksQ0FBWjtBQUNBLFNBQUtDLElBQUwsR0FBWSxDQUFaO0FBQ0EsU0FBS0MsSUFBTCxHQUFZLENBQVo7QUFDQSxTQUFLQyxJQUFMLEdBQVksQ0FBWjtBQUNBLFNBQUtDLEVBQUwsR0FBVSxDQUFWO0FBQ0EsU0FBS0MsRUFBTCxHQUFVLENBQVYsQ0FuQkksQ0FvQko7O0FBQ0EsU0FBS0MsZ0JBQUwsR0FBd0IsRUFBeEI7QUFDSCxHQXpCc0I7QUEyQnZCQyxFQUFBQSxpQkEzQnVCLCtCQTJCRjtBQUNqQixRQUFJLENBQUMsS0FBS2IsSUFBVixFQUFnQjtBQUNoQixRQUFJYyxHQUFHLEdBQUcsS0FBS2QsSUFBZjs7QUFDQSxRQUFJLEtBQUtGLFFBQVQsRUFBbUI7QUFDZmdCLE1BQUFBLEdBQUcsQ0FBQ0MsS0FBSixDQUFVQyxVQUFWLEdBQXVCLFNBQXZCO0FBQ0gsS0FGRCxNQUdLO0FBQ0RGLE1BQUFBLEdBQUcsQ0FBQ0MsS0FBSixDQUFVQyxVQUFWLEdBQXVCLFFBQXZCO0FBQ0g7QUFDSixHQXBDc0I7QUFzQ3ZCQyxFQUFBQSxXQXRDdUIsdUJBc0NWQyxDQXRDVSxFQXNDUEMsQ0F0Q08sRUFzQ0o7QUFDZixRQUFJTCxHQUFHLEdBQUcsS0FBS2QsSUFBZjs7QUFDQSxRQUFJYyxHQUFKLEVBQVM7QUFDTEEsTUFBQUEsR0FBRyxDQUFDQyxLQUFKLENBQVVLLEtBQVYsR0FBa0JGLENBQUMsR0FBRyxJQUF0QjtBQUNBSixNQUFBQSxHQUFHLENBQUNDLEtBQUosQ0FBVU0sTUFBVixHQUFtQkYsQ0FBQyxHQUFHLElBQXZCO0FBQ0g7QUFDSixHQTVDc0I7QUE4Q3ZCRyxFQUFBQSxVQTlDdUIsd0JBOENUO0FBQ1YsUUFBSUMsTUFBTSxHQUFHLEtBQUt0QixPQUFsQjs7QUFDQSxRQUFJc0IsTUFBSixFQUFZO0FBQ1IsVUFBSUMsR0FBRyxHQUFHLEtBQUtaLGdCQUFmO0FBQUEsVUFBaUNhLElBQUksR0FBRyxJQUF4Qzs7QUFDQUQsTUFBQUEsR0FBRyxDQUFDRSxJQUFKLEdBQVcsWUFBWTtBQUNuQkQsUUFBQUEsSUFBSSxDQUFDdEIsWUFBTCxHQUFvQixJQUFwQjs7QUFDQXNCLFFBQUFBLElBQUksQ0FBQ0UsY0FBTCxDQUFvQmxDLFdBQVcsQ0FBQ21DLFNBQVosQ0FBc0JDLE1BQTFDO0FBQ0gsT0FIRDs7QUFJQUwsTUFBQUEsR0FBRyxDQUFDTSxLQUFKLEdBQVksWUFBWTtBQUNwQkwsUUFBQUEsSUFBSSxDQUFDRSxjQUFMLENBQW9CbEMsV0FBVyxDQUFDbUMsU0FBWixDQUFzQkcsS0FBMUM7QUFDSCxPQUZEOztBQUdBUixNQUFBQSxNQUFNLENBQUNTLGdCQUFQLENBQXdCLE1BQXhCLEVBQWdDUixHQUFHLENBQUNFLElBQXBDO0FBQ0FILE1BQUFBLE1BQU0sQ0FBQ1MsZ0JBQVAsQ0FBd0IsT0FBeEIsRUFBaUNSLEdBQUcsQ0FBQ00sS0FBckM7QUFDSDtBQUNKLEdBNURzQjtBQThEdkJHLEVBQUFBLFVBOUR1Qix3QkE4RFQ7QUFDVixRQUFJLENBQUMsS0FBS2pDLElBQVYsRUFBZ0I7QUFDaEIsUUFBSWMsR0FBRyxHQUFHLEtBQUtkLElBQWY7QUFDQWMsSUFBQUEsR0FBRyxDQUFDQyxLQUFKLENBQVVtQixRQUFWLEdBQXFCLFVBQXJCO0FBQ0FwQixJQUFBQSxHQUFHLENBQUNDLEtBQUosQ0FBVW9CLE1BQVYsR0FBbUIsS0FBbkI7QUFDQXJCLElBQUFBLEdBQUcsQ0FBQ0MsS0FBSixDQUFVcUIsSUFBVixHQUFpQixLQUFqQjtBQUNILEdBcEVzQjtBQXNFdkJDLEVBQUFBLFdBdEV1Qix1QkFzRVZDLE9BdEVVLEVBc0VEO0FBQ2xCLFFBQUlmLE1BQU0sR0FBRyxLQUFLdEIsT0FBbEI7O0FBQ0EsUUFBSXNCLE1BQU0sSUFBSUEsTUFBTSxDQUFDUixLQUFyQixFQUE0QjtBQUN4QlEsTUFBQUEsTUFBTSxDQUFDUixLQUFQLENBQWF1QixPQUFiLEdBQXVCQSxPQUFPLEdBQUcsR0FBakM7QUFDSDtBQUNKLEdBM0VzQjtBQTZFdkJDLEVBQUFBLFVBN0V1QixzQkE2RVhyQixDQTdFVyxFQTZFUkMsQ0E3RVEsRUE2RUw7QUFDZCxRQUFJMUIsV0FBVyxDQUFDK0MsU0FBWixDQUFzQkMsU0FBMUIsRUFBcUM7QUFDakMsV0FBS3pDLElBQUwsR0FBWTBDLFFBQVEsQ0FBQ0MsYUFBVCxDQUF1QixLQUF2QixDQUFaO0FBQ0EsV0FBSzNDLElBQUwsQ0FBVWUsS0FBVixDQUFnQixrQkFBaEIsSUFBc0MsTUFBdEM7QUFDQSxXQUFLZixJQUFMLENBQVVlLEtBQVYsQ0FBZ0IsNEJBQWhCLElBQWdELE9BQWhEO0FBQ0EsV0FBS2QsT0FBTCxHQUFleUMsUUFBUSxDQUFDQyxhQUFULENBQXVCLFFBQXZCLENBQWY7O0FBQ0EsV0FBSzNDLElBQUwsQ0FBVTRDLFdBQVYsQ0FBc0IsS0FBSzNDLE9BQTNCOztBQUNBLFdBQUtBLE9BQUwsQ0FBYWMsS0FBYixDQUFtQkssS0FBbkIsR0FBMkIsTUFBM0I7QUFDQSxXQUFLbkIsT0FBTCxDQUFhYyxLQUFiLENBQW1CTSxNQUFuQixHQUE0QixNQUE1QjtBQUNILEtBUkQsTUFTSztBQUNELFdBQUtyQixJQUFMLEdBQVksS0FBS0MsT0FBTCxHQUFleUMsUUFBUSxDQUFDQyxhQUFULENBQXVCLFFBQXZCLENBQTNCO0FBQ0g7O0FBRUQsUUFBSWxELFdBQVcsQ0FBQytDLFNBQVosQ0FBc0JLLFFBQTFCLEVBQ0ksS0FBSzdDLElBQUwsQ0FBVWUsS0FBVixDQUFnQixZQUFoQixJQUFnQyxNQUFoQztBQUVKLFNBQUtmLElBQUwsQ0FBVWUsS0FBVixDQUFnQixZQUFoQixJQUFnQyxNQUFoQztBQUNBLFNBQUtmLElBQUwsQ0FBVWUsS0FBVixDQUFnQk0sTUFBaEIsR0FBeUJGLENBQUMsR0FBRyxJQUE3QjtBQUNBLFNBQUtuQixJQUFMLENBQVVlLEtBQVYsQ0FBZ0JLLEtBQWhCLEdBQXdCRixDQUFDLEdBQUcsSUFBNUI7QUFDQSxTQUFLbEIsSUFBTCxDQUFVZSxLQUFWLENBQWdCK0IsUUFBaEIsR0FBMkIsUUFBM0I7QUFDQSxTQUFLN0MsT0FBTCxDQUFhYyxLQUFiLENBQW1CZ0MsTUFBbkIsR0FBNEIsTUFBNUI7QUFFQXhELElBQUFBLEVBQUUsQ0FBQ3lELElBQUgsQ0FBUUMsU0FBUixDQUFrQkwsV0FBbEIsQ0FBOEIsS0FBSzVDLElBQW5DOztBQUNBLFNBQUthLGlCQUFMO0FBQ0gsR0F0R3NCO0FBd0d2QnFDLEVBQUFBLG9CQXhHdUIsZ0NBd0dEaEMsQ0F4R0MsRUF3R0VDLENBeEdGLEVBd0dLO0FBQ3hCLFNBQUtvQixVQUFMLENBQWdCckIsQ0FBaEIsRUFBbUJDLENBQW5COztBQUNBLFNBQUtjLFVBQUw7O0FBQ0EsU0FBS1gsVUFBTDtBQUNILEdBNUdzQjtBQThHdkI2QixFQUFBQSx3QkFBd0IsRUFBRUMsU0FBUyxHQUFHLFVBQVVsQyxDQUFWLEVBQWFDLENBQWIsRUFBZ0I7QUFDbEQsU0FBS25CLElBQUwsR0FBWTBDLFFBQVEsQ0FBQ0MsYUFBVCxDQUF1QixLQUF2QixDQUFaO0FBQ0EsU0FBSzNDLElBQUwsQ0FBVWUsS0FBVixDQUFnQnNDLFVBQWhCLEdBQTZCLDBCQUE3QjtBQUNBLFNBQUtyRCxJQUFMLENBQVVlLEtBQVYsQ0FBZ0J1QyxLQUFoQixHQUF3QixpQkFBeEI7QUFDQSxTQUFLdEQsSUFBTCxDQUFVZSxLQUFWLENBQWdCTSxNQUFoQixHQUF5QkgsQ0FBQyxHQUFHLElBQTdCO0FBQ0EsU0FBS2xCLElBQUwsQ0FBVWUsS0FBVixDQUFnQkssS0FBaEIsR0FBd0JELENBQUMsR0FBRyxJQUE1QjtBQUNBLFNBQUtuQixJQUFMLENBQVVlLEtBQVYsQ0FBZ0JtQixRQUFoQixHQUEyQixVQUEzQjtBQUNBLFNBQUtsQyxJQUFMLENBQVVlLEtBQVYsQ0FBZ0JvQixNQUFoQixHQUF5QixLQUF6QjtBQUNBLFNBQUtuQyxJQUFMLENBQVVlLEtBQVYsQ0FBZ0JxQixJQUFoQixHQUF1QixLQUF2QjtBQUNBLFNBQUtwQyxJQUFMLENBQVVlLEtBQVYsQ0FBZ0IsV0FBaEIsSUFBK0IsWUFBL0I7QUFDQXhCLElBQUFBLEVBQUUsQ0FBQ3lELElBQUgsQ0FBUUMsU0FBUixDQUFrQkwsV0FBbEIsQ0FBOEIsS0FBSzVDLElBQW5DO0FBQ0gsR0FYa0MsR0FXL0IsVUFBVWtCLENBQVYsRUFBYUMsQ0FBYixFQUFnQjtBQUNoQixRQUFJLENBQUMsS0FBS25CLElBQVYsRUFBZ0I7QUFDWixXQUFLa0Qsb0JBQUwsQ0FBMEJoQyxDQUExQixFQUE2QkMsQ0FBN0I7QUFDSCxLQUZELE1BR0s7QUFDRCxXQUFLRixXQUFMLENBQWlCQyxDQUFqQixFQUFvQkMsQ0FBcEI7QUFDSDtBQUNKLEdBaElzQjtBQWtJdkJvQyxFQUFBQSxTQWxJdUIsdUJBa0lWO0FBQ1QsUUFBSXpDLEdBQUcsR0FBRyxLQUFLZCxJQUFmOztBQUNBLFFBQUljLEdBQUosRUFBUztBQUNMLFVBQUkwQyxRQUFRLEdBQUdyRSxLQUFLLENBQUNzRSxRQUFOLENBQWVsRSxFQUFFLENBQUN5RCxJQUFILENBQVFDLFNBQXZCLEVBQWtDbkMsR0FBbEMsQ0FBZjtBQUNBLFVBQUkwQyxRQUFKLEVBQ0lqRSxFQUFFLENBQUN5RCxJQUFILENBQVFDLFNBQVIsQ0FBa0JTLFdBQWxCLENBQThCNUMsR0FBOUI7QUFFSixXQUFLZCxJQUFMLEdBQVksSUFBWjtBQUNIOztBQUNELFFBQUl1QixNQUFNLEdBQUcsS0FBS3RCLE9BQWxCOztBQUNBLFFBQUlzQixNQUFKLEVBQVk7QUFDUixVQUFJQyxHQUFHLEdBQUcsS0FBS1osZ0JBQWY7QUFDQVcsTUFBQUEsTUFBTSxDQUFDb0MsbUJBQVAsQ0FBMkIsTUFBM0IsRUFBbUNuQyxHQUFHLENBQUNFLElBQXZDO0FBQ0FILE1BQUFBLE1BQU0sQ0FBQ29DLG1CQUFQLENBQTJCLE9BQTNCLEVBQW9DbkMsR0FBRyxDQUFDTSxLQUF4QztBQUNBTixNQUFBQSxHQUFHLENBQUNFLElBQUosR0FBVyxJQUFYO0FBQ0FGLE1BQUFBLEdBQUcsQ0FBQ00sS0FBSixHQUFZLElBQVo7QUFDQSxXQUFLN0IsT0FBTCxHQUFlLElBQWY7QUFDSDtBQUNKLEdBcEpzQjtBQXNKdkIyRCxFQUFBQSxlQXRKdUIsMkJBc0pOQyxRQXRKTSxFQXNKSSxDQUFFLENBdEpOO0FBdUp2QkMsRUFBQUEsNEJBdkp1Qix3Q0F1Sk9DLE1BdkpQLEVBdUplLENBQUUsQ0F2SmpCO0FBd0p2QjtBQUNBQyxFQUFBQSxRQXpKdUIsb0JBeUpiQyxJQXpKYSxFQXlKUEMsUUF6Sk8sRUF5SkdDLFFBekpILEVBeUphQyxPQXpKYixFQXlKc0IsQ0FBRSxDQXpKeEI7QUEwSnZCQyxFQUFBQSxjQTFKdUIsMEJBMEpQQyxNQTFKTyxFQTBKQ0YsT0ExSkQsRUEwSlUsQ0FBRSxDQTFKWjs7QUE0SnZCOzs7O0FBSUFHLEVBQUFBLE9BQU8sRUFBRW5CLFNBQVMsR0FBRyxVQUFVb0IsR0FBVixFQUFlO0FBQ2hDLFNBQUt4RSxJQUFMLENBQVV5RSxTQUFWLEdBQXNCRCxHQUF0QjtBQUNILEdBRmlCLEdBRWQsVUFBVUEsR0FBVixFQUFlO0FBQ2YsUUFBSWpELE1BQU0sR0FBRyxLQUFLdEIsT0FBbEI7O0FBQ0EsUUFBSXNCLE1BQUosRUFBWTtBQUNSQSxNQUFBQSxNQUFNLENBQUNtRCxHQUFQLEdBQWFGLEdBQWI7QUFDQSxVQUFJL0MsSUFBSSxHQUFHLElBQVg7O0FBQ0EsVUFBSWtELEVBQUUsR0FBRyxTQUFMQSxFQUFLLEdBQVk7QUFDakJsRCxRQUFBQSxJQUFJLENBQUNtRCxPQUFMLEdBQWUsSUFBZjs7QUFDQW5ELFFBQUFBLElBQUksQ0FBQ1osaUJBQUw7O0FBQ0FVLFFBQUFBLE1BQU0sQ0FBQ29DLG1CQUFQLENBQTJCLE1BQTNCLEVBQW1DZ0IsRUFBbkM7QUFDSCxPQUpEOztBQUtBcEQsTUFBQUEsTUFBTSxDQUFDUyxnQkFBUCxDQUF3QixNQUF4QixFQUFnQzJDLEVBQWhDOztBQUNBLFdBQUtoRCxjQUFMLENBQW9CbEMsV0FBVyxDQUFDbUMsU0FBWixDQUFzQmlELE9BQTFDO0FBQ0g7QUFDSixHQS9Lc0I7O0FBaUx2Qjs7O0FBR0FDLEVBQUFBLFdBcEx1Qix5QkFvTFI7QUFDWHZGLElBQUFBLEVBQUUsQ0FBQ3dGLEtBQUgsQ0FBUyxJQUFUO0FBQ0gsR0F0THNCOztBQXdMdkI7OztBQUdBQyxFQUFBQSxNQTNMdUIsb0JBMkxiO0FBQ04sUUFBSXpELE1BQU0sR0FBRyxLQUFLdEIsT0FBbEI7O0FBQ0EsUUFBSXNCLE1BQUosRUFBWTtBQUNSLFVBQUkwRCxHQUFHLEdBQUcxRCxNQUFNLENBQUMyRCxhQUFqQjtBQUNBLFVBQUlELEdBQUcsSUFBSUEsR0FBRyxDQUFDRSxRQUFmLEVBQ0lGLEdBQUcsQ0FBQ0UsUUFBSixDQUFhSCxNQUFiO0FBQ1A7QUFDSixHQWxNc0I7O0FBb012Qjs7O0FBR0FJLEVBQUFBLFNBdk11Qix1QkF1TVY7QUFDVDdGLElBQUFBLEVBQUUsQ0FBQ3dGLEtBQUgsQ0FBUyxJQUFUO0FBQ0EsV0FBTyxJQUFQO0FBQ0gsR0ExTXNCOztBQTRNdkI7OztBQUdBTSxFQUFBQSxZQS9NdUIsMEJBK01QO0FBQ1o5RixJQUFBQSxFQUFFLENBQUN3RixLQUFILENBQVMsSUFBVDtBQUNBLFdBQU8sSUFBUDtBQUNILEdBbE5zQjs7QUFvTnZCOzs7QUFHQU8sRUFBQUEsTUF2TnVCLG9CQXVOYjtBQUNOLFFBQUk7QUFDQSxVQUFJN0YsV0FBVyxDQUFDK0MsU0FBWixDQUFzQitDLFlBQTFCLEVBQ0ksT0FBT2hHLEVBQUUsQ0FBQ3dGLEtBQUgsQ0FBUyxJQUFULENBQVA7QUFDSixVQUFJeEQsTUFBTSxHQUFHLEtBQUt0QixPQUFsQjs7QUFDQSxVQUFJc0IsTUFBSixFQUFZO0FBQ1IsWUFBSTBELEdBQUcsR0FBRzFELE1BQU0sQ0FBQzJELGFBQWpCO0FBQ0EsWUFBSUQsR0FBRyxJQUFJQSxHQUFHLENBQUNFLFFBQWYsRUFDSUYsR0FBRyxDQUFDTyxPQUFKLENBQVlDLElBQVosQ0FBaUJDLElBQWpCLENBQXNCVCxHQUF0QjtBQUNQO0FBQ0osS0FURCxDQVNFLE9BQU9VLEdBQVAsRUFBWTtBQUNWcEcsTUFBQUEsRUFBRSxDQUFDcUcsR0FBSCxDQUFPRCxHQUFQO0FBQ0g7QUFDSixHQXBPc0I7O0FBc092Qjs7O0FBR0FFLEVBQUFBLFNBek91Qix1QkF5T1Y7QUFDVCxRQUFJO0FBQ0EsVUFBSXBHLFdBQVcsQ0FBQytDLFNBQVosQ0FBc0IrQyxZQUExQixFQUNJLE9BQU9oRyxFQUFFLENBQUN3RixLQUFILENBQVMsSUFBVCxDQUFQO0FBQ0osVUFBSXhELE1BQU0sR0FBRyxLQUFLdEIsT0FBbEI7O0FBQ0EsVUFBSXNCLE1BQUosRUFBWTtBQUNSLFlBQUkwRCxHQUFHLEdBQUcxRCxNQUFNLENBQUMyRCxhQUFqQjtBQUNBLFlBQUlELEdBQUcsSUFBSUEsR0FBRyxDQUFDRSxRQUFmLEVBQ0lGLEdBQUcsQ0FBQ08sT0FBSixDQUFZTSxPQUFaLENBQW9CSixJQUFwQixDQUF5QlQsR0FBekI7QUFDUDtBQUNKLEtBVEQsQ0FTRSxPQUFPVSxHQUFQLEVBQVk7QUFDVnBHLE1BQUFBLEVBQUUsQ0FBQ3FHLEdBQUgsQ0FBT0QsR0FBUDtBQUNIO0FBQ0osR0F0UHNCOztBQXdQdkI7Ozs7QUFJQUksRUFBQUEsVUE1UHVCLHNCQTRQWEMsR0E1UFcsRUE0UE47QUFDYixRQUFJekUsTUFBTSxHQUFHLEtBQUt0QixPQUFsQjs7QUFDQSxRQUFJc0IsTUFBSixFQUFZO0FBQ1IsVUFBSTBELEdBQUcsR0FBRzFELE1BQU0sQ0FBQzJELGFBQWpCOztBQUNBLFVBQUk7QUFDQUQsUUFBQUEsR0FBRyxDQUFDZ0IsSUFBSixDQUFTRCxHQUFUOztBQUNBLGFBQUtyRSxjQUFMLENBQW9CbEMsV0FBVyxDQUFDbUMsU0FBWixDQUFzQnNFLFlBQTFDO0FBQ0gsT0FIRCxDQUdFLE9BQU9QLEdBQVAsRUFBWTtBQUNWUSxRQUFBQSxPQUFPLENBQUNyRSxLQUFSLENBQWM2RCxHQUFkO0FBQ0g7QUFDSjtBQUNKLEdBdlFzQjs7QUF5UXZCOzs7QUFHQVMsRUFBQUEsa0JBNVF1QixnQ0E0UUQ7QUFDbEI3RyxJQUFBQSxFQUFFLENBQUN3RixLQUFILENBQVMsSUFBVDtBQUNILEdBOVFzQjs7QUFnUnZCOzs7OztBQUtBc0IsRUFBQUEsZ0JBclJ1Qiw0QkFxUkxDLEtBclJLLEVBcVJFekMsUUFyUkYsRUFxUlk7QUFDL0IsU0FBS2hFLFVBQUwsQ0FBZ0J5RyxLQUFoQixJQUF5QnpDLFFBQXpCO0FBQ0gsR0F2UnNCOztBQXlSdkI7Ozs7QUFJQUYsRUFBQUEsbUJBN1J1QiwrQkE2UkYyQyxLQTdSRSxFQTZSSztBQUN4QixTQUFLekcsVUFBTCxDQUFnQnlHLEtBQWhCLElBQXlCLElBQXpCO0FBQ0gsR0EvUnNCO0FBaVN2QjNFLEVBQUFBLGNBalN1QiwwQkFpU1AyRSxLQWpTTyxFQWlTQTtBQUNuQixRQUFJekMsUUFBUSxHQUFHLEtBQUtoRSxVQUFMLENBQWdCeUcsS0FBaEIsQ0FBZjtBQUNBLFFBQUl6QyxRQUFKLEVBQ0lBLFFBQVEsQ0FBQzZCLElBQVQsQ0FBYyxJQUFkLEVBQW9CLElBQXBCLEVBQTBCLEtBQUt6RixPQUFMLENBQWF5RSxHQUF2QztBQUNQLEdBclNzQjtBQXVTdkI2QixFQUFBQSxnQkF2U3VCLDhCQXVTSDtBQUNoQixXQUFPLElBQUk5RyxXQUFXLENBQUMrRyxTQUFoQixDQUEwQixJQUExQixDQUFQO0FBQ0gsR0F6U3NCO0FBMlN2QkMsRUFBQUEsT0EzU3VCLHFCQTJTWjtBQUNQLFNBQUtsRCxTQUFMO0FBQ0gsR0E3U3NCO0FBK1N2Qm1ELEVBQUFBLFVBL1N1QixzQkErU1hDLE9BL1NXLEVBK1NGO0FBQ2pCLFFBQUksS0FBSzdHLFFBQUwsS0FBa0I2RyxPQUF0QixFQUErQjtBQUMzQixXQUFLN0csUUFBTCxHQUFnQixDQUFDLENBQUM2RyxPQUFsQjs7QUFDQSxXQUFLOUYsaUJBQUw7QUFDSDtBQUNKLEdBcFRzQjtBQXNUdkIrRixFQUFBQSxZQXRUdUIsd0JBc1RUQyxJQXRUUyxFQXNUSDtBQUNoQixRQUFJLENBQUMsS0FBSzdHLElBQU4sSUFBYyxDQUFDLEtBQUtGLFFBQXhCLEVBQWtDO0FBRWxDK0csSUFBQUEsSUFBSSxDQUFDQyxjQUFMLENBQW9CeEgsVUFBcEI7O0FBRUEsUUFBSXlILFlBQVksR0FBR3hILEVBQUUsQ0FBQ3lILE1BQUgsQ0FBVUMsbUJBQVYsQ0FBOEJKLElBQTlCLENBQW5COztBQUNBLFFBQUlFLFlBQUosRUFBa0I7QUFDZEEsTUFBQUEsWUFBWSxDQUFDRyxtQkFBYixDQUFpQzVILFVBQWpDLEVBQTZDQSxVQUE3QyxFQUF5REMsRUFBRSxDQUFDeUQsSUFBSCxDQUFRbUUsTUFBUixDQUFlL0YsS0FBeEUsRUFBK0U3QixFQUFFLENBQUN5RCxJQUFILENBQVFtRSxNQUFSLENBQWU5RixNQUE5RjtBQUNIOztBQUVELFFBQUkrRixXQUFXLEdBQUc5SCxVQUFVLENBQUMrSCxDQUE3Qjs7QUFDQSxRQUFJLENBQUMsS0FBS2xILFlBQU4sSUFDQSxLQUFLQyxJQUFMLEtBQWNnSCxXQUFXLENBQUMsQ0FBRCxDQUR6QixJQUNnQyxLQUFLL0csSUFBTCxLQUFjK0csV0FBVyxDQUFDLENBQUQsQ0FEekQsSUFFQSxLQUFLOUcsSUFBTCxLQUFjOEcsV0FBVyxDQUFDLENBQUQsQ0FGekIsSUFFZ0MsS0FBSzdHLElBQUwsS0FBYzZHLFdBQVcsQ0FBQyxDQUFELENBRnpELElBR0EsS0FBSzVHLElBQUwsS0FBYzRHLFdBQVcsQ0FBQyxFQUFELENBSHpCLElBR2lDLEtBQUszRyxJQUFMLEtBQWMyRyxXQUFXLENBQUMsRUFBRCxDQUgxRCxJQUlBLEtBQUsxRyxFQUFMLEtBQVltRyxJQUFJLENBQUNTLFlBQUwsQ0FBa0JsRyxLQUo5QixJQUl1QyxLQUFLVCxFQUFMLEtBQVlrRyxJQUFJLENBQUNTLFlBQUwsQ0FBa0JqRyxNQUp6RSxFQUlpRjtBQUM3RTtBQUNILEtBakJlLENBbUJoQjs7O0FBQ0EsU0FBS2pCLElBQUwsR0FBWWdILFdBQVcsQ0FBQyxDQUFELENBQXZCO0FBQ0EsU0FBSy9HLElBQUwsR0FBWStHLFdBQVcsQ0FBQyxDQUFELENBQXZCO0FBQ0EsU0FBSzlHLElBQUwsR0FBWThHLFdBQVcsQ0FBQyxDQUFELENBQXZCO0FBQ0EsU0FBSzdHLElBQUwsR0FBWTZHLFdBQVcsQ0FBQyxDQUFELENBQXZCO0FBQ0EsU0FBSzVHLElBQUwsR0FBWTRHLFdBQVcsQ0FBQyxFQUFELENBQXZCO0FBQ0EsU0FBSzNHLElBQUwsR0FBWTJHLFdBQVcsQ0FBQyxFQUFELENBQXZCO0FBQ0EsU0FBSzFHLEVBQUwsR0FBVW1HLElBQUksQ0FBQ1MsWUFBTCxDQUFrQmxHLEtBQTVCO0FBQ0EsU0FBS1QsRUFBTCxHQUFVa0csSUFBSSxDQUFDUyxZQUFMLENBQWtCakcsTUFBNUI7QUFFQSxRQUFJa0csR0FBRyxHQUFHaEksRUFBRSxDQUFDaUksSUFBSCxDQUFRQyxpQkFBbEI7QUFDQSxRQUFJQyxNQUFNLEdBQUcsSUFBSUgsR0FBakI7QUFDQSxRQUFJSSxNQUFNLEdBQUcsSUFBSUosR0FBakI7QUFFQSxRQUFJdEUsU0FBUyxHQUFHMUQsRUFBRSxDQUFDeUQsSUFBSCxDQUFRQyxTQUF4QjtBQUNBLFFBQUkyRSxDQUFDLEdBQUdSLFdBQVcsQ0FBQyxDQUFELENBQVgsR0FBaUJNLE1BQXpCO0FBQUEsUUFBaUNHLENBQUMsR0FBR1QsV0FBVyxDQUFDLENBQUQsQ0FBaEQ7QUFBQSxRQUFxRFUsQ0FBQyxHQUFHVixXQUFXLENBQUMsQ0FBRCxDQUFwRTtBQUFBLFFBQXlFVyxDQUFDLEdBQUdYLFdBQVcsQ0FBQyxDQUFELENBQVgsR0FBaUJPLE1BQTlGO0FBRUEsUUFBSUssT0FBTyxHQUFHL0UsU0FBUyxJQUFJQSxTQUFTLENBQUNsQyxLQUFWLENBQWdCa0gsV0FBN0IsR0FBMkNDLFFBQVEsQ0FBQ2pGLFNBQVMsQ0FBQ2xDLEtBQVYsQ0FBZ0JrSCxXQUFqQixDQUFuRCxHQUFtRixDQUFqRztBQUNBLFFBQUlFLE9BQU8sR0FBR2xGLFNBQVMsSUFBSUEsU0FBUyxDQUFDbEMsS0FBVixDQUFnQnFILGFBQTdCLEdBQTZDRixRQUFRLENBQUNqRixTQUFTLENBQUNsQyxLQUFWLENBQWdCcUgsYUFBakIsQ0FBckQsR0FBdUYsQ0FBckc7O0FBQ0EsU0FBS25ILFdBQUwsQ0FBaUIsS0FBS1AsRUFBdEIsRUFBMEIsS0FBS0MsRUFBL0I7O0FBQ0EsUUFBSU8sQ0FBQyxHQUFHLEtBQUtSLEVBQUwsR0FBVWdILE1BQWxCO0FBQ0EsUUFBSXZHLENBQUMsR0FBRyxLQUFLUixFQUFMLEdBQVVnSCxNQUFsQjtBQUVBLFFBQUlVLElBQUksR0FBSW5ILENBQUMsR0FBR2tHLFdBQVcsQ0FBQyxDQUFELENBQWhCLEdBQXVCUCxJQUFJLENBQUN5QixZQUFMLENBQWtCQyxDQUFwRDtBQUNBLFFBQUlDLElBQUksR0FBSXJILENBQUMsR0FBR2lHLFdBQVcsQ0FBQyxDQUFELENBQWhCLEdBQXVCUCxJQUFJLENBQUN5QixZQUFMLENBQWtCRyxDQUFwRDtBQUdBLFFBQUlDLEVBQUUsR0FBR3RCLFdBQVcsQ0FBQyxFQUFELENBQVgsR0FBa0JNLE1BQWxCLEdBQTJCVyxJQUEzQixHQUFrQ0wsT0FBM0M7QUFBQSxRQUFvRFcsRUFBRSxHQUFHdkIsV0FBVyxDQUFDLEVBQUQsQ0FBWCxHQUFrQk8sTUFBbEIsR0FBMkJhLElBQTNCLEdBQWtDTCxPQUEzRjtBQUVBLFFBQUlTLE1BQU0sR0FBRyxZQUFZaEIsQ0FBWixHQUFnQixHQUFoQixHQUFzQixDQUFDQyxDQUF2QixHQUEyQixHQUEzQixHQUFpQyxDQUFDQyxDQUFsQyxHQUFzQyxHQUF0QyxHQUE0Q0MsQ0FBNUMsR0FBZ0QsR0FBaEQsR0FBc0RXLEVBQXRELEdBQTJELEdBQTNELEdBQWlFLENBQUNDLEVBQWxFLEdBQXVFLEdBQXBGO0FBQ0EsU0FBSzNJLElBQUwsQ0FBVWUsS0FBVixDQUFnQixXQUFoQixJQUErQjZILE1BQS9CO0FBQ0EsU0FBSzVJLElBQUwsQ0FBVWUsS0FBVixDQUFnQixtQkFBaEIsSUFBdUM2SCxNQUF2QztBQUNBLFNBQUs1SSxJQUFMLENBQVVlLEtBQVYsQ0FBZ0Isa0JBQWhCLElBQXNDLGNBQXRDO0FBQ0EsU0FBS2YsSUFBTCxDQUFVZSxLQUFWLENBQWdCLDBCQUFoQixJQUE4QyxjQUE5QyxDQXBEZ0IsQ0FzRGhCOztBQUNBLFNBQUtzQixXQUFMLENBQWlCd0UsSUFBSSxDQUFDdkUsT0FBdEI7O0FBQ0EsU0FBS25DLFlBQUwsR0FBb0IsS0FBcEI7QUFDSDtBQS9Xc0IsQ0FBVCxDQUFsQjtBQWtYQVYsV0FBVyxDQUFDbUMsU0FBWixHQUF3QjtBQUNwQmlELEVBQUFBLE9BQU8sRUFBRSxDQURXO0FBRXBCaEQsRUFBQUEsTUFBTSxFQUFFLENBRlk7QUFHcEJFLEVBQUFBLEtBQUssRUFBRSxDQUhhO0FBSXBCbUUsRUFBQUEsWUFBWSxFQUFFO0FBSk0sQ0FBeEI7QUFPQSxJQUFJMkMsUUFBUSxHQUFHcEosV0FBVyxDQUFDK0MsU0FBWixHQUF3QjtBQUNuQ3NHLEVBQUFBLGdCQUFnQixFQUFFLEtBRGlCO0FBRW5DckcsRUFBQUEsU0FBUyxFQUFFO0FBRndCLENBQXZDO0FBS0EsSUFBSXBELEdBQUcsQ0FBQzBKLEVBQUosS0FBVzFKLEdBQUcsQ0FBQzJKLE1BQW5CLEVBQ0lILFFBQVEsQ0FBQ3BHLFNBQVQsR0FBcUIsSUFBckI7O0FBRUosSUFBSXBELEdBQUcsQ0FBQzRKLFFBQVIsRUFBa0I7QUFDZCxNQUFJNUosR0FBRyxDQUFDNkosV0FBSixLQUFvQjdKLEdBQUcsQ0FBQzhKLG9CQUE1QixFQUFrRDtBQUM5Q04sSUFBQUEsUUFBUSxDQUFDaEcsUUFBVCxHQUFvQixJQUFwQjtBQUNIO0FBQ0osQ0FKRCxNQUtLO0FBQ0QsTUFBSXhELEdBQUcsQ0FBQzZKLFdBQUosS0FBb0I3SixHQUFHLENBQUMrSixlQUE1QixFQUE2QztBQUN6Q1AsSUFBQUEsUUFBUSxDQUFDdEQsWUFBVCxHQUF3QixJQUF4QjtBQUNIO0FBQ0o7O0FBRUQ4RCxNQUFNLENBQUNDLE9BQVAsR0FBaUI3SixXQUFqQiIsInNvdXJjZXNDb250ZW50IjpbIi8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqXG4gQ29weXJpZ2h0IChjKSAyMDE3LTIwMTggWGlhbWVuIFlhamkgU29mdHdhcmUgQ28uLCBMdGQuXG5cbiBodHRwczovL3d3dy5jb2Nvcy5jb20vXG5cbiBQZXJtaXNzaW9uIGlzIGhlcmVieSBncmFudGVkLCBmcmVlIG9mIGNoYXJnZSwgdG8gYW55IHBlcnNvbiBvYnRhaW5pbmcgYSBjb3B5XG4gb2YgdGhpcyBzb2Z0d2FyZSBhbmQgYXNzb2NpYXRlZCBlbmdpbmUgc291cmNlIGNvZGUgKHRoZSBcIlNvZnR3YXJlXCIpLCBhIGxpbWl0ZWQsXG4gd29ybGR3aWRlLCByb3lhbHR5LWZyZWUsIG5vbi1hc3NpZ25hYmxlLCByZXZvY2FibGUgYW5kIG5vbi1leGNsdXNpdmUgbGljZW5zZVxuIHRvIHVzZSBDb2NvcyBDcmVhdG9yIHNvbGVseSB0byBkZXZlbG9wIGdhbWVzIG9uIHlvdXIgdGFyZ2V0IHBsYXRmb3Jtcy4gWW91IHNoYWxsXG4gbm90IHVzZSBDb2NvcyBDcmVhdG9yIHNvZnR3YXJlIGZvciBkZXZlbG9waW5nIG90aGVyIHNvZnR3YXJlIG9yIHRvb2xzIHRoYXQnc1xuIHVzZWQgZm9yIGRldmVsb3BpbmcgZ2FtZXMuIFlvdSBhcmUgbm90IGdyYW50ZWQgdG8gcHVibGlzaCwgZGlzdHJpYnV0ZSxcbiBzdWJsaWNlbnNlLCBhbmQvb3Igc2VsbCBjb3BpZXMgb2YgQ29jb3MgQ3JlYXRvci5cblxuIFRoZSBzb2Z0d2FyZSBvciB0b29scyBpbiB0aGlzIExpY2Vuc2UgQWdyZWVtZW50IGFyZSBsaWNlbnNlZCwgbm90IHNvbGQuXG4gWGlhbWVuIFlhamkgU29mdHdhcmUgQ28uLCBMdGQuIHJlc2VydmVzIGFsbCByaWdodHMgbm90IGV4cHJlc3NseSBncmFudGVkIHRvIHlvdS5cblxuIFRIRSBTT0ZUV0FSRSBJUyBQUk9WSURFRCBcIkFTIElTXCIsIFdJVEhPVVQgV0FSUkFOVFkgT0YgQU5ZIEtJTkQsIEVYUFJFU1MgT1JcbiBJTVBMSUVELCBJTkNMVURJTkcgQlVUIE5PVCBMSU1JVEVEIFRPIFRIRSBXQVJSQU5USUVTIE9GIE1FUkNIQU5UQUJJTElUWSxcbiBGSVRORVNTIEZPUiBBIFBBUlRJQ1VMQVIgUFVSUE9TRSBBTkQgTk9OSU5GUklOR0VNRU5ULiBJTiBOTyBFVkVOVCBTSEFMTCBUSEVcbiBBVVRIT1JTIE9SIENPUFlSSUdIVCBIT0xERVJTIEJFIExJQUJMRSBGT1IgQU5ZIENMQUlNLCBEQU1BR0VTIE9SIE9USEVSXG4gTElBQklMSVRZLCBXSEVUSEVSIElOIEFOIEFDVElPTiBPRiBDT05UUkFDVCwgVE9SVCBPUiBPVEhFUldJU0UsIEFSSVNJTkcgRlJPTSxcbiBPVVQgT0YgT1IgSU4gQ09OTkVDVElPTiBXSVRIIFRIRSBTT0ZUV0FSRSBPUiBUSEUgVVNFIE9SIE9USEVSIERFQUxJTkdTIElOXG4gVEhFIFNPRlRXQVJFLlxuICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiovXG5cbmNvbnN0IHV0aWxzID0gcmVxdWlyZSgnLi4vY29yZS9wbGF0Zm9ybS91dGlscycpO1xuY29uc3Qgc3lzID0gcmVxdWlyZSgnLi4vY29yZS9wbGF0Zm9ybS9DQ1N5cycpO1xuXG5sZXQgX21hdDRfdGVtcCA9IGNjLm1hdDQoKTtcblxubGV0IFdlYlZpZXdJbXBsID0gY2MuQ2xhc3Moe1xuICAgIG5hbWU6IFwiV2ViVmlld0ltcGxcIixcblxuICAgIGN0b3IgKCkge1xuICAgICAgICAvLyB0aGlzLnNldENvbnRlbnRTaXplKGNjLnNpemUoMzAwLCAyMDApKTtcbiAgICAgICAgdGhpcy5fRXZlbnRMaXN0ID0ge307XG5cbiAgICAgICAgdGhpcy5fdmlzaWJsZSA9IGZhbHNlO1xuICAgICAgICB0aGlzLl9wYXJlbnQgPSBudWxsO1xuICAgICAgICB0aGlzLl9kaXYgPSBudWxsO1xuICAgICAgICB0aGlzLl9pZnJhbWUgPSBudWxsO1xuICAgICAgICB0aGlzLl9saXN0ZW5lciA9IG51bGw7XG4gICAgICAgIHRoaXMuX2ZvcmNlVXBkYXRlID0gZmFsc2U7XG5cbiAgICAgICAgLy8gdXBkYXRlIG1hdHJpeCBjYWNoZVxuICAgICAgICB0aGlzLl9tMDAgPSAwO1xuICAgICAgICB0aGlzLl9tMDEgPSAwO1xuICAgICAgICB0aGlzLl9tMDQgPSAwO1xuICAgICAgICB0aGlzLl9tMDUgPSAwO1xuICAgICAgICB0aGlzLl9tMTIgPSAwO1xuICAgICAgICB0aGlzLl9tMTMgPSAwO1xuICAgICAgICB0aGlzLl93ID0gMDtcbiAgICAgICAgdGhpcy5faCA9IDA7XG4gICAgICAgIC8vXG4gICAgICAgIHRoaXMuX19ldmVudExpc3RlbmVycyA9IHt9O1xuICAgIH0sXG5cbiAgICBfdXBkYXRlVmlzaWJpbGl0eSAoKSB7XG4gICAgICAgIGlmICghdGhpcy5fZGl2KSByZXR1cm47XG4gICAgICAgIGxldCBkaXYgPSB0aGlzLl9kaXY7XG4gICAgICAgIGlmICh0aGlzLl92aXNpYmxlKSB7XG4gICAgICAgICAgICBkaXYuc3R5bGUudmlzaWJpbGl0eSA9ICd2aXNpYmxlJztcbiAgICAgICAgfVxuICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgIGRpdi5zdHlsZS52aXNpYmlsaXR5ID0gJ2hpZGRlbic7XG4gICAgICAgIH1cbiAgICB9LFxuXG4gICAgX3VwZGF0ZVNpemUgKHcsIGgpIHtcbiAgICAgICAgbGV0IGRpdiA9IHRoaXMuX2RpdjtcbiAgICAgICAgaWYgKGRpdikge1xuICAgICAgICAgICAgZGl2LnN0eWxlLndpZHRoID0gdyArIFwicHhcIjtcbiAgICAgICAgICAgIGRpdi5zdHlsZS5oZWlnaHQgPSBoICsgXCJweFwiO1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIF9pbml0RXZlbnQgKCkge1xuICAgICAgICBsZXQgaWZyYW1lID0gdGhpcy5faWZyYW1lO1xuICAgICAgICBpZiAoaWZyYW1lKSB7XG4gICAgICAgICAgICBsZXQgY2JzID0gdGhpcy5fX2V2ZW50TGlzdGVuZXJzLCBzZWxmID0gdGhpcztcbiAgICAgICAgICAgIGNicy5sb2FkID0gZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgICAgIHNlbGYuX2ZvcmNlVXBkYXRlID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICBzZWxmLl9kaXNwYXRjaEV2ZW50KFdlYlZpZXdJbXBsLkV2ZW50VHlwZS5MT0FERUQpO1xuICAgICAgICAgICAgfTtcbiAgICAgICAgICAgIGNicy5lcnJvciA9IGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgICAgICBzZWxmLl9kaXNwYXRjaEV2ZW50KFdlYlZpZXdJbXBsLkV2ZW50VHlwZS5FUlJPUik7XG4gICAgICAgICAgICB9O1xuICAgICAgICAgICAgaWZyYW1lLmFkZEV2ZW50TGlzdGVuZXIoXCJsb2FkXCIsIGNicy5sb2FkKTtcbiAgICAgICAgICAgIGlmcmFtZS5hZGRFdmVudExpc3RlbmVyKFwiZXJyb3JcIiwgY2JzLmVycm9yKTtcbiAgICAgICAgfVxuICAgIH0sXG5cbiAgICBfaW5pdFN0eWxlICgpIHtcbiAgICAgICAgaWYgKCF0aGlzLl9kaXYpIHJldHVybjtcbiAgICAgICAgbGV0IGRpdiA9IHRoaXMuX2RpdjtcbiAgICAgICAgZGl2LnN0eWxlLnBvc2l0aW9uID0gXCJhYnNvbHV0ZVwiO1xuICAgICAgICBkaXYuc3R5bGUuYm90dG9tID0gXCIwcHhcIjtcbiAgICAgICAgZGl2LnN0eWxlLmxlZnQgPSBcIjBweFwiO1xuICAgIH0sXG5cbiAgICBfc2V0T3BhY2l0eSAob3BhY2l0eSkge1xuICAgICAgICBsZXQgaWZyYW1lID0gdGhpcy5faWZyYW1lO1xuICAgICAgICBpZiAoaWZyYW1lICYmIGlmcmFtZS5zdHlsZSkge1xuICAgICAgICAgICAgaWZyYW1lLnN0eWxlLm9wYWNpdHkgPSBvcGFjaXR5IC8gMjU1O1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIF9jcmVhdGVEb20gKHcsIGgpIHtcbiAgICAgICAgaWYgKFdlYlZpZXdJbXBsLl9wb2x5ZmlsbC5lbmFibGVEaXYpIHtcbiAgICAgICAgICAgIHRoaXMuX2RpdiA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoXCJkaXZcIik7XG4gICAgICAgICAgICB0aGlzLl9kaXYuc3R5bGVbXCItd2Via2l0LW92ZXJmbG93XCJdID0gXCJhdXRvXCI7XG4gICAgICAgICAgICB0aGlzLl9kaXYuc3R5bGVbXCItd2Via2l0LW92ZXJmbG93LXNjcm9sbGluZ1wiXSA9IFwidG91Y2hcIjtcbiAgICAgICAgICAgIHRoaXMuX2lmcmFtZSA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoXCJpZnJhbWVcIik7XG4gICAgICAgICAgICB0aGlzLl9kaXYuYXBwZW5kQ2hpbGQodGhpcy5faWZyYW1lKTtcbiAgICAgICAgICAgIHRoaXMuX2lmcmFtZS5zdHlsZS53aWR0aCA9IFwiMTAwJVwiO1xuICAgICAgICAgICAgdGhpcy5faWZyYW1lLnN0eWxlLmhlaWdodCA9IFwiMTAwJVwiO1xuICAgICAgICB9XG4gICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgdGhpcy5fZGl2ID0gdGhpcy5faWZyYW1lID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudChcImlmcmFtZVwiKTtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmIChXZWJWaWV3SW1wbC5fcG9seWZpbGwuZW5hYmxlQkcpXG4gICAgICAgICAgICB0aGlzLl9kaXYuc3R5bGVbXCJiYWNrZ3JvdW5kXCJdID0gXCIjRkZGXCI7XG5cbiAgICAgICAgdGhpcy5fZGl2LnN0eWxlW1wiYmFja2dyb3VuZFwiXSA9IFwiI0ZGRlwiO1xuICAgICAgICB0aGlzLl9kaXYuc3R5bGUuaGVpZ2h0ID0gaCArIFwicHhcIjtcbiAgICAgICAgdGhpcy5fZGl2LnN0eWxlLndpZHRoID0gdyArIFwicHhcIjtcbiAgICAgICAgdGhpcy5fZGl2LnN0eWxlLm92ZXJmbG93ID0gXCJzY3JvbGxcIjtcbiAgICAgICAgdGhpcy5faWZyYW1lLnN0eWxlLmJvcmRlciA9IFwibm9uZVwiO1xuXG4gICAgICAgIGNjLmdhbWUuY29udGFpbmVyLmFwcGVuZENoaWxkKHRoaXMuX2Rpdik7XG4gICAgICAgIHRoaXMuX3VwZGF0ZVZpc2liaWxpdHkoKTtcbiAgICB9LFxuXG4gICAgX2NyZWF0ZU5hdGl2ZUNvbnRyb2wgKHcsIGgpIHtcbiAgICAgICAgdGhpcy5fY3JlYXRlRG9tKHcsIGgpO1xuICAgICAgICB0aGlzLl9pbml0U3R5bGUoKTtcbiAgICAgICAgdGhpcy5faW5pdEV2ZW50KCk7XG4gICAgfSxcblxuICAgIGNyZWF0ZURvbUVsZW1lbnRJZk5lZWRlZDogQ0NfRURJVE9SID8gZnVuY3Rpb24gKHcsIGgpIHtcbiAgICAgICAgdGhpcy5fZGl2ID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZGl2Jyk7XG4gICAgICAgIHRoaXMuX2Rpdi5zdHlsZS5iYWNrZ3JvdW5kID0gJ3JnYmEoMjU1LCAyNTUsIDI1NSwgMC44KSc7XG4gICAgICAgIHRoaXMuX2Rpdi5zdHlsZS5jb2xvciA9ICdyZ2IoNTEsIDUxLCA1MSknO1xuICAgICAgICB0aGlzLl9kaXYuc3R5bGUuaGVpZ2h0ID0gdyArICdweCc7XG4gICAgICAgIHRoaXMuX2Rpdi5zdHlsZS53aWR0aCA9IGggKyAncHgnO1xuICAgICAgICB0aGlzLl9kaXYuc3R5bGUucG9zaXRpb24gPSAnYWJzb2x1dGUnO1xuICAgICAgICB0aGlzLl9kaXYuc3R5bGUuYm90dG9tID0gJzBweCc7XG4gICAgICAgIHRoaXMuX2Rpdi5zdHlsZS5sZWZ0ID0gJzBweCc7XG4gICAgICAgIHRoaXMuX2Rpdi5zdHlsZVsnd29yZC13cmFwJ10gPSAnYnJlYWstd29yZCc7XG4gICAgICAgIGNjLmdhbWUuY29udGFpbmVyLmFwcGVuZENoaWxkKHRoaXMuX2Rpdik7XG4gICAgfSA6IGZ1bmN0aW9uICh3LCBoKSB7XG4gICAgICAgIGlmICghdGhpcy5fZGl2KSB7XG4gICAgICAgICAgICB0aGlzLl9jcmVhdGVOYXRpdmVDb250cm9sKHcsIGgpO1xuICAgICAgICB9XG4gICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgdGhpcy5fdXBkYXRlU2l6ZSh3LCBoKTtcbiAgICAgICAgfVxuICAgIH0sXG5cbiAgICByZW1vdmVEb20gKCkge1xuICAgICAgICBsZXQgZGl2ID0gdGhpcy5fZGl2O1xuICAgICAgICBpZiAoZGl2KSB7XG4gICAgICAgICAgICBsZXQgaGFzQ2hpbGQgPSB1dGlscy5jb250YWlucyhjYy5nYW1lLmNvbnRhaW5lciwgZGl2KTtcbiAgICAgICAgICAgIGlmIChoYXNDaGlsZClcbiAgICAgICAgICAgICAgICBjYy5nYW1lLmNvbnRhaW5lci5yZW1vdmVDaGlsZChkaXYpO1xuXG4gICAgICAgICAgICB0aGlzLl9kaXYgPSBudWxsO1xuICAgICAgICB9XG4gICAgICAgIGxldCBpZnJhbWUgPSB0aGlzLl9pZnJhbWU7XG4gICAgICAgIGlmIChpZnJhbWUpIHtcbiAgICAgICAgICAgIGxldCBjYnMgPSB0aGlzLl9fZXZlbnRMaXN0ZW5lcnM7XG4gICAgICAgICAgICBpZnJhbWUucmVtb3ZlRXZlbnRMaXN0ZW5lcihcImxvYWRcIiwgY2JzLmxvYWQpO1xuICAgICAgICAgICAgaWZyYW1lLnJlbW92ZUV2ZW50TGlzdGVuZXIoXCJlcnJvclwiLCBjYnMuZXJyb3IpO1xuICAgICAgICAgICAgY2JzLmxvYWQgPSBudWxsO1xuICAgICAgICAgICAgY2JzLmVycm9yID0gbnVsbDtcbiAgICAgICAgICAgIHRoaXMuX2lmcmFtZSA9IG51bGw7XG4gICAgICAgIH1cbiAgICB9LFxuXG4gICAgc2V0T25KU0NhbGxiYWNrIChjYWxsYmFjaykge30sXG4gICAgc2V0SmF2YXNjcmlwdEludGVyZmFjZVNjaGVtZSAoc2NoZW1lKSB7fSxcbiAgICAvLyBwcml2YXRlIG1ldGhvZFxuICAgIGxvYWREYXRhIChkYXRhLCBNSU1FVHlwZSwgZW5jb2RpbmcsIGJhc2VVUkwpIHt9LFxuICAgIGxvYWRIVE1MU3RyaW5nIChzdHJpbmcsIGJhc2VVUkwpIHt9LFxuXG4gICAgLyoqXG4gICAgICogTG9hZCBhbiBVUkxcbiAgICAgKiBAcGFyYW0ge1N0cmluZ30gdXJsXG4gICAgICovXG4gICAgbG9hZFVSTDogQ0NfRURJVE9SID8gZnVuY3Rpb24gKHVybCkge1xuICAgICAgICB0aGlzLl9kaXYuaW5uZXJUZXh0ID0gdXJsO1xuICAgIH0gOiBmdW5jdGlvbiAodXJsKSB7XG4gICAgICAgIGxldCBpZnJhbWUgPSB0aGlzLl9pZnJhbWU7XG4gICAgICAgIGlmIChpZnJhbWUpIHtcbiAgICAgICAgICAgIGlmcmFtZS5zcmMgPSB1cmw7XG4gICAgICAgICAgICBsZXQgc2VsZiA9IHRoaXM7XG4gICAgICAgICAgICBsZXQgY2IgPSBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICAgICAgc2VsZi5fbG9hZGVkID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICBzZWxmLl91cGRhdGVWaXNpYmlsaXR5KCk7XG4gICAgICAgICAgICAgICAgaWZyYW1lLnJlbW92ZUV2ZW50TGlzdGVuZXIoXCJsb2FkXCIsIGNiKTtcbiAgICAgICAgICAgIH07XG4gICAgICAgICAgICBpZnJhbWUuYWRkRXZlbnRMaXN0ZW5lcihcImxvYWRcIiwgY2IpO1xuICAgICAgICAgICAgdGhpcy5fZGlzcGF0Y2hFdmVudChXZWJWaWV3SW1wbC5FdmVudFR5cGUuTE9BRElORyk7XG4gICAgICAgIH1cbiAgICB9LFxuXG4gICAgLyoqXG4gICAgICogU3RvcCBsb2FkaW5nXG4gICAgICovXG4gICAgc3RvcExvYWRpbmcgKCkge1xuICAgICAgICBjYy5sb2dJRCg3ODAwKTtcbiAgICB9LFxuXG4gICAgLyoqXG4gICAgICogUmVsb2FkIHRoZSBXZWJWaWV3XG4gICAgICovXG4gICAgcmVsb2FkICgpIHtcbiAgICAgICAgbGV0IGlmcmFtZSA9IHRoaXMuX2lmcmFtZTtcbiAgICAgICAgaWYgKGlmcmFtZSkge1xuICAgICAgICAgICAgbGV0IHdpbiA9IGlmcmFtZS5jb250ZW50V2luZG93O1xuICAgICAgICAgICAgaWYgKHdpbiAmJiB3aW4ubG9jYXRpb24pXG4gICAgICAgICAgICAgICAgd2luLmxvY2F0aW9uLnJlbG9hZCgpO1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqIERldGVybWluZSB3aGV0aGVyIHRvIGdvIGJhY2tcbiAgICAgKi9cbiAgICBjYW5Hb0JhY2sgKCkge1xuICAgICAgICBjYy5sb2dJRCg3ODAxKTtcbiAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqIERldGVybWluZSB3aGV0aGVyIHRvIGdvIGZvcndhcmRcbiAgICAgKi9cbiAgICBjYW5Hb0ZvcndhcmQgKCkge1xuICAgICAgICBjYy5sb2dJRCg3ODAyKTtcbiAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqIGdvIGJhY2tcbiAgICAgKi9cbiAgICBnb0JhY2sgKCkge1xuICAgICAgICB0cnkge1xuICAgICAgICAgICAgaWYgKFdlYlZpZXdJbXBsLl9wb2x5ZmlsbC5jbG9zZUhpc3RvcnkpXG4gICAgICAgICAgICAgICAgcmV0dXJuIGNjLmxvZ0lEKDc4MDMpO1xuICAgICAgICAgICAgbGV0IGlmcmFtZSA9IHRoaXMuX2lmcmFtZTtcbiAgICAgICAgICAgIGlmIChpZnJhbWUpIHtcbiAgICAgICAgICAgICAgICBsZXQgd2luID0gaWZyYW1lLmNvbnRlbnRXaW5kb3c7XG4gICAgICAgICAgICAgICAgaWYgKHdpbiAmJiB3aW4ubG9jYXRpb24pXG4gICAgICAgICAgICAgICAgICAgIHdpbi5oaXN0b3J5LmJhY2suY2FsbCh3aW4pO1xuICAgICAgICAgICAgfVxuICAgICAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgICAgICAgIGNjLmxvZyhlcnIpO1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqIGdvIGZvcndhcmRcbiAgICAgKi9cbiAgICBnb0ZvcndhcmQgKCkge1xuICAgICAgICB0cnkge1xuICAgICAgICAgICAgaWYgKFdlYlZpZXdJbXBsLl9wb2x5ZmlsbC5jbG9zZUhpc3RvcnkpXG4gICAgICAgICAgICAgICAgcmV0dXJuIGNjLmxvZ0lEKDc4MDQpO1xuICAgICAgICAgICAgbGV0IGlmcmFtZSA9IHRoaXMuX2lmcmFtZTtcbiAgICAgICAgICAgIGlmIChpZnJhbWUpIHtcbiAgICAgICAgICAgICAgICBsZXQgd2luID0gaWZyYW1lLmNvbnRlbnRXaW5kb3c7XG4gICAgICAgICAgICAgICAgaWYgKHdpbiAmJiB3aW4ubG9jYXRpb24pXG4gICAgICAgICAgICAgICAgICAgIHdpbi5oaXN0b3J5LmZvcndhcmQuY2FsbCh3aW4pO1xuICAgICAgICAgICAgfVxuICAgICAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgICAgICAgIGNjLmxvZyhlcnIpO1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqIEluIHRoZSB3ZWJ2aWV3IGV4ZWN1dGlvbiB3aXRoaW4gYSBwZXJpb2Qgb2YganMgc3RyaW5nXG4gICAgICogQHBhcmFtIHtTdHJpbmd9IHN0clxuICAgICAqL1xuICAgIGV2YWx1YXRlSlMgKHN0cikge1xuICAgICAgICBsZXQgaWZyYW1lID0gdGhpcy5faWZyYW1lO1xuICAgICAgICBpZiAoaWZyYW1lKSB7XG4gICAgICAgICAgICBsZXQgd2luID0gaWZyYW1lLmNvbnRlbnRXaW5kb3c7XG4gICAgICAgICAgICB0cnkge1xuICAgICAgICAgICAgICAgIHdpbi5ldmFsKHN0cik7XG4gICAgICAgICAgICAgICAgdGhpcy5fZGlzcGF0Y2hFdmVudChXZWJWaWV3SW1wbC5FdmVudFR5cGUuSlNfRVZBTFVBVEVEKTtcbiAgICAgICAgICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgICAgICAgICAgIGNvbnNvbGUuZXJyb3IoZXJyKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH0sXG5cbiAgICAvKipcbiAgICAgKiBMaW1pdGVkIHNjYWxlXG4gICAgICovXG4gICAgc2V0U2NhbGVzUGFnZVRvRml0ICgpIHtcbiAgICAgICAgY2MubG9nSUQoNzgwNSk7XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqIFRoZSBiaW5kaW5nIGV2ZW50XG4gICAgICogQHBhcmFtIHtXZWJWaWV3SW1wbC5FdmVudFR5cGV9IGV2ZW50XG4gICAgICogQHBhcmFtIHtGdW5jdGlvbn0gY2FsbGJhY2tcbiAgICAgKi9cbiAgICBzZXRFdmVudExpc3RlbmVyIChldmVudCwgY2FsbGJhY2spIHtcbiAgICAgICAgdGhpcy5fRXZlbnRMaXN0W2V2ZW50XSA9IGNhbGxiYWNrO1xuICAgIH0sXG5cbiAgICAvKipcbiAgICAgKiBEZWxldGUgZXZlbnRzXG4gICAgICogQHBhcmFtIHtXZWJWaWV3SW1wbC5FdmVudFR5cGV9IGV2ZW50XG4gICAgICovXG4gICAgcmVtb3ZlRXZlbnRMaXN0ZW5lciAoZXZlbnQpIHtcbiAgICAgICAgdGhpcy5fRXZlbnRMaXN0W2V2ZW50XSA9IG51bGw7XG4gICAgfSxcblxuICAgIF9kaXNwYXRjaEV2ZW50IChldmVudCkge1xuICAgICAgICBsZXQgY2FsbGJhY2sgPSB0aGlzLl9FdmVudExpc3RbZXZlbnRdO1xuICAgICAgICBpZiAoY2FsbGJhY2spXG4gICAgICAgICAgICBjYWxsYmFjay5jYWxsKHRoaXMsIHRoaXMsIHRoaXMuX2lmcmFtZS5zcmMpO1xuICAgIH0sXG5cbiAgICBfY3JlYXRlUmVuZGVyQ21kICgpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBXZWJWaWV3SW1wbC5SZW5kZXJDbWQodGhpcyk7XG4gICAgfSxcblxuICAgIGRlc3Ryb3kgKCkge1xuICAgICAgICB0aGlzLnJlbW92ZURvbSgpO1xuICAgIH0sXG5cbiAgICBzZXRWaXNpYmxlICh2aXNpYmxlKSB7XG4gICAgICAgIGlmICh0aGlzLl92aXNpYmxlICE9PSB2aXNpYmxlKSB7XG4gICAgICAgICAgICB0aGlzLl92aXNpYmxlID0gISF2aXNpYmxlO1xuICAgICAgICAgICAgdGhpcy5fdXBkYXRlVmlzaWJpbGl0eSgpO1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIHVwZGF0ZU1hdHJpeCAobm9kZSkge1xuICAgICAgICBpZiAoIXRoaXMuX2RpdiB8fCAhdGhpcy5fdmlzaWJsZSkgcmV0dXJuO1xuXG4gICAgICAgIG5vZGUuZ2V0V29ybGRNYXRyaXgoX21hdDRfdGVtcCk7XG5cbiAgICAgICAgbGV0IHJlbmRlckNhbWVyYSA9IGNjLkNhbWVyYS5fZmluZFJlbmRlcmVyQ2FtZXJhKG5vZGUpO1xuICAgICAgICBpZiAocmVuZGVyQ2FtZXJhKSB7XG4gICAgICAgICAgICByZW5kZXJDYW1lcmEud29ybGRNYXRyaXhUb1NjcmVlbihfbWF0NF90ZW1wLCBfbWF0NF90ZW1wLCBjYy5nYW1lLmNhbnZhcy53aWR0aCwgY2MuZ2FtZS5jYW52YXMuaGVpZ2h0KTtcbiAgICAgICAgfVxuXG4gICAgICAgIGxldCBfbWF0NF90ZW1wbSA9IF9tYXQ0X3RlbXAubTtcbiAgICAgICAgaWYgKCF0aGlzLl9mb3JjZVVwZGF0ZSAmJlxuICAgICAgICAgICAgdGhpcy5fbTAwID09PSBfbWF0NF90ZW1wbVswXSAmJiB0aGlzLl9tMDEgPT09IF9tYXQ0X3RlbXBtWzFdICYmXG4gICAgICAgICAgICB0aGlzLl9tMDQgPT09IF9tYXQ0X3RlbXBtWzRdICYmIHRoaXMuX20wNSA9PT0gX21hdDRfdGVtcG1bNV0gJiZcbiAgICAgICAgICAgIHRoaXMuX20xMiA9PT0gX21hdDRfdGVtcG1bMTJdICYmIHRoaXMuX20xMyA9PT0gX21hdDRfdGVtcG1bMTNdICYmXG4gICAgICAgICAgICB0aGlzLl93ID09PSBub2RlLl9jb250ZW50U2l6ZS53aWR0aCAmJiB0aGlzLl9oID09PSBub2RlLl9jb250ZW50U2l6ZS5oZWlnaHQpIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIC8vIHVwZGF0ZSBtYXRyaXggY2FjaGVcbiAgICAgICAgdGhpcy5fbTAwID0gX21hdDRfdGVtcG1bMF07XG4gICAgICAgIHRoaXMuX20wMSA9IF9tYXQ0X3RlbXBtWzFdO1xuICAgICAgICB0aGlzLl9tMDQgPSBfbWF0NF90ZW1wbVs0XTtcbiAgICAgICAgdGhpcy5fbTA1ID0gX21hdDRfdGVtcG1bNV07XG4gICAgICAgIHRoaXMuX20xMiA9IF9tYXQ0X3RlbXBtWzEyXTtcbiAgICAgICAgdGhpcy5fbTEzID0gX21hdDRfdGVtcG1bMTNdO1xuICAgICAgICB0aGlzLl93ID0gbm9kZS5fY29udGVudFNpemUud2lkdGg7XG4gICAgICAgIHRoaXMuX2ggPSBub2RlLl9jb250ZW50U2l6ZS5oZWlnaHQ7XG5cbiAgICAgICAgbGV0IGRwciA9IGNjLnZpZXcuX2RldmljZVBpeGVsUmF0aW87XG4gICAgICAgIGxldCBzY2FsZVggPSAxIC8gZHByO1xuICAgICAgICBsZXQgc2NhbGVZID0gMSAvIGRwcjtcblxuICAgICAgICBsZXQgY29udGFpbmVyID0gY2MuZ2FtZS5jb250YWluZXI7XG4gICAgICAgIGxldCBhID0gX21hdDRfdGVtcG1bMF0gKiBzY2FsZVgsIGIgPSBfbWF0NF90ZW1wbVsxXSwgYyA9IF9tYXQ0X3RlbXBtWzRdLCBkID0gX21hdDRfdGVtcG1bNV0gKiBzY2FsZVk7XG5cbiAgICAgICAgbGV0IG9mZnNldFggPSBjb250YWluZXIgJiYgY29udGFpbmVyLnN0eWxlLnBhZGRpbmdMZWZ0ID8gcGFyc2VJbnQoY29udGFpbmVyLnN0eWxlLnBhZGRpbmdMZWZ0KSA6IDA7XG4gICAgICAgIGxldCBvZmZzZXRZID0gY29udGFpbmVyICYmIGNvbnRhaW5lci5zdHlsZS5wYWRkaW5nQm90dG9tID8gcGFyc2VJbnQoY29udGFpbmVyLnN0eWxlLnBhZGRpbmdCb3R0b20pIDogMDtcbiAgICAgICAgdGhpcy5fdXBkYXRlU2l6ZSh0aGlzLl93LCB0aGlzLl9oKTtcbiAgICAgICAgbGV0IHcgPSB0aGlzLl93ICogc2NhbGVYO1xuICAgICAgICBsZXQgaCA9IHRoaXMuX2ggKiBzY2FsZVk7XG5cbiAgICAgICAgbGV0IGFwcHggPSAodyAqIF9tYXQ0X3RlbXBtWzBdKSAqIG5vZGUuX2FuY2hvclBvaW50Lng7XG4gICAgICAgIGxldCBhcHB5ID0gKGggKiBfbWF0NF90ZW1wbVs1XSkgKiBub2RlLl9hbmNob3JQb2ludC55O1xuXG5cbiAgICAgICAgbGV0IHR4ID0gX21hdDRfdGVtcG1bMTJdICogc2NhbGVYIC0gYXBweCArIG9mZnNldFgsIHR5ID0gX21hdDRfdGVtcG1bMTNdICogc2NhbGVZIC0gYXBweSArIG9mZnNldFk7XG5cbiAgICAgICAgbGV0IG1hdHJpeCA9IFwibWF0cml4KFwiICsgYSArIFwiLFwiICsgLWIgKyBcIixcIiArIC1jICsgXCIsXCIgKyBkICsgXCIsXCIgKyB0eCArIFwiLFwiICsgLXR5ICsgXCIpXCI7XG4gICAgICAgIHRoaXMuX2Rpdi5zdHlsZVsndHJhbnNmb3JtJ10gPSBtYXRyaXg7XG4gICAgICAgIHRoaXMuX2Rpdi5zdHlsZVsnLXdlYmtpdC10cmFuc2Zvcm0nXSA9IG1hdHJpeDtcbiAgICAgICAgdGhpcy5fZGl2LnN0eWxlWyd0cmFuc2Zvcm0tb3JpZ2luJ10gPSAnMHB4IDEwMCUgMHB4JztcbiAgICAgICAgdGhpcy5fZGl2LnN0eWxlWyctd2Via2l0LXRyYW5zZm9ybS1vcmlnaW4nXSA9ICcwcHggMTAwJSAwcHgnO1xuXG4gICAgICAgIC8vIGNoYWduZWQgaWZyYW1lIG9wYWNpdHlcbiAgICAgICAgdGhpcy5fc2V0T3BhY2l0eShub2RlLm9wYWNpdHkpO1xuICAgICAgICB0aGlzLl9mb3JjZVVwZGF0ZSA9IGZhbHNlO1xuICAgIH1cbn0pO1xuXG5XZWJWaWV3SW1wbC5FdmVudFR5cGUgPSB7XG4gICAgTE9BRElORzogMCxcbiAgICBMT0FERUQ6IDEsXG4gICAgRVJST1I6IDIsXG4gICAgSlNfRVZBTFVBVEVEOiAzXG59O1xuXG5sZXQgcG9seWZpbGwgPSBXZWJWaWV3SW1wbC5fcG9seWZpbGwgPSB7XG4gICAgZGV2aWNlUGl4ZWxSYXRpbzogZmFsc2UsXG4gICAgZW5hYmxlRGl2OiBmYWxzZVxufTtcblxuaWYgKHN5cy5vcyA9PT0gc3lzLk9TX0lPUylcbiAgICBwb2x5ZmlsbC5lbmFibGVEaXYgPSB0cnVlO1xuXG5pZiAoc3lzLmlzTW9iaWxlKSB7XG4gICAgaWYgKHN5cy5icm93c2VyVHlwZSA9PT0gc3lzLkJST1dTRVJfVFlQRV9GSVJFRk9YKSB7XG4gICAgICAgIHBvbHlmaWxsLmVuYWJsZUJHID0gdHJ1ZTtcbiAgICB9XG59XG5lbHNlIHtcbiAgICBpZiAoc3lzLmJyb3dzZXJUeXBlID09PSBzeXMuQlJPV1NFUl9UWVBFX0lFKSB7XG4gICAgICAgIHBvbHlmaWxsLmNsb3NlSGlzdG9yeSA9IHRydWU7XG4gICAgfVxufVxuXG5tb2R1bGUuZXhwb3J0cyA9IFdlYlZpZXdJbXBsO1xuIl0sInNvdXJjZVJvb3QiOiIvIn0=