
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/tilemap/CCTiledObjectGroup.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

/**
 * !#en Renders the TMX object group.
 * !#zh 渲染 tmx object group。
 * @class TiledObjectGroup
 * @extends Component
 */
var TiledObjectGroup = cc.Class({
  name: 'cc.TiledObjectGroup',
  // Inherits from the abstract class directly,
  // because TiledLayer not create or maintains the sgNode by itself.
  "extends": cc.Component,

  /**
   * !#en Offset position of child objects.
   * !#zh 获取子对象的偏移位置。
   * @method getPositionOffset
   * @return {Vec2}
   * @example
   * let offset = tMXObjectGroup.getPositionOffset();
   */
  getPositionOffset: function getPositionOffset() {
    return this._positionOffset;
  },

  /**
   * !#en List of properties stored in a dictionary.
   * !#zh 以映射的形式获取属性列表。
   * @method getProperties
   * @return {Object}
   * @example
   * let offset = tMXObjectGroup.getProperties();
   */
  getProperties: function getProperties() {
    this._properties;
  },

  /**
   * !#en Gets the Group name.
   * !#zh 获取组名称。
   * @method getGroupName
   * @return {String}
   * @example
   * let groupName = tMXObjectGroup.getGroupName;
   */
  getGroupName: function getGroupName() {
    return this._groupName;
  },

  /**
   * Return the value for the specific property name
   * @param {String} propertyName
   * @return {Object}
   */
  getProperty: function getProperty(propertyName) {
    return this._properties[propertyName.toString()];
  },

  /**
   * !#en
   * Return the object for the specific object name. <br />
   * It will return the 1st object found on the array for the given name.
   * !#zh 获取指定的对象。
   * @method getObject
   * @param {String} objectName
   * @return {Object|Null}
   * @example
   * let object = tMXObjectGroup.getObject("Group");
   */
  getObject: function getObject(objectName) {
    for (var i = 0, len = this._objects.length; i < len; i++) {
      var obj = this._objects[i];

      if (obj && obj.name === objectName) {
        return obj;
      }
    } // object not found


    return null;
  },

  /**
   * !#en Gets the objects.
   * !#zh 获取对象数组。
   * @method getObjects
   * @return {Array}
   * @example
   * let objects = tMXObjectGroup.getObjects();
   */
  getObjects: function getObjects() {
    return this._objects;
  },
  _init: function _init(groupInfo, mapInfo, texGrids) {
    var TiledMap = cc.TiledMap;
    var TMXObjectType = TiledMap.TMXObjectType;
    var Orientation = TiledMap.Orientation;
    var StaggerAxis = TiledMap.StaggerAxis;
    var TileFlag = TiledMap.TileFlag;
    var FLIPPED_MASK = TileFlag.FLIPPED_MASK;
    var FLAG_HORIZONTAL = TileFlag.HORIZONTAL;
    var FLAG_VERTICAL = TileFlag.VERTICAL;
    this._groupName = groupInfo.name;
    this._positionOffset = groupInfo.offset;
    this._mapInfo = mapInfo;
    this._properties = groupInfo.getProperties();
    this._offset = cc.v2(groupInfo.offset.x, -groupInfo.offset.y);
    this._opacity = groupInfo._opacity;
    var mapSize = mapInfo._mapSize;
    var tileSize = mapInfo._tileSize;
    var width = 0,
        height = 0;

    if (mapInfo.orientation === Orientation.HEX) {
      if (mapInfo.getStaggerAxis() === StaggerAxis.STAGGERAXIS_X) {
        height = tileSize.height * (mapSize.height + 0.5);
        width = (tileSize.width + mapInfo.getHexSideLength()) * Math.floor(mapSize.width / 2) + tileSize.width * (mapSize.width % 2);
      } else {
        width = tileSize.width * (mapSize.width + 0.5);
        height = (tileSize.height + mapInfo.getHexSideLength()) * Math.floor(mapSize.height / 2) + tileSize.height * (mapSize.height % 2);
      }
    } else if (mapInfo.orientation === Orientation.ISO) {
      var wh = mapSize.width + mapSize.height;
      width = tileSize.width * 0.5 * wh;
      height = tileSize.height * 0.5 * wh;
    } else {
      width = mapSize.width * tileSize.width;
      height = mapSize.height * tileSize.height;
    }

    this.node.setContentSize(width, height);
    var leftTopX = width * this.node.anchorX;
    var leftTopY = height * (1 - this.node.anchorY);
    var objects = groupInfo._objects;
    var aliveNodes = {};

    for (var i = 0, l = objects.length; i < l; i++) {
      var object = objects[i];
      var objType = object.type;
      object.offset = cc.v2(object.x, object.y);
      var points = object.points || object.polylinePoints;

      if (points) {
        for (var pi = 0; pi < points.length; pi++) {
          points[pi].y *= -1;
        }
      }

      if (Orientation.ISO !== mapInfo.orientation) {
        object.y = height - object.y;
      } else {
        var posIdxX = object.x / tileSize.height;
        var posIdxY = object.y / tileSize.height;
        object.x = tileSize.width * 0.5 * (mapSize.height + posIdxX - posIdxY);
        object.y = tileSize.height * 0.5 * (mapSize.width + mapSize.height - posIdxX - posIdxY);
      }

      if (objType === TMXObjectType.TEXT) {
        var textName = "text" + object.id;
        aliveNodes[textName] = true;
        var textNode = this.node.getChildByName(textName);

        if (!textNode) {
          textNode = new cc.Node();
        }

        textNode.anchorX = 0;
        textNode.anchorY = 1;
        textNode.angle = -object.rotation;
        textNode.x = object.x - leftTopX;
        textNode.y = object.y - leftTopY;
        textNode.name = textName;
        textNode.parent = this.node;
        textNode.color = object.color;
        textNode.opacity = this._opacity;
        textNode.setSiblingIndex(i);
        var label = textNode.getComponent(cc.Label);

        if (!label) {
          label = textNode.addComponent(cc.Label);
        }

        label.overflow = cc.Label.Overflow.SHRINK;
        label.lineHeight = object.height;
        label.string = object.text;
        label.horizontalAlign = object.halign;
        label.verticalAlign = object.valign;
        label.fontSize = object.pixelsize;
        textNode.width = object.width;
        textNode.height = object.height;
      }

      if (objType === TMXObjectType.IMAGE) {
        var gid = object.gid;
        var grid = texGrids[(gid & FLIPPED_MASK) >>> 0];
        if (!grid) continue;
        var tileset = grid.tileset;
        var imgName = "img" + object.id;
        aliveNodes[imgName] = true;
        var imgNode = this.node.getChildByName(imgName);
        var imgWidth = object.width || grid.width;
        var imgHeight = object.height || grid.height;
        var tileOffsetX = tileset.tileOffset.x;
        var tileOffsetY = tileset.tileOffset.y; // Delete image nodes implemented as private nodes
        // Use cc.Node to implement node-level requirements

        if (imgNode instanceof cc.PrivateNode) {
          imgNode.removeFromParent();
          imgNode.destroy();
          imgNode = null;
        }

        if (!imgNode) {
          imgNode = new cc.Node();
        }

        if (Orientation.ISO == mapInfo.orientation) {
          imgNode.anchorX = 0.5 + tileOffsetX / imgWidth;
          imgNode.anchorY = tileOffsetY / imgHeight;
        } else {
          imgNode.anchorX = tileOffsetX / imgWidth;
          imgNode.anchorY = tileOffsetY / imgHeight;
        }

        imgNode.angle = -object.rotation;
        imgNode.x = object.x - leftTopX;
        imgNode.y = object.y - leftTopY;
        imgNode.name = imgName;
        imgNode.parent = this.node;
        imgNode.opacity = this._opacity;
        imgNode.setSiblingIndex(i);
        var sp = imgNode.getComponent(cc.Sprite);

        if (!sp) {
          sp = imgNode.addComponent(cc.Sprite);
        }

        var spf = sp.spriteFrame;

        if (!spf) {
          spf = new cc.SpriteFrame();
        }

        if ((gid & FLAG_HORIZONTAL) >>> 0) {
          spf.setFlipX(true);
        } else {
          spf.setFlipX(false);
        }

        if ((gid & FLAG_VERTICAL) >>> 0) {
          spf.setFlipY(true);
        } else {
          spf.setFlipY(false);
        }

        spf.setTexture(grid.tileset.sourceImage, cc.rect(grid));
        sp.spriteFrame = spf;
        sp.setVertsDirty(); // object group may has no width or height info

        imgNode.width = imgWidth;
        imgNode.height = imgHeight;
      }
    }

    this._objects = objects; // destroy useless node

    var children = this.node.children;
    var uselessExp = /^(?:img|text)\d+$/;

    for (var _i = 0, n = children.length; _i < n; _i++) {
      var c = children[_i];
      var cName = c._name;
      var isUseless = uselessExp.test(cName);
      if (isUseless && !aliveNodes[cName]) c.destroy();
    }
  }
});
cc.TiledObjectGroup = module.exports = TiledObjectGroup;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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