
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/types.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.getInspectorProps = getInspectorProps;
exports.getClassName = exports.getInstanceCtor = exports.getInstanceType = exports.enums2default = exports.ctor2enums = void 0;

var _enums = _interopRequireDefault(require("./enums"));

var _valueTypes = require("../core/value-types");

var _CCTexture2D = _interopRequireDefault(require("../core/assets/CCTexture2D"));

var _ctor2default, _enums2ctor, _ctor2enums, _enums2default;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var gfxTexture2D = null,
    gfxTextureCube = null;

if (CC_JSB && CC_NATIVERENDERER) {
  gfxTexture2D = gfx.Texture2D;
} else {
  gfxTexture2D = require('./gfx/texture-2d');
}

var CCObject = cc.Object;
var ctor2default = (_ctor2default = {}, _ctor2default[Boolean] = function (v) {
  return v || false;
}, _ctor2default[Number] = function (v) {
  return v ? ArrayBuffer.isView(v) ? v[0] : v : 0;
}, _ctor2default[_valueTypes.Vec2] = function (v) {
  return v ? cc.v2(v[0], v[1]) : cc.v2();
}, _ctor2default[_valueTypes.Vec3] = function (v) {
  return v ? cc.v3(v[0], v[1], v[2]) : cc.v3();
}, _ctor2default[_valueTypes.Vec4] = function (v) {
  return v ? cc.v4(v[0], v[1], v[2], v[3]) : cc.v4();
}, _ctor2default[_valueTypes.Color] = function (v) {
  return v ? cc.color(v[0] * 255, v[1] * 255, v[2] * 255, (v[3] || 1) * 255) : cc.color();
}, _ctor2default[_valueTypes.Mat4] = function (v) {
  return v ? cc.mat4(v[0], v[1], v[2], v[3], v[4], v[5], v[6], v[7], v[8], v[9], v[10], v[11], v[12], v[13], v[14], v[15]) : cc.mat4();
}, _ctor2default[_CCTexture2D["default"]] = function () {
  return null;
}, _ctor2default[CCObject] = function () {
  return null;
}, _ctor2default);
var enums2ctor = (_enums2ctor = {}, _enums2ctor[_enums["default"].PARAM_INT] = Number, _enums2ctor[_enums["default"].PARAM_INT2] = _valueTypes.Vec2, _enums2ctor[_enums["default"].PARAM_INT3] = _valueTypes.Vec3, _enums2ctor[_enums["default"].PARAM_INT4] = _valueTypes.Vec4, _enums2ctor[_enums["default"].PARAM_FLOAT] = Number, _enums2ctor[_enums["default"].PARAM_FLOAT2] = _valueTypes.Vec2, _enums2ctor[_enums["default"].PARAM_FLOAT3] = _valueTypes.Vec3, _enums2ctor[_enums["default"].PARAM_FLOAT4] = _valueTypes.Vec4, _enums2ctor[_enums["default"].PARAM_MAT4] = _valueTypes.Mat4, _enums2ctor[_enums["default"].PARAM_TEXTURE_2D] = _CCTexture2D["default"], _enums2ctor.color = _valueTypes.Color, _enums2ctor.number = Number, _enums2ctor["boolean"] = Boolean, _enums2ctor["default"] = CCObject, _enums2ctor);
var ctor2enums = (_ctor2enums = {}, _ctor2enums[Number] = _enums["default"].PARAM_FLOAT, _ctor2enums[_valueTypes.Vec2] = _enums["default"].PARAM_FLOAT2, _ctor2enums[_valueTypes.Vec3] = _enums["default"].PARAM_FLOAT3, _ctor2enums[_valueTypes.Vec4] = _enums["default"].PARAM_FLOAT4, _ctor2enums[_valueTypes.Color] = _enums["default"].PARAM_COLOR3, _ctor2enums[_valueTypes.Color] = _enums["default"].PARAM_COLOR4, _ctor2enums[_valueTypes.Mat4] = _enums["default"].PARAM_MAT4, _ctor2enums[_CCTexture2D["default"]] = _enums["default"].PARAM_TEXTURE_2D, _ctor2enums[gfxTexture2D] = _enums["default"].PARAM_TEXTURE_2D, _ctor2enums);
exports.ctor2enums = ctor2enums;
var enums2default = (_enums2default = {}, _enums2default[_enums["default"].PARAM_INT] = new Uint32Array([0]), _enums2default[_enums["default"].PARAM_INT2] = new Uint32Array([0, 0]), _enums2default[_enums["default"].PARAM_INT3] = new Uint32Array([0, 0, 0]), _enums2default[_enums["default"].PARAM_INT4] = new Uint32Array([0, 0, 0, 0]), _enums2default[_enums["default"].PARAM_FLOAT] = new Float32Array([0]), _enums2default[_enums["default"].PARAM_FLOAT2] = new Float32Array([0, 0]), _enums2default[_enums["default"].PARAM_FLOAT3] = new Float32Array([0, 0, 0]), _enums2default[_enums["default"].PARAM_FLOAT4] = new Float32Array([0, 0, 0, 0]), _enums2default[_enums["default"].PARAM_MAT4] = cc.mat4().m, _enums2default[_enums["default"].PARAM_TEXTURE_2D] = null, _enums2default.number = 0, _enums2default["boolean"] = false, _enums2default);
exports.enums2default = enums2default;

var getInstanceType = function getInstanceType(t) {
  return enums2ctor[t] || enums2ctor["default"];
};

exports.getInstanceType = getInstanceType;

var getInstanceCtor = function getInstanceCtor(t) {
  return ctor2default[getInstanceType(t)];
};

exports.getInstanceCtor = getInstanceCtor;

var getClassName = function getClassName(t) {
  return cc.js.getClassName(getInstanceType(t));
};

exports.getClassName = getClassName;
var className2InspectorName = {
  Number: 'number',
  Boolean: 'boolean'
};

function getInspectorProps(prop) {
  var editor = {
    type: prop.type
  };
  Object.assign(editor, prop.editor || prop.inspector);
  editor.defines = prop.defines;
  editor.value = getInstanceCtor(editor.type)(prop.value);
  var className = getClassName(editor.type);
  editor.typeName = className2InspectorName[className] || className;
  editor.valueCtor = enums2ctor[editor.type];

  if (editor.typeName == 'cc.Texture2D') {
    editor.typeName = 'cc.Asset';
    editor.assetType = 'cc.Texture2D';
  }

  return editor;
}

;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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