
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/scene/scene.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _memop = require("../memop");

// Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

/**
 * A representation of the scene
 */
var Scene =
/*#__PURE__*/
function () {
  /**
   * Setup a default empty scene
   */
  function Scene(app) {
    this._lights = new _memop.FixedArray(16);
    this._models = new _memop.FixedArray(16);
    this._cameras = new _memop.FixedArray(16);
    this._debugCamera = null;
    this._app = app; // NOTE: we don't use pool for views (because it's less changed and it doesn't have poolID)

    this._views = [];
  }

  var _proto = Scene.prototype;

  _proto._add = function _add(pool, item) {
    if (item._poolID !== -1) {
      return;
    }

    pool.push(item);
    item._poolID = pool.length - 1;
  };

  _proto._remove = function _remove(pool, item) {
    if (item._poolID === -1) {
      return;
    }

    pool.data[pool.length - 1]._poolID = item._poolID;
    pool.fastRemove(item._poolID);
    item._poolID = -1;
  }
  /**
   * reset the model viewIDs
   */
  ;

  _proto.reset = function reset() {
    for (var i = 0; i < this._models.length; ++i) {
      var model = this._models.data[i];
      model._viewID = -1;
    }
  }
  /**
   * Set the debug camera
   * @param {Camera} cam the debug camera
   */
  ;

  _proto.setDebugCamera = function setDebugCamera(cam) {
    this._debugCamera = cam;
  }
  /**
   * Get the count of registered cameras
   * @returns {number} camera count
   */
  ;

  _proto.getCameraCount = function getCameraCount() {
    return this._cameras.length;
  }
  /**
   * Get the specified camera
   * @param {number} idx camera index
   * @returns {Camera} the specified camera
   */
  ;

  _proto.getCamera = function getCamera(idx) {
    return this._cameras.data[idx];
  }
  /**
   * register a camera
   * @param {Camera} camera the new camera
   */
  ;

  _proto.addCamera = function addCamera(camera) {
    this._add(this._cameras, camera);
  }
  /**
   * remove a camera
   * @param {Camera} camera the camera to be removed
   */
  ;

  _proto.removeCamera = function removeCamera(camera) {
    this._remove(this._cameras, camera);
  }
  /**
   * Get the count of registered model
   * @returns {number} model count
   */
  ;

  _proto.getModelCount = function getModelCount() {
    return this._models.length;
  }
  /**
   * Get the specified model
   * @param {number} idx model index
   * @returns {Model} the specified model
   */
  ;

  _proto.getModel = function getModel(idx) {
    return this._models.data[idx];
  }
  /**
   * register a model
   * @param {Model} model the new model
   */
  ;

  _proto.addModel = function addModel(model) {
    this._add(this._models, model);
  }
  /**
   * remove a model
   * @param {Model} model the model to be removed
   */
  ;

  _proto.removeModel = function removeModel(model) {
    this._remove(this._models, model);
  }
  /**
   * Get the count of registered light
   * @returns {number} light count
   */
  ;

  _proto.getLightCount = function getLightCount() {
    return this._lights.length;
  }
  /**
   * Get the specified light
   * @param {number} idx light index
   * @returns {Light} the specified light
   */
  ;

  _proto.getLight = function getLight(idx) {
    return this._lights.data[idx];
  }
  /**
   * register a light
   * @param {Light} light the new light
   */
  ;

  _proto.addLight = function addLight(light) {
    this._add(this._lights, light);
  }
  /**
   * remove a light
   * @param {Light} light the light to be removed
   */
  ;

  _proto.removeLight = function removeLight(light) {
    this._remove(this._lights, light);
  }
  /**
   * register a view
   * @param {View} view the new view
   */
  ;

  _proto.addView = function addView(view) {
    if (this._views.indexOf(view) === -1) {
      this._views.push(view);
    }
  }
  /**
   * remove a view
   * @param {View} view the view to be removed
   */
  ;

  _proto.removeView = function removeView(view) {
    var idx = this._views.indexOf(view);

    if (idx !== -1) {
      this._views.splice(idx, 1);
    }
  };

  return Scene;
}();

var _default = Scene;
exports["default"] = _default;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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