
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/renderers/forward-renderer.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _valueTypes = require("../../core/value-types");

var _baseRenderer = _interopRequireDefault(require("../core/base-renderer"));

var _enums = _interopRequireDefault(require("../enums"));

var _memop = require("../memop");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var _a16_view = new Float32Array(16);

var _a16_view_inv = new Float32Array(16);

var _a16_proj = new Float32Array(16);

var _a16_viewProj = new Float32Array(16);

var _a4_camPos = new Float32Array(4);

var _a64_shadow_lightViewProj = new Float32Array(64);

var _a16_shadow_lightViewProjs = [];

var _a4_shadow_info = new Float32Array(4);

var _camPos = new _valueTypes.Vec4(0, 0, 0, 0);

var _camFwd = new _valueTypes.Vec3(0, 0, 0);

var _v3_tmp1 = new _valueTypes.Vec3(0, 0, 0);

var CC_MAX_LIGHTS = 4;
var CC_MAX_SHADOW_LIGHTS = 2;

var _float16_pool = new _memop.RecyclePool(function () {
  return new Float32Array(16);
}, 8);

var ForwardRenderer =
/*#__PURE__*/
function (_BaseRenderer) {
  _inheritsLoose(ForwardRenderer, _BaseRenderer);

  function ForwardRenderer(device, builtin) {
    var _this;

    _this = _BaseRenderer.call(this, device, builtin) || this;
    _this._time = new Float32Array(4);
    _this._lights = [];
    _this._shadowLights = [];
    _this._numLights = 0;
    _this._defines = {};

    _this._registerStage('shadowcast', _this._shadowStage.bind(_assertThisInitialized(_this)));

    _this._registerStage('opaque', _this._opaqueStage.bind(_assertThisInitialized(_this)));

    _this._registerStage('transparent', _this._transparentStage.bind(_assertThisInitialized(_this)));

    return _this;
  }

  var _proto = ForwardRenderer.prototype;

  _proto.reset = function reset() {
    _float16_pool.reset();

    _BaseRenderer.prototype.reset.call(this);
  };

  _proto.render = function render(scene, dt) {
    this.reset();

    if (!CC_EDITOR) {
      this._time[0] += dt;

      this._device.setUniform('cc_time', this._time);
    }

    this._updateLights(scene);

    var canvas = this._device._gl.canvas;

    for (var i = 0; i < scene._cameras.length; ++i) {
      var view = this._requestView();

      var width = canvas.width;
      var height = canvas.height;
      var camera = scene._cameras.data[i];
      camera.extractView(view, width, height);
    } // render by cameras


    this._viewPools.sort(function (a, b) {
      return a._priority - b._priority;
    });

    for (var _i = 0; _i < this._viewPools.length; ++_i) {
      var _view = this._viewPools.data[_i];

      this._render(_view, scene);
    }
  } // direct render a single camera
  ;

  _proto.renderCamera = function renderCamera(camera, scene) {
    this.reset();
    var canvas = this._device._gl.canvas;
    var width = canvas.width;
    var height = canvas.height;

    var view = this._requestView();

    camera.extractView(view, width, height);

    this._render(view, scene);
  };

  _proto._updateLights = function _updateLights(scene) {
    this._lights.length = 0;
    this._shadowLights.length = 0;
    var lights = scene._lights;

    for (var i = 0; i < lights.length; ++i) {
      var light = lights.data[i];
      light.update(this._device);

      if (light.shadowType !== _enums["default"].SHADOW_NONE) {
        if (this._shadowLights.length < CC_MAX_SHADOW_LIGHTS) {
          this._shadowLights.splice(0, 0, light);
        }

        var view = this._requestView();

        light.extractView(view, ['shadowcast']);

        this._lights.splice(0, 0, light);
      } else {
        this._lights.push(light);
      }
    }

    this._updateLightDefines();

    this._numLights = lights._count;
  };

  _proto._updateLightDefines = function _updateLightDefines() {
    var defines = this._defines;

    for (var i = 0; i < this._lights.length; ++i) {
      var light = this._lights[i];
      defines["CC_LIGHT_" + i + "_TYPE"] = light._type;
      defines["CC_SHADOW_" + i + "_TYPE"] = light._shadowType;
    }

    defines.CC_NUM_LIGHTS = Math.min(CC_MAX_LIGHTS, this._lights.length);
    defines.CC_NUM_SHADOW_LIGHTS = Math.min(CC_MAX_LIGHTS, this._shadowLights.length);
  };

  _proto._submitLightsUniforms = function _submitLightsUniforms() {
    var device = this._device;

    if (this._lights.length > 0) {
      var positionAndRanges = _float16_pool.add();

      var directions = _float16_pool.add();

      var colors = _float16_pool.add();

      var lightNum = Math.min(CC_MAX_LIGHTS, this._lights.length);

      for (var i = 0; i < lightNum; ++i) {
        var light = this._lights[i];
        var index = i * 4;
        colors.set(light._colorUniform, index);
        directions.set(light._directionUniform, index);
        positionAndRanges.set(light._positionUniform, index);
        positionAndRanges[index + 3] = light._range;

        if (light._type === _enums["default"].LIGHT_SPOT) {
          directions[index + 3] = light._spotUniform[0];
          colors[index + 3] = light._spotUniform[1];
        } else {
          directions[index + 3] = 0;
          colors[index + 3] = 0;
        }
      }

      device.setUniform('cc_lightDirection', directions);
      device.setUniform('cc_lightColor', colors);
      device.setUniform('cc_lightPositionAndRange', positionAndRanges);
    }
  };

  _proto._submitShadowStageUniforms = function _submitShadowStageUniforms(view) {
    var light = view._shadowLight;
    var shadowInfo = _a4_shadow_info;
    shadowInfo[0] = light.shadowMinDepth;
    shadowInfo[1] = light.shadowMaxDepth;
    shadowInfo[2] = light.shadowDepthScale;
    shadowInfo[3] = light.shadowDarkness;

    this._device.setUniform('cc_shadow_map_lightViewProjMatrix', _valueTypes.Mat4.toArray(_a16_viewProj, view._matViewProj));

    this._device.setUniform('cc_shadow_map_info', shadowInfo);

    this._device.setUniform('cc_shadow_map_bias', light.shadowBias);

    this._defines.CC_SHADOW_TYPE = light._shadowType;
  };

  _proto._submitOtherStagesUniforms = function _submitOtherStagesUniforms() {
    var shadowInfo = _float16_pool.add();

    for (var i = 0; i < this._shadowLights.length; ++i) {
      var light = this._shadowLights[i];
      var view = _a16_shadow_lightViewProjs[i];

      if (!view) {
        view = _a16_shadow_lightViewProjs[i] = new Float32Array(_a64_shadow_lightViewProj.buffer, i * 64, 16);
      }

      _valueTypes.Mat4.toArray(view, light.viewProjMatrix);

      var index = i * 4;
      shadowInfo[index] = light.shadowMinDepth;
      shadowInfo[index + 1] = light.shadowMaxDepth;
      shadowInfo[index + 2] = light._shadowResolution;
      shadowInfo[index + 3] = light.shadowDarkness;
    }

    this._device.setUniform("cc_shadow_lightViewProjMatrix", _a64_shadow_lightViewProj);

    this._device.setUniform("cc_shadow_info", shadowInfo); // this._device.setUniform(`cc_frustumEdgeFalloff_${index}`, light.frustumEdgeFalloff);

  };

  _proto._sortItems = function _sortItems(items) {
    // sort items
    items.sort(function (a, b) {
      // if (a.layer !== b.layer) {
      //   return a.layer - b.layer;
      // }
      if (a.passes.length !== b.passes.length) {
        return a.passes.length - b.passes.length;
      }

      return a.sortKey - b.sortKey;
    });
  };

  _proto._shadowStage = function _shadowStage(view, items) {
    // update rendering
    this._submitShadowStageUniforms(view); // this._sortItems(items);
    // draw it


    for (var i = 0; i < items.length; ++i) {
      var item = items.data[i];

      if (item.effect.getDefine('CC_CASTING_SHADOW')) {
        this._draw(item);
      }
    }
  };

  _proto._drawItems = function _drawItems(view, items) {
    var shadowLights = this._shadowLights;

    if (shadowLights.length === 0 && this._numLights === 0) {
      for (var i = 0; i < items.length; ++i) {
        var item = items.data[i];

        this._draw(item);
      }
    } else {
      for (var _i2 = 0; _i2 < items.length; ++_i2) {
        var _item = items.data[_i2];

        for (var shadowIdx = 0; shadowIdx < shadowLights.length; ++shadowIdx) {
          this._device.setTexture('cc_shadow_map_' + shadowIdx, shadowLights[shadowIdx].shadowMap, this._allocTextureUnit());
        }

        this._draw(_item);
      }
    }
  };

  _proto._opaqueStage = function _opaqueStage(view, items) {
    view.getPosition(_camPos); // update uniforms

    this._device.setUniform('cc_matView', _valueTypes.Mat4.toArray(_a16_view, view._matView));

    this._device.setUniform('cc_matViewInv', _valueTypes.Mat4.toArray(_a16_view_inv, view._matViewInv));

    this._device.setUniform('cc_matpProj', _valueTypes.Mat4.toArray(_a16_proj, view._matProj));

    this._device.setUniform('cc_matViewProj', _valueTypes.Mat4.toArray(_a16_viewProj, view._matViewProj));

    this._device.setUniform('cc_cameraPos', _valueTypes.Vec4.toArray(_a4_camPos, _camPos)); // update rendering


    this._submitLightsUniforms();

    this._submitOtherStagesUniforms();

    this._drawItems(view, items);
  };

  _proto._transparentStage = function _transparentStage(view, items) {
    view.getPosition(_camPos);
    view.getForward(_camFwd); // update uniforms

    this._device.setUniform('cc_matView', _valueTypes.Mat4.toArray(_a16_view, view._matView));

    this._device.setUniform('cc_matViewInv', _valueTypes.Mat4.toArray(_a16_view_inv, view._matViewInv));

    this._device.setUniform('cc_matpProj', _valueTypes.Mat4.toArray(_a16_proj, view._matProj));

    this._device.setUniform('cc_matViewProj', _valueTypes.Mat4.toArray(_a16_viewProj, view._matViewProj));

    this._device.setUniform('cc_cameraPos', _valueTypes.Vec4.toArray(_a4_camPos, _camPos));

    this._submitLightsUniforms();

    this._submitOtherStagesUniforms(); // calculate zdist


    for (var i = 0; i < items.length; ++i) {
      var item = items.data[i]; // TODO: we should use mesh center instead!

      item.node.getWorldPosition(_v3_tmp1);

      _valueTypes.Vec3.sub(_v3_tmp1, _v3_tmp1, _camPos);

      item.sortKey = -_valueTypes.Vec3.dot(_v3_tmp1, _camFwd);
    }

    this._sortItems(items);

    this._drawItems(view, items);
  };

  return ForwardRenderer;
}(_baseRenderer["default"]);

exports["default"] = ForwardRenderer;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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