
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/memop/pool.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var Pool =
/*#__PURE__*/
function () {
  function Pool(fn, size) {
    this._fn = fn;
    this._idx = size - 1;
    this._frees = new Array(size);

    for (var i = 0; i < size; ++i) {
      this._frees[i] = fn();
    }
  }

  var _proto = Pool.prototype;

  _proto._expand = function _expand(size) {
    var old = this._frees;
    this._frees = new Array(size);
    var len = size - old.length;

    for (var i = 0; i < len; ++i) {
      this._frees[i] = this._fn();
    }

    for (var _i = len, j = 0; _i < size; ++_i, ++j) {
      this._frees[_i] = old[j];
    }

    this._idx += len;
  };

  _proto.alloc = function alloc() {
    // create some more space (expand by 20%, minimum 1)
    if (this._idx < 0) {
      this._expand(Math.round(this._frees.length * 1.2) + 1);
    }

    var ret = this._frees[this._idx];
    this._frees[this._idx] = null;
    --this._idx;
    return ret;
  };

  _proto.free = function free(obj) {
    ++this._idx;
    this._frees[this._idx] = obj;
  }
  /**
   * 清除对象池。
   * @param fn 清除回调，对每个释放的对象调用一次。
   */
  ;

  _proto.clear = function clear(fn) {
    for (var i = 0; i <= this._idx; i++) {
      if (fn) {
        fn(this._frees[i]);
      }
    }

    this._frees.length = 0;
    this._idx = -1;
  };

  return Pool;
}();

exports["default"] = Pool;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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