
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/memop/linked-array.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _pool = _interopRequireDefault(require("./pool"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

// NOTE: you must have `_prev` and `_next` field in the object returns by `fn`
var LinkedArray =
/*#__PURE__*/
function () {
  function LinkedArray(fn, size) {
    this._fn = fn;
    this._count = 0;
    this._head = null;
    this._tail = null;
    this._pool = new _pool["default"](fn, size);
  }

  var _proto = LinkedArray.prototype;

  _proto.add = function add() {
    var node = this._pool.alloc();

    if (!this._tail) {
      this._head = node;
    } else {
      this._tail._next = node;
      node._prev = this._tail;
    }

    this._tail = node;
    this._count += 1;
    return node;
  };

  _proto.remove = function remove(node) {
    if (node._prev) {
      node._prev._next = node._next;
    } else {
      this._head = node._next;
    }

    if (node._next) {
      node._next._prev = node._prev;
    } else {
      this._tail = node._prev;
    }

    node._next = null;
    node._prev = null;

    this._pool.free(node);

    this._count -= 1;
  };

  _proto.forEach = function forEach(fn, binder) {
    var cursor = this._head;

    if (!cursor) {
      return;
    }

    if (binder) {
      fn = fn.bind(binder);
    }

    var idx = 0;
    var next = cursor;

    while (cursor) {
      next = cursor._next;
      fn(cursor, idx, this);
      cursor = next;
      ++idx;
    }
  };

  _createClass(LinkedArray, [{
    key: "head",
    get: function get() {
      return this._head;
    }
  }, {
    key: "tail",
    get: function get() {
      return this._tail;
    }
  }, {
    key: "length",
    get: function get() {
      return this._count;
    }
  }]);

  return LinkedArray;
}();

exports["default"] = LinkedArray;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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