
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/gfx/vertex-format.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _enums = require("./enums");

var _murmurhash2_gc = _interopRequireDefault(require("../murmurhash2_gc"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// ====================
// exports
// ====================
var VertexFormat =
/*#__PURE__*/
function () {
  /**
   * @constructor
   * @param {Array} infos
   *
   * @example
   * let vertexFmt = new VertexFormat([
   *   { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 3 },
   *   { name: gfx.ATTR_UV0, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
   *   { name: gfx.ATTR_COLOR, type: gfx.ATTR_TYPE_FLOAT32, num: 4, normalize: true },
   * ])
   */
  function VertexFormat(infos) {
    this._attr2el = {};
    this._elements = [];
    this._bytes = 0;
    var hash = "";

    for (var i = 0, len = infos.length; i < len; ++i) {
      var info = infos[i];
      var el = {
        name: info.name,
        offset: this._bytes,
        stride: 0,
        stream: -1,
        type: info.type,
        num: info.num,
        normalize: info.normalize === undefined ? false : info.normalize,
        bytes: info.num * (0, _enums.attrTypeBytes)(info.type)
      };
      this._attr2el[el.name] = el;

      this._elements.push(el);

      this._bytes += el.bytes;
      hash += el.name + ":" + el.num + ":" + el.type + ":" + el.normalize;
    }

    for (var _i = 0, _len = this._elements.length; _i < _len; ++_i) {
      var _el = this._elements[_i];
      _el.stride = this._bytes;
    }

    this._hash = (0, _murmurhash2_gc["default"])(hash, 666);
  }
  /**
   * @method element
   * @param {string} attrName
   */


  var _proto = VertexFormat.prototype;

  _proto.element = function element(attrName) {
    return this._attr2el[attrName];
  }
  /**
   * @method getHash
   */
  ;

  _proto.getHash = function getHash() {
    return this._hash;
  };

  return VertexFormat;
}();

exports["default"] = VertexFormat;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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