
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/gfx/vertex-buffer.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _enums = require("./enums");

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var VertexBuffer =
/*#__PURE__*/
function () {
  /**
   * @constructor
   * @param {Device} device
   * @param {VertexFormat} format
   * @param {USAGE_*} usage
   * @param {ArrayBuffer | Uint8Array} data
   */
  function VertexBuffer(device, format, usage, data) {
    this._device = device;
    this._format = format;
    this._usage = usage;
    this._bytesPerVertex = this._format._bytes;
    this._bytes = data.byteLength;
    this._numVertices = this._bytes / this._bytesPerVertex;
    this._needExpandDataStore = true; // update

    this._glID = device._gl.createBuffer();
    this.update(0, data); // stats

    device._stats.vb += this._bytes;
  }
  /**
   * @method destroy
   */


  var _proto = VertexBuffer.prototype;

  _proto.destroy = function destroy() {
    if (this._glID === -1) {
      console.error('The buffer already destroyed');
      return;
    }

    var gl = this._device._gl;
    gl.deleteBuffer(this._glID);
    this._device._stats.vb -= this.bytes;
    this._glID = -1;
  }
  /**
   * @method update
   * @param {Number} byteOffset
   * @param {ArrayBuffer} data
   */
  ;

  _proto.update = function update(byteOffset, data) {
    if (this._glID === -1) {
      console.error('The buffer is destroyed');
      return;
    }

    if (data.byteLength === 0) return; // Need to create new buffer object when bytes exceed

    if (byteOffset + data.byteLength > this._bytes) {
      if (byteOffset) {
        // Lost data between [0, byteOffset] which is need for new buffer
        console.error('Failed to update data, bytes exceed.');
        return;
      } else {
        this._needExpandDataStore = true;
        this._bytes = byteOffset + data.byteLength;
        this._numVertices = this._bytes / this._bytesPerVertex;
      }
    }

    var gl = this._device._gl;
    var glUsage = this._usage;
    gl.bindBuffer(gl.ARRAY_BUFFER, this._glID);

    if (this._needExpandDataStore) {
      gl.bufferData(gl.ARRAY_BUFFER, data, glUsage);
      this._needExpandDataStore = false;
    } else {
      gl.bufferSubData(gl.ARRAY_BUFFER, byteOffset, data);
    }

    gl.bindBuffer(gl.ARRAY_BUFFER, null);
  };

  _proto.getFormat = function getFormat(name) {
    return this._format.element(name);
  };

  _proto.setUsage = function setUsage(usage) {
    this._usage = usage;
  };

  _createClass(VertexBuffer, [{
    key: "count",
    get: function get() {
      return this._numVertices;
    }
  }]);

  return VertexBuffer;
}();

var _default = VertexBuffer;
exports["default"] = _default;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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