
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/gfx/texture-cube.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _texture = _interopRequireDefault(require("./texture"));

var _enums = require("./enums");

var _misc = require("./misc");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var TextureCube =
/*#__PURE__*/
function (_Texture) {
  _inheritsLoose(TextureCube, _Texture);

  /**
   * @constructor
   * @param {Device} device
   * @param {Object} options
   * @param {Array} options.images
   * @param {Boolean} options.mipmap
   * @param {Number} options.width
   * @param {Number} options.height
   * @param {TEXTURE_FMT_*} options.format
   * @param {Number} options.anisotropy
   * @param {FILTER_*} options.minFilter
   * @param {FILTER_*} options.magFilter
   * @param {FILTER_*} options.mipFilter
   * @param {WRAP_*} options.wrapS
   * @param {WRAP_*} options.wrapT
   * @param {WRAP_*} options.wrapR
   * @param {Boolean} options.flipY
   * @param {Boolean} options.premultiplyAlpha
   */
  function TextureCube(device, options) {
    var _this;

    _this = _Texture.call(this, device) || this;
    var gl = _this._device._gl;
    _this._target = gl.TEXTURE_CUBE_MAP;
    _this._glID = gl.createTexture();

    _this.update(options);

    return _this;
  }
  /**
   * @method update
   * @param {Object} options
   * @param {Array} options.images
   * @param {Boolean} options.genMipmaps
   * @param {Number} options.width
   * @param {Number} options.height
   * @param {TEXTURE_FMT_*} options.format
   * @param {Number} options.anisotropy
   * @param {FILTER_*} options.minFilter
   * @param {FILTER_*} options.magFilter
   * @param {FILTER_*} options.mipFilter
   * @param {WRAP_*} options.wrapS
   * @param {WRAP_*} options.wrapT
   * @param {WRAP_*} options.wrapR
   * @param {Boolean} options.flipY
   * @param {Boolean} options.premultiplyAlpha
   */


  var _proto = TextureCube.prototype;

  _proto.update = function update(options) {
    var gl = this._device._gl;
    var genMipmaps = this._genMipmaps;

    if (options) {
      if (options.width !== undefined) {
        this._width = options.width;
      }

      if (options.height !== undefined) {
        this._height = options.height;
      }

      if (options.anisotropy !== undefined) {
        this._anisotropy = options.anisotropy;
      }

      if (options.minFilter !== undefined) {
        this._minFilter = options.minFilter;
      }

      if (options.magFilter !== undefined) {
        this._magFilter = options.magFilter;
      }

      if (options.mipFilter !== undefined) {
        this._mipFilter = options.mipFilter;
      }

      if (options.wrapS !== undefined) {
        this._wrapS = options.wrapS;
      }

      if (options.wrapT !== undefined) {
        this._wrapT = options.wrapT;
      } // wrapR available in webgl2
      // if (options.wrapR !== undefined) {
      //   this._wrapR = options.wrapR;
      // }


      if (options.format !== undefined) {
        this._format = options.format;
        this._compressed = this._format >= _enums.enums.TEXTURE_FMT_RGB_DXT1 && this._format <= _enums.enums.TEXTURE_FMT_RGBA_PVRTC_4BPPV1 || this._format >= _enums.enums.TEXTURE_FMT_RGB_ETC2 && this._format <= _enums.enums.TEXTURE_FMT_RGBA_ETC2;
      } // check if generate mipmap


      if (options.genMipmaps !== undefined) {
        this._genMipmaps = options.genMipmaps;
        genMipmaps = options.genMipmaps;
      }

      if (options.images !== undefined) {
        if (options.images.length > 1) {
          genMipmaps = false;

          if (options.width !== options.height) {
            console.warn('texture-cube width and height should be identical.');
          }

          if (options.width >> options.images.length - 1 !== 1) {
            console.error('texture-cube mipmap is invalid. please set mipmap as 1x1, 2x2, 4x4 ... nxn');
          }
        }
      }
    } // NOTE: get pot after this._width, this._height has been assigned.


    var pot = (0, _misc.isPow2)(this._width) && (0, _misc.isPow2)(this._height);

    if (!pot) {
      genMipmaps = false;
    }

    gl.activeTexture(gl.TEXTURE0);
    gl.bindTexture(gl.TEXTURE_CUBE_MAP, this._glID);

    if (options.images !== undefined && options.images.length > 0) {
      this._setMipmap(options.images, options.flipY, options.premultiplyAlpha);

      if (options.images.length > 1) this._genMipmaps = true;
    }

    if (genMipmaps) {
      gl.hint(gl.GENERATE_MIPMAP_HINT, gl.NICEST);
      gl.generateMipmap(gl.TEXTURE_CUBE_MAP);
      this._genMipmaps = true;
    }

    this._setTexInfo();

    this._device._restoreTexture(0);
  }
  /**
   * @method updateSubImage
   * @param {Object} options
   * @param {Number} options.x
   * @param {Number} options.y
   * @param {Number} options.width
   * @param {Number} options.height
   * @param {Number} options.level
   * @param {Number} options.faceIndex
   * @param {HTMLCanvasElement | HTMLImageElement | HTMLVideoElement | ArrayBufferView} options.image
   * @param {Boolean} options.flipY
   * @param {Boolean} options.premultiplyAlpha
   */
  ;

  _proto.updateSubImage = function updateSubImage(options) {
    var gl = this._device._gl;
    var glFmt = (0, _enums.glTextureFmt)(this._format);
    gl.activeTexture(gl.TEXTURE0);
    gl.bindTexture(gl.TEXTURE_CUBE_MAP, this._glID);

    this._setSubImage(glFmt, options);

    this._device._restoreTexture(0);
  }
  /**
   * @method updateImage
   * @param {Object} options
   * @param {Number} options.width
   * @param {Number} options.height
   * @param {Number} options.level
   * @param {Number} options.faceIndex
   * @param {HTMLCanvasElement | HTMLImageElement | HTMLVideoElement | ArrayBufferView} options.image
   * @param {Boolean} options.flipY
   * @param {Boolean} options.premultiplyAlpha
   */
  ;

  _proto.updateImage = function updateImage(options) {
    var gl = this._device._gl;
    var glFmt = (0, _enums.glTextureFmt)(this._format);
    gl.activeTexture(gl.TEXTURE0);
    gl.bindTexture(gl.TEXTURE_CUBE_MAP, this._glID);

    this._setImage(glFmt, options);

    this._device._restoreTexture(0);
  };

  _proto._setSubImage = function _setSubImage(glFmt, options) {
    var gl = this._device._gl;
    var flipY = options.flipY;
    var premultiplyAlpha = options.premultiplyAlpha;
    var faceIndex = options.faceIndex;
    var img = options.image;

    if (flipY === undefined) {
      gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, false);
    } else {
      gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, flipY);
    }

    if (premultiplyAlpha === undefined) {
      gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
    } else {
      gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, premultiplyAlpha);
    }

    if (img && !ArrayBuffer.isView(img) && !(img instanceof ArrayBuffer)) {
      gl.texSubImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, options.level, options.x, options.y, glFmt.format, glFmt.pixelType, img);
    } else {
      if (this._compressed) {
        gl.compressedTexSubImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, options.level, options.x, options.y, options.width, options.height, glFmt.format, img);
      } else {
        gl.texSubImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, options.level, options.x, options.y, options.width, options.height, glFmt.format, glFmt.pixelType, img);
      }
    }
  };

  _proto._setImage = function _setImage(glFmt, options) {
    var gl = this._device._gl;
    var flipY = options.flipY;
    var premultiplyAlpha = options.premultiplyAlpha;
    var faceIndex = options.faceIndex;
    var img = options.image;

    if (flipY === undefined) {
      gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, false);
    } else {
      gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, flipY);
    }

    if (premultiplyAlpha === undefined) {
      gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
    } else {
      gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, premultiplyAlpha);
    }

    if (img && !ArrayBuffer.isView(img) && !(img instanceof ArrayBuffer)) {
      gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, options.level, glFmt.internalFormat, glFmt.format, glFmt.pixelType, img);
    } else {
      if (this._compressed) {
        gl.compressedTexImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, options.level, glFmt.internalFormat, options.width, options.height, 0, img);
      } else {
        gl.texImage2D(gl.TEXTURE_CUBE_MAP_POSITIVE_X + faceIndex, options.level, glFmt.internalFormat, options.width, options.height, 0, glFmt.format, glFmt.pixelType, img);
      }
    }
  } // levelImages = [imagePosX, imageNegX, imagePosY, imageNegY, imagePosZ, imageNegz]
  // images = [levelImages0, levelImages1, ...]
  ;

  _proto._setMipmap = function _setMipmap(images, flipY, premultiplyAlpha) {
    var glFmt = (0, _enums.glTextureFmt)(this._format);
    var options = {
      width: this._width,
      height: this._height,
      faceIndex: 0,
      flipY: flipY,
      premultiplyAlpha: premultiplyAlpha,
      level: 0,
      image: null
    };

    for (var i = 0; i < images.length; ++i) {
      var levelImages = images[i];
      options.level = i;
      options.width = this._width >> i;
      options.height = this._height >> i;

      for (var face = 0; face < 6; ++face) {
        options.faceIndex = face;
        options.image = levelImages[face];

        this._setImage(glFmt, options);
      }
    }
  };

  _proto._setTexInfo = function _setTexInfo() {
    var gl = this._device._gl;
    var pot = (0, _misc.isPow2)(this._width) && (0, _misc.isPow2)(this._height); // WebGL1 doesn't support all wrap modes with NPOT textures

    if (!pot && (this._wrapS !== _enums.enums.WRAP_CLAMP || this._wrapT !== _enums.enums.WRAP_CLAMP)) {
      console.warn('WebGL1 doesn\'t support all wrap modes with NPOT textures');
      this._wrapS = _enums.enums.WRAP_CLAMP;
      this._wrapT = _enums.enums.WRAP_CLAMP;
    }

    var mipFilter = this._genMipmaps ? this._mipFilter : -1;

    if (!pot && mipFilter !== -1) {
      console.warn('NPOT textures do not support mipmap filter');
      mipFilter = -1;
    }

    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MIN_FILTER, (0, _enums.glFilter)(gl, this._minFilter, mipFilter));
    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_MAG_FILTER, (0, _enums.glFilter)(gl, this._magFilter, -1));
    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_S, this._wrapS);
    gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_T, this._wrapT); // wrapR available in webgl2
    // gl.texParameteri(gl.TEXTURE_CUBE_MAP, gl.TEXTURE_WRAP_R, this._wrapR);

    var ext = this._device.ext('EXT_texture_filter_anisotropic');

    if (ext) {
      gl.texParameteri(gl.TEXTURE_CUBE_MAP, ext.TEXTURE_MAX_ANISOTROPY_EXT, this._anisotropy);
    }
  };

  return TextureCube;
}(_texture["default"]);

exports["default"] = TextureCube;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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