
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/gfx/texture-2d.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _texture = _interopRequireDefault(require("./texture"));

var _enums = require("./enums");

var _misc = require("./misc");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

/**
 * @typedef {HTMLImageElement | HTMLCanvasElement} HTMLImageSource
 * @typedef {HTMLImageSource | ArrayBufferView} ImageSource
 * @typedef {{width?: number, height?: number, minFilter?: number, magFilter?: number, mipFilter?: number, wrapS?: number, wrapT?: number, format?: number, genMipmaps?: boolean, images?: ImageSource[], image?: ImageSource, flipY?: boolean, premultiplyAlpha?: boolean, anisotropy?: number}} TextureUpdateOpts
 * @typedef {import("../gfx/device").default} Device
 */
var Texture2D =
/*#__PURE__*/
function (_Texture) {
  _inheritsLoose(Texture2D, _Texture);

  /**
   * @constructor
   * @param {Device} device
   * @param {TextureUpdateOpts} options
   */
  function Texture2D(device, options) {
    var _this;

    _this = _Texture.call(this, device) || this;
    var gl = _this._device._gl;
    _this._target = gl.TEXTURE_2D;
    _this._glID = gl.createTexture(); // always alloc texture in GPU when we create it.

    options.images = options.images || [null];

    _this.update(options);

    return _this;
  }
  /**
   * @method update
   * @param {TextureUpdateOpts} options
   */


  var _proto = Texture2D.prototype;

  _proto.update = function update(options) {
    var gl = this._device._gl;
    var genMipmaps = this._genMipmap;

    if (options) {
      if (options.width !== undefined) {
        this._width = options.width;
      }

      if (options.height !== undefined) {
        this._height = options.height;
      }

      if (options.anisotropy !== undefined) {
        this._anisotropy = options.anisotropy;
      }

      if (options.minFilter !== undefined) {
        this._minFilter = options.minFilter;
      }

      if (options.magFilter !== undefined) {
        this._magFilter = options.magFilter;
      }

      if (options.mipFilter !== undefined) {
        this._mipFilter = options.mipFilter;
      }

      if (options.wrapS !== undefined) {
        this._wrapS = options.wrapS;
      }

      if (options.wrapT !== undefined) {
        this._wrapT = options.wrapT;
      }

      if (options.format !== undefined) {
        this._format = options.format;
        this._compressed = this._format >= _enums.enums.TEXTURE_FMT_RGB_DXT1 && this._format <= _enums.enums.TEXTURE_FMT_RGBA_PVRTC_4BPPV1 || this._format >= _enums.enums.TEXTURE_FMT_RGB_ETC2 && this._format <= _enums.enums.TEXTURE_FMT_RGBA_ETC2;
      } // check if generate mipmap


      if (options.genMipmaps !== undefined) {
        this._genMipmap = options.genMipmaps;
        genMipmaps = options.genMipmaps;
      }

      var maxSize = this._device.caps.maxTextureSize || Number.MAX_VALUE;
      var textureMaxSize = Math.max(options.width || 0, options.height || 0);
      if (maxSize < textureMaxSize) console.warn("The current texture size " + textureMaxSize + " exceeds the maximum size [" + maxSize + "] supported on the device.");

      if (options.images !== undefined) {
        if (options.images.length > 1) {
          genMipmaps = false;
          var maxLength = options.width > options.height ? options.width : options.height;

          if (maxLength >> options.images.length - 1 !== 1) {
            console.error('texture-2d mipmap is invalid, should have a 1x1 mipmap.');
          }
        }
      }
    } // NOTE: get pot after this._width, this._height has been assigned.


    var pot = (0, _misc.isPow2)(this._width) && (0, _misc.isPow2)(this._height);

    if (!pot) {
      genMipmaps = false;
    }

    gl.activeTexture(gl.TEXTURE0);
    gl.bindTexture(gl.TEXTURE_2D, this._glID);

    if (options.images !== undefined && options.images.length > 0) {
      this._setMipmap(options.images, options.flipY, options.premultiplyAlpha);

      if (options.images.length > 1) this._genMipmap = true;
    }

    if (genMipmaps) {
      gl.hint(gl.GENERATE_MIPMAP_HINT, gl.NICEST);
      gl.generateMipmap(gl.TEXTURE_2D);
      this._genMipmap = true;
    }

    this._setTexInfo();

    this._device._restoreTexture(0);
  }
  /**
   * @method updateSubImage
   * @param {Object} options
   * @param {Number} options.x
   * @param {Number} options.y
   * @param {Number} options.width
   * @param {Number} options.height
   * @param {Number} options.level
   * @param {HTMLCanvasElement | HTMLImageElement | HTMLVideoElement | ArrayBufferView} options.image
   * @param {Boolean} options.flipY
   * @param {Boolean} options.premultiplyAlpha
   */
  ;

  _proto.updateSubImage = function updateSubImage(options) {
    var gl = this._device._gl;
    var glFmt = (0, _enums.glTextureFmt)(this._format);
    gl.activeTexture(gl.TEXTURE0);
    gl.bindTexture(gl.TEXTURE_2D, this._glID);

    this._setSubImage(glFmt, options);

    this._device._restoreTexture(0);
  }
  /**
   * @method updateImage
   * @param {Object} options
   * @param {Number} options.width
   * @param {Number} options.height
   * @param {Number} options.level
   * @param {HTMLCanvasElement | HTMLImageElement | HTMLVideoElement | ArrayBufferView} options.image
   * @param {Boolean} options.flipY
   * @param {Boolean} options.premultiplyAlpha
   */
  ;

  _proto.updateImage = function updateImage(options) {
    var gl = this._device._gl;
    var glFmt = (0, _enums.glTextureFmt)(this._format);
    gl.activeTexture(gl.TEXTURE0);
    gl.bindTexture(gl.TEXTURE_2D, this._glID);

    this._setImage(glFmt, options);

    this._device._restoreTexture(0);
  };

  _proto._setSubImage = function _setSubImage(glFmt, options) {
    var gl = this._device._gl;
    var flipY = options.flipY;
    var premultiplyAlpha = options.premultiplyAlpha;
    var img = options.image;

    if (img && !ArrayBuffer.isView(img) && !(img instanceof ArrayBuffer)) {
      if (flipY === undefined) {
        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);
      } else {
        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, flipY);
      }

      if (premultiplyAlpha === undefined) {
        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
      } else {
        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, premultiplyAlpha);
      }

      gl.texSubImage2D(gl.TEXTURE_2D, options.level, options.x, options.y, glFmt.format, glFmt.pixelType, img);
    } else {
      if (flipY === undefined) {
        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, false);
      } else {
        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, flipY);
      }

      if (premultiplyAlpha === undefined) {
        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
      } else {
        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, premultiplyAlpha);
      }

      if (this._compressed) {
        gl.compressedTexSubImage2D(gl.TEXTURE_2D, options.level, options.x, options.y, options.width, options.height, glFmt.format, img);
      } else {
        gl.texSubImage2D(gl.TEXTURE_2D, options.level, options.x, options.y, options.width, options.height, glFmt.format, glFmt.pixelType, img);
      }
    }
  };

  _proto._setImage = function _setImage(glFmt, options) {
    var gl = this._device._gl;
    var flipY = options.flipY;
    var premultiplyAlpha = options.premultiplyAlpha;
    var img = options.image;

    if (img && !ArrayBuffer.isView(img) && !(img instanceof ArrayBuffer)) {
      if (flipY === undefined) {
        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);
      } else {
        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, flipY);
      }

      if (premultiplyAlpha === undefined) {
        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
      } else {
        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, premultiplyAlpha);
      }

      gl.texImage2D(gl.TEXTURE_2D, options.level, glFmt.internalFormat, glFmt.format, glFmt.pixelType, img);
    } else {
      if (flipY === undefined) {
        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, false);
      } else {
        gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, flipY);
      }

      if (premultiplyAlpha === undefined) {
        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, false);
      } else {
        gl.pixelStorei(gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL, premultiplyAlpha);
      }

      if (this._compressed) {
        gl.compressedTexImage2D(gl.TEXTURE_2D, options.level, glFmt.internalFormat, options.width, options.height, 0, img);
      } else {
        gl.texImage2D(gl.TEXTURE_2D, options.level, glFmt.internalFormat, options.width, options.height, 0, glFmt.format, glFmt.pixelType, img);
      }
    }
  };

  _proto._setMipmap = function _setMipmap(images, flipY, premultiplyAlpha) {
    var glFmt = (0, _enums.glTextureFmt)(this._format);
    var options = {
      width: this._width,
      height: this._height,
      flipY: flipY,
      premultiplyAlpha: premultiplyAlpha,
      level: 0,
      image: null
    };

    for (var i = 0; i < images.length; ++i) {
      options.level = i;
      options.width = this._width >> i;
      options.height = this._height >> i;
      options.image = images[i];

      this._setImage(glFmt, options);
    }
  };

  _proto._setTexInfo = function _setTexInfo() {
    var gl = this._device._gl;
    var pot = (0, _misc.isPow2)(this._width) && (0, _misc.isPow2)(this._height); // WebGL1 doesn't support all wrap modes with NPOT textures

    if (!pot && (this._wrapS !== _enums.enums.WRAP_CLAMP || this._wrapT !== _enums.enums.WRAP_CLAMP)) {
      console.warn('WebGL1 doesn\'t support all wrap modes with NPOT textures');
      this._wrapS = _enums.enums.WRAP_CLAMP;
      this._wrapT = _enums.enums.WRAP_CLAMP;
    }

    var mipFilter = this._genMipmap ? this._mipFilter : -1;

    if (!pot && mipFilter !== -1) {
      console.warn('NPOT textures do not support mipmap filter');
      mipFilter = -1;
    }

    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, (0, _enums.glFilter)(gl, this._minFilter, mipFilter));
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, (0, _enums.glFilter)(gl, this._magFilter, -1));
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, this._wrapS);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, this._wrapT);

    var ext = this._device.ext('EXT_texture_filter_anisotropic');

    if (ext) {
      gl.texParameteri(gl.TEXTURE_2D, ext.TEXTURE_MAX_ANISOTROPY_EXT, this._anisotropy);
    }
  };

  return Texture2D;
}(_texture["default"]);

exports["default"] = Texture2D;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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