
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/gfx/state.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _enums = require("./enums");

var _default = {
  // blend
  blend: false,
  blendSep: false,
  blendColor: 0xffffffff,
  blendEq: _enums.enums.BLEND_FUNC_ADD,
  blendAlphaEq: _enums.enums.BLEND_FUNC_ADD,
  blendSrc: _enums.enums.BLEND_ONE,
  blendDst: _enums.enums.BLEND_ZERO,
  blendSrcAlpha: _enums.enums.BLEND_ONE,
  blendDstAlpha: _enums.enums.BLEND_ZERO,
  // depth
  depthTest: false,
  depthWrite: false,
  depthFunc: _enums.enums.DS_FUNC_LESS,
  // stencil
  stencilTest: false,
  stencilSep: false,
  stencilFuncFront: _enums.enums.DS_FUNC_ALWAYS,
  stencilRefFront: 0,
  stencilMaskFront: 0xff,
  stencilFailOpFront: _enums.enums.STENCIL_OP_KEEP,
  stencilZFailOpFront: _enums.enums.STENCIL_OP_KEEP,
  stencilZPassOpFront: _enums.enums.STENCIL_OP_KEEP,
  stencilWriteMaskFront: 0xff,
  stencilFuncBack: _enums.enums.DS_FUNC_ALWAYS,
  stencilRefBack: 0,
  stencilMaskBack: 0xff,
  stencilFailOpBack: _enums.enums.STENCIL_OP_KEEP,
  stencilZFailOpBack: _enums.enums.STENCIL_OP_KEEP,
  stencilZPassOpBack: _enums.enums.STENCIL_OP_KEEP,
  stencilWriteMaskBack: 0xff,
  // cull-mode
  cullMode: _enums.enums.CULL_BACK,
  // primitive-type
  primitiveType: _enums.enums.PT_TRIANGLES,
  // bindings
  maxStream: -1,
  vertexBuffers: [],
  vertexBufferOffsets: [],
  indexBuffer: null,
  maxTextureSlot: -1,
  textureUnits: [],
  program: null
};

var State =
/*#__PURE__*/
function () {
  function State(device) {
    // bindings
    this.vertexBuffers = new Array(device._caps.maxVertexStreams);
    this.vertexBufferOffsets = new Array(device._caps.maxVertexStreams);
    this.textureUnits = new Array(device._caps.maxTextureUnits);
    this.set(_default);
  }

  State.initDefault = function initDefault(device) {
    _default.vertexBuffers = new Array(device._caps.maxVertexStreams);
    _default.vertexBufferOffsets = new Array(device._caps.maxVertexStreams);
    _default.textureUnits = new Array(device._caps.maxTextureUnits);
  };

  var _proto = State.prototype;

  _proto.reset = function reset() {
    this.set(_default);
  };

  _proto.set = function set(cpy) {
    // blending
    this.blend = cpy.blend;
    this.blendSep = cpy.blendSep;
    this.blendColor = cpy.blendColor;
    this.blendEq = cpy.blendEq;
    this.blendAlphaEq = cpy.blendAlphaEq;
    this.blendSrc = cpy.blendSrc;
    this.blendDst = cpy.blendDst;
    this.blendSrcAlpha = cpy.blendSrcAlpha;
    this.blendDstAlpha = cpy.blendDstAlpha; // depth

    this.depthTest = cpy.depthTest;
    this.depthWrite = cpy.depthWrite;
    this.depthFunc = cpy.depthFunc; // stencil

    this.stencilTest = cpy.stencilTest;
    this.stencilSep = cpy.stencilSep;
    this.stencilFuncFront = cpy.stencilFuncFront;
    this.stencilRefFront = cpy.stencilRefFront;
    this.stencilMaskFront = cpy.stencilMaskFront;
    this.stencilFailOpFront = cpy.stencilFailOpFront;
    this.stencilZFailOpFront = cpy.stencilZFailOpFront;
    this.stencilZPassOpFront = cpy.stencilZPassOpFront;
    this.stencilWriteMaskFront = cpy.stencilWriteMaskFront;
    this.stencilFuncBack = cpy.stencilFuncBack;
    this.stencilRefBack = cpy.stencilRefBack;
    this.stencilMaskBack = cpy.stencilMaskBack;
    this.stencilFailOpBack = cpy.stencilFailOpBack;
    this.stencilZFailOpBack = cpy.stencilZFailOpBack;
    this.stencilZPassOpBack = cpy.stencilZPassOpBack;
    this.stencilWriteMaskBack = cpy.stencilWriteMaskBack; // cull-mode

    this.cullMode = cpy.cullMode; // primitive-type

    this.primitiveType = cpy.primitiveType; // buffer bindings

    this.maxStream = cpy.maxStream;

    for (var i = 0; i < cpy.vertexBuffers.length; ++i) {
      this.vertexBuffers[i] = cpy.vertexBuffers[i];
    }

    for (var _i = 0; _i < cpy.vertexBufferOffsets.length; ++_i) {
      this.vertexBufferOffsets[_i] = cpy.vertexBufferOffsets[_i];
    }

    this.indexBuffer = cpy.indexBuffer; // texture bindings

    this.maxTextureSlot = cpy.maxTextureSlot;

    for (var _i2 = 0; _i2 < cpy.textureUnits.length; ++_i2) {
      this.textureUnits[_i2] = cpy.textureUnits[_i2];
    }

    this.program = cpy.program;
  };

  return State;
}();

exports["default"] = State;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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