
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/gfx/program.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var _genID = 0;

function _parseError(out, type, errorLog) {
  errorLog.split('\n').forEach(function (msg) {
    if (msg.length < 5) {
      return;
    }

    var parts = /^ERROR:\s+(\d+):(\d+):\s*(.*)$/.exec(msg);

    if (parts) {
      out.push({
        type: type,
        fileID: parts[1] | 0,
        line: parts[2] | 0,
        message: parts[3].trim()
      });
    } else if (msg.length > 0) {
      out.push({
        type: type,
        fileID: -1,
        line: 0,
        message: msg
      });
    }
  });
}

var Program =
/*#__PURE__*/
function () {
  /**
   * @param {ef.GraphicsDevice} device - graphic device
   * @param {object} options - shader definition
   * @param {string} options.vert - vertex shader source code
   * @param {string} options.frag - fragment shader shader source code
   * @example
   * let prog = new Program(device, {
   *   vert: `
   *     attribute vec3 a_position;
   *     void main() {
   *       gl_Position = vec4( a_position, 1.0 );
   *     }
   *   `,
   *   frag: `
   *     precision mediump float;
   *     void main() {
   *       gl_FragColor = vec4( 1.0, 1.0, 1.0, 1.0 );
   *     }
   *   `
   * });
   */
  function Program(device, options) {
    this._device = device; // stores gl information: { location, type }

    this._attributes = [];
    this._uniforms = [];
    this._samplers = [];
    this._errors = [];
    this._linked = false;
    this._vertSource = options.vert;
    this._fragSource = options.frag;
    this._glID = null;
    this._id = _genID++;
  }

  var _proto = Program.prototype;

  _proto.link = function link() {
    if (this._linked) {
      return;
    }

    var gl = this._device._gl;

    var vertShader = _createShader(gl, gl.VERTEX_SHADER, this._vertSource);

    var fragShader = _createShader(gl, gl.FRAGMENT_SHADER, this._fragSource);

    var program = gl.createProgram();
    gl.attachShader(program, vertShader);
    gl.attachShader(program, fragShader);
    gl.linkProgram(program);
    var failed = false;
    var errors = this._errors;

    if (!gl.getShaderParameter(vertShader, gl.COMPILE_STATUS)) {
      _parseError(errors, 'vs', gl.getShaderInfoLog(vertShader));

      failed = true;
    }

    if (!gl.getShaderParameter(fragShader, gl.COMPILE_STATUS)) {
      _parseError(errors, 'fs', gl.getShaderInfoLog(fragShader));

      failed = true;
    }

    gl.deleteShader(vertShader);
    gl.deleteShader(fragShader);

    if (failed) {
      return errors;
    }

    if (!gl.getProgramParameter(program, gl.LINK_STATUS)) {
      errors.push({
        info: "Failed to link shader program: " + gl.getProgramInfoLog(program)
      });
      return errors;
    }

    this._glID = program; // parse attribute

    var numAttributes = gl.getProgramParameter(program, gl.ACTIVE_ATTRIBUTES);

    for (var i = 0; i < numAttributes; ++i) {
      var info = gl.getActiveAttrib(program, i);
      var location = gl.getAttribLocation(program, info.name);

      this._attributes.push({
        name: info.name,
        location: location,
        type: info.type
      });
    } // parse uniform


    var numUniforms = gl.getProgramParameter(program, gl.ACTIVE_UNIFORMS);

    for (var _i = 0; _i < numUniforms; ++_i) {
      var _info = gl.getActiveUniform(program, _i);

      var name = _info.name;

      var _location = gl.getUniformLocation(program, name);

      var isArray = name.substr(name.length - 3) === '[0]';

      if (isArray) {
        name = name.substr(0, name.length - 3);
      }

      var uniform = {
        name: name,
        location: _location,
        type: _info.type,
        size: isArray ? _info.size : undefined // used when uniform is an array

      };

      this._uniforms.push(uniform);
    }

    this._linked = true;
  };

  _proto.destroy = function destroy() {
    var gl = this._device._gl;
    gl.deleteProgram(this._glID);
    this._linked = false;
    this._glID = null;
    this._attributes = [];
    this._uniforms = [];
    this._samplers = [];
  };

  _createClass(Program, [{
    key: "id",
    get: function get() {
      return this._id;
    }
  }]);

  return Program;
}(); // ====================
// internal
// ====================


exports["default"] = Program;

function _createShader(gl, type, src) {
  var shader = gl.createShader(type);
  gl.shaderSource(shader, src);
  gl.compileShader(shader);
  return shader;
}

module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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