
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/gfx/index-buffer.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _enums = require("./enums");

var _BYTES_PER_INDEX;

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var BYTES_PER_INDEX = (_BYTES_PER_INDEX = {}, _BYTES_PER_INDEX[_enums.enums.INDEX_FMT_UINT8] = 1, _BYTES_PER_INDEX[_enums.enums.INDEX_FMT_UINT16] = 2, _BYTES_PER_INDEX[_enums.enums.INDEX_FMT_UINT32] = 4, _BYTES_PER_INDEX);

var IndexBuffer =
/*#__PURE__*/
function () {
  /**
   * @constructor
   * @param {Device} device
   * @param {INDEX_FMT_*} format
   * @param {USAGE_*} usage
   * @param {ArrayBuffer | Uint8Array} data
   */
  function IndexBuffer(device, format, usage, data) {
    this._device = device;
    this._format = format;
    this._usage = usage;
    this._bytesPerIndex = BYTES_PER_INDEX[format];
    this._bytes = data.byteLength;
    this._numIndices = this._bytes / this._bytesPerIndex;
    this._needExpandDataStore = true; // update

    this._glID = device._gl.createBuffer();
    this.update(0, data); // stats

    device._stats.ib += this._bytes;
  }
  /**
   * @method destroy
   */


  var _proto = IndexBuffer.prototype;

  _proto.destroy = function destroy() {
    if (this._glID === -1) {
      console.error('The buffer already destroyed');
      return;
    }

    var gl = this._device._gl;
    gl.deleteBuffer(this._glID);
    this._device._stats.ib -= this.bytes;
    this._glID = -1;
  }
  /**
   * @method update
   * @param {Number} byteOffset
   * @param {ArrayBuffer} data
   */
  ;

  _proto.update = function update(byteOffset, data) {
    if (this._glID === -1) {
      console.error('The buffer is destroyed');
      return;
    }

    if (data.byteLength === 0) return; // Need to create new buffer object when bytes exceed

    if (byteOffset + data.byteLength > this._bytes) {
      if (byteOffset) {
        // Lost data between [0, byteOffset] which is need for new buffer
        console.error('Failed to update data, bytes exceed.');
        return;
      } else {
        this._needExpandDataStore = true;
        this._bytes = byteOffset + data.byteLength;
        this._numIndices = this._bytes / this._bytesPerIndex;
      }
    }
    /** @type{WebGLRenderingContext} */


    var gl = this._device._gl;
    var glUsage = this._usage;
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this._glID);

    if (this._needExpandDataStore) {
      gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, data, glUsage);
      this._needExpandDataStore = false;
    } else {
      gl.bufferSubData(gl.ELEMENT_ARRAY_BUFFER, byteOffset, data);
    }

    this._device._restoreIndexBuffer();
  };

  _proto.setUsage = function setUsage(usage) {
    this._usage = usage;
  };

  _createClass(IndexBuffer, [{
    key: "count",
    get: function get() {
      return this._numIndices;
    }
  }]);

  return IndexBuffer;
}();

IndexBuffer.BYTES_PER_INDEX = BYTES_PER_INDEX;
var _default = IndexBuffer;
exports["default"] = _default;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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