
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/gfx/frame-buffer.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var FrameBuffer =
/*#__PURE__*/
function () {
  /**
   * @constructor
   * @param {Device} device
   * @param {Number} width
   * @param {Number} height
   * @param {Object} options
   * @param {Array} options.colors
   * @param {RenderBuffer|Texture2D|TextureCube} options.depth
   * @param {RenderBuffer|Texture2D|TextureCube} options.stencil
   * @param {RenderBuffer|Texture2D|TextureCube} options.depthStencil
   */
  function FrameBuffer(device, width, height, options) {
    this._device = device;
    this._width = width;
    this._height = height;
    this._colors = options.colors || [];
    this._depth = options.depth || null;
    this._stencil = options.stencil || null;
    this._depthStencil = options.depthStencil || null;
    this._glID = device._gl.createFramebuffer();
  }
  /**
   * @method destroy
   */


  var _proto = FrameBuffer.prototype;

  _proto.destroy = function destroy() {
    if (this._glID === null) {
      console.error('The frame-buffer already destroyed');
      return;
    }

    var gl = this._device._gl;
    gl.deleteFramebuffer(this._glID);
    this._glID = null;
  };

  _proto.getHandle = function getHandle() {
    return this._glID;
  };

  return FrameBuffer;
}();

exports["default"] = FrameBuffer;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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