
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/gfx/enums.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.attrTypeBytes = attrTypeBytes;
exports.glFilter = glFilter;
exports.glTextureFmt = glTextureFmt;
exports.enums = void 0;
var GL_NEAREST = 9728; // gl.NEAREST

var GL_LINEAR = 9729; // gl.LINEAR

var GL_NEAREST_MIPMAP_NEAREST = 9984; // gl.NEAREST_MIPMAP_NEAREST

var GL_LINEAR_MIPMAP_NEAREST = 9985; // gl.LINEAR_MIPMAP_NEAREST

var GL_NEAREST_MIPMAP_LINEAR = 9986; // gl.NEAREST_MIPMAP_LINEAR

var GL_LINEAR_MIPMAP_LINEAR = 9987; // gl.LINEAR_MIPMAP_LINEAR
// const GL_BYTE = 5120;                  // gl.BYTE

var GL_UNSIGNED_BYTE = 5121; // gl.UNSIGNED_BYTE
// const GL_SHORT = 5122;                 // gl.SHORT

var GL_UNSIGNED_SHORT = 5123; // gl.UNSIGNED_SHORT

var GL_UNSIGNED_INT = 5125; // gl.UNSIGNED_INT

var GL_FLOAT = 5126; // gl.FLOAT

var GL_UNSIGNED_SHORT_5_6_5 = 33635; // gl.UNSIGNED_SHORT_5_6_5

var GL_UNSIGNED_SHORT_4_4_4_4 = 32819; // gl.UNSIGNED_SHORT_4_4_4_4

var GL_UNSIGNED_SHORT_5_5_5_1 = 32820; // gl.UNSIGNED_SHORT_5_5_5_1

var GL_HALF_FLOAT_OES = 36193; // gl.HALF_FLOAT_OES

var GL_DEPTH_COMPONENT = 6402; // gl.DEPTH_COMPONENT

var GL_ALPHA = 6406; // gl.ALPHA

var GL_RGB = 6407; // gl.RGB

var GL_RGBA = 6408; // gl.RGBA

var GL_LUMINANCE = 6409; // gl.LUMINANCE

var GL_LUMINANCE_ALPHA = 6410; // gl.LUMINANCE_ALPHA

var GL_COMPRESSED_RGB_S3TC_DXT1_EXT = 0x83F0; // ext.COMPRESSED_RGB_S3TC_DXT1_EXT

var GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = 0x83F1; // ext.COMPRESSED_RGBA_S3TC_DXT1_EXT

var GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = 0x83F2; // ext.COMPRESSED_RGBA_S3TC_DXT3_EXT

var GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = 0x83F3; // ext.COMPRESSED_RGBA_S3TC_DXT5_EXT

var GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG = 0x8C00; // ext.COMPRESSED_RGB_PVRTC_4BPPV1_IMG

var GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG = 0x8C01; // ext.COMPRESSED_RGB_PVRTC_2BPPV1_IMG

var GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG = 0x8C02; // ext.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG

var GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG = 0x8C03; // ext.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG

var GL_COMPRESSED_RGB_ETC1_WEBGL = 0x8D64; // ext.COMPRESSED_RGB_ETC1_WEBGL

var GL_COMPRESSED_RGB8_ETC2 = 0x9274; // ext.COMPRESSED_RGB8_ETC2

var GL_COMPRESSED_RGBA8_ETC2_EAC = 0x9278; // ext.COMPRESSED_RGBA8_ETC2_EAC

var _filterGL = [[GL_NEAREST, GL_NEAREST_MIPMAP_NEAREST, GL_NEAREST_MIPMAP_LINEAR], [GL_LINEAR, GL_LINEAR_MIPMAP_NEAREST, GL_LINEAR_MIPMAP_LINEAR]];
var _textureFmtGL = [// TEXTURE_FMT_RGB_DXT1: 0
{
  format: GL_RGB,
  internalFormat: GL_COMPRESSED_RGB_S3TC_DXT1_EXT,
  pixelType: null
}, // TEXTURE_FMT_RGBA_DXT1: 1
{
  format: GL_RGBA,
  internalFormat: GL_COMPRESSED_RGBA_S3TC_DXT1_EXT,
  pixelType: null
}, // TEXTURE_FMT_RGBA_DXT3: 2
{
  format: GL_RGBA,
  internalFormat: GL_COMPRESSED_RGBA_S3TC_DXT3_EXT,
  pixelType: null
}, // TEXTURE_FMT_RGBA_DXT5: 3
{
  format: GL_RGBA,
  internalFormat: GL_COMPRESSED_RGBA_S3TC_DXT5_EXT,
  pixelType: null
}, // TEXTURE_FMT_RGB_ETC1: 4
{
  format: GL_RGB,
  internalFormat: GL_COMPRESSED_RGB_ETC1_WEBGL,
  pixelType: null
}, // TEXTURE_FMT_RGB_PVRTC_2BPPV1: 5
{
  format: GL_RGB,
  internalFormat: GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG,
  pixelType: null
}, // TEXTURE_FMT_RGBA_PVRTC_2BPPV1: 6
{
  format: GL_RGBA,
  internalFormat: GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,
  pixelType: null
}, // TEXTURE_FMT_RGB_PVRTC_4BPPV1: 7
{
  format: GL_RGB,
  internalFormat: GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG,
  pixelType: null
}, // TEXTURE_FMT_RGBA_PVRTC_4BPPV1: 8
{
  format: GL_RGBA,
  internalFormat: GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,
  pixelType: null
}, // TEXTURE_FMT_A8: 9
{
  format: GL_ALPHA,
  internalFormat: GL_ALPHA,
  pixelType: GL_UNSIGNED_BYTE
}, // TEXTURE_FMT_L8: 10
{
  format: GL_LUMINANCE,
  internalFormat: GL_LUMINANCE,
  pixelType: GL_UNSIGNED_BYTE
}, // TEXTURE_FMT_L8_A8: 11
{
  format: GL_LUMINANCE_ALPHA,
  internalFormat: GL_LUMINANCE_ALPHA,
  pixelType: GL_UNSIGNED_BYTE
}, // TEXTURE_FMT_R5_G6_B5: 12
{
  format: GL_RGB,
  internalFormat: GL_RGB,
  pixelType: GL_UNSIGNED_SHORT_5_6_5
}, // TEXTURE_FMT_R5_G5_B5_A1: 13
{
  format: GL_RGBA,
  internalFormat: GL_RGBA,
  pixelType: GL_UNSIGNED_SHORT_5_5_5_1
}, // TEXTURE_FMT_R4_G4_B4_A4: 14
{
  format: GL_RGBA,
  internalFormat: GL_RGBA,
  pixelType: GL_UNSIGNED_SHORT_4_4_4_4
}, // TEXTURE_FMT_RGB8: 15
{
  format: GL_RGB,
  internalFormat: GL_RGB,
  pixelType: GL_UNSIGNED_BYTE
}, // TEXTURE_FMT_RGBA8: 16
{
  format: GL_RGBA,
  internalFormat: GL_RGBA,
  pixelType: GL_UNSIGNED_BYTE
}, // TEXTURE_FMT_RGB16F: 17
{
  format: GL_RGB,
  internalFormat: GL_RGB,
  pixelType: GL_HALF_FLOAT_OES
}, // TEXTURE_FMT_RGBA16F: 18
{
  format: GL_RGBA,
  internalFormat: GL_RGBA,
  pixelType: GL_HALF_FLOAT_OES
}, // TEXTURE_FMT_RGB32F: 19
{
  format: GL_RGB,
  internalFormat: GL_RGB,
  pixelType: GL_FLOAT
}, // TEXTURE_FMT_RGBA32F: 20
{
  format: GL_RGBA,
  internalFormat: GL_RGBA,
  pixelType: GL_FLOAT
}, // TEXTURE_FMT_R32F: 21
{
  format: null,
  internalFormat: null,
  pixelType: null
}, // TEXTURE_FMT_111110F: 22
{
  format: null,
  internalFormat: null,
  pixelType: null
}, // TEXTURE_FMT_SRGB: 23
{
  format: null,
  internalFormat: null,
  pixelType: null
}, // TEXTURE_FMT_SRGBA: 24
{
  format: null,
  internalFormat: null,
  pixelType: null
}, // TEXTURE_FMT_D16: 25
{
  format: GL_DEPTH_COMPONENT,
  internalFormat: GL_DEPTH_COMPONENT,
  pixelType: GL_UNSIGNED_SHORT
}, // TEXTURE_FMT_D32: 26
{
  format: GL_DEPTH_COMPONENT,
  internalFormat: GL_DEPTH_COMPONENT,
  pixelType: GL_UNSIGNED_INT
}, // TEXTURE_FMT_D24S8: 27
{
  format: GL_DEPTH_COMPONENT,
  internalFormat: GL_DEPTH_COMPONENT,
  pixelType: GL_UNSIGNED_INT
}, // TEXTURE_FMT_RGB_ETC2: 28
{
  format: GL_RGB,
  internalFormat: GL_COMPRESSED_RGB8_ETC2,
  pixelType: null
}, // TEXTURE_FMT_RGBA_ETC2: 29
{
  format: GL_RGBA,
  internalFormat: GL_COMPRESSED_RGBA8_ETC2_EAC,
  pixelType: null
}];
/**
 * enums
 */

var enums = {
  // buffer usage
  USAGE_STATIC: 35044,
  // gl.STATIC_DRAW
  USAGE_DYNAMIC: 35048,
  // gl.DYNAMIC_DRAW
  USAGE_STREAM: 35040,
  // gl.STREAM_DRAW
  // index buffer format
  INDEX_FMT_UINT8: 5121,
  // gl.UNSIGNED_BYTE
  INDEX_FMT_UINT16: 5123,
  // gl.UNSIGNED_SHORT
  INDEX_FMT_UINT32: 5125,
  // gl.UNSIGNED_INT (OES_element_index_uint)
  // vertex attribute semantic
  ATTR_POSITION: 'a_position',
  ATTR_NORMAL: 'a_normal',
  ATTR_TANGENT: 'a_tangent',
  ATTR_BITANGENT: 'a_bitangent',
  ATTR_WEIGHTS: 'a_weights',
  ATTR_JOINTS: 'a_joints',
  ATTR_COLOR: 'a_color',
  ATTR_COLOR0: 'a_color0',
  ATTR_COLOR1: 'a_color1',
  ATTR_UV: 'a_uv',
  ATTR_UV0: 'a_uv0',
  ATTR_UV1: 'a_uv1',
  ATTR_UV2: 'a_uv2',
  ATTR_UV3: 'a_uv3',
  ATTR_UV4: 'a_uv4',
  ATTR_UV5: 'a_uv5',
  ATTR_UV6: 'a_uv6',
  ATTR_UV7: 'a_uv7',
  ATTR_TEX_COORD: 'a_texCoord',
  ATTR_TEX_COORD1: 'a_texCoord1',
  ATTR_TEX_COORD2: 'a_texCoord2',
  ATTR_TEX_COORD3: 'a_texCoord3',
  ATTR_TEX_COORD4: 'a_texCoord4',
  ATTR_TEX_COORD5: 'a_texCoord5',
  ATTR_TEX_COORD6: 'a_texCoord6',
  ATTR_TEX_COORD7: 'a_texCoord7',
  ATTR_TEX_COORD8: 'a_texCoord8',
  // vertex attribute type
  ATTR_TYPE_INT8: 5120,
  // gl.BYTE
  ATTR_TYPE_UINT8: 5121,
  // gl.UNSIGNED_BYTE
  ATTR_TYPE_INT16: 5122,
  // gl.SHORT
  ATTR_TYPE_UINT16: 5123,
  // gl.UNSIGNED_SHORT
  ATTR_TYPE_INT32: 5124,
  // gl.INT
  ATTR_TYPE_UINT32: 5125,
  // gl.UNSIGNED_INT
  ATTR_TYPE_FLOAT32: 5126,
  // gl.FLOAT
  // texture filter
  FILTER_NEAREST: 0,
  FILTER_LINEAR: 1,
  // texture wrap mode
  WRAP_REPEAT: 10497,
  // gl.REPEAT
  WRAP_CLAMP: 33071,
  // gl.CLAMP_TO_EDGE
  WRAP_MIRROR: 33648,
  // gl.MIRRORED_REPEAT
  // texture format
  // compress formats
  TEXTURE_FMT_RGB_DXT1: 0,
  TEXTURE_FMT_RGBA_DXT1: 1,
  TEXTURE_FMT_RGBA_DXT3: 2,
  TEXTURE_FMT_RGBA_DXT5: 3,
  TEXTURE_FMT_RGB_ETC1: 4,
  TEXTURE_FMT_RGB_PVRTC_2BPPV1: 5,
  TEXTURE_FMT_RGBA_PVRTC_2BPPV1: 6,
  TEXTURE_FMT_RGB_PVRTC_4BPPV1: 7,
  TEXTURE_FMT_RGBA_PVRTC_4BPPV1: 8,
  // normal formats
  TEXTURE_FMT_A8: 9,
  TEXTURE_FMT_L8: 10,
  TEXTURE_FMT_L8_A8: 11,
  TEXTURE_FMT_R5_G6_B5: 12,
  TEXTURE_FMT_R5_G5_B5_A1: 13,
  TEXTURE_FMT_R4_G4_B4_A4: 14,
  TEXTURE_FMT_RGB8: 15,
  TEXTURE_FMT_RGBA8: 16,
  TEXTURE_FMT_RGB16F: 17,
  TEXTURE_FMT_RGBA16F: 18,
  TEXTURE_FMT_RGB32F: 19,
  TEXTURE_FMT_RGBA32F: 20,
  TEXTURE_FMT_R32F: 21,
  TEXTURE_FMT_111110F: 22,
  TEXTURE_FMT_SRGB: 23,
  TEXTURE_FMT_SRGBA: 24,
  // depth formats
  TEXTURE_FMT_D16: 25,
  TEXTURE_FMT_D32: 26,
  TEXTURE_FMT_D24S8: 27,
  // etc2 format
  TEXTURE_FMT_RGB_ETC2: 28,
  TEXTURE_FMT_RGBA_ETC2: 29,
  // depth and stencil function
  DS_FUNC_NEVER: 512,
  // gl.NEVER
  DS_FUNC_LESS: 513,
  // gl.LESS
  DS_FUNC_EQUAL: 514,
  // gl.EQUAL
  DS_FUNC_LEQUAL: 515,
  // gl.LEQUAL
  DS_FUNC_GREATER: 516,
  // gl.GREATER
  DS_FUNC_NOTEQUAL: 517,
  // gl.NOTEQUAL
  DS_FUNC_GEQUAL: 518,
  // gl.GEQUAL
  DS_FUNC_ALWAYS: 519,
  // gl.ALWAYS
  // render-buffer format
  RB_FMT_RGBA4: 32854,
  // gl.RGBA4
  RB_FMT_RGB5_A1: 32855,
  // gl.RGB5_A1
  RB_FMT_RGB565: 36194,
  // gl.RGB565
  RB_FMT_D16: 33189,
  // gl.DEPTH_COMPONENT16
  RB_FMT_S8: 36168,
  // gl.STENCIL_INDEX8
  RB_FMT_D24S8: 34041,
  // gl.DEPTH_STENCIL
  // blend-equation
  BLEND_FUNC_ADD: 32774,
  // gl.FUNC_ADD
  BLEND_FUNC_SUBTRACT: 32778,
  // gl.FUNC_SUBTRACT
  BLEND_FUNC_REVERSE_SUBTRACT: 32779,
  // gl.FUNC_REVERSE_SUBTRACT
  // blend
  BLEND_ZERO: 0,
  // gl.ZERO
  BLEND_ONE: 1,
  // gl.ONE
  BLEND_SRC_COLOR: 768,
  // gl.SRC_COLOR
  BLEND_ONE_MINUS_SRC_COLOR: 769,
  // gl.ONE_MINUS_SRC_COLOR
  BLEND_DST_COLOR: 774,
  // gl.DST_COLOR
  BLEND_ONE_MINUS_DST_COLOR: 775,
  // gl.ONE_MINUS_DST_COLOR
  BLEND_SRC_ALPHA: 770,
  // gl.SRC_ALPHA
  BLEND_ONE_MINUS_SRC_ALPHA: 771,
  // gl.ONE_MINUS_SRC_ALPHA
  BLEND_DST_ALPHA: 772,
  // gl.DST_ALPHA
  BLEND_ONE_MINUS_DST_ALPHA: 773,
  // gl.ONE_MINUS_DST_ALPHA
  BLEND_CONSTANT_COLOR: 32769,
  // gl.CONSTANT_COLOR
  BLEND_ONE_MINUS_CONSTANT_COLOR: 32770,
  // gl.ONE_MINUS_CONSTANT_COLOR
  BLEND_CONSTANT_ALPHA: 32771,
  // gl.CONSTANT_ALPHA
  BLEND_ONE_MINUS_CONSTANT_ALPHA: 32772,
  // gl.ONE_MINUS_CONSTANT_ALPHA
  BLEND_SRC_ALPHA_SATURATE: 776,
  // gl.SRC_ALPHA_SATURATE
  // stencil operation
  STENCIL_DISABLE: 0,
  // disable stencil
  STENCIL_ENABLE: 1,
  // enable stencil
  STENCIL_INHERIT: 2,
  // inherit stencil states
  STENCIL_OP_KEEP: 7680,
  // gl.KEEP
  STENCIL_OP_ZERO: 0,
  // gl.ZERO
  STENCIL_OP_REPLACE: 7681,
  // gl.REPLACE
  STENCIL_OP_INCR: 7682,
  // gl.INCR
  STENCIL_OP_INCR_WRAP: 34055,
  // gl.INCR_WRAP
  STENCIL_OP_DECR: 7683,
  // gl.DECR
  STENCIL_OP_DECR_WRAP: 34056,
  // gl.DECR_WRAP
  STENCIL_OP_INVERT: 5386,
  // gl.INVERT
  // cull
  CULL_NONE: 0,
  CULL_FRONT: 1028,
  CULL_BACK: 1029,
  CULL_FRONT_AND_BACK: 1032,
  // primitive type
  PT_POINTS: 0,
  // gl.POINTS
  PT_LINES: 1,
  // gl.LINES
  PT_LINE_LOOP: 2,
  // gl.LINE_LOOP
  PT_LINE_STRIP: 3,
  // gl.LINE_STRIP
  PT_TRIANGLES: 4,
  // gl.TRIANGLES
  PT_TRIANGLE_STRIP: 5,
  // gl.TRIANGLE_STRIP
  PT_TRIANGLE_FAN: 6 // gl.TRIANGLE_FAN

};
/**
 * @method attrTypeBytes
 * @param {ATTR_TYPE_*} attrType
 */

exports.enums = enums;

function attrTypeBytes(attrType) {
  if (attrType === enums.ATTR_TYPE_INT8) {
    return 1;
  } else if (attrType === enums.ATTR_TYPE_UINT8) {
    return 1;
  } else if (attrType === enums.ATTR_TYPE_INT16) {
    return 2;
  } else if (attrType === enums.ATTR_TYPE_UINT16) {
    return 2;
  } else if (attrType === enums.ATTR_TYPE_INT32) {
    return 4;
  } else if (attrType === enums.ATTR_TYPE_UINT32) {
    return 4;
  } else if (attrType === enums.ATTR_TYPE_FLOAT32) {
    return 4;
  }

  console.warn("Unknown ATTR_TYPE: " + attrType);
  return 0;
}
/**
 * @method glFilter
 * @param {WebGLContext} gl
 * @param {FILTER_*} filter
 * @param {FILTER_*} mipFilter
 */


function glFilter(gl, filter, mipFilter) {
  if (mipFilter === void 0) {
    mipFilter = -1;
  }

  var result = _filterGL[filter][mipFilter + 1];

  if (result === undefined) {
    console.warn("Unknown FILTER: " + filter);
    return mipFilter === -1 ? gl.LINEAR : gl.LINEAR_MIPMAP_LINEAR;
  }

  return result;
}
/**
 * @method glTextureFmt
 * @param {TEXTURE_FMT_*} fmt
 */


function glTextureFmt(fmt) {
  var result = _textureFmtGL[fmt];

  if (result === undefined) {
    console.warn("Unknown TEXTURE_FMT: " + fmt);
    return _textureFmtGL[enums.TEXTURE_FMT_RGBA8];
  }

  return result;
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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