
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/gfx/device.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _state = _interopRequireDefault(require("./state"));

var _enums = require("./enums");

var _texture2d = _interopRequireDefault(require("./texture-2d"));

var _textureCube = _interopRequireDefault(require("./texture-cube"));

var _type2uniformCommit2, _type2uniformArrayCom;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var GL_INT = 5124;
var GL_FLOAT = 5126;
var GL_FLOAT_VEC2 = 35664;
var GL_FLOAT_VEC3 = 35665;
var GL_FLOAT_VEC4 = 35666;
var GL_INT_VEC2 = 35667;
var GL_INT_VEC3 = 35668;
var GL_INT_VEC4 = 35669;
var GL_BOOL = 35670;
var GL_BOOL_VEC2 = 35671;
var GL_BOOL_VEC3 = 35672;
var GL_BOOL_VEC4 = 35673;
var GL_FLOAT_MAT2 = 35674;
var GL_FLOAT_MAT3 = 35675;
var GL_FLOAT_MAT4 = 35676;
var GL_SAMPLER_2D = 35678;
var GL_SAMPLER_CUBE = 35680;
/**
 * _type2uniformCommit
 */

var _type2uniformCommit = (_type2uniformCommit2 = {}, _type2uniformCommit2[GL_INT] = function (gl, id, value) {
  gl.uniform1i(id, value);
}, _type2uniformCommit2[GL_FLOAT] = function (gl, id, value) {
  gl.uniform1f(id, value);
}, _type2uniformCommit2[GL_FLOAT_VEC2] = function (gl, id, value) {
  gl.uniform2fv(id, value);
}, _type2uniformCommit2[GL_FLOAT_VEC3] = function (gl, id, value) {
  gl.uniform3fv(id, value);
}, _type2uniformCommit2[GL_FLOAT_VEC4] = function (gl, id, value) {
  gl.uniform4fv(id, value);
}, _type2uniformCommit2[GL_INT_VEC2] = function (gl, id, value) {
  gl.uniform2iv(id, value);
}, _type2uniformCommit2[GL_INT_VEC3] = function (gl, id, value) {
  gl.uniform3iv(id, value);
}, _type2uniformCommit2[GL_INT_VEC4] = function (gl, id, value) {
  gl.uniform4iv(id, value);
}, _type2uniformCommit2[GL_BOOL] = function (gl, id, value) {
  gl.uniform1i(id, value);
}, _type2uniformCommit2[GL_BOOL_VEC2] = function (gl, id, value) {
  gl.uniform2iv(id, value);
}, _type2uniformCommit2[GL_BOOL_VEC3] = function (gl, id, value) {
  gl.uniform3iv(id, value);
}, _type2uniformCommit2[GL_BOOL_VEC4] = function (gl, id, value) {
  gl.uniform4iv(id, value);
}, _type2uniformCommit2[GL_FLOAT_MAT2] = function (gl, id, value) {
  gl.uniformMatrix2fv(id, false, value);
}, _type2uniformCommit2[GL_FLOAT_MAT3] = function (gl, id, value) {
  gl.uniformMatrix3fv(id, false, value);
}, _type2uniformCommit2[GL_FLOAT_MAT4] = function (gl, id, value) {
  gl.uniformMatrix4fv(id, false, value);
}, _type2uniformCommit2[GL_SAMPLER_2D] = function (gl, id, value) {
  gl.uniform1i(id, value);
}, _type2uniformCommit2[GL_SAMPLER_CUBE] = function (gl, id, value) {
  gl.uniform1i(id, value);
}, _type2uniformCommit2);
/**
 * _type2uniformArrayCommit
 */


var _type2uniformArrayCommit = (_type2uniformArrayCom = {}, _type2uniformArrayCom[GL_INT] = function (gl, id, value) {
  gl.uniform1iv(id, value);
}, _type2uniformArrayCom[GL_FLOAT] = function (gl, id, value) {
  gl.uniform1fv(id, value);
}, _type2uniformArrayCom[GL_FLOAT_VEC2] = function (gl, id, value) {
  gl.uniform2fv(id, value);
}, _type2uniformArrayCom[GL_FLOAT_VEC3] = function (gl, id, value) {
  gl.uniform3fv(id, value);
}, _type2uniformArrayCom[GL_FLOAT_VEC4] = function (gl, id, value) {
  gl.uniform4fv(id, value);
}, _type2uniformArrayCom[GL_INT_VEC2] = function (gl, id, value) {
  gl.uniform2iv(id, value);
}, _type2uniformArrayCom[GL_INT_VEC3] = function (gl, id, value) {
  gl.uniform3iv(id, value);
}, _type2uniformArrayCom[GL_INT_VEC4] = function (gl, id, value) {
  gl.uniform4iv(id, value);
}, _type2uniformArrayCom[GL_BOOL] = function (gl, id, value) {
  gl.uniform1iv(id, value);
}, _type2uniformArrayCom[GL_BOOL_VEC2] = function (gl, id, value) {
  gl.uniform2iv(id, value);
}, _type2uniformArrayCom[GL_BOOL_VEC3] = function (gl, id, value) {
  gl.uniform3iv(id, value);
}, _type2uniformArrayCom[GL_BOOL_VEC4] = function (gl, id, value) {
  gl.uniform4iv(id, value);
}, _type2uniformArrayCom[GL_FLOAT_MAT2] = function (gl, id, value) {
  gl.uniformMatrix2fv(id, false, value);
}, _type2uniformArrayCom[GL_FLOAT_MAT3] = function (gl, id, value) {
  gl.uniformMatrix3fv(id, false, value);
}, _type2uniformArrayCom[GL_FLOAT_MAT4] = function (gl, id, value) {
  gl.uniformMatrix4fv(id, false, value);
}, _type2uniformArrayCom[GL_SAMPLER_2D] = function (gl, id, value) {
  gl.uniform1iv(id, value);
}, _type2uniformArrayCom[GL_SAMPLER_CUBE] = function (gl, id, value) {
  gl.uniform1iv(id, value);
}, _type2uniformArrayCom);
/**
 * _commitBlendStates
 */


function _commitBlendStates(gl, cur, next) {
  // enable/disable blend
  if (cur.blend !== next.blend) {
    if (!next.blend) {
      gl.disable(gl.BLEND);
      return;
    }

    gl.enable(gl.BLEND);

    if (next.blendSrc === _enums.enums.BLEND_CONSTANT_COLOR || next.blendSrc === _enums.enums.BLEND_ONE_MINUS_CONSTANT_COLOR || next.blendDst === _enums.enums.BLEND_CONSTANT_COLOR || next.blendDst === _enums.enums.BLEND_ONE_MINUS_CONSTANT_COLOR) {
      gl.blendColor((next.blendColor >> 24) / 255, (next.blendColor >> 16 & 0xff) / 255, (next.blendColor >> 8 & 0xff) / 255, (next.blendColor & 0xff) / 255);
    }

    if (next.blendSep) {
      gl.blendFuncSeparate(next.blendSrc, next.blendDst, next.blendSrcAlpha, next.blendDstAlpha);
      gl.blendEquationSeparate(next.blendEq, next.blendAlphaEq);
    } else {
      gl.blendFunc(next.blendSrc, next.blendDst);
      gl.blendEquation(next.blendEq);
    }

    return;
  } // nothing to update


  if (next.blend === false) {
    return;
  } // blend-color


  if (cur.blendColor !== next.blendColor) {
    gl.blendColor((next.blendColor >> 24) / 255, (next.blendColor >> 16 & 0xff) / 255, (next.blendColor >> 8 & 0xff) / 255, (next.blendColor & 0xff) / 255);
  } // separate diff, reset all


  if (cur.blendSep !== next.blendSep) {
    if (next.blendSep) {
      gl.blendFuncSeparate(next.blendSrc, next.blendDst, next.blendSrcAlpha, next.blendDstAlpha);
      gl.blendEquationSeparate(next.blendEq, next.blendAlphaEq);
    } else {
      gl.blendFunc(next.blendSrc, next.blendDst);
      gl.blendEquation(next.blendEq);
    }

    return;
  }

  if (next.blendSep) {
    // blend-func-separate
    if (cur.blendSrc !== next.blendSrc || cur.blendDst !== next.blendDst || cur.blendSrcAlpha !== next.blendSrcAlpha || cur.blendDstAlpha !== next.blendDstAlpha) {
      gl.blendFuncSeparate(next.blendSrc, next.blendDst, next.blendSrcAlpha, next.blendDstAlpha);
    } // blend-equation-separate


    if (cur.blendEq !== next.blendEq || cur.blendAlphaEq !== next.blendAlphaEq) {
      gl.blendEquationSeparate(next.blendEq, next.blendAlphaEq);
    }
  } else {
    // blend-func
    if (cur.blendSrc !== next.blendSrc || cur.blendDst !== next.blendDst) {
      gl.blendFunc(next.blendSrc, next.blendDst);
    } // blend-equation


    if (cur.blendEq !== next.blendEq) {
      gl.blendEquation(next.blendEq);
    }
  }
}
/**
 * _commitDepthStates
 */


function _commitDepthStates(gl, cur, next) {
  // enable/disable depth-test
  if (cur.depthTest !== next.depthTest) {
    if (!next.depthTest) {
      gl.disable(gl.DEPTH_TEST);
      return;
    }

    gl.enable(gl.DEPTH_TEST);
    gl.depthFunc(next.depthFunc);
    gl.depthMask(next.depthWrite);
    return;
  } // commit depth-write


  if (cur.depthWrite !== next.depthWrite) {
    gl.depthMask(next.depthWrite);
  } // check if depth-write enabled


  if (next.depthTest === false) {
    if (next.depthWrite) {
      next.depthTest = true;
      next.depthFunc = _enums.enums.DS_FUNC_ALWAYS;
      gl.enable(gl.DEPTH_TEST);
      gl.depthFunc(next.depthFunc);
    }

    return;
  } // depth-func


  if (cur.depthFunc !== next.depthFunc) {
    gl.depthFunc(next.depthFunc);
  }
}
/**
 * _commitStencilStates
 */


function _commitStencilStates(gl, cur, next) {
  // inherit stencil states
  if (next.stencilTest === _enums.enums.STENCIL_INHERIT) {
    return;
  }

  if (next.stencilTest !== cur.stencilTest) {
    if (next.stencilTest === _enums.enums.STENCIL_DISABLE) {
      gl.disable(gl.STENCIL_TEST);
      return;
    }

    gl.enable(gl.STENCIL_TEST);

    if (next.stencilSep) {
      gl.stencilFuncSeparate(gl.FRONT, next.stencilFuncFront, next.stencilRefFront, next.stencilMaskFront);
      gl.stencilMaskSeparate(gl.FRONT, next.stencilWriteMaskFront);
      gl.stencilOpSeparate(gl.FRONT, next.stencilFailOpFront, next.stencilZFailOpFront, next.stencilZPassOpFront);
      gl.stencilFuncSeparate(gl.BACK, next.stencilFuncBack, next.stencilRefBack, next.stencilMaskBack);
      gl.stencilMaskSeparate(gl.BACK, next.stencilWriteMaskBack);
      gl.stencilOpSeparate(gl.BACK, next.stencilFailOpBack, next.stencilZFailOpBack, next.stencilZPassOpBack);
    } else {
      gl.stencilFunc(next.stencilFuncFront, next.stencilRefFront, next.stencilMaskFront);
      gl.stencilMask(next.stencilWriteMaskFront);
      gl.stencilOp(next.stencilFailOpFront, next.stencilZFailOpFront, next.stencilZPassOpFront);
    }

    return;
  } // fast return


  if (next.stencilTest === _enums.enums.STENCIL_DISABLE) {
    return;
  }

  if (cur.stencilSep !== next.stencilSep) {
    if (next.stencilSep) {
      gl.stencilFuncSeparate(gl.FRONT, next.stencilFuncFront, next.stencilRefFront, next.stencilMaskFront);
      gl.stencilMaskSeparate(gl.FRONT, next.stencilWriteMaskFront);
      gl.stencilOpSeparate(gl.FRONT, next.stencilFailOpFront, next.stencilZFailOpFront, next.stencilZPassOpFront);
      gl.stencilFuncSeparate(gl.BACK, next.stencilFuncBack, next.stencilRefBack, next.stencilMaskBack);
      gl.stencilMaskSeparate(gl.BACK, next.stencilWriteMaskBack);
      gl.stencilOpSeparate(gl.BACK, next.stencilFailOpBack, next.stencilZFailOpBack, next.stencilZPassOpBack);
    } else {
      gl.stencilFunc(next.stencilFuncFront, next.stencilRefFront, next.stencilMaskFront);
      gl.stencilMask(next.stencilWriteMaskFront);
      gl.stencilOp(next.stencilFailOpFront, next.stencilZFailOpFront, next.stencilZPassOpFront);
    }

    return;
  }

  if (next.stencilSep) {
    // front
    if (cur.stencilFuncFront !== next.stencilFuncFront || cur.stencilRefFront !== next.stencilRefFront || cur.stencilMaskFront !== next.stencilMaskFront) {
      gl.stencilFuncSeparate(gl.FRONT, next.stencilFuncFront, next.stencilRefFront, next.stencilMaskFront);
    }

    if (cur.stencilWriteMaskFront !== next.stencilWriteMaskFront) {
      gl.stencilMaskSeparate(gl.FRONT, next.stencilWriteMaskFront);
    }

    if (cur.stencilFailOpFront !== next.stencilFailOpFront || cur.stencilZFailOpFront !== next.stencilZFailOpFront || cur.stencilZPassOpFront !== next.stencilZPassOpFront) {
      gl.stencilOpSeparate(gl.FRONT, next.stencilFailOpFront, next.stencilZFailOpFront, next.stencilZPassOpFront);
    } // back


    if (cur.stencilFuncBack !== next.stencilFuncBack || cur.stencilRefBack !== next.stencilRefBack || cur.stencilMaskBack !== next.stencilMaskBack) {
      gl.stencilFuncSeparate(gl.BACK, next.stencilFuncBack, next.stencilRefBack, next.stencilMaskBack);
    }

    if (cur.stencilWriteMaskBack !== next.stencilWriteMaskBack) {
      gl.stencilMaskSeparate(gl.BACK, next.stencilWriteMaskBack);
    }

    if (cur.stencilFailOpBack !== next.stencilFailOpBack || cur.stencilZFailOpBack !== next.stencilZFailOpBack || cur.stencilZPassOpBack !== next.stencilZPassOpBack) {
      gl.stencilOpSeparate(gl.BACK, next.stencilFailOpBack, next.stencilZFailOpBack, next.stencilZPassOpBack);
    }
  } else {
    if (cur.stencilFuncFront !== next.stencilFuncFront || cur.stencilRefFront !== next.stencilRefFront || cur.stencilMaskFront !== next.stencilMaskFront) {
      gl.stencilFunc(next.stencilFuncFront, next.stencilRefFront, next.stencilMaskFront);
    }

    if (cur.stencilWriteMaskFront !== next.stencilWriteMaskFront) {
      gl.stencilMask(next.stencilWriteMaskFront);
    }

    if (cur.stencilFailOpFront !== next.stencilFailOpFront || cur.stencilZFailOpFront !== next.stencilZFailOpFront || cur.stencilZPassOpFront !== next.stencilZPassOpFront) {
      gl.stencilOp(next.stencilFailOpFront, next.stencilZFailOpFront, next.stencilZPassOpFront);
    }
  }
}
/**
 * _commitCullMode
 */


function _commitCullMode(gl, cur, next) {
  if (cur.cullMode === next.cullMode) {
    return;
  }

  if (next.cullMode === _enums.enums.CULL_NONE) {
    gl.disable(gl.CULL_FACE);
    return;
  }

  gl.enable(gl.CULL_FACE);
  gl.cullFace(next.cullMode);
}
/**
 * _commitVertexBuffers
 */


function _commitVertexBuffers(device, gl, cur, next) {
  var attrsDirty = false; // nothing changed for vertex buffer

  if (next.maxStream === -1) {
    return;
  }

  if (cur.maxStream !== next.maxStream) {
    attrsDirty = true;
  } else if (cur.program !== next.program) {
    attrsDirty = true;
  } else {
    for (var i = 0; i < next.maxStream + 1; ++i) {
      if (cur.vertexBuffers[i] !== next.vertexBuffers[i] || cur.vertexBufferOffsets[i] !== next.vertexBufferOffsets[i]) {
        attrsDirty = true;
        break;
      }
    }
  }

  if (attrsDirty) {
    for (var _i = 0; _i < device._caps.maxVertexAttribs; ++_i) {
      device._newAttributes[_i] = 0;
    }

    for (var _i2 = 0; _i2 < next.maxStream + 1; ++_i2) {
      var vb = next.vertexBuffers[_i2];
      var vbOffset = next.vertexBufferOffsets[_i2];

      if (!vb || vb._glID === -1) {
        continue;
      }

      gl.bindBuffer(gl.ARRAY_BUFFER, vb._glID);

      for (var j = 0; j < next.program._attributes.length; ++j) {
        var attr = next.program._attributes[j];

        var el = vb._format.element(attr.name);

        if (!el) {
          console.warn("Can not find vertex attribute: " + attr.name);
          continue;
        }

        if (device._enabledAttributes[attr.location] === 0) {
          gl.enableVertexAttribArray(attr.location);
          device._enabledAttributes[attr.location] = 1;
        }

        device._newAttributes[attr.location] = 1;
        gl.vertexAttribPointer(attr.location, el.num, el.type, el.normalize, el.stride, el.offset + vbOffset * el.stride);
      }
    } // disable unused attributes


    for (var _i3 = 0; _i3 < device._caps.maxVertexAttribs; ++_i3) {
      if (device._enabledAttributes[_i3] !== device._newAttributes[_i3]) {
        gl.disableVertexAttribArray(_i3);
        device._enabledAttributes[_i3] = 0;
      }
    }
  }
}
/**
 * _commitTextures
 */


function _commitTextures(gl, cur, next) {
  for (var i = 0; i < next.maxTextureSlot + 1; ++i) {
    if (cur.textureUnits[i] !== next.textureUnits[i]) {
      var texture = next.textureUnits[i];

      if (texture && texture._glID !== -1) {
        gl.activeTexture(gl.TEXTURE0 + i);
        gl.bindTexture(texture._target, texture._glID);
      }
    }
  }
}
/**
 * _attach
 */


function _attach(gl, location, attachment, face) {
  if (face === void 0) {
    face = 0;
  }

  if (attachment instanceof _texture2d["default"]) {
    gl.framebufferTexture2D(gl.FRAMEBUFFER, location, gl.TEXTURE_2D, attachment._glID, 0);
  } else if (attachment instanceof _textureCube["default"]) {
    gl.framebufferTexture2D(gl.FRAMEBUFFER, location, gl.TEXTURE_CUBE_MAP_POSITIVE_X + face, attachment._glID, 0);
  } else {
    gl.framebufferRenderbuffer(gl.FRAMEBUFFER, location, gl.RENDERBUFFER, attachment._glID);
  }
}

var Device =
/*#__PURE__*/
function () {
  _createClass(Device, [{
    key: "caps",

    /**
     * @property caps
     */
    get: function get() {
      return this._caps;
    }
    /**
     * @param {HTMLElement} canvasEL
     * @param {object} opts
     */

  }]);

  function Device(canvasEL, opts) {
    var gl; // default options

    opts = opts || {};

    if (opts.alpha === undefined) {
      opts.alpha = false;
    }

    if (opts.stencil === undefined) {
      opts.stencil = true;
    }

    if (opts.depth === undefined) {
      opts.depth = true;
    }

    if (opts.antialias === undefined) {
      opts.antialias = false;
    } // NOTE: it is said the performance improved in mobile device with this flag off.


    if (opts.preserveDrawingBuffer === undefined) {
      opts.preserveDrawingBuffer = false;
    }

    try {
      gl = canvasEL.getContext('webgl', opts) || canvasEL.getContext('experimental-webgl', opts) || canvasEL.getContext('webkit-3d', opts) || canvasEL.getContext('moz-webgl', opts);
    } catch (err) {
      console.error(err);
      return;
    } // No errors are thrown using try catch
    // Tested through ios baidu browser 4.14.1


    if (!gl) {
      console.error('This device does not support webgl');
    } // statics

    /**
     * @type {WebGLRenderingContext}
     */


    this._gl = gl;
    this._extensions = {};
    this._caps = {}; // capability

    this._stats = {
      texture: 0,
      vb: 0,
      ib: 0,
      drawcalls: 0
    }; // https://developer.mozilla.org/zh-CN/docs/Web/API/WebGL_API/Using_Extensions

    this._initExtensions(['EXT_texture_filter_anisotropic', 'EXT_shader_texture_lod', 'OES_standard_derivatives', 'OES_texture_float', 'OES_texture_float_linear', 'OES_texture_half_float', 'OES_texture_half_float_linear', 'OES_vertex_array_object', 'WEBGL_compressed_texture_atc', 'WEBGL_compressed_texture_etc', 'WEBGL_compressed_texture_etc1', 'WEBGL_compressed_texture_pvrtc', 'WEBGL_compressed_texture_s3tc', 'WEBGL_depth_texture', 'WEBGL_draw_buffers']);

    this._initCaps();

    this._initStates(); // runtime


    _state["default"].initDefault(this);

    this._current = new _state["default"](this);
    this._next = new _state["default"](this);
    this._uniforms = {}; // name: { value, num, dirty }

    this._vx = this._vy = this._vw = this._vh = 0;
    this._sx = this._sy = this._sw = this._sh = 0;
    this._framebuffer = null; //

    this._enabledAttributes = new Array(this._caps.maxVertexAttribs);
    this._newAttributes = new Array(this._caps.maxVertexAttribs);

    for (var i = 0; i < this._caps.maxVertexAttribs; ++i) {
      this._enabledAttributes[i] = 0;
      this._newAttributes[i] = 0;
    }
  }

  var _proto = Device.prototype;

  _proto._initExtensions = function _initExtensions(extensions) {
    var gl = this._gl;

    for (var i = 0; i < extensions.length; ++i) {
      var name = extensions[i];
      var vendorPrefixes = ["", "WEBKIT_", "MOZ_"];

      for (var j = 0; j < vendorPrefixes.length; j++) {
        try {
          var ext = gl.getExtension(vendorPrefixes[j] + name);

          if (ext) {
            this._extensions[name] = ext;
            break;
          }
        } catch (e) {
          console.error(e);
        }
      }
    }
  };

  _proto._initCaps = function _initCaps() {
    var gl = this._gl;
    var extDrawBuffers = this.ext('WEBGL_draw_buffers');
    this._caps.maxVertexStreams = 4;
    this._caps.maxVertexTextures = gl.getParameter(gl.MAX_VERTEX_TEXTURE_IMAGE_UNITS);
    this._caps.maxFragUniforms = gl.getParameter(gl.MAX_FRAGMENT_UNIFORM_VECTORS);
    this._caps.maxTextureUnits = gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS);
    this._caps.maxVertexAttribs = gl.getParameter(gl.MAX_VERTEX_ATTRIBS);
    this._caps.maxTextureSize = gl.getParameter(gl.MAX_TEXTURE_SIZE);
    this._caps.maxDrawBuffers = extDrawBuffers ? gl.getParameter(extDrawBuffers.MAX_DRAW_BUFFERS_WEBGL) : 1;
    this._caps.maxColorAttachments = extDrawBuffers ? gl.getParameter(extDrawBuffers.MAX_COLOR_ATTACHMENTS_WEBGL) : 1;
  };

  _proto._initStates = function _initStates() {
    var gl = this._gl; // gl.frontFace(gl.CCW);

    gl.disable(gl.BLEND);
    gl.blendFunc(gl.ONE, gl.ZERO);
    gl.blendEquation(gl.FUNC_ADD);
    gl.blendColor(1, 1, 1, 1);
    gl.colorMask(true, true, true, true);
    gl.enable(gl.CULL_FACE);
    gl.cullFace(gl.BACK);
    gl.disable(gl.DEPTH_TEST);
    gl.depthFunc(gl.LESS);
    gl.depthMask(false);
    gl.disable(gl.POLYGON_OFFSET_FILL);
    gl.depthRange(0, 1);
    gl.disable(gl.STENCIL_TEST);
    gl.stencilFunc(gl.ALWAYS, 0, 0xFF);
    gl.stencilMask(0xFF);
    gl.stencilOp(gl.KEEP, gl.KEEP, gl.KEEP); // TODO:
    // this.setAlphaToCoverage(false);
    // this.setTransformFeedbackBuffer(null);
    // this.setRaster(true);
    // this.setDepthBias(false);

    gl.clearDepth(1);
    gl.clearColor(0, 0, 0, 0);
    gl.clearStencil(0);
    gl.disable(gl.SCISSOR_TEST);
  };

  _proto._restoreTexture = function _restoreTexture(unit) {
    var gl = this._gl;
    var texture = this._current.textureUnits[unit];

    if (texture && texture._glID !== -1) {
      gl.bindTexture(texture._target, texture._glID);
    } else {
      gl.bindTexture(gl.TEXTURE_2D, null);
    }
  };

  _proto._restoreIndexBuffer = function _restoreIndexBuffer() {
    var gl = this._gl;
    var ib = this._current.indexBuffer;

    if (ib && ib._glID !== -1) {
      gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, ib._glID);
    } else {
      gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, null);
    }
  }
  /**
   * @method ext
   * @param {string} name
   */
  ;

  _proto.ext = function ext(name) {
    return this._extensions[name];
  };

  _proto.allowFloatTexture = function allowFloatTexture() {
    return this.ext("OES_texture_float") != null;
  } // ===============================
  // Immediate Settings
  // ===============================

  /**
   * @method setFrameBuffer
   * @param {FrameBuffer} fb - null means use the backbuffer
   */
  ;

  _proto.setFrameBuffer = function setFrameBuffer(fb) {
    if (this._framebuffer === fb) {
      return;
    }

    this._framebuffer = fb;
    var gl = this._gl;

    if (!fb) {
      gl.bindFramebuffer(gl.FRAMEBUFFER, null);
      return;
    }

    gl.bindFramebuffer(gl.FRAMEBUFFER, fb._glID);
    var numColors = fb._colors.length;

    for (var i = 0; i < numColors; ++i) {
      var colorBuffer = fb._colors[i];

      _attach(gl, gl.COLOR_ATTACHMENT0 + i, colorBuffer); // TODO: what about cubemap face??? should be the target parameter for colorBuffer

    }

    for (var _i4 = numColors; _i4 < this._caps.maxColorAttachments; ++_i4) {
      gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0 + _i4, gl.TEXTURE_2D, null, 0);
    }

    if (fb._depth) {
      _attach(gl, gl.DEPTH_ATTACHMENT, fb._depth);
    }

    if (fb._stencil) {
      _attach(gl, gl.STENCIL_ATTACHMENT, fb._stencil);
    }

    if (fb._depthStencil) {
      _attach(gl, gl.DEPTH_STENCIL_ATTACHMENT, fb._depthStencil);
    }
  }
  /**
   * @method setViewport
   * @param {Number} x
   * @param {Number} y
   * @param {Number} w
   * @param {Number} h
   */
  ;

  _proto.setViewport = function setViewport(x, y, w, h) {
    if (this._vx !== x || this._vy !== y || this._vw !== w || this._vh !== h) {
      this._gl.viewport(x, y, w, h);

      this._vx = x;
      this._vy = y;
      this._vw = w;
      this._vh = h;
    }
  }
  /**
   * @method setScissor
   * @param {Number} x
   * @param {Number} y
   * @param {Number} w
   * @param {Number} h
   */
  ;

  _proto.setScissor = function setScissor(x, y, w, h) {
    if (this._sx !== x || this._sy !== y || this._sw !== w || this._sh !== h) {
      this._gl.scissor(x, y, w, h);

      this._sx = x;
      this._sy = y;
      this._sw = w;
      this._sh = h;
    }
  }
  /**
   * @method clear
   * @param {Object} opts
   * @param {Array} opts.color
   * @param {Number} opts.depth
   * @param {Number} opts.stencil
   */
  ;

  _proto.clear = function clear(opts) {
    if (opts.color === undefined && opts.depth === undefined && opts.stencil === undefined) {
      return;
    }

    var gl = this._gl;
    var flags = 0;

    if (opts.color !== undefined) {
      flags |= gl.COLOR_BUFFER_BIT;
      gl.clearColor(opts.color[0], opts.color[1], opts.color[2], opts.color[3]);
    }

    if (opts.depth !== undefined) {
      flags |= gl.DEPTH_BUFFER_BIT;
      gl.clearDepth(opts.depth);
      gl.enable(gl.DEPTH_TEST);
      gl.depthMask(true);
      gl.depthFunc(gl.ALWAYS);
    }

    if (opts.stencil !== undefined) {
      flags |= gl.STENCIL_BUFFER_BIT;
      gl.clearStencil(opts.stencil);
    }

    gl.clear(flags); // restore depth-write

    if (opts.depth !== undefined) {
      if (this._current.depthTest === false) {
        gl.disable(gl.DEPTH_TEST);
      } else {
        if (this._current.depthWrite === false) {
          gl.depthMask(false);
        }

        if (this._current.depthFunc !== _enums.enums.DS_FUNC_ALWAYS) {
          gl.depthFunc(this._current.depthFunc);
        }
      }
    }
  } // ===============================
  // Deferred States
  // ===============================

  /**
   * @method enableBlend
   */
  ;

  _proto.enableBlend = function enableBlend() {
    this._next.blend = true;
  }
  /**
   * @method enableDepthTest
   */
  ;

  _proto.enableDepthTest = function enableDepthTest() {
    this._next.depthTest = true;
  }
  /**
   * @method enableDepthWrite
   */
  ;

  _proto.enableDepthWrite = function enableDepthWrite() {
    this._next.depthWrite = true;
  }
  /**
   * @method enableStencilTest
   * @param {Number} stencilTest
   */
  ;

  _proto.setStencilTest = function setStencilTest(stencilTest) {
    this._next.stencilTest = stencilTest;
  }
  /**
   * @method setStencilFunc
   * @param {DS_FUNC_*} func
   * @param {Number} ref
   * @param {Number} mask
   */
  ;

  _proto.setStencilFunc = function setStencilFunc(func, ref, mask) {
    this._next.stencilSep = false;
    this._next.stencilFuncFront = this._next.stencilFuncBack = func;
    this._next.stencilRefFront = this._next.stencilRefBack = ref;
    this._next.stencilMaskFront = this._next.stencilMaskBack = mask;
  }
  /**
   * @method setStencilFuncFront
   * @param {DS_FUNC_*} func
   * @param {Number} ref
   * @param {Number} mask
   */
  ;

  _proto.setStencilFuncFront = function setStencilFuncFront(func, ref, mask) {
    this._next.stencilSep = true;
    this._next.stencilFuncFront = func;
    this._next.stencilRefFront = ref;
    this._next.stencilMaskFront = mask;
  }
  /**
   * @method setStencilFuncBack
   * @param {DS_FUNC_*} func
   * @param {Number} ref
   * @param {Number} mask
   */
  ;

  _proto.setStencilFuncBack = function setStencilFuncBack(func, ref, mask) {
    this._next.stencilSep = true;
    this._next.stencilFuncBack = func;
    this._next.stencilRefBack = ref;
    this._next.stencilMaskBack = mask;
  }
  /**
   * @method setStencilOp
   * @param {STENCIL_OP_*} failOp
   * @param {STENCIL_OP_*} zFailOp
   * @param {STENCIL_OP_*} zPassOp
   * @param {Number} writeMask
   */
  ;

  _proto.setStencilOp = function setStencilOp(failOp, zFailOp, zPassOp, writeMask) {
    this._next.stencilFailOpFront = this._next.stencilFailOpBack = failOp;
    this._next.stencilZFailOpFront = this._next.stencilZFailOpBack = zFailOp;
    this._next.stencilZPassOpFront = this._next.stencilZPassOpBack = zPassOp;
    this._next.stencilWriteMaskFront = this._next.stencilWriteMaskBack = writeMask;
  }
  /**
   * @method setStencilOpFront
   * @param {STENCIL_OP_*} failOp
   * @param {STENCIL_OP_*} zFailOp
   * @param {STENCIL_OP_*} zPassOp
   * @param {Number} writeMask
   */
  ;

  _proto.setStencilOpFront = function setStencilOpFront(failOp, zFailOp, zPassOp, writeMask) {
    this._next.stencilSep = true;
    this._next.stencilFailOpFront = failOp;
    this._next.stencilZFailOpFront = zFailOp;
    this._next.stencilZPassOpFront = zPassOp;
    this._next.stencilWriteMaskFront = writeMask;
  }
  /**
   * @method setStencilOpBack
   * @param {STENCIL_OP_*} failOp
   * @param {STENCIL_OP_*} zFailOp
   * @param {STENCIL_OP_*} zPassOp
   * @param {Number} writeMask
   */
  ;

  _proto.setStencilOpBack = function setStencilOpBack(failOp, zFailOp, zPassOp, writeMask) {
    this._next.stencilSep = true;
    this._next.stencilFailOpBack = failOp;
    this._next.stencilZFailOpBack = zFailOp;
    this._next.stencilZPassOpBack = zPassOp;
    this._next.stencilWriteMaskBack = writeMask;
  }
  /**
   * @method setDepthFunc
   * @param {DS_FUNC_*} depthFunc
   */
  ;

  _proto.setDepthFunc = function setDepthFunc(depthFunc) {
    this._next.depthFunc = depthFunc;
  }
  /**
   * @method setBlendColor32
   * @param {Number} rgba
   */
  ;

  _proto.setBlendColor32 = function setBlendColor32(rgba) {
    this._next.blendColor = rgba;
  }
  /**
   * @method setBlendColor
   * @param {Number} r
   * @param {Number} g
   * @param {Number} b
   * @param {Number} a
   */
  ;

  _proto.setBlendColor = function setBlendColor(r, g, b, a) {
    this._next.blendColor = (r * 255 << 24 | g * 255 << 16 | b * 255 << 8 | a * 255) >>> 0;
  }
  /**
   * @method setBlendFunc
   * @param {BELND_*} src
   * @param {BELND_*} dst
   */
  ;

  _proto.setBlendFunc = function setBlendFunc(src, dst) {
    this._next.blendSep = false;
    this._next.blendSrc = src;
    this._next.blendDst = dst;
  }
  /**
   * @method setBlendFuncSep
   * @param {BELND_*} src
   * @param {BELND_*} dst
   * @param {BELND_*} srcAlpha
   * @param {BELND_*} dstAlpha
   */
  ;

  _proto.setBlendFuncSep = function setBlendFuncSep(src, dst, srcAlpha, dstAlpha) {
    this._next.blendSep = true;
    this._next.blendSrc = src;
    this._next.blendDst = dst;
    this._next.blendSrcAlpha = srcAlpha;
    this._next.blendDstAlpha = dstAlpha;
  }
  /**
   * @method setBlendEq
   * @param {BELND_FUNC_*} eq
   */
  ;

  _proto.setBlendEq = function setBlendEq(eq) {
    this._next.blendSep = false;
    this._next.blendEq = eq;
  }
  /**
   * @method setBlendEqSep
   * @param {BELND_FUNC_*} eq
   * @param {BELND_FUNC_*} alphaEq
   */
  ;

  _proto.setBlendEqSep = function setBlendEqSep(eq, alphaEq) {
    this._next.blendSep = true;
    this._next.blendEq = eq;
    this._next.blendAlphaEq = alphaEq;
  }
  /**
   * @method setCullMode
   * @param {CULL_*} mode
   */
  ;

  _proto.setCullMode = function setCullMode(mode) {
    this._next.cullMode = mode;
  }
  /**
   * @method setVertexBuffer
   * @param {Number} stream
   * @param {VertexBuffer} buffer
   * @param {Number} start - start vertex
   */
  ;

  _proto.setVertexBuffer = function setVertexBuffer(stream, buffer, start) {
    if (start === void 0) {
      start = 0;
    }

    this._next.vertexBuffers[stream] = buffer;
    this._next.vertexBufferOffsets[stream] = start;

    if (this._next.maxStream < stream) {
      this._next.maxStream = stream;
    }
  }
  /**
   * @method setIndexBuffer
   * @param {IndexBuffer} buffer
   */
  ;

  _proto.setIndexBuffer = function setIndexBuffer(buffer) {
    this._next.indexBuffer = buffer;
  }
  /**
   * @method setProgram
   * @param {Program} program
   */
  ;

  _proto.setProgram = function setProgram(program) {
    this._next.program = program;
  }
  /**
   * @method setTexture
   * @param {String} name
   * @param {Texture} texture
   * @param {Number} slot
   */
  ;

  _proto.setTexture = function setTexture(name, texture, slot) {
    if (slot >= this._caps.maxTextureUnits) {
      console.warn("Can not set texture " + name + " at stage " + slot + ", max texture exceed: " + this._caps.maxTextureUnits);
      return;
    }

    this._next.textureUnits[slot] = texture;
    this.setUniform(name, slot);

    if (this._next.maxTextureSlot < slot) {
      this._next.maxTextureSlot = slot;
    }
  }
  /**
   * @method setTextureArray
   * @param {String} name
   * @param {Array} textures
   * @param {Int32Array} slots
   */
  ;

  _proto.setTextureArray = function setTextureArray(name, textures, slots) {
    var len = textures.length;

    if (len >= this._caps.maxTextureUnits) {
      console.warn("Can not set " + len + " textures for " + name + ", max texture exceed: " + this._caps.maxTextureUnits);
      return;
    }

    for (var i = 0; i < len; ++i) {
      var slot = slots[i];
      this._next.textureUnits[slot] = textures[i];

      if (this._next.maxTextureSlot < slot) {
        this._next.maxTextureSlot = slot;
      }
    }

    this.setUniform(name, slots);
  }
  /**
   * @method setUniform
   * @param {String} name
   * @param {*} value
   */
  ;

  _proto.setUniform = function setUniform(name, value) {
    var uniform = this._uniforms[name];
    var sameType = false;
    var isArray = false,
        isFloat32Array = false,
        isInt32Array = false;

    do {
      if (!uniform) {
        break;
      }

      isFloat32Array = Array.isArray(value) || value instanceof Float32Array;
      isInt32Array = value instanceof Int32Array;
      isArray = isFloat32Array || isInt32Array;

      if (uniform.isArray !== isArray) {
        break;
      }

      if (uniform.isArray && uniform.value.length !== value.length) {
        break;
      }

      sameType = true;
    } while (false);

    if (!sameType) {
      var newValue = value;

      if (isFloat32Array) {
        newValue = new Float32Array(value);
      } else if (isInt32Array) {
        newValue = new Int32Array(value);
      }

      uniform = {
        dirty: true,
        value: newValue,
        isArray: isArray
      };
    } else {
      var oldValue = uniform.value;
      var dirty = false;

      if (uniform.isArray) {
        for (var i = 0, l = oldValue.length; i < l; i++) {
          if (oldValue[i] !== value[i]) {
            dirty = true;
            oldValue[i] = value[i];
          }
        }
      } else {
        if (oldValue !== value) {
          dirty = true;
          uniform.value = value;
        }
      }

      if (dirty) {
        uniform.dirty = true;
      }
    }

    this._uniforms[name] = uniform;
  };

  _proto.setUniformDirectly = function setUniformDirectly(name, value) {
    var uniform = this._uniforms[name];

    if (!uniform) {
      this._uniforms[name] = uniform = {};
    }

    uniform.dirty = true;
    uniform.value = value;
  }
  /**
   * @method setPrimitiveType
   * @param {PT_*} type
   */
  ;

  _proto.setPrimitiveType = function setPrimitiveType(type) {
    this._next.primitiveType = type;
  }
  /**
   * @method resetDrawCalls
   */
  ;

  _proto.resetDrawCalls = function resetDrawCalls() {
    this._stats.drawcalls = 0;
  }
  /**
   * @method getDrawCalls
   */
  ;

  _proto.getDrawCalls = function getDrawCalls() {
    return this._stats.drawcalls;
  }
  /**
   * @method draw
   * @param {Number} base
   * @param {Number} count
   */
  ;

  _proto.draw = function draw(base, count) {
    var gl = this._gl;
    var cur = this._current;
    var next = this._next; // commit blend

    _commitBlendStates(gl, cur, next); // commit depth


    _commitDepthStates(gl, cur, next); // commit stencil


    _commitStencilStates(gl, cur, next); // commit cull


    _commitCullMode(gl, cur, next); // commit vertex-buffer


    _commitVertexBuffers(this, gl, cur, next); // commit index-buffer


    if (cur.indexBuffer !== next.indexBuffer) {
      gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, next.indexBuffer && next.indexBuffer._glID !== -1 ? next.indexBuffer._glID : null);
    } // commit program


    var programDirty = false;

    if (cur.program !== next.program) {
      if (next.program._linked) {
        gl.useProgram(next.program._glID);
      } else {
        console.warn('Failed to use program: has not linked yet.');
      }

      programDirty = true;
    } // commit texture/sampler


    _commitTextures(gl, cur, next); // commit uniforms


    for (var i = 0; i < next.program._uniforms.length; ++i) {
      var uniformInfo = next.program._uniforms[i];
      var uniform = this._uniforms[uniformInfo.name];

      if (!uniform) {
        // console.warn(`Can not find uniform ${uniformInfo.name}`);
        continue;
      }

      if (!programDirty && !uniform.dirty) {
        continue;
      }

      uniform.dirty = false; // TODO: please consider array uniform: uniformInfo.size > 0

      var commitFunc = uniformInfo.size === undefined ? _type2uniformCommit[uniformInfo.type] : _type2uniformArrayCommit[uniformInfo.type];

      if (!commitFunc) {
        console.warn("Can not find commit function for uniform " + uniformInfo.name);
        continue;
      }

      commitFunc(gl, uniformInfo.location, uniform.value);
    }

    if (count) {
      // drawPrimitives
      if (next.indexBuffer) {
        gl.drawElements(this._next.primitiveType, count, next.indexBuffer._format, base * next.indexBuffer._bytesPerIndex);
      } else {
        gl.drawArrays(this._next.primitiveType, base, count);
      } // update stats


      this._stats.drawcalls++;
    } // TODO: autogen mipmap for color buffer
    // if (this._framebuffer && this._framebuffer.colors[0].mipmap) {
    //   gl.bindTexture(this._framebuffer.colors[i]._target, colors[i]._glID);
    //   gl.generateMipmap(this._framebuffer.colors[i]._target);
    // }
    // reset states


    cur.set(next);
    next.reset();
  };

  return Device;
}();

exports["default"] = Device;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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