
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/renderer/core/view.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _valueTypes = require("../../core/value-types");

var _enums = _interopRequireDefault(require("../enums"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.
var _m4_tmp = new _valueTypes.Mat4();

var _genID = 0;
/**
 * A representation of a single camera view
 */

var View =
/*#__PURE__*/
function () {
  /**
   * Setup a default view
   */
  function View() {
    this._id = _genID++; // priority. the smaller one will be rendered first

    this._priority = 0; // viewport

    this._rect = {
      x: 0,
      y: 0,
      w: 1,
      h: 1
    }; // TODO:
    // this._scissor = {
    //   x: 0, y: 0, w: 1, h: 1
    // };
    // clear options

    this._color = new _valueTypes.Vec4(0.3, 0.3, 0.3, 1);
    this._depth = 1;
    this._stencil = 0;
    this._clearFlags = _enums["default"].CLEAR_COLOR | _enums["default"].CLEAR_DEPTH;
    this._clearModel = null; // matrix

    this._matView = cc.mat4();
    this._matViewInv = cc.mat4();
    this._matProj = cc.mat4();
    this._matViewProj = cc.mat4();
    this._matInvViewProj = cc.mat4(); // stages & framebuffer

    this._stages = [];
    this._cullingByID = false;
    this._framebuffer = null;
    this._shadowLight = null; // TODO: should not refer light in view.

    this._cullingMask = 0xffffffff;
  }
  /**
   * Get the view's forward direction
   * @param {Vec3} out the receiving vector
   * @returns {Vec3} the receiving vector
   */


  var _proto = View.prototype;

  _proto.getForward = function getForward(out) {
    var m = this._matView.m;
    return _valueTypes.Vec3.set(out, -m[2], -m[6], -m[10]);
  }
  /**
   * Get the view's observing location
   * @param {Vec3} out the receiving vector
   * @returns {Vec3} the receiving vector
   */
  ;

  _proto.getPosition = function getPosition(out) {
    _valueTypes.Mat4.invert(_m4_tmp, this._matView);

    return _valueTypes.Mat4.getTranslation(out, _m4_tmp);
  };

  return View;
}();

exports["default"] = View;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9yZW5kZXJlci9jb3JlL3ZpZXcuanMiXSwibmFtZXMiOlsiX200X3RtcCIsIk1hdDQiLCJfZ2VuSUQiLCJWaWV3IiwiX2lkIiwiX3ByaW9yaXR5IiwiX3JlY3QiLCJ4IiwieSIsInciLCJoIiwiX2NvbG9yIiwiVmVjNCIsIl9kZXB0aCIsIl9zdGVuY2lsIiwiX2NsZWFyRmxhZ3MiLCJlbnVtcyIsIkNMRUFSX0NPTE9SIiwiQ0xFQVJfREVQVEgiLCJfY2xlYXJNb2RlbCIsIl9tYXRWaWV3IiwiY2MiLCJtYXQ0IiwiX21hdFZpZXdJbnYiLCJfbWF0UHJvaiIsIl9tYXRWaWV3UHJvaiIsIl9tYXRJbnZWaWV3UHJvaiIsIl9zdGFnZXMiLCJfY3VsbGluZ0J5SUQiLCJfZnJhbWVidWZmZXIiLCJfc2hhZG93TGlnaHQiLCJfY3VsbGluZ01hc2siLCJnZXRGb3J3YXJkIiwib3V0IiwibSIsIlZlYzMiLCJzZXQiLCJnZXRQb3NpdGlvbiIsImludmVydCIsImdldFRyYW5zbGF0aW9uIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7O0FBRUE7O0FBQ0E7Ozs7QUFIQTtBQUtBLElBQUlBLE9BQU8sR0FBRyxJQUFJQyxnQkFBSixFQUFkOztBQUNBLElBQUlDLE1BQU0sR0FBRyxDQUFiO0FBRUE7Ozs7SUFHcUJDOzs7QUFDbkI7OztBQUdBLGtCQUFjO0FBQ1osU0FBS0MsR0FBTCxHQUFXRixNQUFNLEVBQWpCLENBRFksQ0FHWjs7QUFDQSxTQUFLRyxTQUFMLEdBQWlCLENBQWpCLENBSlksQ0FNWjs7QUFDQSxTQUFLQyxLQUFMLEdBQWE7QUFDWEMsTUFBQUEsQ0FBQyxFQUFFLENBRFE7QUFDTEMsTUFBQUEsQ0FBQyxFQUFFLENBREU7QUFDQ0MsTUFBQUEsQ0FBQyxFQUFFLENBREo7QUFDT0MsTUFBQUEsQ0FBQyxFQUFFO0FBRFYsS0FBYixDQVBZLENBV1o7QUFDQTtBQUNBO0FBQ0E7QUFFQTs7QUFDQSxTQUFLQyxNQUFMLEdBQWMsSUFBSUMsZ0JBQUosQ0FBUyxHQUFULEVBQWMsR0FBZCxFQUFtQixHQUFuQixFQUF3QixDQUF4QixDQUFkO0FBQ0EsU0FBS0MsTUFBTCxHQUFjLENBQWQ7QUFDQSxTQUFLQyxRQUFMLEdBQWdCLENBQWhCO0FBQ0EsU0FBS0MsV0FBTCxHQUFtQkMsa0JBQU1DLFdBQU4sR0FBb0JELGtCQUFNRSxXQUE3QztBQUNBLFNBQUtDLFdBQUwsR0FBbUIsSUFBbkIsQ0FyQlksQ0F1Qlo7O0FBQ0EsU0FBS0MsUUFBTCxHQUFnQkMsRUFBRSxDQUFDQyxJQUFILEVBQWhCO0FBQ0EsU0FBS0MsV0FBTCxHQUFtQkYsRUFBRSxDQUFDQyxJQUFILEVBQW5CO0FBQ0EsU0FBS0UsUUFBTCxHQUFnQkgsRUFBRSxDQUFDQyxJQUFILEVBQWhCO0FBQ0EsU0FBS0csWUFBTCxHQUFvQkosRUFBRSxDQUFDQyxJQUFILEVBQXBCO0FBQ0EsU0FBS0ksZUFBTCxHQUF1QkwsRUFBRSxDQUFDQyxJQUFILEVBQXZCLENBNUJZLENBOEJaOztBQUNBLFNBQUtLLE9BQUwsR0FBZSxFQUFmO0FBQ0EsU0FBS0MsWUFBTCxHQUFvQixLQUFwQjtBQUNBLFNBQUtDLFlBQUwsR0FBb0IsSUFBcEI7QUFFQSxTQUFLQyxZQUFMLEdBQW9CLElBQXBCLENBbkNZLENBbUNjOztBQUUxQixTQUFLQyxZQUFMLEdBQW9CLFVBQXBCO0FBQ0Q7QUFFRDs7Ozs7Ozs7O1NBS0FDLGFBQUEsb0JBQVdDLEdBQVgsRUFBZ0I7QUFDZCxRQUFJQyxDQUFDLEdBQUcsS0FBS2QsUUFBTCxDQUFjYyxDQUF0QjtBQUNBLFdBQU9DLGlCQUFLQyxHQUFMLENBQ0xILEdBREssRUFFTCxDQUFDQyxDQUFDLENBQUMsQ0FBRCxDQUZHLEVBR0wsQ0FBQ0EsQ0FBQyxDQUFDLENBQUQsQ0FIRyxFQUlMLENBQUNBLENBQUMsQ0FBQyxFQUFELENBSkcsQ0FBUDtBQU1EO0FBRUQ7Ozs7Ozs7U0FLQUcsY0FBQSxxQkFBWUosR0FBWixFQUFpQjtBQUNmaEMscUJBQUtxQyxNQUFMLENBQVl0QyxPQUFaLEVBQXFCLEtBQUtvQixRQUExQjs7QUFDQSxXQUFPbkIsaUJBQUtzQyxjQUFMLENBQW9CTixHQUFwQixFQUF5QmpDLE9BQXpCLENBQVA7QUFDRCIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAoYykgMjAxNy0yMDE4IFhpYW1lbiBZYWppIFNvZnR3YXJlIENvLiwgTHRkLlxuXG5pbXBvcnQgeyBWZWMzLCBNYXQ0LCBWZWM0IH0gZnJvbSAnLi4vLi4vY29yZS92YWx1ZS10eXBlcyc7XG5pbXBvcnQgZW51bXMgZnJvbSAnLi4vZW51bXMnO1xuXG5sZXQgX200X3RtcCA9IG5ldyBNYXQ0KCk7XG5sZXQgX2dlbklEID0gMDtcblxuLyoqXG4gKiBBIHJlcHJlc2VudGF0aW9uIG9mIGEgc2luZ2xlIGNhbWVyYSB2aWV3XG4gKi9cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFZpZXcge1xuICAvKipcbiAgICogU2V0dXAgYSBkZWZhdWx0IHZpZXdcbiAgICovXG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIHRoaXMuX2lkID0gX2dlbklEKys7XG5cbiAgICAvLyBwcmlvcml0eS4gdGhlIHNtYWxsZXIgb25lIHdpbGwgYmUgcmVuZGVyZWQgZmlyc3RcbiAgICB0aGlzLl9wcmlvcml0eSA9IDA7XG5cbiAgICAvLyB2aWV3cG9ydFxuICAgIHRoaXMuX3JlY3QgPSB7XG4gICAgICB4OiAwLCB5OiAwLCB3OiAxLCBoOiAxXG4gICAgfTtcblxuICAgIC8vIFRPRE86XG4gICAgLy8gdGhpcy5fc2Npc3NvciA9IHtcbiAgICAvLyAgIHg6IDAsIHk6IDAsIHc6IDEsIGg6IDFcbiAgICAvLyB9O1xuXG4gICAgLy8gY2xlYXIgb3B0aW9uc1xuICAgIHRoaXMuX2NvbG9yID0gbmV3IFZlYzQoMC4zLCAwLjMsIDAuMywgMSk7XG4gICAgdGhpcy5fZGVwdGggPSAxO1xuICAgIHRoaXMuX3N0ZW5jaWwgPSAwO1xuICAgIHRoaXMuX2NsZWFyRmxhZ3MgPSBlbnVtcy5DTEVBUl9DT0xPUiB8IGVudW1zLkNMRUFSX0RFUFRIO1xuICAgIHRoaXMuX2NsZWFyTW9kZWwgPSBudWxsO1xuXG4gICAgLy8gbWF0cml4XG4gICAgdGhpcy5fbWF0VmlldyA9IGNjLm1hdDQoKTtcbiAgICB0aGlzLl9tYXRWaWV3SW52ID0gY2MubWF0NCgpO1xuICAgIHRoaXMuX21hdFByb2ogPSBjYy5tYXQ0KCk7XG4gICAgdGhpcy5fbWF0Vmlld1Byb2ogPSBjYy5tYXQ0KCk7XG4gICAgdGhpcy5fbWF0SW52Vmlld1Byb2ogPSBjYy5tYXQ0KCk7XG5cbiAgICAvLyBzdGFnZXMgJiBmcmFtZWJ1ZmZlclxuICAgIHRoaXMuX3N0YWdlcyA9IFtdO1xuICAgIHRoaXMuX2N1bGxpbmdCeUlEID0gZmFsc2U7XG4gICAgdGhpcy5fZnJhbWVidWZmZXIgPSBudWxsO1xuXG4gICAgdGhpcy5fc2hhZG93TGlnaHQgPSBudWxsOyAvLyBUT0RPOiBzaG91bGQgbm90IHJlZmVyIGxpZ2h0IGluIHZpZXcuXG5cbiAgICB0aGlzLl9jdWxsaW5nTWFzayA9IDB4ZmZmZmZmZmY7XG4gIH1cblxuICAvKipcbiAgICogR2V0IHRoZSB2aWV3J3MgZm9yd2FyZCBkaXJlY3Rpb25cbiAgICogQHBhcmFtIHtWZWMzfSBvdXQgdGhlIHJlY2VpdmluZyB2ZWN0b3JcbiAgICogQHJldHVybnMge1ZlYzN9IHRoZSByZWNlaXZpbmcgdmVjdG9yXG4gICAqL1xuICBnZXRGb3J3YXJkKG91dCkge1xuICAgIGxldCBtID0gdGhpcy5fbWF0Vmlldy5tO1xuICAgIHJldHVybiBWZWMzLnNldChcbiAgICAgIG91dCxcbiAgICAgIC1tWzJdLFxuICAgICAgLW1bNl0sXG4gICAgICAtbVsxMF1cbiAgICApO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldCB0aGUgdmlldydzIG9ic2VydmluZyBsb2NhdGlvblxuICAgKiBAcGFyYW0ge1ZlYzN9IG91dCB0aGUgcmVjZWl2aW5nIHZlY3RvclxuICAgKiBAcmV0dXJucyB7VmVjM30gdGhlIHJlY2VpdmluZyB2ZWN0b3JcbiAgICovXG4gIGdldFBvc2l0aW9uKG91dCkge1xuICAgIE1hdDQuaW52ZXJ0KF9tNF90bXAsIHRoaXMuX21hdFZpZXcpO1xuICAgIHJldHVybiBNYXQ0LmdldFRyYW5zbGF0aW9uKG91dCwgX200X3RtcCk7XG4gIH1cbn1cbiJdLCJzb3VyY2VSb290IjoiLyJ9