
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/particle/particle-system-assembler.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var _assembler = _interopRequireDefault(require("../core/renderer/assembler"));

var _inputAssembler = _interopRequireDefault(require("../renderer/core/input-assembler"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var ParticleSystem = require('./CCParticleSystem');

var renderer = require('../core/renderer/');

var QuadBuffer = require('../core/renderer/webgl/quad-buffer');

var vfmtPosUvColor = require('../core/renderer/webgl/vertex-format').vfmtPosUvColor;

var ParticleAssembler =
/*#__PURE__*/
function (_Assembler) {
  _inheritsLoose(ParticleAssembler, _Assembler);

  function ParticleAssembler(comp) {
    var _this;

    _this = _Assembler.call(this, comp) || this;
    _this._buffer = null;
    _this._ia = null;
    _this._vfmt = vfmtPosUvColor;
    return _this;
  }

  var _proto = ParticleAssembler.prototype;

  _proto.getBuffer = function getBuffer() {
    if (!this._buffer) {
      // Create quad buffer for vertex and index
      this._buffer = new QuadBuffer(renderer._handle, vfmtPosUvColor);
      this._ia = new _inputAssembler["default"]();
      this._ia._vertexBuffer = this._buffer._vb;
      this._ia._indexBuffer = this._buffer._ib;
      this._ia._start = 0;
      this._ia._count = 0;
    }

    return this._buffer;
  };

  _proto.fillBuffers = function fillBuffers(comp, renderer) {
    if (!this._ia) return;
    renderer.node = comp.node;
    renderer.material = comp._materials[0];

    renderer._flushIA(this._ia);
  };

  return ParticleAssembler;
}(_assembler["default"]);

_assembler["default"].register(ParticleSystem, ParticleAssembler);

module.exports = ParticleAssembler;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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