
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/particle/particle-simulator.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var AffineTrans = require('../core/utils/affine-transform');

var js = require('../core/platform/js');

var misc = require('../core/utils/misc');

var ZERO_VEC2 = cc.v2(0, 0);

var _trans = AffineTrans.create();

var _pos = cc.v2();

var _tpa = cc.v2();

var _tpb = cc.v2();

var _tpc = cc.v2();

var Particle = function Particle() {
  this.pos = cc.v2(0, 0);
  this.startPos = cc.v2(0, 0);
  this.color = cc.color(0, 0, 0, 255);
  this.deltaColor = {
    r: 0,
    g: 0,
    b: 0,
    a: 255
  };
  this.size = 0;
  this.deltaSize = 0;
  this.rotation = 0;
  this.deltaRotation = 0;
  this.timeToLive = 0;
  this.drawPos = cc.v2(0, 0);
  this.aspectRatio = 1; // Mode A

  this.dir = cc.v2(0, 0);
  this.radialAccel = 0;
  this.tangentialAccel = 0; // Mode B

  this.angle = 0;
  this.degreesPerSecond = 0;
  this.radius = 0;
  this.deltaRadius = 0;
};

var pool = new js.Pool(function (par) {
  par.pos.set(ZERO_VEC2);
  par.startPos.set(ZERO_VEC2);
  par.color._val = 0xFF000000;
  par.deltaColor.r = par.deltaColor.g = par.deltaColor.b = 0;
  par.deltaColor.a = 255;
  par.size = 0;
  par.deltaSize = 0;
  par.rotation = 0;
  par.deltaRotation = 0;
  par.timeToLive = 0;
  par.drawPos.set(ZERO_VEC2);
  par.aspectRatio = 1; // Mode A

  par.dir.set(ZERO_VEC2);
  par.radialAccel = 0;
  par.tangentialAccel = 0; // Mode B

  par.angle = 0;
  par.degreesPerSecond = 0;
  par.radius = 0;
  par.deltaRadius = 0;
}, 1024);

pool.get = function () {
  return this._get() || new Particle();
};

var Simulator = function Simulator(system) {
  this.sys = system;
  this.particles = [];
  this.active = false;
  this.readyToPlay = true;
  this.finished = false;
  this.elapsed = 0;
  this.emitCounter = 0;
  this._uvFilled = 0;
};

Simulator.prototype.stop = function () {
  this.active = false;
  this.readyToPlay = false;
  this.elapsed = this.sys.duration;
  this.emitCounter = 0;
};

Simulator.prototype.reset = function () {
  this.active = true;
  this.readyToPlay = true;
  this.elapsed = 0;
  this.emitCounter = 0;
  this.finished = false;
  var particles = this.particles;

  for (var id = 0; id < particles.length; ++id) {
    pool.put(particles[id]);
  }

  particles.length = 0;
};

Simulator.prototype.emitParticle = function (pos) {
  var psys = this.sys;
  var clampf = misc.clampf;
  var particle = pool.get();
  this.particles.push(particle); // Init particle
  // timeToLive
  // no negative life. prevent division by 0

  particle.timeToLive = psys.life + psys.lifeVar * (Math.random() - 0.5) * 2;
  var timeToLive = particle.timeToLive = Math.max(0, particle.timeToLive); // position

  particle.pos.x = psys.sourcePos.x + psys.posVar.x * (Math.random() - 0.5) * 2;
  particle.pos.y = psys.sourcePos.y + psys.posVar.y * (Math.random() - 0.5) * 2; // Color

  var sr, sg, sb, sa;
  var startColor = psys._startColor,
      startColorVar = psys._startColorVar;
  var endColor = psys._endColor,
      endColorVar = psys._endColorVar;
  particle.color.r = sr = clampf(startColor.r + startColorVar.r * (Math.random() - 0.5) * 2, 0, 255);
  particle.color.g = sg = clampf(startColor.g + startColorVar.g * (Math.random() - 0.5) * 2, 0, 255);
  particle.color.b = sb = clampf(startColor.b + startColorVar.b * (Math.random() - 0.5) * 2, 0, 255);
  particle.color.a = sa = clampf(startColor.a + startColorVar.a * (Math.random() - 0.5) * 2, 0, 255);
  particle.deltaColor.r = (clampf(endColor.r + endColorVar.r * (Math.random() - 0.5) * 2, 0, 255) - sr) / timeToLive;
  particle.deltaColor.g = (clampf(endColor.g + endColorVar.g * (Math.random() - 0.5) * 2, 0, 255) - sg) / timeToLive;
  particle.deltaColor.b = (clampf(endColor.b + endColorVar.b * (Math.random() - 0.5) * 2, 0, 255) - sb) / timeToLive;
  particle.deltaColor.a = (clampf(endColor.a + endColorVar.a * (Math.random() - 0.5) * 2, 0, 255) - sa) / timeToLive; // size

  var startS = psys.startSize + psys.startSizeVar * (Math.random() - 0.5) * 2;
  startS = Math.max(0, startS); // No negative value

  particle.size = startS;

  if (psys.endSize === cc.ParticleSystem.START_SIZE_EQUAL_TO_END_SIZE) {
    particle.deltaSize = 0;
  } else {
    var endS = psys.endSize + psys.endSizeVar * (Math.random() - 0.5) * 2;
    endS = Math.max(0, endS); // No negative values

    particle.deltaSize = (endS - startS) / timeToLive;
  } // rotation


  var startA = psys.startSpin + psys.startSpinVar * (Math.random() - 0.5) * 2;
  var endA = psys.endSpin + psys.endSpinVar * (Math.random() - 0.5) * 2;
  particle.rotation = startA;
  particle.deltaRotation = (endA - startA) / timeToLive; // position

  particle.startPos.x = pos.x;
  particle.startPos.y = pos.y; // aspect ratio

  particle.aspectRatio = psys._aspectRatio || 1; // direction

  var worldRotation = getWorldRotation(psys.node);
  var relAngle = psys.positionType === cc.ParticleSystem.PositionType.FREE ? psys.angle + worldRotation : psys.angle;
  var a = misc.degreesToRadians(relAngle + psys.angleVar * (Math.random() - 0.5) * 2); // Mode Gravity: A

  if (psys.emitterMode === cc.ParticleSystem.EmitterMode.GRAVITY) {
    var s = psys.speed + psys.speedVar * (Math.random() - 0.5) * 2; // direction

    particle.dir.x = Math.cos(a);
    particle.dir.y = Math.sin(a);
    particle.dir.mulSelf(s); // radial accel

    particle.radialAccel = psys.radialAccel + psys.radialAccelVar * (Math.random() - 0.5) * 2; // tangential accel

    particle.tangentialAccel = psys.tangentialAccel + psys.tangentialAccelVar * (Math.random() - 0.5) * 2; // rotation is dir

    if (psys.rotationIsDir) {
      particle.rotation = -misc.radiansToDegrees(Math.atan2(particle.dir.y, particle.dir.x));
    }
  } // Mode Radius: B
  else {
      // Set the default diameter of the particle from the source position
      var startRadius = psys.startRadius + psys.startRadiusVar * (Math.random() - 0.5) * 2;
      var endRadius = psys.endRadius + psys.endRadiusVar * (Math.random() - 0.5) * 2;
      particle.radius = startRadius;
      particle.deltaRadius = psys.endRadius === cc.ParticleSystem.START_RADIUS_EQUAL_TO_END_RADIUS ? 0 : (endRadius - startRadius) / timeToLive;
      particle.angle = a;
      particle.degreesPerSecond = misc.degreesToRadians(psys.rotatePerS + psys.rotatePerSVar * (Math.random() - 0.5) * 2);
    }
}; // In the Free mode to get emit real rotation in the world coordinate.


function getWorldRotation(node) {
  var rotation = 0;
  var tempNode = node;

  while (tempNode) {
    rotation += tempNode.angle;
    tempNode = tempNode.parent;
  }

  return rotation;
}

Simulator.prototype.updateUVs = function (force) {
  var assembler = this.sys._assembler;

  if (!assembler) {
    return;
  }

  var buffer = assembler.getBuffer();

  if (buffer && this.sys._renderSpriteFrame) {
    var FLOAT_PER_PARTICLE = 4 * assembler._vfmt._bytes / 4;
    var vbuf = buffer._vData;
    var uv = this.sys._renderSpriteFrame.uv;
    var start = force ? 0 : this._uvFilled;
    var particleCount = this.particles.length;

    for (var i = start; i < particleCount; i++) {
      var offset = i * FLOAT_PER_PARTICLE;
      vbuf[offset + 2] = uv[0];
      vbuf[offset + 3] = uv[1];
      vbuf[offset + 7] = uv[2];
      vbuf[offset + 8] = uv[3];
      vbuf[offset + 12] = uv[4];
      vbuf[offset + 13] = uv[5];
      vbuf[offset + 17] = uv[6];
      vbuf[offset + 18] = uv[7];
    }

    this._uvFilled = particleCount;
  }
};

Simulator.prototype.updateParticleBuffer = function (particle, pos, buffer, offset) {
  var vbuf = buffer._vData;
  var uintbuf = buffer._uintVData;
  var x = pos.x,
      y = pos.y;
  var width = particle.size;
  var height = width;
  var aspectRatio = particle.aspectRatio;
  aspectRatio > 1 ? height = width / aspectRatio : width = height * aspectRatio;
  var halfWidth = width / 2;
  var halfHeight = height / 2; // pos

  if (particle.rotation) {
    var x1 = -halfWidth,
        y1 = -halfHeight;
    var x2 = halfWidth,
        y2 = halfHeight;
    var rad = -misc.degreesToRadians(particle.rotation);
    var cr = Math.cos(rad),
        sr = Math.sin(rad); // bl

    vbuf[offset] = x1 * cr - y1 * sr + x;
    vbuf[offset + 1] = x1 * sr + y1 * cr + y; // br

    vbuf[offset + 5] = x2 * cr - y1 * sr + x;
    vbuf[offset + 6] = x2 * sr + y1 * cr + y; // tl

    vbuf[offset + 10] = x1 * cr - y2 * sr + x;
    vbuf[offset + 11] = x1 * sr + y2 * cr + y; // tr

    vbuf[offset + 15] = x2 * cr - y2 * sr + x;
    vbuf[offset + 16] = x2 * sr + y2 * cr + y;
  } else {
    // bl
    vbuf[offset] = x - halfWidth;
    vbuf[offset + 1] = y - halfHeight; // br

    vbuf[offset + 5] = x + halfWidth;
    vbuf[offset + 6] = y - halfHeight; // tl

    vbuf[offset + 10] = x - halfWidth;
    vbuf[offset + 11] = y + halfHeight; // tr

    vbuf[offset + 15] = x + halfWidth;
    vbuf[offset + 16] = y + halfHeight;
  } // color


  uintbuf[offset + 4] = particle.color._val;
  uintbuf[offset + 9] = particle.color._val;
  uintbuf[offset + 14] = particle.color._val;
  uintbuf[offset + 19] = particle.color._val;
};

Simulator.prototype.step = function (dt) {
  dt = dt > cc.director._maxParticleDeltaTime ? cc.director._maxParticleDeltaTime : dt;
  var psys = this.sys;
  var node = psys.node;
  var particles = this.particles;
  var FLOAT_PER_PARTICLE = 4 * this.sys._assembler._vfmt._bytes / 4; // Calculate pos

  node._updateWorldMatrix();

  _trans = AffineTrans.identity();

  if (psys.positionType === cc.ParticleSystem.PositionType.FREE) {
    var m = node._worldMatrix.m;
    _trans.tx = m[12];
    _trans.ty = m[13];
    AffineTrans.transformVec2(_pos, ZERO_VEC2, _trans);
  } else if (psys.positionType === cc.ParticleSystem.PositionType.RELATIVE) {
    var angle = misc.degreesToRadians(-node.angle);
    var cos = Math.cos(angle);
    var sin = Math.sin(angle);
    _trans = AffineTrans.create(cos, -sin, sin, cos, 0, 0);
    _pos.x = node.x;
    _pos.y = node.y;
  } // Get world to node trans only once


  AffineTrans.invert(_trans, _trans);
  var worldToNodeTrans = _trans; // Emission

  if (this.active && psys.emissionRate) {
    var rate = 1.0 / psys.emissionRate; //issue #1201, prevent bursts of particles, due to too high emitCounter

    if (particles.length < psys.totalParticles) this.emitCounter += dt;

    while (particles.length < psys.totalParticles && this.emitCounter > rate) {
      this.emitParticle(_pos);
      this.emitCounter -= rate;
    }

    this.elapsed += dt;

    if (psys.duration !== -1 && psys.duration < this.elapsed) {
      psys.stopSystem();
    }
  } // Request buffer for particles


  var buffer = psys._assembler.getBuffer();

  var particleCount = particles.length;
  buffer.reset();
  buffer.request(particleCount * 4, particleCount * 6); // Fill up uvs

  if (particleCount > this._uvFilled) {
    this.updateUVs();
  } // Used to reduce memory allocation / creation within the loop


  var particleIdx = 0;

  while (particleIdx < particles.length) {
    // Reset temporary vectors
    _tpa.x = _tpa.y = _tpb.x = _tpb.y = _tpc.x = _tpc.y = 0;
    var particle = particles[particleIdx]; // life

    particle.timeToLive -= dt;

    if (particle.timeToLive > 0) {
      // Mode A: gravity, direction, tangential accel & radial accel
      if (psys.emitterMode === cc.ParticleSystem.EmitterMode.GRAVITY) {
        var tmp = _tpc,
            radial = _tpa,
            tangential = _tpb; // radial acceleration

        if (particle.pos.x || particle.pos.y) {
          radial.set(particle.pos);
          radial.normalizeSelf();
        }

        tangential.set(radial);
        radial.mulSelf(particle.radialAccel); // tangential acceleration

        var newy = tangential.x;
        tangential.x = -tangential.y;
        tangential.y = newy;
        tangential.mulSelf(particle.tangentialAccel);
        tmp.set(radial);
        tmp.addSelf(tangential);
        tmp.addSelf(psys.gravity);
        tmp.mulSelf(dt);
        particle.dir.addSelf(tmp);
        tmp.set(particle.dir);
        tmp.mulSelf(dt);
        particle.pos.addSelf(tmp);
      } // Mode B: radius movement
      else {
          // Update the angle and radius of the particle.
          particle.angle += particle.degreesPerSecond * dt;
          particle.radius += particle.deltaRadius * dt;
          particle.pos.x = -Math.cos(particle.angle) * particle.radius;
          particle.pos.y = -Math.sin(particle.angle) * particle.radius;
        } // color


      particle.color.r += particle.deltaColor.r * dt;
      particle.color.g += particle.deltaColor.g * dt;
      particle.color.b += particle.deltaColor.b * dt;
      particle.color.a += particle.deltaColor.a * dt; // size

      particle.size += particle.deltaSize * dt;

      if (particle.size < 0) {
        particle.size = 0;
      } // angle


      particle.rotation += particle.deltaRotation * dt; // update values in quad buffer

      var newPos = _tpa;
      var diff = _tpb;

      if (psys.positionType === cc.ParticleSystem.PositionType.FREE) {
        diff.set(particle.startPos);
        diff.negSelf(); // Unify direction with other positionType

        newPos.set(particle.pos);
        newPos.subSelf(diff);
      } else if (psys.positionType === cc.ParticleSystem.PositionType.RELATIVE) {
        var startPos = _tpc; // current Position convert To Node Space

        AffineTrans.transformVec2(diff, _pos, worldToNodeTrans); // start Position convert To Node Space

        AffineTrans.transformVec2(startPos, particle.startPos, worldToNodeTrans);
        diff.subSelf(startPos);
        newPos.set(particle.pos);
        newPos.subSelf(diff);
      } else {
        newPos.set(particle.pos);
      }

      var offset = FLOAT_PER_PARTICLE * particleIdx;
      this.updateParticleBuffer(particle, newPos, buffer, offset); // update particle counter

      ++particleIdx;
    } else {
      // life < 0
      var deadParticle = particles[particleIdx];

      if (particleIdx !== particles.length - 1) {
        particles[particleIdx] = particles[particles.length - 1];
      }

      pool.put(deadParticle);
      particles.length--;
    }
  }

  if (particles.length > 0) {
    buffer.uploadData();
    psys._assembler._ia._count = particles.length * 6;
  } else if (!this.active && !this.readyToPlay) {
    this.finished = true;

    psys._finishedSimulation();
  }
};

module.exports = Simulator;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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