
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/particle/CCParticleSystem.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var macro = require('../core/platform/CCMacro');

var ParticleAsset = require('./CCParticleAsset');

var RenderComponent = require('../core/components/CCRenderComponent');

var codec = require('../compression/ZipUtils');

var PNGReader = require('./CCPNGReader');

var tiffReader = require('./CCTIFFReader');

var textureUtil = require('../core/utils/texture-util');

var RenderFlow = require('../core/renderer/render-flow');

var ParticleSimulator = require('./particle-simulator');

var Material = require('../core/assets/material/CCMaterial');

var BlendFunc = require('../core/utils/blend-func');

function getImageFormatByData(imgData) {
  // if it is a png file buffer.
  if (imgData.length > 8 && imgData[0] === 0x89 && imgData[1] === 0x50 && imgData[2] === 0x4E && imgData[3] === 0x47 && imgData[4] === 0x0D && imgData[5] === 0x0A && imgData[6] === 0x1A && imgData[7] === 0x0A) {
    return macro.ImageFormat.PNG;
  } // if it is a tiff file buffer.


  if (imgData.length > 2 && (imgData[0] === 0x49 && imgData[1] === 0x49 || imgData[0] === 0x4d && imgData[1] === 0x4d || imgData[0] === 0xff && imgData[1] === 0xd8)) {
    return macro.ImageFormat.TIFF;
  }

  return macro.ImageFormat.UNKNOWN;
} //


function getParticleComponents(node) {
  var parent = node.parent,
      comp = node.getComponent(cc.ParticleSystem);

  if (!parent || !comp) {
    return node.getComponentsInChildren(cc.ParticleSystem);
  }

  return getParticleComponents(parent);
}
/**
 * !#en Enum for emitter modes
 * !#zh 发射模式
 * @enum ParticleSystem.EmitterMode
 */


var EmitterMode = cc.Enum({
  /**
   * !#en Uses gravity, speed, radial and tangential acceleration.
   * !#zh 重力模式，模拟重力，可让粒子围绕一个中心点移近或移远。
   * @property {Number} GRAVITY
   */
  GRAVITY: 0,

  /**
   * !#en Uses radius movement + rotation.
   * !#zh 半径模式，可以使粒子以圆圈方式旋转，它也可以创造螺旋效果让粒子急速前进或后退。
   * @property {Number} RADIUS - Uses radius movement + rotation.
   */
  RADIUS: 1
});
/**
 * !#en Enum for particles movement type.
 * !#zh 粒子位置类型
 * @enum ParticleSystem.PositionType
 */

var PositionType = cc.Enum({
  /**
   * !#en
   * Living particles are attached to the world and are unaffected by emitter repositioning.
   * !#zh
   * 自由模式，相对于世界坐标，不会随粒子节点移动而移动。（可产生火焰、蒸汽等效果）
   * @property {Number} FREE
   */
  FREE: 0,

  /**
   * !#en
   * Living particles are attached to the world but will follow the emitter repositioning.<br/>
   * Use case: Attach an emitter to an sprite, and you want that the emitter follows the sprite.
   * !#zh
   * 相对模式，粒子会随父节点移动而移动，可用于制作移动角色身上的特效等等。（该选项在 Creator 中暂时不支持）
   * @property {Number} RELATIVE
   */
  RELATIVE: 1,

  /**
   * !#en
   * Living particles are attached to the emitter and are translated along with it.
   * !#zh
   * 整组模式，粒子跟随发射器移动。（不会发生拖尾）
   * @property {Number} GROUPED
   */
  GROUPED: 2
});
/**
 * @class ParticleSystem
 */

var properties = {
  /**
   * !#en Play particle in edit mode.
   * !#zh 在编辑器模式下预览粒子，启用后选中粒子时，粒子将自动播放。
   * @property {Boolean} preview
   * @default false
   */
  preview: {
    "default": true,
    editorOnly: true,
    notify: CC_EDITOR && function () {
      this.resetSystem();

      if (!this.preview) {
        this.stopSystem();
        this.disableRender();
      }

      cc.engine.repaintInEditMode();
    },
    animatable: false,
    tooltip: CC_DEV && 'i18n:COMPONENT.particle_system.preview'
  },

  /**
   * !#en
   * If set custom to true, then use custom properties insteadof read particle file.
   * !#zh 是否自定义粒子属性。
   * @property {Boolean} custom
   * @default false
   */
  _custom: false,
  custom: {
    get: function get() {
      return this._custom;
    },
    set: function set(value) {
      if (CC_EDITOR && !value && !this._file) {
        return cc.warnID(6000);
      }

      if (this._custom !== value) {
        this._custom = value;

        this._applyFile();

        if (CC_EDITOR) {
          cc.engine.repaintInEditMode();
        }
      }
    },
    animatable: false,
    tooltip: CC_DEV && 'i18n:COMPONENT.particle_system.custom'
  },

  /**
   * !#en The plist file.
   * !#zh plist 格式的粒子配置文件。
   * @property {ParticleAsset} file
   * @default null
   */
  _file: {
    "default": null,
    type: ParticleAsset
  },
  file: {
    get: function get() {
      return this._file;
    },
    set: function set(value, force) {
      if (this._file !== value || CC_EDITOR && force) {
        this._file = value;

        if (value) {
          this._applyFile();

          if (CC_EDITOR) {
            cc.engine.repaintInEditMode();
          }
        } else {
          this.custom = true;
        }
      }
    },
    animatable: false,
    type: ParticleAsset,
    tooltip: CC_DEV && 'i18n:COMPONENT.particle_system.file'
  },

  /**
   * !#en SpriteFrame used for particles display
   * !#zh 用于粒子呈现的 SpriteFrame
   * @property spriteFrame
   * @type {SpriteFrame}
   */
  _spriteFrame: {
    "default": null,
    type: cc.SpriteFrame
  },
  spriteFrame: {
    get: function get() {
      return this._spriteFrame;
    },
    set: function set(value, force) {
      var lastSprite = this._renderSpriteFrame;

      if (CC_EDITOR) {
        if (!force && lastSprite === value) {
          return;
        }
      } else {
        if (lastSprite === value) {
          return;
        }
      }

      this._renderSpriteFrame = value;

      if (!value || value._uuid) {
        this._spriteFrame = value;
      }

      if ((lastSprite && lastSprite.getTexture()) !== (value && value.getTexture())) {
        this._applySpriteFrame(lastSprite);
      }

      if (CC_EDITOR) {
        this.node.emit('spriteframe-changed', this);
      }
    },
    type: cc.SpriteFrame,
    tooltip: CC_DEV && 'i18n:COMPONENT.particle_system.spriteFrame'
  },
  // just used to read data from 1.x
  _texture: {
    "default": null,
    type: cc.Texture2D,
    editorOnly: true
  },

  /**
   * !#en Texture of Particle System, readonly, please use spriteFrame to setup new texture。
   * !#zh 粒子贴图，只读属性，请使用 spriteFrame 属性来替换贴图。
   * @property texture
   * @type {String}
   * @readonly
   */
  texture: {
    get: function get() {
      return this._getTexture();
    },
    set: function set(value) {
      if (value) {
        cc.warnID(6017);
      }
    },
    type: cc.Texture2D,
    tooltip: CC_DEV && 'i18n:COMPONENT.particle_system.texture',
    readonly: true,
    visible: false,
    animatable: false
  },

  /**
   * !#en Current quantity of particles that are being simulated.
   * !#zh 当前播放的粒子数量。
   * @property {Number} particleCount
   * @readonly
   */
  particleCount: {
    visible: false,
    get: function get() {
      return this._simulator.particles.length;
    },
    readonly: true
  },

  /**
   * !#en Indicate whether the system simulation have stopped.
   * !#zh 指示粒子播放是否完毕。
   * @property {Boolean} stopped
   */
  _stopped: true,
  stopped: {
    get: function get() {
      return this._stopped;
    },
    animatable: false,
    visible: false
  },

  /**
   * !#en If set to true, the particle system will automatically start playing on onLoad.
   * !#zh 如果设置为 true 运行时会自动发射粒子。
   * @property playOnLoad
   * @type {boolean}
   * @default true
   */
  playOnLoad: true,

  /**
   * !#en Indicate whether the owner node will be auto-removed when it has no particles left.
   * !#zh 粒子播放完毕后自动销毁所在的节点。
   * @property {Boolean} autoRemoveOnFinish
   */
  autoRemoveOnFinish: {
    "default": false,
    animatable: false,
    tooltip: CC_DEV && 'i18n:COMPONENT.particle_system.autoRemoveOnFinish'
  },

  /**
   * !#en Indicate whether the particle system is activated.
   * !#zh 是否激活粒子。
   * @property {Boolean} active
   * @readonly
   */
  active: {
    get: function get() {
      return this._simulator.active;
    },
    visible: false
  },

  /**
   * !#en Maximum particles of the system.
   * !#zh 粒子最大数量。
   * @property {Number} totalParticles
   * @default 150
   */
  totalParticles: 150,

  /**
   * !#en How many seconds the emitter wil run. -1 means 'forever'.
   * !#zh 发射器生存时间，单位秒，-1表示持续发射。
   * @property {Number} duration
   * @default ParticleSystem.DURATION_INFINITY
   */
  duration: -1,

  /**
   * !#en Emission rate of the particles.
   * !#zh 每秒发射的粒子数目。
   * @property {Number} emissionRate
   * @default 10
   */
  emissionRate: 10,

  /**
   * !#en Life of each particle setter.
   * !#zh 粒子的运行时间。
   * @property {Number} life
   * @default 1
   */
  life: 1,

  /**
   * !#en Variation of life.
   * !#zh 粒子的运行时间变化范围。
   * @property {Number} lifeVar
   * @default 0
   */
  lifeVar: 0,

  /**
   * !#en Start color of each particle.
   * !#zh 粒子初始颜色。
   * @property {cc.Color} startColor
   * @default {r: 255, g: 255, b: 255, a: 255}
   */
  _startColor: null,
  startColor: {
    type: cc.Color,
    get: function get() {
      return this._startColor;
    },
    set: function set(val) {
      this._startColor.r = val.r;
      this._startColor.g = val.g;
      this._startColor.b = val.b;
      this._startColor.a = val.a;
    }
  },

  /**
   * !#en Variation of the start color.
   * !#zh 粒子初始颜色变化范围。
   * @property {cc.Color} startColorVar
   * @default {r: 0, g: 0, b: 0, a: 0}
   */
  _startColorVar: null,
  startColorVar: {
    type: cc.Color,
    get: function get() {
      return this._startColorVar;
    },
    set: function set(val) {
      this._startColorVar.r = val.r;
      this._startColorVar.g = val.g;
      this._startColorVar.b = val.b;
      this._startColorVar.a = val.a;
    }
  },

  /**
   * !#en Ending color of each particle.
   * !#zh 粒子结束颜色。
   * @property {cc.Color} endColor
   * @default {r: 255, g: 255, b: 255, a: 0}
   */
  _endColor: null,
  endColor: {
    type: cc.Color,
    get: function get() {
      return this._endColor;
    },
    set: function set(val) {
      this._endColor.r = val.r;
      this._endColor.g = val.g;
      this._endColor.b = val.b;
      this._endColor.a = val.a;
    }
  },

  /**
   * !#en Variation of the end color.
   * !#zh 粒子结束颜色变化范围。
   * @property {cc.Color} endColorVar
   * @default {r: 0, g: 0, b: 0, a: 0}
   */
  _endColorVar: null,
  endColorVar: {
    type: cc.Color,
    get: function get() {
      return this._endColorVar;
    },
    set: function set(val) {
      this._endColorVar.r = val.r;
      this._endColorVar.g = val.g;
      this._endColorVar.b = val.b;
      this._endColorVar.a = val.a;
    }
  },

  /**
   * !#en Angle of each particle setter.
   * !#zh 粒子角度。
   * @property {Number} angle
   * @default 90
   */
  angle: 90,

  /**
   * !#en Variation of angle of each particle setter.
   * !#zh 粒子角度变化范围。
   * @property {Number} angleVar
   * @default 20
   */
  angleVar: 20,

  /**
   * !#en Start size in pixels of each particle.
   * !#zh 粒子的初始大小。
   * @property {Number} startSize
   * @default 50
   */
  startSize: 50,

  /**
   * !#en Variation of start size in pixels.
   * !#zh 粒子初始大小的变化范围。
   * @property {Number} startSizeVar
   * @default 0
   */
  startSizeVar: 0,

  /**
   * !#en End size in pixels of each particle.
   * !#zh 粒子结束时的大小。
   * @property {Number} endSize
   * @default 0
   */
  endSize: 0,

  /**
   * !#en Variation of end size in pixels.
   * !#zh 粒子结束大小的变化范围。
   * @property {Number} endSizeVar
   * @default 0
   */
  endSizeVar: 0,

  /**
   * !#en Start angle of each particle.
   * !#zh 粒子开始自旋角度。
   * @property {Number} startSpin
   * @default 0
   */
  startSpin: 0,

  /**
   * !#en Variation of start angle.
   * !#zh 粒子开始自旋角度变化范围。
   * @property {Number} startSpinVar
   * @default 0
   */
  startSpinVar: 0,

  /**
   * !#en End angle of each particle.
   * !#zh 粒子结束自旋角度。
   * @property {Number} endSpin
   * @default 0
   */
  endSpin: 0,

  /**
   * !#en Variation of end angle.
   * !#zh 粒子结束自旋角度变化范围。
   * @property {Number} endSpinVar
   * @default 0
   */
  endSpinVar: 0,

  /**
   * !#en Source position of the emitter.
   * !#zh 发射器位置。
   * @property {Vec2} sourcePos
   * @default cc.Vec2.ZERO
   */
  sourcePos: cc.Vec2.ZERO,

  /**
   * !#en Variation of source position.
   * !#zh 发射器位置的变化范围。（横向和纵向）
   * @property {Vec2} posVar
   * @default cc.Vec2.ZERO
   */
  posVar: cc.Vec2.ZERO,

  /**
   * !#en Particles movement type.
   * !#zh 粒子位置类型。
   * @property {ParticleSystem.PositionType} positionType
   * @default ParticleSystem.PositionType.FREE
   */
  _positionType: {
    "default": PositionType.FREE,
    formerlySerializedAs: "positionType"
  },
  positionType: {
    type: PositionType,
    get: function get() {
      return this._positionType;
    },
    set: function set(val) {
      this._positionType = val;

      this._updateMaterial();
    }
  },

  /**
   * !#en Particles emitter modes.
   * !#zh 发射器类型。
   * @property {ParticleSystem.EmitterMode} emitterMode
   * @default ParticleSystem.EmitterMode.GRAVITY
   */
  emitterMode: {
    "default": EmitterMode.GRAVITY,
    type: EmitterMode
  },
  // GRAVITY MODE

  /**
   * !#en Gravity of the emitter.
   * !#zh 重力。
   * @property {Vec2} gravity
   * @default cc.Vec2.ZERO
   */
  gravity: cc.Vec2.ZERO,

  /**
   * !#en Speed of the emitter.
   * !#zh 速度。
   * @property {Number} speed
   * @default 180
   */
  speed: 180,

  /**
   * !#en Variation of the speed.
   * !#zh 速度变化范围。
   * @property {Number} speedVar
   * @default 50
   */
  speedVar: 50,

  /**
   * !#en Tangential acceleration of each particle. Only available in 'Gravity' mode.
   * !#zh 每个粒子的切向加速度，即垂直于重力方向的加速度，只有在重力模式下可用。
   * @property {Number} tangentialAccel
   * @default 80
   */
  tangentialAccel: 80,

  /**
   * !#en Variation of the tangential acceleration.
   * !#zh 每个粒子的切向加速度变化范围。
   * @property {Number} tangentialAccelVar
   * @default 0
   */
  tangentialAccelVar: 0,

  /**
   * !#en Acceleration of each particle. Only available in 'Gravity' mode.
   * !#zh 粒子径向加速度，即平行于重力方向的加速度，只有在重力模式下可用。
   * @property {Number} radialAccel
   * @default 0
   */
  radialAccel: 0,

  /**
   * !#en Variation of the radial acceleration.
   * !#zh 粒子径向加速度变化范围。
   * @property {Number} radialAccelVar
   * @default 0
   */
  radialAccelVar: 0,

  /**
   * !#en Indicate whether the rotation of each particle equals to its direction. Only available in 'Gravity' mode.
   * !#zh 每个粒子的旋转是否等于其方向，只有在重力模式下可用。
   * @property {Boolean} rotationIsDir
   * @default false
   */
  rotationIsDir: false,
  // RADIUS MODE

  /**
   * !#en Starting radius of the particles. Only available in 'Radius' mode.
   * !#zh 初始半径，表示粒子出生时相对发射器的距离，只有在半径模式下可用。
   * @property {Number} startRadius
   * @default 0
   */
  startRadius: 0,

  /**
   * !#en Variation of the starting radius.
   * !#zh 初始半径变化范围。
   * @property {Number} startRadiusVar
   * @default 0
   */
  startRadiusVar: 0,

  /**
   * !#en Ending radius of the particles. Only available in 'Radius' mode.
   * !#zh 结束半径，只有在半径模式下可用。
   * @property {Number} endRadius
   * @default 0
   */
  endRadius: 0,

  /**
   * !#en Variation of the ending radius.
   * !#zh 结束半径变化范围。
   * @property {Number} endRadiusVar
   * @default 0
   */
  endRadiusVar: 0,

  /**
   * !#en Number of degress to rotate a particle around the source pos per second. Only available in 'Radius' mode.
   * !#zh 粒子每秒围绕起始点的旋转角度，只有在半径模式下可用。
   * @property {Number} rotatePerS
   * @default 0
   */
  rotatePerS: 0,

  /**
   * !#en Variation of the degress to rotate a particle around the source pos per second.
   * !#zh 粒子每秒围绕起始点的旋转角度变化范围。
   * @property {Number} rotatePerSVar
   * @default 0
   */
  rotatePerSVar: 0
};
/**
 * Particle System base class. <br/>
 * Attributes of a Particle System:<br/>
 *  - emmision rate of the particles<br/>
 *  - Gravity Mode (Mode A): <br/>
 *  - gravity <br/>
 *  - direction <br/>
 *  - speed +-  variance <br/>
 *  - tangential acceleration +- variance<br/>
 *  - radial acceleration +- variance<br/>
 *  - Radius Mode (Mode B):      <br/>
 *  - startRadius +- variance    <br/>
 *  - endRadius +- variance      <br/>
 *  - rotate +- variance         <br/>
 *  - Properties common to all modes: <br/>
 *  - life +- life variance      <br/>
 *  - start spin +- variance     <br/>
 *  - end spin +- variance       <br/>
 *  - start size +- variance     <br/>
 *  - end size +- variance       <br/>
 *  - start color +- variance    <br/>
 *  - end color +- variance      <br/>
 *  - life +- variance           <br/>
 *  - blending function          <br/>
 *  - texture                    <br/>
 * <br/>
 * cocos2d also supports particles generated by Particle Designer (http://particledesigner.71squared.com/).<br/>
 * 'Radius Mode' in Particle Designer uses a fixed emit rate of 30 hz. Since that can't be guarateed in cocos2d,  <br/>
 * cocos2d uses a another approach, but the results are almost identical.<br/>
 * cocos2d supports all the variables used by Particle Designer plus a bit more:  <br/>
 *  - spinning particles (supported when using ParticleSystem)       <br/>
 *  - tangential acceleration (Gravity mode)                               <br/>
 *  - radial acceleration (Gravity mode)                                   <br/>
 *  - radius direction (Radius mode) (Particle Designer supports outwards to inwards direction only) <br/>
 * It is possible to customize any of the above mentioned properties in runtime. Example:   <br/>
 *
 * @example
 * emitter.radialAccel = 15;
 * emitter.startSpin = 0;
 *
 * @class ParticleSystem
 * @extends RenderComponent
 * @uses BlendFunc
 */

var ParticleSystem = cc.Class({
  name: 'cc.ParticleSystem',
  "extends": RenderComponent,
  mixins: [BlendFunc],
  editor: CC_EDITOR && {
    menu: 'i18n:MAIN_MENU.component.renderers/ParticleSystem',
    inspector: 'packages://inspector/inspectors/comps/particle-system.js',
    playOnFocus: true,
    executeInEditMode: true
  },
  ctor: function ctor() {
    this.initProperties();
  },
  initProperties: function initProperties() {
    this._previewTimer = null;
    this._focused = false;
    this._aspectRatio = 1;
    this._simulator = new ParticleSimulator(this); // colors

    this._startColor = cc.color(255, 255, 255, 255);
    this._startColorVar = cc.color(0, 0, 0, 0);
    this._endColor = cc.color(255, 255, 255, 0);
    this._endColorVar = cc.color(0, 0, 0, 0); // The temporary SpriteFrame object used for the renderer. Because there is no corresponding asset, it can't be serialized.

    this._renderSpriteFrame = null;
  },
  properties: properties,
  statics: {
    /**
     * !#en The Particle emitter lives forever.
     * !#zh 表示发射器永久存在
     * @property {Number} DURATION_INFINITY
     * @default -1
     * @static
     * @readonly
     */
    DURATION_INFINITY: -1,

    /**
     * !#en The starting size of the particle is equal to the ending size.
     * !#zh 表示粒子的起始大小等于结束大小。
     * @property {Number} START_SIZE_EQUAL_TO_END_SIZE
     * @default -1
     * @static
     * @readonly
     */
    START_SIZE_EQUAL_TO_END_SIZE: -1,

    /**
     * !#en The starting radius of the particle is equal to the ending radius.
     * !#zh 表示粒子的起始半径等于结束半径。
     * @property {Number} START_RADIUS_EQUAL_TO_END_RADIUS
     * @default -1
     * @static
     * @readonly
     */
    START_RADIUS_EQUAL_TO_END_RADIUS: -1,
    EmitterMode: EmitterMode,
    PositionType: PositionType,
    _PNGReader: PNGReader,
    _TIFFReader: tiffReader
  },
  // EDITOR RELATED METHODS
  onFocusInEditor: CC_EDITOR && function () {
    this._focused = true;
    var components = getParticleComponents(this.node);

    for (var i = 0; i < components.length; ++i) {
      components[i]._startPreview();
    }
  },
  onLostFocusInEditor: CC_EDITOR && function () {
    this._focused = false;
    var components = getParticleComponents(this.node);

    for (var i = 0; i < components.length; ++i) {
      components[i]._stopPreview();
    }
  },
  _startPreview: CC_EDITOR && function () {
    if (this.preview) {
      this.resetSystem();
    }
  },
  _stopPreview: CC_EDITOR && function () {
    if (this.preview) {
      this.resetSystem();
      this.stopSystem();
      this.disableRender();
      cc.engine.repaintInEditMode();
    }

    if (this._previewTimer) {
      clearInterval(this._previewTimer);
    }
  },
  // LIFE-CYCLE METHODS
  // just used to read data from 1.x
  _convertTextureToSpriteFrame: CC_EDITOR && function () {
    if (this._spriteFrame) {
      return;
    }

    var texture = this.texture;

    if (!texture || !texture._uuid) {
      return;
    }

    var _this = this;

    Editor.assetdb.queryMetaInfoByUuid(texture._uuid, function (err, metaInfo) {
      if (err) return Editor.error(err);
      var meta = JSON.parse(metaInfo.json);

      if (meta.type === 'raw') {
        var NodeUtils = Editor.require('app://editor/page/scene-utils/utils/node');

        var nodePath = NodeUtils.getNodePath(_this.node);
        return Editor.warn("The texture " + metaInfo.assetUrl + " used by particle " + nodePath + " does not contain any SpriteFrame, please set the texture type to Sprite and reassign the SpriteFrame to the particle component.");
      } else {
        var Url = require('fire-url');

        var name = Url.basenameNoExt(metaInfo.assetPath);
        var uuid = meta.subMetas[name].uuid;
        cc.AssetLibrary.loadAsset(uuid, function (err, sp) {
          if (err) return Editor.error(err);
          _this.spriteFrame = sp;
        });
      }
    });
  },
  __preload: function __preload() {
    this._super();

    if (CC_EDITOR) {
      this._convertTextureToSpriteFrame();
    }

    if (this._custom && this.spriteFrame && !this._renderSpriteFrame) {
      this._applySpriteFrame(this.spriteFrame);
    } else if (this._file) {
      if (this._custom) {
        var missCustomTexture = !this._getTexture();

        if (missCustomTexture) {
          this._applyFile();
        }
      } else {
        this._applyFile();
      }
    } // auto play


    if (!CC_EDITOR || cc.engine.isPlaying) {
      if (this.playOnLoad) {
        this.resetSystem();
      }
    } // Upgrade color type from v2.0.0


    if (CC_EDITOR && !(this._startColor instanceof cc.Color)) {
      this._startColor = cc.color(this._startColor);
      this._startColorVar = cc.color(this._startColorVar);
      this._endColor = cc.color(this._endColor);
      this._endColorVar = cc.color(this._endColorVar);
    }
  },
  onDestroy: function onDestroy() {
    if (this.autoRemoveOnFinish) {
      this.autoRemoveOnFinish = false; // already removed
    }

    if (this._buffer) {
      this._buffer.destroy();

      this._buffer = null;
    } // reset uv data so next time simulator will refill buffer uv info when exit edit mode from prefab.


    this._simulator._uvFilled = 0;

    this._super();
  },
  lateUpdate: function lateUpdate(dt) {
    if (!this._simulator.finished) {
      this._simulator.step(dt);
    }
  },
  // APIS

  /*
   * !#en Add a particle to the emitter.
   * !#zh 添加一个粒子到发射器中。
   * @method addParticle
   * @return {Boolean}
   */
  addParticle: function addParticle() {// Not implemented
  },

  /**
   * !#en Stop emitting particles. Running particles will continue to run until they die.
   * !#zh 停止发射器发射粒子，发射出去的粒子将继续运行，直至粒子生命结束。
   * @method stopSystem
   * @example
   * // stop particle system.
   * myParticleSystem.stopSystem();
   */
  stopSystem: function stopSystem() {
    this._stopped = true;

    this._simulator.stop();
  },

  /**
   * !#en Kill all living particles.
   * !#zh 杀死所有存在的粒子，然后重新启动粒子发射器。
   * @method resetSystem
   * @example
   * // play particle system.
   * myParticleSystem.resetSystem();
   */
  resetSystem: function resetSystem() {
    this._stopped = false;

    this._simulator.reset();

    this.markForRender(true);
  },

  /**
   * !#en Whether or not the system is full.
   * !#zh 发射器中粒子是否大于等于设置的总粒子数量。
   * @method isFull
   * @return {Boolean}
   */
  isFull: function isFull() {
    return this.particleCount >= this.totalParticles;
  },

  /**
   * !#en Sets a new texture with a rect. The rect is in texture position and size.
   * Please use spriteFrame property instead, this function is deprecated since v1.9
   * !#zh 设置一张新贴图和关联的矩形。
   * 请直接设置 spriteFrame 属性，这个函数从 v1.9 版本开始已经被废弃
   * @method setTextureWithRect
   * @param {Texture2D} texture
   * @param {Rect} rect
   * @deprecated since v1.9
   */
  setTextureWithRect: function setTextureWithRect(texture, rect) {
    if (texture instanceof cc.Texture2D) {
      this.spriteFrame = new cc.SpriteFrame(texture, rect);
    }
  },
  // PRIVATE METHODS
  _applyFile: function _applyFile() {
    var file = this._file;

    if (file) {
      var self = this;
      cc.loader.load(file.nativeUrl, function (err, content) {
        if (err || !content) {
          cc.errorID(6029);
          return;
        }

        if (!self.isValid) {
          return;
        }

        self._plistFile = file.nativeUrl;

        if (!self._custom) {
          self._initWithDictionary(content);
        }

        if (!self._spriteFrame) {
          if (file.spriteFrame) {
            self.spriteFrame = file.spriteFrame;
          } else if (self._custom) {
            self._initTextureWithDictionary(content);
          }
        } else if (!self._renderSpriteFrame && self._spriteFrame) {
          self._applySpriteFrame(self.spriteFrame);
        }
      });
    }
  },
  _initTextureWithDictionary: function _initTextureWithDictionary(dict) {
    var imgPath = cc.path.changeBasename(this._plistFile, dict["textureFileName"] || ''); // texture

    if (dict["textureFileName"]) {
      // Try to get the texture from the cache
      textureUtil.loadImage(imgPath, function (error, texture) {
        if (error) {
          dict["textureFileName"] = undefined;

          this._initTextureWithDictionary(dict);
        } else {
          this.spriteFrame = new cc.SpriteFrame(texture);
        }
      }, this);
    } else if (dict["textureImageData"]) {
      var textureData = dict["textureImageData"];

      if (textureData && textureData.length > 0) {
        var tex = cc.loader.getRes(imgPath);

        if (!tex) {
          var buffer = codec.unzipBase64AsArray(textureData, 1);

          if (!buffer) {
            cc.logID(6030);
            return false;
          }

          var imageFormat = getImageFormatByData(buffer);

          if (imageFormat !== macro.ImageFormat.TIFF && imageFormat !== macro.ImageFormat.PNG) {
            cc.logID(6031);
            return false;
          }

          var canvasObj = document.createElement("canvas");

          if (imageFormat === macro.ImageFormat.PNG) {
            var myPngObj = new PNGReader(buffer);
            myPngObj.render(canvasObj);
          } else {
            tiffReader.parseTIFF(buffer, canvasObj);
          }

          tex = textureUtil.cacheImage(imgPath, canvasObj);
        }

        if (!tex) cc.logID(6032); // TODO: Use cc.loader to load asynchronously the SpriteFrame object, avoid using textureUtil

        this.spriteFrame = new cc.SpriteFrame(tex);
      } else {
        return false;
      }
    }

    return true;
  },
  // parsing process
  _initWithDictionary: function _initWithDictionary(dict) {
    this.totalParticles = parseInt(dict["maxParticles"] || 0); // life span

    this.life = parseFloat(dict["particleLifespan"] || 0);
    this.lifeVar = parseFloat(dict["particleLifespanVariance"] || 0); // emission Rate

    var _tempEmissionRate = dict["emissionRate"];

    if (_tempEmissionRate) {
      this.emissionRate = _tempEmissionRate;
    } else {
      this.emissionRate = Math.min(this.totalParticles / this.life, Number.MAX_VALUE);
    } // duration


    this.duration = parseFloat(dict["duration"] || 0); // blend function

    this.srcBlendFactor = parseInt(dict["blendFuncSource"] || macro.SRC_ALPHA);
    this.dstBlendFactor = parseInt(dict["blendFuncDestination"] || macro.ONE_MINUS_SRC_ALPHA); // color

    var locStartColor = this._startColor;
    locStartColor.r = parseFloat(dict["startColorRed"] || 0) * 255;
    locStartColor.g = parseFloat(dict["startColorGreen"] || 0) * 255;
    locStartColor.b = parseFloat(dict["startColorBlue"] || 0) * 255;
    locStartColor.a = parseFloat(dict["startColorAlpha"] || 0) * 255;
    var locStartColorVar = this._startColorVar;
    locStartColorVar.r = parseFloat(dict["startColorVarianceRed"] || 0) * 255;
    locStartColorVar.g = parseFloat(dict["startColorVarianceGreen"] || 0) * 255;
    locStartColorVar.b = parseFloat(dict["startColorVarianceBlue"] || 0) * 255;
    locStartColorVar.a = parseFloat(dict["startColorVarianceAlpha"] || 0) * 255;
    var locEndColor = this._endColor;
    locEndColor.r = parseFloat(dict["finishColorRed"] || 0) * 255;
    locEndColor.g = parseFloat(dict["finishColorGreen"] || 0) * 255;
    locEndColor.b = parseFloat(dict["finishColorBlue"] || 0) * 255;
    locEndColor.a = parseFloat(dict["finishColorAlpha"] || 0) * 255;
    var locEndColorVar = this._endColorVar;
    locEndColorVar.r = parseFloat(dict["finishColorVarianceRed"] || 0) * 255;
    locEndColorVar.g = parseFloat(dict["finishColorVarianceGreen"] || 0) * 255;
    locEndColorVar.b = parseFloat(dict["finishColorVarianceBlue"] || 0) * 255;
    locEndColorVar.a = parseFloat(dict["finishColorVarianceAlpha"] || 0) * 255; // particle size

    this.startSize = parseFloat(dict["startParticleSize"] || 0);
    this.startSizeVar = parseFloat(dict["startParticleSizeVariance"] || 0);
    this.endSize = parseFloat(dict["finishParticleSize"] || 0);
    this.endSizeVar = parseFloat(dict["finishParticleSizeVariance"] || 0); // position
    // Make empty positionType value and old version compatible

    this.positionType = parseFloat(dict['positionType'] !== undefined ? dict['positionType'] : PositionType.RELATIVE); // for 

    this.sourcePos.x = 0;
    this.sourcePos.y = 0;
    this.posVar.x = parseFloat(dict["sourcePositionVariancex"] || 0);
    this.posVar.y = parseFloat(dict["sourcePositionVariancey"] || 0); // angle

    this.angle = parseFloat(dict["angle"] || 0);
    this.angleVar = parseFloat(dict["angleVariance"] || 0); // Spinning

    this.startSpin = parseFloat(dict["rotationStart"] || 0);
    this.startSpinVar = parseFloat(dict["rotationStartVariance"] || 0);
    this.endSpin = parseFloat(dict["rotationEnd"] || 0);
    this.endSpinVar = parseFloat(dict["rotationEndVariance"] || 0);
    this.emitterMode = parseInt(dict["emitterType"] || EmitterMode.GRAVITY); // Mode A: Gravity + tangential accel + radial accel

    if (this.emitterMode === EmitterMode.GRAVITY) {
      // gravity
      this.gravity.x = parseFloat(dict["gravityx"] || 0);
      this.gravity.y = parseFloat(dict["gravityy"] || 0); // speed

      this.speed = parseFloat(dict["speed"] || 0);
      this.speedVar = parseFloat(dict["speedVariance"] || 0); // radial acceleration

      this.radialAccel = parseFloat(dict["radialAcceleration"] || 0);
      this.radialAccelVar = parseFloat(dict["radialAccelVariance"] || 0); // tangential acceleration

      this.tangentialAccel = parseFloat(dict["tangentialAcceleration"] || 0);
      this.tangentialAccelVar = parseFloat(dict["tangentialAccelVariance"] || 0); // rotation is dir

      var locRotationIsDir = dict["rotationIsDir"] || "";

      if (locRotationIsDir !== null) {
        locRotationIsDir = locRotationIsDir.toString().toLowerCase();
        this.rotationIsDir = locRotationIsDir === "true" || locRotationIsDir === "1";
      } else {
        this.rotationIsDir = false;
      }
    } else if (this.emitterMode === EmitterMode.RADIUS) {
      // or Mode B: radius movement
      this.startRadius = parseFloat(dict["maxRadius"] || 0);
      this.startRadiusVar = parseFloat(dict["maxRadiusVariance"] || 0);
      this.endRadius = parseFloat(dict["minRadius"] || 0);
      this.endRadiusVar = parseFloat(dict["minRadiusVariance"] || 0);
      this.rotatePerS = parseFloat(dict["rotatePerSecond"] || 0);
      this.rotatePerSVar = parseFloat(dict["rotatePerSecondVariance"] || 0);
    } else {
      cc.warnID(6009);
      return false;
    }

    this._initTextureWithDictionary(dict);

    return true;
  },
  _validateRender: function _validateRender() {
    var texture = this._getTexture();

    if (!texture || !texture.loaded) {
      this.disableRender();
      return;
    }

    this._super();
  },
  _onTextureLoaded: function _onTextureLoaded() {
    this._simulator.updateUVs(true);

    this._syncAspect();

    this._updateMaterial();

    this.markForRender(true);
  },
  _syncAspect: function _syncAspect() {
    var frameRect = this._renderSpriteFrame._rect;
    this._aspectRatio = frameRect.width / frameRect.height;
  },
  _applySpriteFrame: function _applySpriteFrame() {
    this._renderSpriteFrame = this._renderSpriteFrame || this._spriteFrame;

    if (this._renderSpriteFrame) {
      if (this._renderSpriteFrame.textureLoaded()) {
        this._onTextureLoaded();
      } else {
        this._renderSpriteFrame.onTextureLoaded(this._onTextureLoaded, this);
      }
    }
  },
  _getTexture: function _getTexture() {
    return this._renderSpriteFrame && this._renderSpriteFrame.getTexture() || this._texture;
  },
  _updateMaterial: function _updateMaterial() {
    var material = this.getMaterial(0);
    if (!material) return;
    material.define('CC_USE_MODEL', this._positionType !== PositionType.FREE);
    material.setProperty('texture', this._getTexture());

    BlendFunc.prototype._updateMaterial.call(this);
  },
  _finishedSimulation: function _finishedSimulation() {
    if (CC_EDITOR) {
      if (this.preview && this._focused && !this.active && !cc.engine.isPlaying) {
        this.resetSystem();
      }

      return;
    }

    this.resetSystem();
    this.stopSystem();
    this.disableRender();

    if (this.autoRemoveOnFinish && this._stopped) {
      this.node.destroy();
    }
  }
});
cc.ParticleSystem = module.exports = ParticleSystem;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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