
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/particle/CCPNGReader.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2011 Devon Govett
 Copyright (c) 2008-2010 Ricardo Quesada
 Copyright (c) 2011-2012 cocos2d-x.org
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 http://www.cocos2d-x.org


 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var zlib = require('../compression/zlib.min');

var debug = require('../core/CCDebug');
/**
 * A png file reader
 * @name PNGReader
 */


var PNGReader = function PNGReader(data) {
  var chunkSize, colors, delayDen, delayNum, frame, i, index, key, section, ccshort, text, _i, _j, _ref;

  this.data = data;
  this.pos = 8;
  this.palette = [];
  this.imgData = [];
  this.transparency = {};
  this.animation = null;
  this.text = {};
  frame = null;

  while (true) {
    chunkSize = this.readUInt32();

    section = function () {
      var _i, _results;

      _results = [];

      for (i = _i = 0; _i < 4; i = ++_i) {
        _results.push(String.fromCharCode(this.data[this.pos++]));
      }

      return _results;
    }.call(this).join('');

    switch (section) {
      case 'IHDR':
        this.width = this.readUInt32();
        this.height = this.readUInt32();
        this.bits = this.data[this.pos++];
        this.colorType = this.data[this.pos++];
        this.compressionMethod = this.data[this.pos++];
        this.filterMethod = this.data[this.pos++];
        this.interlaceMethod = this.data[this.pos++];
        break;

      case 'acTL':
        this.animation = {
          numFrames: this.readUInt32(),
          numPlays: this.readUInt32() || Infinity,
          frames: []
        };
        break;

      case 'PLTE':
        this.palette = this.read(chunkSize);
        break;

      case 'fcTL':
        if (frame) {
          this.animation.frames.push(frame);
        }

        this.pos += 4;
        frame = {
          width: this.readUInt32(),
          height: this.readUInt32(),
          xOffset: this.readUInt32(),
          yOffset: this.readUInt32()
        };
        delayNum = this.readUInt16();
        delayDen = this.readUInt16() || 100;
        frame.delay = 1000 * delayNum / delayDen;
        frame.disposeOp = this.data[this.pos++];
        frame.blendOp = this.data[this.pos++];
        frame.data = [];
        break;

      case 'IDAT':
      case 'fdAT':
        if (section === 'fdAT') {
          this.pos += 4;
          chunkSize -= 4;
        }

        data = (frame != null ? frame.data : void 0) || this.imgData;

        for (i = _i = 0; 0 <= chunkSize ? _i < chunkSize : _i > chunkSize; i = 0 <= chunkSize ? ++_i : --_i) {
          data.push(this.data[this.pos++]);
        }

        break;

      case 'tRNS':
        this.transparency = {};

        switch (this.colorType) {
          case 3:
            this.transparency.indexed = this.read(chunkSize);
            ccshort = 255 - this.transparency.indexed.length;

            if (ccshort > 0) {
              for (i = _j = 0; 0 <= ccshort ? _j < ccshort : _j > ccshort; i = 0 <= ccshort ? ++_j : --_j) {
                this.transparency.indexed.push(255);
              }
            }

            break;

          case 0:
            this.transparency.grayscale = this.read(chunkSize)[0];
            break;

          case 2:
            this.transparency.rgb = this.read(chunkSize);
        }

        break;

      case 'tEXt':
        text = this.read(chunkSize);
        index = text.indexOf(0);
        key = String.fromCharCode.apply(String, text.slice(0, index));
        this.text[key] = String.fromCharCode.apply(String, text.slice(index + 1));
        break;

      case 'IEND':
        if (frame) {
          this.animation.frames.push(frame);
        }

        this.colors = function () {
          switch (this.colorType) {
            case 0:
            case 3:
            case 4:
              return 1;

            case 2:
            case 6:
              return 3;
          }
        }.call(this);

        this.hasAlphaChannel = (_ref = this.colorType) === 4 || _ref === 6;
        colors = this.colors + (this.hasAlphaChannel ? 1 : 0);
        this.pixelBitlength = this.bits * colors;

        this.colorSpace = function () {
          switch (this.colors) {
            case 1:
              return 'DeviceGray';

            case 3:
              return 'DeviceRGB';
          }
        }.call(this);

        if (Uint8Array != Array) this.imgData = new Uint8Array(this.imgData);
        return;

      default:
        this.pos += chunkSize;
    }

    this.pos += 4;

    if (this.pos > this.data.length) {
      throw new Error(debug.getError(6017));
    }
  }
};

PNGReader.prototype = {
  constructor: PNGReader,
  read: function read(bytes) {
    var i, _i, _results;

    _results = [];

    for (i = _i = 0; 0 <= bytes ? _i < bytes : _i > bytes; i = 0 <= bytes ? ++_i : --_i) {
      _results.push(this.data[this.pos++]);
    }

    return _results;
  },
  readUInt32: function readUInt32() {
    var b1, b2, b3, b4;
    b1 = this.data[this.pos++] << 24;
    b2 = this.data[this.pos++] << 16;
    b3 = this.data[this.pos++] << 8;
    b4 = this.data[this.pos++];
    return b1 | b2 | b3 | b4;
  },
  readUInt16: function readUInt16() {
    var b1, b2;
    b1 = this.data[this.pos++] << 8;
    b2 = this.data[this.pos++];
    return b1 | b2;
  },
  decodePixels: function decodePixels(data) {
    var ccbyte, c, col, i, left, length, p, pa, paeth, pb, pc, pixelBytes, pixels, pos, row, scanlineLength, upper, upperLeft, _i, _j, _k, _l, _m;

    if (data == null) {
      data = this.imgData;
    }

    if (data.length === 0) {
      return new Uint8Array(0);
    }

    var inflate = new zlib.Inflate(data, {
      index: 0,
      verify: false
    });
    data = inflate.decompress();
    pixelBytes = this.pixelBitlength / 8;
    scanlineLength = pixelBytes * this.width;
    pixels = new Uint8Array(scanlineLength * this.height);
    length = data.length;
    row = 0;
    pos = 0;
    c = 0;

    while (pos < length) {
      switch (data[pos++]) {
        case 0:
          for (i = _i = 0; _i < scanlineLength; i = _i += 1) {
            pixels[c++] = data[pos++];
          }

          break;

        case 1:
          for (i = _j = 0; _j < scanlineLength; i = _j += 1) {
            ccbyte = data[pos++];
            left = i < pixelBytes ? 0 : pixels[c - pixelBytes];
            pixels[c++] = (ccbyte + left) % 256;
          }

          break;

        case 2:
          for (i = _k = 0; _k < scanlineLength; i = _k += 1) {
            ccbyte = data[pos++];
            col = (i - i % pixelBytes) / pixelBytes;
            upper = row && pixels[(row - 1) * scanlineLength + col * pixelBytes + i % pixelBytes];
            pixels[c++] = (upper + ccbyte) % 256;
          }

          break;

        case 3:
          for (i = _l = 0; _l < scanlineLength; i = _l += 1) {
            ccbyte = data[pos++];
            col = (i - i % pixelBytes) / pixelBytes;
            left = i < pixelBytes ? 0 : pixels[c - pixelBytes];
            upper = row && pixels[(row - 1) * scanlineLength + col * pixelBytes + i % pixelBytes];
            pixels[c++] = (ccbyte + Math.floor((left + upper) / 2)) % 256;
          }

          break;

        case 4:
          for (i = _m = 0; _m < scanlineLength; i = _m += 1) {
            ccbyte = data[pos++];
            col = (i - i % pixelBytes) / pixelBytes;
            left = i < pixelBytes ? 0 : pixels[c - pixelBytes];

            if (row === 0) {
              upper = upperLeft = 0;
            } else {
              upper = pixels[(row - 1) * scanlineLength + col * pixelBytes + i % pixelBytes];
              upperLeft = col && pixels[(row - 1) * scanlineLength + (col - 1) * pixelBytes + i % pixelBytes];
            }

            p = left + upper - upperLeft;
            pa = Math.abs(p - left);
            pb = Math.abs(p - upper);
            pc = Math.abs(p - upperLeft);

            if (pa <= pb && pa <= pc) {
              paeth = left;
            } else if (pb <= pc) {
              paeth = upper;
            } else {
              paeth = upperLeft;
            }

            pixels[c++] = (ccbyte + paeth) % 256;
          }

          break;

        default:
          throw new Error(debug.getError(6018, data[pos - 1]));
      }

      row++;
    }

    return pixels;
  },
  copyToImageData: function copyToImageData(imageData, pixels) {
    var alpha, colors, data, i, input, j, k, length, palette, v, _ref;

    colors = this.colors;
    palette = null;
    alpha = this.hasAlphaChannel;

    if (this.palette.length) {
      palette = (_ref = this._decodedPalette) != null ? _ref : this._decodedPalette = this.decodePalette();
      colors = 4;
      alpha = true;
    }

    data = imageData.data || imageData;
    length = data.length;
    input = palette || pixels;
    i = j = 0;

    if (colors === 1) {
      while (i < length) {
        k = palette ? pixels[i / 4] * 4 : j;
        v = input[k++];
        data[i++] = v;
        data[i++] = v;
        data[i++] = v;
        data[i++] = alpha ? input[k++] : 255;
        j = k;
      }
    } else {
      while (i < length) {
        k = palette ? pixels[i / 4] * 4 : j;
        data[i++] = input[k++];
        data[i++] = input[k++];
        data[i++] = input[k++];
        data[i++] = alpha ? input[k++] : 255;
        j = k;
      }
    }
  },
  decodePalette: function decodePalette() {
    var c, i, palette, pos, ret, transparency, _i, _ref, _ref1;

    palette = this.palette;
    transparency = this.transparency.indexed || [];
    ret = new Uint8Array((transparency.length || 0) + palette.length);
    pos = 0;
    c = 0;

    for (i = _i = 0, _ref = palette.length; _i < _ref; i = _i += 3) {
      ret[pos++] = palette[i];
      ret[pos++] = palette[i + 1];
      ret[pos++] = palette[i + 2];
      ret[pos++] = (_ref1 = transparency[c++]) != null ? _ref1 : 255;
    }

    return ret;
  },
  render: function render(canvas) {
    var ctx, data;
    canvas.width = this.width;
    canvas.height = this.height;
    ctx = canvas.getContext("2d");
    data = ctx.createImageData(this.width, this.height);
    this.copyToImageData(data, this.decodePixels());
    return ctx.putImageData(data, 0, 0);
  }
};
module.exports = PNGReader;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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