
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/deprecated.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var js = cc.js;

if (CC_DEBUG) {
  var deprecateEnum = function deprecateEnum(obj, oldPath, newPath, hasTypePrefixBefore) {
    if (!CC_SUPPORT_JIT) {
      return;
    }

    hasTypePrefixBefore = hasTypePrefixBefore !== false;
    var enumDef = Function('return ' + newPath)();
    var entries = cc.Enum.getList(enumDef);
    var delimiter = hasTypePrefixBefore ? '_' : '.';

    for (var i = 0; i < entries.length; i++) {
      var entry = entries[i].name;
      var oldPropName;

      if (hasTypePrefixBefore) {
        var oldTypeName = oldPath.split('.').slice(-1)[0];
        oldPropName = oldTypeName + '_' + entry;
      } else {
        oldPropName = entry;
      }

      js.get(obj, oldPropName, function (entry) {
        cc.errorID(1400, oldPath + delimiter + entry, newPath + '.' + entry);
        return enumDef[entry];
      }.bind(null, entry));
    }
  };

  var markAsRemoved = function markAsRemoved(ownerCtor, removedProps, ownerName) {
    if (!ownerCtor) {
      // 可能被裁剪了
      return;
    }

    ownerName = ownerName || js.getClassName(ownerCtor);
    removedProps.forEach(function (prop) {
      function error() {
        cc.errorID(1406, ownerName, prop);
      }

      js.getset(ownerCtor.prototype, prop, error, error);
    });
  };

  var markAsDeprecated = function markAsDeprecated(ownerCtor, deprecatedProps, ownerName) {
    if (!ownerCtor) {
      return;
    }

    ownerName = ownerName || js.getClassName(ownerCtor);
    var descriptors = Object.getOwnPropertyDescriptors(ownerCtor.prototype);
    deprecatedProps.forEach(function (prop) {
      var deprecatedProp = prop[0];
      var newProp = prop[1];
      var descriptor = descriptors[deprecatedProp];
      js.getset(ownerCtor.prototype, deprecatedProp, function () {
        cc.warnID(1400, ownerName + "." + deprecatedProp, ownerName + "." + newProp);
        return descriptor.get.call(this);
      }, function (v) {
        cc.warnID(1400, ownerName + "." + deprecatedProp, ownerName + "." + newProp);
        descriptor.set.call(this, v);
      });
    });
  };

  var markAsRemovedInObject = function markAsRemovedInObject(ownerObj, removedProps, ownerName) {
    if (!ownerObj) {
      // 可能被裁剪了
      return;
    }

    removedProps.forEach(function (prop) {
      function error() {
        cc.errorID(1406, ownerName, prop);
      }

      js.getset(ownerObj, prop, error);
    });
  };

  var provideClearError = function provideClearError(owner, obj, ownerName) {
    if (!owner) {
      // 可能被裁剪了
      return;
    }

    var className = ownerName || cc.js.getClassName(owner);
    var Info = 'Sorry, ' + className + '.%s is removed, please use %s instead.';

    var _loop = function _loop() {
      function define(prop, getset) {
        function accessor(newProp) {
          cc.error(Info, prop, newProp);
        }

        if (!Array.isArray(getset)) {
          getset = getset.split(',').map(function (x) {
            return x.trim();
          });
        }

        try {
          js.getset(owner, prop, accessor.bind(null, getset[0]), getset[1] && accessor.bind(null, getset[1]));
        } catch (e) {}
      }

      getset = obj[prop];

      if (prop[0] === '*') {
        // get set
        etProp = prop.slice(1);
        define('g' + etProp, getset);
        define('s' + etProp, getset);
      } else {
        prop.split(',').map(function (x) {
          return x.trim();
        }).forEach(function (x) {
          define(x, getset);
        });
      }
    };

    for (var prop in obj) {
      var getset;
      var etProp;

      _loop();
    }
  };

  var markFunctionWarning = function markFunctionWarning(ownerCtor, obj, ownerName) {
    if (!ownerCtor) {
      // 可能被裁剪了
      return;
    }

    ownerName = ownerName || js.getClassName(ownerCtor);

    for (var prop in obj) {
      (function () {
        var propName = prop;
        var originFunc = ownerCtor[propName];
        if (!originFunc) return;

        function warn() {
          cc.warn('Sorry, %s.%s is deprecated. Please use %s instead', ownerName, propName, obj[propName]);
          return originFunc.apply(this, arguments);
        }

        ownerCtor[propName] = warn;
      })();
    }
  }; // remove cc.info


  js.get(cc, 'info', function () {
    cc.errorID(1400, 'cc.info', 'cc.log');
    return cc.log;
  }); // cc.spriteFrameCache

  js.get(cc, "spriteFrameCache", function () {
    cc.errorID(1404);
  }); // cc.vmath

  js.get(cc, 'vmath', function () {
    cc.warnID(1400, 'cc.vmath', 'cc.math');
    return cc.math;
  });
  js.get(cc.math, 'vec2', function () {
    cc.warnID(1400, 'cc.vmath.vec2', 'cc.Vec2');
    return cc.Vec2;
  });
  js.get(cc.math, 'vec3', function () {
    cc.warnID(1400, 'cc.vmath.vec3', 'cc.Vec3');
    return cc.Vec3;
  });
  js.get(cc.math, 'vec4', function () {
    cc.warnID(1400, 'cc.vmath.vec4', 'cc.Vec4');
    return cc.Vec4;
  });
  js.get(cc.math, 'mat4', function () {
    cc.warnID(1400, 'cc.vmath.mat4', 'cc.Mat4');
    return cc.Mat4;
  });
  js.get(cc.math, 'mat3', function () {
    cc.warnID(1400, 'cc.vmath.mat3', 'cc.Mat3');
    return cc.Mat3;
  });
  js.get(cc.math, 'quat', function () {
    cc.warnID(1400, 'cc.vmath.quat', 'cc.Quat');
    return cc.Quat;
  }); // SpriteFrame

  js.get(cc.SpriteFrame.prototype, '_textureLoaded', function () {
    cc.errorID(1400, 'spriteFrame._textureLoaded', 'spriteFrame.textureLoaded()');
    return this.textureLoaded();
  });
  markAsRemoved(cc.SpriteFrame, ['addLoadedEventListener']);
  markFunctionWarning(cc.Sprite.prototype, {
    setState: 'cc.Sprite.setMaterial',
    getState: 'cc.Sprite.getMaterial'
  }, 'cc.Sprite');
  js.get(cc.SpriteFrame.prototype, 'clearTexture', function () {
    cc.errorID(1406, 'cc.SpriteFrame', 'clearTexture');
    return function () {};
  }); // cc.textureCache

  js.get(cc, 'textureCache', function () {
    cc.errorID(1406, 'cc', 'textureCache');
  }); // Texture

  var Texture2D = cc.Texture2D;
  js.get(Texture2D.prototype, 'releaseTexture', function () {
    cc.errorID(1400, 'texture.releaseTexture()', 'texture.destroy()');
    return this.destroy;
  });
  js.get(Texture2D.prototype, 'getName', function () {
    cc.errorID(1400, 'texture.getName()', 'texture._glID');
    return function () {
      return this._glID || null;
    };
  });
  js.get(Texture2D.prototype, 'isLoaded', function () {
    cc.errorID(1400, 'texture.isLoaded function', 'texture.loaded property');
    return function () {
      return this.loaded;
    };
  });
  js.get(Texture2D.prototype, 'setAntiAliasTexParameters', function () {
    cc.errorID(1400, 'texture.setAntiAliasTexParameters()', 'texture.setFilters(cc.Texture2D.Filter.LINEAR, cc.Texture2D.Filter.LINEAR)');
    return function () {
      this.setFilters(Texture2D.Filter.LINEAR, Texture2D.Filter.LINEAR);
    };
  });
  js.get(Texture2D.prototype, 'setAliasTexParameters', function () {
    cc.errorID(1400, 'texture.setAntiAliasTexParameters()', 'texture.setFilters(cc.Texture2D.Filter.NEAREST, cc.Texture2D.Filter.NEAREST)');
    return function () {
      this.setFilters(Texture2D.Filter.NEAREST, Texture2D.Filter.NEAREST);
    };
  }); // cc.macro

  markAsRemovedInObject(cc.macro, ['ENABLE_GL_STATE_CACHE', 'FIX_ARTIFACTS_BY_STRECHING_TEXEL'], 'cc.macro');
  provideClearError(cc.macro, {
    PI: 'Math.PI',
    PI2: 'Math.PI * 2',
    FLT_MAX: 'Number.MAX_VALUE',
    FLT_MIN: 'Number.MIN_VALUE',
    UINT_MAX: 'Number.MAX_SAFE_INTEGER'
  }, 'cc.macro'); // cc.game

  markAsRemovedInObject(cc.game, ['CONFIG_KEY'], 'cc.game'); // cc.sys

  markAsRemovedInObject(cc.sys, ['dumpRoot', 'cleanScript'], 'cc.sys'); // cc.Director

  provideClearError(cc.Director, {
    EVENT_PROJECTION_CHANGED: '',
    EVENT_BEFORE_VISIT: 'EVENT_AFTER_UPDATE',
    EVENT_AFTER_VISIT: 'EVENT_BEFORE_DRAW'
  }, 'cc.Director');
  markFunctionWarning(cc.Director.prototype, {
    convertToGL: 'cc.view.convertToLocationInView',
    convertToUI: '',
    getWinSize: 'cc.winSize',
    getWinSizeInPixels: 'cc.winSize',
    getVisibleSize: 'cc.view.getVisibleSize',
    getVisibleOrigin: 'cc.view.getVisibleOrigin',
    purgeCachedData: 'cc.loader.releaseAll',
    setDepthTest: 'cc.Camera.main.depth',
    setClearColor: 'cc.Camera.main.backgroundColor',
    getRunningScene: 'cc.director.getScene',
    getAnimationInterval: 'cc.game.getFrameRate',
    setAnimationInterval: 'cc.game.setFrameRate',
    isDisplayStats: 'cc.debug.isDisplayStats',
    setDisplayStats: 'cc.debug.setDisplayStats',
    stopAnimation: 'cc.game.pause',
    startAnimation: 'cc.game.resume'
  }, 'cc.Director');
  markAsRemoved(cc.Director, ['pushScene', 'popScene', 'popToRootScene', 'popToSceneStackLevel', 'setProjection', 'getProjection'], 'cc.Director'); // Scheduler

  provideClearError(cc.Scheduler, {
    scheduleCallbackForTarget: 'schedule',
    scheduleUpdateForTarget: 'scheduleUpdate',
    unscheduleCallbackForTarget: 'unschedule',
    unscheduleUpdateForTarget: 'unscheduleUpdate',
    unscheduleAllCallbacksForTarget: 'unscheduleAllForTarget',
    unscheduleAllCallbacks: 'unscheduleAll',
    unscheduleAllCallbacksWithMinPriority: 'unscheduleAllWithMinPriority'
  }, 'cc.Scheduler'); // cc.view

  provideClearError(cc.view, {
    adjustViewPort: 'adjustViewportMeta',
    setViewPortInPoints: 'setViewportInPoints',
    getViewPortRect: 'getViewportRect'
  }, 'cc.view');
  markAsRemovedInObject(cc.view, ['isViewReady', 'setTargetDensityDPI', 'getTargetDensityDPI', 'setFrameZoomFactor', 'canSetContentScaleFactor', 'setContentTranslateLeftTop', 'getContentTranslateLeftTop', 'setViewName', 'getViewName'], 'cc.view'); // Loader

  markAsRemoved(cc.Pipeline, ['flowInDeps', 'getItems'], 'cc.loader'); // cc.PhysicsManager

  markAsRemoved(cc.PhysicsManager, ['attachDebugDrawToCamera', 'detachDebugDrawFromCamera']); // cc.CollisionManager

  markAsRemoved(cc.CollisionManager, ['attachDebugDrawToCamera', 'detachDebugDrawFromCamera']); // cc.Node

  provideClearError(cc._BaseNode.prototype, {
    'tag': 'name',
    'getTag': 'name',
    'setTag': 'name',
    'getChildByTag': 'getChildByName',
    'removeChildByTag': 'getChildByName(name).destroy()'
  });
  markAsRemoved(cc.Node, ['_cascadeColorEnabled', 'cascadeColor', 'isCascadeColorEnabled', 'setCascadeColorEnabled', '_cascadeOpacityEnabled', 'cascadeOpacity', 'isCascadeOpacityEnabled', 'setCascadeOpacityEnabled', 'opacityModifyRGB', 'isOpacityModifyRGB', 'setOpacityModifyRGB', 'ignoreAnchor', 'isIgnoreAnchorPointForPosition', 'ignoreAnchorPointForPosition', 'isRunning', '_sgNode']);
  markFunctionWarning(cc.Node.prototype, {
    getNodeToParentTransform: 'getLocalMatrix',
    getNodeToParentTransformAR: 'getLocalMatrix',
    getNodeToWorldTransform: 'getWorldMatrix',
    getNodeToWorldTransformAR: 'getWorldMatrix',
    getParentToNodeTransform: 'getLocalMatrix',
    getWorldToNodeTransform: 'getWorldMatrix',
    convertTouchToNodeSpace: 'convertToNodeSpaceAR',
    convertTouchToNodeSpaceAR: 'convertToNodeSpaceAR',
    convertToWorldSpace: 'convertToWorldSpaceAR',
    convertToNodeSpace: 'convertToNodeSpaceAR'
  });
  provideClearError(cc.Node.prototype, {
    getRotationX: 'rotationX',
    setRotationX: 'rotationX',
    getRotationY: 'rotationY',
    setRotationY: 'rotationY',
    getPositionX: 'x',
    setPositionX: 'x',
    getPositionY: 'y',
    setPositionY: 'y',
    getSkewX: 'skewX',
    setSkewX: 'skewX',
    getSkewY: 'skewY',
    setSkewY: 'skewY',
    getScaleX: 'scaleX',
    setScaleX: 'scaleX',
    getScaleY: 'scaleY',
    setScaleY: 'scaleY',
    getOpacity: 'opacity',
    setOpacity: 'opacity',
    getColor: 'color',
    setColor: 'color',
    getLocalZOrder: 'zIndex',
    setLocalZOrder: 'zIndex'
  });
  provideClearError(cc.Sprite.prototype, {
    setInsetLeft: 'cc.SpriteFrame insetLeft',
    setInsetRight: 'cc.SpriteFrame insetRight',
    setInsetTop: 'cc.SpriteFrame insetTop',
    setInsetBottom: 'cc.SpriteFrame insetBottom'
  }); // cc.Material

  cc.Material.getInstantiatedBuiltinMaterial = cc.MaterialVariant.createWithBuiltin;
  cc.Material.getInstantiatedMaterial = cc.MaterialVariant.create;
  markFunctionWarning(cc.Material, {
    getInstantiatedBuiltinMaterial: 'cc.MaterialVariant.createWithBuiltin',
    getInstantiatedMaterial: 'cc.MaterialVariant.create'
  }); // cc.RenderComponent

  cc.js.getset(cc.RenderComponent.prototype, 'sharedMaterials', function () {
    cc.warnID(1400, 'sharedMaterials', 'getMaterials');
    return this.materials;
  }, function (v) {
    cc.warnID(1400, 'sharedMaterials', 'setMaterial');
    this.materials = v;
  }); // cc.Camera

  markFunctionWarning(cc.Camera.prototype, {
    getNodeToCameraTransform: 'getWorldToScreenMatrix2D',
    getCameraToWorldPoint: 'getScreenToWorldPoint',
    getWorldToCameraPoint: 'getWorldToScreenPoint',
    getCameraToWorldMatrix: 'getScreenToWorldMatrix2D',
    getWorldToCameraMatrix: 'getWorldToScreenMatrix2D'
  });
  markAsRemoved(cc.Camera, ['addTarget', 'removeTarget', 'getTargets']); // SCENE

  var ERR = '"%s" is not defined in the Scene, it is only defined in normal nodes.';
  CC_EDITOR || Object.defineProperties(cc.Scene.prototype, {
    active: {
      get: function get() {
        cc.error(ERR, 'active');
        return true;
      },
      set: function set() {
        cc.error(ERR, 'active');
      }
    },
    activeInHierarchy: {
      get: function get() {
        cc.error(ERR, 'activeInHierarchy');
        return true;
      }
    },
    getComponent: {
      get: function get() {
        cc.error(ERR, 'getComponent');
        return function () {
          return null;
        };
      }
    },
    addComponent: {
      get: function get() {
        cc.error(ERR, 'addComponent');
        return function () {
          return null;
        };
      }
    }
  }); // cc.dynamicAtlasManager

  markAsRemovedInObject(cc.dynamicAtlasManager, ['minFrameSize'], 'cc.dynamicAtlasManager'); // light component

  if (cc.Light) {
    markAsRemovedInObject(cc.Light.prototype, ['shadowDepthScale'], 'cc.Light.prototype');
  } // Value types


  provideClearError(cc, {
    // AffineTransform
    affineTransformMake: 'cc.AffineTransform.create',
    affineTransformMakeIdentity: 'cc.AffineTransform.identity',
    affineTransformClone: 'cc.AffineTransform.clone',
    affineTransformConcat: 'cc.AffineTransform.concat',
    affineTransformConcatIn: 'cc.AffineTransform.concat',
    affineTransformInvert: 'cc.AffineTransform.invert',
    affineTransformInvertIn: 'cc.AffineTransform.invert',
    affineTransformInvertOut: 'cc.AffineTransform.invert',
    affineTransformEqualToTransform: 'cc.AffineTransform.equal',
    pointApplyAffineTransform: 'cc.AffineTransform.transformVec2',
    sizeApplyAffineTransform: 'cc.AffineTransform.transformSize',
    rectApplyAffineTransform: 'cc.AffineTransform.transformRect',
    obbApplyAffineTransform: 'cc.AffineTransform.transformObb',
    // Vec2
    pointEqualToPoint: 'cc.Vec2 equals',
    // Size
    sizeEqualToSize: 'cc.Size equals',
    // Rect
    rectEqualToRect: 'rectA.equals(rectB)',
    rectContainsRect: 'rectA.containsRect(rectB)',
    rectContainsPoint: 'rect.contains(vec2)',
    rectOverlapsRect: 'rectA.intersects(rectB)',
    rectIntersectsRect: 'rectA.intersects(rectB)',
    rectIntersection: 'rectA.intersection(intersection, rectB)',
    rectUnion: 'rectA.union(union, rectB)',
    rectGetMaxX: 'rect.xMax',
    rectGetMidX: 'rect.center.x',
    rectGetMinX: 'rect.xMin',
    rectGetMaxY: 'rect.yMax',
    rectGetMidY: 'rect.center.y',
    rectGetMinY: 'rect.yMin',
    // Color
    colorEqual: 'colorA.equals(colorB)',
    hexToColor: 'color.fromHEX(hexColor)',
    colorToHex: 'color.toHEX()',
    // Enums
    TextAlignment: 'cc.macro.TextAlignment',
    VerticalTextAlignment: 'cc.macro.VerticalTextAlignment',
    // Point Extensions
    pNeg: 'p.neg()',
    pAdd: 'p1.add(p2)',
    pSub: 'p1.sub(p2)',
    pMult: 'p.mul(factor)',
    pMidpoint: 'p1.add(p2).mul(0.5)',
    pDot: 'p1.dot(p2)',
    pCross: 'p1.cross(p2)',
    pPerp: 'p.rotate(-90 * Math.PI / 180)',
    pRPerp: 'p.rotate(90 * Math.PI / 180)',
    pProject: 'p1.project(p2)',
    pLengthSQ: 'p.magSqr()',
    pDistanceSQ: 'p1.sub(p2).magSqr()',
    pLength: 'p.mag()',
    pDistance: 'p1.sub(p2).mag()',
    pNormalize: 'p.normalize()',
    pForAngle: 'cc.v2(Math.cos(a), Math.sin(a))',
    pToAngle: 'Math.atan2(v.y, v.x)',
    pZeroIn: 'p.x = p.y = 0',
    pIn: 'p1.set(p2)',
    pMultIn: 'p.mulSelf(factor)',
    pSubIn: 'p1.subSelf(p2)',
    pAddIn: 'p1.addSelf(p2)',
    pNormalizeIn: 'p.normalizeSelf()',
    pSameAs: 'p1.equals(p2)',
    pAngle: 'v1.angle(v2)',
    pAngleSigned: 'v1.signAngle(v2)',
    pRotateByAngle: 'p.rotate(radians)',
    pCompMult: 'v1.dot(v2)',
    pFuzzyEqual: 'v1.fuzzyEquals(v2, tolerance)',
    pLerp: 'p.lerp(endPoint, ratio)',
    pClamp: 'p.clampf(min_inclusive, max_inclusive)',
    rand: 'Math.random() * 0xffffff',
    randomMinus1To1: '(Math.random() - 0.5) * 2',
    container: 'cc.game.container',
    _canvas: 'cc.game.canvas',
    _renderType: 'cc.game.renderType',
    _getError: 'cc.debug.getError',
    _initDebugSetting: 'cc.debug._resetDebugSetting',
    DebugMode: 'cc.debug.DebugMode'
  }, 'cc');
  markAsRemovedInObject(cc, ['blendFuncDisable', 'pFromSize', 'pCompOp', 'pIntersectPoint', 'pSegmentIntersect', 'pLineIntersect', 'obbApplyMatrix', 'getImageFormatByData', 'initEngine'], 'cc');
  markFunctionWarning(cc, {
    // cc.p
    p: 'cc.v2'
  }, 'cc'); // cc.Rect

  provideClearError(cc.Rect, {
    contain: 'rectA.contains(rectB)',
    transformMat4: 'rect.transformMat4(out, mat4)'
  }); // cc.Color

  provideClearError(cc.Color, {
    rgb2hsv: 'color.toHSV()',
    hsv2rgb: 'color.fromHSV(h, s, v)'
  }); // macro functions

  js.get(cc, 'lerp', function () {
    cc.errorID(1400, 'cc.lerp', 'cc.misc.lerp');
    return cc.misc.lerp;
  });
  js.get(cc, 'random0To1', function () {
    cc.errorID(1400, 'cc.random0To1', 'Math.random');
    return Math.random;
  });
  js.get(cc, 'degreesToRadians', function () {
    cc.errorID(1400, 'cc.degreesToRadians', 'cc.misc.degreesToRadians');
    return cc.misc.degreesToRadians;
  });
  js.get(cc, 'radiansToDegrees', function () {
    cc.errorID(1400, 'cc.radiansToDegrees', 'cc.misc.radiansToDegrees');
    return cc.misc.radiansToDegrees;
  });
  js.get(cc, 'clampf', function () {
    cc.errorID(1400, 'cc.clampf', 'cc.misc.clampf');
    return cc.misc.clampf;
  });
  js.get(cc, 'clamp01', function () {
    cc.errorID(1400, 'cc.clamp01', 'cc.misc.clamp01');
    return cc.misc.clamp01;
  });
  js.get(cc, 'ImageFormat', function () {
    cc.errorID(1400, 'cc.ImageFormat', 'cc.macro.ImageFormat');
    return cc.macro.ImageFormat;
  });
  js.get(cc, 'KEY', function () {
    cc.errorID(1400, 'cc.KEY', 'cc.macro.KEY');
    return cc.macro.KEY;
  });
  js.get(cc, 'Easing', function () {
    cc.errorID(1400, 'cc.Easing', 'cc.easing');
    return cc.easing;
  }); // cc.isChildClassOf

  js.get(cc, 'isChildClassOf', function () {
    cc.errorID(1400, 'cc.isChildClassOf', 'cc.js.isChildClassOf');
    return cc.js.isChildClassOf;
  }); // dragon bones

  if (typeof dragonBones !== 'undefined') {
    js.get(dragonBones.CCFactory, 'getFactory', function () {
      cc.errorID(1400, 'dragonBones.CCFactory.getFactory', 'dragonBones.CCFactory.getInstance');
      return dragonBones.CCFactory.getInstance;
    });
  } // renderEngine


  cc.renderer.renderEngine = {
    get gfx() {
      cc.warnID(1400, 'cc.renderer.renderEngine.gfx', 'cc.gfx');
      return cc.gfx;
    },

    get math() {
      cc.warnID(1400, 'cc.renderer.renderEngine.math', 'cc.math');
      return cc.vmath;
    },

    get InputAssembler() {
      cc.warnID(1400, 'cc.renderer.renderEngine.InputAssembler', 'cc.renderer.InputAssembler');
      return cc.renderer.InputAssembler;
    }

  };
}
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9kZXByZWNhdGVkLmpzIl0sIm5hbWVzIjpbImpzIiwiY2MiLCJDQ19ERUJVRyIsImRlcHJlY2F0ZUVudW0iLCJvYmoiLCJvbGRQYXRoIiwibmV3UGF0aCIsImhhc1R5cGVQcmVmaXhCZWZvcmUiLCJDQ19TVVBQT1JUX0pJVCIsImVudW1EZWYiLCJGdW5jdGlvbiIsImVudHJpZXMiLCJFbnVtIiwiZ2V0TGlzdCIsImRlbGltaXRlciIsImkiLCJsZW5ndGgiLCJlbnRyeSIsIm5hbWUiLCJvbGRQcm9wTmFtZSIsIm9sZFR5cGVOYW1lIiwic3BsaXQiLCJzbGljZSIsImdldCIsImVycm9ySUQiLCJiaW5kIiwibWFya0FzUmVtb3ZlZCIsIm93bmVyQ3RvciIsInJlbW92ZWRQcm9wcyIsIm93bmVyTmFtZSIsImdldENsYXNzTmFtZSIsImZvckVhY2giLCJwcm9wIiwiZXJyb3IiLCJnZXRzZXQiLCJwcm90b3R5cGUiLCJtYXJrQXNEZXByZWNhdGVkIiwiZGVwcmVjYXRlZFByb3BzIiwiZGVzY3JpcHRvcnMiLCJPYmplY3QiLCJnZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3JzIiwiZGVwcmVjYXRlZFByb3AiLCJuZXdQcm9wIiwiZGVzY3JpcHRvciIsIndhcm5JRCIsImNhbGwiLCJ2Iiwic2V0IiwibWFya0FzUmVtb3ZlZEluT2JqZWN0Iiwib3duZXJPYmoiLCJwcm92aWRlQ2xlYXJFcnJvciIsIm93bmVyIiwiY2xhc3NOYW1lIiwiSW5mbyIsImRlZmluZSIsImFjY2Vzc29yIiwiQXJyYXkiLCJpc0FycmF5IiwibWFwIiwieCIsInRyaW0iLCJlIiwiZXRQcm9wIiwibWFya0Z1bmN0aW9uV2FybmluZyIsInByb3BOYW1lIiwib3JpZ2luRnVuYyIsIndhcm4iLCJhcHBseSIsImFyZ3VtZW50cyIsImxvZyIsIm1hdGgiLCJWZWMyIiwiVmVjMyIsIlZlYzQiLCJNYXQ0IiwiTWF0MyIsIlF1YXQiLCJTcHJpdGVGcmFtZSIsInRleHR1cmVMb2FkZWQiLCJTcHJpdGUiLCJzZXRTdGF0ZSIsImdldFN0YXRlIiwiVGV4dHVyZTJEIiwiZGVzdHJveSIsIl9nbElEIiwibG9hZGVkIiwic2V0RmlsdGVycyIsIkZpbHRlciIsIkxJTkVBUiIsIk5FQVJFU1QiLCJtYWNybyIsIlBJIiwiUEkyIiwiRkxUX01BWCIsIkZMVF9NSU4iLCJVSU5UX01BWCIsImdhbWUiLCJzeXMiLCJEaXJlY3RvciIsIkVWRU5UX1BST0pFQ1RJT05fQ0hBTkdFRCIsIkVWRU5UX0JFRk9SRV9WSVNJVCIsIkVWRU5UX0FGVEVSX1ZJU0lUIiwiY29udmVydFRvR0wiLCJjb252ZXJ0VG9VSSIsImdldFdpblNpemUiLCJnZXRXaW5TaXplSW5QaXhlbHMiLCJnZXRWaXNpYmxlU2l6ZSIsImdldFZpc2libGVPcmlnaW4iLCJwdXJnZUNhY2hlZERhdGEiLCJzZXREZXB0aFRlc3QiLCJzZXRDbGVhckNvbG9yIiwiZ2V0UnVubmluZ1NjZW5lIiwiZ2V0QW5pbWF0aW9uSW50ZXJ2YWwiLCJzZXRBbmltYXRpb25JbnRlcnZhbCIsImlzRGlzcGxheVN0YXRzIiwic2V0RGlzcGxheVN0YXRzIiwic3RvcEFuaW1hdGlvbiIsInN0YXJ0QW5pbWF0aW9uIiwiU2NoZWR1bGVyIiwic2NoZWR1bGVDYWxsYmFja0ZvclRhcmdldCIsInNjaGVkdWxlVXBkYXRlRm9yVGFyZ2V0IiwidW5zY2hlZHVsZUNhbGxiYWNrRm9yVGFyZ2V0IiwidW5zY2hlZHVsZVVwZGF0ZUZvclRhcmdldCIsInVuc2NoZWR1bGVBbGxDYWxsYmFja3NGb3JUYXJnZXQiLCJ1bnNjaGVkdWxlQWxsQ2FsbGJhY2tzIiwidW5zY2hlZHVsZUFsbENhbGxiYWNrc1dpdGhNaW5Qcmlvcml0eSIsInZpZXciLCJhZGp1c3RWaWV3UG9ydCIsInNldFZpZXdQb3J0SW5Qb2ludHMiLCJnZXRWaWV3UG9ydFJlY3QiLCJQaXBlbGluZSIsIlBoeXNpY3NNYW5hZ2VyIiwiQ29sbGlzaW9uTWFuYWdlciIsIl9CYXNlTm9kZSIsIk5vZGUiLCJnZXROb2RlVG9QYXJlbnRUcmFuc2Zvcm0iLCJnZXROb2RlVG9QYXJlbnRUcmFuc2Zvcm1BUiIsImdldE5vZGVUb1dvcmxkVHJhbnNmb3JtIiwiZ2V0Tm9kZVRvV29ybGRUcmFuc2Zvcm1BUiIsImdldFBhcmVudFRvTm9kZVRyYW5zZm9ybSIsImdldFdvcmxkVG9Ob2RlVHJhbnNmb3JtIiwiY29udmVydFRvdWNoVG9Ob2RlU3BhY2UiLCJjb252ZXJ0VG91Y2hUb05vZGVTcGFjZUFSIiwiY29udmVydFRvV29ybGRTcGFjZSIsImNvbnZlcnRUb05vZGVTcGFjZSIsImdldFJvdGF0aW9uWCIsInNldFJvdGF0aW9uWCIsImdldFJvdGF0aW9uWSIsInNldFJvdGF0aW9uWSIsImdldFBvc2l0aW9uWCIsInNldFBvc2l0aW9uWCIsImdldFBvc2l0aW9uWSIsInNldFBvc2l0aW9uWSIsImdldFNrZXdYIiwic2V0U2tld1giLCJnZXRTa2V3WSIsInNldFNrZXdZIiwiZ2V0U2NhbGVYIiwic2V0U2NhbGVYIiwiZ2V0U2NhbGVZIiwic2V0U2NhbGVZIiwiZ2V0T3BhY2l0eSIsInNldE9wYWNpdHkiLCJnZXRDb2xvciIsInNldENvbG9yIiwiZ2V0TG9jYWxaT3JkZXIiLCJzZXRMb2NhbFpPcmRlciIsInNldEluc2V0TGVmdCIsInNldEluc2V0UmlnaHQiLCJzZXRJbnNldFRvcCIsInNldEluc2V0Qm90dG9tIiwiTWF0ZXJpYWwiLCJnZXRJbnN0YW50aWF0ZWRCdWlsdGluTWF0ZXJpYWwiLCJNYXRlcmlhbFZhcmlhbnQiLCJjcmVhdGVXaXRoQnVpbHRpbiIsImdldEluc3RhbnRpYXRlZE1hdGVyaWFsIiwiY3JlYXRlIiwiUmVuZGVyQ29tcG9uZW50IiwibWF0ZXJpYWxzIiwiQ2FtZXJhIiwiZ2V0Tm9kZVRvQ2FtZXJhVHJhbnNmb3JtIiwiZ2V0Q2FtZXJhVG9Xb3JsZFBvaW50IiwiZ2V0V29ybGRUb0NhbWVyYVBvaW50IiwiZ2V0Q2FtZXJhVG9Xb3JsZE1hdHJpeCIsImdldFdvcmxkVG9DYW1lcmFNYXRyaXgiLCJFUlIiLCJDQ19FRElUT1IiLCJkZWZpbmVQcm9wZXJ0aWVzIiwiU2NlbmUiLCJhY3RpdmUiLCJhY3RpdmVJbkhpZXJhcmNoeSIsImdldENvbXBvbmVudCIsImFkZENvbXBvbmVudCIsImR5bmFtaWNBdGxhc01hbmFnZXIiLCJMaWdodCIsImFmZmluZVRyYW5zZm9ybU1ha2UiLCJhZmZpbmVUcmFuc2Zvcm1NYWtlSWRlbnRpdHkiLCJhZmZpbmVUcmFuc2Zvcm1DbG9uZSIsImFmZmluZVRyYW5zZm9ybUNvbmNhdCIsImFmZmluZVRyYW5zZm9ybUNvbmNhdEluIiwiYWZmaW5lVHJhbnNmb3JtSW52ZXJ0IiwiYWZmaW5lVHJhbnNmb3JtSW52ZXJ0SW4iLCJhZmZpbmVUcmFuc2Zvcm1JbnZlcnRPdXQiLCJhZmZpbmVUcmFuc2Zvcm1FcXVhbFRvVHJhbnNmb3JtIiwicG9pbnRBcHBseUFmZmluZVRyYW5zZm9ybSIsInNpemVBcHBseUFmZmluZVRyYW5zZm9ybSIsInJlY3RBcHBseUFmZmluZVRyYW5zZm9ybSIsIm9iYkFwcGx5QWZmaW5lVHJhbnNmb3JtIiwicG9pbnRFcXVhbFRvUG9pbnQiLCJzaXplRXF1YWxUb1NpemUiLCJyZWN0RXF1YWxUb1JlY3QiLCJyZWN0Q29udGFpbnNSZWN0IiwicmVjdENvbnRhaW5zUG9pbnQiLCJyZWN0T3ZlcmxhcHNSZWN0IiwicmVjdEludGVyc2VjdHNSZWN0IiwicmVjdEludGVyc2VjdGlvbiIsInJlY3RVbmlvbiIsInJlY3RHZXRNYXhYIiwicmVjdEdldE1pZFgiLCJyZWN0R2V0TWluWCIsInJlY3RHZXRNYXhZIiwicmVjdEdldE1pZFkiLCJyZWN0R2V0TWluWSIsImNvbG9yRXF1YWwiLCJoZXhUb0NvbG9yIiwiY29sb3JUb0hleCIsIlRleHRBbGlnbm1lbnQiLCJWZXJ0aWNhbFRleHRBbGlnbm1lbnQiLCJwTmVnIiwicEFkZCIsInBTdWIiLCJwTXVsdCIsInBNaWRwb2ludCIsInBEb3QiLCJwQ3Jvc3MiLCJwUGVycCIsInBSUGVycCIsInBQcm9qZWN0IiwicExlbmd0aFNRIiwicERpc3RhbmNlU1EiLCJwTGVuZ3RoIiwicERpc3RhbmNlIiwicE5vcm1hbGl6ZSIsInBGb3JBbmdsZSIsInBUb0FuZ2xlIiwicFplcm9JbiIsInBJbiIsInBNdWx0SW4iLCJwU3ViSW4iLCJwQWRkSW4iLCJwTm9ybWFsaXplSW4iLCJwU2FtZUFzIiwicEFuZ2xlIiwicEFuZ2xlU2lnbmVkIiwicFJvdGF0ZUJ5QW5nbGUiLCJwQ29tcE11bHQiLCJwRnV6enlFcXVhbCIsInBMZXJwIiwicENsYW1wIiwicmFuZCIsInJhbmRvbU1pbnVzMVRvMSIsImNvbnRhaW5lciIsIl9jYW52YXMiLCJfcmVuZGVyVHlwZSIsIl9nZXRFcnJvciIsIl9pbml0RGVidWdTZXR0aW5nIiwiRGVidWdNb2RlIiwicCIsIlJlY3QiLCJjb250YWluIiwidHJhbnNmb3JtTWF0NCIsIkNvbG9yIiwicmdiMmhzdiIsImhzdjJyZ2IiLCJtaXNjIiwibGVycCIsIk1hdGgiLCJyYW5kb20iLCJkZWdyZWVzVG9SYWRpYW5zIiwicmFkaWFuc1RvRGVncmVlcyIsImNsYW1wZiIsImNsYW1wMDEiLCJJbWFnZUZvcm1hdCIsIktFWSIsImVhc2luZyIsImlzQ2hpbGRDbGFzc09mIiwiZHJhZ29uQm9uZXMiLCJDQ0ZhY3RvcnkiLCJnZXRJbnN0YW5jZSIsInJlbmRlcmVyIiwicmVuZGVyRW5naW5lIiwiZ2Z4Iiwidm1hdGgiLCJJbnB1dEFzc2VtYmxlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7OztBQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUEwQkEsSUFBSUEsRUFBRSxHQUFHQyxFQUFFLENBQUNELEVBQVo7O0FBRUEsSUFBSUUsUUFBSixFQUFjO0FBQUEsTUFFREMsYUFGQyxHQUVWLFNBQVNBLGFBQVQsQ0FBd0JDLEdBQXhCLEVBQTZCQyxPQUE3QixFQUFzQ0MsT0FBdEMsRUFBK0NDLG1CQUEvQyxFQUFvRTtBQUNoRSxRQUFJLENBQUNDLGNBQUwsRUFBcUI7QUFDakI7QUFDSDs7QUFDREQsSUFBQUEsbUJBQW1CLEdBQUdBLG1CQUFtQixLQUFLLEtBQTlDO0FBQ0EsUUFBSUUsT0FBTyxHQUFHQyxRQUFRLENBQUMsWUFBWUosT0FBYixDQUFSLEVBQWQ7QUFDQSxRQUFJSyxPQUFPLEdBQUdWLEVBQUUsQ0FBQ1csSUFBSCxDQUFRQyxPQUFSLENBQWdCSixPQUFoQixDQUFkO0FBQ0EsUUFBSUssU0FBUyxHQUFHUCxtQkFBbUIsR0FBRyxHQUFILEdBQVMsR0FBNUM7O0FBQ0EsU0FBSyxJQUFJUSxDQUFDLEdBQUcsQ0FBYixFQUFnQkEsQ0FBQyxHQUFHSixPQUFPLENBQUNLLE1BQTVCLEVBQW9DRCxDQUFDLEVBQXJDLEVBQXlDO0FBQ3JDLFVBQUlFLEtBQUssR0FBR04sT0FBTyxDQUFDSSxDQUFELENBQVAsQ0FBV0csSUFBdkI7QUFDQSxVQUFJQyxXQUFKOztBQUNBLFVBQUlaLG1CQUFKLEVBQXlCO0FBQ3JCLFlBQUlhLFdBQVcsR0FBR2YsT0FBTyxDQUFDZ0IsS0FBUixDQUFjLEdBQWQsRUFBbUJDLEtBQW5CLENBQXlCLENBQUMsQ0FBMUIsRUFBNkIsQ0FBN0IsQ0FBbEI7QUFDQUgsUUFBQUEsV0FBVyxHQUFHQyxXQUFXLEdBQUcsR0FBZCxHQUFvQkgsS0FBbEM7QUFDSCxPQUhELE1BSUs7QUFDREUsUUFBQUEsV0FBVyxHQUFHRixLQUFkO0FBQ0g7O0FBQ0RqQixNQUFBQSxFQUFFLENBQUN1QixHQUFILENBQU9uQixHQUFQLEVBQVllLFdBQVosRUFBeUIsVUFBVUYsS0FBVixFQUFpQjtBQUN0Q2hCLFFBQUFBLEVBQUUsQ0FBQ3VCLE9BQUgsQ0FBVyxJQUFYLEVBQWlCbkIsT0FBTyxHQUFHUyxTQUFWLEdBQXNCRyxLQUF2QyxFQUE4Q1gsT0FBTyxHQUFHLEdBQVYsR0FBZ0JXLEtBQTlEO0FBQ0EsZUFBT1IsT0FBTyxDQUFDUSxLQUFELENBQWQ7QUFDSCxPQUh3QixDQUd2QlEsSUFIdUIsQ0FHbEIsSUFIa0IsRUFHWlIsS0FIWSxDQUF6QjtBQUlIO0FBQ0osR0F6QlM7O0FBQUEsTUEyQkRTLGFBM0JDLEdBMkJWLFNBQVNBLGFBQVQsQ0FBd0JDLFNBQXhCLEVBQW1DQyxZQUFuQyxFQUFpREMsU0FBakQsRUFBNEQ7QUFDeEQsUUFBSSxDQUFDRixTQUFMLEVBQWdCO0FBQ1o7QUFDQTtBQUNIOztBQUNERSxJQUFBQSxTQUFTLEdBQUdBLFNBQVMsSUFBSTdCLEVBQUUsQ0FBQzhCLFlBQUgsQ0FBZ0JILFNBQWhCLENBQXpCO0FBQ0FDLElBQUFBLFlBQVksQ0FBQ0csT0FBYixDQUFxQixVQUFVQyxJQUFWLEVBQWdCO0FBQ2pDLGVBQVNDLEtBQVQsR0FBa0I7QUFDZGhDLFFBQUFBLEVBQUUsQ0FBQ3VCLE9BQUgsQ0FBVyxJQUFYLEVBQWlCSyxTQUFqQixFQUE0QkcsSUFBNUI7QUFDSDs7QUFDRGhDLE1BQUFBLEVBQUUsQ0FBQ2tDLE1BQUgsQ0FBVVAsU0FBUyxDQUFDUSxTQUFwQixFQUErQkgsSUFBL0IsRUFBcUNDLEtBQXJDLEVBQTRDQSxLQUE1QztBQUNILEtBTEQ7QUFNSCxHQXZDUzs7QUFBQSxNQXlDREcsZ0JBekNDLEdBeUNWLFNBQVNBLGdCQUFULENBQTJCVCxTQUEzQixFQUFzQ1UsZUFBdEMsRUFBdURSLFNBQXZELEVBQWtFO0FBQzlELFFBQUksQ0FBQ0YsU0FBTCxFQUFnQjtBQUNaO0FBQ0g7O0FBQ0RFLElBQUFBLFNBQVMsR0FBR0EsU0FBUyxJQUFJN0IsRUFBRSxDQUFDOEIsWUFBSCxDQUFnQkgsU0FBaEIsQ0FBekI7QUFDQSxRQUFJVyxXQUFXLEdBQUdDLE1BQU0sQ0FBQ0MseUJBQVAsQ0FBaUNiLFNBQVMsQ0FBQ1EsU0FBM0MsQ0FBbEI7QUFDQUUsSUFBQUEsZUFBZSxDQUFDTixPQUFoQixDQUF3QixVQUFVQyxJQUFWLEVBQWdCO0FBQ3BDLFVBQUlTLGNBQWMsR0FBR1QsSUFBSSxDQUFDLENBQUQsQ0FBekI7QUFDQSxVQUFJVSxPQUFPLEdBQUdWLElBQUksQ0FBQyxDQUFELENBQWxCO0FBQ0EsVUFBSVcsVUFBVSxHQUFHTCxXQUFXLENBQUNHLGNBQUQsQ0FBNUI7QUFDQXpDLE1BQUFBLEVBQUUsQ0FBQ2tDLE1BQUgsQ0FBVVAsU0FBUyxDQUFDUSxTQUFwQixFQUErQk0sY0FBL0IsRUFBK0MsWUFBWTtBQUN2RHhDLFFBQUFBLEVBQUUsQ0FBQzJDLE1BQUgsQ0FBVSxJQUFWLEVBQW1CZixTQUFuQixTQUFnQ1ksY0FBaEMsRUFBcURaLFNBQXJELFNBQWtFYSxPQUFsRTtBQUNBLGVBQU9DLFVBQVUsQ0FBQ3BCLEdBQVgsQ0FBZXNCLElBQWYsQ0FBb0IsSUFBcEIsQ0FBUDtBQUNILE9BSEQsRUFHRyxVQUFVQyxDQUFWLEVBQWE7QUFDWjdDLFFBQUFBLEVBQUUsQ0FBQzJDLE1BQUgsQ0FBVSxJQUFWLEVBQW1CZixTQUFuQixTQUFnQ1ksY0FBaEMsRUFBcURaLFNBQXJELFNBQWtFYSxPQUFsRTtBQUNBQyxRQUFBQSxVQUFVLENBQUNJLEdBQVgsQ0FBZUYsSUFBZixDQUFvQixJQUFwQixFQUEwQkMsQ0FBMUI7QUFDSCxPQU5EO0FBT0gsS0FYRDtBQVlILEdBM0RTOztBQUFBLE1BNkRERSxxQkE3REMsR0E2RFYsU0FBU0EscUJBQVQsQ0FBZ0NDLFFBQWhDLEVBQTBDckIsWUFBMUMsRUFBd0RDLFNBQXhELEVBQW1FO0FBQy9ELFFBQUksQ0FBQ29CLFFBQUwsRUFBZTtBQUNYO0FBQ0E7QUFDSDs7QUFDRHJCLElBQUFBLFlBQVksQ0FBQ0csT0FBYixDQUFxQixVQUFVQyxJQUFWLEVBQWdCO0FBQ2pDLGVBQVNDLEtBQVQsR0FBa0I7QUFDZGhDLFFBQUFBLEVBQUUsQ0FBQ3VCLE9BQUgsQ0FBVyxJQUFYLEVBQWlCSyxTQUFqQixFQUE0QkcsSUFBNUI7QUFDSDs7QUFDRGhDLE1BQUFBLEVBQUUsQ0FBQ2tDLE1BQUgsQ0FBVWUsUUFBVixFQUFvQmpCLElBQXBCLEVBQTBCQyxLQUExQjtBQUNILEtBTEQ7QUFNSCxHQXhFUzs7QUFBQSxNQTBFRGlCLGlCQTFFQyxHQTBFVixTQUFTQSxpQkFBVCxDQUE0QkMsS0FBNUIsRUFBbUMvQyxHQUFuQyxFQUF3Q3lCLFNBQXhDLEVBQW1EO0FBQy9DLFFBQUksQ0FBQ3NCLEtBQUwsRUFBWTtBQUNSO0FBQ0E7QUFDSDs7QUFDRCxRQUFJQyxTQUFTLEdBQUd2QixTQUFTLElBQUk1QixFQUFFLENBQUNELEVBQUgsQ0FBTThCLFlBQU4sQ0FBbUJxQixLQUFuQixDQUE3QjtBQUNBLFFBQUlFLElBQUksR0FBRyxZQUFZRCxTQUFaLEdBQXdCLHdDQUFuQzs7QUFOK0M7QUFRM0MsZUFBU0UsTUFBVCxDQUFpQnRCLElBQWpCLEVBQXVCRSxNQUF2QixFQUErQjtBQUMzQixpQkFBU3FCLFFBQVQsQ0FBbUJiLE9BQW5CLEVBQTRCO0FBQ3hCekMsVUFBQUEsRUFBRSxDQUFDZ0MsS0FBSCxDQUFTb0IsSUFBVCxFQUFlckIsSUFBZixFQUFxQlUsT0FBckI7QUFDSDs7QUFDRCxZQUFJLENBQUNjLEtBQUssQ0FBQ0MsT0FBTixDQUFjdkIsTUFBZCxDQUFMLEVBQTRCO0FBQ3hCQSxVQUFBQSxNQUFNLEdBQUdBLE1BQU0sQ0FBQ2IsS0FBUCxDQUFhLEdBQWIsRUFDSnFDLEdBREksQ0FDQSxVQUFVQyxDQUFWLEVBQWE7QUFDZCxtQkFBT0EsQ0FBQyxDQUFDQyxJQUFGLEVBQVA7QUFDSCxXQUhJLENBQVQ7QUFJSDs7QUFDRCxZQUFJO0FBQ0E1RCxVQUFBQSxFQUFFLENBQUNrQyxNQUFILENBQVVpQixLQUFWLEVBQWlCbkIsSUFBakIsRUFBdUJ1QixRQUFRLENBQUM5QixJQUFULENBQWMsSUFBZCxFQUFvQlMsTUFBTSxDQUFDLENBQUQsQ0FBMUIsQ0FBdkIsRUFBdURBLE1BQU0sQ0FBQyxDQUFELENBQU4sSUFBYXFCLFFBQVEsQ0FBQzlCLElBQVQsQ0FBYyxJQUFkLEVBQW9CUyxNQUFNLENBQUMsQ0FBRCxDQUExQixDQUFwRTtBQUNILFNBRkQsQ0FHQSxPQUFPMkIsQ0FBUCxFQUFVLENBQUU7QUFDZjs7QUFDRzNCLE1BQUFBLE1BQU0sR0FBRzlCLEdBQUcsQ0FBQzRCLElBQUQsQ0F2QjJCOztBQXdCM0MsVUFBSUEsSUFBSSxDQUFDLENBQUQsQ0FBSixLQUFZLEdBQWhCLEVBQXFCO0FBQ2pCO0FBQ0k4QixRQUFBQSxNQUFNLEdBQUc5QixJQUFJLENBQUNWLEtBQUwsQ0FBVyxDQUFYLENBRkk7QUFHakJnQyxRQUFBQSxNQUFNLENBQUMsTUFBTVEsTUFBUCxFQUFlNUIsTUFBZixDQUFOO0FBQ0FvQixRQUFBQSxNQUFNLENBQUMsTUFBTVEsTUFBUCxFQUFlNUIsTUFBZixDQUFOO0FBQ0gsT0FMRCxNQU1LO0FBQ0RGLFFBQUFBLElBQUksQ0FBQ1gsS0FBTCxDQUFXLEdBQVgsRUFDS3FDLEdBREwsQ0FDUyxVQUFVQyxDQUFWLEVBQWE7QUFDZCxpQkFBT0EsQ0FBQyxDQUFDQyxJQUFGLEVBQVA7QUFDSCxTQUhMLEVBSUs3QixPQUpMLENBSWEsVUFBVTRCLENBQVYsRUFBYTtBQUNsQkwsVUFBQUEsTUFBTSxDQUFDSyxDQUFELEVBQUl6QixNQUFKLENBQU47QUFDSCxTQU5MO0FBT0g7QUF0QzBDOztBQU8vQyxTQUFLLElBQUlGLElBQVQsSUFBaUI1QixHQUFqQixFQUFzQjtBQUFBLFVBZ0JkOEIsTUFoQmM7QUFBQSxVQW1CVjRCLE1BbkJVOztBQUFBO0FBZ0NyQjtBQUNKLEdBbEhTOztBQUFBLE1Bb0hEQyxtQkFwSEMsR0FvSFYsU0FBU0EsbUJBQVQsQ0FBOEJwQyxTQUE5QixFQUF5Q3ZCLEdBQXpDLEVBQThDeUIsU0FBOUMsRUFBeUQ7QUFDckQsUUFBSSxDQUFDRixTQUFMLEVBQWdCO0FBQ1o7QUFDQTtBQUNIOztBQUNERSxJQUFBQSxTQUFTLEdBQUdBLFNBQVMsSUFBSTdCLEVBQUUsQ0FBQzhCLFlBQUgsQ0FBZ0JILFNBQWhCLENBQXpCOztBQUNBLFNBQUssSUFBSUssSUFBVCxJQUFpQjVCLEdBQWpCLEVBQXNCO0FBQ2xCLE9BQUMsWUFBVTtBQUNQLFlBQUk0RCxRQUFRLEdBQUdoQyxJQUFmO0FBQ0EsWUFBSWlDLFVBQVUsR0FBR3RDLFNBQVMsQ0FBQ3FDLFFBQUQsQ0FBMUI7QUFDQSxZQUFJLENBQUNDLFVBQUwsRUFBaUI7O0FBRWpCLGlCQUFTQyxJQUFULEdBQWlCO0FBQ2JqRSxVQUFBQSxFQUFFLENBQUNpRSxJQUFILENBQVEsbURBQVIsRUFBNkRyQyxTQUE3RCxFQUF3RW1DLFFBQXhFLEVBQWtGNUQsR0FBRyxDQUFDNEQsUUFBRCxDQUFyRjtBQUNBLGlCQUFPQyxVQUFVLENBQUNFLEtBQVgsQ0FBaUIsSUFBakIsRUFBdUJDLFNBQXZCLENBQVA7QUFDSDs7QUFFRHpDLFFBQUFBLFNBQVMsQ0FBQ3FDLFFBQUQsQ0FBVCxHQUFzQkUsSUFBdEI7QUFDSCxPQVhEO0FBWUg7QUFDSixHQXhJUyxFQXlJVjs7O0FBQ0FsRSxFQUFBQSxFQUFFLENBQUN1QixHQUFILENBQU90QixFQUFQLEVBQVcsTUFBWCxFQUFtQixZQUFZO0FBQzNCQSxJQUFBQSxFQUFFLENBQUN1QixPQUFILENBQVcsSUFBWCxFQUFpQixTQUFqQixFQUE0QixRQUE1QjtBQUNBLFdBQU92QixFQUFFLENBQUNvRSxHQUFWO0FBQ0gsR0FIRCxFQTFJVSxDQThJVjs7QUFDQXJFLEVBQUFBLEVBQUUsQ0FBQ3VCLEdBQUgsQ0FBT3RCLEVBQVAsRUFBVyxrQkFBWCxFQUErQixZQUFZO0FBQ3ZDQSxJQUFBQSxFQUFFLENBQUN1QixPQUFILENBQVcsSUFBWDtBQUNILEdBRkQsRUEvSVUsQ0FtSlY7O0FBQ0F4QixFQUFBQSxFQUFFLENBQUN1QixHQUFILENBQU90QixFQUFQLEVBQVcsT0FBWCxFQUFvQixZQUFZO0FBQzVCQSxJQUFBQSxFQUFFLENBQUMyQyxNQUFILENBQVUsSUFBVixFQUFnQixVQUFoQixFQUE0QixTQUE1QjtBQUNBLFdBQU8zQyxFQUFFLENBQUNxRSxJQUFWO0FBQ0gsR0FIRDtBQUlBdEUsRUFBQUEsRUFBRSxDQUFDdUIsR0FBSCxDQUFPdEIsRUFBRSxDQUFDcUUsSUFBVixFQUFnQixNQUFoQixFQUF3QixZQUFZO0FBQ2hDckUsSUFBQUEsRUFBRSxDQUFDMkMsTUFBSCxDQUFVLElBQVYsRUFBZ0IsZUFBaEIsRUFBaUMsU0FBakM7QUFDQSxXQUFPM0MsRUFBRSxDQUFDc0UsSUFBVjtBQUNILEdBSEQ7QUFJQXZFLEVBQUFBLEVBQUUsQ0FBQ3VCLEdBQUgsQ0FBT3RCLEVBQUUsQ0FBQ3FFLElBQVYsRUFBZ0IsTUFBaEIsRUFBd0IsWUFBWTtBQUNoQ3JFLElBQUFBLEVBQUUsQ0FBQzJDLE1BQUgsQ0FBVSxJQUFWLEVBQWdCLGVBQWhCLEVBQWlDLFNBQWpDO0FBQ0EsV0FBTzNDLEVBQUUsQ0FBQ3VFLElBQVY7QUFDSCxHQUhEO0FBSUF4RSxFQUFBQSxFQUFFLENBQUN1QixHQUFILENBQU90QixFQUFFLENBQUNxRSxJQUFWLEVBQWdCLE1BQWhCLEVBQXdCLFlBQVk7QUFDaENyRSxJQUFBQSxFQUFFLENBQUMyQyxNQUFILENBQVUsSUFBVixFQUFnQixlQUFoQixFQUFpQyxTQUFqQztBQUNBLFdBQU8zQyxFQUFFLENBQUN3RSxJQUFWO0FBQ0gsR0FIRDtBQUlBekUsRUFBQUEsRUFBRSxDQUFDdUIsR0FBSCxDQUFPdEIsRUFBRSxDQUFDcUUsSUFBVixFQUFnQixNQUFoQixFQUF3QixZQUFZO0FBQ2hDckUsSUFBQUEsRUFBRSxDQUFDMkMsTUFBSCxDQUFVLElBQVYsRUFBZ0IsZUFBaEIsRUFBaUMsU0FBakM7QUFDQSxXQUFPM0MsRUFBRSxDQUFDeUUsSUFBVjtBQUNILEdBSEQ7QUFJQTFFLEVBQUFBLEVBQUUsQ0FBQ3VCLEdBQUgsQ0FBT3RCLEVBQUUsQ0FBQ3FFLElBQVYsRUFBZ0IsTUFBaEIsRUFBd0IsWUFBWTtBQUNoQ3JFLElBQUFBLEVBQUUsQ0FBQzJDLE1BQUgsQ0FBVSxJQUFWLEVBQWdCLGVBQWhCLEVBQWlDLFNBQWpDO0FBQ0EsV0FBTzNDLEVBQUUsQ0FBQzBFLElBQVY7QUFDSCxHQUhEO0FBSUEzRSxFQUFBQSxFQUFFLENBQUN1QixHQUFILENBQU90QixFQUFFLENBQUNxRSxJQUFWLEVBQWdCLE1BQWhCLEVBQXdCLFlBQVk7QUFDaENyRSxJQUFBQSxFQUFFLENBQUMyQyxNQUFILENBQVUsSUFBVixFQUFnQixlQUFoQixFQUFpQyxTQUFqQztBQUNBLFdBQU8zQyxFQUFFLENBQUMyRSxJQUFWO0FBQ0gsR0FIRCxFQTVLVSxDQWlMVjs7QUFDQTVFLEVBQUFBLEVBQUUsQ0FBQ3VCLEdBQUgsQ0FBT3RCLEVBQUUsQ0FBQzRFLFdBQUgsQ0FBZTFDLFNBQXRCLEVBQWlDLGdCQUFqQyxFQUFtRCxZQUFZO0FBQzNEbEMsSUFBQUEsRUFBRSxDQUFDdUIsT0FBSCxDQUFXLElBQVgsRUFBaUIsNEJBQWpCLEVBQStDLDZCQUEvQztBQUNBLFdBQU8sS0FBS3NELGFBQUwsRUFBUDtBQUNILEdBSEQ7QUFJQXBELEVBQUFBLGFBQWEsQ0FBQ3pCLEVBQUUsQ0FBQzRFLFdBQUosRUFBaUIsQ0FDMUIsd0JBRDBCLENBQWpCLENBQWI7QUFHQWQsRUFBQUEsbUJBQW1CLENBQUM5RCxFQUFFLENBQUM4RSxNQUFILENBQVU1QyxTQUFYLEVBQXNCO0FBQ3JDNkMsSUFBQUEsUUFBUSxFQUFFLHVCQUQyQjtBQUVyQ0MsSUFBQUEsUUFBUSxFQUFFO0FBRjJCLEdBQXRCLEVBR2hCLFdBSGdCLENBQW5CO0FBS0FqRixFQUFBQSxFQUFFLENBQUN1QixHQUFILENBQU90QixFQUFFLENBQUM0RSxXQUFILENBQWUxQyxTQUF0QixFQUFpQyxjQUFqQyxFQUFpRCxZQUFZO0FBQ3pEbEMsSUFBQUEsRUFBRSxDQUFDdUIsT0FBSCxDQUFXLElBQVgsRUFBaUIsZ0JBQWpCLEVBQW1DLGNBQW5DO0FBQ0EsV0FBTyxZQUFZLENBQUUsQ0FBckI7QUFDSCxHQUhELEVBOUxVLENBbU1WOztBQUNBeEIsRUFBQUEsRUFBRSxDQUFDdUIsR0FBSCxDQUFPdEIsRUFBUCxFQUFXLGNBQVgsRUFBMkIsWUFBWTtBQUNuQ0EsSUFBQUEsRUFBRSxDQUFDdUIsT0FBSCxDQUFXLElBQVgsRUFBaUIsSUFBakIsRUFBdUIsY0FBdkI7QUFDSCxHQUZELEVBcE1VLENBd01WOztBQUNBLE1BQUkwRCxTQUFTLEdBQUdqRixFQUFFLENBQUNpRixTQUFuQjtBQUNBbEYsRUFBQUEsRUFBRSxDQUFDdUIsR0FBSCxDQUFPMkQsU0FBUyxDQUFDL0MsU0FBakIsRUFBNEIsZ0JBQTVCLEVBQThDLFlBQVk7QUFDdERsQyxJQUFBQSxFQUFFLENBQUN1QixPQUFILENBQVcsSUFBWCxFQUFpQiwwQkFBakIsRUFBNkMsbUJBQTdDO0FBQ0EsV0FBTyxLQUFLMkQsT0FBWjtBQUNILEdBSEQ7QUFLQW5GLEVBQUFBLEVBQUUsQ0FBQ3VCLEdBQUgsQ0FBTzJELFNBQVMsQ0FBQy9DLFNBQWpCLEVBQTRCLFNBQTVCLEVBQXVDLFlBQVk7QUFDL0NsQyxJQUFBQSxFQUFFLENBQUN1QixPQUFILENBQVcsSUFBWCxFQUFpQixtQkFBakIsRUFBc0MsZUFBdEM7QUFDQSxXQUFPLFlBQVk7QUFDZixhQUFPLEtBQUs0RCxLQUFMLElBQWMsSUFBckI7QUFDSCxLQUZEO0FBR0gsR0FMRDtBQU9BcEYsRUFBQUEsRUFBRSxDQUFDdUIsR0FBSCxDQUFPMkQsU0FBUyxDQUFDL0MsU0FBakIsRUFBNEIsVUFBNUIsRUFBd0MsWUFBWTtBQUNoRGxDLElBQUFBLEVBQUUsQ0FBQ3VCLE9BQUgsQ0FBVyxJQUFYLEVBQWlCLDJCQUFqQixFQUE4Qyx5QkFBOUM7QUFDQSxXQUFRLFlBQVk7QUFDaEIsYUFBTyxLQUFLNkQsTUFBWjtBQUNILEtBRkQ7QUFHSCxHQUxEO0FBT0FyRixFQUFBQSxFQUFFLENBQUN1QixHQUFILENBQU8yRCxTQUFTLENBQUMvQyxTQUFqQixFQUE0QiwyQkFBNUIsRUFBeUQsWUFBWTtBQUNqRWxDLElBQUFBLEVBQUUsQ0FBQ3VCLE9BQUgsQ0FBVyxJQUFYLEVBQWlCLHFDQUFqQixFQUF3RCw0RUFBeEQ7QUFDQSxXQUFPLFlBQVk7QUFDZixXQUFLOEQsVUFBTCxDQUFnQkosU0FBUyxDQUFDSyxNQUFWLENBQWlCQyxNQUFqQyxFQUF5Q04sU0FBUyxDQUFDSyxNQUFWLENBQWlCQyxNQUExRDtBQUNILEtBRkQ7QUFHSCxHQUxEO0FBT0F4RixFQUFBQSxFQUFFLENBQUN1QixHQUFILENBQU8yRCxTQUFTLENBQUMvQyxTQUFqQixFQUE0Qix1QkFBNUIsRUFBcUQsWUFBWTtBQUM3RGxDLElBQUFBLEVBQUUsQ0FBQ3VCLE9BQUgsQ0FBVyxJQUFYLEVBQWlCLHFDQUFqQixFQUF3RCw4RUFBeEQ7QUFDQSxXQUFPLFlBQVk7QUFDZixXQUFLOEQsVUFBTCxDQUFnQkosU0FBUyxDQUFDSyxNQUFWLENBQWlCRSxPQUFqQyxFQUEwQ1AsU0FBUyxDQUFDSyxNQUFWLENBQWlCRSxPQUEzRDtBQUNILEtBRkQ7QUFHSCxHQUxELEVBcE9VLENBMk9WOztBQUNBekMsRUFBQUEscUJBQXFCLENBQUMvQyxFQUFFLENBQUN5RixLQUFKLEVBQVcsQ0FDNUIsdUJBRDRCLEVBRTVCLGtDQUY0QixDQUFYLEVBR2xCLFVBSGtCLENBQXJCO0FBS0F4QyxFQUFBQSxpQkFBaUIsQ0FBQ2pELEVBQUUsQ0FBQ3lGLEtBQUosRUFBVztBQUN4QkMsSUFBQUEsRUFBRSxFQUFFLFNBRG9CO0FBRXhCQyxJQUFBQSxHQUFHLEVBQUUsYUFGbUI7QUFHeEJDLElBQUFBLE9BQU8sRUFBRSxrQkFIZTtBQUl4QkMsSUFBQUEsT0FBTyxFQUFFLGtCQUplO0FBS3hCQyxJQUFBQSxRQUFRLEVBQUU7QUFMYyxHQUFYLEVBTWQsVUFOYyxDQUFqQixDQWpQVSxDQXlQVjs7QUFDQS9DLEVBQUFBLHFCQUFxQixDQUFDL0MsRUFBRSxDQUFDK0YsSUFBSixFQUFVLENBQzNCLFlBRDJCLENBQVYsRUFFbEIsU0FGa0IsQ0FBckIsQ0ExUFUsQ0E4UFY7O0FBQ0FoRCxFQUFBQSxxQkFBcUIsQ0FBQy9DLEVBQUUsQ0FBQ2dHLEdBQUosRUFBUyxDQUMxQixVQUQwQixFQUUxQixhQUYwQixDQUFULEVBR2xCLFFBSGtCLENBQXJCLENBL1BVLENBb1FWOztBQUNBL0MsRUFBQUEsaUJBQWlCLENBQUNqRCxFQUFFLENBQUNpRyxRQUFKLEVBQWM7QUFDM0JDLElBQUFBLHdCQUF3QixFQUFFLEVBREM7QUFFM0JDLElBQUFBLGtCQUFrQixFQUFFLG9CQUZPO0FBRzNCQyxJQUFBQSxpQkFBaUIsRUFBRTtBQUhRLEdBQWQsRUFJZCxhQUpjLENBQWpCO0FBS0F0QyxFQUFBQSxtQkFBbUIsQ0FBQzlELEVBQUUsQ0FBQ2lHLFFBQUgsQ0FBWS9ELFNBQWIsRUFBd0I7QUFDdkNtRSxJQUFBQSxXQUFXLEVBQUUsaUNBRDBCO0FBRXZDQyxJQUFBQSxXQUFXLEVBQUUsRUFGMEI7QUFHdkNDLElBQUFBLFVBQVUsRUFBRSxZQUgyQjtBQUl2Q0MsSUFBQUEsa0JBQWtCLEVBQUUsWUFKbUI7QUFLdkNDLElBQUFBLGNBQWMsRUFBRSx3QkFMdUI7QUFNdkNDLElBQUFBLGdCQUFnQixFQUFFLDBCQU5xQjtBQU92Q0MsSUFBQUEsZUFBZSxFQUFFLHNCQVBzQjtBQVF2Q0MsSUFBQUEsWUFBWSxFQUFFLHNCQVJ5QjtBQVN2Q0MsSUFBQUEsYUFBYSxFQUFFLGdDQVR3QjtBQVV2Q0MsSUFBQUEsZUFBZSxFQUFFLHNCQVZzQjtBQVd2Q0MsSUFBQUEsb0JBQW9CLEVBQUUsc0JBWGlCO0FBWXZDQyxJQUFBQSxvQkFBb0IsRUFBRSxzQkFaaUI7QUFhdkNDLElBQUFBLGNBQWMsRUFBRSx5QkFidUI7QUFjdkNDLElBQUFBLGVBQWUsRUFBRSwwQkFkc0I7QUFldkNDLElBQUFBLGFBQWEsRUFBRSxlQWZ3QjtBQWdCdkNDLElBQUFBLGNBQWMsRUFBRTtBQWhCdUIsR0FBeEIsRUFpQmhCLGFBakJnQixDQUFuQjtBQWtCQTNGLEVBQUFBLGFBQWEsQ0FBQ3pCLEVBQUUsQ0FBQ2lHLFFBQUosRUFBYyxDQUN2QixXQUR1QixFQUV2QixVQUZ1QixFQUd2QixnQkFIdUIsRUFJdkIsc0JBSnVCLEVBS3ZCLGVBTHVCLEVBTXZCLGVBTnVCLENBQWQsRUFPVixhQVBVLENBQWIsQ0E1UlUsQ0FxU1Y7O0FBQ0FoRCxFQUFBQSxpQkFBaUIsQ0FBQ2pELEVBQUUsQ0FBQ3FILFNBQUosRUFBZTtBQUM1QkMsSUFBQUEseUJBQXlCLEVBQUUsVUFEQztBQUU1QkMsSUFBQUEsdUJBQXVCLEVBQUUsZ0JBRkc7QUFHNUJDLElBQUFBLDJCQUEyQixFQUFFLFlBSEQ7QUFJNUJDLElBQUFBLHlCQUF5QixFQUFFLGtCQUpDO0FBSzVCQyxJQUFBQSwrQkFBK0IsRUFBRSx3QkFMTDtBQU01QkMsSUFBQUEsc0JBQXNCLEVBQUUsZUFOSTtBQU81QkMsSUFBQUEscUNBQXFDLEVBQUU7QUFQWCxHQUFmLEVBUWQsY0FSYyxDQUFqQixDQXRTVSxDQWdUVjs7QUFDQTNFLEVBQUFBLGlCQUFpQixDQUFDakQsRUFBRSxDQUFDNkgsSUFBSixFQUFVO0FBQ3ZCQyxJQUFBQSxjQUFjLEVBQUUsb0JBRE87QUFFdkJDLElBQUFBLG1CQUFtQixFQUFFLHFCQUZFO0FBR3ZCQyxJQUFBQSxlQUFlLEVBQUU7QUFITSxHQUFWLEVBSWQsU0FKYyxDQUFqQjtBQUtBakYsRUFBQUEscUJBQXFCLENBQUMvQyxFQUFFLENBQUM2SCxJQUFKLEVBQVUsQ0FDM0IsYUFEMkIsRUFFM0IscUJBRjJCLEVBRzNCLHFCQUgyQixFQUkzQixvQkFKMkIsRUFLM0IsMEJBTDJCLEVBTTNCLDRCQU4yQixFQU8zQiw0QkFQMkIsRUFRM0IsYUFSMkIsRUFTM0IsYUFUMkIsQ0FBVixFQVVsQixTQVZrQixDQUFyQixDQXRUVSxDQWtVVjs7QUFDQXBHLEVBQUFBLGFBQWEsQ0FBQ3pCLEVBQUUsQ0FBQ2lJLFFBQUosRUFBYyxDQUN2QixZQUR1QixFQUV2QixVQUZ1QixDQUFkLEVBR1YsV0FIVSxDQUFiLENBblVVLENBd1VWOztBQUNBeEcsRUFBQUEsYUFBYSxDQUFDekIsRUFBRSxDQUFDa0ksY0FBSixFQUFvQixDQUM3Qix5QkFENkIsRUFFN0IsMkJBRjZCLENBQXBCLENBQWIsQ0F6VVUsQ0E4VVY7O0FBQ0F6RyxFQUFBQSxhQUFhLENBQUN6QixFQUFFLENBQUNtSSxnQkFBSixFQUFzQixDQUMvQix5QkFEK0IsRUFFL0IsMkJBRitCLENBQXRCLENBQWIsQ0EvVVUsQ0FvVlY7O0FBQ0FsRixFQUFBQSxpQkFBaUIsQ0FBQ2pELEVBQUUsQ0FBQ29JLFNBQUgsQ0FBYWxHLFNBQWQsRUFBeUI7QUFDdEMsV0FBTyxNQUQrQjtBQUV0QyxjQUFVLE1BRjRCO0FBR3RDLGNBQVUsTUFINEI7QUFJdEMscUJBQWlCLGdCQUpxQjtBQUt0Qyx3QkFBb0I7QUFMa0IsR0FBekIsQ0FBakI7QUFRQVQsRUFBQUEsYUFBYSxDQUFDekIsRUFBRSxDQUFDcUksSUFBSixFQUFVLENBQ25CLHNCQURtQixFQUVuQixjQUZtQixFQUduQix1QkFIbUIsRUFJbkIsd0JBSm1CLEVBS25CLHdCQUxtQixFQU1uQixnQkFObUIsRUFPbkIseUJBUG1CLEVBUW5CLDBCQVJtQixFQVNuQixrQkFUbUIsRUFVbkIsb0JBVm1CLEVBV25CLHFCQVhtQixFQVluQixjQVptQixFQWFuQixnQ0FibUIsRUFjbkIsOEJBZG1CLEVBZW5CLFdBZm1CLEVBZ0JuQixTQWhCbUIsQ0FBVixDQUFiO0FBbUJBdkUsRUFBQUEsbUJBQW1CLENBQUM5RCxFQUFFLENBQUNxSSxJQUFILENBQVFuRyxTQUFULEVBQW9CO0FBQ25Db0csSUFBQUEsd0JBQXdCLEVBQUUsZ0JBRFM7QUFFbkNDLElBQUFBLDBCQUEwQixFQUFFLGdCQUZPO0FBR25DQyxJQUFBQSx1QkFBdUIsRUFBRSxnQkFIVTtBQUluQ0MsSUFBQUEseUJBQXlCLEVBQUUsZ0JBSlE7QUFLbkNDLElBQUFBLHdCQUF3QixFQUFFLGdCQUxTO0FBTW5DQyxJQUFBQSx1QkFBdUIsRUFBRSxnQkFOVTtBQU9uQ0MsSUFBQUEsdUJBQXVCLEVBQUUsc0JBUFU7QUFRbkNDLElBQUFBLHlCQUF5QixFQUFFLHNCQVJRO0FBU25DQyxJQUFBQSxtQkFBbUIsRUFBRSx1QkFUYztBQVVuQ0MsSUFBQUEsa0JBQWtCLEVBQUU7QUFWZSxHQUFwQixDQUFuQjtBQWFBOUYsRUFBQUEsaUJBQWlCLENBQUNqRCxFQUFFLENBQUNxSSxJQUFILENBQVFuRyxTQUFULEVBQW9CO0FBQ2pDOEcsSUFBQUEsWUFBWSxFQUFFLFdBRG1CO0FBRWpDQyxJQUFBQSxZQUFZLEVBQUUsV0FGbUI7QUFHakNDLElBQUFBLFlBQVksRUFBRSxXQUhtQjtBQUlqQ0MsSUFBQUEsWUFBWSxFQUFFLFdBSm1CO0FBS2pDQyxJQUFBQSxZQUFZLEVBQUUsR0FMbUI7QUFNakNDLElBQUFBLFlBQVksRUFBRSxHQU5tQjtBQU9qQ0MsSUFBQUEsWUFBWSxFQUFFLEdBUG1CO0FBUWpDQyxJQUFBQSxZQUFZLEVBQUUsR0FSbUI7QUFTakNDLElBQUFBLFFBQVEsRUFBRSxPQVR1QjtBQVVqQ0MsSUFBQUEsUUFBUSxFQUFFLE9BVnVCO0FBV2pDQyxJQUFBQSxRQUFRLEVBQUUsT0FYdUI7QUFZakNDLElBQUFBLFFBQVEsRUFBRSxPQVp1QjtBQWFqQ0MsSUFBQUEsU0FBUyxFQUFFLFFBYnNCO0FBY2pDQyxJQUFBQSxTQUFTLEVBQUUsUUFkc0I7QUFlakNDLElBQUFBLFNBQVMsRUFBRSxRQWZzQjtBQWdCakNDLElBQUFBLFNBQVMsRUFBRSxRQWhCc0I7QUFpQmpDQyxJQUFBQSxVQUFVLEVBQUUsU0FqQnFCO0FBa0JqQ0MsSUFBQUEsVUFBVSxFQUFFLFNBbEJxQjtBQW1CakNDLElBQUFBLFFBQVEsRUFBRSxPQW5CdUI7QUFvQmpDQyxJQUFBQSxRQUFRLEVBQUUsT0FwQnVCO0FBcUJqQ0MsSUFBQUEsY0FBYyxFQUFFLFFBckJpQjtBQXNCakNDLElBQUFBLGNBQWMsRUFBRTtBQXRCaUIsR0FBcEIsQ0FBakI7QUF5QkFwSCxFQUFBQSxpQkFBaUIsQ0FBQ2pELEVBQUUsQ0FBQzhFLE1BQUgsQ0FBVTVDLFNBQVgsRUFBc0I7QUFDbkNvSSxJQUFBQSxZQUFZLEVBQUUsMEJBRHFCO0FBRW5DQyxJQUFBQSxhQUFhLEVBQUUsMkJBRm9CO0FBR25DQyxJQUFBQSxXQUFXLEVBQUUseUJBSHNCO0FBSW5DQyxJQUFBQSxjQUFjLEVBQUU7QUFKbUIsR0FBdEIsQ0FBakIsQ0F0WlUsQ0E2WlY7O0FBQ0F6SyxFQUFBQSxFQUFFLENBQUMwSyxRQUFILENBQVlDLDhCQUFaLEdBQTZDM0ssRUFBRSxDQUFDNEssZUFBSCxDQUFtQkMsaUJBQWhFO0FBQ0E3SyxFQUFBQSxFQUFFLENBQUMwSyxRQUFILENBQVlJLHVCQUFaLEdBQXNDOUssRUFBRSxDQUFDNEssZUFBSCxDQUFtQkcsTUFBekQ7QUFDQWpILEVBQUFBLG1CQUFtQixDQUFDOUQsRUFBRSxDQUFDMEssUUFBSixFQUFjO0FBQzdCQyxJQUFBQSw4QkFBOEIsRUFBRSxzQ0FESDtBQUU3QkcsSUFBQUEsdUJBQXVCLEVBQUU7QUFGSSxHQUFkLENBQW5CLENBaGFVLENBcWFWOztBQUNBOUssRUFBQUEsRUFBRSxDQUFDRCxFQUFILENBQU1rQyxNQUFOLENBQWFqQyxFQUFFLENBQUNnTCxlQUFILENBQW1COUksU0FBaEMsRUFBMkMsaUJBQTNDLEVBQThELFlBQVk7QUFDdEVsQyxJQUFBQSxFQUFFLENBQUMyQyxNQUFILENBQVUsSUFBVixFQUFnQixpQkFBaEIsRUFBbUMsY0FBbkM7QUFDQSxXQUFPLEtBQUtzSSxTQUFaO0FBQ0gsR0FIRCxFQUdHLFVBQVVwSSxDQUFWLEVBQWE7QUFDWjdDLElBQUFBLEVBQUUsQ0FBQzJDLE1BQUgsQ0FBVSxJQUFWLEVBQWdCLGlCQUFoQixFQUFtQyxhQUFuQztBQUNBLFNBQUtzSSxTQUFMLEdBQWlCcEksQ0FBakI7QUFDSCxHQU5ELEVBdGFVLENBOGFWOztBQUNBaUIsRUFBQUEsbUJBQW1CLENBQUM5RCxFQUFFLENBQUNrTCxNQUFILENBQVVoSixTQUFYLEVBQXNCO0FBQ3JDaUosSUFBQUEsd0JBQXdCLEVBQUUsMEJBRFc7QUFFckNDLElBQUFBLHFCQUFxQixFQUFFLHVCQUZjO0FBR3JDQyxJQUFBQSxxQkFBcUIsRUFBRSx1QkFIYztBQUlyQ0MsSUFBQUEsc0JBQXNCLEVBQUUsMEJBSmE7QUFLckNDLElBQUFBLHNCQUFzQixFQUFFO0FBTGEsR0FBdEIsQ0FBbkI7QUFRQTlKLEVBQUFBLGFBQWEsQ0FBQ3pCLEVBQUUsQ0FBQ2tMLE1BQUosRUFBWSxDQUNyQixXQURxQixFQUVyQixjQUZxQixFQUdyQixZQUhxQixDQUFaLENBQWIsQ0F2YlUsQ0E2YlY7O0FBQ0EsTUFBSU0sR0FBRyxHQUFHLHVFQUFWO0FBQ0FDLEVBQUFBLFNBQVMsSUFBSW5KLE1BQU0sQ0FBQ29KLGdCQUFQLENBQXdCMUwsRUFBRSxDQUFDMkwsS0FBSCxDQUFTekosU0FBakMsRUFBNEM7QUFDckQwSixJQUFBQSxNQUFNLEVBQUU7QUFDSnRLLE1BQUFBLEdBQUcsRUFBRSxlQUFZO0FBQ2J0QixRQUFBQSxFQUFFLENBQUNnQyxLQUFILENBQVN3SixHQUFULEVBQWMsUUFBZDtBQUNBLGVBQU8sSUFBUDtBQUNILE9BSkc7QUFLSjFJLE1BQUFBLEdBQUcsRUFBRSxlQUFZO0FBQ2I5QyxRQUFBQSxFQUFFLENBQUNnQyxLQUFILENBQVN3SixHQUFULEVBQWMsUUFBZDtBQUNIO0FBUEcsS0FENkM7QUFVckRLLElBQUFBLGlCQUFpQixFQUFFO0FBQ2Z2SyxNQUFBQSxHQUFHLEVBQUUsZUFBWTtBQUNidEIsUUFBQUEsRUFBRSxDQUFDZ0MsS0FBSCxDQUFTd0osR0FBVCxFQUFjLG1CQUFkO0FBQ0EsZUFBTyxJQUFQO0FBQ0g7QUFKYyxLQVZrQztBQWdCckRNLElBQUFBLFlBQVksRUFBRTtBQUNWeEssTUFBQUEsR0FBRyxFQUFFLGVBQVk7QUFDYnRCLFFBQUFBLEVBQUUsQ0FBQ2dDLEtBQUgsQ0FBU3dKLEdBQVQsRUFBYyxjQUFkO0FBQ0EsZUFBTyxZQUFZO0FBQ2YsaUJBQU8sSUFBUDtBQUNILFNBRkQ7QUFHSDtBQU5TLEtBaEJ1QztBQXdCckRPLElBQUFBLFlBQVksRUFBRTtBQUNWekssTUFBQUEsR0FBRyxFQUFFLGVBQVk7QUFDYnRCLFFBQUFBLEVBQUUsQ0FBQ2dDLEtBQUgsQ0FBU3dKLEdBQVQsRUFBYyxjQUFkO0FBQ0EsZUFBTyxZQUFZO0FBQ2YsaUJBQU8sSUFBUDtBQUNILFNBRkQ7QUFHSDtBQU5TO0FBeEJ1QyxHQUE1QyxDQUFiLENBL2JVLENBaWVWOztBQUNBekksRUFBQUEscUJBQXFCLENBQUMvQyxFQUFFLENBQUNnTSxtQkFBSixFQUF5QixDQUMxQyxjQUQwQyxDQUF6QixFQUVsQix3QkFGa0IsQ0FBckIsQ0FsZVUsQ0FzZVY7O0FBQ0EsTUFBSWhNLEVBQUUsQ0FBQ2lNLEtBQVAsRUFBYztBQUNWbEosSUFBQUEscUJBQXFCLENBQUMvQyxFQUFFLENBQUNpTSxLQUFILENBQVMvSixTQUFWLEVBQXFCLENBQ3RDLGtCQURzQyxDQUFyQixFQUVsQixvQkFGa0IsQ0FBckI7QUFHSCxHQTNlUyxDQTZlVjs7O0FBQ0FlLEVBQUFBLGlCQUFpQixDQUFDakQsRUFBRCxFQUFLO0FBQ2xCO0FBQ0FrTSxJQUFBQSxtQkFBbUIsRUFBRSwyQkFGSDtBQUdsQkMsSUFBQUEsMkJBQTJCLEVBQUUsNkJBSFg7QUFJbEJDLElBQUFBLG9CQUFvQixFQUFFLDBCQUpKO0FBS2xCQyxJQUFBQSxxQkFBcUIsRUFBRSwyQkFMTDtBQU1sQkMsSUFBQUEsdUJBQXVCLEVBQUUsMkJBTlA7QUFPbEJDLElBQUFBLHFCQUFxQixFQUFFLDJCQVBMO0FBUWxCQyxJQUFBQSx1QkFBdUIsRUFBRSwyQkFSUDtBQVNsQkMsSUFBQUEsd0JBQXdCLEVBQUUsMkJBVFI7QUFVbEJDLElBQUFBLCtCQUErQixFQUFFLDBCQVZmO0FBV2xCQyxJQUFBQSx5QkFBeUIsRUFBRSxrQ0FYVDtBQVlsQkMsSUFBQUEsd0JBQXdCLEVBQUUsa0NBWlI7QUFhbEJDLElBQUFBLHdCQUF3QixFQUFFLGtDQWJSO0FBY2xCQyxJQUFBQSx1QkFBdUIsRUFBRSxpQ0FkUDtBQWdCbEI7QUFDQUMsSUFBQUEsaUJBQWlCLEVBQUUsZ0JBakJEO0FBbUJsQjtBQUNBQyxJQUFBQSxlQUFlLEVBQUUsZ0JBcEJDO0FBc0JsQjtBQUNBQyxJQUFBQSxlQUFlLEVBQUUscUJBdkJDO0FBd0JsQkMsSUFBQUEsZ0JBQWdCLEVBQUUsMkJBeEJBO0FBeUJsQkMsSUFBQUEsaUJBQWlCLEVBQUUscUJBekJEO0FBMEJsQkMsSUFBQUEsZ0JBQWdCLEVBQUUseUJBMUJBO0FBMkJsQkMsSUFBQUEsa0JBQWtCLEVBQUUseUJBM0JGO0FBNEJsQkMsSUFBQUEsZ0JBQWdCLEVBQUUseUNBNUJBO0FBNkJsQkMsSUFBQUEsU0FBUyxFQUFFLDJCQTdCTztBQThCbEJDLElBQUFBLFdBQVcsRUFBRSxXQTlCSztBQStCbEJDLElBQUFBLFdBQVcsRUFBRSxlQS9CSztBQWdDbEJDLElBQUFBLFdBQVcsRUFBRSxXQWhDSztBQWlDbEJDLElBQUFBLFdBQVcsRUFBRSxXQWpDSztBQWtDbEJDLElBQUFBLFdBQVcsRUFBRSxlQWxDSztBQW1DbEJDLElBQUFBLFdBQVcsRUFBRSxXQW5DSztBQXFDbEI7QUFDQUMsSUFBQUEsVUFBVSxFQUFFLHVCQXRDTTtBQXVDbEJDLElBQUFBLFVBQVUsRUFBRSx5QkF2Q007QUF3Q2xCQyxJQUFBQSxVQUFVLEVBQUUsZUF4Q007QUEwQ2xCO0FBQ0FDLElBQUFBLGFBQWEsRUFBRSx3QkEzQ0c7QUE0Q2xCQyxJQUFBQSxxQkFBcUIsRUFBRSxnQ0E1Q0w7QUE4Q2xCO0FBQ0FDLElBQUFBLElBQUksRUFBRSxTQS9DWTtBQWdEbEJDLElBQUFBLElBQUksRUFBRSxZQWhEWTtBQWlEbEJDLElBQUFBLElBQUksRUFBRSxZQWpEWTtBQWtEbEJDLElBQUFBLEtBQUssRUFBRSxlQWxEVztBQW1EbEJDLElBQUFBLFNBQVMsRUFBRSxxQkFuRE87QUFvRGxCQyxJQUFBQSxJQUFJLEVBQUUsWUFwRFk7QUFxRGxCQyxJQUFBQSxNQUFNLEVBQUUsY0FyRFU7QUFzRGxCQyxJQUFBQSxLQUFLLEVBQUUsK0JBdERXO0FBdURsQkMsSUFBQUEsTUFBTSxFQUFFLDhCQXZEVTtBQXdEbEJDLElBQUFBLFFBQVEsRUFBRSxnQkF4RFE7QUF5RGxCQyxJQUFBQSxTQUFTLEVBQUUsWUF6RE87QUEwRGxCQyxJQUFBQSxXQUFXLEVBQUUscUJBMURLO0FBMkRsQkMsSUFBQUEsT0FBTyxFQUFFLFNBM0RTO0FBNERsQkMsSUFBQUEsU0FBUyxFQUFFLGtCQTVETztBQTZEbEJDLElBQUFBLFVBQVUsRUFBRSxlQTdETTtBQThEbEJDLElBQUFBLFNBQVMsRUFBRSxpQ0E5RE87QUErRGxCQyxJQUFBQSxRQUFRLEVBQUUsc0JBL0RRO0FBZ0VsQkMsSUFBQUEsT0FBTyxFQUFFLGVBaEVTO0FBaUVsQkMsSUFBQUEsR0FBRyxFQUFFLFlBakVhO0FBa0VsQkMsSUFBQUEsT0FBTyxFQUFFLG1CQWxFUztBQW1FbEJDLElBQUFBLE1BQU0sRUFBRSxnQkFuRVU7QUFvRWxCQyxJQUFBQSxNQUFNLEVBQUUsZ0JBcEVVO0FBcUVsQkMsSUFBQUEsWUFBWSxFQUFFLG1CQXJFSTtBQXNFbEJDLElBQUFBLE9BQU8sRUFBRSxlQXRFUztBQXVFbEJDLElBQUFBLE1BQU0sRUFBRSxjQXZFVTtBQXdFbEJDLElBQUFBLFlBQVksRUFBRSxrQkF4RUk7QUF5RWxCQyxJQUFBQSxjQUFjLEVBQUUsbUJBekVFO0FBMEVsQkMsSUFBQUEsU0FBUyxFQUFFLFlBMUVPO0FBMkVsQkMsSUFBQUEsV0FBVyxFQUFFLCtCQTNFSztBQTRFbEJDLElBQUFBLEtBQUssRUFBRSx5QkE1RVc7QUE2RWxCQyxJQUFBQSxNQUFNLEVBQUUsd0NBN0VVO0FBK0VsQkMsSUFBQUEsSUFBSSxFQUFFLDBCQS9FWTtBQWdGbEJDLElBQUFBLGVBQWUsRUFBRSwyQkFoRkM7QUFrRmxCQyxJQUFBQSxTQUFTLEVBQUUsbUJBbEZPO0FBbUZsQkMsSUFBQUEsT0FBTyxFQUFFLGdCQW5GUztBQW9GbEJDLElBQUFBLFdBQVcsRUFBRSxvQkFwRks7QUFzRmxCQyxJQUFBQSxTQUFTLEVBQUUsbUJBdEZPO0FBdUZsQkMsSUFBQUEsaUJBQWlCLEVBQUUsNkJBdkZEO0FBd0ZsQkMsSUFBQUEsU0FBUyxFQUFFO0FBeEZPLEdBQUwsRUF5RmQsSUF6RmMsQ0FBakI7QUEwRkExTixFQUFBQSxxQkFBcUIsQ0FBQy9DLEVBQUQsRUFBSyxDQUN0QixrQkFEc0IsRUFHdEIsV0FIc0IsRUFJdEIsU0FKc0IsRUFLdEIsaUJBTHNCLEVBTXRCLG1CQU5zQixFQU90QixnQkFQc0IsRUFTdEIsZ0JBVHNCLEVBV3RCLHNCQVhzQixFQWF0QixZQWJzQixDQUFMLEVBY2xCLElBZGtCLENBQXJCO0FBZUE4RCxFQUFBQSxtQkFBbUIsQ0FBQzlELEVBQUQsRUFBSztBQUNwQjtBQUNBMFEsSUFBQUEsQ0FBQyxFQUFFO0FBRmlCLEdBQUwsRUFHaEIsSUFIZ0IsQ0FBbkIsQ0F2bEJVLENBMmxCVjs7QUFDQXpOLEVBQUFBLGlCQUFpQixDQUFDakQsRUFBRSxDQUFDMlEsSUFBSixFQUFVO0FBQ3ZCQyxJQUFBQSxPQUFPLEVBQUUsdUJBRGM7QUFFdkJDLElBQUFBLGFBQWEsRUFBRTtBQUZRLEdBQVYsQ0FBakIsQ0E1bEJVLENBZ21CVjs7QUFDQTVOLEVBQUFBLGlCQUFpQixDQUFDakQsRUFBRSxDQUFDOFEsS0FBSixFQUFXO0FBQ3hCQyxJQUFBQSxPQUFPLEVBQUUsZUFEZTtBQUV4QkMsSUFBQUEsT0FBTyxFQUFFO0FBRmUsR0FBWCxDQUFqQixDQWptQlUsQ0FzbUJWOztBQUNBalIsRUFBQUEsRUFBRSxDQUFDdUIsR0FBSCxDQUFPdEIsRUFBUCxFQUFXLE1BQVgsRUFBbUIsWUFBWTtBQUMzQkEsSUFBQUEsRUFBRSxDQUFDdUIsT0FBSCxDQUFXLElBQVgsRUFBaUIsU0FBakIsRUFBNEIsY0FBNUI7QUFDQSxXQUFPdkIsRUFBRSxDQUFDaVIsSUFBSCxDQUFRQyxJQUFmO0FBQ0gsR0FIRDtBQUlBblIsRUFBQUEsRUFBRSxDQUFDdUIsR0FBSCxDQUFPdEIsRUFBUCxFQUFXLFlBQVgsRUFBeUIsWUFBWTtBQUNqQ0EsSUFBQUEsRUFBRSxDQUFDdUIsT0FBSCxDQUFXLElBQVgsRUFBaUIsZUFBakIsRUFBa0MsYUFBbEM7QUFDQSxXQUFPNFAsSUFBSSxDQUFDQyxNQUFaO0FBQ0gsR0FIRDtBQUlBclIsRUFBQUEsRUFBRSxDQUFDdUIsR0FBSCxDQUFPdEIsRUFBUCxFQUFXLGtCQUFYLEVBQStCLFlBQVk7QUFDdkNBLElBQUFBLEVBQUUsQ0FBQ3VCLE9BQUgsQ0FBVyxJQUFYLEVBQWlCLHFCQUFqQixFQUF3QywwQkFBeEM7QUFDQSxXQUFPdkIsRUFBRSxDQUFDaVIsSUFBSCxDQUFRSSxnQkFBZjtBQUNILEdBSEQ7QUFJQXRSLEVBQUFBLEVBQUUsQ0FBQ3VCLEdBQUgsQ0FBT3RCLEVBQVAsRUFBVyxrQkFBWCxFQUErQixZQUFZO0FBQ3ZDQSxJQUFBQSxFQUFFLENBQUN1QixPQUFILENBQVcsSUFBWCxFQUFpQixxQkFBakIsRUFBd0MsMEJBQXhDO0FBQ0EsV0FBT3ZCLEVBQUUsQ0FBQ2lSLElBQUgsQ0FBUUssZ0JBQWY7QUFDSCxHQUhEO0FBSUF2UixFQUFBQSxFQUFFLENBQUN1QixHQUFILENBQU90QixFQUFQLEVBQVcsUUFBWCxFQUFxQixZQUFZO0FBQzdCQSxJQUFBQSxFQUFFLENBQUN1QixPQUFILENBQVcsSUFBWCxFQUFpQixXQUFqQixFQUE4QixnQkFBOUI7QUFDQSxXQUFPdkIsRUFBRSxDQUFDaVIsSUFBSCxDQUFRTSxNQUFmO0FBQ0gsR0FIRDtBQUlBeFIsRUFBQUEsRUFBRSxDQUFDdUIsR0FBSCxDQUFPdEIsRUFBUCxFQUFXLFNBQVgsRUFBc0IsWUFBWTtBQUM5QkEsSUFBQUEsRUFBRSxDQUFDdUIsT0FBSCxDQUFXLElBQVgsRUFBaUIsWUFBakIsRUFBK0IsaUJBQS9CO0FBQ0EsV0FBT3ZCLEVBQUUsQ0FBQ2lSLElBQUgsQ0FBUU8sT0FBZjtBQUNILEdBSEQ7QUFJQXpSLEVBQUFBLEVBQUUsQ0FBQ3VCLEdBQUgsQ0FBT3RCLEVBQVAsRUFBVyxhQUFYLEVBQTBCLFlBQVk7QUFDbENBLElBQUFBLEVBQUUsQ0FBQ3VCLE9BQUgsQ0FBVyxJQUFYLEVBQWlCLGdCQUFqQixFQUFtQyxzQkFBbkM7QUFDQSxXQUFPdkIsRUFBRSxDQUFDeUYsS0FBSCxDQUFTZ00sV0FBaEI7QUFDSCxHQUhEO0FBSUExUixFQUFBQSxFQUFFLENBQUN1QixHQUFILENBQU90QixFQUFQLEVBQVcsS0FBWCxFQUFrQixZQUFZO0FBQzFCQSxJQUFBQSxFQUFFLENBQUN1QixPQUFILENBQVcsSUFBWCxFQUFpQixRQUFqQixFQUEyQixjQUEzQjtBQUNBLFdBQU92QixFQUFFLENBQUN5RixLQUFILENBQVNpTSxHQUFoQjtBQUNILEdBSEQ7QUFJQTNSLEVBQUFBLEVBQUUsQ0FBQ3VCLEdBQUgsQ0FBT3RCLEVBQVAsRUFBVyxRQUFYLEVBQXFCLFlBQVk7QUFDN0JBLElBQUFBLEVBQUUsQ0FBQ3VCLE9BQUgsQ0FBVyxJQUFYLEVBQWlCLFdBQWpCLEVBQThCLFdBQTlCO0FBQ0EsV0FBT3ZCLEVBQUUsQ0FBQzJSLE1BQVY7QUFDSCxHQUhELEVBdm9CVSxDQTRvQlY7O0FBQ0E1UixFQUFBQSxFQUFFLENBQUN1QixHQUFILENBQU90QixFQUFQLEVBQVcsZ0JBQVgsRUFBNkIsWUFBWTtBQUNyQ0EsSUFBQUEsRUFBRSxDQUFDdUIsT0FBSCxDQUFXLElBQVgsRUFBaUIsbUJBQWpCLEVBQXNDLHNCQUF0QztBQUNBLFdBQU92QixFQUFFLENBQUNELEVBQUgsQ0FBTTZSLGNBQWI7QUFDSCxHQUhELEVBN29CVSxDQWtwQlY7O0FBQ0EsTUFBSSxPQUFPQyxXQUFQLEtBQXVCLFdBQTNCLEVBQXdDO0FBQ3BDOVIsSUFBQUEsRUFBRSxDQUFDdUIsR0FBSCxDQUFPdVEsV0FBVyxDQUFDQyxTQUFuQixFQUE4QixZQUE5QixFQUE0QyxZQUFZO0FBQ3BEOVIsTUFBQUEsRUFBRSxDQUFDdUIsT0FBSCxDQUFXLElBQVgsRUFBaUIsa0NBQWpCLEVBQXFELG1DQUFyRDtBQUNBLGFBQU9zUSxXQUFXLENBQUNDLFNBQVosQ0FBc0JDLFdBQTdCO0FBQ0gsS0FIRDtBQUlILEdBeHBCUyxDQTBwQlY7OztBQUNBL1IsRUFBQUEsRUFBRSxDQUFDZ1MsUUFBSCxDQUFZQyxZQUFaLEdBQTJCO0FBQ3ZCLFFBQUlDLEdBQUosR0FBVztBQUNQbFMsTUFBQUEsRUFBRSxDQUFDMkMsTUFBSCxDQUFVLElBQVYsRUFBZ0IsOEJBQWhCLEVBQWdELFFBQWhEO0FBQ0EsYUFBTzNDLEVBQUUsQ0FBQ2tTLEdBQVY7QUFDSCxLQUpzQjs7QUFLdkIsUUFBSTdOLElBQUosR0FBWTtBQUNSckUsTUFBQUEsRUFBRSxDQUFDMkMsTUFBSCxDQUFVLElBQVYsRUFBZ0IsK0JBQWhCLEVBQWlELFNBQWpEO0FBQ0EsYUFBTzNDLEVBQUUsQ0FBQ21TLEtBQVY7QUFDSCxLQVJzQjs7QUFTdkIsUUFBSUMsY0FBSixHQUFzQjtBQUNsQnBTLE1BQUFBLEVBQUUsQ0FBQzJDLE1BQUgsQ0FBVSxJQUFWLEVBQWdCLHlDQUFoQixFQUEyRCw0QkFBM0Q7QUFDQSxhQUFPM0MsRUFBRSxDQUFDZ1MsUUFBSCxDQUFZSSxjQUFuQjtBQUNIOztBQVpzQixHQUEzQjtBQWVIIiwic291cmNlc0NvbnRlbnQiOlsiLyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKipcbiBDb3B5cmlnaHQgKGMpIDIwMTctMjAxOCBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC5cblxuIGh0dHBzOi8vd3d3LmNvY29zLmNvbS9cblxuIFBlcm1pc3Npb24gaXMgaGVyZWJ5IGdyYW50ZWQsIGZyZWUgb2YgY2hhcmdlLCB0byBhbnkgcGVyc29uIG9idGFpbmluZyBhIGNvcHlcbiBvZiB0aGlzIHNvZnR3YXJlIGFuZCBhc3NvY2lhdGVkIGVuZ2luZSBzb3VyY2UgY29kZSAodGhlIFwiU29mdHdhcmVcIiksIGEgbGltaXRlZCxcbiB3b3JsZHdpZGUsIHJveWFsdHktZnJlZSwgbm9uLWFzc2lnbmFibGUsIHJldm9jYWJsZSBhbmQgbm9uLWV4Y2x1c2l2ZSBsaWNlbnNlXG4gdG8gdXNlIENvY29zIENyZWF0b3Igc29sZWx5IHRvIGRldmVsb3AgZ2FtZXMgb24geW91ciB0YXJnZXQgcGxhdGZvcm1zLiBZb3Ugc2hhbGxcbiBub3QgdXNlIENvY29zIENyZWF0b3Igc29mdHdhcmUgZm9yIGRldmVsb3Bpbmcgb3RoZXIgc29mdHdhcmUgb3IgdG9vbHMgdGhhdCdzXG4gdXNlZCBmb3IgZGV2ZWxvcGluZyBnYW1lcy4gWW91IGFyZSBub3QgZ3JhbnRlZCB0byBwdWJsaXNoLCBkaXN0cmlidXRlLFxuIHN1YmxpY2Vuc2UsIGFuZC9vciBzZWxsIGNvcGllcyBvZiBDb2NvcyBDcmVhdG9yLlxuXG4gVGhlIHNvZnR3YXJlIG9yIHRvb2xzIGluIHRoaXMgTGljZW5zZSBBZ3JlZW1lbnQgYXJlIGxpY2Vuc2VkLCBub3Qgc29sZC5cbiBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC4gcmVzZXJ2ZXMgYWxsIHJpZ2h0cyBub3QgZXhwcmVzc2x5IGdyYW50ZWQgdG8geW91LlxuXG4gVEhFIFNPRlRXQVJFIElTIFBST1ZJREVEIFwiQVMgSVNcIiwgV0lUSE9VVCBXQVJSQU5UWSBPRiBBTlkgS0lORCwgRVhQUkVTUyBPUlxuIElNUExJRUQsIElOQ0xVRElORyBCVVQgTk9UIExJTUlURUQgVE8gVEhFIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZLFxuIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFORCBOT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRVxuIEFVVEhPUlMgT1IgQ09QWVJJR0hUIEhPTERFUlMgQkUgTElBQkxFIEZPUiBBTlkgQ0xBSU0sIERBTUFHRVMgT1IgT1RIRVJcbiBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQU4gQUNUSU9OIE9GIENPTlRSQUNULCBUT1JUIE9SIE9USEVSV0lTRSwgQVJJU0lORyBGUk9NLFxuIE9VVCBPRiBPUiBJTiBDT05ORUNUSU9OIFdJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU5cbiBUSEUgU09GVFdBUkUuXG4gKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKi9cblxuXG52YXIganMgPSBjYy5qcztcblxuaWYgKENDX0RFQlVHKSB7XG5cbiAgICBmdW5jdGlvbiBkZXByZWNhdGVFbnVtIChvYmosIG9sZFBhdGgsIG5ld1BhdGgsIGhhc1R5cGVQcmVmaXhCZWZvcmUpIHtcbiAgICAgICAgaWYgKCFDQ19TVVBQT1JUX0pJVCkge1xuICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG4gICAgICAgIGhhc1R5cGVQcmVmaXhCZWZvcmUgPSBoYXNUeXBlUHJlZml4QmVmb3JlICE9PSBmYWxzZTtcbiAgICAgICAgdmFyIGVudW1EZWYgPSBGdW5jdGlvbigncmV0dXJuICcgKyBuZXdQYXRoKSgpO1xuICAgICAgICB2YXIgZW50cmllcyA9IGNjLkVudW0uZ2V0TGlzdChlbnVtRGVmKTtcbiAgICAgICAgdmFyIGRlbGltaXRlciA9IGhhc1R5cGVQcmVmaXhCZWZvcmUgPyAnXycgOiAnLic7XG4gICAgICAgIGZvciAodmFyIGkgPSAwOyBpIDwgZW50cmllcy5sZW5ndGg7IGkrKykge1xuICAgICAgICAgICAgdmFyIGVudHJ5ID0gZW50cmllc1tpXS5uYW1lO1xuICAgICAgICAgICAgdmFyIG9sZFByb3BOYW1lO1xuICAgICAgICAgICAgaWYgKGhhc1R5cGVQcmVmaXhCZWZvcmUpIHtcbiAgICAgICAgICAgICAgICB2YXIgb2xkVHlwZU5hbWUgPSBvbGRQYXRoLnNwbGl0KCcuJykuc2xpY2UoLTEpWzBdO1xuICAgICAgICAgICAgICAgIG9sZFByb3BOYW1lID0gb2xkVHlwZU5hbWUgKyAnXycgKyBlbnRyeTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgICAgIG9sZFByb3BOYW1lID0gZW50cnk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBqcy5nZXQob2JqLCBvbGRQcm9wTmFtZSwgZnVuY3Rpb24gKGVudHJ5KSB7XG4gICAgICAgICAgICAgICAgY2MuZXJyb3JJRCgxNDAwLCBvbGRQYXRoICsgZGVsaW1pdGVyICsgZW50cnksIG5ld1BhdGggKyAnLicgKyBlbnRyeSk7XG4gICAgICAgICAgICAgICAgcmV0dXJuIGVudW1EZWZbZW50cnldO1xuICAgICAgICAgICAgfS5iaW5kKG51bGwsIGVudHJ5KSk7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBmdW5jdGlvbiBtYXJrQXNSZW1vdmVkIChvd25lckN0b3IsIHJlbW92ZWRQcm9wcywgb3duZXJOYW1lKSB7XG4gICAgICAgIGlmICghb3duZXJDdG9yKSB7XG4gICAgICAgICAgICAvLyDlj6/og73ooqvoo4HliarkuoZcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuICAgICAgICBvd25lck5hbWUgPSBvd25lck5hbWUgfHwganMuZ2V0Q2xhc3NOYW1lKG93bmVyQ3Rvcik7XG4gICAgICAgIHJlbW92ZWRQcm9wcy5mb3JFYWNoKGZ1bmN0aW9uIChwcm9wKSB7XG4gICAgICAgICAgICBmdW5jdGlvbiBlcnJvciAoKSB7XG4gICAgICAgICAgICAgICAgY2MuZXJyb3JJRCgxNDA2LCBvd25lck5hbWUsIHByb3ApO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAganMuZ2V0c2V0KG93bmVyQ3Rvci5wcm90b3R5cGUsIHByb3AsIGVycm9yLCBlcnJvcik7XG4gICAgICAgIH0pO1xuICAgIH1cblxuICAgIGZ1bmN0aW9uIG1hcmtBc0RlcHJlY2F0ZWQgKG93bmVyQ3RvciwgZGVwcmVjYXRlZFByb3BzLCBvd25lck5hbWUpIHtcbiAgICAgICAgaWYgKCFvd25lckN0b3IpIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuICAgICAgICBvd25lck5hbWUgPSBvd25lck5hbWUgfHwganMuZ2V0Q2xhc3NOYW1lKG93bmVyQ3Rvcik7XG4gICAgICAgIGxldCBkZXNjcmlwdG9ycyA9IE9iamVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3JzKG93bmVyQ3Rvci5wcm90b3R5cGUpO1xuICAgICAgICBkZXByZWNhdGVkUHJvcHMuZm9yRWFjaChmdW5jdGlvbiAocHJvcCkge1xuICAgICAgICAgICAgbGV0IGRlcHJlY2F0ZWRQcm9wID0gcHJvcFswXTtcbiAgICAgICAgICAgIGxldCBuZXdQcm9wID0gcHJvcFsxXTtcbiAgICAgICAgICAgIGxldCBkZXNjcmlwdG9yID0gZGVzY3JpcHRvcnNbZGVwcmVjYXRlZFByb3BdO1xuICAgICAgICAgICAganMuZ2V0c2V0KG93bmVyQ3Rvci5wcm90b3R5cGUsIGRlcHJlY2F0ZWRQcm9wLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICAgICAgY2Mud2FybklEKDE0MDAsIGAke293bmVyTmFtZX0uJHtkZXByZWNhdGVkUHJvcH1gLCBgJHtvd25lck5hbWV9LiR7bmV3UHJvcH1gKTtcbiAgICAgICAgICAgICAgICByZXR1cm4gZGVzY3JpcHRvci5nZXQuY2FsbCh0aGlzKTtcbiAgICAgICAgICAgIH0sIGZ1bmN0aW9uICh2KSB7XG4gICAgICAgICAgICAgICAgY2Mud2FybklEKDE0MDAsIGAke293bmVyTmFtZX0uJHtkZXByZWNhdGVkUHJvcH1gLCBgJHtvd25lck5hbWV9LiR7bmV3UHJvcH1gKTtcbiAgICAgICAgICAgICAgICBkZXNjcmlwdG9yLnNldC5jYWxsKHRoaXMsIHYpO1xuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pXG4gICAgfVxuXG4gICAgZnVuY3Rpb24gbWFya0FzUmVtb3ZlZEluT2JqZWN0IChvd25lck9iaiwgcmVtb3ZlZFByb3BzLCBvd25lck5hbWUpIHtcbiAgICAgICAgaWYgKCFvd25lck9iaikge1xuICAgICAgICAgICAgLy8g5Y+v6IO96KKr6KOB5Ymq5LqGXG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgICAgcmVtb3ZlZFByb3BzLmZvckVhY2goZnVuY3Rpb24gKHByb3ApIHtcbiAgICAgICAgICAgIGZ1bmN0aW9uIGVycm9yICgpIHtcbiAgICAgICAgICAgICAgICBjYy5lcnJvcklEKDE0MDYsIG93bmVyTmFtZSwgcHJvcCk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBqcy5nZXRzZXQob3duZXJPYmosIHByb3AsIGVycm9yKTtcbiAgICAgICAgfSk7XG4gICAgfVxuXG4gICAgZnVuY3Rpb24gcHJvdmlkZUNsZWFyRXJyb3IgKG93bmVyLCBvYmosIG93bmVyTmFtZSkge1xuICAgICAgICBpZiAoIW93bmVyKSB7XG4gICAgICAgICAgICAvLyDlj6/og73ooqvoo4HliarkuoZcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuICAgICAgICB2YXIgY2xhc3NOYW1lID0gb3duZXJOYW1lIHx8IGNjLmpzLmdldENsYXNzTmFtZShvd25lcik7XG4gICAgICAgIHZhciBJbmZvID0gJ1NvcnJ5LCAnICsgY2xhc3NOYW1lICsgJy4lcyBpcyByZW1vdmVkLCBwbGVhc2UgdXNlICVzIGluc3RlYWQuJztcbiAgICAgICAgZm9yICh2YXIgcHJvcCBpbiBvYmopIHtcbiAgICAgICAgICAgIGZ1bmN0aW9uIGRlZmluZSAocHJvcCwgZ2V0c2V0KSB7XG4gICAgICAgICAgICAgICAgZnVuY3Rpb24gYWNjZXNzb3IgKG5ld1Byb3ApIHtcbiAgICAgICAgICAgICAgICAgICAgY2MuZXJyb3IoSW5mbywgcHJvcCwgbmV3UHJvcCk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGlmICghQXJyYXkuaXNBcnJheShnZXRzZXQpKSB7XG4gICAgICAgICAgICAgICAgICAgIGdldHNldCA9IGdldHNldC5zcGxpdCgnLCcpXG4gICAgICAgICAgICAgICAgICAgICAgICAubWFwKGZ1bmN0aW9uICh4KSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHgudHJpbSgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIHRyeSB7XG4gICAgICAgICAgICAgICAgICAgIGpzLmdldHNldChvd25lciwgcHJvcCwgYWNjZXNzb3IuYmluZChudWxsLCBnZXRzZXRbMF0pLCBnZXRzZXRbMV0gJiYgYWNjZXNzb3IuYmluZChudWxsLCBnZXRzZXRbMV0pKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgY2F0Y2ggKGUpIHt9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB2YXIgZ2V0c2V0ID0gb2JqW3Byb3BdO1xuICAgICAgICAgICAgaWYgKHByb3BbMF0gPT09ICcqJykge1xuICAgICAgICAgICAgICAgIC8vIGdldCBzZXRcbiAgICAgICAgICAgICAgICB2YXIgZXRQcm9wID0gcHJvcC5zbGljZSgxKTtcbiAgICAgICAgICAgICAgICBkZWZpbmUoJ2cnICsgZXRQcm9wLCBnZXRzZXQpO1xuICAgICAgICAgICAgICAgIGRlZmluZSgncycgKyBldFByb3AsIGdldHNldCk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgICAgICBwcm9wLnNwbGl0KCcsJylcbiAgICAgICAgICAgICAgICAgICAgLm1hcChmdW5jdGlvbiAoeCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHgudHJpbSgpO1xuICAgICAgICAgICAgICAgICAgICB9KVxuICAgICAgICAgICAgICAgICAgICAuZm9yRWFjaChmdW5jdGlvbiAoeCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgZGVmaW5lKHgsIGdldHNldCk7XG4gICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgfVxuXG4gICAgZnVuY3Rpb24gbWFya0Z1bmN0aW9uV2FybmluZyAob3duZXJDdG9yLCBvYmosIG93bmVyTmFtZSkge1xuICAgICAgICBpZiAoIW93bmVyQ3Rvcikge1xuICAgICAgICAgICAgLy8g5Y+v6IO96KKr6KOB5Ymq5LqGXG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgICAgb3duZXJOYW1lID0gb3duZXJOYW1lIHx8IGpzLmdldENsYXNzTmFtZShvd25lckN0b3IpO1xuICAgICAgICBmb3IgKHZhciBwcm9wIGluIG9iaikge1xuICAgICAgICAgICAgKGZ1bmN0aW9uKCl7XG4gICAgICAgICAgICAgICAgdmFyIHByb3BOYW1lID0gcHJvcDtcbiAgICAgICAgICAgICAgICB2YXIgb3JpZ2luRnVuYyA9IG93bmVyQ3Rvcltwcm9wTmFtZV07XG4gICAgICAgICAgICAgICAgaWYgKCFvcmlnaW5GdW5jKSByZXR1cm47XG5cbiAgICAgICAgICAgICAgICBmdW5jdGlvbiB3YXJuICgpIHtcbiAgICAgICAgICAgICAgICAgICAgY2Mud2FybignU29ycnksICVzLiVzIGlzIGRlcHJlY2F0ZWQuIFBsZWFzZSB1c2UgJXMgaW5zdGVhZCcsIG93bmVyTmFtZSwgcHJvcE5hbWUsIG9ialtwcm9wTmFtZV0pO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gb3JpZ2luRnVuYy5hcHBseSh0aGlzLCBhcmd1bWVudHMpO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIG93bmVyQ3Rvcltwcm9wTmFtZV0gPSB3YXJuO1xuICAgICAgICAgICAgfSkoKTtcbiAgICAgICAgfVxuICAgIH1cbiAgICAvLyByZW1vdmUgY2MuaW5mb1xuICAgIGpzLmdldChjYywgJ2luZm8nLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgIGNjLmVycm9ySUQoMTQwMCwgJ2NjLmluZm8nLCAnY2MubG9nJyk7XG4gICAgICAgIHJldHVybiBjYy5sb2c7XG4gICAgfSk7XG4gICAgLy8gY2Muc3ByaXRlRnJhbWVDYWNoZVxuICAgIGpzLmdldChjYywgXCJzcHJpdGVGcmFtZUNhY2hlXCIsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2MuZXJyb3JJRCgxNDA0KTtcbiAgICB9KTtcblxuICAgIC8vIGNjLnZtYXRoXG4gICAganMuZ2V0KGNjLCAndm1hdGgnLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgIGNjLndhcm5JRCgxNDAwLCAnY2Mudm1hdGgnLCAnY2MubWF0aCcpO1xuICAgICAgICByZXR1cm4gY2MubWF0aDtcbiAgICB9KTtcbiAgICBqcy5nZXQoY2MubWF0aCwgJ3ZlYzInLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgIGNjLndhcm5JRCgxNDAwLCAnY2Mudm1hdGgudmVjMicsICdjYy5WZWMyJyk7XG4gICAgICAgIHJldHVybiBjYy5WZWMyO1xuICAgIH0pXG4gICAganMuZ2V0KGNjLm1hdGgsICd2ZWMzJywgZnVuY3Rpb24gKCkge1xuICAgICAgICBjYy53YXJuSUQoMTQwMCwgJ2NjLnZtYXRoLnZlYzMnLCAnY2MuVmVjMycpO1xuICAgICAgICByZXR1cm4gY2MuVmVjMztcbiAgICB9KVxuICAgIGpzLmdldChjYy5tYXRoLCAndmVjNCcsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2Mud2FybklEKDE0MDAsICdjYy52bWF0aC52ZWM0JywgJ2NjLlZlYzQnKTtcbiAgICAgICAgcmV0dXJuIGNjLlZlYzQ7XG4gICAgfSlcbiAgICBqcy5nZXQoY2MubWF0aCwgJ21hdDQnLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgIGNjLndhcm5JRCgxNDAwLCAnY2Mudm1hdGgubWF0NCcsICdjYy5NYXQ0Jyk7XG4gICAgICAgIHJldHVybiBjYy5NYXQ0O1xuICAgIH0pXG4gICAganMuZ2V0KGNjLm1hdGgsICdtYXQzJywgZnVuY3Rpb24gKCkge1xuICAgICAgICBjYy53YXJuSUQoMTQwMCwgJ2NjLnZtYXRoLm1hdDMnLCAnY2MuTWF0MycpO1xuICAgICAgICByZXR1cm4gY2MuTWF0MztcbiAgICB9KVxuICAgIGpzLmdldChjYy5tYXRoLCAncXVhdCcsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2Mud2FybklEKDE0MDAsICdjYy52bWF0aC5xdWF0JywgJ2NjLlF1YXQnKTtcbiAgICAgICAgcmV0dXJuIGNjLlF1YXQ7XG4gICAgfSlcblxuICAgIC8vIFNwcml0ZUZyYW1lXG4gICAganMuZ2V0KGNjLlNwcml0ZUZyYW1lLnByb3RvdHlwZSwgJ190ZXh0dXJlTG9hZGVkJywgZnVuY3Rpb24gKCkge1xuICAgICAgICBjYy5lcnJvcklEKDE0MDAsICdzcHJpdGVGcmFtZS5fdGV4dHVyZUxvYWRlZCcsICdzcHJpdGVGcmFtZS50ZXh0dXJlTG9hZGVkKCknKTtcbiAgICAgICAgcmV0dXJuIHRoaXMudGV4dHVyZUxvYWRlZCgpO1xuICAgIH0pO1xuICAgIG1hcmtBc1JlbW92ZWQoY2MuU3ByaXRlRnJhbWUsIFtcbiAgICAgICAgJ2FkZExvYWRlZEV2ZW50TGlzdGVuZXInXG4gICAgXSk7XG4gICAgbWFya0Z1bmN0aW9uV2FybmluZyhjYy5TcHJpdGUucHJvdG90eXBlLCB7XG4gICAgICAgIHNldFN0YXRlOiAnY2MuU3ByaXRlLnNldE1hdGVyaWFsJyxcbiAgICAgICAgZ2V0U3RhdGU6ICdjYy5TcHJpdGUuZ2V0TWF0ZXJpYWwnXG4gICAgfSwgJ2NjLlNwcml0ZScpO1xuXG4gICAganMuZ2V0KGNjLlNwcml0ZUZyYW1lLnByb3RvdHlwZSwgJ2NsZWFyVGV4dHVyZScsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2MuZXJyb3JJRCgxNDA2LCAnY2MuU3ByaXRlRnJhbWUnLCAnY2xlYXJUZXh0dXJlJyk7XG4gICAgICAgIHJldHVybiBmdW5jdGlvbiAoKSB7fTtcbiAgICB9KTtcblxuICAgIC8vIGNjLnRleHR1cmVDYWNoZVxuICAgIGpzLmdldChjYywgJ3RleHR1cmVDYWNoZScsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2MuZXJyb3JJRCgxNDA2LCAnY2MnLCAndGV4dHVyZUNhY2hlJyk7XG4gICAgfSk7XG5cbiAgICAvLyBUZXh0dXJlXG4gICAgbGV0IFRleHR1cmUyRCA9IGNjLlRleHR1cmUyRDtcbiAgICBqcy5nZXQoVGV4dHVyZTJELnByb3RvdHlwZSwgJ3JlbGVhc2VUZXh0dXJlJywgZnVuY3Rpb24gKCkge1xuICAgICAgICBjYy5lcnJvcklEKDE0MDAsICd0ZXh0dXJlLnJlbGVhc2VUZXh0dXJlKCknLCAndGV4dHVyZS5kZXN0cm95KCknKTtcbiAgICAgICAgcmV0dXJuIHRoaXMuZGVzdHJveTtcbiAgICB9KTtcblxuICAgIGpzLmdldChUZXh0dXJlMkQucHJvdG90eXBlLCAnZ2V0TmFtZScsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2MuZXJyb3JJRCgxNDAwLCAndGV4dHVyZS5nZXROYW1lKCknLCAndGV4dHVyZS5fZ2xJRCcpO1xuICAgICAgICByZXR1cm4gZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuX2dsSUQgfHwgbnVsbDtcbiAgICAgICAgfTtcbiAgICB9KTtcblxuICAgIGpzLmdldChUZXh0dXJlMkQucHJvdG90eXBlLCAnaXNMb2FkZWQnLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgIGNjLmVycm9ySUQoMTQwMCwgJ3RleHR1cmUuaXNMb2FkZWQgZnVuY3Rpb24nLCAndGV4dHVyZS5sb2FkZWQgcHJvcGVydHknKTtcbiAgICAgICAgcmV0dXJuIChmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5sb2FkZWQ7XG4gICAgICAgIH0pO1xuICAgIH0pO1xuXG4gICAganMuZ2V0KFRleHR1cmUyRC5wcm90b3R5cGUsICdzZXRBbnRpQWxpYXNUZXhQYXJhbWV0ZXJzJywgZnVuY3Rpb24gKCkge1xuICAgICAgICBjYy5lcnJvcklEKDE0MDAsICd0ZXh0dXJlLnNldEFudGlBbGlhc1RleFBhcmFtZXRlcnMoKScsICd0ZXh0dXJlLnNldEZpbHRlcnMoY2MuVGV4dHVyZTJELkZpbHRlci5MSU5FQVIsIGNjLlRleHR1cmUyRC5GaWx0ZXIuTElORUFSKScpO1xuICAgICAgICByZXR1cm4gZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgdGhpcy5zZXRGaWx0ZXJzKFRleHR1cmUyRC5GaWx0ZXIuTElORUFSLCBUZXh0dXJlMkQuRmlsdGVyLkxJTkVBUik7XG4gICAgICAgIH07XG4gICAgfSk7XG5cbiAgICBqcy5nZXQoVGV4dHVyZTJELnByb3RvdHlwZSwgJ3NldEFsaWFzVGV4UGFyYW1ldGVycycsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2MuZXJyb3JJRCgxNDAwLCAndGV4dHVyZS5zZXRBbnRpQWxpYXNUZXhQYXJhbWV0ZXJzKCknLCAndGV4dHVyZS5zZXRGaWx0ZXJzKGNjLlRleHR1cmUyRC5GaWx0ZXIuTkVBUkVTVCwgY2MuVGV4dHVyZTJELkZpbHRlci5ORUFSRVNUKScpO1xuICAgICAgICByZXR1cm4gZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgdGhpcy5zZXRGaWx0ZXJzKFRleHR1cmUyRC5GaWx0ZXIuTkVBUkVTVCwgVGV4dHVyZTJELkZpbHRlci5ORUFSRVNUKTtcbiAgICAgICAgfTtcbiAgICB9KTtcblxuICAgIC8vIGNjLm1hY3JvXG4gICAgbWFya0FzUmVtb3ZlZEluT2JqZWN0KGNjLm1hY3JvLCBbXG4gICAgICAgICdFTkFCTEVfR0xfU1RBVEVfQ0FDSEUnLFxuICAgICAgICAnRklYX0FSVElGQUNUU19CWV9TVFJFQ0hJTkdfVEVYRUwnLFxuICAgIF0sICdjYy5tYWNybycpO1xuXG4gICAgcHJvdmlkZUNsZWFyRXJyb3IoY2MubWFjcm8sIHtcbiAgICAgICAgUEk6ICdNYXRoLlBJJyxcbiAgICAgICAgUEkyOiAnTWF0aC5QSSAqIDInLFxuICAgICAgICBGTFRfTUFYOiAnTnVtYmVyLk1BWF9WQUxVRScsXG4gICAgICAgIEZMVF9NSU46ICdOdW1iZXIuTUlOX1ZBTFVFJyxcbiAgICAgICAgVUlOVF9NQVg6ICdOdW1iZXIuTUFYX1NBRkVfSU5URUdFUidcbiAgICB9LCAnY2MubWFjcm8nKTtcblxuICAgIC8vIGNjLmdhbWVcbiAgICBtYXJrQXNSZW1vdmVkSW5PYmplY3QoY2MuZ2FtZSwgW1xuICAgICAgICAnQ09ORklHX0tFWScsXG4gICAgXSwgJ2NjLmdhbWUnKTtcblxuICAgIC8vIGNjLnN5c1xuICAgIG1hcmtBc1JlbW92ZWRJbk9iamVjdChjYy5zeXMsIFtcbiAgICAgICAgJ2R1bXBSb290JyxcbiAgICAgICAgJ2NsZWFuU2NyaXB0JyxcbiAgICBdLCAnY2Muc3lzJyk7XG5cbiAgICAvLyBjYy5EaXJlY3RvclxuICAgIHByb3ZpZGVDbGVhckVycm9yKGNjLkRpcmVjdG9yLCB7XG4gICAgICAgIEVWRU5UX1BST0pFQ1RJT05fQ0hBTkdFRDogJycsXG4gICAgICAgIEVWRU5UX0JFRk9SRV9WSVNJVDogJ0VWRU5UX0FGVEVSX1VQREFURScsXG4gICAgICAgIEVWRU5UX0FGVEVSX1ZJU0lUOiAnRVZFTlRfQkVGT1JFX0RSQVcnLFxuICAgIH0sICdjYy5EaXJlY3RvcicpO1xuICAgIG1hcmtGdW5jdGlvbldhcm5pbmcoY2MuRGlyZWN0b3IucHJvdG90eXBlLCB7XG4gICAgICAgIGNvbnZlcnRUb0dMOiAnY2Mudmlldy5jb252ZXJ0VG9Mb2NhdGlvbkluVmlldycsXG4gICAgICAgIGNvbnZlcnRUb1VJOiAnJyxcbiAgICAgICAgZ2V0V2luU2l6ZTogJ2NjLndpblNpemUnLFxuICAgICAgICBnZXRXaW5TaXplSW5QaXhlbHM6ICdjYy53aW5TaXplJyxcbiAgICAgICAgZ2V0VmlzaWJsZVNpemU6ICdjYy52aWV3LmdldFZpc2libGVTaXplJyxcbiAgICAgICAgZ2V0VmlzaWJsZU9yaWdpbjogJ2NjLnZpZXcuZ2V0VmlzaWJsZU9yaWdpbicsXG4gICAgICAgIHB1cmdlQ2FjaGVkRGF0YTogJ2NjLmxvYWRlci5yZWxlYXNlQWxsJyxcbiAgICAgICAgc2V0RGVwdGhUZXN0OiAnY2MuQ2FtZXJhLm1haW4uZGVwdGgnLFxuICAgICAgICBzZXRDbGVhckNvbG9yOiAnY2MuQ2FtZXJhLm1haW4uYmFja2dyb3VuZENvbG9yJyxcbiAgICAgICAgZ2V0UnVubmluZ1NjZW5lOiAnY2MuZGlyZWN0b3IuZ2V0U2NlbmUnLFxuICAgICAgICBnZXRBbmltYXRpb25JbnRlcnZhbDogJ2NjLmdhbWUuZ2V0RnJhbWVSYXRlJyxcbiAgICAgICAgc2V0QW5pbWF0aW9uSW50ZXJ2YWw6ICdjYy5nYW1lLnNldEZyYW1lUmF0ZScsXG4gICAgICAgIGlzRGlzcGxheVN0YXRzOiAnY2MuZGVidWcuaXNEaXNwbGF5U3RhdHMnLFxuICAgICAgICBzZXREaXNwbGF5U3RhdHM6ICdjYy5kZWJ1Zy5zZXREaXNwbGF5U3RhdHMnLFxuICAgICAgICBzdG9wQW5pbWF0aW9uOiAnY2MuZ2FtZS5wYXVzZScsXG4gICAgICAgIHN0YXJ0QW5pbWF0aW9uOiAnY2MuZ2FtZS5yZXN1bWUnLFxuICAgIH0sICdjYy5EaXJlY3RvcicpO1xuICAgIG1hcmtBc1JlbW92ZWQoY2MuRGlyZWN0b3IsIFtcbiAgICAgICAgJ3B1c2hTY2VuZScsXG4gICAgICAgICdwb3BTY2VuZScsXG4gICAgICAgICdwb3BUb1Jvb3RTY2VuZScsXG4gICAgICAgICdwb3BUb1NjZW5lU3RhY2tMZXZlbCcsXG4gICAgICAgICdzZXRQcm9qZWN0aW9uJyxcbiAgICAgICAgJ2dldFByb2plY3Rpb24nLFxuICAgIF0sICdjYy5EaXJlY3RvcicpO1xuXG4gICAgLy8gU2NoZWR1bGVyXG4gICAgcHJvdmlkZUNsZWFyRXJyb3IoY2MuU2NoZWR1bGVyLCB7XG4gICAgICAgIHNjaGVkdWxlQ2FsbGJhY2tGb3JUYXJnZXQ6ICdzY2hlZHVsZScsXG4gICAgICAgIHNjaGVkdWxlVXBkYXRlRm9yVGFyZ2V0OiAnc2NoZWR1bGVVcGRhdGUnLFxuICAgICAgICB1bnNjaGVkdWxlQ2FsbGJhY2tGb3JUYXJnZXQ6ICd1bnNjaGVkdWxlJyxcbiAgICAgICAgdW5zY2hlZHVsZVVwZGF0ZUZvclRhcmdldDogJ3Vuc2NoZWR1bGVVcGRhdGUnLFxuICAgICAgICB1bnNjaGVkdWxlQWxsQ2FsbGJhY2tzRm9yVGFyZ2V0OiAndW5zY2hlZHVsZUFsbEZvclRhcmdldCcsXG4gICAgICAgIHVuc2NoZWR1bGVBbGxDYWxsYmFja3M6ICd1bnNjaGVkdWxlQWxsJyxcbiAgICAgICAgdW5zY2hlZHVsZUFsbENhbGxiYWNrc1dpdGhNaW5Qcmlvcml0eTogJ3Vuc2NoZWR1bGVBbGxXaXRoTWluUHJpb3JpdHknXG4gICAgfSwgJ2NjLlNjaGVkdWxlcicpO1xuXG4gICAgLy8gY2Mudmlld1xuICAgIHByb3ZpZGVDbGVhckVycm9yKGNjLnZpZXcsIHtcbiAgICAgICAgYWRqdXN0Vmlld1BvcnQ6ICdhZGp1c3RWaWV3cG9ydE1ldGEnLFxuICAgICAgICBzZXRWaWV3UG9ydEluUG9pbnRzOiAnc2V0Vmlld3BvcnRJblBvaW50cycsXG4gICAgICAgIGdldFZpZXdQb3J0UmVjdDogJ2dldFZpZXdwb3J0UmVjdCdcbiAgICB9LCAnY2MudmlldycpO1xuICAgIG1hcmtBc1JlbW92ZWRJbk9iamVjdChjYy52aWV3LCBbXG4gICAgICAgICdpc1ZpZXdSZWFkeScsXG4gICAgICAgICdzZXRUYXJnZXREZW5zaXR5RFBJJyxcbiAgICAgICAgJ2dldFRhcmdldERlbnNpdHlEUEknLFxuICAgICAgICAnc2V0RnJhbWVab29tRmFjdG9yJyxcbiAgICAgICAgJ2NhblNldENvbnRlbnRTY2FsZUZhY3RvcicsXG4gICAgICAgICdzZXRDb250ZW50VHJhbnNsYXRlTGVmdFRvcCcsXG4gICAgICAgICdnZXRDb250ZW50VHJhbnNsYXRlTGVmdFRvcCcsXG4gICAgICAgICdzZXRWaWV3TmFtZScsXG4gICAgICAgICdnZXRWaWV3TmFtZSdcbiAgICBdLCAnY2MudmlldycpO1xuXG4gICAgLy8gTG9hZGVyXG4gICAgbWFya0FzUmVtb3ZlZChjYy5QaXBlbGluZSwgW1xuICAgICAgICAnZmxvd0luRGVwcycsXG4gICAgICAgICdnZXRJdGVtcydcbiAgICBdLCAnY2MubG9hZGVyJyk7XG5cbiAgICAvLyBjYy5QaHlzaWNzTWFuYWdlclxuICAgIG1hcmtBc1JlbW92ZWQoY2MuUGh5c2ljc01hbmFnZXIsIFtcbiAgICAgICAgJ2F0dGFjaERlYnVnRHJhd1RvQ2FtZXJhJyxcbiAgICAgICAgJ2RldGFjaERlYnVnRHJhd0Zyb21DYW1lcmEnLFxuICAgIF0pO1xuXG4gICAgLy8gY2MuQ29sbGlzaW9uTWFuYWdlclxuICAgIG1hcmtBc1JlbW92ZWQoY2MuQ29sbGlzaW9uTWFuYWdlciwgW1xuICAgICAgICAnYXR0YWNoRGVidWdEcmF3VG9DYW1lcmEnLFxuICAgICAgICAnZGV0YWNoRGVidWdEcmF3RnJvbUNhbWVyYScsXG4gICAgXSk7XG5cbiAgICAvLyBjYy5Ob2RlXG4gICAgcHJvdmlkZUNsZWFyRXJyb3IoY2MuX0Jhc2VOb2RlLnByb3RvdHlwZSwge1xuICAgICAgICAndGFnJzogJ25hbWUnLFxuICAgICAgICAnZ2V0VGFnJzogJ25hbWUnLFxuICAgICAgICAnc2V0VGFnJzogJ25hbWUnLFxuICAgICAgICAnZ2V0Q2hpbGRCeVRhZyc6ICdnZXRDaGlsZEJ5TmFtZScsXG4gICAgICAgICdyZW1vdmVDaGlsZEJ5VGFnJzogJ2dldENoaWxkQnlOYW1lKG5hbWUpLmRlc3Ryb3koKSdcbiAgICB9KTtcblxuICAgIG1hcmtBc1JlbW92ZWQoY2MuTm9kZSwgW1xuICAgICAgICAnX2Nhc2NhZGVDb2xvckVuYWJsZWQnLFxuICAgICAgICAnY2FzY2FkZUNvbG9yJyxcbiAgICAgICAgJ2lzQ2FzY2FkZUNvbG9yRW5hYmxlZCcsXG4gICAgICAgICdzZXRDYXNjYWRlQ29sb3JFbmFibGVkJyxcbiAgICAgICAgJ19jYXNjYWRlT3BhY2l0eUVuYWJsZWQnLFxuICAgICAgICAnY2FzY2FkZU9wYWNpdHknLFxuICAgICAgICAnaXNDYXNjYWRlT3BhY2l0eUVuYWJsZWQnLFxuICAgICAgICAnc2V0Q2FzY2FkZU9wYWNpdHlFbmFibGVkJyxcbiAgICAgICAgJ29wYWNpdHlNb2RpZnlSR0InLFxuICAgICAgICAnaXNPcGFjaXR5TW9kaWZ5UkdCJyxcbiAgICAgICAgJ3NldE9wYWNpdHlNb2RpZnlSR0InLFxuICAgICAgICAnaWdub3JlQW5jaG9yJyxcbiAgICAgICAgJ2lzSWdub3JlQW5jaG9yUG9pbnRGb3JQb3NpdGlvbicsXG4gICAgICAgICdpZ25vcmVBbmNob3JQb2ludEZvclBvc2l0aW9uJyxcbiAgICAgICAgJ2lzUnVubmluZycsXG4gICAgICAgICdfc2dOb2RlJyxcbiAgICBdKTtcblxuICAgIG1hcmtGdW5jdGlvbldhcm5pbmcoY2MuTm9kZS5wcm90b3R5cGUsIHtcbiAgICAgICAgZ2V0Tm9kZVRvUGFyZW50VHJhbnNmb3JtOiAnZ2V0TG9jYWxNYXRyaXgnLFxuICAgICAgICBnZXROb2RlVG9QYXJlbnRUcmFuc2Zvcm1BUjogJ2dldExvY2FsTWF0cml4JyxcbiAgICAgICAgZ2V0Tm9kZVRvV29ybGRUcmFuc2Zvcm06ICdnZXRXb3JsZE1hdHJpeCcsXG4gICAgICAgIGdldE5vZGVUb1dvcmxkVHJhbnNmb3JtQVI6ICdnZXRXb3JsZE1hdHJpeCcsXG4gICAgICAgIGdldFBhcmVudFRvTm9kZVRyYW5zZm9ybTogJ2dldExvY2FsTWF0cml4JyxcbiAgICAgICAgZ2V0V29ybGRUb05vZGVUcmFuc2Zvcm06ICdnZXRXb3JsZE1hdHJpeCcsXG4gICAgICAgIGNvbnZlcnRUb3VjaFRvTm9kZVNwYWNlOiAnY29udmVydFRvTm9kZVNwYWNlQVInLFxuICAgICAgICBjb252ZXJ0VG91Y2hUb05vZGVTcGFjZUFSOiAnY29udmVydFRvTm9kZVNwYWNlQVInLFxuICAgICAgICBjb252ZXJ0VG9Xb3JsZFNwYWNlOiAnY29udmVydFRvV29ybGRTcGFjZUFSJyxcbiAgICAgICAgY29udmVydFRvTm9kZVNwYWNlOiAnY29udmVydFRvTm9kZVNwYWNlQVInXG4gICAgfSk7XG5cbiAgICBwcm92aWRlQ2xlYXJFcnJvcihjYy5Ob2RlLnByb3RvdHlwZSwge1xuICAgICAgICBnZXRSb3RhdGlvblg6ICdyb3RhdGlvblgnLFxuICAgICAgICBzZXRSb3RhdGlvblg6ICdyb3RhdGlvblgnLFxuICAgICAgICBnZXRSb3RhdGlvblk6ICdyb3RhdGlvblknLFxuICAgICAgICBzZXRSb3RhdGlvblk6ICdyb3RhdGlvblknLFxuICAgICAgICBnZXRQb3NpdGlvblg6ICd4JyxcbiAgICAgICAgc2V0UG9zaXRpb25YOiAneCcsXG4gICAgICAgIGdldFBvc2l0aW9uWTogJ3knLFxuICAgICAgICBzZXRQb3NpdGlvblk6ICd5JyxcbiAgICAgICAgZ2V0U2tld1g6ICdza2V3WCcsXG4gICAgICAgIHNldFNrZXdYOiAnc2tld1gnLFxuICAgICAgICBnZXRTa2V3WTogJ3NrZXdZJyxcbiAgICAgICAgc2V0U2tld1k6ICdza2V3WScsXG4gICAgICAgIGdldFNjYWxlWDogJ3NjYWxlWCcsXG4gICAgICAgIHNldFNjYWxlWDogJ3NjYWxlWCcsXG4gICAgICAgIGdldFNjYWxlWTogJ3NjYWxlWScsXG4gICAgICAgIHNldFNjYWxlWTogJ3NjYWxlWScsXG4gICAgICAgIGdldE9wYWNpdHk6ICdvcGFjaXR5JyxcbiAgICAgICAgc2V0T3BhY2l0eTogJ29wYWNpdHknLFxuICAgICAgICBnZXRDb2xvcjogJ2NvbG9yJyxcbiAgICAgICAgc2V0Q29sb3I6ICdjb2xvcicsXG4gICAgICAgIGdldExvY2FsWk9yZGVyOiAnekluZGV4JyxcbiAgICAgICAgc2V0TG9jYWxaT3JkZXI6ICd6SW5kZXgnLFxuICAgIH0pO1xuXG4gICAgcHJvdmlkZUNsZWFyRXJyb3IoY2MuU3ByaXRlLnByb3RvdHlwZSwge1xuICAgICAgICBzZXRJbnNldExlZnQ6ICdjYy5TcHJpdGVGcmFtZSBpbnNldExlZnQnLFxuICAgICAgICBzZXRJbnNldFJpZ2h0OiAnY2MuU3ByaXRlRnJhbWUgaW5zZXRSaWdodCcsXG4gICAgICAgIHNldEluc2V0VG9wOiAnY2MuU3ByaXRlRnJhbWUgaW5zZXRUb3AnLFxuICAgICAgICBzZXRJbnNldEJvdHRvbTogJ2NjLlNwcml0ZUZyYW1lIGluc2V0Qm90dG9tJyxcbiAgICB9KTtcblxuICAgIC8vIGNjLk1hdGVyaWFsXG4gICAgY2MuTWF0ZXJpYWwuZ2V0SW5zdGFudGlhdGVkQnVpbHRpbk1hdGVyaWFsID0gY2MuTWF0ZXJpYWxWYXJpYW50LmNyZWF0ZVdpdGhCdWlsdGluO1xuICAgIGNjLk1hdGVyaWFsLmdldEluc3RhbnRpYXRlZE1hdGVyaWFsID0gY2MuTWF0ZXJpYWxWYXJpYW50LmNyZWF0ZTtcbiAgICBtYXJrRnVuY3Rpb25XYXJuaW5nKGNjLk1hdGVyaWFsLCB7XG4gICAgICAgIGdldEluc3RhbnRpYXRlZEJ1aWx0aW5NYXRlcmlhbDogJ2NjLk1hdGVyaWFsVmFyaWFudC5jcmVhdGVXaXRoQnVpbHRpbicsXG4gICAgICAgIGdldEluc3RhbnRpYXRlZE1hdGVyaWFsOiAnY2MuTWF0ZXJpYWxWYXJpYW50LmNyZWF0ZSdcbiAgICB9KVxuXG4gICAgLy8gY2MuUmVuZGVyQ29tcG9uZW50XG4gICAgY2MuanMuZ2V0c2V0KGNjLlJlbmRlckNvbXBvbmVudC5wcm90b3R5cGUsICdzaGFyZWRNYXRlcmlhbHMnLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgIGNjLndhcm5JRCgxNDAwLCAnc2hhcmVkTWF0ZXJpYWxzJywgJ2dldE1hdGVyaWFscycpO1xuICAgICAgICByZXR1cm4gdGhpcy5tYXRlcmlhbHM7XG4gICAgfSwgZnVuY3Rpb24gKHYpIHtcbiAgICAgICAgY2Mud2FybklEKDE0MDAsICdzaGFyZWRNYXRlcmlhbHMnLCAnc2V0TWF0ZXJpYWwnKTtcbiAgICAgICAgdGhpcy5tYXRlcmlhbHMgPSB2O1xuICAgIH0pXG5cbiAgICAvLyBjYy5DYW1lcmFcbiAgICBtYXJrRnVuY3Rpb25XYXJuaW5nKGNjLkNhbWVyYS5wcm90b3R5cGUsIHtcbiAgICAgICAgZ2V0Tm9kZVRvQ2FtZXJhVHJhbnNmb3JtOiAnZ2V0V29ybGRUb1NjcmVlbk1hdHJpeDJEJyxcbiAgICAgICAgZ2V0Q2FtZXJhVG9Xb3JsZFBvaW50OiAnZ2V0U2NyZWVuVG9Xb3JsZFBvaW50JyxcbiAgICAgICAgZ2V0V29ybGRUb0NhbWVyYVBvaW50OiAnZ2V0V29ybGRUb1NjcmVlblBvaW50JyxcbiAgICAgICAgZ2V0Q2FtZXJhVG9Xb3JsZE1hdHJpeDogJ2dldFNjcmVlblRvV29ybGRNYXRyaXgyRCcsXG4gICAgICAgIGdldFdvcmxkVG9DYW1lcmFNYXRyaXg6ICdnZXRXb3JsZFRvU2NyZWVuTWF0cml4MkQnXG4gICAgfSk7XG5cbiAgICBtYXJrQXNSZW1vdmVkKGNjLkNhbWVyYSwgW1xuICAgICAgICAnYWRkVGFyZ2V0JyxcbiAgICAgICAgJ3JlbW92ZVRhcmdldCcsXG4gICAgICAgICdnZXRUYXJnZXRzJ1xuICAgIF0pO1xuXG4gICAgLy8gU0NFTkVcbiAgICB2YXIgRVJSID0gJ1wiJXNcIiBpcyBub3QgZGVmaW5lZCBpbiB0aGUgU2NlbmUsIGl0IGlzIG9ubHkgZGVmaW5lZCBpbiBub3JtYWwgbm9kZXMuJztcbiAgICBDQ19FRElUT1IgfHwgT2JqZWN0LmRlZmluZVByb3BlcnRpZXMoY2MuU2NlbmUucHJvdG90eXBlLCB7XG4gICAgICAgIGFjdGl2ZToge1xuICAgICAgICAgICAgZ2V0OiBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICAgICAgY2MuZXJyb3IoRVJSLCAnYWN0aXZlJyk7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgc2V0OiBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICAgICAgY2MuZXJyb3IoRVJSLCAnYWN0aXZlJyk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICAgIGFjdGl2ZUluSGllcmFyY2h5OiB7XG4gICAgICAgICAgICBnZXQ6IGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgICAgICBjYy5lcnJvcihFUlIsICdhY3RpdmVJbkhpZXJhcmNoeScpO1xuICAgICAgICAgICAgICAgIHJldHVybiB0cnVlO1xuICAgICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgICAgZ2V0Q29tcG9uZW50OiB7XG4gICAgICAgICAgICBnZXQ6IGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgICAgICBjYy5lcnJvcihFUlIsICdnZXRDb21wb25lbnQnKTtcbiAgICAgICAgICAgICAgICByZXR1cm4gZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gbnVsbDtcbiAgICAgICAgICAgICAgICB9O1xuICAgICAgICAgICAgfVxuICAgICAgICB9LFxuICAgICAgICBhZGRDb21wb25lbnQ6IHtcbiAgICAgICAgICAgIGdldDogZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgICAgIGNjLmVycm9yKEVSUiwgJ2FkZENvbXBvbmVudCcpO1xuICAgICAgICAgICAgICAgIHJldHVybiBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiBudWxsO1xuICAgICAgICAgICAgICAgIH07XG4gICAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgfSk7XG5cbiAgICAvLyBjYy5keW5hbWljQXRsYXNNYW5hZ2VyXG4gICAgbWFya0FzUmVtb3ZlZEluT2JqZWN0KGNjLmR5bmFtaWNBdGxhc01hbmFnZXIsIFtcbiAgICAgICAgJ21pbkZyYW1lU2l6ZSdcbiAgICBdLCAnY2MuZHluYW1pY0F0bGFzTWFuYWdlcicpXG5cbiAgICAvLyBsaWdodCBjb21wb25lbnRcbiAgICBpZiAoY2MuTGlnaHQpIHtcbiAgICAgICAgbWFya0FzUmVtb3ZlZEluT2JqZWN0KGNjLkxpZ2h0LnByb3RvdHlwZSwgW1xuICAgICAgICAgICAgJ3NoYWRvd0RlcHRoU2NhbGUnLFxuICAgICAgICBdLCAnY2MuTGlnaHQucHJvdG90eXBlJyk7XG4gICAgfVxuXG4gICAgLy8gVmFsdWUgdHlwZXNcbiAgICBwcm92aWRlQ2xlYXJFcnJvcihjYywge1xuICAgICAgICAvLyBBZmZpbmVUcmFuc2Zvcm1cbiAgICAgICAgYWZmaW5lVHJhbnNmb3JtTWFrZTogJ2NjLkFmZmluZVRyYW5zZm9ybS5jcmVhdGUnLFxuICAgICAgICBhZmZpbmVUcmFuc2Zvcm1NYWtlSWRlbnRpdHk6ICdjYy5BZmZpbmVUcmFuc2Zvcm0uaWRlbnRpdHknLFxuICAgICAgICBhZmZpbmVUcmFuc2Zvcm1DbG9uZTogJ2NjLkFmZmluZVRyYW5zZm9ybS5jbG9uZScsXG4gICAgICAgIGFmZmluZVRyYW5zZm9ybUNvbmNhdDogJ2NjLkFmZmluZVRyYW5zZm9ybS5jb25jYXQnLFxuICAgICAgICBhZmZpbmVUcmFuc2Zvcm1Db25jYXRJbjogJ2NjLkFmZmluZVRyYW5zZm9ybS5jb25jYXQnLFxuICAgICAgICBhZmZpbmVUcmFuc2Zvcm1JbnZlcnQ6ICdjYy5BZmZpbmVUcmFuc2Zvcm0uaW52ZXJ0JyxcbiAgICAgICAgYWZmaW5lVHJhbnNmb3JtSW52ZXJ0SW46ICdjYy5BZmZpbmVUcmFuc2Zvcm0uaW52ZXJ0JyxcbiAgICAgICAgYWZmaW5lVHJhbnNmb3JtSW52ZXJ0T3V0OiAnY2MuQWZmaW5lVHJhbnNmb3JtLmludmVydCcsXG4gICAgICAgIGFmZmluZVRyYW5zZm9ybUVxdWFsVG9UcmFuc2Zvcm06ICdjYy5BZmZpbmVUcmFuc2Zvcm0uZXF1YWwnLFxuICAgICAgICBwb2ludEFwcGx5QWZmaW5lVHJhbnNmb3JtOiAnY2MuQWZmaW5lVHJhbnNmb3JtLnRyYW5zZm9ybVZlYzInLFxuICAgICAgICBzaXplQXBwbHlBZmZpbmVUcmFuc2Zvcm06ICdjYy5BZmZpbmVUcmFuc2Zvcm0udHJhbnNmb3JtU2l6ZScsXG4gICAgICAgIHJlY3RBcHBseUFmZmluZVRyYW5zZm9ybTogJ2NjLkFmZmluZVRyYW5zZm9ybS50cmFuc2Zvcm1SZWN0JyxcbiAgICAgICAgb2JiQXBwbHlBZmZpbmVUcmFuc2Zvcm06ICdjYy5BZmZpbmVUcmFuc2Zvcm0udHJhbnNmb3JtT2JiJyxcblxuICAgICAgICAvLyBWZWMyXG4gICAgICAgIHBvaW50RXF1YWxUb1BvaW50OiAnY2MuVmVjMiBlcXVhbHMnLFxuXG4gICAgICAgIC8vIFNpemVcbiAgICAgICAgc2l6ZUVxdWFsVG9TaXplOiAnY2MuU2l6ZSBlcXVhbHMnLFxuXG4gICAgICAgIC8vIFJlY3RcbiAgICAgICAgcmVjdEVxdWFsVG9SZWN0OiAncmVjdEEuZXF1YWxzKHJlY3RCKScsXG4gICAgICAgIHJlY3RDb250YWluc1JlY3Q6ICdyZWN0QS5jb250YWluc1JlY3QocmVjdEIpJyxcbiAgICAgICAgcmVjdENvbnRhaW5zUG9pbnQ6ICdyZWN0LmNvbnRhaW5zKHZlYzIpJyxcbiAgICAgICAgcmVjdE92ZXJsYXBzUmVjdDogJ3JlY3RBLmludGVyc2VjdHMocmVjdEIpJyxcbiAgICAgICAgcmVjdEludGVyc2VjdHNSZWN0OiAncmVjdEEuaW50ZXJzZWN0cyhyZWN0QiknLFxuICAgICAgICByZWN0SW50ZXJzZWN0aW9uOiAncmVjdEEuaW50ZXJzZWN0aW9uKGludGVyc2VjdGlvbiwgcmVjdEIpJyxcbiAgICAgICAgcmVjdFVuaW9uOiAncmVjdEEudW5pb24odW5pb24sIHJlY3RCKScsXG4gICAgICAgIHJlY3RHZXRNYXhYOiAncmVjdC54TWF4JyxcbiAgICAgICAgcmVjdEdldE1pZFg6ICdyZWN0LmNlbnRlci54JyxcbiAgICAgICAgcmVjdEdldE1pblg6ICdyZWN0LnhNaW4nLFxuICAgICAgICByZWN0R2V0TWF4WTogJ3JlY3QueU1heCcsXG4gICAgICAgIHJlY3RHZXRNaWRZOiAncmVjdC5jZW50ZXIueScsXG4gICAgICAgIHJlY3RHZXRNaW5ZOiAncmVjdC55TWluJyxcblxuICAgICAgICAvLyBDb2xvclxuICAgICAgICBjb2xvckVxdWFsOiAnY29sb3JBLmVxdWFscyhjb2xvckIpJyxcbiAgICAgICAgaGV4VG9Db2xvcjogJ2NvbG9yLmZyb21IRVgoaGV4Q29sb3IpJyxcbiAgICAgICAgY29sb3JUb0hleDogJ2NvbG9yLnRvSEVYKCknLFxuXG4gICAgICAgIC8vIEVudW1zXG4gICAgICAgIFRleHRBbGlnbm1lbnQ6ICdjYy5tYWNyby5UZXh0QWxpZ25tZW50JyxcbiAgICAgICAgVmVydGljYWxUZXh0QWxpZ25tZW50OiAnY2MubWFjcm8uVmVydGljYWxUZXh0QWxpZ25tZW50JyxcblxuICAgICAgICAvLyBQb2ludCBFeHRlbnNpb25zXG4gICAgICAgIHBOZWc6ICdwLm5lZygpJyxcbiAgICAgICAgcEFkZDogJ3AxLmFkZChwMiknLFxuICAgICAgICBwU3ViOiAncDEuc3ViKHAyKScsXG4gICAgICAgIHBNdWx0OiAncC5tdWwoZmFjdG9yKScsXG4gICAgICAgIHBNaWRwb2ludDogJ3AxLmFkZChwMikubXVsKDAuNSknLFxuICAgICAgICBwRG90OiAncDEuZG90KHAyKScsXG4gICAgICAgIHBDcm9zczogJ3AxLmNyb3NzKHAyKScsXG4gICAgICAgIHBQZXJwOiAncC5yb3RhdGUoLTkwICogTWF0aC5QSSAvIDE4MCknLFxuICAgICAgICBwUlBlcnA6ICdwLnJvdGF0ZSg5MCAqIE1hdGguUEkgLyAxODApJyxcbiAgICAgICAgcFByb2plY3Q6ICdwMS5wcm9qZWN0KHAyKScsXG4gICAgICAgIHBMZW5ndGhTUTogJ3AubWFnU3FyKCknLFxuICAgICAgICBwRGlzdGFuY2VTUTogJ3AxLnN1YihwMikubWFnU3FyKCknLFxuICAgICAgICBwTGVuZ3RoOiAncC5tYWcoKScsXG4gICAgICAgIHBEaXN0YW5jZTogJ3AxLnN1YihwMikubWFnKCknLFxuICAgICAgICBwTm9ybWFsaXplOiAncC5ub3JtYWxpemUoKScsXG4gICAgICAgIHBGb3JBbmdsZTogJ2NjLnYyKE1hdGguY29zKGEpLCBNYXRoLnNpbihhKSknLFxuICAgICAgICBwVG9BbmdsZTogJ01hdGguYXRhbjIodi55LCB2LngpJyxcbiAgICAgICAgcFplcm9JbjogJ3AueCA9IHAueSA9IDAnLFxuICAgICAgICBwSW46ICdwMS5zZXQocDIpJyxcbiAgICAgICAgcE11bHRJbjogJ3AubXVsU2VsZihmYWN0b3IpJyxcbiAgICAgICAgcFN1YkluOiAncDEuc3ViU2VsZihwMiknLFxuICAgICAgICBwQWRkSW46ICdwMS5hZGRTZWxmKHAyKScsXG4gICAgICAgIHBOb3JtYWxpemVJbjogJ3Aubm9ybWFsaXplU2VsZigpJyxcbiAgICAgICAgcFNhbWVBczogJ3AxLmVxdWFscyhwMiknLFxuICAgICAgICBwQW5nbGU6ICd2MS5hbmdsZSh2MiknLFxuICAgICAgICBwQW5nbGVTaWduZWQ6ICd2MS5zaWduQW5nbGUodjIpJyxcbiAgICAgICAgcFJvdGF0ZUJ5QW5nbGU6ICdwLnJvdGF0ZShyYWRpYW5zKScsXG4gICAgICAgIHBDb21wTXVsdDogJ3YxLmRvdCh2MiknLFxuICAgICAgICBwRnV6enlFcXVhbDogJ3YxLmZ1enp5RXF1YWxzKHYyLCB0b2xlcmFuY2UpJyxcbiAgICAgICAgcExlcnA6ICdwLmxlcnAoZW5kUG9pbnQsIHJhdGlvKScsXG4gICAgICAgIHBDbGFtcDogJ3AuY2xhbXBmKG1pbl9pbmNsdXNpdmUsIG1heF9pbmNsdXNpdmUpJyxcblxuICAgICAgICByYW5kOiAnTWF0aC5yYW5kb20oKSAqIDB4ZmZmZmZmJyxcbiAgICAgICAgcmFuZG9tTWludXMxVG8xOiAnKE1hdGgucmFuZG9tKCkgLSAwLjUpICogMicsXG5cbiAgICAgICAgY29udGFpbmVyOiAnY2MuZ2FtZS5jb250YWluZXInLFxuICAgICAgICBfY2FudmFzOiAnY2MuZ2FtZS5jYW52YXMnLFxuICAgICAgICBfcmVuZGVyVHlwZTogJ2NjLmdhbWUucmVuZGVyVHlwZScsXG5cbiAgICAgICAgX2dldEVycm9yOiAnY2MuZGVidWcuZ2V0RXJyb3InLFxuICAgICAgICBfaW5pdERlYnVnU2V0dGluZzogJ2NjLmRlYnVnLl9yZXNldERlYnVnU2V0dGluZycsXG4gICAgICAgIERlYnVnTW9kZTogJ2NjLmRlYnVnLkRlYnVnTW9kZScsXG4gICAgfSwgJ2NjJyk7XG4gICAgbWFya0FzUmVtb3ZlZEluT2JqZWN0KGNjLCBbXG4gICAgICAgICdibGVuZEZ1bmNEaXNhYmxlJyxcblxuICAgICAgICAncEZyb21TaXplJyxcbiAgICAgICAgJ3BDb21wT3AnLFxuICAgICAgICAncEludGVyc2VjdFBvaW50JyxcbiAgICAgICAgJ3BTZWdtZW50SW50ZXJzZWN0JyxcbiAgICAgICAgJ3BMaW5lSW50ZXJzZWN0JyxcblxuICAgICAgICAnb2JiQXBwbHlNYXRyaXgnLFxuXG4gICAgICAgICdnZXRJbWFnZUZvcm1hdEJ5RGF0YScsXG5cbiAgICAgICAgJ2luaXRFbmdpbmUnLFxuICAgIF0sICdjYycpO1xuICAgIG1hcmtGdW5jdGlvbldhcm5pbmcoY2MsIHtcbiAgICAgICAgLy8gY2MucFxuICAgICAgICBwOiAnY2MudjInXG4gICAgfSwgJ2NjJyk7XG4gICAgLy8gY2MuUmVjdFxuICAgIHByb3ZpZGVDbGVhckVycm9yKGNjLlJlY3QsIHtcbiAgICAgICAgY29udGFpbjogJ3JlY3RBLmNvbnRhaW5zKHJlY3RCKScsXG4gICAgICAgIHRyYW5zZm9ybU1hdDQ6ICdyZWN0LnRyYW5zZm9ybU1hdDQob3V0LCBtYXQ0KSdcbiAgICB9KTtcbiAgICAvLyBjYy5Db2xvclxuICAgIHByb3ZpZGVDbGVhckVycm9yKGNjLkNvbG9yLCB7XG4gICAgICAgIHJnYjJoc3Y6ICdjb2xvci50b0hTVigpJyxcbiAgICAgICAgaHN2MnJnYjogJ2NvbG9yLmZyb21IU1YoaCwgcywgdiknXG4gICAgfSk7XG5cbiAgICAvLyBtYWNybyBmdW5jdGlvbnNcbiAgICBqcy5nZXQoY2MsICdsZXJwJywgZnVuY3Rpb24gKCkge1xuICAgICAgICBjYy5lcnJvcklEKDE0MDAsICdjYy5sZXJwJywgJ2NjLm1pc2MubGVycCcpO1xuICAgICAgICByZXR1cm4gY2MubWlzYy5sZXJwO1xuICAgIH0pO1xuICAgIGpzLmdldChjYywgJ3JhbmRvbTBUbzEnLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgIGNjLmVycm9ySUQoMTQwMCwgJ2NjLnJhbmRvbTBUbzEnLCAnTWF0aC5yYW5kb20nKTtcbiAgICAgICAgcmV0dXJuIE1hdGgucmFuZG9tO1xuICAgIH0pO1xuICAgIGpzLmdldChjYywgJ2RlZ3JlZXNUb1JhZGlhbnMnLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgIGNjLmVycm9ySUQoMTQwMCwgJ2NjLmRlZ3JlZXNUb1JhZGlhbnMnLCAnY2MubWlzYy5kZWdyZWVzVG9SYWRpYW5zJyk7XG4gICAgICAgIHJldHVybiBjYy5taXNjLmRlZ3JlZXNUb1JhZGlhbnM7XG4gICAgfSk7XG4gICAganMuZ2V0KGNjLCAncmFkaWFuc1RvRGVncmVlcycsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2MuZXJyb3JJRCgxNDAwLCAnY2MucmFkaWFuc1RvRGVncmVlcycsICdjYy5taXNjLnJhZGlhbnNUb0RlZ3JlZXMnKTtcbiAgICAgICAgcmV0dXJuIGNjLm1pc2MucmFkaWFuc1RvRGVncmVlcztcbiAgICB9KTtcbiAgICBqcy5nZXQoY2MsICdjbGFtcGYnLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgIGNjLmVycm9ySUQoMTQwMCwgJ2NjLmNsYW1wZicsICdjYy5taXNjLmNsYW1wZicpO1xuICAgICAgICByZXR1cm4gY2MubWlzYy5jbGFtcGY7XG4gICAgfSk7XG4gICAganMuZ2V0KGNjLCAnY2xhbXAwMScsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2MuZXJyb3JJRCgxNDAwLCAnY2MuY2xhbXAwMScsICdjYy5taXNjLmNsYW1wMDEnKTtcbiAgICAgICAgcmV0dXJuIGNjLm1pc2MuY2xhbXAwMTtcbiAgICB9KTtcbiAgICBqcy5nZXQoY2MsICdJbWFnZUZvcm1hdCcsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2MuZXJyb3JJRCgxNDAwLCAnY2MuSW1hZ2VGb3JtYXQnLCAnY2MubWFjcm8uSW1hZ2VGb3JtYXQnKTtcbiAgICAgICAgcmV0dXJuIGNjLm1hY3JvLkltYWdlRm9ybWF0O1xuICAgIH0pO1xuICAgIGpzLmdldChjYywgJ0tFWScsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2MuZXJyb3JJRCgxNDAwLCAnY2MuS0VZJywgJ2NjLm1hY3JvLktFWScpO1xuICAgICAgICByZXR1cm4gY2MubWFjcm8uS0VZO1xuICAgIH0pO1xuICAgIGpzLmdldChjYywgJ0Vhc2luZycsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2MuZXJyb3JJRCgxNDAwLCAnY2MuRWFzaW5nJywgJ2NjLmVhc2luZycpO1xuICAgICAgICByZXR1cm4gY2MuZWFzaW5nO1xuICAgIH0pO1xuXG4gICAgLy8gY2MuaXNDaGlsZENsYXNzT2ZcbiAgICBqcy5nZXQoY2MsICdpc0NoaWxkQ2xhc3NPZicsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgY2MuZXJyb3JJRCgxNDAwLCAnY2MuaXNDaGlsZENsYXNzT2YnLCAnY2MuanMuaXNDaGlsZENsYXNzT2YnKTtcbiAgICAgICAgcmV0dXJuIGNjLmpzLmlzQ2hpbGRDbGFzc09mO1xuICAgIH0pO1xuXG4gICAgLy8gZHJhZ29uIGJvbmVzXG4gICAgaWYgKHR5cGVvZiBkcmFnb25Cb25lcyAhPT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgICAganMuZ2V0KGRyYWdvbkJvbmVzLkNDRmFjdG9yeSwgJ2dldEZhY3RvcnknLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICBjYy5lcnJvcklEKDE0MDAsICdkcmFnb25Cb25lcy5DQ0ZhY3RvcnkuZ2V0RmFjdG9yeScsICdkcmFnb25Cb25lcy5DQ0ZhY3RvcnkuZ2V0SW5zdGFuY2UnKTtcbiAgICAgICAgICAgIHJldHVybiBkcmFnb25Cb25lcy5DQ0ZhY3RvcnkuZ2V0SW5zdGFuY2U7XG4gICAgICAgIH0pO1xuICAgIH1cblxuICAgIC8vIHJlbmRlckVuZ2luZVxuICAgIGNjLnJlbmRlcmVyLnJlbmRlckVuZ2luZSA9IHtcbiAgICAgICAgZ2V0IGdmeCAoKSB7XG4gICAgICAgICAgICBjYy53YXJuSUQoMTQwMCwgJ2NjLnJlbmRlcmVyLnJlbmRlckVuZ2luZS5nZngnLCAnY2MuZ2Z4Jyk7XG4gICAgICAgICAgICByZXR1cm4gY2MuZ2Z4O1xuICAgICAgICB9LFxuICAgICAgICBnZXQgbWF0aCAoKSB7XG4gICAgICAgICAgICBjYy53YXJuSUQoMTQwMCwgJ2NjLnJlbmRlcmVyLnJlbmRlckVuZ2luZS5tYXRoJywgJ2NjLm1hdGgnKTtcbiAgICAgICAgICAgIHJldHVybiBjYy52bWF0aDtcbiAgICAgICAgfSxcbiAgICAgICAgZ2V0IElucHV0QXNzZW1ibGVyICgpIHtcbiAgICAgICAgICAgIGNjLndhcm5JRCgxNDAwLCAnY2MucmVuZGVyZXIucmVuZGVyRW5naW5lLklucHV0QXNzZW1ibGVyJywgJ2NjLnJlbmRlcmVyLklucHV0QXNzZW1ibGVyJyk7XG4gICAgICAgICAgICByZXR1cm4gY2MucmVuZGVyZXIuSW5wdXRBc3NlbWJsZXI7XG4gICAgICAgIH1cbiAgICB9O1xuICAgIFxufVxuIl0sInNvdXJjZVJvb3QiOiIvIn0=