
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/utils/trans-pool/unit-base.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2019 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
// Unit has many segment, layout such as :
// Head Free Pointer + Using Segment Num + Segment 1 + Segment 2 + Segment 3 ...
// sign data format
// Space : [If Free Flag]                          [Size:1 Uint16]
// Space : [Next Free Index]                       [Size:1 Uint16]
// invalid pointer value
var POINTER_INVALID_FLAG = 0xffff;
var SPACE_FREE_FLAG = 0x0;
var SPACE_USE_FLAG = 0x1;
var POS_NEXT_FREE = 0;
var POS_FREE_FLAG = 1;

var UnitBase = function UnitBase(unitID, memPool, contentNum) {
  contentNum = contentNum || 128; // set unit id

  this.unitID = unitID;
  this._memPool = memPool;
  this._data = new Uint16Array(2); // head of the free content index

  this._data[0] = 0; // using segment num

  this._data[1] = 0;
  this._contentNum = contentNum;
  this._signData = new Uint16Array(this._contentNum * 2);
  this._spacesData = [];

  for (var i = 0; i < contentNum; i++) {
    var signIndex = i * 2; // store content block index but not sign array index

    this._signData[signIndex + POS_NEXT_FREE] = i + 1;
    this._signData[signIndex + POS_FREE_FLAG] = SPACE_FREE_FLAG;
    this._spacesData[i] = {
      index: i,
      unitID: unitID
    };
  } // last one has no next space;


  this._signData[(contentNum - 1) * 2] = POINTER_INVALID_FLAG;
};

var UnitBaseProto = UnitBase.prototype;

UnitBaseProto.hasSpace = function () {
  return this._data[0] !== POINTER_INVALID_FLAG;
};

UnitBaseProto.isAllFree = function () {
  return this._data[1] == 0;
}; // pop space from unit


UnitBaseProto.pop = function () {
  var headFreeIndex = this._data[0];
  if (headFreeIndex === POINTER_INVALID_FLAG) return null;
  var index = headFreeIndex;
  var signIndex = index * 2;
  var space = this._spacesData[index]; // set use flag

  this._signData[signIndex + POS_FREE_FLAG] = SPACE_USE_FLAG; // store new next free space index

  this._data[0] = this._signData[signIndex + POS_NEXT_FREE]; // add using segment num

  this._data[1]++;
  return space;
}; // push back to unit


UnitBaseProto.push = function (index) {
  var signIndex = index * 2; // set free flag

  this._signData[signIndex + POS_FREE_FLAG] = SPACE_FREE_FLAG; // store head free index to the space

  this._signData[signIndex + POS_NEXT_FREE] = this._data[0]; // update head free index

  this._data[0] = index; // sub using segment num

  this._data[1]--;
}; // dump all space info


UnitBaseProto.dump = function () {
  var spaceNum = 0;
  var index = this._data[0];
  var freeStr = "";

  while (index != POINTER_INVALID_FLAG) {
    spaceNum++;
    freeStr += index + "->";
    index = this._signData[index * 2 + POS_NEXT_FREE];
  }

  var usingNum = 0;
  var usingStr = "";
  var contentNum = this._contentNum;

  for (var i = 0; i < contentNum; i++) {
    var freeFlag = this._signData[i * 2 + POS_FREE_FLAG];

    if (freeFlag == SPACE_USE_FLAG) {
      usingNum++;
      usingStr += i + "->";
    }
  }

  var totalNum = spaceNum + usingNum;
  console.log("unitID:", this.unitID, "spaceNum:", spaceNum, "calc using num:", usingNum, 'store using num:', this._data[1], 'calc total num:', totalNum, 'actually total num:', this._contentNum);
  console.log("free info:", freeStr);
  console.log("using info:", usingStr);

  if (usingNum != this._data[1]) {
    cc.error('using num error', "calc using num:", usingNum, 'store using num:', this._data[1]);
  }

  if (spaceNum + usingNum != this._contentNum) {
    cc.error('total num error', 'calc total num:', totalNum, 'actually total num:', this._contentNum);
  }
};

module.exports = UnitBase;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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