
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/utils/trans-pool/node-unit.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var _utils = require("../../value-types/utils");

/****************************************************************************
 Copyright (c) 2019 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Uint32_Bytes = 4;
var Uint8_Bytes = 1; // Space : [Dirty]                                  [Size:4 Uint32]

var Dirty_Type = Uint32Array;
var Dirty_Members = 1;
var Dirty_Stride = Dirty_Members * Uint32_Bytes; // Space : [TRS]                                    [Size:4 * 10 Float32|Float64]

var TRS_Members = 10;
var TRS_Stride = TRS_Members * _utils.FLOAT_BYTES; // Space : [LocalMatrix]                            [Size:4 * 16 Float32|Float64]

var LocalMatrix_Members = 16;
var LocalMatrix_Stride = LocalMatrix_Members * _utils.FLOAT_BYTES; // Space : [WorldMatrix]                            [Size:4 * 16 Float32|Float64]

var WorldMatrix_Members = 16;
var WorldMatrix_Stride = WorldMatrix_Members * _utils.FLOAT_BYTES; // Space : [Parent Unit]                            [Size:4 Uint32]
// Space : [Parent Index]                           [Size:4 Uint32]

var Parent_Type = Uint32Array;
var Parent_Members = 2;
var Parent_Stride = Parent_Members * Uint32_Bytes; // Space : [ZOrder]                                 [Size:4 Uint32]

var ZOrder_Type = Uint32Array;
var ZOrder_Members = 1;
var ZOrder_Stride = ZOrder_Members * Uint32_Bytes; // Space : [CullingMask]                            [Size:4 Int32]

var CullingMask_Type = Int32Array;
var CullingMask_Members = 1;
var CullingMask_Stride = CullingMask_Members * Uint32_Bytes; // Space : [Opacity]                                [Size:1 Uint8]

var Opacity_Type = Uint8Array;
var Opacity_Members = 1;
var Opacity_Stride = Opacity_Members * Uint8_Bytes; // Space : [Is3D]                                   [Size:1 Uint8]

var Is3D_Type = Uint8Array;
var Is3D_Members = 1;
var Is3D_Stride = Is3D_Members * Uint8_Bytes; // Space : [NodePtr]                                [Size:4 * 2 Uint32]

var Node_Type = Uint32Array;
var Node_Members = 2; // Space : [Skew]                                   [Size:4 * 2 Float32]

var Skew_Members = 2;
var Skew_Stride = Skew_Members * _utils.FLOAT_BYTES;

var UnitBase = require('./unit-base');

var NodeUnit = function NodeUnit(unitID, memPool) {
  UnitBase.call(this, unitID, memPool);
  var contentNum = this._contentNum;
  this.trsList = new _utils.FLOAT_ARRAY_TYPE(contentNum * TRS_Members);
  this.localMatList = new _utils.FLOAT_ARRAY_TYPE(contentNum * LocalMatrix_Members);
  this.worldMatList = new _utils.FLOAT_ARRAY_TYPE(contentNum * WorldMatrix_Members);

  if (CC_JSB && CC_NATIVERENDERER) {
    this.dirtyList = new Dirty_Type(contentNum * Dirty_Members);
    this.parentList = new Parent_Type(contentNum * Parent_Members);
    this.zOrderList = new ZOrder_Type(contentNum * ZOrder_Members);
    this.cullingMaskList = new CullingMask_Type(contentNum * CullingMask_Members);
    this.opacityList = new Opacity_Type(contentNum * Opacity_Members);
    this.is3DList = new Is3D_Type(contentNum * Is3D_Members);
    this.nodeList = new Node_Type(contentNum * Node_Members);
    this.skewList = new _utils.FLOAT_ARRAY_TYPE(contentNum * Skew_Members);

    this._memPool._nativeMemPool.updateNodeData(unitID, this.dirtyList, this.trsList, this.localMatList, this.worldMatList, this.parentList, this.zOrderList, this.cullingMaskList, this.opacityList, this.is3DList, this.nodeList, this.skewList);
  }

  for (var i = 0; i < contentNum; i++) {
    var space = this._spacesData[i];
    space.trs = new _utils.FLOAT_ARRAY_TYPE(this.trsList.buffer, i * TRS_Stride, TRS_Members);
    space.localMat = new _utils.FLOAT_ARRAY_TYPE(this.localMatList.buffer, i * LocalMatrix_Stride, LocalMatrix_Members);
    space.worldMat = new _utils.FLOAT_ARRAY_TYPE(this.worldMatList.buffer, i * WorldMatrix_Stride, WorldMatrix_Members);

    if (CC_JSB && CC_NATIVERENDERER) {
      space.dirty = new Dirty_Type(this.dirtyList.buffer, i * Dirty_Stride, Dirty_Members);
      space.parent = new Parent_Type(this.parentList.buffer, i * Parent_Stride, Parent_Members);
      space.zOrder = new ZOrder_Type(this.zOrderList.buffer, i * ZOrder_Stride, ZOrder_Members);
      space.cullingMask = new CullingMask_Type(this.cullingMaskList.buffer, i * CullingMask_Stride, CullingMask_Members);
      space.opacity = new Opacity_Type(this.opacityList.buffer, i * Opacity_Stride, Opacity_Members);
      space.is3D = new Is3D_Type(this.is3DList.buffer, i * Is3D_Stride, Is3D_Members);
      space.skew = new _utils.FLOAT_ARRAY_TYPE(this.skewList.buffer, i * Skew_Stride, Skew_Members);
    }
  }
};

(function () {
  var Super = function Super() {};

  Super.prototype = UnitBase.prototype;
  NodeUnit.prototype = new Super();
})();

module.exports = NodeUnit;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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