
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/utils/text-utils.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var _js = _interopRequireDefault(require("../platform/js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
// Draw text the textBaseline ratio (Can adjust the appropriate baseline ratio based on the platform)
var _BASELINE_RATIO = 0.26;
var _BASELINE_OFFSET = 0;

if (CC_RUNTIME) {
  _BASELINE_OFFSET = _BASELINE_RATIO / 2;
}

var MAX_CACHE_SIZE = 100;
var pool = new _js["default"].Pool(2);

pool.get = function () {
  var node = this._get() || {
    key: null,
    value: null,
    prev: null,
    next: null
  };
  return node;
};

function LRUCache(size) {
  this.count = 0;
  this.limit = size;
  this.datas = {};
  this.head = null;
  this.tail = null;
}

LRUCache.prototype.moveToHead = function (node) {
  node.next = this.head;
  node.prev = null;
  if (this.head !== null) this.head.prev = node;
  this.head = node;
  if (this.tail === null) this.tail = node;
  this.count++;
  this.datas[node.key] = node;
};

LRUCache.prototype.put = function (key, value) {
  var node = pool.get();
  node.key = key;
  node.value = value;

  if (this.count >= this.limit) {
    var discard = this.tail;
    delete this.datas[discard.key];
    this.count--;
    this.tail = discard.prev;
    this.tail.next = null;
    discard.prev = null;
    discard.next = null;
    pool.put(discard);
  }

  this.moveToHead(node);
};

LRUCache.prototype.remove = function (node) {
  if (node.prev !== null) {
    node.prev.next = node.next;
  } else {
    this.head = node.next;
  }

  if (node.next !== null) {
    node.next.prev = node.prev;
  } else {
    this.tail = node.prev;
  }

  delete this.datas[node.key];
  this.count--;
};

LRUCache.prototype.get = function (key) {
  var node = this.datas[key];

  if (node) {
    this.remove(node);
    this.moveToHead(node);
    return node.value;
  }

  return null;
};

LRUCache.prototype.clear = function () {
  this.count = 0;
  this.datas = {};
  this.head = null;
  this.tail = null;
};

LRUCache.prototype.has = function (key) {
  return !!this.datas[key];
};

LRUCache.prototype["delete"] = function (key) {
  var node = this.datas[key];
  this.remove(node);
};

var measureCache = new LRUCache(MAX_CACHE_SIZE);
var textUtils = {
  BASELINE_RATIO: _BASELINE_RATIO,
  MIDDLE_RATIO: (_BASELINE_RATIO + 1) / 2 - _BASELINE_RATIO,
  BASELINE_OFFSET: _BASELINE_OFFSET,
  label_wordRex: /([a-zA-Z0-9ÄÖÜäöüßéèçàùêâîôûа-яА-ЯЁё]+|\S)/,
  label_symbolRex: /^[!,.:;'}\]%\?>、‘“》？。，！]/,
  label_lastWordRex: /([a-zA-Z0-9ÄÖÜäöüßéèçàùêâîôûаíìÍÌïÁÀáàÉÈÒÓòóŐőÙÚŰúűñÑæÆœŒÃÂãÔõěščřžýáíéóúůťďňĚŠČŘŽÁÍÉÓÚŤżźśóńłęćąŻŹŚÓŃŁĘĆĄ-яА-ЯЁё]+|\S)$/,
  label_lastEnglish: /[a-zA-Z0-9ÄÖÜäöüßéèçàùêâîôûаíìÍÌïÁÀáàÉÈÒÓòóŐőÙÚŰúűñÑæÆœŒÃÂãÔõěščřžýáíéóúůťďňĚŠČŘŽÁÍÉÓÚŤżźśóńłęćąŻŹŚÓŃŁĘĆĄ-яА-ЯЁё]+$/,
  label_firstEnglish: /^[a-zA-Z0-9ÄÖÜäöüßéèçàùêâîôûаíìÍÌïÁÀáàÉÈÒÓòóŐőÙÚŰúűñÑæÆœŒÃÂãÔõěščřžýáíéóúůťďňĚŠČŘŽÁÍÉÓÚŤżźśóńłęćąŻŹŚÓŃŁĘĆĄ-яА-ЯЁё]/,
  // The unicode standard will never assign a character from code point 0xD800 to 0xDFFF
  // high surrogate (0xD800-0xDBFF) and low surrogate(0xDC00-0xDFFF) combines to a character on the Supplementary Multilingual Plane
  // reference: https://en.wikipedia.org/wiki/UTF-16
  highSurrogateRex: /[\uD800-\uDBFF]/,
  lowSurrogateRex: /[\uDC00-\uDFFF]/,
  label_wrapinspection: true,
  __CHINESE_REG: /^[\u4E00-\u9FFF\u3400-\u4DFF]+$/,
  __JAPANESE_REG: /[\u3000-\u303F]|[\u3040-\u309F]|[\u30A0-\u30FF]|[\uFF00-\uFFEF]|[\u4E00-\u9FAF]|[\u2605-\u2606]|[\u2190-\u2195]|\u203B/g,
  __KOREAN_REG: /^[\u1100-\u11FF]|[\u3130-\u318F]|[\uA960-\uA97F]|[\uAC00-\uD7AF]|[\uD7B0-\uD7FF]+$/,
  isUnicodeCJK: function isUnicodeCJK(ch) {
    return this.__CHINESE_REG.test(ch) || this.__JAPANESE_REG.test(ch) || this.__KOREAN_REG.test(ch);
  },
  //Checking whether the character is a whitespace
  isUnicodeSpace: function isUnicodeSpace(ch) {
    ch = ch.charCodeAt(0);
    return ch >= 9 && ch <= 13 || ch === 32 || ch === 133 || ch === 160 || ch === 5760 || ch >= 8192 && ch <= 8202 || ch === 8232 || ch === 8233 || ch === 8239 || ch === 8287 || ch === 12288;
  },
  safeMeasureText: function safeMeasureText(ctx, string, desc) {
    var font = desc || ctx.font;
    var key = font + "\uD83C\uDFAE" + string;
    var cache = measureCache.get(key);

    if (cache !== null) {
      return cache;
    }

    var metric = ctx.measureText(string);
    var width = metric && metric.width || 0;
    measureCache.put(key, width);
    return width;
  },
  // in case truncate a character on the Supplementary Multilingual Plane
  // test case: a = '😉🚗'
  // _safeSubstring(a, 1) === '😉🚗'
  // _safeSubstring(a, 0, 1) === '😉'
  // _safeSubstring(a, 0, 2) === '😉'
  // _safeSubstring(a, 0, 3) === '😉'
  // _safeSubstring(a, 0, 4) === '😉🚗'
  // _safeSubstring(a, 1, 2) === _safeSubstring(a, 1, 3) === '😉'
  // _safeSubstring(a, 2, 3) === _safeSubstring(a, 2, 4) === '🚗'
  _safeSubstring: function _safeSubstring(targetString, startIndex, endIndex) {
    var newStartIndex = startIndex,
        newEndIndex = endIndex;
    var startChar = targetString[startIndex];

    if (this.lowSurrogateRex.test(startChar)) {
      newStartIndex--;
    }

    if (endIndex !== undefined) {
      if (endIndex - 1 !== startIndex) {
        var endChar = targetString[endIndex - 1];

        if (this.highSurrogateRex.test(endChar)) {
          newEndIndex--;
        }
      } else if (this.highSurrogateRex.test(startChar)) {
        newEndIndex++;
      }
    }

    return targetString.substring(newStartIndex, newEndIndex);
  },
  fragmentText: function fragmentText(stringToken, allWidth, maxWidth, measureText) {
    //check the first character
    var wrappedWords = []; //fast return if strArr is empty

    if (stringToken.length === 0 || maxWidth < 0) {
      wrappedWords.push('');
      return wrappedWords;
    }

    var text = stringToken;

    while (allWidth > maxWidth && text.length > 1) {
      var fuzzyLen = text.length * (maxWidth / allWidth) | 0;

      var tmpText = this._safeSubstring(text, fuzzyLen);

      var width = allWidth - measureText(tmpText);
      var sLine = tmpText;
      var pushNum = 0;
      var checkWhile = 0;
      var checkCount = 10; //Exceeded the size

      while (width > maxWidth && checkWhile++ < checkCount) {
        fuzzyLen *= maxWidth / width;
        fuzzyLen = fuzzyLen | 0;
        tmpText = this._safeSubstring(text, fuzzyLen);
        width = allWidth - measureText(tmpText);
      }

      checkWhile = 0; //Find the truncation point

      while (width <= maxWidth && checkWhile++ < checkCount) {
        if (tmpText) {
          var exec = this.label_wordRex.exec(tmpText);
          pushNum = exec ? exec[0].length : 1;
          sLine = tmpText;
        }

        fuzzyLen = fuzzyLen + pushNum;
        tmpText = this._safeSubstring(text, fuzzyLen);
        width = allWidth - measureText(tmpText);
      }

      fuzzyLen -= pushNum; // in case maxWidth cannot contain any characters, need at least one character per line

      if (fuzzyLen === 0) {
        fuzzyLen = 1;
        sLine = this._safeSubstring(text, 1);
      } else if (fuzzyLen === 1 && this.highSurrogateRex.test(text[0])) {
        fuzzyLen = 2;
        sLine = this._safeSubstring(text, 2);
      }

      var sText = this._safeSubstring(text, 0, fuzzyLen),
          result; //symbol in the first


      if (this.label_wrapinspection) {
        if (this.label_symbolRex.test(sLine || tmpText)) {
          result = this.label_lastWordRex.exec(sText);
          fuzzyLen -= result ? result[0].length : 0;
          if (fuzzyLen === 0) fuzzyLen = 1;
          sLine = this._safeSubstring(text, fuzzyLen);
          sText = this._safeSubstring(text, 0, fuzzyLen);
        }
      } //To judge whether a English words are truncated


      if (this.label_firstEnglish.test(sLine)) {
        result = this.label_lastEnglish.exec(sText);

        if (result && sText !== result[0]) {
          fuzzyLen -= result[0].length;
          sLine = this._safeSubstring(text, fuzzyLen);
          sText = this._safeSubstring(text, 0, fuzzyLen);
        }
      } // The first line And do not wrap should not remove the space


      if (wrappedWords.length === 0) {
        wrappedWords.push(sText);
      } else {
        sText = sText.trimLeft();

        if (sText.length > 0) {
          wrappedWords.push(sText);
        }
      }

      text = sLine || tmpText;
      allWidth = measureText(text);
    }

    if (wrappedWords.length === 0) {
      wrappedWords.push(text);
    } else {
      text = text.trimLeft();

      if (text.length > 0) {
        wrappedWords.push(text);
      }
    }

    return wrappedWords;
  }
};
cc.textUtils = module.exports = textUtils;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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