
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/utils/profiler/CCProfiler.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
  worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
  not use Cocos Creator software for developing other software or tools that's
  used for developing games. You are not granted to publish, distribute,
  sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var macro = require('../../platform/CCMacro');

var PerfCounter = require('./perf-counter');

var _showFPS = false;
var _fontSize = 15;
var _stats = null;
var _rootNode = null;
var _label = null;

function generateStats() {
  if (_stats) return;
  _stats = {
    frame: {
      desc: 'Frame time (ms)',
      min: 0,
      max: 50,
      average: 500
    },
    fps: {
      desc: 'Framerate (FPS)',
      below: 30,
      average: 500
    },
    draws: {
      desc: 'Draw call'
    },
    logic: {
      desc: 'Game Logic (ms)',
      min: 0,
      max: 50,
      average: 500,
      color: '#080'
    },
    render: {
      desc: 'Renderer (ms)',
      min: 0,
      max: 50,
      average: 500,
      color: '#f90'
    },
    mode: {
      desc: cc.game.renderType === cc.game.RENDER_TYPE_WEBGL ? 'WebGL' : 'Canvas',
      min: 1
    }
  };
  var now = performance.now();

  for (var id in _stats) {
    _stats[id]._counter = new PerfCounter(id, _stats[id], now);
  }
}

function generateNode() {
  if (_rootNode && _rootNode.isValid) return;
  _rootNode = new cc.Node('PROFILER-NODE');
  _rootNode.x = _rootNode.y = 10;
  _rootNode.groupIndex = cc.Node.BuiltinGroupIndex.DEBUG;

  cc.Camera._setupDebugCamera();

  _rootNode.zIndex = macro.MAX_ZINDEX;
  cc.game.addPersistRootNode(_rootNode);
  var left = new cc.Node('LEFT-PANEL');
  left.anchorX = left.anchorY = 0;
  var leftLabel = left.addComponent(cc.Label);
  leftLabel.fontSize = _fontSize;
  leftLabel.lineHeight = _fontSize;
  left.parent = _rootNode;
  var right = new cc.Node('RIGHT-PANEL');
  right.anchorX = 1;
  right.anchorY = 0;
  right.x = 200;
  var rightLabel = right.addComponent(cc.Label);
  rightLabel.horizontalAlign = cc.Label.HorizontalAlign.RIGHT;
  rightLabel.fontSize = _fontSize;
  rightLabel.lineHeight = _fontSize;
  right.parent = _rootNode;

  if (cc.sys.browserType !== cc.sys.BROWSER_TYPE_BAIDU_GAME_SUB && cc.sys.browserType !== cc.sys.BROWSER_TYPE_WECHAT_GAME_SUB) {
    leftLabel.cacheMode = cc.Label.CacheMode.CHAR;
    rightLabel.cacheMode = cc.Label.CacheMode.CHAR;
  }

  _label = {
    left: leftLabel,
    right: rightLabel
  };
}

function beforeUpdate() {
  generateNode();
  var now = cc.director._lastUpdate;

  _stats['frame']._counter.start(now);

  _stats['logic']._counter.start(now);
}

function afterUpdate() {
  var now = performance.now();

  if (cc.director.isPaused()) {
    _stats['frame']._counter.start(now);
  } else {
    _stats['logic']._counter.end(now);
  }

  _stats['render']._counter.start(now);
}

function updateLabel(stat) {
  var length = 20;
  var desc = stat.desc;
  var value = stat._counter.human() + '';
  stat.label.string = stat.desc + '  ' + stat._counter.human();
}

function afterDraw() {
  var now = performance.now();

  _stats['render']._counter.end(now);

  _stats['draws']._counter.value = cc.renderer.drawCalls;

  _stats['frame']._counter.end(now);

  _stats['fps']._counter.frame(now);

  var left = '';
  var right = '';

  for (var id in _stats) {
    var stat = _stats[id];

    stat._counter.sample(now);

    left += stat.desc + '\n';
    right += stat._counter.human() + '\n';
  }

  if (_label) {
    _label.left.string = left;
    _label.right.string = right;
  }
}

cc.profiler = module.exports = {
  isShowingStats: function isShowingStats() {
    return _showFPS;
  },
  hideStats: function hideStats() {
    if (_showFPS) {
      if (_rootNode) {
        _rootNode.active = false;
      }

      cc.director.off(cc.Director.EVENT_BEFORE_UPDATE, beforeUpdate);
      cc.director.off(cc.Director.EVENT_AFTER_UPDATE, afterUpdate);
      cc.director.off(cc.Director.EVENT_AFTER_DRAW, afterDraw);
      _showFPS = false;
    }
  },
  showStats: function showStats() {
    if (!_showFPS) {
      generateStats();

      if (_rootNode) {
        _rootNode.active = true;
      }

      cc.director.on(cc.Director.EVENT_BEFORE_UPDATE, beforeUpdate);
      cc.director.on(cc.Director.EVENT_AFTER_UPDATE, afterUpdate);
      cc.director.on(cc.Director.EVENT_AFTER_DRAW, afterDraw);
      _showFPS = true;
    }
  }
};
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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