
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/utils/html-text-parser.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var eventRegx = /^(click)(\s)*=|(param)(\s)*=/;
var imageAttrReg = /(\s)*src(\s)*=|(\s)*height(\s)*=|(\s)*width(\s)*=|(\s)*align(\s)*=|(\s)*offset(\s)*=|(\s)*click(\s)*=|(\s)*param(\s)*=/;
/**
 * A utils class for parsing HTML texts. The parsed results will be an object array.
 */

var HtmlTextParser = function HtmlTextParser() {
  this._parsedObject = {};
  this._specialSymbolArray = [];

  this._specialSymbolArray.push([/&lt;/g, '<']);

  this._specialSymbolArray.push([/&gt;/g, '>']);

  this._specialSymbolArray.push([/&amp;/g, '&']);

  this._specialSymbolArray.push([/&quot;/g, '"']);

  this._specialSymbolArray.push([/&apos;/g, '\'']);

  this._specialSymbolArray.push([/&nbsp;/g, ' ']);
};

HtmlTextParser.prototype = {
  constructor: HtmlTextParser,
  parse: function parse(htmlString) {
    this._resultObjectArray = [];
    this._stack = [];
    var startIndex = 0;
    var length = htmlString.length;

    while (startIndex < length) {
      var tagEndIndex = htmlString.indexOf('>', startIndex);
      var tagBeginIndex = -1;

      if (tagEndIndex >= 0) {
        tagBeginIndex = htmlString.lastIndexOf('<', tagEndIndex);
        var noTagBegin = tagBeginIndex < startIndex - 1;

        if (noTagBegin) {
          tagBeginIndex = htmlString.indexOf('<', tagEndIndex + 1);
          tagEndIndex = htmlString.indexOf('>', tagBeginIndex + 1);
        }
      }

      if (tagBeginIndex < 0) {
        this._stack.pop();

        this._processResult(htmlString.substring(startIndex));

        startIndex = length;
      } else {
        var newStr = htmlString.substring(startIndex, tagBeginIndex);
        var tagStr = htmlString.substring(tagBeginIndex + 1, tagEndIndex);
        if (tagStr === "") newStr = htmlString.substring(startIndex, tagEndIndex + 1);

        this._processResult(newStr);

        if (tagEndIndex === -1) {
          // cc.error('The HTML tag is invalid!');
          tagEndIndex = tagBeginIndex;
        } else if (htmlString.charAt(tagBeginIndex + 1) === '\/') {
          this._stack.pop();
        } else {
          this._addToStack(tagStr);
        }

        startIndex = tagEndIndex + 1;
      }
    }

    return this._resultObjectArray;
  },
  _attributeToObject: function _attributeToObject(attribute) {
    attribute = attribute.trim();
    var obj = {};
    var header = attribute.match(/^(color|size)(\s)*=/);
    var tagName;
    var nextSpace;
    var eventObj;
    var eventHanlderString;

    if (header) {
      tagName = header[0];
      attribute = attribute.substring(tagName.length).trim();
      if (attribute === "") return obj; //parse color

      nextSpace = attribute.indexOf(' ');

      switch (tagName[0]) {
        case 'c':
          if (nextSpace > -1) {
            obj.color = attribute.substring(0, nextSpace).trim();
          } else {
            obj.color = attribute;
          }

          break;

        case 's':
          obj.size = parseInt(attribute);
          break;
      } //tag has event arguments


      if (nextSpace > -1) {
        eventHanlderString = attribute.substring(nextSpace + 1).trim();
        eventObj = this._processEventHandler(eventHanlderString);
        obj.event = eventObj;
      }

      return obj;
    }

    header = attribute.match(/^(br(\s)*\/)/);

    if (header && header[0].length > 0) {
      tagName = header[0].trim();

      if (tagName.startsWith("br") && tagName[tagName.length - 1] === "/") {
        obj.isNewLine = true;

        this._resultObjectArray.push({
          text: "",
          style: {
            newline: true
          }
        });

        return obj;
      }
    }

    header = attribute.match(/^(img(\s)*src(\s)*=[^>]+\/)/);

    if (header && header[0].length > 0) {
      tagName = header[0].trim();

      if (tagName.startsWith("img") && tagName[tagName.length - 1] === "/") {
        header = attribute.match(imageAttrReg);
        var tagValue;
        var remainingArgument;
        var isValidImageTag = false;

        while (header) {
          //skip the invalid tags at first
          attribute = attribute.substring(attribute.indexOf(header[0]));
          tagName = attribute.substr(0, header[0].length); //remove space and = character

          remainingArgument = attribute.substring(tagName.length).trim();
          nextSpace = remainingArgument.indexOf(' ');
          tagValue = nextSpace > -1 ? remainingArgument.substr(0, nextSpace) : remainingArgument;
          tagName = tagName.replace(/[^a-zA-Z]/g, "").trim();
          tagName = tagName.toLocaleLowerCase();
          attribute = remainingArgument.substring(nextSpace).trim();
          if (tagValue.endsWith('\/')) tagValue = tagValue.slice(0, -1);

          if (tagName === "src") {
            switch (tagValue.charCodeAt(0)) {
              case 34: // "

              case 39:
                // '
                isValidImageTag = true;
                tagValue = tagValue.slice(1, -1);
                break;
            }

            obj.isImage = true;
            obj.src = tagValue;
          } else if (tagName === "height") {
            obj.imageHeight = parseInt(tagValue);
          } else if (tagName === "width") {
            obj.imageWidth = parseInt(tagValue);
          } else if (tagName === "align") {
            switch (tagValue.charCodeAt(0)) {
              case 34: // "

              case 39:
                // '
                tagValue = tagValue.slice(1, -1);
                break;
            }

            obj.imageAlign = tagValue.toLocaleLowerCase();
          } else if (tagName === "offset") {
            obj.imageOffset = tagValue;
          } else if (tagName === "click") {
            obj.event = this._processEventHandler(tagName + "=" + tagValue);
          }

          if (obj.event && tagName === 'param') {
            obj.event.param = tagValue.replace(/^\"|\"$/g, '');
          }

          header = attribute.match(imageAttrReg);
        }

        if (isValidImageTag && obj.isImage) {
          this._resultObjectArray.push({
            text: "",
            style: obj
          });
        }

        return {};
      }
    }

    header = attribute.match(/^(outline(\s)*[^>]*)/);

    if (header) {
      attribute = header[0].substring("outline".length).trim();
      var defaultOutlineObject = {
        color: "#ffffff",
        width: 1
      };

      if (attribute) {
        var outlineAttrReg = /(\s)*color(\s)*=|(\s)*width(\s)*=|(\s)*click(\s)*=|(\s)*param(\s)*=/;
        header = attribute.match(outlineAttrReg);
        var tagValue;

        while (header) {
          //skip the invalid tags at first
          attribute = attribute.substring(attribute.indexOf(header[0]));
          tagName = attribute.substr(0, header[0].length); //remove space and = character

          remainingArgument = attribute.substring(tagName.length).trim();
          nextSpace = remainingArgument.indexOf(' ');

          if (nextSpace > -1) {
            tagValue = remainingArgument.substr(0, nextSpace);
          } else {
            tagValue = remainingArgument;
          }

          tagName = tagName.replace(/[^a-zA-Z]/g, "").trim();
          tagName = tagName.toLocaleLowerCase();
          attribute = remainingArgument.substring(nextSpace).trim();

          if (tagName === "click") {
            obj.event = this._processEventHandler(tagName + "=" + tagValue);
          } else if (tagName === "color") {
            defaultOutlineObject.color = tagValue;
          } else if (tagName === "width") {
            defaultOutlineObject.width = parseInt(tagValue);
          }

          if (obj.event && tagName === 'param') {
            obj.event.param = tagValue.replace(/^\"|\"$/g, '');
          }

          header = attribute.match(outlineAttrReg);
        }
      }

      obj.outline = defaultOutlineObject;
    }

    header = attribute.match(/^(on|u|b|i)(\s)*/);

    if (header && header[0].length > 0) {
      tagName = header[0];
      attribute = attribute.substring(tagName.length).trim();

      switch (tagName[0]) {
        case 'u':
          obj.underline = true;
          break;

        case 'i':
          obj.italic = true;
          break;

        case 'b':
          obj.bold = true;
          break;
      }

      if (attribute === "") {
        return obj;
      }

      eventObj = this._processEventHandler(attribute);
      obj.event = eventObj;
    }

    return obj;
  },
  _processEventHandler: function _processEventHandler(eventString) {
    var index = 0;
    var obj = {};
    var eventNames = eventString.match(eventRegx);
    var isValidTag = false;

    while (eventNames) {
      var eventName = eventNames[0];
      var eventValue = "";
      isValidTag = false;
      eventString = eventString.substring(eventName.length).trim();

      if (eventString.charAt(0) === "\"") {
        index = eventString.indexOf("\"", 1);

        if (index > -1) {
          eventValue = eventString.substring(1, index).trim();
          isValidTag = true;
        }

        index++;
      } else if (eventString.charAt(0) === "\'") {
        index = eventString.indexOf('\'', 1);

        if (index > -1) {
          eventValue = eventString.substring(1, index).trim();
          isValidTag = true;
        }

        index++;
      } else {
        //skip the invalid attribute value
        var match = eventString.match(/(\S)+/);

        if (match) {
          eventValue = match[0];
        } else {
          eventValue = "";
        }

        index = eventValue.length;
      }

      if (isValidTag) {
        eventName = eventName.substring(0, eventName.length - 1).trim();
        obj[eventName] = eventValue;
      }

      eventString = eventString.substring(index).trim();
      eventNames = eventString.match(eventRegx);
    }

    return obj;
  },
  _addToStack: function _addToStack(attribute) {
    var obj = this._attributeToObject(attribute);

    if (this._stack.length === 0) {
      this._stack.push(obj);
    } else {
      if (obj.isNewLine || obj.isImage) {
        return;
      } //for nested tags


      var previousTagObj = this._stack[this._stack.length - 1];

      for (var key in previousTagObj) {
        if (!obj[key]) {
          obj[key] = previousTagObj[key];
        }
      }

      this._stack.push(obj);
    }
  },
  _processResult: function _processResult(value) {
    if (value === "") {
      return;
    }

    value = this._escapeSpecialSymbol(value);

    if (this._stack.length > 0) {
      this._resultObjectArray.push({
        text: value,
        style: this._stack[this._stack.length - 1]
      });
    } else {
      this._resultObjectArray.push({
        text: value
      });
    }
  },
  _escapeSpecialSymbol: function _escapeSpecialSymbol(str) {
    for (var i = 0; i < this._specialSymbolArray.length; ++i) {
      var key = this._specialSymbolArray[i][0];
      var value = this._specialSymbolArray[i][1];
      str = str.replace(key, value);
    }

    return str;
  }
};

if (CC_TEST) {
  cc._Test.HtmlTextParser = HtmlTextParser;
}

module.exports = HtmlTextParser;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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