
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/utils/blend-func.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

var RenderComponent = require('../components/CCRenderComponent');

var BlendFactor = require('../platform/CCMacro').BlendFactor;

var gfx = require('../../renderer/gfx');
/**
 * !#en
 * Helper class for setting material blend function.
 * !#zh
 * 设置材质混合模式的辅助类。
 * @class BlendFunc
 */


var BlendFunc = cc.Class({
  properties: {
    _srcBlendFactor: BlendFactor.SRC_ALPHA,
    _dstBlendFactor: BlendFactor.ONE_MINUS_SRC_ALPHA,

    /**
     * !#en specify the source Blend Factor, this will generate a custom material object, please pay attention to the memory cost.
     * !#zh 指定原图的混合模式，这会克隆一个新的材质对象，注意这带来的开销
     * @property srcBlendFactor
     * @type {macro.BlendFactor}
     * @example
     * sprite.srcBlendFactor = cc.macro.BlendFactor.ONE;
     */
    srcBlendFactor: {
      get: function get() {
        return this._srcBlendFactor;
      },
      set: function set(value) {
        if (this._srcBlendFactor === value) return;
        this._srcBlendFactor = value;

        this._updateBlendFunc();
      },
      animatable: false,
      type: BlendFactor,
      tooltip: CC_DEV && 'i18n:COMPONENT.sprite.src_blend_factor',
      visible: true
    },

    /**
     * !#en specify the destination Blend Factor.
     * !#zh 指定目标的混合模式
     * @property dstBlendFactor
     * @type {macro.BlendFactor}
     * @example
     * sprite.dstBlendFactor = cc.macro.BlendFactor.ONE;
     */
    dstBlendFactor: {
      get: function get() {
        return this._dstBlendFactor;
      },
      set: function set(value) {
        if (this._dstBlendFactor === value) return;
        this._dstBlendFactor = value;

        this._updateBlendFunc();
      },
      animatable: false,
      type: BlendFactor,
      tooltip: CC_DEV && 'i18n:COMPONENT.sprite.dst_blend_factor',
      visible: true
    }
  },
  setMaterial: function setMaterial(index, material) {
    var materialVar = RenderComponent.prototype.setMaterial.call(this, index, material);

    if (this._srcBlendFactor !== BlendFactor.SRC_ALPHA || this._dstBlendFactor !== BlendFactor.ONE_MINUS_SRC_ALPHA) {
      this._updateMaterialBlendFunc(materialVar);
    }

    return materialVar;
  },
  _updateMaterial: function _updateMaterial() {
    this._updateBlendFunc();
  },
  _updateBlendFunc: function _updateBlendFunc() {
    if (this._srcBlendFactor === BlendFactor.SRC_ALPHA && this._dstBlendFactor === BlendFactor.ONE_MINUS_SRC_ALPHA) {
      return;
    }

    var materials = this.getMaterials();

    for (var i = 0; i < materials.length; i++) {
      var material = materials[i];

      this._updateMaterialBlendFunc(material);
    }
  },
  _updateMaterialBlendFunc: function _updateMaterialBlendFunc(material) {
    material.setBlend(true, gfx.BLEND_FUNC_ADD, this._srcBlendFactor, this._dstBlendFactor, gfx.BLEND_FUNC_ADD, this._srcBlendFactor, this._dstBlendFactor);
  }
});
module.exports = cc.BlendFunc = BlendFunc;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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