
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/utils/base-node.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Flags = require('../platform/CCObject').Flags;

var misc = require('./misc');

var js = require('../platform/js');

var IdGenerater = require('../platform/id-generater');

var eventManager = require('../event-manager');

var RenderFlow = require('../renderer/render-flow');

var Destroying = Flags.Destroying;
var DontDestroy = Flags.DontDestroy;
var Deactivating = Flags.Deactivating;
var CHILD_ADDED = 'child-added';
var CHILD_REMOVED = 'child-removed';
var idGenerater = new IdGenerater('Node');

function getConstructor(typeOrClassName) {
  if (!typeOrClassName) {
    cc.errorID(3804);
    return null;
  }

  if (typeof typeOrClassName === 'string') {
    return js.getClassByName(typeOrClassName);
  }

  return typeOrClassName;
}

function findComponent(node, constructor) {
  if (constructor._sealed) {
    for (var i = 0; i < node._components.length; ++i) {
      var comp = node._components[i];

      if (comp.constructor === constructor) {
        return comp;
      }
    }
  } else {
    for (var _i = 0; _i < node._components.length; ++_i) {
      var _comp = node._components[_i];

      if (_comp instanceof constructor) {
        return _comp;
      }
    }
  }

  return null;
}

function findComponents(node, constructor, components) {
  if (constructor._sealed) {
    for (var i = 0; i < node._components.length; ++i) {
      var comp = node._components[i];

      if (comp.constructor === constructor) {
        components.push(comp);
      }
    }
  } else {
    for (var _i2 = 0; _i2 < node._components.length; ++_i2) {
      var _comp2 = node._components[_i2];

      if (_comp2 instanceof constructor) {
        components.push(_comp2);
      }
    }
  }
}

function findChildComponent(children, constructor) {
  for (var i = 0; i < children.length; ++i) {
    var node = children[i];
    var comp = findComponent(node, constructor);

    if (comp) {
      return comp;
    } else if (node._children.length > 0) {
      comp = findChildComponent(node._children, constructor);

      if (comp) {
        return comp;
      }
    }
  }

  return null;
}

function findChildComponents(children, constructor, components) {
  for (var i = 0; i < children.length; ++i) {
    var node = children[i];
    findComponents(node, constructor, components);

    if (node._children.length > 0) {
      findChildComponents(node._children, constructor, components);
    }
  }
}
/**
 * A base node for CCNode, it will:
 * - maintain scene hierarchy and active logic
 * - notifications if some properties changed
 * - define some interfaces shares between CCNode
 * - define machanisms for Enity Component Systems
 * - define prefab and serialize functions
 *
 * @class _BaseNode
 * @extends Object
 * @uses EventTarget
 * @constructor
 * @param {String} [name]
 * @private
 */


var BaseNode = cc.Class({
  name: 'cc._BaseNode',
  "extends": cc.Object,
  properties: {
    // SERIALIZABLE
    _parent: null,
    _children: [],
    _active: true,

    /**
     * @property _components
     * @type {Component[]}
     * @default []
     * @readOnly
     * @private
     */
    _components: [],

    /**
     * The PrefabInfo object
     * @property _prefab
     * @type {PrefabInfo}
     * @private
     */
    _prefab: null,

    /**
     * If true, the node is an persist node which won't be destroyed during scene transition.
     * If false, the node will be destroyed automatically when loading a new scene. Default is false.
     * @property _persistNode
     * @type {Boolean}
     * @default false
     * @private
     */
    _persistNode: {
      get: function get() {
        return (this._objFlags & DontDestroy) > 0;
      },
      set: function set(value) {
        if (value) {
          this._objFlags |= DontDestroy;
        } else {
          this._objFlags &= ~DontDestroy;
        }
      }
    },
    // API

    /**
     * !#en Name of node.
     * !#zh 该节点名称。
     * @property name
     * @type {String}
     * @example
     * node.name = "New Node";
     * cc.log("Node Name: " + node.name);
     */
    name: {
      get: function get() {
        return this._name;
      },
      set: function set(value) {
        if (CC_DEV && value.indexOf('/') !== -1) {
          cc.errorID(1632);
          return;
        }

        this._name = value;

        if (CC_JSB && CC_NATIVERENDERER) {
          this._proxy.setName(this._name);
        }
      }
    },

    /**
     * !#en The uuid for editor, will be stripped before building project.
     * !#zh 主要用于编辑器的 uuid，在编辑器下可用于持久化存储，在项目构建之后将变成自增的 id。
     * @property uuid
     * @type {String}
     * @readOnly
     * @example
     * cc.log("Node Uuid: " + node.uuid);
     */
    uuid: {
      get: function get() {
        return this._id;
      }
    },

    /**
     * !#en All children nodes.
     * !#zh 节点的所有子节点。
     * @property children
     * @type {Node[]}
     * @readOnly
     * @example
     * var children = node.children;
     * for (var i = 0; i < children.length; ++i) {
     *     cc.log("Node: " + children[i]);
     * }
     */
    children: {
      get: function get() {
        return this._children;
      }
    },

    /**
     * !#en All children nodes.
     * !#zh 节点的子节点数量。
     * @property childrenCount
     * @type {Number}
     * @readOnly
     * @example
     * var count = node.childrenCount;
     * cc.log("Node Children Count: " + count);
     */
    childrenCount: {
      get: function get() {
        return this._children.length;
      }
    },

    /**
     * !#en
     * The local active state of this node.<br/>
     * Note that a Node may be inactive because a parent is not active, even if this returns true.<br/>
     * Use {{#crossLink "Node/activeInHierarchy:property"}}{{/crossLink}} if you want to check if the Node is actually treated as active in the scene.
     * !#zh
     * 当前节点的自身激活状态。<br/>
     * 值得注意的是，一个节点的父节点如果不被激活，那么即使它自身设为激活，它仍然无法激活。<br/>
     * 如果你想检查节点在场景中实际的激活状态可以使用 {{#crossLink "Node/activeInHierarchy:property"}}{{/crossLink}}。
     * @property active
     * @type {Boolean}
     * @default true
     * @example
     * node.active = false;
     */
    active: {
      get: function get() {
        return this._active;
      },
      set: function set(value) {
        value = !!value;

        if (this._active !== value) {
          this._active = value;
          var parent = this._parent;

          if (parent) {
            var couldActiveInScene = parent._activeInHierarchy;

            if (couldActiveInScene) {
              cc.director._nodeActivator.activateNode(this, value);
            }
          }
        }
      }
    },

    /**
     * !#en Indicates whether this node is active in the scene.
     * !#zh 表示此节点是否在场景中激活。
     * @property activeInHierarchy
     * @type {Boolean}
     * @example
     * cc.log("activeInHierarchy: " + node.activeInHierarchy);
     */
    activeInHierarchy: {
      get: function get() {
        return this._activeInHierarchy;
      }
    }
  },

  /**
   * @method constructor
   * @param {String} [name]
   */
  ctor: function ctor(name) {
    this._name = name !== undefined ? name : 'New Node';
    this._activeInHierarchy = false;
    this._id = CC_EDITOR ? Editor.Utils.UuidUtils.uuid() : idGenerater.getNewId();
    cc.director._scheduler && cc.director._scheduler.enableForTarget(this);
    /**
     * Register all related EventTargets,
     * all event callbacks will be removed in _onPreDestroy
     * @property __eventTargets
     * @type {EventTarget[]}
     * @private
     */

    this.__eventTargets = [];
  },

  /** 
   * !#en The parent of the node.
   * !#zh 该节点的父节点。
   * @property {Node} parent
   * @example 
   * cc.log("Node Parent: " + node.parent);
   */

  /**
   * !#en Get parent of the node.
   * !#zh 获取该节点的父节点。
   * @method getParent
   * @return {Node}
   * @example
   * var parent = this.node.getParent();
   */
  getParent: function getParent() {
    return this._parent;
  },

  /**
   * !#en Set parent of the node.
   * !#zh 设置该节点的父节点。
   * @method setParent
   * @param {Node} value
   * @example
   * node.setParent(newNode);
   */
  setParent: function setParent(value) {
    if (this._parent === value) {
      return;
    }

    if (CC_EDITOR && cc.engine && !cc.engine.isPlaying) {
      if (_Scene.DetectConflict.beforeAddChild(this, value)) {
        return;
      }
    }

    var oldParent = this._parent;

    if (CC_DEBUG && oldParent && oldParent._objFlags & Deactivating) {
      cc.errorID(3821);
    }

    this._parent = value || null;

    this._onSetParent(value);

    if (value) {
      if (CC_DEBUG && value._objFlags & Deactivating) {
        cc.errorID(3821);
      }

      eventManager._setDirtyForNode(this);

      value._children.push(this);

      value.emit && value.emit(CHILD_ADDED, this);
      value._renderFlag |= RenderFlow.FLAG_CHILDREN;
    }

    if (oldParent) {
      if (!(oldParent._objFlags & Destroying)) {
        var removeAt = oldParent._children.indexOf(this);

        if (CC_DEV && removeAt < 0) {
          return cc.errorID(1633);
        }

        oldParent._children.splice(removeAt, 1);

        oldParent.emit && oldParent.emit(CHILD_REMOVED, this);

        this._onHierarchyChanged(oldParent);

        if (oldParent._children.length === 0) {
          oldParent._renderFlag &= ~RenderFlow.FLAG_CHILDREN;
        }
      }
    } else if (value) {
      this._onHierarchyChanged(null);
    }
  },
  // ABSTRACT INTERFACES

  /**
   * !#en
   * Properties configuration function <br/>
   * All properties in attrs will be set to the node, <br/>
   * when the setter of the node is available, <br/>
   * the property will be set via setter function.<br/>
   * !#zh 属性配置函数。在 attrs 的所有属性将被设置为节点属性。
   * @method attr
   * @param {Object} attrs - Properties to be set to node
   * @example
   * var attrs = { key: 0, num: 100 };
   * node.attr(attrs);
   */
  attr: function attr(attrs) {
    js.mixin(this, attrs);
  },
  // composition: GET

  /**
   * !#en Returns a child from the container given its uuid.
   * !#zh 通过 uuid 获取节点的子节点。
   * @method getChildByUuid
   * @param {String} uuid - The uuid to find the child node.
   * @return {Node} a Node whose uuid equals to the input parameter
   * @example
   * var child = node.getChildByUuid(uuid);
   */
  getChildByUuid: function getChildByUuid(uuid) {
    if (!uuid) {
      cc.log("Invalid uuid");
      return null;
    }

    var locChildren = this._children;

    for (var i = 0, len = locChildren.length; i < len; i++) {
      if (locChildren[i]._id === uuid) return locChildren[i];
    }

    return null;
  },

  /**
   * !#en Returns a child from the container given its name.
   * !#zh 通过名称获取节点的子节点。
   * @method getChildByName
   * @param {String} name - A name to find the child node.
   * @return {Node} a CCNode object whose name equals to the input parameter
   * @example
   * var child = node.getChildByName("Test Node");
   */
  getChildByName: function getChildByName(name) {
    if (!name) {
      cc.log("Invalid name");
      return null;
    }

    var locChildren = this._children;

    for (var i = 0, len = locChildren.length; i < len; i++) {
      if (locChildren[i]._name === name) return locChildren[i];
    }

    return null;
  },
  // composition: ADD
  addChild: function addChild(child) {
    if (CC_DEV && !(child instanceof cc._BaseNode)) {
      return cc.errorID(1634, cc.js.getClassName(child));
    }

    cc.assertID(child, 1606);
    cc.assertID(child._parent === null, 1605); // invokes the parent setter

    child.setParent(this);
  },

  /**
   * !#en
   * Inserts a child to the node at a specified index.
   * !#zh
   * 插入子节点到指定位置
   * @method insertChild
   * @param {Node} child - the child node to be inserted
   * @param {Number} siblingIndex - the sibling index to place the child in
   * @example
   * node.insertChild(child, 2);
   */
  insertChild: function insertChild(child, siblingIndex) {
    child.parent = this;
    child.setSiblingIndex(siblingIndex);
  },
  // HIERARCHY METHODS

  /**
   * !#en Get the sibling index.
   * !#zh 获取同级索引。
   * @method getSiblingIndex
   * @return {Number}
   * @example
   * var index = node.getSiblingIndex();
   */
  getSiblingIndex: function getSiblingIndex() {
    if (this._parent) {
      return this._parent._children.indexOf(this);
    } else {
      return 0;
    }
  },

  /**
   * !#en Set the sibling index of this node.
   * !#zh 设置节点同级索引。
   * @method setSiblingIndex
   * @param {Number} index
   * @example
   * node.setSiblingIndex(1);
   */
  setSiblingIndex: function setSiblingIndex(index) {
    if (!this._parent) {
      return;
    }

    if (this._parent._objFlags & Deactivating) {
      cc.errorID(3821);
      return;
    }

    var siblings = this._parent._children;
    index = index !== -1 ? index : siblings.length - 1;
    var oldIndex = siblings.indexOf(this);

    if (index !== oldIndex) {
      siblings.splice(oldIndex, 1);

      if (index < siblings.length) {
        siblings.splice(index, 0, this);
      } else {
        siblings.push(this);
      }

      this._onSiblingIndexChanged && this._onSiblingIndexChanged(index);
    }
  },

  /**
   * !#en Walk though the sub children tree of the current node.
   * Each node, including the current node, in the sub tree will be visited two times, before all children and after all children.
   * This function call is not recursive, it's based on stack.
   * Please don't walk any other node inside the walk process.
   * !#zh 遍历该节点的子树里的所有节点并按规则执行回调函数。
   * 对子树中的所有节点，包含当前节点，会执行两次回调，prefunc 会在访问它的子节点之前调用，postfunc 会在访问所有子节点之后调用。
   * 这个函数的实现不是基于递归的，而是基于栈展开递归的方式。
   * 请不要在 walk 过程中对任何其他的节点嵌套执行 walk。
   * @method walk
   * @param {Function} prefunc The callback to process node when reach the node for the first time
   * @param {_BaseNode} prefunc.target The current visiting node
   * @param {Function} postfunc The callback to process node when re-visit the node after walked all children in its sub tree
   * @param {_BaseNode} postfunc.target The current visiting node
   * @example
   * node.walk(function (target) {
   *     console.log('Walked through node ' + target.name + ' for the first time');
   * }, function (target) {
   *     console.log('Walked through node ' + target.name + ' after walked all children in its sub tree');
   * });
   */
  walk: function walk(prefunc, postfunc) {
    var BaseNode = cc._BaseNode;
    var index = 1;
    var children, child, curr, i, afterChildren;
    var stack = BaseNode._stacks[BaseNode._stackId];

    if (!stack) {
      stack = [];

      BaseNode._stacks.push(stack);
    }

    BaseNode._stackId++;
    stack.length = 0;
    stack[0] = this;
    var parent = null;
    afterChildren = false;

    while (index) {
      index--;
      curr = stack[index];

      if (!curr) {
        continue;
      }

      if (!afterChildren && prefunc) {
        // pre call
        prefunc(curr);
      } else if (afterChildren && postfunc) {
        // post call
        postfunc(curr);
      } // Avoid memory leak


      stack[index] = null; // Do not repeatly visit child tree, just do post call and continue walk

      if (afterChildren) {
        afterChildren = false;
      } else {
        // Children not proceeded and has children, proceed to child tree
        if (curr._children.length > 0) {
          parent = curr;
          children = curr._children;
          i = 0;
          stack[index] = children[i];
          index++;
        } // No children, then repush curr to be walked for post func
        else {
            stack[index] = curr;
            index++;
            afterChildren = true;
          }

        continue;
      } // curr has no sub tree, so look into the siblings in parent children


      if (children) {
        i++; // Proceed to next sibling in parent children

        if (children[i]) {
          stack[index] = children[i];
          index++;
        } // No children any more in this sub tree, go upward
        else if (parent) {
            stack[index] = parent;
            index++; // Setup parent walk env

            afterChildren = true;

            if (parent._parent) {
              children = parent._parent._children;
              i = children.indexOf(parent);
              parent = parent._parent;
            } else {
              // At root
              parent = null;
              children = null;
            } // ERROR


            if (i < 0) {
              break;
            }
          }
      }
    }

    stack.length = 0;
    BaseNode._stackId--;
  },
  cleanup: function cleanup() {},

  /**
   * !#en
   * Remove itself from its parent node. If cleanup is `true`, then also remove all events and actions. <br/>
   * If the cleanup parameter is not passed, it will force a cleanup, so it is recommended that you always pass in the `false` parameter when calling this API.<br/>
   * If the node orphan, then nothing happens.
   * !#zh
   * 从父节点中删除该节点。如果不传入 cleanup 参数或者传入 `true`，那么这个节点上所有绑定的事件、action 都会被删除。<br/>
   * 因此建议调用这个 API 时总是传入 `false` 参数。<br/>
   * 如果这个节点是一个孤节点，那么什么都不会发生。
   * @method removeFromParent
   * @param {Boolean} [cleanup=true] - true if all actions and callbacks on this node should be removed, false otherwise.
   * @example
   * node.removeFromParent();
   * node.removeFromParent(false);
   */
  removeFromParent: function removeFromParent(cleanup) {
    if (this._parent) {
      if (cleanup === undefined) cleanup = true;

      this._parent.removeChild(this, cleanup);
    }
  },

  /**
   * !#en
   * Removes a child from the container. It will also cleanup all running actions depending on the cleanup parameter. </p>
   * If the cleanup parameter is not passed, it will force a cleanup. <br/>
   * "remove" logic MUST only be on this method  <br/>
   * If a class wants to extend the 'removeChild' behavior it only needs <br/>
   * to override this method.
   * !#zh
   * 移除节点中指定的子节点，是否需要清理所有正在运行的行为取决于 cleanup 参数。<br/>
   * 如果 cleanup 参数不传入，默认为 true 表示清理。<br/>
   * @method removeChild
   * @param {Node} child - The child node which will be removed.
   * @param {Boolean} [cleanup=true] - true if all running actions and callbacks on the child node will be cleanup, false otherwise.
   * @example
   * node.removeChild(newNode);
   * node.removeChild(newNode, false);
   */
  removeChild: function removeChild(child, cleanup) {
    if (this._children.indexOf(child) > -1) {
      // If you don't do cleanup, the child's actions will not get removed and the
      if (cleanup || cleanup === undefined) {
        child.cleanup();
      } // invoke the parent setter


      child.parent = null;
    }
  },

  /**
   * !#en
   * Removes all children from the container and do a cleanup all running actions depending on the cleanup parameter. <br/>
   * If the cleanup parameter is not passed, it will force a cleanup.
   * !#zh
   * 移除节点所有的子节点，是否需要清理所有正在运行的行为取决于 cleanup 参数。<br/>
   * 如果 cleanup 参数不传入，默认为 true 表示清理。
   * @method removeAllChildren
   * @param {Boolean} [cleanup=true] - true if all running actions on all children nodes should be cleanup, false otherwise.
   * @example
   * node.removeAllChildren();
   * node.removeAllChildren(false);
   */
  removeAllChildren: function removeAllChildren(cleanup) {
    // not using detachChild improves speed here
    var children = this._children;
    if (cleanup === undefined) cleanup = true;

    for (var i = children.length - 1; i >= 0; i--) {
      var node = children[i];

      if (node) {
        // If you don't do cleanup, the node's actions will not get removed and the
        if (cleanup) node.cleanup();
        node.parent = null;
      }
    }

    this._children.length = 0;
  },

  /**
   * !#en Is this node a child of the given node?
   * !#zh 是否是指定节点的子节点？
   * @method isChildOf
   * @param {Node} parent
   * @return {Boolean} - Returns true if this node is a child, deep child or identical to the given node.
   * @example
   * node.isChildOf(newNode);
   */
  isChildOf: function isChildOf(parent) {
    var child = this;

    do {
      if (child === parent) {
        return true;
      }

      child = child._parent;
    } while (child);

    return false;
  },
  // COMPONENT

  /**
   * !#en
   * Returns the component of supplied type if the node has one attached, null if it doesn't.<br/>
   * You can also get component in the node by passing in the name of the script.
   * !#zh
   * 获取节点上指定类型的组件，如果节点有附加指定类型的组件，则返回，如果没有则为空。<br/>
   * 传入参数也可以是脚本的名称。
   * @method getComponent
   * @param {Function|String} typeOrClassName
   * @return {Component}
   * @example
   * // get sprite component
   * var sprite = node.getComponent(cc.Sprite);
   * // get custom test class
   * var test = node.getComponent("Test");
   * @typescript
   * getComponent<T extends Component>(type: {prototype: T}): T
   * getComponent(className: string): any
   */
  getComponent: function getComponent(typeOrClassName) {
    var constructor = getConstructor(typeOrClassName);

    if (constructor) {
      return findComponent(this, constructor);
    }

    return null;
  },

  /**
   * !#en Returns all components of supplied type in the node.
   * !#zh 返回节点上指定类型的所有组件。
   * @method getComponents
   * @param {Function|String} typeOrClassName
   * @return {Component[]}
   * @example
   * var sprites = node.getComponents(cc.Sprite);
   * var tests = node.getComponents("Test");
   * @typescript
   * getComponents<T extends Component>(type: {prototype: T}): T[]
   * getComponents(className: string): any[]
   */
  getComponents: function getComponents(typeOrClassName) {
    var constructor = getConstructor(typeOrClassName),
        components = [];

    if (constructor) {
      findComponents(this, constructor, components);
    }

    return components;
  },

  /**
   * !#en Returns the component of supplied type in any of its children using depth first search.
   * !#zh 递归查找所有子节点中第一个匹配指定类型的组件。
   * @method getComponentInChildren
   * @param {Function|String} typeOrClassName
   * @return {Component}
   * @example
   * var sprite = node.getComponentInChildren(cc.Sprite);
   * var Test = node.getComponentInChildren("Test");
   * @typescript
   * getComponentInChildren<T extends Component>(type: {prototype: T}): T
   * getComponentInChildren(className: string): any
   */
  getComponentInChildren: function getComponentInChildren(typeOrClassName) {
    var constructor = getConstructor(typeOrClassName);

    if (constructor) {
      return findChildComponent(this._children, constructor);
    }

    return null;
  },

  /**
   * !#en Returns all components of supplied type in self or any of its children.
   * !#zh 递归查找自身或所有子节点中指定类型的组件
   * @method getComponentsInChildren
   * @param {Function|String} typeOrClassName
   * @return {Component[]}
   * @example
   * var sprites = node.getComponentsInChildren(cc.Sprite);
   * var tests = node.getComponentsInChildren("Test");
   * @typescript
   * getComponentsInChildren<T extends Component>(type: {prototype: T}): T[]
   * getComponentsInChildren(className: string): any[]
   */
  getComponentsInChildren: function getComponentsInChildren(typeOrClassName) {
    var constructor = getConstructor(typeOrClassName),
        components = [];

    if (constructor) {
      findComponents(this, constructor, components);
      findChildComponents(this._children, constructor, components);
    }

    return components;
  },
  _checkMultipleComp: CC_EDITOR && function (ctor) {
    var existing = this.getComponent(ctor._disallowMultiple);

    if (existing) {
      if (existing.constructor === ctor) {
        cc.errorID(3805, js.getClassName(ctor), this._name);
      } else {
        cc.errorID(3806, js.getClassName(ctor), this._name, js.getClassName(existing));
      }

      return false;
    }

    return true;
  },

  /**
   * !#en Adds a component class to the node. You can also add component to node by passing in the name of the script.
   * !#zh 向节点添加一个指定类型的组件类，你还可以通过传入脚本的名称来添加组件。
   * @method addComponent
   * @param {Function|String} typeOrClassName - The constructor or the class name of the component to add
   * @return {Component} - The newly added component
   * @example
   * var sprite = node.addComponent(cc.Sprite);
   * var test = node.addComponent("Test");
   * @typescript
   * addComponent<T extends Component>(type: {new(): T}): T
   * addComponent(className: string): any
   */
  addComponent: function addComponent(typeOrClassName) {
    if (CC_EDITOR && this._objFlags & Destroying) {
      cc.error('isDestroying');
      return null;
    } // get component


    var constructor;

    if (typeof typeOrClassName === 'string') {
      constructor = js.getClassByName(typeOrClassName);

      if (!constructor) {
        cc.errorID(3807, typeOrClassName);

        if (cc._RFpeek()) {
          cc.errorID(3808, typeOrClassName);
        }

        return null;
      }
    } else {
      if (!typeOrClassName) {
        cc.errorID(3804);
        return null;
      }

      constructor = typeOrClassName;
    } // check component


    if (typeof constructor !== 'function') {
      cc.errorID(3809);
      return null;
    }

    if (!js.isChildClassOf(constructor, cc.Component)) {
      cc.errorID(3810);
      return null;
    }

    if (CC_EDITOR && constructor._disallowMultiple) {
      if (!this._checkMultipleComp(constructor)) {
        return null;
      }
    } // check requirement


    var ReqComp = constructor._requireComponent;

    if (ReqComp && !this.getComponent(ReqComp)) {
      var depended = this.addComponent(ReqComp);

      if (!depended) {
        // depend conflicts
        return null;
      }
    } //// check conflict
    //
    //if (CC_EDITOR && !_Scene.DetectConflict.beforeAddComponent(this, constructor)) {
    //    return null;
    //}
    //


    var component = new constructor();
    component.node = this;

    this._components.push(component);

    if ((CC_EDITOR || CC_TEST) && cc.engine && this._id in cc.engine.attachedObjsForEditor) {
      cc.engine.attachedObjsForEditor[component._id] = component;
    }

    if (this._activeInHierarchy) {
      cc.director._nodeActivator.activateComp(component);
    }

    return component;
  },

  /**
   * This api should only used by undo system
   * @method _addComponentAt
   * @param {Component} comp
   * @param {Number} index
   * @private
   */
  _addComponentAt: CC_EDITOR && function (comp, index) {
    if (this._objFlags & Destroying) {
      return cc.error('isDestroying');
    }

    if (!(comp instanceof cc.Component)) {
      return cc.errorID(3811);
    }

    if (index > this._components.length) {
      return cc.errorID(3812);
    } // recheck attributes because script may changed


    var ctor = comp.constructor;

    if (ctor._disallowMultiple) {
      if (!this._checkMultipleComp(ctor)) {
        return;
      }
    }

    var ReqComp = ctor._requireComponent;

    if (ReqComp && !this.getComponent(ReqComp)) {
      if (index === this._components.length) {
        // If comp should be last component, increase the index because required component added
        ++index;
      }

      var depended = this.addComponent(ReqComp);

      if (!depended) {
        // depend conflicts
        return null;
      }
    }

    comp.node = this;

    this._components.splice(index, 0, comp);

    if ((CC_EDITOR || CC_TEST) && cc.engine && this._id in cc.engine.attachedObjsForEditor) {
      cc.engine.attachedObjsForEditor[comp._id] = comp;
    }

    if (this._activeInHierarchy) {
      cc.director._nodeActivator.activateComp(comp);
    }
  },

  /**
   * !#en
   * Removes a component identified by the given name or removes the component object given.
   * You can also use component.destroy() if you already have the reference.
   * !#zh
   * 删除节点上的指定组件，传入参数可以是一个组件构造函数或组件名，也可以是已经获得的组件引用。
   * 如果你已经获得组件引用，你也可以直接调用 component.destroy()
   * @method removeComponent
   * @param {String|Function|Component} component - The need remove component.
   * @deprecated please destroy the component to remove it.
   * @example
   * node.removeComponent(cc.Sprite);
   * var Test = require("Test");
   * node.removeComponent(Test);
   */
  removeComponent: function removeComponent(component) {
    if (!component) {
      cc.errorID(3813);
      return;
    }

    if (!(component instanceof cc.Component)) {
      component = this.getComponent(component);
    }

    if (component) {
      component.destroy();
    }
  },

  /**
   * @method _getDependComponent
   * @param {Component} depended
   * @return {Component}
   * @private
   */
  _getDependComponent: CC_EDITOR && function (depended) {
    for (var i = 0; i < this._components.length; i++) {
      var comp = this._components[i];

      if (comp !== depended && comp.isValid && !cc.Object._willDestroy(comp)) {
        var depend = comp.constructor._requireComponent;

        if (depend && depended instanceof depend) {
          return comp;
        }
      }
    }

    return null;
  },
  // do remove component, only used internally
  _removeComponent: function _removeComponent(component) {
    if (!component) {
      cc.errorID(3814);
      return;
    }

    if (!(this._objFlags & Destroying)) {
      var i = this._components.indexOf(component);

      if (i !== -1) {
        this._components.splice(i, 1);

        if ((CC_EDITOR || CC_TEST) && cc.engine) {
          delete cc.engine.attachedObjsForEditor[component._id];
        }
      } else if (component.node !== this) {
        cc.errorID(3815);
      }
    }
  },
  destroy: function destroy() {
    if (cc.Object.prototype.destroy.call(this)) {
      this.active = false;
    }
  },

  /**
   * !#en
   * Destroy all children from the node, and release all their own references to other objects.<br/>
   * Actual destruct operation will delayed until before rendering.
   * !#zh
   * 销毁所有子节点，并释放所有它们对其它对象的引用。<br/>
   * 实际销毁操作会延迟到当前帧渲染前执行。
   * @method destroyAllChildren
   * @example
   * node.destroyAllChildren();
   */
  destroyAllChildren: function destroyAllChildren() {
    var children = this._children;

    for (var i = 0; i < children.length; ++i) {
      children[i].destroy();
    }
  },
  _onSetParent: function _onSetParent(value) {},
  _onPostActivated: function _onPostActivated() {},
  _onBatchRestored: function _onBatchRestored() {},
  _onBatchCreated: function _onBatchCreated() {},
  _onHierarchyChanged: function _onHierarchyChanged(oldParent) {
    var newParent = this._parent;

    if (this._persistNode && !(newParent instanceof cc.Scene)) {
      cc.game.removePersistRootNode(this);

      if (CC_EDITOR) {
        cc.warnID(1623);
      }
    }

    if (CC_EDITOR || CC_TEST) {
      var scene = cc.director.getScene();
      var inCurrentSceneBefore = oldParent && oldParent.isChildOf(scene);
      var inCurrentSceneNow = newParent && newParent.isChildOf(scene);

      if (!inCurrentSceneBefore && inCurrentSceneNow) {
        // attached
        this._registerIfAttached(true);
      } else if (inCurrentSceneBefore && !inCurrentSceneNow) {
        // detached
        this._registerIfAttached(false);
      } // update prefab


      var newPrefabRoot = newParent && newParent._prefab && newParent._prefab.root;
      var myPrefabInfo = this._prefab;

      var PrefabUtils = Editor.require('scene://utils/prefab');

      if (myPrefabInfo) {
        if (newPrefabRoot) {
          if (myPrefabInfo.root !== newPrefabRoot) {
            // change prefab
            PrefabUtils.unlinkPrefab(this);
            PrefabUtils.linkPrefab(newPrefabRoot._prefab.asset, newPrefabRoot, this);
          }
        } else if (myPrefabInfo.root !== this) {
          // detach from prefab
          PrefabUtils.unlinkPrefab(this);
        }
      } else if (newPrefabRoot) {
        // attach to prefab
        PrefabUtils.linkPrefab(newPrefabRoot._prefab.asset, newPrefabRoot, this);
      } // conflict detection


      _Scene.DetectConflict.afterAddChild(this);
    }

    var shouldActiveNow = this._active && !!(newParent && newParent._activeInHierarchy);

    if (this._activeInHierarchy !== shouldActiveNow) {
      cc.director._nodeActivator.activateNode(this, shouldActiveNow);
    }
  },
  _instantiate: function _instantiate(cloned) {
    if (!cloned) {
      cloned = cc.instantiate._clone(this, this);
    }

    var thisPrefabInfo = this._prefab;

    if (CC_EDITOR && thisPrefabInfo) {
      if (this !== thisPrefabInfo.root) {
        var PrefabUtils = Editor.require('scene://utils/prefab');

        PrefabUtils.initClonedChildOfPrefab(cloned);
      }
    }

    var syncing = thisPrefabInfo && this === thisPrefabInfo.root && thisPrefabInfo.sync;

    if (syncing) {//if (thisPrefabInfo._synced) {
      //    return clone;
      //}
    } else if (CC_EDITOR && cc.engine._isPlaying) {
      cloned._name += ' (Clone)';
    } // reset and init


    cloned._parent = null;

    cloned._onBatchRestored();

    return cloned;
  },
  _registerIfAttached: (CC_EDITOR || CC_TEST) && function (register) {
    var attachedObjsForEditor = cc.engine.attachedObjsForEditor;

    if (register) {
      attachedObjsForEditor[this._id] = this;

      for (var i = 0; i < this._components.length; i++) {
        var comp = this._components[i];
        attachedObjsForEditor[comp._id] = comp;
      }

      cc.engine.emit('node-attach-to-scene', this);
    } else {
      cc.engine.emit('node-detach-from-scene', this);
      delete attachedObjsForEditor[this._id];

      for (var _i3 = 0; _i3 < this._components.length; _i3++) {
        var _comp3 = this._components[_i3];
        delete attachedObjsForEditor[_comp3._id];
      }
    }

    var children = this._children;

    for (var _i4 = 0, len = children.length; _i4 < len; ++_i4) {
      var child = children[_i4];

      child._registerIfAttached(register);
    }
  },
  _onPreDestroy: function _onPreDestroy() {
    var i, len; // marked as destroying

    this._objFlags |= Destroying; // detach self and children from editor

    var parent = this._parent;
    var destroyByParent = parent && parent._objFlags & Destroying;

    if (!destroyByParent && (CC_EDITOR || CC_TEST)) {
      this._registerIfAttached(false);
    } // destroy children


    var children = this._children;

    for (i = 0, len = children.length; i < len; ++i) {
      // destroy immediate so its _onPreDestroy can be called
      children[i]._destroyImmediate();
    } // destroy self components


    for (i = 0, len = this._components.length; i < len; ++i) {
      var component = this._components[i]; // destroy immediate so its _onPreDestroy can be called

      component._destroyImmediate();
    }

    var eventTargets = this.__eventTargets;

    for (i = 0, len = eventTargets.length; i < len; ++i) {
      var target = eventTargets[i];
      target && target.targetOff(this);
    }

    eventTargets.length = 0; // remove from persist

    if (this._persistNode) {
      cc.game.removePersistRootNode(this);
    }

    if (!destroyByParent) {
      // remove from parent
      if (parent) {
        var childIndex = parent._children.indexOf(this);

        parent._children.splice(childIndex, 1);

        parent.emit && parent.emit('child-removed', this);
      }
    }

    return destroyByParent;
  },
  onRestore: CC_EDITOR && function () {
    // check activity state
    var shouldActiveNow = this._active && !!(this._parent && this._parent._activeInHierarchy);

    if (this._activeInHierarchy !== shouldActiveNow) {
      cc.director._nodeActivator.activateNode(this, shouldActiveNow);
    }
  }
});
BaseNode.idGenerater = idGenerater; // For walk

BaseNode._stacks = [[]];
BaseNode._stackId = 0;
BaseNode.prototype._onPreDestroyBase = BaseNode.prototype._onPreDestroy;

if (CC_EDITOR) {
  BaseNode.prototype._onPreDestroy = function () {
    var destroyByParent = this._onPreDestroyBase();

    if (!destroyByParent) {
      // ensure this node can reattach to scene by undo system
      // (simulate some destruct logic to make undo system work correctly)
      this._parent = null;
    }

    return destroyByParent;
  };
}

BaseNode.prototype._onHierarchyChangedBase = BaseNode.prototype._onHierarchyChanged;

if (CC_EDITOR) {
  BaseNode.prototype._onRestoreBase = BaseNode.prototype.onRestore;
} // Define public getter and setter methods to ensure api compatibility.


var SameNameGetSets = ['parent', 'name', 'children', 'childrenCount'];
misc.propertyDefine(BaseNode, SameNameGetSets, {});

if (CC_DEV) {
  // promote debug info
  js.get(BaseNode.prototype, ' INFO ', function () {
    var path = '';
    var node = this;

    while (node && !(node instanceof cc.Scene)) {
      if (path) {
        path = node.name + '/' + path;
      } else {
        path = node.name;
      }

      node = node._parent;
    }

    return this.name + ', path: ' + path;
  });
}
/**
 * !#en
 * Note: This event is only emitted from the top most node whose active value did changed,
 * not including its child nodes.
 * !#zh
 * 注意：此节点激活时，此事件仅从最顶部的节点发出。
 * @event active-in-hierarchy-changed
 * @param {Event.EventCustom} event
 */


cc._BaseNode = module.exports = BaseNode;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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