
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/webgl/assemblers/sprite/2d/tiled.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _assembler2d = _interopRequireDefault(require("../../../../assembler-2d"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var TiledAssembler =
/*#__PURE__*/
function (_Assembler2D) {
  _inheritsLoose(TiledAssembler, _Assembler2D);

  function TiledAssembler() {
    return _Assembler2D.apply(this, arguments) || this;
  }

  var _proto = TiledAssembler.prototype;

  _proto.initData = function initData(sprite) {
    this.verticesCount = 0;
    this.contentWidth = 0;
    this.contentHeight = 0;
    this.rectWidth = 0;
    this.rectHeight = 0;
    this.hRepeat = 0;
    this.vRepeat = 0;
    this.row = 0;
    this.col = 0;

    this._renderData.createFlexData(0, 4, 6, this.getVfmt());

    this._updateIndices();
  };

  _proto.initLocal = function initLocal() {
    this._local = {
      x: [],
      y: []
    };
  };

  _proto._updateIndices = function _updateIndices() {
    var iData = this._renderData.iDatas[0];

    for (var i = 0, vid = 0, l = iData.length; i < l; i += 6, vid += 4) {
      iData[i] = vid;
      iData[i + 1] = vid + 1;
      iData[i + 2] = vid + 2;
      iData[i + 3] = vid + 1;
      iData[i + 4] = vid + 3;
      iData[i + 5] = vid + 2;
    }
  };

  _proto.updateRenderData = function updateRenderData(sprite) {
    var frame = sprite._spriteFrame;
    this.packToDynamicAtlas(sprite, frame);
    var node = sprite.node;
    var contentWidth = this.contentWidth = Math.abs(node.width);
    var contentHeight = this.contentHeight = Math.abs(node.height);
    var rect = frame._rect;
    var leftWidth = frame.insetLeft,
        rightWidth = frame.insetRight,
        centerWidth = rect.width - leftWidth - rightWidth,
        topHeight = frame.insetTop,
        bottomHeight = frame.insetBottom,
        centerHeight = rect.height - topHeight - bottomHeight;
    this.sizableWidth = contentWidth - leftWidth - rightWidth;
    this.sizableHeight = contentHeight - topHeight - bottomHeight;
    this.sizableWidth = this.sizableWidth > 0 ? this.sizableWidth : 0;
    this.sizableHeight = this.sizableHeight > 0 ? this.sizableHeight : 0;
    var hRepeat = this.hRepeat = centerWidth === 0 ? this.sizableWidth : this.sizableWidth / centerWidth;
    var vRepeat = this.vRepeat = centerHeight === 0 ? this.sizableHeight : this.sizableHeight / centerHeight;
    var row = this.row = Math.ceil(vRepeat + 2);
    var col = this.col = Math.ceil(hRepeat + 2); // update data property

    var count = row * col;
    this.verticesCount = count * 4;
    this.indicesCount = count * 6;
    var renderData = this._renderData;
    var flexBuffer = renderData._flexBuffer;

    if (flexBuffer.reserve(this.verticesCount, this.indicesCount)) {
      this._updateIndices();

      this.updateColor(sprite);
    }

    flexBuffer.used(this.verticesCount, this.indicesCount);

    if (sprite._vertsDirty) {
      this.updateUVs(sprite);
      this.updateVerts(sprite);
      sprite._vertsDirty = false;
    }
  };

  _proto.updateVerts = function updateVerts(sprite) {
    var frame = sprite._spriteFrame;
    var rect = frame._rect;
    var node = sprite.node,
        appx = node.anchorX * node.width,
        appy = node.anchorY * node.height;
    var row = this.row,
        col = this.col,
        contentWidth = this.contentWidth,
        contentHeight = this.contentHeight;
    var _this$_local = this._local,
        x = _this$_local.x,
        y = _this$_local.y;
    x.length = y.length = 0;
    var leftWidth = frame.insetLeft,
        rightWidth = frame.insetRight,
        centerWidth = rect.width - leftWidth - rightWidth,
        topHeight = frame.insetTop,
        bottomHeight = frame.insetBottom,
        centerHeight = rect.height - topHeight - bottomHeight;
    var xScale = node.width / (leftWidth + rightWidth) > 1 ? 1 : node.width / (leftWidth + rightWidth);
    var yScale = node.height / (topHeight + bottomHeight) > 1 ? 1 : node.height / (topHeight + bottomHeight);
    var offsetWidth = 0,
        offsetHeight = 0;

    if (centerWidth > 0) {
      /*
       * Because the float numerical calculation in javascript is not accurate enough, 
       * there is an expected result of 1.0, but the actual result is 1.000001.
       */
      offsetWidth = Math.floor(this.sizableWidth * 1000) / 1000 % centerWidth === 0 ? centerWidth : this.sizableWidth % centerWidth;
    } else {
      offsetWidth = this.sizableWidth;
    }

    if (centerHeight > 0) {
      offsetHeight = Math.floor(this.sizableHeight * 1000) / 1000 % centerHeight === 0 ? centerHeight : this.sizableHeight % centerHeight;
    } else {
      offsetHeight = this.sizableHeight;
    }

    for (var i = 0; i <= col; i++) {
      if (i === 0) {
        x[i] = -appx;
      } else if (i > 0 && i < col) {
        if (i === 1) {
          x[i] = leftWidth * xScale + Math.min(centerWidth, this.sizableWidth) - appx;
        } else {
          if (centerWidth > 0) {
            if (i === col - 1) {
              x[i] = leftWidth + offsetWidth + centerWidth * (i - 2) - appx;
            } else {
              x[i] = leftWidth + Math.min(centerWidth, this.sizableWidth) + centerWidth * (i - 2) - appx;
            }
          } else {
            x[i] = leftWidth + this.sizableWidth - appx;
          }
        }
      } else if (i === col) {
        x[i] = Math.min(leftWidth + this.sizableWidth + rightWidth, contentWidth) - appx;
      }
    }

    for (var _i = 0; _i <= row; _i++) {
      if (_i === 0) {
        y[_i] = -appy;
      } else if (_i > 0 && _i < row) {
        if (_i === 1) {
          y[_i] = bottomHeight * yScale + Math.min(centerHeight, this.sizableHeight) - appy;
        } else {
          if (centerHeight > 0) {
            if (_i === row - 1) {
              y[_i] = bottomHeight + offsetHeight + (_i - 2) * centerHeight - appy;
            } else {
              y[_i] = bottomHeight + Math.min(centerHeight, this.sizableHeight) + (_i - 2) * centerHeight - appy;
            }
          } else {
            y[_i] = bottomHeight + this.sizableHeight - appy;
          }
        }
      } else if (_i === row) {
        y[_i] = Math.min(bottomHeight + this.sizableHeight + topHeight, contentHeight) - appy;
      }
    }

    this.updateWorldVerts(sprite);
  };

  _proto.updateWorldVerts = function updateWorldVerts(sprite) {
    var renderData = this._renderData;
    var local = this._local;
    var localX = local.x,
        localY = local.y;
    var world = renderData.vDatas[0];
    var row = this.row,
        col = this.col;
    var matrix = sprite.node._worldMatrix;
    var matrixm = matrix.m;
    var a = matrixm[0],
        b = matrixm[1],
        c = matrixm[4],
        d = matrixm[5],
        tx = matrixm[12],
        ty = matrixm[13];
    var x, x1, y, y1;
    var floatsPerVert = this.floatsPerVert;
    var vertexOffset = 0;

    for (var yindex = 0, ylength = row; yindex < ylength; ++yindex) {
      y = localY[yindex];
      y1 = localY[yindex + 1];

      for (var xindex = 0, xlength = col; xindex < xlength; ++xindex) {
        x = localX[xindex];
        x1 = localX[xindex + 1]; // lb

        world[vertexOffset] = x * a + y * c + tx;
        world[vertexOffset + 1] = x * b + y * d + ty;
        vertexOffset += floatsPerVert; // rb

        world[vertexOffset] = x1 * a + y * c + tx;
        world[vertexOffset + 1] = x1 * b + y * d + ty;
        vertexOffset += floatsPerVert; // lt

        world[vertexOffset] = x * a + y1 * c + tx;
        world[vertexOffset + 1] = x * b + y1 * d + ty;
        vertexOffset += floatsPerVert; // rt

        world[vertexOffset] = x1 * a + y1 * c + tx;
        world[vertexOffset + 1] = x1 * b + y1 * d + ty;
        vertexOffset += floatsPerVert;
      }
    }
  };

  _proto.updateUVs = function updateUVs(sprite) {
    var verts = this._renderData.vDatas[0];
    if (!verts) return;
    var frame = sprite._spriteFrame;
    var rect = frame._rect;
    var leftWidth = frame.insetLeft,
        rightWidth = frame.insetRight,
        centerWidth = rect.width - leftWidth - rightWidth,
        topHeight = frame.insetTop,
        bottomHeight = frame.insetBottom,
        centerHeight = rect.height - topHeight - bottomHeight;
    var row = this.row,
        col = this.col,
        hRepeat = this.hRepeat,
        vRepeat = this.vRepeat;
    var coefu = 0,
        coefv = 0;
    var uv = sprite.spriteFrame.uv;
    var uvSliced = sprite.spriteFrame.uvSliced;
    var rotated = sprite.spriteFrame._rotated;
    var floatsPerVert = this.floatsPerVert,
        uvOffset = this.uvOffset;

    for (var yindex = 0, ylength = row; yindex < ylength; ++yindex) {
      if (this.sizableHeight > centerHeight) {
        if (this.sizableHeight >= yindex * centerHeight) {
          coefv = 1;
        } else {
          coefv = vRepeat % 1;
        }
      } else {
        coefv = vRepeat;
      }

      for (var xindex = 0, xlength = col; xindex < xlength; ++xindex) {
        if (this.sizableWidth > centerWidth) {
          if (this.sizableWidth >= xindex * centerWidth) {
            coefu = 1;
          } else {
            coefu = hRepeat % 1;
          }
        } else {
          coefu = hRepeat;
        } // UV


        if (rotated) {
          // lb
          verts[uvOffset] = uv[0];
          verts[uvOffset + 1] = uv[1];
          uvOffset += floatsPerVert; // rb

          verts[uvOffset] = uv[0];
          verts[uvOffset + 1] = uv[1] + (uv[7] - uv[1]) * coefu;
          uvOffset += floatsPerVert; // lt

          verts[uvOffset] = uv[0] + (uv[6] - uv[0]) * coefv;
          verts[uvOffset + 1] = uv[1];
          uvOffset += floatsPerVert; // rt

          verts[uvOffset] = verts[uvOffset - floatsPerVert];
          verts[uvOffset + 1] = verts[uvOffset + 1 - floatsPerVert * 2];
          uvOffset += floatsPerVert;
        } else {
          // lb
          if (xindex === 0) {
            verts[uvOffset] = uv[0];
          } else if (xindex > 0 && xindex < col - 1) {
            verts[uvOffset] = uvSliced[1].u;
          } else if (xindex === col - 1) {
            verts[uvOffset] = uvSliced[2].u;
          }

          if (yindex === 0) {
            verts[uvOffset + 1] = uvSliced[0].v;
          } else if (yindex > 0 && yindex < row - 1) {
            verts[uvOffset + 1] = uvSliced[4].v;
          } else if (yindex === row - 1) {
            verts[uvOffset + 1] = uvSliced[8].v;
          }

          uvOffset += floatsPerVert; // rb

          if (xindex === 0) {
            verts[uvOffset] = uvSliced[1].u + (uvSliced[2].u - uvSliced[1].u) * coefu;
          } else if (xindex > 0 && xindex < col - 1) {
            verts[uvOffset] = uvSliced[1].u + (uvSliced[2].u - uvSliced[1].u) * coefu;
          } else if (xindex === col - 1) {
            verts[uvOffset] = uvSliced[3].u;
          }

          if (yindex === 0) {
            verts[uvOffset + 1] = uvSliced[0].v;
          } else if (yindex > 0 && yindex < row - 1) {
            verts[uvOffset + 1] = uvSliced[4].v;
          } else if (yindex === row - 1) {
            verts[uvOffset + 1] = uvSliced[8].v;
          }

          uvOffset += floatsPerVert; // lt

          if (xindex === 0) {
            verts[uvOffset] = uv[0];
          } else if (xindex > 0 && xindex < col - 1) {
            verts[uvOffset] = uvSliced[1].u;
          } else if (xindex === col - 1) {
            verts[uvOffset] = uvSliced[2].u;
          }

          if (yindex === 0) {
            verts[uvOffset + 1] = uvSliced[4].v + (uvSliced[8].v - uvSliced[4].v) * coefv;
          } else if (yindex > 0 && yindex < row - 1) {
            verts[uvOffset + 1] = uvSliced[4].v + (uvSliced[8].v - uvSliced[4].v) * coefv;
          } else if (yindex === row - 1) {
            verts[uvOffset + 1] = uvSliced[12].v;
          }

          uvOffset += floatsPerVert; // rt

          verts[uvOffset] = verts[uvOffset - floatsPerVert * 2];
          verts[uvOffset + 1] = verts[uvOffset + 1 - floatsPerVert];
          uvOffset += floatsPerVert;
        }
      }
    }
  };

  return TiledAssembler;
}(_assembler2d["default"]);

exports["default"] = TiledAssembler;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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