
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/webgl/assemblers/sprite/2d/sliced.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _assembler2d = _interopRequireDefault(require("../../../../assembler-2d"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var SlicedAssembler =
/*#__PURE__*/
function (_Assembler2D) {
  _inheritsLoose(SlicedAssembler, _Assembler2D);

  function SlicedAssembler() {
    return _Assembler2D.apply(this, arguments) || this;
  }

  var _proto = SlicedAssembler.prototype;

  _proto.initData = function initData(sprite) {
    if (this._renderData.meshCount > 0) return;

    this._renderData.createData(0, this.verticesFloats, this.indicesCount);

    var indices = this._renderData.iDatas[0];
    var indexOffset = 0;

    for (var r = 0; r < 3; ++r) {
      for (var c = 0; c < 3; ++c) {
        var start = r * 4 + c;
        indices[indexOffset++] = start;
        indices[indexOffset++] = start + 1;
        indices[indexOffset++] = start + 4;
        indices[indexOffset++] = start + 1;
        indices[indexOffset++] = start + 5;
        indices[indexOffset++] = start + 4;
      }
    }
  };

  _proto.initLocal = function initLocal() {
    this._local = [];
    this._local.length = 8;
  };

  _proto.updateRenderData = function updateRenderData(sprite) {
    var frame = sprite._spriteFrame;
    this.packToDynamicAtlas(sprite, frame);

    if (sprite._vertsDirty) {
      this.updateUVs(sprite);
      this.updateVerts(sprite);
      sprite._vertsDirty = false;
    }
  };

  _proto.updateVerts = function updateVerts(sprite) {
    var node = sprite.node,
        width = node.width,
        height = node.height,
        appx = node.anchorX * width,
        appy = node.anchorY * height;
    var frame = sprite.spriteFrame;
    var leftWidth = frame.insetLeft;
    var rightWidth = frame.insetRight;
    var topHeight = frame.insetTop;
    var bottomHeight = frame.insetBottom;
    var sizableWidth = width - leftWidth - rightWidth;
    var sizableHeight = height - topHeight - bottomHeight;
    var xScale = width / (leftWidth + rightWidth);
    var yScale = height / (topHeight + bottomHeight);
    xScale = isNaN(xScale) || xScale > 1 ? 1 : xScale;
    yScale = isNaN(yScale) || yScale > 1 ? 1 : yScale;
    sizableWidth = sizableWidth < 0 ? 0 : sizableWidth;
    sizableHeight = sizableHeight < 0 ? 0 : sizableHeight; // update local

    var local = this._local;
    local[0] = -appx;
    local[1] = -appy;
    local[2] = leftWidth * xScale - appx;
    local[3] = bottomHeight * yScale - appy;
    local[4] = local[2] + sizableWidth;
    local[5] = local[3] + sizableHeight;
    local[6] = width - appx;
    local[7] = height - appy;
    this.updateWorldVerts(sprite);
  };

  _proto.updateUVs = function updateUVs(sprite) {
    var verts = this._renderData.vDatas[0];
    var uvSliced = sprite.spriteFrame.uvSliced;
    var uvOffset = this.uvOffset;
    var floatsPerVert = this.floatsPerVert;

    for (var row = 0; row < 4; ++row) {
      for (var col = 0; col < 4; ++col) {
        var vid = row * 4 + col;
        var uv = uvSliced[vid];
        var voffset = vid * floatsPerVert;
        verts[voffset + uvOffset] = uv.u;
        verts[voffset + uvOffset + 1] = uv.v;
      }
    }
  };

  _proto.updateWorldVerts = function updateWorldVerts(sprite) {
    var matrix = sprite.node._worldMatrix;
    var matrixm = matrix.m,
        a = matrixm[0],
        b = matrixm[1],
        c = matrixm[4],
        d = matrixm[5],
        tx = matrixm[12],
        ty = matrixm[13];
    var local = this._local;
    var world = this._renderData.vDatas[0];
    var floatsPerVert = this.floatsPerVert;

    for (var row = 0; row < 4; ++row) {
      var localRowY = local[row * 2 + 1];

      for (var col = 0; col < 4; ++col) {
        var localColX = local[col * 2];
        var worldIndex = (row * 4 + col) * floatsPerVert;
        world[worldIndex] = localColX * a + localRowY * c + tx;
        world[worldIndex + 1] = localColX * b + localRowY * d + ty;
      }
    }
  };

  return SlicedAssembler;
}(_assembler2d["default"]);

exports["default"] = SlicedAssembler;
Object.assign(SlicedAssembler.prototype, {
  verticesCount: 16,
  indicesCount: 54
});
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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