
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/webgl/assemblers/sprite/2d/radial-filled.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _assembler2d = _interopRequireDefault(require("../../../../assembler-2d"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var PI_2 = Math.PI * 2;
var _vertPos = [cc.v2(0, 0), cc.v2(0, 0), cc.v2(0, 0), cc.v2(0, 0)];
var _vertices = [0, 0, 0, 0];
var _uvs = [0, 0, 0, 0, 0, 0, 0, 0];
var _intersectPoint_1 = [cc.v2(0, 0), cc.v2(0, 0), cc.v2(0, 0), cc.v2(0, 0)];
var _intersectPoint_2 = [cc.v2(0, 0), cc.v2(0, 0), cc.v2(0, 0), cc.v2(0, 0)];

var _center = cc.v2(0, 0);

var _triangles = [];

function _calcInsectedPoints(left, right, bottom, top, center, angle, intersectPoints) {
  //left bottom, right, top
  var sinAngle = Math.sin(angle);
  var cosAngle = Math.cos(angle);
  var tanAngle, cotAngle;

  if (Math.cos(angle) !== 0) {
    tanAngle = sinAngle / cosAngle; //calculate right and left

    if ((left - center.x) * cosAngle > 0) {
      var yleft = center.y + tanAngle * (left - center.x);
      intersectPoints[0].x = left;
      intersectPoints[0].y = yleft;
    }

    if ((right - center.x) * cosAngle > 0) {
      var yright = center.y + tanAngle * (right - center.x);
      intersectPoints[2].x = right;
      intersectPoints[2].y = yright;
    }
  }

  if (Math.sin(angle) !== 0) {
    cotAngle = cosAngle / sinAngle; //calculate  top and bottom

    if ((top - center.y) * sinAngle > 0) {
      var xtop = center.x + cotAngle * (top - center.y);
      intersectPoints[3].x = xtop;
      intersectPoints[3].y = top;
    }

    if ((bottom - center.y) * sinAngle > 0) {
      var xbottom = center.x + cotAngle * (bottom - center.y);
      intersectPoints[1].x = xbottom;
      intersectPoints[1].y = bottom;
    }
  }
}

function _calculateVertices(sprite) {
  var node = sprite.node,
      width = node.width,
      height = node.height,
      appx = node.anchorX * width,
      appy = node.anchorY * height;
  var l = -appx,
      b = -appy,
      r = width - appx,
      t = height - appy;
  var vertices = _vertices;
  vertices[0] = l;
  vertices[1] = b;
  vertices[2] = r;
  vertices[3] = t;
  var fillCenter = sprite._fillCenter,
      cx = _center.x = Math.min(Math.max(0, fillCenter.x), 1) * (r - l) + l,
      cy = _center.y = Math.min(Math.max(0, fillCenter.y), 1) * (t - b) + b;
  _vertPos[0].x = _vertPos[3].x = l;
  _vertPos[1].x = _vertPos[2].x = r;
  _vertPos[0].y = _vertPos[1].y = b;
  _vertPos[2].y = _vertPos[3].y = t;
  _triangles.length = 0;

  if (cx !== vertices[0]) {
    _triangles[0] = [3, 0];
  }

  if (cx !== vertices[2]) {
    _triangles[2] = [1, 2];
  }

  if (cy !== vertices[1]) {
    _triangles[1] = [0, 1];
  }

  if (cy !== vertices[3]) {
    _triangles[3] = [2, 3];
  }
}

function _calculateUVs(spriteFrame) {
  var atlasWidth = spriteFrame._texture.width;
  var atlasHeight = spriteFrame._texture.height;
  var textureRect = spriteFrame._rect;
  var u0, u1, v0, v1;
  var uvs = _uvs;

  if (spriteFrame._rotated) {
    u0 = textureRect.x / atlasWidth;
    u1 = (textureRect.x + textureRect.height) / atlasWidth;
    v0 = textureRect.y / atlasHeight;
    v1 = (textureRect.y + textureRect.width) / atlasHeight;
    uvs[0] = uvs[2] = u0;
    uvs[4] = uvs[6] = u1;
    uvs[3] = uvs[7] = v1;
    uvs[1] = uvs[5] = v0;
  } else {
    u0 = textureRect.x / atlasWidth;
    u1 = (textureRect.x + textureRect.width) / atlasWidth;
    v0 = textureRect.y / atlasHeight;
    v1 = (textureRect.y + textureRect.height) / atlasHeight;
    uvs[0] = uvs[4] = u0;
    uvs[2] = uvs[6] = u1;
    uvs[1] = uvs[3] = v1;
    uvs[5] = uvs[7] = v0;
  }
}

function _getVertAngle(start, end) {
  var placementX, placementY;
  placementX = end.x - start.x;
  placementY = end.y - start.y;

  if (placementX === 0 && placementY === 0) {
    return undefined;
  } else if (placementX === 0) {
    if (placementY > 0) {
      return Math.PI * 0.5;
    } else {
      return Math.PI * 1.5;
    }
  } else {
    var angle = Math.atan(placementY / placementX);

    if (placementX < 0) {
      angle += Math.PI;
    }

    return angle;
  }
}

var RadialFilledAssembler =
/*#__PURE__*/
function (_Assembler2D) {
  _inheritsLoose(RadialFilledAssembler, _Assembler2D);

  function RadialFilledAssembler() {
    return _Assembler2D.apply(this, arguments) || this;
  }

  var _proto = RadialFilledAssembler.prototype;

  _proto.initData = function initData(sprite) {
    this._renderData.createFlexData(0, 4, 6, this.getVfmt());

    this.updateIndices();
  };

  _proto.updateRenderData = function updateRenderData(sprite) {
    _Assembler2D.prototype.updateRenderData.call(this, sprite);

    var frame = sprite.spriteFrame;
    this.packToDynamicAtlas(sprite, frame);

    if (sprite._vertsDirty) {
      var fillStart = sprite._fillStart;
      var fillRange = sprite._fillRange;

      if (fillRange < 0) {
        fillStart += fillRange;
        fillRange = -fillRange;
      } //do round fill start [0,1), include 0, exclude 1


      while (fillStart >= 1.0) {
        fillStart -= 1.0;
      }

      while (fillStart < 0.0) {
        fillStart += 1.0;
      }

      fillStart *= PI_2;
      fillRange *= PI_2; //build vertices

      _calculateVertices(sprite); //build uvs


      _calculateUVs(frame);

      _calcInsectedPoints(_vertices[0], _vertices[2], _vertices[1], _vertices[3], _center, fillStart, _intersectPoint_1);

      _calcInsectedPoints(_vertices[0], _vertices[2], _vertices[1], _vertices[3], _center, fillStart + fillRange, _intersectPoint_2);

      this.updateVerts(sprite, fillStart, fillRange);
      sprite._vertsDirty = false;
    }
  };

  _proto.updateVerts = function updateVerts(sprite, fillStart, fillRange) {
    var fillEnd = fillStart + fillRange;
    var local = this._local;
    local.length = 0;
    var offset = 0;
    var floatsPerTriangle = 3 * this.floatsPerVert;

    for (var triangleIndex = 0; triangleIndex < 4; ++triangleIndex) {
      var triangle = _triangles[triangleIndex];

      if (!triangle) {
        continue;
      } //all in


      if (fillRange >= PI_2) {
        local.length = offset + floatsPerTriangle;

        this._generateTriangle(local, offset, _center, _vertPos[triangle[0]], _vertPos[triangle[1]]);

        offset += floatsPerTriangle;
        continue;
      } //test against


      var startAngle = _getVertAngle(_center, _vertPos[triangle[0]]);

      var endAngle = _getVertAngle(_center, _vertPos[triangle[1]]);

      if (endAngle < startAngle) endAngle += PI_2;
      startAngle -= PI_2;
      endAngle -= PI_2; //testing

      for (var testIndex = 0; testIndex < 3; ++testIndex) {
        if (startAngle >= fillEnd) {//all out
        } else if (startAngle >= fillStart) {
          local.length = offset + floatsPerTriangle;

          if (endAngle >= fillEnd) {
            //startAngle to fillEnd
            this._generateTriangle(local, offset, _center, _vertPos[triangle[0]], _intersectPoint_2[triangleIndex]);
          } else {
            //startAngle to endAngle
            this._generateTriangle(local, offset, _center, _vertPos[triangle[0]], _vertPos[triangle[1]]);
          }

          offset += floatsPerTriangle;
        } else {
          //startAngle < fillStart
          if (endAngle <= fillStart) {//all out
          } else if (endAngle <= fillEnd) {
            local.length = offset + floatsPerTriangle; //fillStart to endAngle

            this._generateTriangle(local, offset, _center, _intersectPoint_1[triangleIndex], _vertPos[triangle[1]]);

            offset += floatsPerTriangle;
          } else {
            local.length = offset + floatsPerTriangle; //fillStart to fillEnd

            this._generateTriangle(local, offset, _center, _intersectPoint_1[triangleIndex], _intersectPoint_2[triangleIndex]);

            offset += floatsPerTriangle;
          }
        } //add 2 * PI


        startAngle += PI_2;
        endAngle += PI_2;
      }
    }

    this.allocWorldVerts(sprite);
    this.updateWorldVerts(sprite);
  };

  _proto.allocWorldVerts = function allocWorldVerts(sprite) {
    var color = sprite.node._color._val;
    var renderData = this._renderData;
    var floatsPerVert = this.floatsPerVert;
    var local = this._local;
    var verticesCount = local.length / floatsPerVert;
    this.verticesCount = this.indicesCount = verticesCount;
    var flexBuffer = renderData._flexBuffer;

    if (flexBuffer.reserve(verticesCount, verticesCount)) {
      this.updateIndices();
    }

    flexBuffer.used(this.verticesCount, this.indicesCount);
    var verts = renderData.vDatas[0],
        uintVerts = renderData.uintVDatas[0];
    var uvOffset = this.uvOffset;

    for (var offset = 0; offset < local.length; offset += floatsPerVert) {
      var start = offset + uvOffset;
      verts[start] = local[start];
      verts[start + 1] = local[start + 1];
      uintVerts[start + 2] = color;
    }
  };

  _proto.updateIndices = function updateIndices() {
    var iData = this._renderData.iDatas[0];

    for (var i = 0; i < iData.length; i++) {
      iData[i] = i;
    }
  };

  _proto.updateWorldVerts = function updateWorldVerts(sprite) {
    var node = sprite.node;
    var matrix = node._worldMatrix;
    var matrixm = matrix.m,
        a = matrixm[0],
        b = matrixm[1],
        c = matrixm[4],
        d = matrixm[5],
        tx = matrixm[12],
        ty = matrixm[13];
    var local = this._local;
    var world = this._renderData.vDatas[0];
    var floatsPerVert = this.floatsPerVert;

    for (var offset = 0; offset < local.length; offset += floatsPerVert) {
      var x = local[offset];
      var y = local[offset + 1];
      world[offset] = x * a + y * c + tx;
      world[offset + 1] = x * b + y * d + ty;
    }
  };

  _proto._generateTriangle = function _generateTriangle(verts, offset, vert0, vert1, vert2) {
    var vertices = _vertices;
    var v0x = vertices[0];
    var v0y = vertices[1];
    var v1x = vertices[2];
    var v1y = vertices[3];
    var floatsPerVert = this.floatsPerVert;
    verts[offset] = vert0.x;
    verts[offset + 1] = vert0.y;
    verts[offset + floatsPerVert] = vert1.x;
    verts[offset + floatsPerVert + 1] = vert1.y;
    verts[offset + floatsPerVert * 2] = vert2.x;
    verts[offset + floatsPerVert * 2 + 1] = vert2.y;
    var uvOffset = this.uvOffset;
    var progressX, progressY;
    progressX = (vert0.x - v0x) / (v1x - v0x);
    progressY = (vert0.y - v0y) / (v1y - v0y);

    this._generateUV(progressX, progressY, verts, offset + uvOffset);

    progressX = (vert1.x - v0x) / (v1x - v0x);
    progressY = (vert1.y - v0y) / (v1y - v0y);

    this._generateUV(progressX, progressY, verts, offset + floatsPerVert + uvOffset);

    progressX = (vert2.x - v0x) / (v1x - v0x);
    progressY = (vert2.y - v0y) / (v1y - v0y);

    this._generateUV(progressX, progressY, verts, offset + floatsPerVert * 2 + uvOffset);
  };

  _proto._generateUV = function _generateUV(progressX, progressY, verts, offset) {
    var uvs = _uvs;
    var px1 = uvs[0] + (uvs[2] - uvs[0]) * progressX;
    var px2 = uvs[4] + (uvs[6] - uvs[4]) * progressX;
    var py1 = uvs[1] + (uvs[3] - uvs[1]) * progressX;
    var py2 = uvs[5] + (uvs[7] - uvs[5]) * progressX;
    verts[offset] = px1 + (px2 - px1) * progressY;
    verts[offset + 1] = py1 + (py2 - py1) * progressY;
  };

  return RadialFilledAssembler;
}(_assembler2d["default"]);

exports["default"] = RadialFilledAssembler;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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