
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/webgl/assemblers/sprite/2d/bar-filled.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _assembler2d = _interopRequireDefault(require("../../../../assembler-2d"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var Sprite = require('../../../../../components/CCSprite');

var FillType = Sprite.FillType;

var BarFilledAssembler =
/*#__PURE__*/
function (_Assembler2D) {
  _inheritsLoose(BarFilledAssembler, _Assembler2D);

  function BarFilledAssembler() {
    return _Assembler2D.apply(this, arguments) || this;
  }

  var _proto = BarFilledAssembler.prototype;

  _proto.updateRenderData = function updateRenderData(sprite) {
    var frame = sprite._spriteFrame;
    this.packToDynamicAtlas(sprite, frame);

    if (!sprite._vertsDirty) {
      return;
    }

    var fillStart = sprite._fillStart;
    var fillRange = sprite._fillRange;

    if (fillRange < 0) {
      fillStart += fillRange;
      fillRange = -fillRange;
    }

    fillRange = fillStart + fillRange;
    fillStart = fillStart > 1.0 ? 1.0 : fillStart;
    fillStart = fillStart < 0.0 ? 0.0 : fillStart;
    fillRange = fillRange > 1.0 ? 1.0 : fillRange;
    fillRange = fillRange < 0.0 ? 0.0 : fillRange;
    fillRange = fillRange - fillStart;
    fillRange = fillRange < 0 ? 0 : fillRange;
    var fillEnd = fillStart + fillRange;
    fillEnd = fillEnd > 1 ? 1 : fillEnd;
    this.updateUVs(sprite, fillStart, fillEnd);
    this.updateVerts(sprite, fillStart, fillEnd);
    sprite._vertsDirty = false;
  };

  _proto.updateUVs = function updateUVs(sprite, fillStart, fillEnd) {
    var spriteFrame = sprite._spriteFrame; //build uvs

    var atlasWidth = spriteFrame._texture.width;
    var atlasHeight = spriteFrame._texture.height;
    var textureRect = spriteFrame._rect; //uv computation should take spritesheet into account.

    var ul, vb, ur, vt;
    var quadUV0, quadUV1, quadUV2, quadUV3, quadUV4, quadUV5, quadUV6, quadUV7;

    if (spriteFrame._rotated) {
      ul = textureRect.x / atlasWidth;
      vb = (textureRect.y + textureRect.width) / atlasHeight;
      ur = (textureRect.x + textureRect.height) / atlasWidth;
      vt = textureRect.y / atlasHeight;
      quadUV0 = quadUV2 = ul;
      quadUV4 = quadUV6 = ur;
      quadUV3 = quadUV7 = vb;
      quadUV1 = quadUV5 = vt;
    } else {
      ul = textureRect.x / atlasWidth;
      vb = (textureRect.y + textureRect.height) / atlasHeight;
      ur = (textureRect.x + textureRect.width) / atlasWidth;
      vt = textureRect.y / atlasHeight;
      quadUV0 = quadUV4 = ul;
      quadUV2 = quadUV6 = ur;
      quadUV1 = quadUV3 = vb;
      quadUV5 = quadUV7 = vt;
    }

    var verts = this._renderData.vDatas[0];
    var uvOffset = this.uvOffset;
    var floatsPerVert = this.floatsPerVert;

    switch (sprite._fillType) {
      case FillType.HORIZONTAL:
        verts[uvOffset] = quadUV0 + (quadUV2 - quadUV0) * fillStart;
        verts[uvOffset + 1] = quadUV1 + (quadUV3 - quadUV1) * fillStart;
        verts[uvOffset + floatsPerVert] = quadUV0 + (quadUV2 - quadUV0) * fillEnd;
        verts[uvOffset + floatsPerVert + 1] = quadUV1 + (quadUV3 - quadUV1) * fillEnd;
        verts[uvOffset + floatsPerVert * 2] = quadUV4 + (quadUV6 - quadUV4) * fillStart;
        verts[uvOffset + floatsPerVert * 2 + 1] = quadUV5 + (quadUV7 - quadUV5) * fillStart;
        verts[uvOffset + floatsPerVert * 3] = quadUV4 + (quadUV6 - quadUV4) * fillEnd;
        verts[uvOffset + floatsPerVert * 3 + 1] = quadUV5 + (quadUV7 - quadUV5) * fillEnd;
        break;

      case FillType.VERTICAL:
        verts[uvOffset] = quadUV0 + (quadUV4 - quadUV0) * fillStart;
        verts[uvOffset + 1] = quadUV1 + (quadUV5 - quadUV1) * fillStart;
        verts[uvOffset + floatsPerVert] = quadUV2 + (quadUV6 - quadUV2) * fillStart;
        verts[uvOffset + floatsPerVert + 1] = quadUV3 + (quadUV7 - quadUV3) * fillStart;
        verts[uvOffset + floatsPerVert * 2] = quadUV0 + (quadUV4 - quadUV0) * fillEnd;
        verts[uvOffset + floatsPerVert * 2 + 1] = quadUV1 + (quadUV5 - quadUV1) * fillEnd;
        verts[uvOffset + floatsPerVert * 3] = quadUV2 + (quadUV6 - quadUV2) * fillEnd;
        verts[uvOffset + floatsPerVert * 3 + 1] = quadUV3 + (quadUV7 - quadUV3) * fillEnd;
        break;

      default:
        cc.errorID(2626);
        break;
    }
  };

  _proto.updateVerts = function updateVerts(sprite, fillStart, fillEnd) {
    var node = sprite.node,
        width = node.width,
        height = node.height,
        appx = node.anchorX * width,
        appy = node.anchorY * height;
    var l = -appx,
        b = -appy,
        r = width - appx,
        t = height - appy;
    var progressStart, progressEnd;

    switch (sprite._fillType) {
      case FillType.HORIZONTAL:
        progressStart = l + (r - l) * fillStart;
        progressEnd = l + (r - l) * fillEnd;
        l = progressStart;
        r = progressEnd;
        break;

      case FillType.VERTICAL:
        progressStart = b + (t - b) * fillStart;
        progressEnd = b + (t - b) * fillEnd;
        b = progressStart;
        t = progressEnd;
        break;

      default:
        cc.errorID(2626);
        break;
    }

    var local = this._local;
    local[0] = l;
    local[1] = b;
    local[2] = r;
    local[3] = t;
    this.updateWorldVerts(sprite);
  };

  return BarFilledAssembler;
}(_assembler2d["default"]);

exports["default"] = BarFilledAssembler;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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