
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/webgl/assemblers/motion-streak.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _assembler2d = _interopRequireDefault(require("../../assembler-2d"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var MotionStreak = require('../../../components/CCMotionStreak');

var RenderFlow = require('../../render-flow');

function Point(point, dir) {
  this.point = point || cc.v2();
  this.dir = dir || cc.v2();
  this.distance = 0;
  this.time = 0;
}

Point.prototype.setPoint = function (x, y) {
  this.point.x = x;
  this.point.y = y;
};

Point.prototype.setDir = function (x, y) {
  this.dir.x = x;
  this.dir.y = y;
};

var _tangent = cc.v2();

var _miter = cc.v2();

var _normal = cc.v2();

var _vec2 = cc.v2();

function normal(out, dir) {
  //get perpendicular
  out.x = -dir.y;
  out.y = dir.x;
  return out;
}

function computeMiter(miter, lineA, lineB, halfThick, maxMultiple) {
  //get tangent line
  lineA.add(lineB, _tangent);

  _tangent.normalizeSelf(); //get miter as a unit vector


  miter.x = -_tangent.y;
  miter.y = _tangent.x;
  _vec2.x = -lineA.y;
  _vec2.y = lineA.x; //get the necessary length of our miter

  var multiple = 1 / miter.dot(_vec2);

  if (maxMultiple) {
    multiple = Math.min(multiple, maxMultiple);
  }

  return halfThick * multiple;
}

var MotionStreakAssembler =
/*#__PURE__*/
function (_Assembler2D) {
  _inheritsLoose(MotionStreakAssembler, _Assembler2D);

  function MotionStreakAssembler() {
    return _Assembler2D.apply(this, arguments) || this;
  }

  var _proto = MotionStreakAssembler.prototype;

  _proto.initData = function initData() {
    this._renderData.createFlexData(0, 16, (16 - 2) * 3);
  };

  _proto.update = function update(comp, dt) {
    if (CC_EDITOR && !comp.preview) return;
    var stroke = comp._stroke / 2;
    var node = comp.node;
    var matrix = node._worldMatrix.m;
    var tx = matrix[12],
        ty = matrix[13];
    var points = comp._points;
    var cur;

    if (points.length > 1) {
      var difx = points[0].point.x - tx;
      var dify = points[0].point.y - ty;

      if (difx * difx + dify * dify < comp.minSeg) {
        cur = points[0];
      }
    }

    if (!cur) {
      cur = new Point();
      points.splice(0, 0, cur);
    }

    cur.setPoint(tx, ty);
    cur.time = comp._fadeTime + dt;
    var verticesCount = 0;
    var indicesCount = 0;

    if (points.length < 2) {
      return;
    }

    var color = comp._color,
        cr = color.r,
        cg = color.g,
        cb = color.b,
        ca = color.a;
    var prev = points[1];
    prev.distance = cur.point.sub(prev.point, _vec2).mag();

    _vec2.normalizeSelf();

    prev.setDir(_vec2.x, _vec2.y);
    cur.setDir(_vec2.x, _vec2.y);
    var flexBuffer = this._renderData._flexBuffer;
    flexBuffer.reserve(points.length * 2, (points.length - 1) * 6);
    var vData = flexBuffer.vData;
    var uintVData = flexBuffer.uintVData;
    var vertsOffset = 5;
    var fadeTime = comp._fadeTime;
    var findLast = false;

    for (var i = points.length - 1; i >= 0; i--) {
      var p = points[i];
      var point = p.point;
      var dir = p.dir;
      p.time -= dt;

      if (p.time < 0) {
        points.splice(i, 1);
        continue;
      }

      var progress = p.time / fadeTime;
      var next = points[i - 1];

      if (!findLast) {
        if (!next) {
          points.splice(i, 1);
          continue;
        }

        point.x = next.point.x - dir.x * progress;
        point.y = next.point.y - dir.y * progress;
      }

      findLast = true;
      normal(_normal, dir);
      var da = progress * ca;
      var c = (da << 24 >>> 0) + (cb << 16) + (cg << 8) + cr;
      var offset = verticesCount * vertsOffset;
      vData[offset] = point.x + _normal.x * stroke;
      vData[offset + 1] = point.y + _normal.y * stroke;
      vData[offset + 2] = 1;
      vData[offset + 3] = progress;
      uintVData[offset + 4] = c;
      offset += vertsOffset;
      vData[offset] = point.x - _normal.x * stroke;
      vData[offset + 1] = point.y - _normal.y * stroke;
      vData[offset + 2] = 0;
      vData[offset + 3] = progress;
      uintVData[offset + 4] = c;
      verticesCount += 2;
    }

    indicesCount = verticesCount <= 2 ? 0 : (verticesCount - 2) * 3;
    flexBuffer.used(verticesCount, indicesCount);
  };

  _proto.fillBuffers = function fillBuffers(comp, renderer) {
    var _this$_renderData$_fl = this._renderData._flexBuffer,
        vData = _this$_renderData$_fl.vData,
        usedVertices = _this$_renderData$_fl.usedVertices,
        usedIndices = _this$_renderData$_fl.usedIndices,
        usedVerticesFloats = _this$_renderData$_fl.usedVerticesFloats;
    var buffer = renderer._meshBuffer;
    var offsetInfo = buffer.request(usedVertices, usedIndices); // buffer data may be realloc, need get reference after request.
    // fill vertices

    var vertexOffset = offsetInfo.byteOffset >> 2,
        vbuf = buffer._vData;

    if (vData.length + vertexOffset > vbuf.length) {
      vbuf.set(vData.subarray(0, usedVerticesFloats), vertexOffset);
    } else {
      vbuf.set(vData, vertexOffset);
    } // fill indices


    var ibuf = buffer._iData,
        indiceOffset = offsetInfo.indiceOffset,
        vertexId = offsetInfo.vertexOffset; // index buffer

    for (var i = 0, l = usedVertices; i < l; i += 2) {
      var start = vertexId + i;
      ibuf[indiceOffset++] = start;
      ibuf[indiceOffset++] = start + 2;
      ibuf[indiceOffset++] = start + 1;
      ibuf[indiceOffset++] = start + 1;
      ibuf[indiceOffset++] = start + 2;
      ibuf[indiceOffset++] = start + 3;
    }

    comp.node._renderFlag |= RenderFlow.FLAG_UPDATE_RENDER_DATA;
  };

  return MotionStreakAssembler;
}(_assembler2d["default"]);

exports["default"] = MotionStreakAssembler;
MotionStreakAssembler.register(MotionStreak, MotionStreakAssembler);
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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