
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/webgl/assemblers/mask-assembler.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports.MaskAssembler = void 0;

var _assembler = _interopRequireDefault(require("../../assembler"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var Mask = require('../../../components/CCMask');

var RenderFlow = require('../../render-flow');

var SimpleSpriteAssembler = require('./sprite/2d/simple');

var GraphicsAssembler = require('./graphics');

var gfx = require('../../../../renderer/gfx');

var vfmtPos = require('../vertex-format').vfmtPos; // todo: 8 is least Stencil depth supported by webGL device, it could be adjusted to vendor implementation value


var _maxLevel = 8; // Current mask

var _maskStack = [];

function getWriteMask() {
  return 0x01 << _maskStack.length - 1;
}

function getStencilRef() {
  var result = 0;

  for (var i = 0; i < _maskStack.length; ++i) {
    result += 0x01 << i;
  }

  return result;
}

function applyStencil(material, func, failOp, ref, stencilMask, writeMask) {
  var effect = material.effect;
  var zFailOp = gfx.STENCIL_OP_KEEP,
      zPassOp = gfx.STENCIL_OP_KEEP;
  effect.setStencil(gfx.STENCIL_ENABLE, func, ref, stencilMask, failOp, zFailOp, zPassOp, writeMask);
}

function pushMask(mask) {
  if (_maskStack.length + 1 > _maxLevel) {
    cc.errorID(9000, _maxLevel);
  }

  _maskStack.push(mask);
}

function exitMask(mask, renderer) {
  if (_maskStack.length === 0) {
    cc.errorID(9001);
  }

  _maskStack.pop();

  if (_maskStack.length === 0) {
    renderer._flushMaterial(mask._exitMaterial);
  } else {
    enableMask(renderer);
  }
}

function applyClearMask(mask, renderer) {
  var func = gfx.DS_FUNC_NEVER;
  var ref = getWriteMask();
  var stencilMask = ref;
  var writeMask = ref;
  var failOp = mask.inverted ? gfx.STENCIL_OP_REPLACE : gfx.STENCIL_OP_ZERO;
  applyStencil(mask._clearMaterial, func, failOp, ref, stencilMask, writeMask);
  var buffer = renderer.getBuffer('mesh', vfmtPos);
  var offsetInfo = buffer.request(4, 6);
  var indiceOffset = offsetInfo.indiceOffset,
      vertexOffset = offsetInfo.byteOffset >> 2,
      vertexId = offsetInfo.vertexOffset,
      vbuf = buffer._vData,
      ibuf = buffer._iData;
  vbuf[vertexOffset++] = -1;
  vbuf[vertexOffset++] = -1;
  vbuf[vertexOffset++] = -1;
  vbuf[vertexOffset++] = 1;
  vbuf[vertexOffset++] = 1;
  vbuf[vertexOffset++] = 1;
  vbuf[vertexOffset++] = 1;
  vbuf[vertexOffset++] = -1;
  ibuf[indiceOffset++] = vertexId;
  ibuf[indiceOffset++] = vertexId + 3;
  ibuf[indiceOffset++] = vertexId + 1;
  ibuf[indiceOffset++] = vertexId + 1;
  ibuf[indiceOffset++] = vertexId + 3;
  ibuf[indiceOffset++] = vertexId + 2;
  renderer.node = renderer._dummyNode;
  renderer.material = mask._clearMaterial;

  renderer._flush();
}

function applyAreaMask(mask, renderer) {
  var func = gfx.DS_FUNC_NEVER;
  var ref = getWriteMask();
  var stencilMask = ref;
  var writeMask = ref;
  var failOp = mask.inverted ? gfx.STENCIL_OP_ZERO : gfx.STENCIL_OP_REPLACE;
  applyStencil(mask._materials[0], func, failOp, ref, stencilMask, writeMask); // vertex buffer

  renderer.material = mask._materials[0];

  if (mask._type === Mask.Type.IMAGE_STENCIL) {
    renderer.node = renderer._dummyNode;
    SimpleSpriteAssembler.prototype.fillBuffers.call(mask._assembler, mask, renderer);

    renderer._flush();
  } else {
    renderer.node = mask.node;
    GraphicsAssembler.prototype.fillBuffers.call(mask._graphics._assembler, mask._graphics, renderer);
  }
}

function enableMask(renderer) {
  var func = gfx.DS_FUNC_EQUAL;
  var failOp = gfx.STENCIL_OP_KEEP;
  var ref = getStencilRef();
  var stencilMask = ref;
  var writeMask = getWriteMask();
  var mask = _maskStack[_maskStack.length - 1];
  applyStencil(mask._enableMaterial, func, failOp, ref, stencilMask, writeMask);

  renderer._flushMaterial(mask._enableMaterial);
}

var MaskAssembler =
/*#__PURE__*/
function (_SimpleSpriteAssemble) {
  _inheritsLoose(MaskAssembler, _SimpleSpriteAssemble);

  function MaskAssembler() {
    return _SimpleSpriteAssemble.apply(this, arguments) || this;
  }

  var _proto = MaskAssembler.prototype;

  _proto.updateRenderData = function updateRenderData(mask) {
    if (mask._type === Mask.Type.IMAGE_STENCIL) {
      if (mask.spriteFrame) {
        SimpleSpriteAssembler.prototype.updateRenderData.call(this, mask);
      } else {
        mask.setMaterial(0, null);
      }
    } else {
      mask._graphics.setMaterial(0, mask._materials[0]);

      GraphicsAssembler.prototype.updateRenderData.call(mask._graphics._assembler, mask._graphics, mask._graphics);
    }
  };

  _proto.fillBuffers = function fillBuffers(mask, renderer) {
    // Invalid state
    if (mask._type !== Mask.Type.IMAGE_STENCIL || mask.spriteFrame) {
      // HACK: Must push mask after batch, so we can only put this logic in fillVertexBuffer or fillIndexBuffer
      pushMask(mask);
      applyClearMask(mask, renderer);
      applyAreaMask(mask, renderer);
      enableMask(renderer);
    }

    mask.node._renderFlag |= RenderFlow.FLAG_UPDATE_RENDER_DATA;
  };

  _proto.postFillBuffers = function postFillBuffers(mask, renderer) {
    // Invalid state
    if (mask._type !== Mask.Type.IMAGE_STENCIL || mask.spriteFrame) {
      // HACK: Must pop mask after batch, so we can only put this logic in fillBuffers
      exitMask(mask, renderer);
    }

    mask.node._renderFlag |= RenderFlow.FLAG_UPDATE_RENDER_DATA;
  };

  return MaskAssembler;
}(SimpleSpriteAssembler);

exports.MaskAssembler = MaskAssembler;
;

_assembler["default"].register(Mask, MaskAssembler);
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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