
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/webgl/assemblers/label/2d/bmfont.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _bmfont = _interopRequireDefault(require("../../../../utils/label/bmfont"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var _dataOffset = 0;

var WebglBmfontAssembler =
/*#__PURE__*/
function (_BmfontAssembler) {
  _inheritsLoose(WebglBmfontAssembler, _BmfontAssembler);

  function WebglBmfontAssembler() {
    return _BmfontAssembler.apply(this, arguments) || this;
  }

  var _proto = WebglBmfontAssembler.prototype;

  _proto.initData = function initData() {
    this._renderData.createFlexData(0, 4, 6, this.getVfmt());
  };

  _proto._reserveQuads = function _reserveQuads(comp, count) {
    var verticesCount = count * 4;
    var indicesCount = count * 6;
    var flexBuffer = this._renderData._flexBuffer;
    flexBuffer.reserve(verticesCount, indicesCount);
    flexBuffer.used(verticesCount, indicesCount);
    var iData = this._renderData.iDatas[0];

    for (var i = 0, vid = 0, l = indicesCount; i < l; i += 6, vid += 4) {
      iData[i] = vid;
      iData[i + 1] = vid + 1;
      iData[i + 2] = vid + 2;
      iData[i + 3] = vid + 1;
      iData[i + 4] = vid + 3;
      iData[i + 5] = vid + 2;
    }

    _dataOffset = 0;
  };

  _proto._quadsUpdated = function _quadsUpdated(comp) {
    _dataOffset = 0;
    var flexBuffer = this._renderData._flexBuffer;
    flexBuffer.used(this.verticesCount, this.indicesCount);
  };

  _proto._getColor = function _getColor(comp) {
    return comp.node._color._val;
  };

  _proto.appendQuad = function appendQuad(comp, texture, rect, rotated, x, y, scale) {
    var renderData = this._renderData;
    var verts = renderData.vDatas[0],
        uintVerts = renderData.uintVDatas[0];
    this.verticesCount += 4;
    this.indicesCount = this.verticesCount / 2 * 3;

    var texw = texture.width,
        texh = texture.height,
        rectWidth = rect.width,
        rectHeight = rect.height,
        color = this._getColor(comp);

    var l, b, r, t;
    var floatsPerVert = this.floatsPerVert; // uvs

    var uvDataOffset = _dataOffset + this.uvOffset;

    if (!rotated) {
      l = rect.x / texw;
      r = (rect.x + rectWidth) / texw;
      b = (rect.y + rectHeight) / texh;
      t = rect.y / texh;
      verts[uvDataOffset] = l;
      verts[uvDataOffset + 1] = b;
      uvDataOffset += floatsPerVert;
      verts[uvDataOffset] = r;
      verts[uvDataOffset + 1] = b;
      uvDataOffset += floatsPerVert;
      verts[uvDataOffset] = l;
      verts[uvDataOffset + 1] = t;
      uvDataOffset += floatsPerVert;
      verts[uvDataOffset] = r;
      verts[uvDataOffset + 1] = t;
    } else {
      l = rect.x / texw;
      r = (rect.x + rectHeight) / texw;
      b = (rect.y + rectWidth) / texh;
      t = rect.y / texh;
      verts[uvDataOffset] = l;
      verts[uvDataOffset + 1] = t;
      uvDataOffset += floatsPerVert;
      verts[uvDataOffset] = l;
      verts[uvDataOffset + 1] = b;
      uvDataOffset += floatsPerVert;
      verts[uvDataOffset] = r;
      verts[uvDataOffset + 1] = t;
      uvDataOffset += floatsPerVert;
      verts[uvDataOffset] = r;
      verts[uvDataOffset + 1] = b;
    } // positions


    l = x;
    r = x + rectWidth * scale;
    b = y - rectHeight * scale;
    t = y;
    this.appendVerts(comp, _dataOffset, l, r, b, t); // colors

    var colorOffset = _dataOffset + this.colorOffset;

    for (var i = 0; i < 4; i++) {
      uintVerts[colorOffset] = color;
      colorOffset += floatsPerVert;
    }

    _dataOffset += this.floatsPerVert * 4;
  };

  _proto.appendVerts = function appendVerts(comp, offset, l, r, b, t) {
    var local = this._local;
    var floatsPerVert = this.floatsPerVert;
    local[offset] = l;
    local[offset + 1] = b;
    offset += floatsPerVert;
    local[offset] = r;
    local[offset + 1] = b;
    offset += floatsPerVert;
    local[offset] = l;
    local[offset + 1] = t;
    offset += floatsPerVert;
    local[offset] = r;
    local[offset + 1] = t;
  };

  _proto.updateWorldVerts = function updateWorldVerts(comp) {
    var node = comp.node;
    var matrix = node._worldMatrix;
    var matrixm = matrix.m,
        a = matrixm[0],
        b = matrixm[1],
        c = matrixm[4],
        d = matrixm[5],
        tx = matrixm[12],
        ty = matrixm[13];
    var local = this._local;
    var world = this._renderData.vDatas[0];
    var floatsPerVert = this.floatsPerVert;

    for (var offset = 0; offset < local.length; offset += floatsPerVert) {
      var x = local[offset];
      var y = local[offset + 1];
      world[offset] = x * a + y * c + tx;
      world[offset + 1] = x * b + y * d + ty;
    }
  };

  return WebglBmfontAssembler;
}(_bmfont["default"]);

exports["default"] = WebglBmfontAssembler;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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