
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/webgl/assemblers/graphics/impl.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

 https://www.cocos.com/

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/
var Helper = require('../../../../graphics/helper');

var PointFlags = require('../../../../graphics/types').PointFlags;

var Point = cc.Graphics.Point = cc.Class({
  name: 'cc.GraphicsPoint',
  "extends": cc.Vec2,
  ctor: function ctor(x, y) {
    this.reset();
  },
  reset: function reset() {
    this.dx = 0;
    this.dy = 0;
    this.dmx = 0;
    this.dmy = 0;
    this.flags = 0;
    this.len = 0;
  }
});

function Path() {
  this.reset();
}

cc.js.mixin(Path.prototype, {
  reset: function reset() {
    this.closed = false;
    this.nbevel = 0;
    this.complex = true;

    if (this.points) {
      this.points.length = 0;
    } else {
      this.points = [];
    }
  }
});

function Impl(graphics) {
  // inner properties
  this._tessTol = 0.25;
  this._distTol = 0.01;
  this._updatePathOffset = false;
  this._paths = null;
  this._pathLength = 0;
  this._pathOffset = 0;
  this._points = null;
  this._pointsOffset = 0;
  this._commandx = 0;
  this._commandy = 0;
  this._paths = [];
  this._points = [];
}

cc.js.mixin(Impl.prototype, {
  moveTo: function moveTo(x, y) {
    if (this._updatePathOffset) {
      this._pathOffset = this._pathLength;
      this._updatePathOffset = false;
    }

    this._addPath();

    this._addPoint(x, y, PointFlags.PT_CORNER);

    this._commandx = x;
    this._commandy = y;
  },
  lineTo: function lineTo(x, y) {
    this._addPoint(x, y, PointFlags.PT_CORNER);

    this._commandx = x;
    this._commandy = y;
  },
  bezierCurveTo: function bezierCurveTo(c1x, c1y, c2x, c2y, x, y) {
    var path = this._curPath;
    var last = path.points[path.points.length - 1];

    if (last.x === c1x && last.y === c1y && c2x === x && c2y === y) {
      this.lineTo(x, y);
      return;
    }

    Helper.tesselateBezier(this, last.x, last.y, c1x, c1y, c2x, c2y, x, y, 0, PointFlags.PT_CORNER);
    this._commandx = x;
    this._commandy = y;
  },
  quadraticCurveTo: function quadraticCurveTo(cx, cy, x, y) {
    var x0 = this._commandx;
    var y0 = this._commandy;
    this.bezierCurveTo(x0 + 2.0 / 3.0 * (cx - x0), y0 + 2.0 / 3.0 * (cy - y0), x + 2.0 / 3.0 * (cx - x), y + 2.0 / 3.0 * (cy - y), x, y);
  },
  arc: function arc(cx, cy, r, startAngle, endAngle, counterclockwise) {
    Helper.arc(this, cx, cy, r, startAngle, endAngle, counterclockwise);
  },
  ellipse: function ellipse(cx, cy, rx, ry) {
    Helper.ellipse(this, cx, cy, rx, ry);
    this._curPath.complex = false;
  },
  circle: function circle(cx, cy, r) {
    Helper.ellipse(this, cx, cy, r, r);
    this._curPath.complex = false;
  },
  rect: function rect(x, y, w, h) {
    this.moveTo(x, y);
    this.lineTo(x, y + h);
    this.lineTo(x + w, y + h);
    this.lineTo(x + w, y);
    this.close();
    this._curPath.complex = false;
  },
  roundRect: function roundRect(x, y, w, h, r) {
    Helper.roundRect(this, x, y, w, h, r);
    this._curPath.complex = false;
  },
  clear: function clear(clean) {
    this._pathLength = 0;
    this._pathOffset = 0;
    this._pointsOffset = 0;
    this._curPath = null;

    if (clean) {
      this._paths.length = 0;
      this._points.length = 0;
    }
  },
  close: function close() {
    this._curPath.closed = true;
  },
  _addPath: function _addPath() {
    var offset = this._pathLength;
    var path = this._paths[offset];

    if (!path) {
      path = new Path();

      this._paths.push(path);
    } else {
      path.reset();
    }

    this._pathLength++;
    this._curPath = path;
    return path;
  },
  _addPoint: function _addPoint(x, y, flags) {
    var path = this._curPath;
    if (!path) return;
    var pt;
    var points = this._points;
    var pathPoints = path.points;
    var offset = this._pointsOffset++;
    pt = points[offset];

    if (!pt) {
      pt = new Point(x, y);
      points.push(pt);
    } else {
      pt.x = x;
      pt.y = y;
    }

    pt.flags = flags;
    pathPoints.push(pt);
  }
});
cc.Graphics._Impl = Impl;
module.exports = Impl;
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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