
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'engine-dev/cocos2d/core/renderer/utils/label/letter-font.js';
                    var __require = nodeEnv ? function (request) {
                        return require(request);
                    } : function (request) {
                        return __quick_compile_engine__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_engine__.registerModule(__filename, module);}"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _bmfont = _interopRequireDefault(require("../../webgl/assemblers/label/2d/bmfont"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var Label = require('../../../components/CCLabel');

var LabelOutline = require('../../../components/CCLabelOutline');

var textUtils = require('../../../utils/text-utils');

var Component = require('../../../components/CCComponent');

var RenderTexture = require('../../../assets/CCRenderTexture');

var OUTLINE_SUPPORTED = cc.js.isChildClassOf(LabelOutline, Component);

var getFontFamily = require('../utils').getFontFamily;

var shareLabelInfo = require('../utils').shareLabelInfo;

var FontLetterDefinition = cc.BitmapFont.FontLetterDefinition;
var FontAtlas = cc.BitmapFont.FontAtlas;
var WHITE = cc.Color.WHITE;
var space = 0;
var bleed = 2;

var _invisibleAlpha = (1 / 255).toFixed(3);

function LetterTexture(_char, labelInfo) {
  this._texture = null;
  this._labelInfo = labelInfo;
  this._char = _char;
  this._hash = null;
  this._data = null;
  this._canvas = null;
  this._context = null;
  this._width = 0;
  this._height = 0;
  this._offsetY = 0;
  this._hash = _char.charCodeAt(0) + labelInfo.hash;
}

LetterTexture.prototype = {
  constructor: LetterTexture,
  updateRenderData: function updateRenderData() {
    this._updateProperties();

    this._updateTexture();
  },
  _updateProperties: function _updateProperties() {
    this._texture = new cc.Texture2D();
    this._data = Label._canvasPool.get();
    this._canvas = this._data.canvas;
    this._context = this._data.context;
    this._context.font = this._labelInfo.fontDesc;
    var width = textUtils.safeMeasureText(this._context, this._char, this._labelInfo.fontDesc);
    var blank = this._labelInfo.margin * 2 + bleed;
    this._width = parseFloat(width.toFixed(2)) + blank;
    this._height = (1 + textUtils.BASELINE_RATIO) * this._labelInfo.fontSize + blank;
    this._offsetY = -(this._labelInfo.fontSize * textUtils.BASELINE_RATIO) / 2;

    if (this._canvas.width !== this._width) {
      this._canvas.width = this._width;
    }

    if (this._canvas.height !== this._height) {
      this._canvas.height = this._height;
    }

    this._texture.initWithElement(this._canvas);
  },
  _updateTexture: function _updateTexture() {
    var context = this._context;
    var labelInfo = this._labelInfo,
        width = this._canvas.width,
        height = this._canvas.height;
    var startX = width / 2;
    var startY = height / 2 + this._labelInfo.fontSize * textUtils.MIDDLE_RATIO;
    var color = labelInfo.color;
    context.textAlign = 'center';
    context.textBaseline = 'alphabetic';
    context.clearRect(0, 0, width, height); //Add a white background to avoid black edges.

    context.fillStyle = "rgba(" + color.r + ", " + color.g + ", " + color.b + ", " + _invisibleAlpha + ")";
    context.fillRect(0, 0, width, height);
    context.font = labelInfo.fontDesc; //use round for line join to avoid sharp intersect point

    context.lineJoin = 'round';
    context.fillStyle = "rgba(" + color.r + ", " + color.g + ", " + color.b + ", 1)";

    if (labelInfo.isOutlined && labelInfo.margin > 0) {
      var strokeColor = labelInfo.out || WHITE;
      context.strokeStyle = "rgba(" + strokeColor.r + ", " + strokeColor.g + ", " + strokeColor.b + ", " + strokeColor.a / 255 + ")";
      context.lineWidth = labelInfo.margin * 2;
      context.strokeText(this._char, startX, startY);
    }

    context.fillText(this._char, startX, startY);

    this._texture.handleLoadedTexture();
  },
  destroy: function destroy() {
    this._texture.destroy();

    this._texture = null;

    Label._canvasPool.put(this._data);
  }
};

function LetterAtlas(width, height) {
  var texture = new RenderTexture();
  texture.initWithSize(width, height);
  texture.update();
  this._fontDefDictionary = new FontAtlas(texture);
  this._x = space;
  this._y = space;
  this._nexty = space;
  this._width = width;
  this._height = height;
  cc.director.on(cc.Director.EVENT_BEFORE_SCENE_LAUNCH, this.beforeSceneLoad, this);
}

cc.js.mixin(LetterAtlas.prototype, {
  insertLetterTexture: function insertLetterTexture(letterTexture) {
    var texture = letterTexture._texture;
    var width = texture.width,
        height = texture.height;

    if (this._x + width + space > this._width) {
      this._x = space;
      this._y = this._nexty;
    }

    if (this._y + height > this._nexty) {
      this._nexty = this._y + height + space;
    }

    if (this._nexty > this._height) {
      return null;
    }

    this._fontDefDictionary._texture.drawTextureAt(texture, this._x, this._y);

    this._dirty = true;
    var letter = new FontLetterDefinition();
    letter.u = this._x + bleed / 2;
    letter.v = this._y + bleed / 2;
    letter.texture = this._fontDefDictionary._texture;
    letter.valid = true;
    letter.w = letterTexture._width - bleed;
    letter.h = letterTexture._height - bleed;
    letter.xAdvance = letter.w;
    letter.offsetY = letterTexture._offsetY;
    this._x += width + space;

    this._fontDefDictionary.addLetterDefinitions(letterTexture._hash, letter);

    return letter;
  },
  update: function update() {
    if (!this._dirty) return;

    this._fontDefDictionary._texture.update();

    this._dirty = false;
  },
  reset: function reset() {
    this._x = space;
    this._y = space;
    this._nexty = space;
    var chars = this._fontDefDictionary._letterDefinitions;

    for (var i = 0, l = chars.length; i < l; i++) {
      var _char2 = chars[i];

      if (!_char2.isValid) {
        continue;
      }

      _char2.destroy();
    }

    this._fontDefDictionary.clear();
  },
  destroy: function destroy() {
    this.reset();

    this._fontDefDictionary._texture.destroy();

    this._fontDefDictionary._texture = null;
  },
  beforeSceneLoad: function beforeSceneLoad() {
    this.clearAllCache();
  },
  clearAllCache: function clearAllCache() {
    this.destroy();
    var texture = new RenderTexture();
    texture.initWithSize(this._width, this._height);
    texture.update();
    this._fontDefDictionary._texture = texture;
  },
  getLetter: function getLetter(key) {
    return this._fontDefDictionary._letterDefinitions[key];
  },
  getTexture: function getTexture() {
    return this._fontDefDictionary.getTexture();
  },
  getLetterDefinitionForChar: function getLetterDefinitionForChar(_char3, labelInfo) {
    var hash = _char3.charCodeAt(0) + labelInfo.hash;
    var letter = this._fontDefDictionary._letterDefinitions[hash];

    if (!letter) {
      var temp = new LetterTexture(_char3, labelInfo);
      temp.updateRenderData();
      letter = this.insertLetterTexture(temp);
      temp.destroy();
    }

    return letter;
  }
});

function computeHash(labelInfo) {
  var hashData = '';
  var color = labelInfo.color.toHEX("#rrggbb");
  var out = '';

  if (labelInfo.isOutlined && labelInfo.margin > 0) {
    out = out + labelInfo.margin + labelInfo.out.toHEX("#rrggbb");
  }

  ;
  return hashData + labelInfo.fontSize + labelInfo.fontFamily + color + out;
}

var _shareAtlas = null;
var _atlasWidth = 2048;
var _atlasHeight = 2048;
var _isBold = false;

var LetterFontAssembler =
/*#__PURE__*/
function (_WebglBmfontAssembler) {
  _inheritsLoose(LetterFontAssembler, _WebglBmfontAssembler);

  function LetterFontAssembler() {
    return _WebglBmfontAssembler.apply(this, arguments) || this;
  }

  var _proto = LetterFontAssembler.prototype;

  _proto._getAssemblerData = function _getAssemblerData() {
    if (!_shareAtlas) {
      _shareAtlas = new LetterAtlas(_atlasWidth, _atlasHeight);
      cc.Label._shareAtlas = _shareAtlas;
    }

    return _shareAtlas.getTexture();
  };

  _proto._updateFontFamily = function _updateFontFamily(comp) {
    shareLabelInfo.fontAtlas = _shareAtlas;
    shareLabelInfo.fontFamily = getFontFamily(comp); // outline

    var outline = OUTLINE_SUPPORTED && comp.getComponent(LabelOutline);

    if (outline && outline.enabled) {
      shareLabelInfo.isOutlined = true;
      shareLabelInfo.margin = outline.width;
      shareLabelInfo.out = outline.color.clone();
      shareLabelInfo.out.a = outline.color.a * comp.node.color.a / 255.0;
    } else {
      shareLabelInfo.isOutlined = false;
      shareLabelInfo.margin = 0;
    }
  };

  _proto._updateLabelInfo = function _updateLabelInfo(comp) {
    shareLabelInfo.fontDesc = this._getFontDesc();
    shareLabelInfo.color = comp.node.color;
    shareLabelInfo.hash = computeHash(shareLabelInfo);
  };

  _proto._getFontDesc = function _getFontDesc() {
    var fontDesc = shareLabelInfo.fontSize.toString() + 'px ';
    fontDesc = fontDesc + shareLabelInfo.fontFamily;

    if (_isBold) {
      fontDesc = "bold " + fontDesc;
    }

    return fontDesc;
  };

  _proto._computeHorizontalKerningForText = function _computeHorizontalKerningForText() {};

  _proto._determineRect = function _determineRect(tempRect) {
    return false;
  };

  return LetterFontAssembler;
}(_bmfont["default"]);

exports["default"] = LetterFontAssembler;
module.exports = exports["default"];
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_engine__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVuZ2luZS1kZXYvY29jb3MyZC9jb3JlL3JlbmRlcmVyL3V0aWxzL2xhYmVsL2xldHRlci1mb250LmpzIl0sIm5hbWVzIjpbIkxhYmVsIiwicmVxdWlyZSIsIkxhYmVsT3V0bGluZSIsInRleHRVdGlscyIsIkNvbXBvbmVudCIsIlJlbmRlclRleHR1cmUiLCJPVVRMSU5FX1NVUFBPUlRFRCIsImNjIiwianMiLCJpc0NoaWxkQ2xhc3NPZiIsImdldEZvbnRGYW1pbHkiLCJzaGFyZUxhYmVsSW5mbyIsIkZvbnRMZXR0ZXJEZWZpbml0aW9uIiwiQml0bWFwRm9udCIsIkZvbnRBdGxhcyIsIldISVRFIiwiQ29sb3IiLCJzcGFjZSIsImJsZWVkIiwiX2ludmlzaWJsZUFscGhhIiwidG9GaXhlZCIsIkxldHRlclRleHR1cmUiLCJjaGFyIiwibGFiZWxJbmZvIiwiX3RleHR1cmUiLCJfbGFiZWxJbmZvIiwiX2NoYXIiLCJfaGFzaCIsIl9kYXRhIiwiX2NhbnZhcyIsIl9jb250ZXh0IiwiX3dpZHRoIiwiX2hlaWdodCIsIl9vZmZzZXRZIiwiY2hhckNvZGVBdCIsImhhc2giLCJwcm90b3R5cGUiLCJjb25zdHJ1Y3RvciIsInVwZGF0ZVJlbmRlckRhdGEiLCJfdXBkYXRlUHJvcGVydGllcyIsIl91cGRhdGVUZXh0dXJlIiwiVGV4dHVyZTJEIiwiX2NhbnZhc1Bvb2wiLCJnZXQiLCJjYW52YXMiLCJjb250ZXh0IiwiZm9udCIsImZvbnREZXNjIiwid2lkdGgiLCJzYWZlTWVhc3VyZVRleHQiLCJibGFuayIsIm1hcmdpbiIsInBhcnNlRmxvYXQiLCJCQVNFTElORV9SQVRJTyIsImZvbnRTaXplIiwiaGVpZ2h0IiwiaW5pdFdpdGhFbGVtZW50Iiwic3RhcnRYIiwic3RhcnRZIiwiTUlERExFX1JBVElPIiwiY29sb3IiLCJ0ZXh0QWxpZ24iLCJ0ZXh0QmFzZWxpbmUiLCJjbGVhclJlY3QiLCJmaWxsU3R5bGUiLCJyIiwiZyIsImIiLCJmaWxsUmVjdCIsImxpbmVKb2luIiwiaXNPdXRsaW5lZCIsInN0cm9rZUNvbG9yIiwib3V0Iiwic3Ryb2tlU3R5bGUiLCJhIiwibGluZVdpZHRoIiwic3Ryb2tlVGV4dCIsImZpbGxUZXh0IiwiaGFuZGxlTG9hZGVkVGV4dHVyZSIsImRlc3Ryb3kiLCJwdXQiLCJMZXR0ZXJBdGxhcyIsInRleHR1cmUiLCJpbml0V2l0aFNpemUiLCJ1cGRhdGUiLCJfZm9udERlZkRpY3Rpb25hcnkiLCJfeCIsIl95IiwiX25leHR5IiwiZGlyZWN0b3IiLCJvbiIsIkRpcmVjdG9yIiwiRVZFTlRfQkVGT1JFX1NDRU5FX0xBVU5DSCIsImJlZm9yZVNjZW5lTG9hZCIsIm1peGluIiwiaW5zZXJ0TGV0dGVyVGV4dHVyZSIsImxldHRlclRleHR1cmUiLCJkcmF3VGV4dHVyZUF0IiwiX2RpcnR5IiwibGV0dGVyIiwidSIsInYiLCJ2YWxpZCIsInciLCJoIiwieEFkdmFuY2UiLCJvZmZzZXRZIiwiYWRkTGV0dGVyRGVmaW5pdGlvbnMiLCJyZXNldCIsImNoYXJzIiwiX2xldHRlckRlZmluaXRpb25zIiwiaSIsImwiLCJsZW5ndGgiLCJpc1ZhbGlkIiwiY2xlYXIiLCJjbGVhckFsbENhY2hlIiwiZ2V0TGV0dGVyIiwia2V5IiwiZ2V0VGV4dHVyZSIsImdldExldHRlckRlZmluaXRpb25Gb3JDaGFyIiwidGVtcCIsImNvbXB1dGVIYXNoIiwiaGFzaERhdGEiLCJ0b0hFWCIsImZvbnRGYW1pbHkiLCJfc2hhcmVBdGxhcyIsIl9hdGxhc1dpZHRoIiwiX2F0bGFzSGVpZ2h0IiwiX2lzQm9sZCIsIkxldHRlckZvbnRBc3NlbWJsZXIiLCJfZ2V0QXNzZW1ibGVyRGF0YSIsIl91cGRhdGVGb250RmFtaWx5IiwiY29tcCIsImZvbnRBdGxhcyIsIm91dGxpbmUiLCJnZXRDb21wb25lbnQiLCJlbmFibGVkIiwiY2xvbmUiLCJub2RlIiwiX3VwZGF0ZUxhYmVsSW5mbyIsIl9nZXRGb250RGVzYyIsInRvU3RyaW5nIiwiX2NvbXB1dGVIb3Jpem9udGFsS2VybmluZ0ZvclRleHQiLCJfZGV0ZXJtaW5lUmVjdCIsInRlbXBSZWN0IiwiV2ViZ2xCbWZvbnRBc3NlbWJsZXIiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7QUF5QkE7Ozs7OztBQUVBLElBQU1BLEtBQUssR0FBR0MsT0FBTyxDQUFDLDZCQUFELENBQXJCOztBQUNBLElBQU1DLFlBQVksR0FBR0QsT0FBTyxDQUFDLG9DQUFELENBQTVCOztBQUNBLElBQU1FLFNBQVMsR0FBR0YsT0FBTyxDQUFDLDJCQUFELENBQXpCOztBQUNBLElBQU1HLFNBQVMsR0FBR0gsT0FBTyxDQUFDLGlDQUFELENBQXpCOztBQUNBLElBQU1JLGFBQWEsR0FBR0osT0FBTyxDQUFDLGlDQUFELENBQTdCOztBQUNBLElBQU1LLGlCQUFpQixHQUFHQyxFQUFFLENBQUNDLEVBQUgsQ0FBTUMsY0FBTixDQUFxQlAsWUFBckIsRUFBbUNFLFNBQW5DLENBQTFCOztBQUNBLElBQU1NLGFBQWEsR0FBR1QsT0FBTyxDQUFDLFVBQUQsQ0FBUCxDQUFvQlMsYUFBMUM7O0FBQ0EsSUFBTUMsY0FBYyxHQUFHVixPQUFPLENBQUMsVUFBRCxDQUFQLENBQW9CVSxjQUEzQzs7QUFHQSxJQUFNQyxvQkFBb0IsR0FBR0wsRUFBRSxDQUFDTSxVQUFILENBQWNELG9CQUEzQztBQUNBLElBQU1FLFNBQVMsR0FBR1AsRUFBRSxDQUFDTSxVQUFILENBQWNDLFNBQWhDO0FBRUEsSUFBTUMsS0FBSyxHQUFHUixFQUFFLENBQUNTLEtBQUgsQ0FBU0QsS0FBdkI7QUFDQSxJQUFNRSxLQUFLLEdBQUcsQ0FBZDtBQUNBLElBQU1DLEtBQUssR0FBRyxDQUFkOztBQUNBLElBQU1DLGVBQWUsR0FBRyxDQUFDLElBQUksR0FBTCxFQUFVQyxPQUFWLENBQWtCLENBQWxCLENBQXhCOztBQUVBLFNBQVNDLGFBQVQsQ0FBdUJDLEtBQXZCLEVBQTZCQyxTQUE3QixFQUF3QztBQUNwQyxPQUFLQyxRQUFMLEdBQWdCLElBQWhCO0FBQ0EsT0FBS0MsVUFBTCxHQUFrQkYsU0FBbEI7QUFDQSxPQUFLRyxLQUFMLEdBQWFKLEtBQWI7QUFDQSxPQUFLSyxLQUFMLEdBQWEsSUFBYjtBQUNBLE9BQUtDLEtBQUwsR0FBYSxJQUFiO0FBQ0EsT0FBS0MsT0FBTCxHQUFlLElBQWY7QUFDQSxPQUFLQyxRQUFMLEdBQWdCLElBQWhCO0FBQ0EsT0FBS0MsTUFBTCxHQUFjLENBQWQ7QUFDQSxPQUFLQyxPQUFMLEdBQWUsQ0FBZjtBQUNBLE9BQUtDLFFBQUwsR0FBZ0IsQ0FBaEI7QUFDQSxPQUFLTixLQUFMLEdBQWFMLEtBQUksQ0FBQ1ksVUFBTCxDQUFnQixDQUFoQixJQUFxQlgsU0FBUyxDQUFDWSxJQUE1QztBQUNIOztBQUVEZCxhQUFhLENBQUNlLFNBQWQsR0FBMEI7QUFDdEJDLEVBQUFBLFdBQVcsRUFBRWhCLGFBRFM7QUFHdEJpQixFQUFBQSxnQkFIc0IsOEJBR0Y7QUFDaEIsU0FBS0MsaUJBQUw7O0FBQ0EsU0FBS0MsY0FBTDtBQUNILEdBTnFCO0FBT3RCRCxFQUFBQSxpQkFQc0IsK0JBT0Q7QUFDakIsU0FBS2YsUUFBTCxHQUFnQixJQUFJakIsRUFBRSxDQUFDa0MsU0FBUCxFQUFoQjtBQUNBLFNBQUtiLEtBQUwsR0FBYTVCLEtBQUssQ0FBQzBDLFdBQU4sQ0FBa0JDLEdBQWxCLEVBQWI7QUFDQSxTQUFLZCxPQUFMLEdBQWUsS0FBS0QsS0FBTCxDQUFXZ0IsTUFBMUI7QUFDQSxTQUFLZCxRQUFMLEdBQWdCLEtBQUtGLEtBQUwsQ0FBV2lCLE9BQTNCO0FBQ0EsU0FBS2YsUUFBTCxDQUFjZ0IsSUFBZCxHQUFxQixLQUFLckIsVUFBTCxDQUFnQnNCLFFBQXJDO0FBQ0EsUUFBSUMsS0FBSyxHQUFHN0MsU0FBUyxDQUFDOEMsZUFBVixDQUEwQixLQUFLbkIsUUFBL0IsRUFBeUMsS0FBS0osS0FBOUMsRUFBcUQsS0FBS0QsVUFBTCxDQUFnQnNCLFFBQXJFLENBQVo7QUFDQSxRQUFJRyxLQUFLLEdBQUcsS0FBS3pCLFVBQUwsQ0FBZ0IwQixNQUFoQixHQUF5QixDQUF6QixHQUE2QmpDLEtBQXpDO0FBQ0EsU0FBS2EsTUFBTCxHQUFjcUIsVUFBVSxDQUFDSixLQUFLLENBQUM1QixPQUFOLENBQWMsQ0FBZCxDQUFELENBQVYsR0FBK0I4QixLQUE3QztBQUNBLFNBQUtsQixPQUFMLEdBQWUsQ0FBQyxJQUFJN0IsU0FBUyxDQUFDa0QsY0FBZixJQUFpQyxLQUFLNUIsVUFBTCxDQUFnQjZCLFFBQWpELEdBQTRESixLQUEzRTtBQUNBLFNBQUtqQixRQUFMLEdBQWdCLEVBQUcsS0FBS1IsVUFBTCxDQUFnQjZCLFFBQWhCLEdBQTJCbkQsU0FBUyxDQUFDa0QsY0FBeEMsSUFBMEQsQ0FBMUU7O0FBRUEsUUFBSSxLQUFLeEIsT0FBTCxDQUFhbUIsS0FBYixLQUF1QixLQUFLakIsTUFBaEMsRUFBd0M7QUFDcEMsV0FBS0YsT0FBTCxDQUFhbUIsS0FBYixHQUFxQixLQUFLakIsTUFBMUI7QUFDSDs7QUFFRCxRQUFJLEtBQUtGLE9BQUwsQ0FBYTBCLE1BQWIsS0FBd0IsS0FBS3ZCLE9BQWpDLEVBQTBDO0FBQ3RDLFdBQUtILE9BQUwsQ0FBYTBCLE1BQWIsR0FBc0IsS0FBS3ZCLE9BQTNCO0FBQ0g7O0FBRUQsU0FBS1IsUUFBTCxDQUFjZ0MsZUFBZCxDQUE4QixLQUFLM0IsT0FBbkM7QUFDSCxHQTVCcUI7QUE2QnRCVyxFQUFBQSxjQTdCc0IsNEJBNkJKO0FBQ2QsUUFBSUssT0FBTyxHQUFHLEtBQUtmLFFBQW5CO0FBQ0EsUUFBSVAsU0FBUyxHQUFHLEtBQUtFLFVBQXJCO0FBQUEsUUFDSXVCLEtBQUssR0FBRyxLQUFLbkIsT0FBTCxDQUFhbUIsS0FEekI7QUFBQSxRQUVJTyxNQUFNLEdBQUcsS0FBSzFCLE9BQUwsQ0FBYTBCLE1BRjFCO0FBSUEsUUFBSUUsTUFBTSxHQUFHVCxLQUFLLEdBQUcsQ0FBckI7QUFDQSxRQUFJVSxNQUFNLEdBQUdILE1BQU0sR0FBRyxDQUFULEdBQWEsS0FBSzlCLFVBQUwsQ0FBZ0I2QixRQUFoQixHQUEyQm5ELFNBQVMsQ0FBQ3dELFlBQS9EO0FBQ0EsUUFBSUMsS0FBSyxHQUFHckMsU0FBUyxDQUFDcUMsS0FBdEI7QUFFQWYsSUFBQUEsT0FBTyxDQUFDZ0IsU0FBUixHQUFvQixRQUFwQjtBQUNBaEIsSUFBQUEsT0FBTyxDQUFDaUIsWUFBUixHQUF1QixZQUF2QjtBQUNBakIsSUFBQUEsT0FBTyxDQUFDa0IsU0FBUixDQUFrQixDQUFsQixFQUFxQixDQUFyQixFQUF3QmYsS0FBeEIsRUFBK0JPLE1BQS9CLEVBWmMsQ0FhZDs7QUFDQVYsSUFBQUEsT0FBTyxDQUFDbUIsU0FBUixhQUE0QkosS0FBSyxDQUFDSyxDQUFsQyxVQUF3Q0wsS0FBSyxDQUFDTSxDQUE5QyxVQUFvRE4sS0FBSyxDQUFDTyxDQUExRCxVQUFnRWhELGVBQWhFO0FBQ0EwQixJQUFBQSxPQUFPLENBQUN1QixRQUFSLENBQWlCLENBQWpCLEVBQW9CLENBQXBCLEVBQXVCcEIsS0FBdkIsRUFBOEJPLE1BQTlCO0FBQ0FWLElBQUFBLE9BQU8sQ0FBQ0MsSUFBUixHQUFldkIsU0FBUyxDQUFDd0IsUUFBekIsQ0FoQmMsQ0FrQmQ7O0FBQ0FGLElBQUFBLE9BQU8sQ0FBQ3dCLFFBQVIsR0FBbUIsT0FBbkI7QUFDQXhCLElBQUFBLE9BQU8sQ0FBQ21CLFNBQVIsYUFBNEJKLEtBQUssQ0FBQ0ssQ0FBbEMsVUFBd0NMLEtBQUssQ0FBQ00sQ0FBOUMsVUFBb0ROLEtBQUssQ0FBQ08sQ0FBMUQ7O0FBQ0EsUUFBSTVDLFNBQVMsQ0FBQytDLFVBQVYsSUFBd0IvQyxTQUFTLENBQUM0QixNQUFWLEdBQW1CLENBQS9DLEVBQWtEO0FBQzlDLFVBQUlvQixXQUFXLEdBQUdoRCxTQUFTLENBQUNpRCxHQUFWLElBQWlCekQsS0FBbkM7QUFDQThCLE1BQUFBLE9BQU8sQ0FBQzRCLFdBQVIsYUFBOEJGLFdBQVcsQ0FBQ04sQ0FBMUMsVUFBZ0RNLFdBQVcsQ0FBQ0wsQ0FBNUQsVUFBa0VLLFdBQVcsQ0FBQ0osQ0FBOUUsVUFBb0ZJLFdBQVcsQ0FBQ0csQ0FBWixHQUFnQixHQUFwRztBQUNBN0IsTUFBQUEsT0FBTyxDQUFDOEIsU0FBUixHQUFvQnBELFNBQVMsQ0FBQzRCLE1BQVYsR0FBbUIsQ0FBdkM7QUFDQU4sTUFBQUEsT0FBTyxDQUFDK0IsVUFBUixDQUFtQixLQUFLbEQsS0FBeEIsRUFBK0IrQixNQUEvQixFQUF1Q0MsTUFBdkM7QUFDSDs7QUFDRGIsSUFBQUEsT0FBTyxDQUFDZ0MsUUFBUixDQUFpQixLQUFLbkQsS0FBdEIsRUFBNkIrQixNQUE3QixFQUFxQ0MsTUFBckM7O0FBRUEsU0FBS2xDLFFBQUwsQ0FBY3NELG1CQUFkO0FBQ0gsR0EzRHFCO0FBNkR0QkMsRUFBQUEsT0E3RHNCLHFCQTZEWDtBQUNQLFNBQUt2RCxRQUFMLENBQWN1RCxPQUFkOztBQUNBLFNBQUt2RCxRQUFMLEdBQWdCLElBQWhCOztBQUNBeEIsSUFBQUEsS0FBSyxDQUFDMEMsV0FBTixDQUFrQnNDLEdBQWxCLENBQXNCLEtBQUtwRCxLQUEzQjtBQUNIO0FBakVxQixDQUExQjs7QUFvRUEsU0FBU3FELFdBQVQsQ0FBc0JqQyxLQUF0QixFQUE2Qk8sTUFBN0IsRUFBcUM7QUFDakMsTUFBSTJCLE9BQU8sR0FBRyxJQUFJN0UsYUFBSixFQUFkO0FBQ0E2RSxFQUFBQSxPQUFPLENBQUNDLFlBQVIsQ0FBcUJuQyxLQUFyQixFQUE0Qk8sTUFBNUI7QUFDQTJCLEVBQUFBLE9BQU8sQ0FBQ0UsTUFBUjtBQUVBLE9BQUtDLGtCQUFMLEdBQTBCLElBQUl2RSxTQUFKLENBQWNvRSxPQUFkLENBQTFCO0FBRUEsT0FBS0ksRUFBTCxHQUFVckUsS0FBVjtBQUNBLE9BQUtzRSxFQUFMLEdBQVV0RSxLQUFWO0FBQ0EsT0FBS3VFLE1BQUwsR0FBY3ZFLEtBQWQ7QUFFQSxPQUFLYyxNQUFMLEdBQWNpQixLQUFkO0FBQ0EsT0FBS2hCLE9BQUwsR0FBZXVCLE1BQWY7QUFFQWhELEVBQUFBLEVBQUUsQ0FBQ2tGLFFBQUgsQ0FBWUMsRUFBWixDQUFlbkYsRUFBRSxDQUFDb0YsUUFBSCxDQUFZQyx5QkFBM0IsRUFBc0QsS0FBS0MsZUFBM0QsRUFBNEUsSUFBNUU7QUFDSDs7QUFFRHRGLEVBQUUsQ0FBQ0MsRUFBSCxDQUFNc0YsS0FBTixDQUFZYixXQUFXLENBQUM3QyxTQUF4QixFQUFtQztBQUMvQjJELEVBQUFBLG1CQUQrQiwrQkFDVkMsYUFEVSxFQUNLO0FBQ2hDLFFBQUlkLE9BQU8sR0FBR2MsYUFBYSxDQUFDeEUsUUFBNUI7QUFDQSxRQUFJd0IsS0FBSyxHQUFHa0MsT0FBTyxDQUFDbEMsS0FBcEI7QUFBQSxRQUEyQk8sTUFBTSxHQUFHMkIsT0FBTyxDQUFDM0IsTUFBNUM7O0FBRUEsUUFBSyxLQUFLK0IsRUFBTCxHQUFVdEMsS0FBVixHQUFrQi9CLEtBQW5CLEdBQTRCLEtBQUtjLE1BQXJDLEVBQTZDO0FBQ3pDLFdBQUt1RCxFQUFMLEdBQVVyRSxLQUFWO0FBQ0EsV0FBS3NFLEVBQUwsR0FBVSxLQUFLQyxNQUFmO0FBQ0g7O0FBRUQsUUFBSyxLQUFLRCxFQUFMLEdBQVVoQyxNQUFYLEdBQXFCLEtBQUtpQyxNQUE5QixFQUFzQztBQUNsQyxXQUFLQSxNQUFMLEdBQWMsS0FBS0QsRUFBTCxHQUFVaEMsTUFBVixHQUFtQnRDLEtBQWpDO0FBQ0g7O0FBRUQsUUFBSSxLQUFLdUUsTUFBTCxHQUFjLEtBQUt4RCxPQUF2QixFQUFnQztBQUM1QixhQUFPLElBQVA7QUFDSDs7QUFFRCxTQUFLcUQsa0JBQUwsQ0FBd0I3RCxRQUF4QixDQUFpQ3lFLGFBQWpDLENBQStDZixPQUEvQyxFQUF3RCxLQUFLSSxFQUE3RCxFQUFpRSxLQUFLQyxFQUF0RTs7QUFFQSxTQUFLVyxNQUFMLEdBQWMsSUFBZDtBQUVBLFFBQUlDLE1BQU0sR0FBRyxJQUFJdkYsb0JBQUosRUFBYjtBQUNBdUYsSUFBQUEsTUFBTSxDQUFDQyxDQUFQLEdBQVcsS0FBS2QsRUFBTCxHQUFVcEUsS0FBSyxHQUFDLENBQTNCO0FBQ0FpRixJQUFBQSxNQUFNLENBQUNFLENBQVAsR0FBVyxLQUFLZCxFQUFMLEdBQVVyRSxLQUFLLEdBQUMsQ0FBM0I7QUFDQWlGLElBQUFBLE1BQU0sQ0FBQ2pCLE9BQVAsR0FBaUIsS0FBS0csa0JBQUwsQ0FBd0I3RCxRQUF6QztBQUNBMkUsSUFBQUEsTUFBTSxDQUFDRyxLQUFQLEdBQWUsSUFBZjtBQUNBSCxJQUFBQSxNQUFNLENBQUNJLENBQVAsR0FBV1AsYUFBYSxDQUFDakUsTUFBZCxHQUF1QmIsS0FBbEM7QUFDQWlGLElBQUFBLE1BQU0sQ0FBQ0ssQ0FBUCxHQUFXUixhQUFhLENBQUNoRSxPQUFkLEdBQXdCZCxLQUFuQztBQUNBaUYsSUFBQUEsTUFBTSxDQUFDTSxRQUFQLEdBQWtCTixNQUFNLENBQUNJLENBQXpCO0FBQ0FKLElBQUFBLE1BQU0sQ0FBQ08sT0FBUCxHQUFpQlYsYUFBYSxDQUFDL0QsUUFBL0I7QUFFQSxTQUFLcUQsRUFBTCxJQUFXdEMsS0FBSyxHQUFHL0IsS0FBbkI7O0FBRUEsU0FBS29FLGtCQUFMLENBQXdCc0Isb0JBQXhCLENBQTZDWCxhQUFhLENBQUNyRSxLQUEzRCxFQUFrRXdFLE1BQWxFOztBQUVBLFdBQU9BLE1BQVA7QUFDSCxHQXJDOEI7QUF1Qy9CZixFQUFBQSxNQXZDK0Isb0JBdUNyQjtBQUNOLFFBQUksQ0FBQyxLQUFLYyxNQUFWLEVBQWtCOztBQUNsQixTQUFLYixrQkFBTCxDQUF3QjdELFFBQXhCLENBQWlDNEQsTUFBakM7O0FBQ0EsU0FBS2MsTUFBTCxHQUFjLEtBQWQ7QUFDSCxHQTNDOEI7QUE2Qy9CVSxFQUFBQSxLQTdDK0IsbUJBNkN0QjtBQUNMLFNBQUt0QixFQUFMLEdBQVVyRSxLQUFWO0FBQ0EsU0FBS3NFLEVBQUwsR0FBVXRFLEtBQVY7QUFDQSxTQUFLdUUsTUFBTCxHQUFjdkUsS0FBZDtBQUVBLFFBQUk0RixLQUFLLEdBQUcsS0FBS3hCLGtCQUFMLENBQXdCeUIsa0JBQXBDOztBQUNBLFNBQUssSUFBSUMsQ0FBQyxHQUFHLENBQVIsRUFBV0MsQ0FBQyxHQUFHSCxLQUFLLENBQUNJLE1BQTFCLEVBQWtDRixDQUFDLEdBQUdDLENBQXRDLEVBQXlDRCxDQUFDLEVBQTFDLEVBQThDO0FBQzFDLFVBQUl6RixNQUFJLEdBQUd1RixLQUFLLENBQUNFLENBQUQsQ0FBaEI7O0FBQ0EsVUFBSSxDQUFDekYsTUFBSSxDQUFDNEYsT0FBVixFQUFtQjtBQUNmO0FBQ0g7O0FBQ0Q1RixNQUFBQSxNQUFJLENBQUN5RCxPQUFMO0FBQ0g7O0FBRUQsU0FBS00sa0JBQUwsQ0FBd0I4QixLQUF4QjtBQUNILEdBNUQ4QjtBQThEL0JwQyxFQUFBQSxPQTlEK0IscUJBOERwQjtBQUNQLFNBQUs2QixLQUFMOztBQUNBLFNBQUt2QixrQkFBTCxDQUF3QjdELFFBQXhCLENBQWlDdUQsT0FBakM7O0FBQ0EsU0FBS00sa0JBQUwsQ0FBd0I3RCxRQUF4QixHQUFtQyxJQUFuQztBQUNILEdBbEU4QjtBQW9FL0JxRSxFQUFBQSxlQXBFK0IsNkJBb0VaO0FBQ2YsU0FBS3VCLGFBQUw7QUFDSCxHQXRFOEI7QUF3RS9CQSxFQUFBQSxhQXhFK0IsMkJBd0VkO0FBQ2IsU0FBS3JDLE9BQUw7QUFFQSxRQUFJRyxPQUFPLEdBQUcsSUFBSTdFLGFBQUosRUFBZDtBQUNBNkUsSUFBQUEsT0FBTyxDQUFDQyxZQUFSLENBQXFCLEtBQUtwRCxNQUExQixFQUFrQyxLQUFLQyxPQUF2QztBQUNBa0QsSUFBQUEsT0FBTyxDQUFDRSxNQUFSO0FBRUEsU0FBS0Msa0JBQUwsQ0FBd0I3RCxRQUF4QixHQUFtQzBELE9BQW5DO0FBQ0gsR0FoRjhCO0FBa0YvQm1DLEVBQUFBLFNBbEYrQixxQkFrRnBCQyxHQWxGb0IsRUFrRmY7QUFDWixXQUFPLEtBQUtqQyxrQkFBTCxDQUF3QnlCLGtCQUF4QixDQUEyQ1EsR0FBM0MsQ0FBUDtBQUNILEdBcEY4QjtBQXNGL0JDLEVBQUFBLFVBdEYrQix3QkFzRmpCO0FBQ1YsV0FBTyxLQUFLbEMsa0JBQUwsQ0FBd0JrQyxVQUF4QixFQUFQO0FBQ0gsR0F4RjhCO0FBMEYvQkMsRUFBQUEsMEJBQTBCLEVBQUUsb0NBQVNsRyxNQUFULEVBQWVDLFNBQWYsRUFBMEI7QUFDbEQsUUFBSVksSUFBSSxHQUFHYixNQUFJLENBQUNZLFVBQUwsQ0FBZ0IsQ0FBaEIsSUFBcUJYLFNBQVMsQ0FBQ1ksSUFBMUM7QUFDQSxRQUFJZ0UsTUFBTSxHQUFHLEtBQUtkLGtCQUFMLENBQXdCeUIsa0JBQXhCLENBQTJDM0UsSUFBM0MsQ0FBYjs7QUFDQSxRQUFJLENBQUNnRSxNQUFMLEVBQWE7QUFDVCxVQUFJc0IsSUFBSSxHQUFHLElBQUlwRyxhQUFKLENBQWtCQyxNQUFsQixFQUF3QkMsU0FBeEIsQ0FBWDtBQUNBa0csTUFBQUEsSUFBSSxDQUFDbkYsZ0JBQUw7QUFDQTZELE1BQUFBLE1BQU0sR0FBRyxLQUFLSixtQkFBTCxDQUF5QjBCLElBQXpCLENBQVQ7QUFDQUEsTUFBQUEsSUFBSSxDQUFDMUMsT0FBTDtBQUNIOztBQUVELFdBQU9vQixNQUFQO0FBQ0g7QUFyRzhCLENBQW5DOztBQXdHQSxTQUFTdUIsV0FBVCxDQUFzQm5HLFNBQXRCLEVBQWlDO0FBQzdCLE1BQUlvRyxRQUFRLEdBQUcsRUFBZjtBQUNBLE1BQUkvRCxLQUFLLEdBQUdyQyxTQUFTLENBQUNxQyxLQUFWLENBQWdCZ0UsS0FBaEIsQ0FBc0IsU0FBdEIsQ0FBWjtBQUNBLE1BQUlwRCxHQUFHLEdBQUcsRUFBVjs7QUFDQSxNQUFJakQsU0FBUyxDQUFDK0MsVUFBVixJQUF3Qi9DLFNBQVMsQ0FBQzRCLE1BQVYsR0FBbUIsQ0FBL0MsRUFBa0Q7QUFDOUNxQixJQUFBQSxHQUFHLEdBQUdBLEdBQUcsR0FBR2pELFNBQVMsQ0FBQzRCLE1BQWhCLEdBQXlCNUIsU0FBUyxDQUFDaUQsR0FBVixDQUFjb0QsS0FBZCxDQUFvQixTQUFwQixDQUEvQjtBQUNIOztBQUFBO0FBRUQsU0FBT0QsUUFBUSxHQUFHcEcsU0FBUyxDQUFDK0IsUUFBckIsR0FBZ0MvQixTQUFTLENBQUNzRyxVQUExQyxHQUF1RGpFLEtBQXZELEdBQStEWSxHQUF0RTtBQUNIOztBQUVELElBQUlzRCxXQUFXLEdBQUcsSUFBbEI7QUFFQSxJQUFJQyxXQUFXLEdBQUcsSUFBbEI7QUFDQSxJQUFJQyxZQUFZLEdBQUcsSUFBbkI7QUFDQSxJQUFJQyxPQUFPLEdBQUcsS0FBZDs7SUFFcUJDOzs7Ozs7Ozs7OztTQUNqQkMsb0JBQUEsNkJBQXFCO0FBQ2pCLFFBQUksQ0FBQ0wsV0FBTCxFQUFrQjtBQUNkQSxNQUFBQSxXQUFXLEdBQUcsSUFBSTdDLFdBQUosQ0FBZ0I4QyxXQUFoQixFQUE2QkMsWUFBN0IsQ0FBZDtBQUNBekgsTUFBQUEsRUFBRSxDQUFDUCxLQUFILENBQVM4SCxXQUFULEdBQXVCQSxXQUF2QjtBQUNIOztBQUVELFdBQU9BLFdBQVcsQ0FBQ1AsVUFBWixFQUFQO0FBQ0g7O1NBRURhLG9CQUFBLDJCQUFtQkMsSUFBbkIsRUFBeUI7QUFDckIxSCxJQUFBQSxjQUFjLENBQUMySCxTQUFmLEdBQTJCUixXQUEzQjtBQUNBbkgsSUFBQUEsY0FBYyxDQUFDa0gsVUFBZixHQUE0Qm5ILGFBQWEsQ0FBQzJILElBQUQsQ0FBekMsQ0FGcUIsQ0FJckI7O0FBQ0EsUUFBSUUsT0FBTyxHQUFHakksaUJBQWlCLElBQUkrSCxJQUFJLENBQUNHLFlBQUwsQ0FBa0J0SSxZQUFsQixDQUFuQzs7QUFDQSxRQUFJcUksT0FBTyxJQUFJQSxPQUFPLENBQUNFLE9BQXZCLEVBQWdDO0FBQzVCOUgsTUFBQUEsY0FBYyxDQUFDMkQsVUFBZixHQUE0QixJQUE1QjtBQUNBM0QsTUFBQUEsY0FBYyxDQUFDd0MsTUFBZixHQUF3Qm9GLE9BQU8sQ0FBQ3ZGLEtBQWhDO0FBQ0FyQyxNQUFBQSxjQUFjLENBQUM2RCxHQUFmLEdBQXFCK0QsT0FBTyxDQUFDM0UsS0FBUixDQUFjOEUsS0FBZCxFQUFyQjtBQUNBL0gsTUFBQUEsY0FBYyxDQUFDNkQsR0FBZixDQUFtQkUsQ0FBbkIsR0FBdUI2RCxPQUFPLENBQUMzRSxLQUFSLENBQWNjLENBQWQsR0FBa0IyRCxJQUFJLENBQUNNLElBQUwsQ0FBVS9FLEtBQVYsQ0FBZ0JjLENBQWxDLEdBQXNDLEtBQTdEO0FBQ0gsS0FMRCxNQU1LO0FBQ0QvRCxNQUFBQSxjQUFjLENBQUMyRCxVQUFmLEdBQTRCLEtBQTVCO0FBQ0EzRCxNQUFBQSxjQUFjLENBQUN3QyxNQUFmLEdBQXdCLENBQXhCO0FBQ0g7QUFDSjs7U0FFRHlGLG1CQUFBLDBCQUFrQlAsSUFBbEIsRUFBd0I7QUFDcEIxSCxJQUFBQSxjQUFjLENBQUNvQyxRQUFmLEdBQTBCLEtBQUs4RixZQUFMLEVBQTFCO0FBQ0FsSSxJQUFBQSxjQUFjLENBQUNpRCxLQUFmLEdBQXVCeUUsSUFBSSxDQUFDTSxJQUFMLENBQVUvRSxLQUFqQztBQUNBakQsSUFBQUEsY0FBYyxDQUFDd0IsSUFBZixHQUFzQnVGLFdBQVcsQ0FBQy9HLGNBQUQsQ0FBakM7QUFDSDs7U0FFRGtJLGVBQUEsd0JBQWdCO0FBQ1osUUFBSTlGLFFBQVEsR0FBR3BDLGNBQWMsQ0FBQzJDLFFBQWYsQ0FBd0J3RixRQUF4QixLQUFxQyxLQUFwRDtBQUNBL0YsSUFBQUEsUUFBUSxHQUFHQSxRQUFRLEdBQUdwQyxjQUFjLENBQUNrSCxVQUFyQzs7QUFDQSxRQUFJSSxPQUFKLEVBQWE7QUFDVGxGLE1BQUFBLFFBQVEsR0FBRyxVQUFVQSxRQUFyQjtBQUNIOztBQUVELFdBQU9BLFFBQVA7QUFDSDs7U0FDRGdHLG1DQUFBLDRDQUFvQyxDQUFFOztTQUN0Q0MsaUJBQUEsd0JBQWdCQyxRQUFoQixFQUEwQjtBQUN0QixXQUFPLEtBQVA7QUFDSDs7O0VBOUM0Q0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKlxuIENvcHlyaWdodCAoYykgMjAxOCBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC5cblxuIGh0dHBzOi8vd3d3LmNvY29zLmNvbS9cblxuIFBlcm1pc3Npb24gaXMgaGVyZWJ5IGdyYW50ZWQsIGZyZWUgb2YgY2hhcmdlLCB0byBhbnkgcGVyc29uIG9idGFpbmluZyBhIGNvcHlcbiBvZiB0aGlzIHNvZnR3YXJlIGFuZCBhc3NvY2lhdGVkIGVuZ2luZSBzb3VyY2UgY29kZSAodGhlIFwiU29mdHdhcmVcIiksIGEgbGltaXRlZCxcbiB3b3JsZHdpZGUsIHJveWFsdHktZnJlZSwgbm9uLWFzc2lnbmFibGUsIHJldm9jYWJsZSBhbmQgbm9uLWV4Y2x1c2l2ZSBsaWNlbnNlXG4gdG8gdXNlIENvY29zIENyZWF0b3Igc29sZWx5IHRvIGRldmVsb3AgZ2FtZXMgb24geW91ciB0YXJnZXQgcGxhdGZvcm1zLiBZb3Ugc2hhbGxcbiBub3QgdXNlIENvY29zIENyZWF0b3Igc29mdHdhcmUgZm9yIGRldmVsb3Bpbmcgb3RoZXIgc29mdHdhcmUgb3IgdG9vbHMgdGhhdCdzXG4gdXNlZCBmb3IgZGV2ZWxvcGluZyBnYW1lcy4gWW91IGFyZSBub3QgZ3JhbnRlZCB0byBwdWJsaXNoLCBkaXN0cmlidXRlLFxuIHN1YmxpY2Vuc2UsIGFuZC9vciBzZWxsIGNvcGllcyBvZiBDb2NvcyBDcmVhdG9yLlxuXG4gVGhlIHNvZnR3YXJlIG9yIHRvb2xzIGluIHRoaXMgTGljZW5zZSBBZ3JlZW1lbnQgYXJlIGxpY2Vuc2VkLCBub3Qgc29sZC5cbiBYaWFtZW4gWWFqaSBTb2Z0d2FyZSBDby4sIEx0ZC4gcmVzZXJ2ZXMgYWxsIHJpZ2h0cyBub3QgZXhwcmVzc2x5IGdyYW50ZWQgdG8geW91LlxuXG4gVEhFIFNPRlRXQVJFIElTIFBST1ZJREVEIFwiQVMgSVNcIiwgV0lUSE9VVCBXQVJSQU5UWSBPRiBBTlkgS0lORCwgRVhQUkVTUyBPUlxuIElNUExJRUQsIElOQ0xVRElORyBCVVQgTk9UIExJTUlURUQgVE8gVEhFIFdBUlJBTlRJRVMgT0YgTUVSQ0hBTlRBQklMSVRZLFxuIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFORCBOT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRVxuIEFVVEhPUlMgT1IgQ09QWVJJR0hUIEhPTERFUlMgQkUgTElBQkxFIEZPUiBBTlkgQ0xBSU0sIERBTUFHRVMgT1IgT1RIRVJcbiBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQU4gQUNUSU9OIE9GIENPTlRSQUNULCBUT1JUIE9SIE9USEVSV0lTRSwgQVJJU0lORyBGUk9NLFxuIE9VVCBPRiBPUiBJTiBDT05ORUNUSU9OIFdJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU5cbiBUSEUgU09GVFdBUkUuXG4gKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKi9cblxuaW1wb3J0IFdlYmdsQm1mb250QXNzZW1ibGVyIGZyb20gJy4uLy4uL3dlYmdsL2Fzc2VtYmxlcnMvbGFiZWwvMmQvYm1mb250JztcblxuY29uc3QgTGFiZWwgPSByZXF1aXJlKCcuLi8uLi8uLi9jb21wb25lbnRzL0NDTGFiZWwnKTtcbmNvbnN0IExhYmVsT3V0bGluZSA9IHJlcXVpcmUoJy4uLy4uLy4uL2NvbXBvbmVudHMvQ0NMYWJlbE91dGxpbmUnKTtcbmNvbnN0IHRleHRVdGlscyA9IHJlcXVpcmUoJy4uLy4uLy4uL3V0aWxzL3RleHQtdXRpbHMnKTtcbmNvbnN0IENvbXBvbmVudCA9IHJlcXVpcmUoJy4uLy4uLy4uL2NvbXBvbmVudHMvQ0NDb21wb25lbnQnKTtcbmNvbnN0IFJlbmRlclRleHR1cmUgPSByZXF1aXJlKCcuLi8uLi8uLi9hc3NldHMvQ0NSZW5kZXJUZXh0dXJlJyk7XG5jb25zdCBPVVRMSU5FX1NVUFBPUlRFRCA9IGNjLmpzLmlzQ2hpbGRDbGFzc09mKExhYmVsT3V0bGluZSwgQ29tcG9uZW50KTtcbmNvbnN0IGdldEZvbnRGYW1pbHkgPSByZXF1aXJlKCcuLi91dGlscycpLmdldEZvbnRGYW1pbHk7XG5jb25zdCBzaGFyZUxhYmVsSW5mbyA9IHJlcXVpcmUoJy4uL3V0aWxzJykuc2hhcmVMYWJlbEluZm87XG5cblxuY29uc3QgRm9udExldHRlckRlZmluaXRpb24gPSBjYy5CaXRtYXBGb250LkZvbnRMZXR0ZXJEZWZpbml0aW9uO1xuY29uc3QgRm9udEF0bGFzID0gY2MuQml0bWFwRm9udC5Gb250QXRsYXM7XG5cbmNvbnN0IFdISVRFID0gY2MuQ29sb3IuV0hJVEU7XG5jb25zdCBzcGFjZSA9IDA7XG5jb25zdCBibGVlZCA9IDI7XG5jb25zdCBfaW52aXNpYmxlQWxwaGEgPSAoMSAvIDI1NSkudG9GaXhlZCgzKTtcblxuZnVuY3Rpb24gTGV0dGVyVGV4dHVyZShjaGFyLCBsYWJlbEluZm8pIHtcbiAgICB0aGlzLl90ZXh0dXJlID0gbnVsbDtcbiAgICB0aGlzLl9sYWJlbEluZm8gPSBsYWJlbEluZm87XG4gICAgdGhpcy5fY2hhciA9IGNoYXI7XG4gICAgdGhpcy5faGFzaCA9IG51bGw7XG4gICAgdGhpcy5fZGF0YSA9IG51bGw7XG4gICAgdGhpcy5fY2FudmFzID0gbnVsbDtcbiAgICB0aGlzLl9jb250ZXh0ID0gbnVsbDtcbiAgICB0aGlzLl93aWR0aCA9IDA7XG4gICAgdGhpcy5faGVpZ2h0ID0gMDtcbiAgICB0aGlzLl9vZmZzZXRZID0gMDtcbiAgICB0aGlzLl9oYXNoID0gY2hhci5jaGFyQ29kZUF0KDApICsgbGFiZWxJbmZvLmhhc2g7XG59XG5cbkxldHRlclRleHR1cmUucHJvdG90eXBlID0ge1xuICAgIGNvbnN0cnVjdG9yOiBMZXR0ZXJUZXh0dXJlLFxuXG4gICAgdXBkYXRlUmVuZGVyRGF0YSAoKSB7XG4gICAgICAgIHRoaXMuX3VwZGF0ZVByb3BlcnRpZXMoKTtcbiAgICAgICAgdGhpcy5fdXBkYXRlVGV4dHVyZSgpO1xuICAgIH0sXG4gICAgX3VwZGF0ZVByb3BlcnRpZXMgKCkge1xuICAgICAgICB0aGlzLl90ZXh0dXJlID0gbmV3IGNjLlRleHR1cmUyRCgpO1xuICAgICAgICB0aGlzLl9kYXRhID0gTGFiZWwuX2NhbnZhc1Bvb2wuZ2V0KCk7XG4gICAgICAgIHRoaXMuX2NhbnZhcyA9IHRoaXMuX2RhdGEuY2FudmFzO1xuICAgICAgICB0aGlzLl9jb250ZXh0ID0gdGhpcy5fZGF0YS5jb250ZXh0O1xuICAgICAgICB0aGlzLl9jb250ZXh0LmZvbnQgPSB0aGlzLl9sYWJlbEluZm8uZm9udERlc2M7XG4gICAgICAgIGxldCB3aWR0aCA9IHRleHRVdGlscy5zYWZlTWVhc3VyZVRleHQodGhpcy5fY29udGV4dCwgdGhpcy5fY2hhciwgdGhpcy5fbGFiZWxJbmZvLmZvbnREZXNjKTtcbiAgICAgICAgbGV0IGJsYW5rID0gdGhpcy5fbGFiZWxJbmZvLm1hcmdpbiAqIDIgKyBibGVlZDtcbiAgICAgICAgdGhpcy5fd2lkdGggPSBwYXJzZUZsb2F0KHdpZHRoLnRvRml4ZWQoMikpICsgYmxhbms7XG4gICAgICAgIHRoaXMuX2hlaWdodCA9ICgxICsgdGV4dFV0aWxzLkJBU0VMSU5FX1JBVElPKSAqIHRoaXMuX2xhYmVsSW5mby5mb250U2l6ZSArIGJsYW5rO1xuICAgICAgICB0aGlzLl9vZmZzZXRZID0gLSAodGhpcy5fbGFiZWxJbmZvLmZvbnRTaXplICogdGV4dFV0aWxzLkJBU0VMSU5FX1JBVElPKSAvIDI7XG5cbiAgICAgICAgaWYgKHRoaXMuX2NhbnZhcy53aWR0aCAhPT0gdGhpcy5fd2lkdGgpIHtcbiAgICAgICAgICAgIHRoaXMuX2NhbnZhcy53aWR0aCA9IHRoaXMuX3dpZHRoO1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKHRoaXMuX2NhbnZhcy5oZWlnaHQgIT09IHRoaXMuX2hlaWdodCkge1xuICAgICAgICAgICAgdGhpcy5fY2FudmFzLmhlaWdodCA9IHRoaXMuX2hlaWdodDtcbiAgICAgICAgfVxuXG4gICAgICAgIHRoaXMuX3RleHR1cmUuaW5pdFdpdGhFbGVtZW50KHRoaXMuX2NhbnZhcyk7XG4gICAgfSxcbiAgICBfdXBkYXRlVGV4dHVyZSAoKSB7XG4gICAgICAgIGxldCBjb250ZXh0ID0gdGhpcy5fY29udGV4dDtcbiAgICAgICAgbGV0IGxhYmVsSW5mbyA9IHRoaXMuX2xhYmVsSW5mbyxcbiAgICAgICAgICAgIHdpZHRoID0gdGhpcy5fY2FudmFzLndpZHRoLFxuICAgICAgICAgICAgaGVpZ2h0ID0gdGhpcy5fY2FudmFzLmhlaWdodDtcblxuICAgICAgICBsZXQgc3RhcnRYID0gd2lkdGggLyAyO1xuICAgICAgICBsZXQgc3RhcnRZID0gaGVpZ2h0IC8gMiArIHRoaXMuX2xhYmVsSW5mby5mb250U2l6ZSAqIHRleHRVdGlscy5NSURETEVfUkFUSU87XG4gICAgICAgIGxldCBjb2xvciA9IGxhYmVsSW5mby5jb2xvcjtcblxuICAgICAgICBjb250ZXh0LnRleHRBbGlnbiA9ICdjZW50ZXInO1xuICAgICAgICBjb250ZXh0LnRleHRCYXNlbGluZSA9ICdhbHBoYWJldGljJztcbiAgICAgICAgY29udGV4dC5jbGVhclJlY3QoMCwgMCwgd2lkdGgsIGhlaWdodCk7XG4gICAgICAgIC8vQWRkIGEgd2hpdGUgYmFja2dyb3VuZCB0byBhdm9pZCBibGFjayBlZGdlcy5cbiAgICAgICAgY29udGV4dC5maWxsU3R5bGUgPSBgcmdiYSgke2NvbG9yLnJ9LCAke2NvbG9yLmd9LCAke2NvbG9yLmJ9LCAke19pbnZpc2libGVBbHBoYX0pYDtcbiAgICAgICAgY29udGV4dC5maWxsUmVjdCgwLCAwLCB3aWR0aCwgaGVpZ2h0KTtcbiAgICAgICAgY29udGV4dC5mb250ID0gbGFiZWxJbmZvLmZvbnREZXNjO1xuXG4gICAgICAgIC8vdXNlIHJvdW5kIGZvciBsaW5lIGpvaW4gdG8gYXZvaWQgc2hhcnAgaW50ZXJzZWN0IHBvaW50XG4gICAgICAgIGNvbnRleHQubGluZUpvaW4gPSAncm91bmQnO1xuICAgICAgICBjb250ZXh0LmZpbGxTdHlsZSA9IGByZ2JhKCR7Y29sb3Iucn0sICR7Y29sb3IuZ30sICR7Y29sb3IuYn0sIDEpYDtcbiAgICAgICAgaWYgKGxhYmVsSW5mby5pc091dGxpbmVkICYmIGxhYmVsSW5mby5tYXJnaW4gPiAwKSB7XG4gICAgICAgICAgICBsZXQgc3Ryb2tlQ29sb3IgPSBsYWJlbEluZm8ub3V0IHx8IFdISVRFO1xuICAgICAgICAgICAgY29udGV4dC5zdHJva2VTdHlsZSA9IGByZ2JhKCR7c3Ryb2tlQ29sb3Iucn0sICR7c3Ryb2tlQ29sb3IuZ30sICR7c3Ryb2tlQ29sb3IuYn0sICR7c3Ryb2tlQ29sb3IuYSAvIDI1NX0pYDtcbiAgICAgICAgICAgIGNvbnRleHQubGluZVdpZHRoID0gbGFiZWxJbmZvLm1hcmdpbiAqIDI7XG4gICAgICAgICAgICBjb250ZXh0LnN0cm9rZVRleHQodGhpcy5fY2hhciwgc3RhcnRYLCBzdGFydFkpO1xuICAgICAgICB9XG4gICAgICAgIGNvbnRleHQuZmlsbFRleHQodGhpcy5fY2hhciwgc3RhcnRYLCBzdGFydFkpO1xuXG4gICAgICAgIHRoaXMuX3RleHR1cmUuaGFuZGxlTG9hZGVkVGV4dHVyZSgpO1xuICAgIH0sXG5cbiAgICBkZXN0cm95ICgpIHtcbiAgICAgICAgdGhpcy5fdGV4dHVyZS5kZXN0cm95KCk7XG4gICAgICAgIHRoaXMuX3RleHR1cmUgPSBudWxsO1xuICAgICAgICBMYWJlbC5fY2FudmFzUG9vbC5wdXQodGhpcy5fZGF0YSk7XG4gICAgfSxcbn1cblxuZnVuY3Rpb24gTGV0dGVyQXRsYXMgKHdpZHRoLCBoZWlnaHQpIHtcbiAgICBsZXQgdGV4dHVyZSA9IG5ldyBSZW5kZXJUZXh0dXJlKCk7XG4gICAgdGV4dHVyZS5pbml0V2l0aFNpemUod2lkdGgsIGhlaWdodCk7XG4gICAgdGV4dHVyZS51cGRhdGUoKTtcblxuICAgIHRoaXMuX2ZvbnREZWZEaWN0aW9uYXJ5ID0gbmV3IEZvbnRBdGxhcyh0ZXh0dXJlKTtcbiAgICBcbiAgICB0aGlzLl94ID0gc3BhY2U7XG4gICAgdGhpcy5feSA9IHNwYWNlO1xuICAgIHRoaXMuX25leHR5ID0gc3BhY2U7XG5cbiAgICB0aGlzLl93aWR0aCA9IHdpZHRoO1xuICAgIHRoaXMuX2hlaWdodCA9IGhlaWdodDtcblxuICAgIGNjLmRpcmVjdG9yLm9uKGNjLkRpcmVjdG9yLkVWRU5UX0JFRk9SRV9TQ0VORV9MQVVOQ0gsIHRoaXMuYmVmb3JlU2NlbmVMb2FkLCB0aGlzKTtcbn1cblxuY2MuanMubWl4aW4oTGV0dGVyQXRsYXMucHJvdG90eXBlLCB7XG4gICAgaW5zZXJ0TGV0dGVyVGV4dHVyZSAobGV0dGVyVGV4dHVyZSkge1xuICAgICAgICBsZXQgdGV4dHVyZSA9IGxldHRlclRleHR1cmUuX3RleHR1cmU7XG4gICAgICAgIGxldCB3aWR0aCA9IHRleHR1cmUud2lkdGgsIGhlaWdodCA9IHRleHR1cmUuaGVpZ2h0OyAgICAgICAgXG5cbiAgICAgICAgaWYgKCh0aGlzLl94ICsgd2lkdGggKyBzcGFjZSkgPiB0aGlzLl93aWR0aCkge1xuICAgICAgICAgICAgdGhpcy5feCA9IHNwYWNlO1xuICAgICAgICAgICAgdGhpcy5feSA9IHRoaXMuX25leHR5O1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKCh0aGlzLl95ICsgaGVpZ2h0KSA+IHRoaXMuX25leHR5KSB7XG4gICAgICAgICAgICB0aGlzLl9uZXh0eSA9IHRoaXMuX3kgKyBoZWlnaHQgKyBzcGFjZTtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmICh0aGlzLl9uZXh0eSA+IHRoaXMuX2hlaWdodCkge1xuICAgICAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgICAgIH1cblxuICAgICAgICB0aGlzLl9mb250RGVmRGljdGlvbmFyeS5fdGV4dHVyZS5kcmF3VGV4dHVyZUF0KHRleHR1cmUsIHRoaXMuX3gsIHRoaXMuX3kpO1xuXG4gICAgICAgIHRoaXMuX2RpcnR5ID0gdHJ1ZTtcbiAgICAgICAgXG4gICAgICAgIGxldCBsZXR0ZXIgPSBuZXcgRm9udExldHRlckRlZmluaXRpb24oKTtcbiAgICAgICAgbGV0dGVyLnUgPSB0aGlzLl94ICsgYmxlZWQvMjtcbiAgICAgICAgbGV0dGVyLnYgPSB0aGlzLl95ICsgYmxlZWQvMjtcbiAgICAgICAgbGV0dGVyLnRleHR1cmUgPSB0aGlzLl9mb250RGVmRGljdGlvbmFyeS5fdGV4dHVyZTtcbiAgICAgICAgbGV0dGVyLnZhbGlkID0gdHJ1ZTtcbiAgICAgICAgbGV0dGVyLncgPSBsZXR0ZXJUZXh0dXJlLl93aWR0aCAtIGJsZWVkO1xuICAgICAgICBsZXR0ZXIuaCA9IGxldHRlclRleHR1cmUuX2hlaWdodCAtIGJsZWVkO1xuICAgICAgICBsZXR0ZXIueEFkdmFuY2UgPSBsZXR0ZXIudztcbiAgICAgICAgbGV0dGVyLm9mZnNldFkgPSBsZXR0ZXJUZXh0dXJlLl9vZmZzZXRZO1xuXG4gICAgICAgIHRoaXMuX3ggKz0gd2lkdGggKyBzcGFjZTtcblxuICAgICAgICB0aGlzLl9mb250RGVmRGljdGlvbmFyeS5hZGRMZXR0ZXJEZWZpbml0aW9ucyhsZXR0ZXJUZXh0dXJlLl9oYXNoLCBsZXR0ZXIpO1xuICAgICAgICBcbiAgICAgICAgcmV0dXJuIGxldHRlclxuICAgIH0sXG5cbiAgICB1cGRhdGUgKCkge1xuICAgICAgICBpZiAoIXRoaXMuX2RpcnR5KSByZXR1cm47XG4gICAgICAgIHRoaXMuX2ZvbnREZWZEaWN0aW9uYXJ5Ll90ZXh0dXJlLnVwZGF0ZSgpO1xuICAgICAgICB0aGlzLl9kaXJ0eSA9IGZhbHNlO1xuICAgIH0sXG5cbiAgICByZXNldCAoKSB7XG4gICAgICAgIHRoaXMuX3ggPSBzcGFjZTtcbiAgICAgICAgdGhpcy5feSA9IHNwYWNlO1xuICAgICAgICB0aGlzLl9uZXh0eSA9IHNwYWNlO1xuXG4gICAgICAgIGxldCBjaGFycyA9IHRoaXMuX2ZvbnREZWZEaWN0aW9uYXJ5Ll9sZXR0ZXJEZWZpbml0aW9ucztcbiAgICAgICAgZm9yIChsZXQgaSA9IDAsIGwgPSBjaGFycy5sZW5ndGg7IGkgPCBsOyBpKyspIHtcbiAgICAgICAgICAgIGxldCBjaGFyID0gY2hhcnNbaV07XG4gICAgICAgICAgICBpZiAoIWNoYXIuaXNWYWxpZCkge1xuICAgICAgICAgICAgICAgIGNvbnRpbnVlO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgY2hhci5kZXN0cm95KCk7XG4gICAgICAgIH1cblxuICAgICAgICB0aGlzLl9mb250RGVmRGljdGlvbmFyeS5jbGVhcigpO1xuICAgIH0sXG5cbiAgICBkZXN0cm95ICgpIHtcbiAgICAgICAgdGhpcy5yZXNldCgpO1xuICAgICAgICB0aGlzLl9mb250RGVmRGljdGlvbmFyeS5fdGV4dHVyZS5kZXN0cm95KCk7XG4gICAgICAgIHRoaXMuX2ZvbnREZWZEaWN0aW9uYXJ5Ll90ZXh0dXJlID0gbnVsbDtcbiAgICB9LFxuXG4gICAgYmVmb3JlU2NlbmVMb2FkICgpIHtcbiAgICAgICAgdGhpcy5jbGVhckFsbENhY2hlKCk7XG4gICAgfSxcblxuICAgIGNsZWFyQWxsQ2FjaGUgKCkge1xuICAgICAgICB0aGlzLmRlc3Ryb3koKTtcblxuICAgICAgICBsZXQgdGV4dHVyZSA9IG5ldyBSZW5kZXJUZXh0dXJlKCk7XG4gICAgICAgIHRleHR1cmUuaW5pdFdpdGhTaXplKHRoaXMuX3dpZHRoLCB0aGlzLl9oZWlnaHQpO1xuICAgICAgICB0ZXh0dXJlLnVwZGF0ZSgpO1xuICAgICAgICBcbiAgICAgICAgdGhpcy5fZm9udERlZkRpY3Rpb25hcnkuX3RleHR1cmUgPSB0ZXh0dXJlO1xuICAgIH0sXG5cbiAgICBnZXRMZXR0ZXIgKGtleSkge1xuICAgICAgICByZXR1cm4gdGhpcy5fZm9udERlZkRpY3Rpb25hcnkuX2xldHRlckRlZmluaXRpb25zW2tleV07XG4gICAgfSxcblxuICAgIGdldFRleHR1cmUgKCkge1xuICAgICAgICByZXR1cm4gdGhpcy5fZm9udERlZkRpY3Rpb25hcnkuZ2V0VGV4dHVyZSgpO1xuICAgIH0sXG5cbiAgICBnZXRMZXR0ZXJEZWZpbml0aW9uRm9yQ2hhcjogZnVuY3Rpb24oY2hhciwgbGFiZWxJbmZvKSB7XG4gICAgICAgIGxldCBoYXNoID0gY2hhci5jaGFyQ29kZUF0KDApICsgbGFiZWxJbmZvLmhhc2g7XG4gICAgICAgIGxldCBsZXR0ZXIgPSB0aGlzLl9mb250RGVmRGljdGlvbmFyeS5fbGV0dGVyRGVmaW5pdGlvbnNbaGFzaF07XG4gICAgICAgIGlmICghbGV0dGVyKSB7XG4gICAgICAgICAgICBsZXQgdGVtcCA9IG5ldyBMZXR0ZXJUZXh0dXJlKGNoYXIsIGxhYmVsSW5mbyk7XG4gICAgICAgICAgICB0ZW1wLnVwZGF0ZVJlbmRlckRhdGEoKTtcbiAgICAgICAgICAgIGxldHRlciA9IHRoaXMuaW5zZXJ0TGV0dGVyVGV4dHVyZSh0ZW1wKTtcbiAgICAgICAgICAgIHRlbXAuZGVzdHJveSgpO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIGxldHRlcjtcbiAgICB9XG59KTtcblxuZnVuY3Rpb24gY29tcHV0ZUhhc2ggKGxhYmVsSW5mbykge1xuICAgIGxldCBoYXNoRGF0YSA9ICcnO1xuICAgIGxldCBjb2xvciA9IGxhYmVsSW5mby5jb2xvci50b0hFWChcIiNycmdnYmJcIik7XG4gICAgbGV0IG91dCA9ICcnO1xuICAgIGlmIChsYWJlbEluZm8uaXNPdXRsaW5lZCAmJiBsYWJlbEluZm8ubWFyZ2luID4gMCkge1xuICAgICAgICBvdXQgPSBvdXQgKyBsYWJlbEluZm8ubWFyZ2luICsgbGFiZWxJbmZvLm91dC50b0hFWChcIiNycmdnYmJcIik7XG4gICAgfTtcbiAgICBcbiAgICByZXR1cm4gaGFzaERhdGEgKyBsYWJlbEluZm8uZm9udFNpemUgKyBsYWJlbEluZm8uZm9udEZhbWlseSArIGNvbG9yICsgb3V0O1xufVxuXG5sZXQgX3NoYXJlQXRsYXMgPSBudWxsO1xuXG5sZXQgX2F0bGFzV2lkdGggPSAyMDQ4O1xubGV0IF9hdGxhc0hlaWdodCA9IDIwNDg7XG5sZXQgX2lzQm9sZCA9IGZhbHNlO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBMZXR0ZXJGb250QXNzZW1ibGVyIGV4dGVuZHMgV2ViZ2xCbWZvbnRBc3NlbWJsZXIge1xuICAgIF9nZXRBc3NlbWJsZXJEYXRhICgpIHtcbiAgICAgICAgaWYgKCFfc2hhcmVBdGxhcykge1xuICAgICAgICAgICAgX3NoYXJlQXRsYXMgPSBuZXcgTGV0dGVyQXRsYXMoX2F0bGFzV2lkdGgsIF9hdGxhc0hlaWdodCk7XG4gICAgICAgICAgICBjYy5MYWJlbC5fc2hhcmVBdGxhcyA9IF9zaGFyZUF0bGFzO1xuICAgICAgICB9XG4gICAgICAgIFxuICAgICAgICByZXR1cm4gX3NoYXJlQXRsYXMuZ2V0VGV4dHVyZSgpO1xuICAgIH1cblxuICAgIF91cGRhdGVGb250RmFtaWx5IChjb21wKSB7XG4gICAgICAgIHNoYXJlTGFiZWxJbmZvLmZvbnRBdGxhcyA9IF9zaGFyZUF0bGFzO1xuICAgICAgICBzaGFyZUxhYmVsSW5mby5mb250RmFtaWx5ID0gZ2V0Rm9udEZhbWlseShjb21wKTtcblxuICAgICAgICAvLyBvdXRsaW5lXG4gICAgICAgIGxldCBvdXRsaW5lID0gT1VUTElORV9TVVBQT1JURUQgJiYgY29tcC5nZXRDb21wb25lbnQoTGFiZWxPdXRsaW5lKTtcbiAgICAgICAgaWYgKG91dGxpbmUgJiYgb3V0bGluZS5lbmFibGVkKSB7XG4gICAgICAgICAgICBzaGFyZUxhYmVsSW5mby5pc091dGxpbmVkID0gdHJ1ZTtcbiAgICAgICAgICAgIHNoYXJlTGFiZWxJbmZvLm1hcmdpbiA9IG91dGxpbmUud2lkdGg7XG4gICAgICAgICAgICBzaGFyZUxhYmVsSW5mby5vdXQgPSBvdXRsaW5lLmNvbG9yLmNsb25lKCk7XG4gICAgICAgICAgICBzaGFyZUxhYmVsSW5mby5vdXQuYSA9IG91dGxpbmUuY29sb3IuYSAqIGNvbXAubm9kZS5jb2xvci5hIC8gMjU1LjA7XG4gICAgICAgIH1cbiAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICBzaGFyZUxhYmVsSW5mby5pc091dGxpbmVkID0gZmFsc2U7XG4gICAgICAgICAgICBzaGFyZUxhYmVsSW5mby5tYXJnaW4gPSAwO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgX3VwZGF0ZUxhYmVsSW5mbyAoY29tcCkge1xuICAgICAgICBzaGFyZUxhYmVsSW5mby5mb250RGVzYyA9IHRoaXMuX2dldEZvbnREZXNjKCk7XG4gICAgICAgIHNoYXJlTGFiZWxJbmZvLmNvbG9yID0gY29tcC5ub2RlLmNvbG9yO1xuICAgICAgICBzaGFyZUxhYmVsSW5mby5oYXNoID0gY29tcHV0ZUhhc2goc2hhcmVMYWJlbEluZm8pO1xuICAgIH1cblxuICAgIF9nZXRGb250RGVzYyAoKSB7XG4gICAgICAgIGxldCBmb250RGVzYyA9IHNoYXJlTGFiZWxJbmZvLmZvbnRTaXplLnRvU3RyaW5nKCkgKyAncHggJztcbiAgICAgICAgZm9udERlc2MgPSBmb250RGVzYyArIHNoYXJlTGFiZWxJbmZvLmZvbnRGYW1pbHk7XG4gICAgICAgIGlmIChfaXNCb2xkKSB7XG4gICAgICAgICAgICBmb250RGVzYyA9IFwiYm9sZCBcIiArIGZvbnREZXNjO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIGZvbnREZXNjO1xuICAgIH1cbiAgICBfY29tcHV0ZUhvcml6b250YWxLZXJuaW5nRm9yVGV4dCAoKSB7fVxuICAgIF9kZXRlcm1pbmVSZWN0ICh0ZW1wUmVjdCkge1xuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxufSJdLCJzb3VyY2VSb290IjoiLyJ9